package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.y41b.model.EnviosPorRemesa;
import com.ejie.y41b.service.EnviosPorRemesaService;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

@Controller
@RequestMapping(value = "/enviosPorRemesa")
public class EnviosPorRemesaController {

	private static final Logger logger = LoggerFactory
			.getLogger(EnviosPorRemesaController.class);

	@Autowired
	private EnviosPorRemesaService enviosPorRemesaService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@RequestMapping(value = "getByEhCodigo/{ehcodigo}", method = RequestMethod.GET)
	public @ResponseBody
	EnviosPorRemesa getById(@PathVariable String ehcodigo) {
		try {
			EnviosPorRemesaController.logger
					.info("[GET - getByEhCodigo] : Obtener EnviosPorRemesa por el cdigo de la notificacin");
			EnviosPorRemesa enviosPorRemesa = new EnviosPorRemesa();
			enviosPorRemesa.setEhcodigo(ehcodigo);
			enviosPorRemesa = this.enviosPorRemesaService
					.findWithoutBlobByEhCodigo(enviosPorRemesa);
			if (enviosPorRemesa == null) {
				EnviosPorRemesaController.logger
						.info("[GET - getByEhCodigo] : No se ha obtenido resultado");
				throw new Y41bUDAException("Null: " + ehcodigo, true,
						new Exception(("Null: " + ehcodigo)));
			}
			return enviosPorRemesa;
		} catch (Exception e) {
			EnviosPorRemesaController.logger.info(
					"[GET - getByEhCodigo] : Ha ocurrido un error", e);
			throw new Y41bUDAException(e.getMessage(), true, new Exception(
					e.getMessage()));
		}
	}

}
