package com.ejie.y41b.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.EnlacesDocumentoService;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41b.model.EnlacesDocumento;

/**
 * EnlacesDocumentoController  
 * 
 *  
 */
@Controller()
@RequestMapping(value = "/enlacesDocumento")
@SessionAttributes({ "enlacesDocumento" })
public class EnlacesDocumentoController {

	private static final Logger logger = LoggerFactory
			.getLogger(EnlacesDocumentoController.class);

	@Autowired
	private EnlacesDocumentoService enlacesDocumentoService;

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint/{zrntabla}/{zrncampo}/{zrvcampo}", method = RequestMethod.GET)
	public ModelAndView getCreateForm(@PathVariable String zrntabla,
			@PathVariable String zrncampo, @PathVariable String zrvcampo,
			Model model) {
		EnlacesDocumento filterEnlacesDocumento = new EnlacesDocumento();
		filterEnlacesDocumento.setZrntabla(zrntabla);
		filterEnlacesDocumento.setZrncampo(zrncampo);
		filterEnlacesDocumento.setZrvcampo(zrvcampo);
		model.addAttribute("enlacesDocumento", filterEnlacesDocumento);
		EnlacesDocumentoController.logger
				.info("[GET - View] : enlacesDocumento");
		return new ModelAndView("enlacesDocumento", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param zrntabla
	 *            String
	 * @param zrncampo
	 *            String
	 * @param zrvcampo
	 *            String
	 * @param zrobjeto
	 *            String
	 * @param zrdescri
	 *            String
	 * @return enlacesDocumento EnlacesDocumento
	 */
	@RequestMapping(value = "/{zrntabla}/{zrncampo}/{zrvcampo}/{zrobjeto}/{zrdescri}", method = RequestMethod.GET)
	public @ResponseBody
	EnlacesDocumento getById(@PathVariable String zrntabla,
			@PathVariable String zrncampo, @PathVariable String zrvcampo,
			@PathVariable String zrobjeto, @PathVariable String zrdescri) {
		EnlacesDocumento enlacesDocumento = new EnlacesDocumento();
		enlacesDocumento.setZrntabla(zrntabla);
		enlacesDocumento.setZrncampo(zrncampo);
		enlacesDocumento.setZrvcampo(zrvcampo);
		enlacesDocumento.setZrobjeto(zrobjeto);
		enlacesDocumento.setZrdescri(zrdescri);
		enlacesDocumento = this.enlacesDocumentoService.find(enlacesDocumento);
		EnlacesDocumentoController.logger
				.info("[GET - findBy_PK] : Obtener EnlacesDocumento por PK");
		return enlacesDocumento;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterEnlacesDocumento
	 *            EnlacesDocumento
	 * @return List
	 */
	@RequestMapping(value = "/findAllDocs", method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@ModelAttribute(value = "enlacesDocumento") EnlacesDocumento filterEnlacesDocumento,
			HttpServletRequest request) {

		EnlacesDocumentoController.logger
				.info("[GET - find_ALL] : Obtener EnlacesDocumento por filtro");
		Pagination pagination = null;
		if (request.getHeader("JQGridModel") != null
				&& request.getHeader("JQGridModel").equals("true")) {
			pagination = new Pagination();
			pagination.setPage(Long.valueOf(request.getParameter("page")));
			pagination.setRows(Long.valueOf(request.getParameter("rows")));
			pagination.setSort(request.getParameter("sidx"));
			pagination.setAscDsc(request.getParameter("sord"));

			List<EnlacesDocumento> listAEnlacesDocumento = this.enlacesDocumentoService
					.findAll(filterEnlacesDocumento, pagination);

			Long total = this.enlacesDocumentoService
					.findAllCount(filterEnlacesDocumento);
			JQGridJSONModel data = new JQGridJSONModel();
			data.setPage(request.getParameter("page"));
			data.setRecords(total.intValue());
			data.setTotal(total, pagination.getRows());
			data.setRows(listAEnlacesDocumento);
			return data;
		} else {
			return this.enlacesDocumentoService.findAll(filterEnlacesDocumento,
					null);
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param enlacesDocumento
	 *            EnlacesDocumento
	 * @return EnlacesDocumento
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	EnlacesDocumento edit(@RequestBody EnlacesDocumento enlacesDocumento) {
		EnlacesDocumento enlacesDocumentoAux = this.enlacesDocumentoService
				.update(enlacesDocumento);
		EnlacesDocumentoController.logger
				.info("[PUT] : EnlacesDocumento actualizado correctamente");
		return enlacesDocumentoAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param enlacesDocumento
	 *            EnlacesDocumento
	 * @return EnlacesDocumento
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	EnlacesDocumento add(@RequestBody EnlacesDocumento enlacesDocumento) {
		EnlacesDocumento enlacesDocumentoAux = this.enlacesDocumentoService
				.add(enlacesDocumento);
		EnlacesDocumentoController.logger
				.info("[POST] : EnlacesDocumento insertado correctamente");
		return enlacesDocumentoAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param zrntabla
	 *            String
	 * @param zrncampo
	 *            String
	 * @param zrvcampo
	 *            String
	 * @param zrobjeto
	 *            String
	 * @param zrdescri
	 *            String
	 * @return enlacesDocumento
	 */
	@RequestMapping(value = "/{zrntabla}/{zrncampo}/{zrvcampo}/{zrobjeto}/{zrdescri}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	EnlacesDocumento remove(@PathVariable String zrntabla,
			@PathVariable String zrncampo, @PathVariable String zrvcampo,
			@PathVariable String zrobjeto, @PathVariable String zrdescri) {
		EnlacesDocumento enlacesDocumento = new EnlacesDocumento();
		enlacesDocumento.setZrntabla(zrntabla);
		enlacesDocumento.setZrncampo(zrncampo);
		enlacesDocumento.setZrvcampo(zrvcampo);
		enlacesDocumento.setZrobjeto(zrobjeto);
		enlacesDocumento.setZrdescri(zrdescri);
		this.enlacesDocumentoService.remove(enlacesDocumento);
		EnlacesDocumentoController.logger
				.info("[DELETE] : EnlacesDocumento borrado correctamente");
		return enlacesDocumento;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param enlacesDocumentoIds
	 *            List
	 * @return enlacesDocumentoList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> enlacesDocumentoIds) {
		List<EnlacesDocumento> enlacesDocumentoList = new ArrayList<EnlacesDocumento>();
		for (List<String> enlacesDocumentoId : enlacesDocumentoIds) {
			Iterator<String> iterator = enlacesDocumentoId.iterator();
			EnlacesDocumento enlacesDocumento = new EnlacesDocumento(); // NOPMD
																		// -
																		// Objeto
																		// nuevo
																		// en la
																		// lista
																		// (parametro
																		// del
																		// servicio)
			enlacesDocumento.setZrntabla(ObjectConversionManager.convert(
					iterator.next(), String.class));
			enlacesDocumento.setZrncampo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			enlacesDocumento.setZrvcampo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			enlacesDocumento.setZrobjeto(ObjectConversionManager.convert(
					iterator.next(), String.class));
			enlacesDocumento.setZrdescri(ObjectConversionManager.convert(
					iterator.next(), String.class));
			enlacesDocumentoList.add(enlacesDocumento);
		}
		this.enlacesDocumentoService.removeMultiple(enlacesDocumentoList);
		EnlacesDocumentoController.logger
				.info("[POST - DELETE_ALL] : EnlacesDocumento borrados correctamente");
		return enlacesDocumentoIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterEnlacesDocumento
	 *            EnlacesDocumento
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute EnlacesDocumento filterEnlacesDocumento,
			@ModelAttribute Pagination pagination) {

		List<EnlacesDocumento> enlacesDocumentos = this.enlacesDocumentoService
				.findAll(filterEnlacesDocumento, pagination);
		Long recordNum = this.enlacesDocumentoService
				.findAllCount(filterEnlacesDocumento);
		EnlacesDocumentoController.logger
				.info("[GET - jqGrid] : Obtener EnlacesDocumento");
		return new JQGridJSONModel(pagination, recordNum, enlacesDocumentos);
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}
}
