package com.ejie.y41b.control;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Empper;
import com.ejie.y41b.service.EmpperService;
import com.ejie.y41b.service.Y41bExcelGeneratorService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * EmpperController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/empper")
public class EmpperController {

	private static final Logger logger = LoggerFactory
			.getLogger(EmpperController.class);

	@Autowired()
	private EmpperService empperService;

	@Autowired()
	private Y41bExcelGeneratorService y41bExcelGeneratorService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */
	@Autowired()
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody()
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;
		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			// throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {
		EmpperController.logger.info("[GET - View] : empper");
		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| (censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO) && censoMonitor
						.getPerfilArbitraje().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO))) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("empper", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormModalBusqueda'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "maintPeritos", method = RequestMethod.GET)
	public ModelAndView getCreateFormModalBusqueda(Model model,
			HttpServletRequest request) {

		model.addAttribute("modoBusquedaPerito",
				Y41bConstantes.MODO_POPUP_SELECCION);

		model.addAttribute("modoActualizarPerito", true);

		EmpperController.logger.info("[GET - View] : perito");
		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| (censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO) && censoMonitor
						.getPerfilArbitraje().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO))) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		}
		return new ModelAndView("peritoSeleccion", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param pecodigo
	 *            String
	 * @return empper Empper
	 */
	@RequestMapping(value = "/getById/{pecodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	Empper getById(@PathVariable() String pecodigo) {
		Empper empper = new Empper();
		empper.setPecodigo(pecodigo);
		empper = this.empperService.find(empper);
		EmpperController.logger
				.info("[GET - findBy_PK] : Obtener Empper por PK");
		return empper;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterEmpper
	 *            Empper
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Empper> getAll(@ModelAttribute() Empper filterEmpper) {
		EmpperController.logger
				.info("[GET - find_ALL] : Obtener Empper por filtro");
		return this.empperService.findAll(filterEmpper, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param empper
	 *            Empper
	 * @return Empper
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Empper edit(@RequestBody() Empper empper) {
		Empper empperAux = this.empperService.update(empper);
		EmpperController.logger
				.info("[PUT] : Empper actualizado correctamente");
		return empperAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param empper
	 *            Empper
	 * @return Empper
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Empper add(@RequestBody() Empper empper) {
		Empper empperAux = this.empperService.add(empper);
		EmpperController.logger.info("[POST] : Empper insertado correctamente");
		return empperAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param pecodigo
	 *            String
	 * @return empper
	 */
	@RequestMapping(value = "/{pecodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Empper remove(@PathVariable() String pecodigo) {
		Empper empper = new Empper();
		empper.setPecodigo(pecodigo);
		this.empperService.remove(empper);
		EmpperController.logger.info("[DELETE] : Empper borrado correctamente");
		return empper;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param empperIds
	 *            List
	 * @return empperList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(
			@RequestBody() List<List<String>> empperIds) {
		List<Empper> empperList = new ArrayList<Empper>();
		for (List<String> empperId : empperIds) {
			Iterator<String> iterator = empperId.iterator();
			Empper empper = new Empper(); // NOPMD - Objeto nuevo en la lista
											// (parametro del servicio)
			empper.setPecodigo(ObjectConversionManager.convert(iterator.next(),
					String.class));
			empperList.add(empper);
		}
		this.empperService.removeMultiple(empperList);
		EmpperController.logger
				.info("[POST - DELETE_ALL] : Empper borrados correctamente");
		return empperIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterEmpper
	 *            Empper
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(@ModelAttribute() Empper filterEmpper,
			@ModelAttribute() Pagination pagination) {
		List<Empper> emppers = this.empperService.findAll(filterEmpper,
				pagination);
		Long recordNum = this.empperService.findAllCount(filterEmpper);
		EmpperController.logger.info("[GET - jqGrid] : Obtener Empper");
		return new JQGridJSONModel(pagination, recordNum, emppers);
	}

	/**
	 * Method 'getCreateFormDetalle'.
	 * 
	 * @param pecodigo
	 *            String
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "/detalle/{pecodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormDetalle(@PathVariable() String pecodigo,
			Model model) {
		EmpperController.logger.info("[GET - View] : Empper");
		model.addAttribute("pecodigo", pecodigo);
		model.addAttribute("modo", Y41bConstantes.MODO_POPUP_MODIFICACION);
		return new ModelAndView("empperDetalle", "model", model);
	}

	/**
	 * Method 'getCreateFormDetalle'.
	 * 
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "/alta", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(Model model) {
		EmpperController.logger.info("[GET - View] : Empper");
		Long pecodigo = this.empperService.getNewPK();
		model.addAttribute("pecodigo", pecodigo);
		model.addAttribute("modo", Y41bConstantes.MODO_POPUP_ALTA);
		return new ModelAndView("empperDetalle", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param pecodigo
	 *            String
	 * @return Empper Empper
	 */
	@RequestMapping(value = "/existe/{pecodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	long existe(@PathVariable() String pecodigo) {
		Empper Empper = new Empper();
		Empper.setPecodigo(pecodigo);
		return this.empperService.findAllCount(Empper);
	}

	/**
	 * Method 'borrarTemporales'.
	 * 
	 * @param pecodigo
	 *            String
	 */
	@RequestMapping(value = "/borrarTemporales/{pecodigo}", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	void borrarTemporales(@PathVariable() String pecodigo) {
		Empper Empper = new Empper();
		Empper.setPecodigo(pecodigo);
		this.empperService.borrarTemporales(Empper);
		EmpperController.logger
				.info("[DELETE] : Empper Temporalres borrado correctamente");

	}

	/**
	 * Method 'getAllExcel'.
	 * 
	 * @param filterPerito
	 *            Empper
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excel", method = RequestMethod.GET)
	public void getAllExcel(@ModelAttribute() Empper filterPerito,
			HttpServletRequest request, HttpServletResponse response) {
		try {

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy,
					"yyyyMMddHHmmss");
			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_PERITO + fechaActual + ".xls";
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ StringEscapeUtils.unescapeHtml(nombre) + "\"");

			String xslString = this.y41bExcelGeneratorService
					.getPeritoExcel(filterPerito);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 * @throws Exception
	 */
	@RequestMapping(value = "seleccionPeritos", method = RequestMethod.GET)
	public ModelAndView getCreateFormModal(Model model,
			HttpServletRequest request) throws Exception {

		model.addAttribute("modoBusquedaPerito",
				Y41bConstantes.MODO_POPUP_SELECCION);

		return new ModelAndView("peritoSeleccion", "model", model);
	}
}
