package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

//import com.ejie.r02T.xml.DatosDocument.Datos.Archivo.Documentoselectronicos.Documento;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.adapter.Y41bDokusiAdapterService;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.DocumentoSolicitudTelematicaEventos;
import com.ejie.y41b.model.SolicitudTelematicaEventos;
import com.ejie.y41b.service.DocumentosSolicitudesTelematicasEventosService;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.ws.Y41bUtilsWS;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.dokusi.User;
import com.ejie.y41b.model.platea.Procedure;

/**
 * SolicitudesTelematicasController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/documentosSolicitudesTelematicasEventos")
public class DocumentosSolicitudesTelematicasEventosController {

	private static final Logger logger = LoggerFactory
			.getLogger(DocumentosSolicitudesTelematicasEventosController.class);

	@Autowired
	private DocumentosSolicitudesTelematicasEventosService documentosSolicitudesTelematicasEventosService;

	@Autowired()
	private Y41bDokusiAdapterService y41bDokusiAdapterService;

	@Autowired
	private Properties appConfiguration;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */
	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param tipoexpediente
	 *            String
	 * @param idsolicitud
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/documentos/{stTipoExpediente}/{stCodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateForm(@PathVariable String stTipoExpediente, @PathVariable String stCodigo,
			Model model) {

		SolicitudTelematicaEventos solicitudTelematicaEventos = new SolicitudTelematicaEventos();
		solicitudTelematicaEventos.setStCodigo(stCodigo);
		solicitudTelematicaEventos.setStTipoExpediente(stTipoExpediente);

		model.addAttribute("solicitudTelematicaEventos", solicitudTelematicaEventos);

		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("documentosSolicitudTelematicaEventos", "model", model);
	}

	/**
	 * Method 'getAllDocumentosSolicitudesTelematicasEventos'.
	 * 
	 * @param solicitudTelematicaEventos
	 *            SolicitudTelematicaEventos
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllDocumentosSTE/{stcodigo}", method = RequestMethod.GET)
	public @ResponseBody Object getAllDocumentosTramite(@PathVariable String stcodigo, HttpServletRequest request) {
		try {

			DocumentoSolicitudTelematicaEventos filterDocumentoSolicitudTelematicaEventos = new DocumentoSolicitudTelematicaEventos();
			SolicitudTelematicaEventos solicitudTelematicaEventosFilter = new SolicitudTelematicaEventos();
			solicitudTelematicaEventosFilter.setStCodigo(stcodigo);
			filterDocumentoSolicitudTelematicaEventos.setDsSolicitudTelematicaEventos(solicitudTelematicaEventosFilter);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<DocumentoSolicitudTelematicaEventos> listDocumentoSolicitudTelematicaEventos = null;

				listDocumentoSolicitudTelematicaEventos = this.documentosSolicitudesTelematicasEventosService
						.findAllDocumentosSTE(filterDocumentoSolicitudTelematicaEventos, pagination);

				if (listDocumentoSolicitudTelematicaEventos == null) {
					throw new Exception("No data Found.");
				}

				Long total = new Long(0);

				total = this.documentosSolicitudesTelematicasEventosService
						.findAllDocumentosSTECount(filterDocumentoSolicitudTelematicaEventos);

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listDocumentoSolicitudTelematicaEventos);
				return data;
			} else {
				List<DocumentoSolicitudTelematicaEventos> listDocumentoSolicitudTelematicaEventos = null;

				listDocumentoSolicitudTelematicaEventos = this.documentosSolicitudesTelematicasEventosService
						.findAllDocumentosSTE(filterDocumentoSolicitudTelematicaEventos, null);

				if (listDocumentoSolicitudTelematicaEventos == null) {
					throw new Exception("No data Found.");
				}
				return listDocumentoSolicitudTelematicaEventos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'findDocumentoSTE'.
	 * 
	 * @param tipoexpediente
	 *            String
	 * @param iddokusi
	 *            String
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findDocumento/{stTipoExpediente}/{dsOIDDokusi}", method = RequestMethod.GET)
	public @ResponseBody void findBandejaSolicitudDoc(@PathVariable String stTipoExpediente,
			@PathVariable String dsOIDDokusi, HttpServletResponse response) {
		try {
			// Inicio Bloque del Test
			Documento documento = new Documento();
			// 1.User
			User user = new User();
			user.setNombre(Y41bConstantes.COD_APLICACION);
			user.setDni(Y41bConstantes.COD_APLICACION);
			documento.setUser(user);
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(stTipoExpediente);
			documento.setProcedure(procedure);

			documento.setOidDokusi(dsOIDDokusi);

			Documento documentoRdo = y41bDokusiAdapterService.descargarDocumentoDokusi(documento);

			// Fin Bloque del Test
			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo

			byte[] buffer = Y41bUtilsWS.decode(documentoRdo.getBytes());

			// String nombre = documentoRdo.getNombreCompleto();
			String nombre = documentoRdo.getNombre();
			response.setHeader("Content-Disposition", "attachment;filename=\"" + nombre + "\"");
			response.setContentType(documentoRdo.getContentType());
			response.getOutputStream().write(buffer);

			// Vaciamos el stream
			response.getOutputStream().flush();
		} catch (Exception e) {
			throw new ResourceNotFoundException(dsOIDDokusi.toString());
		}
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * @param documentoSolicitud
	 *            DocumentoSolicitud Bean que contiene la informacion con la que
	 *            se va a crear el nuevo registro.
	 * @return DocumentoSolicitud Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody DocumentoSolicitudTelematicaEventos add(
			@RequestBody DocumentoSolicitudTelematicaEventos documentoSolicitudTelematicaEventos) {
		DocumentoSolicitudTelematicaEventos documentoSolicitudTelematicaEventosAux = this.documentosSolicitudesTelematicasEventosService
				.add(documentoSolicitudTelematicaEventos);
		DocumentosSolicitudesTelematicasEventosController.logger
				.info("[POST] : DocumentoSolicitud insertado correctamente");
		return documentoSolicitudTelematicaEventosAux;
	}
}
