package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.MethodFailureException;
//import com.ejie.r02T.xml.DatosDocument.Datos.Archivo.Documentoselectronicos.Documento;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.adapter.Y41bDokusiAdapterService;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Arbtipdoc;
import com.ejie.y41b.model.AsientoRegistral;
import com.ejie.y41b.model.Denuncia;
import com.ejie.y41b.model.DocumentoAsientoRegistral;
import com.ejie.y41b.model.InspeccionesTipoDocumento;
import com.ejie.y41b.model.Santipdoc;
import com.ejie.y41b.model.TipoDocumento;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.dokusi.User;
import com.ejie.y41b.model.platea.Procedure;
import com.ejie.y41b.service.ArbtipdocService;
import com.ejie.y41b.service.DocumentosAsientoRegistralService;
import com.ejie.y41b.service.InspeccionesTipoDocumentoService;
import com.ejie.y41b.service.SantipdocService;
import com.ejie.y41b.service.TipoDocumentoService;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.ws.Y41bUtilsWS;

/**
 * SolicitudesTelematicasController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/documentosAsientoRegistral")
@SessionAttributes({ "documentoAsientoRegistral" })
public class DocumentosAsientoRegistralController {

	private static final Logger logger = LoggerFactory.getLogger(DocumentosAsientoRegistralController.class);

	@Autowired
	private DocumentosAsientoRegistralService documentosAsientoRegistralService;

	@Autowired()
	private Y41bDokusiAdapterService y41bDokusiAdapterService;

	@Autowired
	private Properties appConfiguration;

	// TipoDocumentoService propio de Solicitudes
	@Autowired
	private TipoDocumentoService tipoDocumentoService;

	// TipoDocumentoService propio de Sanciones
	@Autowired
	private SantipdocService santipdocService;

	@Autowired()
	private ArbtipdocService arbtipdocService;

	@Autowired
	private InspeccionesTipoDocumentoService inspeccionesTipoDocumentoService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */
	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param tipoexpediente
	 *            String
	 * @param idsolicitud
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/documentos/{pcodigo}/{idAsiento}", method = RequestMethod.GET)
	public ModelAndView getCreateForm(@PathVariable String pcodigo, @PathVariable String idAsiento, Model model) {

		AsientoRegistral asientoRegistral = new AsientoRegistral();
		asientoRegistral.setIdAsiento(idAsiento);
		asientoRegistral.setPcodigo(pcodigo);

		model.addAttribute("asientoRegistral", asientoRegistral);

		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("documentosAsientoRegistral", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param tipoexpediente
	 *            String
	 * @param idsolicitud
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/y41bDetalleDocumento/{oidDokusi}", method = RequestMethod.GET)
	public ModelAndView getCreateForm(@PathVariable String oidDokusi, Model model) {

		DocumentoAsientoRegistral documentoAsientoRegistral = new DocumentoAsientoRegistral();
		documentoAsientoRegistral.setOidDokusi(oidDokusi);

		model.addAttribute("documentoAsientoRegistral", documentoAsientoRegistral);

		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("detalleDocumentoAsientoRegistral", "model", model);
	}

	/**
	 * Method 'getAllDocumentosAsientoRegistral'.
	 * 
	 * @param asientoRegistral
	 *            AsientoRegistral
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllDocumentosAR/{idAsiento}", method = RequestMethod.GET)
	public @ResponseBody Object getAllDocumentosAR(@PathVariable String idAsiento, HttpServletRequest request) {
		try {

			DocumentoAsientoRegistral filterDocumentoAsientoRegistral = new DocumentoAsientoRegistral();
			AsientoRegistral asientoRegistral = new AsientoRegistral();
			asientoRegistral.setIdAsiento(idAsiento);
			filterDocumentoAsientoRegistral.setAsientoRegistral(asientoRegistral);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<DocumentoAsientoRegistral> listDocumentoAsientoRegistral = null;

				listDocumentoAsientoRegistral = this.documentosAsientoRegistralService
						.findAllDocumentosAR(filterDocumentoAsientoRegistral, pagination);

				if (listDocumentoAsientoRegistral == null) {
					throw new Exception("No data Found.");
				}

				Long total = new Long(0);

				total = this.documentosAsientoRegistralService
						.findAllDocumentosARCount(filterDocumentoAsientoRegistral);

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listDocumentoAsientoRegistral);
				return data;
			} else {
				List<DocumentoAsientoRegistral> listDocumentoAsientoRegistral = null;

				listDocumentoAsientoRegistral = this.documentosAsientoRegistralService
						.findAllDocumentosAR(filterDocumentoAsientoRegistral, null);

				if (listDocumentoAsientoRegistral == null) {
					throw new Exception("No data Found.");
				}
				return listDocumentoAsientoRegistral;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'findDocumentoSTE'.
	 * 
	 * @param tipoexpediente
	 *            String
	 * @param iddokusi
	 *            String
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findDocumento/{pcodigo}/{oidDokusi}", method = RequestMethod.GET)
	public @ResponseBody void findBandejaSolicitudDoc(@PathVariable String pcodigo, @PathVariable String oidDokusi,
			HttpServletResponse response) {
		try {
			// Inicio Bloque del Test
			Documento documento = new Documento();
			// 1.User
			User user = new User();
			user.setNombre(Y41bConstantes.COD_APLICACION);
			user.setDni(Y41bConstantes.COD_APLICACION);
			documento.setUser(user);
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(pcodigo);
			documento.setProcedure(procedure);

			documento.setOidDokusi(oidDokusi);

			Documento documentoRdo = y41bDokusiAdapterService.descargarDocumentoSIR(documento);

			// Fin Bloque del Test
			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo

			byte[] buffer = Y41bUtilsWS.decode(documentoRdo.getBytes());

			// String nombre = documentoRdo.getNombreCompleto();
			String nombre = documentoRdo.getNombre();
			response.setHeader("Content-Disposition", "attachment;filename=\"" + nombre + "\"");
			response.setContentType(documentoRdo.getContentType());
			response.getOutputStream().write(buffer);

			// Vaciamos el stream
			response.getOutputStream().flush();
		} catch (Exception e) {
			throw new ResourceNotFoundException(oidDokusi.toString());
		}
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * @param documentoAsientoRegistral
	 *            DocumentoAsientoRegistral Bean que contiene la informacion con
	 *            la que se va a crear el nuevo registro.
	 * @return DocumentoAsientoRegistral Bean resultante del proceso de
	 *         creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody DocumentoAsientoRegistral add(
			@RequestBody DocumentoAsientoRegistral documentoAsientoRegistral) {
		DocumentoAsientoRegistral documentoAsientoRegistralAux = this.documentosAsientoRegistralService
				.add(documentoAsientoRegistral);
		DocumentosAsientoRegistralController.logger
				.info("[POST] : DocumentosAsientoRegistralController insertado correctamente");
		return documentoAsientoRegistralAux;
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param documentoAsientoRegistral
	 *            DocumentoAsientoRegistral
	 * @param response
	 *            HttpServletResponse
	 * @return DocumentoAsientoRegistral
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody DocumentoAsientoRegistral edit(
			@RequestBody DocumentoAsientoRegistral documentoAsientoRegistral, HttpServletResponse response) {
		try {
			DocumentoAsientoRegistral documentoAsientoRegistralAux = this.documentosAsientoRegistralService
					.update(documentoAsientoRegistral);
			logger.info("Entity correctly inserted!");
			return documentoAsientoRegistralAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'findDocumentoSTE'.
	 * 
	 * @param tipoexpediente
	 *            String
	 * @param iddokusi
	 *            String
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/getbyid/{oidDokusi}", method = RequestMethod.GET)
	public @ResponseBody DocumentoAsientoRegistral findAsientoRegistralDocumentoDetalle(@PathVariable String oidDokusi,
			HttpServletResponse response) {
		try {

			DocumentoAsientoRegistral documentoAsientoRegistral = new DocumentoAsientoRegistral();
			documentoAsientoRegistral.setOidDokusi(oidDokusi);

			documentoAsientoRegistral = this.documentosAsientoRegistralService
					.findDocumentoAR(documentoAsientoRegistral);

			return documentoAsientoRegistral;
		} catch (Exception e) {
			throw new ResourceNotFoundException(oidDokusi.toString());
		}
	}

	/**
	 * Method 'getAllTipoDocumentos'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return List
	 */
	@RequestMapping(value = "/findAllTipoDocumento/{tipoProcedimiento}", method = RequestMethod.GET)
	public @ResponseBody List<TipoDocumento> getAllTipoDocumento(@PathVariable String tipoProcedimiento) {

		if (tipoProcedimiento.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			return this.tipoDocumentoService.findAll(new TipoDocumento(), null);
		} else if (tipoProcedimiento.equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
			Santipdoc santipdoc = new Santipdoc();
			santipdoc.setTdtipo(Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA);
			return this.santipdocService.findAllTipoDocumento(santipdoc, null);
		} else if (tipoProcedimiento.equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
			Arbtipdoc arbtipdoc = new Arbtipdoc();
			arbtipdoc.setTdtipo(Y41bConstantes.TIPO_DOCUMENTO_ARBITRAJE_ENTRADA);
			arbtipdoc.setTdpcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
			return this.arbtipdocService.findAllTipoDocumento(arbtipdoc, null);
		} else if (tipoProcedimiento.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			return this.inspeccionesTipoDocumentoService.findAllTipoDocumento(new InspeccionesTipoDocumento(), null);
		}
		return null;
	}

	/**
	 * Method 'countDocsSinRellenar'.
	 * 
	 * 
	 * @param idAsiento
	 *            String
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/countDocsSinRellenar/{idAsiento}", method = RequestMethod.GET)
	public @ResponseBody Long countDocsSinRellenar(@PathVariable String idAsiento, HttpServletResponse response) {
		try {

			DocumentoAsientoRegistral documentoAsientoRegistral = new DocumentoAsientoRegistral();
			AsientoRegistral asientoRegistral = new AsientoRegistral();
			asientoRegistral.setIdAsiento(idAsiento);
			documentoAsientoRegistral.setAsientoRegistral(asientoRegistral);

			return this.documentosAsientoRegistralService.countDocsSinRellenar(documentoAsientoRegistral);
		} catch (Exception e) {
			throw new ResourceNotFoundException(idAsiento.toString());
		}
	}

	/**
	 * Method 'reseteaDocsAsiento'.
	 * 
	 * @param documentoAsientoRegistral
	 *            DocumentoAsientoRegistral
	 * @param response
	 *            HttpServletResponse
	 * @return DocumentoAsientoRegistral
	 */
	@RequestMapping(value = "/reseteaDocsAsiento/{idAsiento}", method = RequestMethod.PUT)
	public @ResponseBody void reseteaDocsAsiento(@PathVariable String idAsiento, HttpServletResponse response) {
		try {
			this.documentosAsientoRegistralService.reseteaDocsAsiento(idAsiento);
		} catch (Exception e) {
			throw new MethodFailureException("Method reseteaDocsAsiento failed");
		}
	}
}
