package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.rowset.serial.SerialBlob;

import org.apache.commons.lang.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.EstTipoDoc;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.TipoDocumento;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.service.AdjuntardocsService;
import com.ejie.y41b.service.ArbdoctempService;
import com.ejie.y41b.service.DocsEstablecimientoService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

;

/**
 * * EstablecimientoController  
 * 
 *  
 */

/**
 *  
 * 
 */
@Controller
@RequestMapping(value = "/docsEstablecimiento")
@SessionAttributes({ "establecimiento", "sede" })
public class DocsEstablecimientoController {

	@Autowired()
	private AdjuntardocsService adjuntardocsService;

	@Autowired()
	private ArbdoctempService arbdoctempService;

	@Autowired()
	private DocsEstablecimientoService docsEstablecimientoService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Properties appConfiguration;

	// /**
	// * Method 'getCreateForm'.
	// *
	// * @param model
	// * Model
	// * @param request
	// * HttpServletRequest
	// * @return String
	// */
	// @RequestMapping(value = "maint", method = RequestMethod.GET)
	// public ModelAndView getCreateForm(Model model, HttpServletRequest
	// request) {
	// model.addAttribute("defaultLanguage",
	// appConfiguration.get("y41bVistaWar.default.language"));
	// model.addAttribute("defaultLayout",
	// appConfiguration.get("y41bVistaWar.default.layout"));
	//
	// return new ModelAndView("establecimiento", "model", model);
	// }

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintModal", method = RequestMethod.GET)
	public ModelAndView getCreateFormModal(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("establecimientoModal", "model", model);
	}

	/**
	 * Method 'getCreateFormMaintY41bCampanhaDetalleDocumentos'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintY41bEstablecimientosDetalle_Documentos", method = RequestMethod.GET)
	public ModelAndView getCreateFormMaintY41bEstablecimientosDetalleDocumentos(
			@ModelAttribute Establecimiento establecimiento, Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(establecimiento.getEscodigo());
		tramiteComun.setIdTramite(establecimiento.getEscodigo());
		tramiteComun.setTipoProcedimiento(new TipoProcedimiento("EST"));

		this.docsEstablecimientoService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);

		if (censoMonitor.getPerfilArbitraje() == null || censoMonitor.getPerfilArbitraje().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("establecimientosDetalle_Documentos", "model", model);
		}
	}

	/**
	 * Method 'getAllDocsTramiteAcuerdoIncoacion'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllDocsEstablecimiento", method = RequestMethod.GET)
	public @ResponseBody() Object getAllDocsEstablecimientos(@ModelAttribute Establecimiento establecimiento,
			HttpServletRequest request) {
		try {
			Adjuntardocs adjuntardocsFilter = new Adjuntardocs();
			adjuntardocsFilter.setThidExpediente(establecimiento.getEscodigo());
			adjuntardocsFilter.setThidTramite(establecimiento.getEscodigo());
			// adjuntardocsFilter.setTrpcodigo(tramiteComun.getTipoProcedimiento()
			// .getPcodigo());
			// adjuntardocsFilter.setTrpcodigo("EST");

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAdjuntardocs);
				return data;
			} else {
				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}
				return listAdjuntardocs;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addDocsTramite'.
	 * 
	 * @param file
	 *            MultipartFile
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return ConsultaFile
	 */
	@RequestMapping(value = "/anyadirDocsEstablecimientos", method = RequestMethod.POST)
	public @ResponseBody() void addDocsTramite(@RequestParam(value = "files[]", required = false) MultipartFile file,
			@ModelAttribute Establecimiento establecimiento, HttpServletResponse response, HttpServletRequest request) {
		try {

			Adjuntardocs adjuntardocsAux = new Adjuntardocs();

			String thtedesfile = request.getParameter("thtedesfile");
			String thesttipodoc = request.getParameter("thesttipodoc");
			// se lo metemos a valor fijo ya que de momento el combo no se
			// muestra
			thesttipodoc = "1";

			adjuntardocsAux.setThcodocumento(this.arbdoctempService.getNewPK().toString());
			adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_ARB_APORTADO_ADMINISTRACION);

			TipoDocumento tipoDocumento = new TipoDocumento();
			tipoDocumento.setIdTipodoc(thesttipodoc);

			adjuntardocsAux.setTipoDocumento(tipoDocumento);

			adjuntardocsAux.setThtedesfile(thtedesfile);

			// Blob blob = new SerialBlob(file.getBytes());
			// adjuntardocsAux.setThdatafile(blob);
			adjuntardocsAux.setThdatafileinputstream(file.getInputStream());
			adjuntardocsAux.setThcontenttypefile(file.getContentType());
			adjuntardocsAux.setThnofile(file.getOriginalFilename());
			adjuntardocsAux.setThsizefile((int) file.getSize());

			// TipoProcedimiento tp = new TipoProcedimiento();
			// tp.setPcodigo("ARB");

			adjuntardocsAux.setThidExpediente(establecimiento.getEscodigo());
			adjuntardocsAux.setThidTramite(establecimiento.getEscodigo());
			adjuntardocsAux.setTipoProcedimiento(new TipoProcedimiento("EST"));
			adjuntardocsAux.setThfecha(new Date());
			adjuntardocsAux.setTrpcodigo("EST");
			adjuntardocsAux = this.adjuntardocsService.add(adjuntardocsAux);

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			filesMetaInfo.add(this.getFileReturnMap(file));
			// return filesMetaInfo;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * Metodos para la Gestion de Tabla de Docs Fin
	 * 
	 */

	/**
	 * 
	 * @param file
	 *            MultipartFile
	 * @return mapa
	 */
	private Map<String, Object> getFileReturnMap(MultipartFile file) {
		Map<String, Object> mapaRetorno = new HashMap<String, Object>();
		mapaRetorno.put("url", "/y41bVistaWar/establecimientoDetalleDocumentos/guardar/" + file.getOriginalFilename());
		mapaRetorno.put("name", file.getOriginalFilename());
		mapaRetorno.put("type", file.getContentType());
		mapaRetorno.put("size", file.getSize());
		mapaRetorno.put("delete_url",
				"/y41bVistaWar/establecimientoDetalleDocumentos/guardar/" + file.getOriginalFilename());
		mapaRetorno.put("delete_type", "DELETE");
		return mapaRetorno;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param thcodocumento
	 *            Long
	 * @param establecimiento
	 *            Establecimiento
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarDocsEstablecimiento/{thcodocumento}", method = RequestMethod.DELETE)
	public void remove(@PathVariable() String thcodocumento, @ModelAttribute Establecimiento establecimiento,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThidExpediente(establecimiento.getEscodigo());
			adjuntardocsAux.setThidTramite(establecimiento.getEscodigo());
			adjuntardocsAux.setThcodocumento(thcodocumento.toString());
			// adjuntardocsAux.setTipoProcedimiento(new
			// TipoProcedimiento("ARB"));
			adjuntardocsAux.setTrpcodigo("EST");

			this.adjuntardocsService.remove(adjuntardocsAux);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param thcodocumento
	 *            Long
	 * @param establecimiento
	 *            Establecimiento
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/guardarDocsEstablecimiento", method = RequestMethod.POST)
	public void guardarDocsEstablecimiento(@ModelAttribute Establecimiento establecimiento,
			HttpServletResponse response) {

		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThidExpediente(establecimiento.getEscodigo());

			this.docsEstablecimientoService.guardarDocumentos(establecimiento);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllTipoDocs'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllTipoDocs", method = RequestMethod.GET)
	public @ResponseBody() Object getAllTipoDocs(HttpServletRequest request) {
		try {

			List<EstTipoDoc> listEstTipoDoc = null;

			listEstTipoDoc = this.docsEstablecimientoService.findAllTipoDocs();

			if (listEstTipoDoc == null) {
				throw new Exception("No data Found.");
			}
			return listEstTipoDoc;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getByIdDocumentoAcuerdoIncoacion'.
	 * 
	 * @param thcodocumento
	 *            Long
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findDoc/{thcodocumento}", method = RequestMethod.GET)
	public @ResponseBody() void getByIdDocumento(@PathVariable() String thcodocumento,
			@ModelAttribute Establecimiento establecimiento, HttpServletResponse response) {
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThidExpediente(establecimiento.getEscodigo());
			adjuntardocsAux.setThidTramite(establecimiento.getEscodigo());
			adjuntardocsAux.setThcodocumento(thcodocumento.toString());
			// adjuntardocsAux.setTipoProcedimiento(tramiteComun
			// .getTipoProcedimiento());

			adjuntardocsAux = this.adjuntardocsService.findAdjuntardocs(adjuntardocsAux);

			Blob contenido = adjuntardocsAux.getThdatafile();
			// byte[] bContenido = contenido.getBytes(1, (int)
			// contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(adjuntardocsAux.getThnofile()) + "\"");
			response.setContentType(adjuntardocsAux.getThcontenttypefile());
			response.setContentLength(adjuntardocsAux.getThsizefile());
			// response.getOutputStream().write(bContenido);
			Y41bUtils.copyStream(contenido.getBinaryStream(), response.getOutputStream());

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

}