package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.DocEsCanalPrioritario;
import com.ejie.y41b.model.EsCanalPrioritario;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.service.ArbdoctempService;
import com.ejie.y41b.service.DocsEsCanalPrioritarioService;
import com.ejie.y41b.service.EstablecimientoService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

;

/**
 * * DocsEsCanalPrioritarioController  
 * 
 *  
 */

/**
 *  
 * 
 */
@Controller
@RequestMapping(value = "/docsEsCanalPrioritario")
@SessionAttributes({ "establecimiento" })
public class DocsEsCanalPrioritarioController {

	@Autowired()
	private DocsEsCanalPrioritarioService docsEsCanalPrioritarioService;

	@Autowired()
	private EstablecimientoService establecimientoService;

	// @Autowired()
	// private AdjuntardocsService adjuntardocsService;
	//
	@Autowired()
	private ArbdoctempService arbdoctempService;

	// @Autowired()
	// private DocsEstablecimientoService docsEstablecimientoService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getCreateFormMaintmaintY41bEsCanalPrioritario_Documentos'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintY41bEsCanalPrioritario_Documentos/{esCif}", method = RequestMethod.GET)
	public ModelAndView getCreateFormMaintmaintY41bEsCanalPrioritario_Documentos(@PathVariable String esCif,
			@ModelAttribute Establecimiento establecimiento, Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		// EstablecimientoDetalle establecimientoDetalle = new
		// EstablecimientoDetalle();
		// establecimientoDetalle =
		// this.establecimientoService.findEstablecimiento(establecimiento);

		EsCanalPrioritario esCanalPrioritario = new EsCanalPrioritario();
		esCanalPrioritario.setYgcif(esCif);

		this.docsEsCanalPrioritarioService.addDocsFinalATemporal(esCanalPrioritario);

		return new ModelAndView("esCanalPrioritario_Documentos", "model", model);

	}

	/**
	 * Method 'getAllDocsTramiteAcuerdoIncoacion'.
	 *
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllDocsEsCanalPrioritarioTemp/{esCif}", method = RequestMethod.GET)
	public @ResponseBody() Object getAllDocsEsCanalPrioritarioTemp(@PathVariable String esCif,
			@ModelAttribute Establecimiento establecimiento, HttpServletRequest request) {
		try {

			DocEsCanalPrioritario docEsCanalPrioritarioFilter = new DocEsCanalPrioritario();
			docEsCanalPrioritarioFilter.setYhcif(esCif);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<DocEsCanalPrioritario> listDocEsCanalPrioritario = null;

				listDocEsCanalPrioritario = this.docsEsCanalPrioritarioService.findAllTemp(docEsCanalPrioritarioFilter,
						pagination);

				if (listDocEsCanalPrioritario == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.docsEsCanalPrioritarioService.findAllTempCount(docEsCanalPrioritarioFilter);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listDocEsCanalPrioritario);
				return data;
			} else {
				List<DocEsCanalPrioritario> listDocEsCanalPrioritario = null;

				listDocEsCanalPrioritario = this.docsEsCanalPrioritarioService.findAllTemp(docEsCanalPrioritarioFilter,
						pagination);

				if (listDocEsCanalPrioritario == null) {
					throw new Exception("No data Found.");
				}
				return listDocEsCanalPrioritario;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getByIdDocumentoAcuerdoIncoacion'.
	 *
	 * @param yhcodocumento
	 *            Long
	 * @param establecimiento
	 *            Establecimiento
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findDocTemp/{yhcodocumento}", method = RequestMethod.GET)
	public @ResponseBody() void getByIdDocumento(@PathVariable() String yhcodocumento,
			@ModelAttribute Establecimiento establecimiento, HttpServletResponse response) {
		try {
			DocEsCanalPrioritario docEsCanalPrioritarioAux = new DocEsCanalPrioritario();
			docEsCanalPrioritarioAux.setYhcodocumento(yhcodocumento);

			docEsCanalPrioritarioAux = this.docsEsCanalPrioritarioService
					.findDocEsCanalPrioritarioTemp(docEsCanalPrioritarioAux);

			Blob contenido = docEsCanalPrioritarioAux.getYhdatafile();
			// byte[] bContenido = contenido.getBytes(1, (int)
			// contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ StringEscapeUtils.unescapeHtml(docEsCanalPrioritarioAux.getYhnofile()) + "\"");
			response.setContentType(docEsCanalPrioritarioAux.getYhcontenttypefile());
			response.setContentLength(docEsCanalPrioritarioAux.getYhsizefile());
			// response.getOutputStream().write(bContenido);
			Y41bUtils.copyStream(contenido.getBinaryStream(), response.getOutputStream());

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'remove'.
	 *
	 * @param thcodocumento
	 *            Long
	 * @param establecimiento
	 *            Establecimiento
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarDocsEsCanalPrioritarioTemp/{yhcodocumento}", method = RequestMethod.DELETE)
	public void remove(@PathVariable() String yhcodocumento, @ModelAttribute Establecimiento establecimiento,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			DocEsCanalPrioritario docEsCanalPrioritarioAux = new DocEsCanalPrioritario();
			docEsCanalPrioritarioAux.setYhcodocumento(yhcodocumento);

			this.docsEsCanalPrioritarioService.remove(docEsCanalPrioritarioAux);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addDocsEsCanalPrioritarioTemp'.
	 *
	 * @param file
	 *            MultipartFile
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 *
	 * @return ConsultaFile
	 */
	@RequestMapping(value = "/anyadirDocEsCanalPrioritario", method = RequestMethod.POST)
	public @ResponseBody() void addDocEsCanalPrioritarioTemp(
			@RequestParam(value = "files[]", required = false) MultipartFile file,
			@ModelAttribute Establecimiento establecimiento, HttpServletResponse response, HttpServletRequest request) {
		try {

			// EstablecimientoDetalle establecimientoDetalle = new
			// EstablecimientoDetalle();
			// establecimientoDetalle =
			// this.establecimientoService.findEstablecimiento(establecimiento);

			DocEsCanalPrioritario docEsCanalPrioritarioAux = new DocEsCanalPrioritario();
			String yhtedesfile = request.getParameter("yhtedesfile");
			String yhcif = request.getParameter("yhcif");
			// String thesttipodoc = request.getParameter("thesttipodoc");
			// // se lo metemos a valor fijo ya que de momento el combo no se
			// // muestra
			// thesttipodoc = "1";
			docEsCanalPrioritarioAux.setYhcodocumento(this.docsEsCanalPrioritarioService.getNewPK().toString());
			docEsCanalPrioritarioAux.setYhcif(yhcif);
			docEsCanalPrioritarioAux.setYhtedesfile(yhtedesfile);

			docEsCanalPrioritarioAux.setYhdatafileinputstream(file.getInputStream());
			docEsCanalPrioritarioAux.setYhcontenttypefile(file.getContentType());
			docEsCanalPrioritarioAux.setYhnofile(file.getOriginalFilename());
			docEsCanalPrioritarioAux.setYhsizefile((int) file.getSize());
			docEsCanalPrioritarioAux.setYhfecalta(new Date());

			this.docsEsCanalPrioritarioService.addTemp(docEsCanalPrioritarioAux);

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			filesMetaInfo.add(this.getFileReturnMap(file));
			// return filesMetaInfo;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 *
	 * Metodos para la Gestion de Tabla de Docs Fin
	 *
	 */

	/**
	 *
	 * @param file
	 *            MultipartFile
	 * @return mapa
	 */
	private Map<String, Object> getFileReturnMap(MultipartFile file) {
		Map<String, Object> mapaRetorno = new HashMap<String, Object>();
		mapaRetorno.put("url",
				"/y41bVistaWar/docsEsCanalPrioritario/anyadirDocsEsCanalPrioritario/" + file.getOriginalFilename());
		mapaRetorno.put("name", file.getOriginalFilename());
		mapaRetorno.put("type", file.getContentType());
		mapaRetorno.put("size", file.getSize());
		mapaRetorno.put("delete_url",
				"/y41bVistaWar/docsEsCanalPrioritario/anyadirDocsEsCanalPrioritario/" + file.getOriginalFilename());
		mapaRetorno.put("delete_type", "DELETE");
		return mapaRetorno;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param thcodocumento
	 *            Long
	 * @param establecimiento
	 *            Establecimiento
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/guardarDocsEsCanalPrioritario/{esCif}", method = RequestMethod.POST)
	public void guardarDocsEsCanalPrioritario(@PathVariable String esCif,
			@ModelAttribute Establecimiento establecimiento, HttpServletResponse response) {

		try {

			// EstablecimientoDetalle establecimientoDetalle = new
			// EstablecimientoDetalle();
			// establecimientoDetalle =
			// this.establecimientoService.findEstablecimiento(establecimiento);

			EsCanalPrioritario esCanalPrioritario = new EsCanalPrioritario();
			esCanalPrioritario.setYgcif(esCif);

			this.docsEsCanalPrioritarioService.guardarDocsEsCanalPrioritario(esCanalPrioritario);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'remove'.
	 *
	 * @param thcodocumento
	 *            Long
	 * @param establecimiento
	 *            Establecimiento
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarDocsEsCanalPrioritarioTemp/{esCif}", method = RequestMethod.POST)
	public void eliminarDocsEsCanalPrioritarioTemp(@PathVariable String esCif,
			@ModelAttribute Establecimiento establecimiento, HttpServletResponse response) {

		try {

			// EstablecimientoDetalle establecimientoDetalle = new
			// EstablecimientoDetalle();
			// establecimientoDetalle =
			// this.establecimientoService.findEstablecimiento(establecimiento);

			EsCanalPrioritario esCanalPrioritario = new EsCanalPrioritario();
			esCanalPrioritario.setYgcif(esCif);

			this.docsEsCanalPrioritarioService.eliminarDocsEsCanalPrioritario(esCanalPrioritario);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	//
	// /**
	// * Method 'getAllTipoDocs'.
	// *
	// * @param request
	// * HttpServletRequest
	// * @return String
	// */
	// @RequestMapping(value = "/findAllTipoDocs", method = RequestMethod.GET)
	// public @ResponseBody() Object getAllTipoDocs(HttpServletRequest request)
	// {
	// try {
	//
	// List<EstTipoDoc> listEstTipoDoc = null;
	//
	// listEstTipoDoc = this.docsEstablecimientoService.findAllTipoDocs();
	//
	// if (listEstTipoDoc == null) {
	// throw new Exception("No data Found.");
	// }
	// return listEstTipoDoc;
	//
	// } catch (Y41bUDAException e) {
	// throw e;
	// } catch (Exception e) {
	// throw new Y41bUDAException("error.generico", true, e);
	// }
	// }
	//

}