package com.ejie.y41b.control;

import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.rowset.serial.SerialBlob;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DocCensoTemp;
import com.ejie.y41b.service.DocCensoTempService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * DocCensoTempController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/doccensotemp")
public class DocCensoTempController {

	private static final Logger logger = LoggerFactory.getLogger(DocCensoTempController.class);

	@Autowired()
	private DocCensoTempService docCensoTempService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		DocCensoTempController.logger.info("[GET - View] : doccensotemp");
		return "adjuntarDocCenso";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param eacodocumento
	 *            Long
	 * @return docCensoTemp DocCensoTemp
	 */
	@RequestMapping(value = "/{eacodocumento}", method = RequestMethod.GET)
	public @ResponseBody() DocCensoTemp getById(@PathVariable() Long eacodocumento) {
		DocCensoTemp docCensoTemp = new DocCensoTemp();
		docCensoTemp.setEacodocumento(eacodocumento);
		docCensoTemp = this.docCensoTempService.find(docCensoTemp);
		DocCensoTempController.logger.info("[GET - findBy_PK] : Obtener DocCensoTemp por PK");
		return docCensoTemp;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterDocCensoTemp
	 *            DocCensoTemp
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody() List<DocCensoTemp> getAll(@ModelAttribute() DocCensoTemp filterDocCensoTemp) {
		DocCensoTempController.logger.info("[GET - find_ALL] : Obtener DocCensoTemp por filtro");
		return this.docCensoTempService.findAll(filterDocCensoTemp, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param docCensoTemp
	 *            DocCensoTemp
	 * @return DocCensoTemp
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody() DocCensoTemp edit(@RequestBody() DocCensoTemp docCensoTemp) {
		DocCensoTemp docCensoTempAux = this.docCensoTempService.update(docCensoTemp);
		DocCensoTempController.logger.info("[PUT] : DocCensoTemp actualizado correctamente");
		return docCensoTempAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param docCensoTemp
	 *            DocCensoTemp
	 * @return DocCensoTemp
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody() DocCensoTemp add(@RequestBody() DocCensoTemp docCensoTemp) {
		DocCensoTemp docCensoTempAux = this.docCensoTempService.add(docCensoTemp);
		DocCensoTempController.logger.info("[POST] : DocCensoTemp insertado correctamente");
		return docCensoTempAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param eacodocumento
	 *            Long
	 * @return docCensoTemp
	 */
	@RequestMapping(value = "/{eacodocumento}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody() DocCensoTemp remove(@PathVariable() Long eacodocumento) {
		DocCensoTemp docCensoTemp = new DocCensoTemp();
		docCensoTemp.setEacodocumento(eacodocumento);
		this.docCensoTempService.remove(docCensoTemp);
		DocCensoTempController.logger.info("[DELETE] : DocCensoTemp borrado correctamente");
		return docCensoTemp;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param docCensoTempIds
	 *            List
	 * @return docCensoTempList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody() List<List<String>> removeMultiple(@RequestBody() List<List<String>> docCensoTempIds) {
		List<DocCensoTemp> docCensoTempList = new ArrayList<DocCensoTemp>();
		for (List<String> docCensoTempId : docCensoTempIds) {
			Iterator<String> iterator = docCensoTempId.iterator();
			DocCensoTemp docCensoTemp = new DocCensoTemp(); // NOPMD - Objeto
															// nuevo en la lista
															// (parametro del
															// servicio)
			docCensoTemp.setEacodocumento(ObjectConversionManager.convert(iterator.next(), Long.class));
			docCensoTempList.add(docCensoTemp);
		}
		this.docCensoTempService.removeMultiple(docCensoTempList);
		DocCensoTempController.logger.info("[POST - DELETE_ALL] : DocCensoTemp borrados correctamente");
		return docCensoTempIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterDocCensoTemp
	 *            DocCensoTemp
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody() JQGridJSONModel getAllJQGrid(@ModelAttribute() DocCensoTemp filterDocCensoTemp,
			@ModelAttribute() Pagination pagination) {
		List<DocCensoTemp> docCensoTemps = this.docCensoTempService.findAll(filterDocCensoTemp, pagination);
		Long recordNum = this.docCensoTempService.findAllCount(filterDocCensoTemp);
		DocCensoTempController.logger.info("[GET - jqGrid] : Obtener DocCensoTemp");
		return new JQGridJSONModel(pagination, recordNum, docCensoTemps);
	}

	/**
	 * Method 'anyadir'.
	 * 
	 * @param file
	 *            MultipartFile
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return List<Map<String, Object>>
	 */
	@RequestMapping(value = "/anyadir", method = RequestMethod.POST)
	public @ResponseBody() List<Map<String, Object>> anyadir(
			@RequestParam(value = "files[]", required = false) MultipartFile file, HttpServletResponse response,
			HttpServletRequest request) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			DocCensoTemp doccensotemp = new DocCensoTemp();

			doccensotemp.setEafecalta(new Date());
			doccensotemp.setEausualta(censoMonitor.getMocodigo());

			String tedesfile = request.getParameter("eatedesfile");

			Blob blob = new SerialBlob(file.getBytes());
			doccensotemp.setEadatafile(blob);
			doccensotemp.setEaconttype(file.getContentType());
			doccensotemp.setEanofile(file.getOriginalFilename());
			doccensotemp.setEasizefile((int) file.getSize());

			doccensotemp.setEatedesfile(tedesfile);

			doccensotemp.setEacoentidad(request.getParameter("eacoentidad"));
			doccensotemp.setEatipoentidad(request.getParameter("eatipoentidad"));

			DocCensoTemp docCensoTempAux = this.add(doccensotemp);

			DocCensoTempController.logger.info("Entity correctly inserted!" + docCensoTempAux);

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			filesMetaInfo.add(this.getFileReturnMap(file));
			return filesMetaInfo;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * @param file
	 *            MultipartFile
	 * @return mapa
	 */
	private Map<String, Object> getFileReturnMap(MultipartFile file) {
		Map<String, Object> mapaRetorno = new HashMap<String, Object>();
		mapaRetorno.put("url", "/y41bVistaWar/doccensotemp/anyadir/" + file.getOriginalFilename());
		mapaRetorno.put("name", file.getOriginalFilename());
		mapaRetorno.put("type", file.getContentType());
		mapaRetorno.put("size", file.getSize());
		mapaRetorno.put("delete_url", "/y41bVistaWar/doccensotemp/anyadir/" + file.getOriginalFilename());
		mapaRetorno.put("delete_type", "DELETE");
		return mapaRetorno;
	}

	/**
	 * Method 'getByIdDocumento'.
	 * 
	 * @param codocumento
	 *            Long
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findDoc/{codocumento}", method = RequestMethod.GET)
	public @ResponseBody() void getByIdDocumento(@PathVariable() Long codocumento, HttpServletResponse response) {
		try {
			DocCensoTemp docCensoTemp = new DocCensoTemp();
			docCensoTemp.setEacodocumento(codocumento);
			docCensoTemp = this.docCensoTempService.find(docCensoTemp);

			DocCensoTemp docCensoTempAux = (DocCensoTemp) this.docCensoTempService.findLobTablaTemporal(docCensoTemp);

			Blob contenido = docCensoTempAux.getEadatafile();
			// byte[] bContenido = contenido.getBytes(1, (int)
			// contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(docCensoTemp.getEanofile()) + "\"");
			response.setContentType(docCensoTemp.getEaconttype());
			response.setContentLength(docCensoTemp.getEasizefile());
			// response.getOutputStream().write(bContenido);
			Y41bUtils.copyStream(contenido.getBinaryStream(), response.getOutputStream());

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

}
