package com.ejie.y41b.control;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.model.DocCenso;
import com.ejie.y41b.service.DocCensoService;

/**
 * DocCensoController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/doccenso")
public class DocCensoController {

	private static final Logger logger = LoggerFactory
			.getLogger(DocCensoController.class);

	@Autowired()
	private DocCensoService docCensoService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		DocCensoController.logger.info("[GET - View] : doccenso");
		return "doccenso";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param eacodocumento
	 *            Long
	 * @return docCenso DocCenso
	 */
	@RequestMapping(value = "/{eacodocumento}", method = RequestMethod.GET)
	public @ResponseBody()
	DocCenso getById(@PathVariable() Long eacodocumento) {
		DocCenso docCenso = new DocCenso();
		docCenso.setEacodocumento(eacodocumento);
		docCenso = this.docCensoService.find(docCenso);
		DocCensoController.logger
				.info("[GET - findBy_PK] : Obtener DocCenso por PK");
		return docCenso;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterDocCenso
	 *            DocCenso
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<DocCenso> getAll(@ModelAttribute() DocCenso filterDocCenso) {
		DocCensoController.logger
				.info("[GET - find_ALL] : Obtener DocCenso por filtro");
		return this.docCensoService.findAll(filterDocCenso, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param docCenso
	 *            DocCenso
	 * @return DocCenso
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	DocCenso edit(@RequestBody() DocCenso docCenso) {
		DocCenso docCensoAux = this.docCensoService.update(docCenso);
		DocCensoController.logger
				.info("[PUT] : DocCenso actualizado correctamente");
		return docCensoAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param docCenso
	 *            DocCenso
	 * @return DocCenso
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	DocCenso add(@RequestBody() DocCenso docCenso) {
		DocCenso docCensoAux = this.docCensoService.add(docCenso);
		DocCensoController.logger
				.info("[POST] : DocCenso insertado correctamente");
		return docCensoAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param eacodocumento
	 *            Long
	 * @return docCenso
	 */
	@RequestMapping(value = "/{eacodocumento}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	DocCenso remove(@PathVariable() Long eacodocumento) {
		DocCenso docCenso = new DocCenso();
		docCenso.setEacodocumento(eacodocumento);
		this.docCensoService.remove(docCenso);
		DocCensoController.logger
				.info("[DELETE] : DocCenso borrado correctamente");
		return docCenso;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param docCensoIds
	 *            List
	 * @return docCensoList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(
			@RequestBody() List<List<String>> docCensoIds) {
		List<DocCenso> docCensoList = new ArrayList<DocCenso>();
		for (List<String> docCensoId : docCensoIds) {
			Iterator<String> iterator = docCensoId.iterator();
			DocCenso docCenso = new DocCenso(); // NOPMD - Objeto nuevo en la
												// lista (parametro del
												// servicio)
			docCenso.setEacodocumento(ObjectConversionManager.convert(
					iterator.next(), Long.class));
			docCensoList.add(docCenso);
		}
		this.docCensoService.removeMultiple(docCensoList);
		DocCensoController.logger
				.info("[POST - DELETE_ALL] : DocCenso borrados correctamente");
		return docCensoIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterDocCenso
	 *            DocCenso
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(@ModelAttribute() DocCenso filterDocCenso,
			@ModelAttribute() Pagination pagination) {
		List<DocCenso> docCensos = this.docCensoService.findAll(filterDocCenso,
				pagination);
		Long recordNum = this.docCensoService.findAllCount(filterDocCenso);
		DocCensoController.logger.info("[GET - jqGrid] : Obtener DocCenso");
		return new JQGridJSONModel(pagination, recordNum, docCensos);
	}

}
