package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.DistribuidorService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.Distribuidor;

/**
 * DistribuidorController  
 *  
 */
 
@Controller
@RequestMapping (value = "/distribuidor")

public class DistribuidorController  {

	private static final Logger logger = LoggerFactory.getLogger(DistribuidorController.class);

	@Autowired
	private DistribuidorService distribuidorService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		DistribuidorController.logger.info("[GET - View] : distribuidor");
		return "distribuidor";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param rdcodigo String
	 * @return distribuidor Distribuidor
	 */
	@RequestMapping(value = "/{rdcodigo}", method = RequestMethod.GET)
	public @ResponseBody Distribuidor getById(@PathVariable String rdcodigo) {
        Distribuidor distribuidor = new Distribuidor();
		distribuidor.setRdcodigo(rdcodigo);
        distribuidor = this.distribuidorService.find(distribuidor);
        DistribuidorController.logger.info("[GET - findBy_PK] : Obtener Distribuidor por PK");
        return distribuidor;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterDistribuidor Distribuidor
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Distribuidor> getAll(@ModelAttribute Distribuidor filterDistribuidor) {
		DistribuidorController.logger.info("[GET - find_ALL] : Obtener Distribuidor por filtro");
	    return this.distribuidorService.findAll(filterDistribuidor, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param distribuidor Distribuidor 
	 * @return Distribuidor
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody Distribuidor edit(@RequestBody Distribuidor distribuidor) {		
        Distribuidor distribuidorAux = this.distribuidorService.update(distribuidor);
		DistribuidorController.logger.info("[PUT] : Distribuidor actualizado correctamente");
        return distribuidorAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param distribuidor Distribuidor 
	 * @return Distribuidor
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Distribuidor add(@RequestBody Distribuidor distribuidor) {		
        Distribuidor distribuidorAux = this.distribuidorService.add(distribuidor);
        DistribuidorController.logger.info("[POST] : Distribuidor insertado correctamente");
    	return distribuidorAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param rdcodigo String
	 * @return distribuidor
	 */
	@RequestMapping(value = "/{rdcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody Distribuidor remove(@PathVariable String rdcodigo) {
        Distribuidor distribuidor = new Distribuidor();
        distribuidor.setRdcodigo(rdcodigo);
        this.distribuidorService.remove(distribuidor);
       	DistribuidorController.logger.info("[DELETE] : Distribuidor borrado correctamente");
       	return distribuidor;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param distribuidorIds List
	 * @return distribuidorList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> distribuidorIds) {
        List<Distribuidor> distribuidorList = new ArrayList<Distribuidor>();
        for (List<String> distribuidorId:distribuidorIds) {
		    Iterator<String> iterator = distribuidorId.iterator();
		    Distribuidor distribuidor = new Distribuidor(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        distribuidor.setRdcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
		    distribuidorList.add(distribuidor);
	    }
        this.distribuidorService.removeMultiple(distribuidorList);
		DistribuidorController.logger.info("[POST - DELETE_ALL] : Distribuidor borrados correctamente");
		return distribuidorIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterDistribuidor Distribuidor
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute Distribuidor filterDistribuidor, @ModelAttribute Pagination pagination) {
        List<Distribuidor> distribuidors = this.distribuidorService.findAll(filterDistribuidor, pagination);
        Long recordNum = this.distribuidorService.findAllCount(filterDistribuidor);
        DistribuidorController.logger.info("[GET - jqGrid] : Obtener Distribuidor");
		return new JQGridJSONModel(pagination, recordNum, distribuidors);
	}
	
}	
