package com.ejie.y41b.control;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Descriptor;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Producto;
import com.ejie.y41b.model.Sector;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.service.DenunciaService;
import com.ejie.y41b.service.DescriptorService;
import com.ejie.y41b.service.EstablecimientoService;
import com.ejie.y41b.service.ExpedienService;
import com.ejie.y41b.service.ProductoService;
import com.ejie.y41b.service.SectorService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.tree.Y41bDescriptoresTree;

/**
 * * DescriptorController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/descriptor")
@SessionAttributes({ "codDescriptor", "modoBusquedaDescriptor",
		"modoDescriptor" })
public class DescriptorController {

	private static final Logger logger = LoggerFactory
			.getLogger(DescriptorController.class);

	@Autowired
	private DescriptorService descriptorService;

	@Autowired
	private SectorService sectorService;

	@Autowired
	private ProductoService productoService;

	@Autowired
	private EstablecimientoService establecimientoService;

	@Autowired
	private DenunciaService denunciaService;

	@Autowired
	private ExpedienService expedienService;

	@Autowired
	private Properties appConfiguration;

	@Resource
	private ReloadableResourceBundleMessageSource appMessageSource;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormMantenimiento'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "descriptores", method = RequestMethod.GET)
	public ModelAndView getCreateFormMantenimiento(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modoBusquedaDescriptor", "");

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("descriptores", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "seleccionDescriptores", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modoBusquedaDescriptor",
				Y41bConstantes.MODO_POPUP_SELECCION);

		return new ModelAndView("seleccionDescriptores", "model", model);
	}

	/**
	 * Method 'getCreateFormAltaDescriptor'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "altaDescriptor", method = RequestMethod.GET)
	public ModelAndView getCreateFormAltaDescriptor(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("codDescriptor", Y41bUIDGenerator.getInstance()
				.generateId(Y41bConstantes.PK_SIZE));

		model.addAttribute("modoDescriptor", Y41bConstantes.MODO_POPUP_ALTA);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleDescriptor", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormModDescriptor'.
	 * 
	 * @param codDescriptor
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "modDescriptor/{codDescriptor}", method = RequestMethod.GET)
	public ModelAndView getCreateFormModDescriptor(
			@PathVariable String codDescriptor, Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("codDescriptor", codDescriptor);

		model.addAttribute("modoDescriptor",
				Y41bConstantes.MODO_POPUP_MODIFICACION);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleDescriptor", "model", model);
		}
	}

	/**
	 * Loading Main tree de la lista de descriptors
	 * 
	 * @param nombreDescriptor_
	 *            String
	 * @param origenDescriptors
	 *            String
	 * @param modoDescriptors
	 *            String
	 * @param idOrigen
	 *            String
	 * @param idsDescriptorsSeleccionadas
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @throws IOException
	 *             IOException
	 */
	@RequestMapping(value = "arbolDescriptores", method = RequestMethod.GET)
	public void showListaDescriptors(
			@RequestParam(value = "nombreDescriptor", required = false) String nombreDescriptor_,
			@RequestParam(value = "origenDescriptores", required = false) String origenDescriptors,
			@RequestParam(value = "modoDescriptores", required = false) String modoDescriptors,
			@RequestParam(value = "idOrigen", required = false) String idOrigen,
			@RequestParam(value = "idsDescriptoresSeleccionadas", required = false) String idsDescriptorsSeleccionadas,
			HttpServletResponse response) throws IOException {
		try {

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			response.setContentType("text/html;charset=utf-8");
			PrintWriter out = response.getWriter();

			String nombreDescriptor = ("".equals(nombreDescriptor_)) ? null
					: nombreDescriptor_;
			Descriptor descriptor = new Descriptor();
			descriptor.setNombre(nombreDescriptor);

			// Obtiene lista completa de descriptors
			List<Descriptor> lstDescriptorsCompletas = this.descriptorService
					.findAllLike(descriptor, null, false);

			// Se inicializa la lista de descriptors seleccionadas
			List<String> selectedIdList = new ArrayList<String>();

			// rellenar la lista de descriptors con las que ya vienen
			// seleccionadas
			String[] arrIdsDescriptorsSeleccionadas;
			String strDelimitador = ",";
			if (idsDescriptorsSeleccionadas != null) {
				arrIdsDescriptorsSeleccionadas = idsDescriptorsSeleccionadas
						.split(strDelimitador);
				for (int i = 0; i < arrIdsDescriptorsSeleccionadas.length; i++)
					selectedIdList.add(arrIdsDescriptorsSeleccionadas[i]);
			}

			// Se inicializa la lista de descriptores del origen
			List<Descriptor> lstDescriptoresOrigen = null;

			// MODO : busqueda / edicion
			if (modoDescriptors.equalsIgnoreCase("modificacion")) {
				// Se obtiene la lista de etiquetas del origen
				if (origenDescriptors.equalsIgnoreCase("sector")) {
					// con el codigo de sector se monta el objeto y se hace la
					// consulta
					// del
					// mismo
					Sector sector = new Sector();
					sector.setSecodigo(idOrigen);

					lstDescriptoresOrigen = this.sectorService
							.findAllSectorDescriptor(sector, null);
					// se recorre para obtener los ids de etiquetas
					for (Descriptor descriptorAux : lstDescriptoresOrigen) {
						selectedIdList.add(descriptorAux.getIdDescriptor());
					}
				} else if (origenDescriptors.equalsIgnoreCase("producto")) {
					// con el codigo de producto se monta el objeto y se hace la
					// consulta
					// del
					// mismo
					Producto producto = new Producto();
					producto.setPscodigo(idOrigen);

					lstDescriptoresOrigen = this.productoService
							.findAllProductoDescriptor(producto, null);
					// se recorre para obtener los ids de etiquetas
					for (Descriptor descriptorAux : lstDescriptoresOrigen) {
						selectedIdList.add(descriptorAux.getIdDescriptor());
					}
				} else if (origenDescriptors
						.equalsIgnoreCase("establecimiento")) {
					// con el codigo de establecimiento se monta el objeto y se
					// hace la
					// consulta
					// del
					// mismo
					Establecimiento establecimiento = new Establecimiento();
					establecimiento.setEscodigo(idOrigen);

					lstDescriptoresOrigen = this.establecimientoService
							.findAllEstablecimientoDescriptor(establecimiento,
									null);
					// se recorre para obtener los ids de etiquetas
					for (Descriptor descriptorAux : lstDescriptoresOrigen) {
						selectedIdList.add(descriptorAux.getIdDescriptor());
					}
				} else if (origenDescriptors.equalsIgnoreCase("solicitud")) {
					// con el codigo de hecho denunciado se monta el objeto y se
					// hace la
					// consulta
					// del
					// mismo
					SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
					solicitudDetalle.setHdcodigo(idOrigen);

					lstDescriptoresOrigen = this.denunciaService
							.findAllHechoDenunciadoDescriptor(solicitudDetalle,
									null);
					// se recorre para obtener los ids de etiquetas
					for (Descriptor descriptorAux : lstDescriptoresOrigen) {
						selectedIdList.add(descriptorAux.getIdDescriptor());
					}
				} else if (origenDescriptors.equalsIgnoreCase("sancion")) {
					// con el codigo de sancionador se monta el objeto y se
					// hace la consulta del mismo
					Expedien expedien = new Expedien();
					expedien.setExcodigo(idOrigen);

					lstDescriptoresOrigen = this.expedienService
							.findAllSancionDescriptor(expedien, null);
					// se recorre para obtener los ids de etiquetas
					for (Descriptor descriptorAux : lstDescriptoresOrigen) {
						selectedIdList.add(descriptorAux.getIdDescriptor());
					}
				}

			}

			String json = Y41bDescriptoresTree.obtieneJsonArbol(
					lstDescriptorsCompletas, selectedIdList);
			out.println(json);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new ResourceNotFoundException(idOrigen);
		}

	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idDescriptor
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{idDescriptor}", method = RequestMethod.GET)
	public @ResponseBody
	Descriptor getById(@PathVariable String idDescriptor) {
		try {
			Descriptor descriptor = new Descriptor();
			descriptor.setIdDescriptor(idDescriptor);
			descriptor = this.descriptorService.find(descriptor);
			if (descriptor == null) {
				throw new Exception(idDescriptor.toString());
			}
			return descriptor;
		} catch (Exception e) {
			throw new ResourceNotFoundException(idDescriptor.toString());
		}
	}

	/**
	 * Method 'getDescriptorById'.
	 * 
	 * @param idDescriptor
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "findDescriptor/{idDescriptor}", method = RequestMethod.GET)
	public @ResponseBody
	Descriptor getDescriptorById(@PathVariable String idDescriptor) {
		try {
			Descriptor descriptor = new Descriptor();
			descriptor.setIdDescriptor(idDescriptor);

			descriptor = this.descriptorService.find(descriptor);
			if (descriptor == null) {
				throw new Exception(idDescriptor.toString());
			}
			return descriptor;
		} catch (Exception e) {
			throw new ResourceNotFoundException(idDescriptor.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param idDescriptor
	 *            String
	 * @param nombre
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "idDescriptor", required = false) String idDescriptor,
			@RequestParam(value = "nombre", required = false) String nombre,
			HttpServletRequest request) {
		try {
			Descriptor filterDescriptor = new Descriptor(idDescriptor, nombre);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Descriptor> descriptors = this.descriptorService.findAll(
						filterDescriptor, pagination);

				if (descriptors == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterDescriptor, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(descriptors);
				return data;
			} else {
				List<Descriptor> descriptors = this.descriptorService.findAll(
						filterDescriptor, pagination);
				if (descriptors == null) {
					throw new Exception("No data Found.");
				}
				return descriptors;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllLike'.
	 * 
	 * @param idDescriptor_
	 *            String
	 * @param nombre_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/like", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllLike(
			@RequestParam(value = "idDescriptor", required = false) String idDescriptor_,
			@RequestParam(value = "nombre", required = false) String nombre_,
			HttpServletRequest request) {
		try {
			String idDescriptor = ("".equals(idDescriptor_)) ? null
					: idDescriptor_;
			String nombre = ("".equals(nombre_)) ? null : nombre_;

			Descriptor filterDescriptor = new Descriptor(idDescriptor, nombre);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Descriptor> descriptors = this.descriptorService
						.findAllLike(filterDescriptor, pagination, false);

				if (descriptors == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.descriptorService.findAllLikeCount(
						filterDescriptor, false);

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(descriptors);
				return data;
			} else {
				List<Descriptor> descriptors = this.descriptorService
						.findAllLike(filterDescriptor, pagination, false);
				if (descriptors == null) {
					throw new Exception("No data Found.");
				}
				return descriptors;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterDescriptor
	 *            Descriptor
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "descriptor", required = false) Descriptor filterDescriptor,
			HttpServletRequest request) {
		try {
			return descriptorService
					.findAllCount(filterDescriptor != null ? filterDescriptor
							: new Descriptor());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @param response
	 *            HttpServletResponse
	 * @return Descriptor
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Descriptor edit(@RequestBody Descriptor descriptor,
			HttpServletResponse response) {
		try {
			Descriptor descriptorAux = this.descriptorService
					.update(descriptor);
			logger.info("Entity correctly inserted!");
			return descriptorAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'editDescriptor'.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @param response
	 *            HttpServletResponse
	 * @return Descriptor
	 */
	@RequestMapping(value = "/updateDescriptor", method = RequestMethod.PUT)
	public @ResponseBody
	Descriptor editDescriptor(@RequestBody Descriptor descriptor,
			HttpServletResponse response) {
		try {
			Descriptor descriptorAux = this.descriptorService
					.updateDescriptor(descriptor);
			logger.info("Entity correctly inserted!");
			return descriptorAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @return Descriptor
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Descriptor add(@RequestBody Descriptor descriptor) {
		try {
			Descriptor descriptorAux = this.descriptorService.add(descriptor);
			logger.info("Entity correctly inserted!");
			return descriptorAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'addDescriptor'.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @return Descriptor
	 */
	@RequestMapping(value = "/addDescriptor", method = RequestMethod.POST)
	public @ResponseBody
	Descriptor addDescriptor(@RequestBody Descriptor descriptor) {
		try {
			Descriptor descriptorAux = this.descriptorService
					.addDescriptor(descriptor);
			logger.info("Entity correctly inserted!");
			return descriptorAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idDescriptor
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return
	 */
	@RequestMapping(value = "/{idDescriptor}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String idDescriptor,
			HttpServletResponse response, HttpServletRequest request) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Descriptor descriptor = new Descriptor();
			descriptor.setIdDescriptor(idDescriptor);
			this.descriptorService.remove(descriptor);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {

			// Obtener el mensaje dependiendo del idioma
			Locale locale = LocaleContextHolder.getLocale();
			String msgError = appMessageSource.getMessage(
					"error.descriptor.usada", null, locale);

			logger.error("Unable to delete " + idDescriptor);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException(msgError);
		}
	}

	/**
	 * Method 'removeDescriptor'.
	 * 
	 * @param idDescriptor
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "removeDescriptor/{idDescriptor}", method = RequestMethod.DELETE)
	public void removeDescriptor(@PathVariable String idDescriptor,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Descriptor descriptor = new Descriptor();
			descriptor.setIdDescriptor(idDescriptor);
			this.descriptorService.removeDescriptor(descriptor);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			logger.error("Unable to delete " + idDescriptor);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param descriptorIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> descriptorIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Descriptor> descriptorList = new ArrayList<Descriptor>();
		try {
			for (ArrayList<String> descriptorId : descriptorIds) {
				Iterator<String> iterator = descriptorId.iterator();
				Descriptor descriptor = new Descriptor();
				descriptor.setIdDescriptor(ObjectConversionManager.convert(
						iterator.next(), String.class));
				descriptorList.add(descriptor);
			}
			this.descriptorService.removeMultiple(descriptorList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'fusionarDescriptor'.
	 * 
	 * @param idDescriptor
	 *            String
	 * @param descriptorIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/fusionarDescriptor", method = RequestMethod.POST)
	public void fusionarDescriptor(
			@RequestParam(value = "idDescriptor", required = true) String idDescriptor,
			@RequestBody ArrayList<String> descriptorIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");

		ArrayList<Descriptor> descriptorList = new ArrayList<Descriptor>();
		try {

			for (String descriptorId : descriptorIds) {
				Descriptor descriptor = new Descriptor();
				descriptor.setIdDescriptor(descriptorId);
				descriptorList.add(descriptor);
			}

			Descriptor descriptor = new Descriptor();
			descriptor.setIdDescriptor(idDescriptor);

			this.descriptorService.fusionDescriptor(descriptor, descriptorList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			logger.error(e.getMessage());
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException(e.getMessage());
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getDescriptorService'.
	 * 
	 * @return DescriptorService
	 */
	protected DescriptorService getDescriptorService() {
		return this.descriptorService;
	}

	/**
	 * Method 'setDescriptorService'.
	 * 
	 * @param descriptorService
	 *            DescriptorService
	 * @return
	 */
	public void setDescriptorService(DescriptorService descriptorService) {
		this.descriptorService = descriptorService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

}
