// CHECKSTYLE:OFF
package com.ejie.y41b.control;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.adapter.Y41bPifAdapterService;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.AsientoRegistral;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Consumidor;
import com.ejie.y41b.model.DecisionHechoDetalle;
import com.ejie.y41b.model.Denuncia;
import com.ejie.y41b.model.Descriptor;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.DocumentoHechoDetalle;
import com.ejie.y41b.model.FormaPresentacion;
import com.ejie.y41b.model.HechoDenunciado;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.PlantillaSolicitudDetalle;
import com.ejie.y41b.model.PosibleTramite;
import com.ejie.y41b.model.SolicitudArbitrajeDetalle;
import com.ejie.y41b.model.SolicitudBusqueda;
import com.ejie.y41b.model.SolicitudCambioInstructor;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.SolicitudEnvios;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteHechoDetalle;
import com.ejie.y41b.model.TramiteHechoDetalleKnet;
import com.ejie.y41b.model.platea.RegistroEntrada;
import com.ejie.y41b.service.DenunciaService;
import com.ejie.y41b.service.PosibleTramiteService;
import com.ejie.y41b.service.SantramexpService;
import com.ejie.y41b.service.SoltramexpService;
import com.ejie.y41b.service.Y41bExcelGeneratorService;
import com.ejie.y41b.utils.Y41bStringUtils;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.utils.documentos.Y41bDocumento;
import com.ejie.y41b.utils.documentos.Y41bGenerarDocumento;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.fichero.Y41bFicheroUtils;

/**
 * * DenunciaController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/denuncia")
@SessionAttributes({ "solicitudBusqueda", "solicitudDetalle", "asientoRegistral" })
public class DenunciaController {

	private static final Logger logger = LoggerFactory.getLogger(DenunciaController.class);

	@Autowired
	private DenunciaService denunciaService;

	@Autowired
	private PosibleTramiteService posibleTramiteService;

	@Autowired
	private SoltramexpService soltramexpService;

	@Autowired
	private Y41bExcelGeneratorService y41bExcelGeneratorService;

	@Autowired
	private Properties appConfiguration;

	@Autowired()
	private Y41bPifAdapterService y41bPifAdapterService;

	@Autowired
	private SantramexpService santramexpService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */
	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("denuncia", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bTabsBusquedaResultadoSolicitudes", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bTabsBusquedaResultadoSolicitudes(Model model, HttpServletRequest request) {

		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo("");

		model.addAttribute("solicitudDetalle", solicitudDetalle);

		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		// precarga de los valores del conectado
		SolicitudBusqueda solicitudBusqueda = new SolicitudBusqueda();

		String codOrg = "";

		if (censoMonitor.getOrganismo() != null) {
			codOrg = censoMonitor.getOrganismo().getCodOrg();
		}

		solicitudBusqueda.setCodOrgSeleccionado(codOrg);
		solicitudBusqueda.setIndIncluirCerrados(Y41bConstantes.VALOR_SI);

		Calendar now = Calendar.getInstance();
		int year = now.get(Calendar.YEAR);

		solicitudBusqueda.setDenran(new BigDecimal(year));
		model.addAttribute("solicitudBusqueda", solicitudBusqueda);
		model.addAttribute("solicitudAccesoDesde", Y41bConstantes.SOLICITUDES_ACCESO_DESDE_SOLICITUD);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bTabsBusquedaResultadoSolicitudes", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bTabsBusquedaResultadoSolicitudesCon", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bTabsBusquedaResultadoSolicitudesCon(Model model, HttpServletRequest request) {

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (!model.containsAttribute("solicitudBusqueda")) {
			// precarga de los valores del conectado
			SolicitudBusqueda solicitudBusqueda = new SolicitudBusqueda();

			String codOrg = "";

			if (censoMonitor.getOrganismo() != null) {
				codOrg = censoMonitor.getOrganismo().getCodOrg();
			}

			solicitudBusqueda.setCodOrgSeleccionado(codOrg);
			solicitudBusqueda.setIndIncluirCerrados(Y41bConstantes.VALOR_SI);
			model.addAttribute("solicitudBusqueda", solicitudBusqueda);
		}

		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("solicitudAccesoDesde", Y41bConstantes.SOLICITUDES_ACCESO_DESDE_SOLICITUD);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bTabsBusquedaResultadoSolicitudes", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bTabsBusquedaResultadoSolicitudesModal", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bTabsBusquedaResultadoSolicitudesModal(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("solicitudAccesoDesde", Y41bConstantes.SOLICITUDES_ACCESO_DESDE_TODOS);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("y41bTabsBusquedaResultadoSolicitudesModal", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bTabsBusquedaResultadoSolicitudesCon/y41bTabBusquedaSolicitudes", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bTabBusquedaSolicitudes(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bTabBusquedaSolicitudes", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bTabsBusquedaResultadoSolicitudesCon/y41bTabResultadoSolicitudes", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bTabResultadoSolicitudes(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bTabResultadoSolicitudes", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bTabsDetalleSolicitudNormal", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bTabsDetalleSolicitudNormal(Model model, HttpServletRequest request) {

		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo("");

		model.addAttribute("solicitudDetalle", solicitudDetalle);

		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("solicitudAccesoDesde", Y41bConstantes.SOLICITUDES_ACCESO_DESDE_SOLICITUD);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		httpSession.setAttribute("desde", Y41bConstantes.DESDE_INICIO);

		if (censoMonitor.getPerfilSolicitudes() == null
				|| censoMonitor.getPerfilSolicitudes().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)
				|| censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_CONSULTAS)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bTabsDetalleSolicitudNormal", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bTabsDetalleSolicitudModal", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bTabsDetalleSolicitudModal(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("solicitudAccesoDesde", Y41bConstantes.SOLICITUDES_ACCESO_DESDE_SOLICITUD);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("y41bTabsDetalleSolicitudModal", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bTabsBusquedaResultadoSolicitudesCon/y41bDetalleSolicitud/{hdcodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bDetalleSolicitud(@PathVariable String hdcodigo, Model model,
			HttpServletRequest request) {

		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(hdcodigo);

		model.addAttribute("solicitudDetalle", solicitudDetalle);

		model.addAttribute("defaultLanguage", appConfiguration.get("z99aVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("z99aVistaWar.default.layout"));
		model.addAttribute("solicitudAccesoDesde", Y41bConstantes.SOLICITUDES_ACCESO_DESDE_SOLICITUD);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		httpSession.setAttribute("desde", Y41bConstantes.DESDE_DETALLE);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bTabsDetalleSolicitudNormal", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bTabsBusquedaResultadoSolicitudesCon/y41bDetalleSolicitudSinCabecera/{hdcodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bDetalleSolicitudSinCabecera(@PathVariable String hdcodigo, Model model,
			HttpServletRequest request) {

		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(hdcodigo);

		model.addAttribute("solicitudDetalle", solicitudDetalle);

		model.addAttribute("defaultLanguage", appConfiguration.get("z99aVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("z99aVistaWar.default.layout"));
		model.addAttribute("solicitudAccesoDesde", Y41bConstantes.SOLICITUDES_ACCESO_DESDE_SOLICITUD);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		httpSession.setAttribute("desde", Y41bConstantes.DESDE_DETALLE);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bTabsDetalleSolicitudNormalSinCabecera", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bDetalleSolicitud/{hdcodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bDetalleSolicitudEscritorio(@PathVariable String hdcodigo, Model model,
			HttpServletRequest request) {

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(hdcodigo);

		// Comprobamos si el codigo introducido se trata de una denuncia AACC /
		// Empresa. Si es asi, la redirigimos a la url correcta.
		solicitudDetalle = this.denunciaService.findSolicitud(solicitudDetalle, censoMonitor);
		if (solicitudDetalle != null && solicitudDetalle.getHddenunciaaaccempresas() != null
				&& solicitudDetalle.getHddenunciaaaccempresas().equals(Y41bConstantes.VALOR_SI)) {
			return new ModelAndView("redirect:/denuncia/y41bTabsDetalleDenunciaAACC/" + hdcodigo);
		}

		model.addAttribute("solicitudDetalle", solicitudDetalle);

		model.addAttribute("defaultLanguage", appConfiguration.get("z99aVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("z99aVistaWar.default.layout"));
		model.addAttribute("solicitudAccesoDesde", Y41bConstantes.SOLICITUDES_ACCESO_DESDE_SOLICITUD);

		httpSession.setAttribute("desde", Y41bConstantes.DESDE_INICIO);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bTabsDetalleSolicitudNormal", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bDetalleSolicitudSinCabecera/{hdcodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bDetalleSolicitudEscritorioSinCabecera(@PathVariable String hdcodigo,
			Model model, HttpServletRequest request) {

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(hdcodigo);

		// Comprobamos si el codigo introducido se trata de una denuncia AACC /
		// Empresa. Si es asi, la redirigimos a la url correcta.
		solicitudDetalle = this.denunciaService.findSolicitud(solicitudDetalle, censoMonitor);
		if (solicitudDetalle != null && solicitudDetalle.getHddenunciaaaccempresas() != null
				&& solicitudDetalle.getHddenunciaaaccempresas().equals(Y41bConstantes.VALOR_SI)) {
			return new ModelAndView("redirect:/denuncia/y41bTabsDetalleDenunciaAACC/" + hdcodigo);
		}

		model.addAttribute("solicitudDetalle", solicitudDetalle);

		model.addAttribute("defaultLanguage", appConfiguration.get("z99aVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("z99aVistaWar.default.layout"));
		model.addAttribute("solicitudAccesoDesde", Y41bConstantes.SOLICITUDES_ACCESO_DESDE_SOLICITUD);

		httpSession.setAttribute("desde", Y41bConstantes.DESDE_INICIO);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bTabsDetalleSolicitudNormalSinCabecera", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bSolicitudTramitacion", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bSolicitudTramitacion(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bSolicitudTramitacion", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "lupaBusquedaSolicitudes", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41blupaBusquedaSolicitudes(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("lupaBusquedaSolicitudes", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bSolicitudDocumentacion", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bSolicitudDocumentacion(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bSolicitudDocumentacion", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bSolicitudTramitacionDetalle", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bSolicitudTramitacionDetalle(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bSolicitudTramitacionDetalle", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bSolicitudDetalle", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bSolicitudDetalle(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bSolicitudDetalle", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bSolicitudTramitacionEmail", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bSolicitudTramitacionEmail(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bSolicitudTramitacionEmail", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bSolicitudTramitacionArbitraje", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bSolicitudTramitacionArbitraje(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("y41bSolicitudTramitacionArbitraje", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bSolicitudModificacionInstructor", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bSolicitudModificacionInstructor(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("y41bSolicitudModificacionInstructor", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bTabsBusquedaResultadoDenunciasAACC", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bTabsBusquedaResultadoDenunciasAACC(Model model, HttpServletRequest request) {

		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo("");

		model.addAttribute("solicitudDetalle", solicitudDetalle);

		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		// precarga de los valores del conectado
		SolicitudBusqueda solicitudBusqueda = new SolicitudBusqueda();

		String codOrg = "";

		if (censoMonitor.getOrganismo() != null) {
			codOrg = censoMonitor.getOrganismo().getCodOrg();
		}

		solicitudBusqueda.setCodOrgSeleccionado(codOrg);
		solicitudBusqueda.setIndIncluirCerrados(Y41bConstantes.VALOR_SI);

		Calendar now = Calendar.getInstance();
		int year = now.get(Calendar.YEAR);

		solicitudBusqueda.setDenran(new BigDecimal(year));
		model.addAttribute("solicitudBusqueda", solicitudBusqueda);
		model.addAttribute("solicitudAccesoDesde", Y41bConstantes.SOLICITUDES_ACCESO_DESDE_EMPRESA);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bTabsBusquedaResultadoSolicitudes", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bTabsBusquedaResultadoDenunciasAACCCon", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bTabsBusquedaResultadoDenunciasAACCCon(Model model,
			HttpServletRequest request) {

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (!model.containsAttribute("solicitudBusqueda")) {
			// precarga de los valores del conectado
			SolicitudBusqueda solicitudBusqueda = new SolicitudBusqueda();

			String codOrg = "";

			if (censoMonitor.getOrganismo() != null) {
				codOrg = censoMonitor.getOrganismo().getCodOrg();
			}

			solicitudBusqueda.setCodOrgSeleccionado(codOrg);
			solicitudBusqueda.setIndIncluirCerrados(Y41bConstantes.VALOR_SI);
			model.addAttribute("solicitudBusqueda", solicitudBusqueda);
		}

		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("solicitudAccesoDesde", Y41bConstantes.SOLICITUDES_ACCESO_DESDE_EMPRESA);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bTabsBusquedaResultadoSolicitudes", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bTabsDetalleDenunciaAACC/{hdcodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bTabsDetalleDenunciaAACCModificacion(@PathVariable String hdcodigo, Model model,
			HttpServletRequest request) {
		return this.getCreateFormY41bTabsDetalleDenunciaAACCConModificacion(hdcodigo, model, request);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bTabsBusquedaResultadoDenunciasAACCCon/alta", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bTabsDetalleDenunciaAACCConAlta(Model model, HttpServletRequest request) {
		return this.getCreateFormY41bTabsDetalleDenunciaAACCAlta(model, request);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bTabsDetalleDenunciaAACCAlta", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bTabsDetalleDenunciaAACCAlta(Model model, HttpServletRequest request) {

		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo("");

		model.addAttribute("solicitudDetalle", solicitudDetalle);

		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("solicitudAccesoDesde", Y41bConstantes.SOLICITUDES_ACCESO_DESDE_EMPRESA);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		httpSession.setAttribute("desde", Y41bConstantes.DESDE_INICIO);

		if (censoMonitor.getPerfilSolicitudes() == null
				|| censoMonitor.getPerfilSolicitudes().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)
				|| censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_CONSULTAS)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bTabsDetalleSolicitudNormal", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bTabsBusquedaResultadoDenunciasAACCCon/detalle/{hdcodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bTabsDetalleDenunciaAACCConModificacion(@PathVariable String hdcodigo,
			Model model, HttpServletRequest request) {

		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(hdcodigo);

		model.addAttribute("solicitudDetalle", solicitudDetalle);

		model.addAttribute("defaultLanguage", appConfiguration.get("z99aVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("z99aVistaWar.default.layout"));
		model.addAttribute("solicitudAccesoDesde", Y41bConstantes.SOLICITUDES_ACCESO_DESDE_EMPRESA);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		httpSession.setAttribute("desde", Y41bConstantes.DESDE_DETALLE);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bTabsDetalleSolicitudNormal", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bTabsBusquedaResultadoDenunciasAACC/detalle/{hdcodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bTabsDetalleDenunciaAACCResultadosModificacion(@PathVariable String hdcodigo,
			Model model, HttpServletRequest request) {
		return this.getCreateFormY41bTabsDetalleDenunciaAACCModificacion(hdcodigo, model, request);
	}

	/**
	 * Method 'getByIdHecho'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * 
	 * 
	 * @return String
	 */
	@RequestMapping(value = "/getbyid/{hdcodigo}", method = RequestMethod.GET)
	public @ResponseBody SolicitudDetalle getByIdHecho(@PathVariable String hdcodigo, HttpServletRequest request) {
		try {

			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(hdcodigo);
			CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			solicitudDetalle = this.denunciaService.findSolicitud(solicitudDetalle, censoMonitor);

			if (solicitudDetalle == null) {
				throw new Exception(hdcodigo.toString());
			}
			return solicitudDetalle;
		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException(hdcodigo.toString());
		}
	}

	/**
	 * Method 'getByIdHecho'.
	 * 
	 * @param decoor
	 *            String
	 * @param denror
	 *            Long
	 * @param denran
	 *            Integer
	 * @param hdnror
	 *            Long
	 * @param request
	 *            HttpServletRequest
	 * 
	 * 
	 * @return String
	 */
	@RequestMapping(value = "/getHechoByNumExpediente/{decoor}/{denror}/{denran}/{hdnror}", method = RequestMethod.GET)
	public @ResponseBody SolicitudDetalle getHechoByNumExpediente(@PathVariable String decoor,
			@PathVariable Long denror, @PathVariable Integer denran, @PathVariable Long hdnror,
			HttpServletRequest request) {
		try {

			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setDecoor(decoor);
			solicitudDetalle.setDenror(denror);
			solicitudDetalle.setDenran(denran);
			solicitudDetalle.setHdnror(hdnror);
			CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			solicitudDetalle = this.denunciaService.findSolicitudByNumeroExpediente(solicitudDetalle, censoMonitor);

			if (solicitudDetalle == null) {
				throw new Exception(decoor.toString());
			}
			return solicitudDetalle;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException(decoor.toString());
		}
	}

	/**
	 * Method 'getArbitrajeByIdHecho'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/arbitraje/{hdcodigo}", method = RequestMethod.GET)
	public @ResponseBody SolicitudArbitrajeDetalle getArbitrajeByIdHecho(@PathVariable String hdcodigo) {
		try {

			SolicitudArbitrajeDetalle solicitudArbitrajeDetalle = new SolicitudArbitrajeDetalle();
			solicitudArbitrajeDetalle.setHdcodigo(hdcodigo);
			solicitudArbitrajeDetalle = this.denunciaService.findSolicitudArbitraje(solicitudArbitrajeDetalle);

			if (solicitudArbitrajeDetalle == null) {
				throw new Exception(hdcodigo.toString());
			}
			return solicitudArbitrajeDetalle;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new ResourceNotFoundException(hdcodigo.toString());
		}
	}

	/**
	 * Method 'getByIdTramitacion'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "/tramitacion/{hdcodigo}", method = RequestMethod.GET)
	public @ResponseBody Object getByIdTramitacion(@PathVariable String hdcodigo, HttpServletRequest request) {
		try {

			TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();
			tramiteHechoDetalle.setHdcodigo(hdcodigo);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<TramiteHechoDetalle> tramitesHecho = this.denunciaService.findAllTramiteHecho(tramiteHechoDetalle,
						pagination);

				if (tramitesHecho == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.denunciaService.findAllTramiteHechoCount(tramiteHechoDetalle);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(tramitesHecho);
				return data;
			} else {
				List<TramiteHechoDetalle> tramitesHecho = this.denunciaService.findAllTramiteHecho(tramiteHechoDetalle,
						pagination);
				if (tramitesHecho == null) {
					throw new Exception("No data Found.");
				}
				return tramitesHecho;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'eliminarTramite'.
	 * 
	 * @param ehcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/tramitacion/eliminarTramite/{ehcodigo}", method = RequestMethod.POST)
	public @ResponseBody void eliminarTramite(@PathVariable String ehcodigo, HttpServletRequest request) {
		try {
			this.soltramexpService.eliminarTramite(ehcodigo);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'reabrirExpediente'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/tramitacion/reabrirExpediente/{hdcodigo}", method = RequestMethod.POST)
	public @ResponseBody void reabrirExpediente(@PathVariable String hdcodigo, HttpServletRequest request) {
		try {
			CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			this.soltramexpService.reabrirExpediente(hdcodigo, censoMonitor);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getDecision'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "/tramitacion/getdecision/{hdcodigo}", method = RequestMethod.GET)
	public @ResponseBody Object getDecision(@PathVariable String hdcodigo, HttpServletRequest request) {
		try {

			DecisionHechoDetalle decisionHechoDetalle = new DecisionHechoDetalle();
			decisionHechoDetalle.setHdcodigo(hdcodigo);

			decisionHechoDetalle = this.denunciaService.findDecisionHecho(decisionHechoDetalle);

			if (decisionHechoDetalle == null) {
				throw new Exception("No data Found. /tramitacion/getdecision/{hdcodigo}");
			}
			return decisionHechoDetalle;

		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found. /tramitacion/getdecision/{hdcodigo}");
		}
	}

	/**
	 * Method 'getEtiquetaByCodHecho'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * 
	 */
	@RequestMapping(value = "/etiqueta/{hdcodigo}", method = RequestMethod.GET)
	public @ResponseBody void getEtiquetaByCodHecho(@PathVariable String hdcodigo, HttpServletResponse response) {
		try {

			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(hdcodigo);

			PlantillaSolicitudDetalle plantillaSolicitudDetalle = this.denunciaService
					.findPlantillaSolicitudDetalle(solicitudDetalle);
			if (plantillaSolicitudDetalle == null) {
				throw new Exception(hdcodigo.toString());
			}

			if (plantillaSolicitudDetalle.getHdte() != null) {
				plantillaSolicitudDetalle
						.setHdte(plantillaSolicitudDetalle.getHdte().replaceAll("\n", "&lineSeparator;"));
				plantillaSolicitudDetalle.setHdte(
						plantillaSolicitudDetalle.getHdte().replaceAll("", "&euro;").replaceAll("\u20AC", "&euro;"));
				plantillaSolicitudDetalle.setHdte(
						Y41bStringUtils.unescapeHTML(Y41bUtils.eliminarTags(plantillaSolicitudDetalle.getHdte()), 0));
			}

			if (plantillaSolicitudDetalle.getHdteso() != null) {
				plantillaSolicitudDetalle
						.setHdteso(plantillaSolicitudDetalle.getHdteso().replaceAll("\n", "&lineSeparator;"));
				plantillaSolicitudDetalle.setHdteso(
						plantillaSolicitudDetalle.getHdteso().replaceAll("", "&euro;").replaceAll("\u20AC", "&euro;"));
				plantillaSolicitudDetalle.setHdteso(
						Y41bStringUtils.unescapeHTML(Y41bUtils.eliminarTags(plantillaSolicitudDetalle.getHdteso()), 0));
			}

			String rutaRTF = (String) appConfiguration.get("y41bVistaWar.ruta.plantillas.word");
			String rutaXML = (String) appConfiguration.get("y41bVistaWar.rutaxml.plantillas.word");
			String nombreRTF = Y41bConstantes.NOMBRE_PLANTILLA_SOLICITUDES_ETIQUETA_RTF;
			String nombreXML = Y41bConstantes.NOMBRE_PLANTILLA_SOLICITUDES_ETIQUETA_XML;
			String rutaCompletaRTF = rutaRTF + nombreRTF;
			String rutaCompletaXML = rutaXML + nombreXML;

			String plantilla = new String(Y41bDocumento.leerArchivoOrigen(rutaCompletaRTF));

			String strFileDataDecode = Y41bGenerarDocumento.generarDocumentoWord(rutaCompletaXML,
					plantillaSolicitudDetalle, plantilla);

			byte[] bytesFichero = strFileDataDecode.getBytes();

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			String nombreFichero = plantillaSolicitudDetalle.getDecoor() + "-" + plantillaSolicitudDetalle.getDenror()
					+ "-" + plantillaSolicitudDetalle.getDenran() + ".rtf";

			// response.addHeader("Expires", "-1");

			// FIXME Esto se ha quitado porque sino en Internet Explorer produce
			// un error al mostrarse
			// response.setCharacterEncoding("ISO-8859-1");
			// response.setHeader("Cache-Control", "no-cache");

			response.setHeader("Content-Disposition", "attachment; filename=\"" + nombreFichero + "\"");
			response.setContentType("application/msword");
			response.setContentLength(bytesFichero.length);
			response.getOutputStream().write(bytesFichero);

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException(hdcodigo.toString());
		} catch (Throwable t) {
			t.printStackTrace();
			throw new ResourceNotFoundException(hdcodigo.toString());
		}
	}

	/**
	 * Method 'getFichaByCodHecho'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * 
	 */
	@RequestMapping(value = "/ficha/{hdcodigo}", method = RequestMethod.GET)
	public @ResponseBody void getFichaByCodHecho(@PathVariable String hdcodigo, HttpServletResponse response) {
		try {

			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(hdcodigo);

			PlantillaSolicitudDetalle plantillaSolicitudDetalle = this.denunciaService
					.findPlantillaSolicitudDetalle(solicitudDetalle);
			if (plantillaSolicitudDetalle == null) {
				throw new Exception(hdcodigo.toString());
			}

			if (plantillaSolicitudDetalle.getHdte() != null) {
				plantillaSolicitudDetalle
						.setHdte(plantillaSolicitudDetalle.getHdte().replaceAll("\n", "&lineSeparator;"));
				plantillaSolicitudDetalle.setHdte(
						plantillaSolicitudDetalle.getHdte().replaceAll("", "&euro;").replaceAll("\u20AC", "&euro;"));
				plantillaSolicitudDetalle.setHdte(
						Y41bStringUtils.unescapeHTML(Y41bUtils.eliminarTags(plantillaSolicitudDetalle.getHdte()), 0));
			}

			if (plantillaSolicitudDetalle.getHdteso() != null) {
				plantillaSolicitudDetalle
						.setHdteso(plantillaSolicitudDetalle.getHdteso().replaceAll("\n", "&lineSeparator;"));
				plantillaSolicitudDetalle.setHdteso(
						plantillaSolicitudDetalle.getHdteso().replaceAll("", "&euro;").replaceAll("\u20AC", "&euro;"));
				plantillaSolicitudDetalle.setHdteso(
						Y41bStringUtils.unescapeHTML(Y41bUtils.eliminarTags(plantillaSolicitudDetalle.getHdteso()), 0));
			}

			String rutaRTF = (String) appConfiguration.get("y41bVistaWar.ruta.plantillas.word");
			String rutaXML = (String) appConfiguration.get("y41bVistaWar.rutaxml.plantillas.word");
			String nombreRTF = Y41bConstantes.NOMBRE_PLANTILLA_SOLICITUDES_FICHA_RTF;
			String nombreXML = Y41bConstantes.NOMBRE_PLANTILLA_SOLICITUDES_FICHA_XML;
			String rutaCompletaRTF = rutaRTF + nombreRTF;
			String rutaCompletaXML = rutaXML + nombreXML;

			String plantilla = new String(Y41bDocumento.leerArchivoOrigen(rutaCompletaRTF));

			String strFileDataDecode = Y41bGenerarDocumento.generarDocumentoWord(rutaCompletaXML,
					plantillaSolicitudDetalle, plantilla);

			byte[] bytesFichero = strFileDataDecode.getBytes();

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			String nombreFichero = plantillaSolicitudDetalle.getDecoor() + "-" + plantillaSolicitudDetalle.getDenror()
					+ "-" + plantillaSolicitudDetalle.getDenran() + ".rtf";

			// response.addHeader("Expires", "-1");

			// FIXME Esto se ha quitado porque sino en Internet Explorer produce
			// un error al mostrarse
			// response.setCharacterEncoding("ISO-8859-1");
			// response.setHeader("Cache-Control", "no-cache");

			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(nombreFichero) + "\"");
			response.setContentType("application/msword");
			response.setContentLength(bytesFichero.length);
			response.getOutputStream().write(bytesFichero);

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException(hdcodigo.toString());
		} catch (Throwable t) {
			t.printStackTrace();
			throw new ResourceNotFoundException(hdcodigo.toString());
		}
	}

	/**
	 * Method 'getFichaByCodHecho'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * 
	 */
	@RequestMapping(value = "/fichareducida/{hdcodigo}", method = RequestMethod.GET)
	public @ResponseBody void getFichaReducidaByCodHecho(@PathVariable String hdcodigo, HttpServletResponse response) {
		try {

			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(hdcodigo);

			PlantillaSolicitudDetalle plantillaSolicitudDetalle = this.denunciaService
					.findPlantillaSolicitudDetalle(solicitudDetalle);
			if (plantillaSolicitudDetalle == null) {
				throw new Exception(hdcodigo.toString());
			}

			if (plantillaSolicitudDetalle.getHdte() != null) {
				plantillaSolicitudDetalle
						.setHdte(plantillaSolicitudDetalle.getHdte().replaceAll("\n", "&lineSeparator;"));
				plantillaSolicitudDetalle.setHdte(
						plantillaSolicitudDetalle.getHdte().replaceAll("", "&euro;").replaceAll("\u20AC", "&euro;"));
				plantillaSolicitudDetalle.setHdte(
						Y41bStringUtils.unescapeHTML(Y41bUtils.eliminarTags(plantillaSolicitudDetalle.getHdte()), 0));
			}

			if (plantillaSolicitudDetalle.getHdteso() != null) {
				plantillaSolicitudDetalle
						.setHdteso(plantillaSolicitudDetalle.getHdteso().replaceAll("\n", "&lineSeparator;"));
				plantillaSolicitudDetalle.setHdteso(
						plantillaSolicitudDetalle.getHdteso().replaceAll("", "&euro;").replaceAll("\u20AC", "&euro;"));
				plantillaSolicitudDetalle.setHdteso(
						Y41bStringUtils.unescapeHTML(Y41bUtils.eliminarTags(plantillaSolicitudDetalle.getHdteso()), 0));
			}

			String rutaRTF = (String) appConfiguration.get("y41bVistaWar.ruta.plantillas.word");
			String rutaXML = (String) appConfiguration.get("y41bVistaWar.rutaxml.plantillas.word");
			String nombreRTF = Y41bConstantes.NOMBRE_PLANTILLA_SOLICITUDES_FICHA_REDUCIDA_RTF;
			String nombreXML = Y41bConstantes.NOMBRE_PLANTILLA_SOLICITUDES_FICHA_REDUCIDA_XML;

			String rutaCompletaRTF = rutaRTF + nombreRTF;
			String rutaCompletaXML = rutaXML + nombreXML;

			String plantilla = new String(Y41bDocumento.leerArchivoOrigen(rutaCompletaRTF));

			String strFileDataDecode = Y41bGenerarDocumento.generarDocumentoWord(rutaCompletaXML,
					plantillaSolicitudDetalle, plantilla);

			byte[] bytesFichero = strFileDataDecode.getBytes();

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			String nombreFichero = plantillaSolicitudDetalle.getDecoor() + "-" + plantillaSolicitudDetalle.getDenror()
					+ "-" + plantillaSolicitudDetalle.getDenran() + ".rtf";

			// response.addHeader("Expires", "-1");

			// FIXME Esto se ha quitado porque sino en Internet Explorer produce
			// un error al mostrarse
			// response.setCharacterEncoding("ISO-8859-1");
			// response.setHeader("Cache-Control", "no-cache");

			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(nombreFichero) + "\"");
			response.setContentType("application/msword");
			response.setContentLength(bytesFichero.length);
			response.getOutputStream().write(bytesFichero);

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException(hdcodigo.toString());
		} catch (Throwable t) {
			t.printStackTrace();
			throw new ResourceNotFoundException(hdcodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param decodigo
	 *            String
	 * @param formaPresentacionTfpcodigo
	 *            String
	 * @param consumidorDtcodigo
	 *            String
	 * @param decocp
	 *            String
	 * @param decoor
	 *            String
	 * @param denran
	 *            BigDecimal
	 * @param denror
	 *            BigDecimal
	 * @param defede
	 *            Date
	 * @param defere
	 *            Date
	 * @param defeex
	 *            Date
	 * @param defeim
	 *            Date
	 * @param deinre
	 *            String
	 * @param denrrgen
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody Object getAll(@RequestParam(value = "decodigo", required = false) String decodigo,
			@RequestParam(value = "formaPresentacionTfpcodigo", required = false) String formaPresentacionTfpcodigo,
			@RequestParam(value = "consumidorDtcodigo", required = false) String consumidorDtcodigo,
			@RequestParam(value = "decocp", required = false) String decocp,
			@RequestParam(value = "decoor", required = false) String decoor,
			@RequestParam(value = "denran", required = false) Integer denran,
			@RequestParam(value = "denror", required = false) Long denror,
			@RequestParam(value = "defede", required = false) Date defede,
			@RequestParam(value = "defere", required = false) Date defere,
			@RequestParam(value = "defeex", required = false) Date defeex,
			@RequestParam(value = "defeim", required = false) Date defeim,
			@RequestParam(value = "deinre", required = false) String deinre,
			@RequestParam(value = "denrrgen", required = false) String denrrgen, HttpServletRequest request) {
		try {
			Denuncia filterDenuncia = new Denuncia(decodigo, decocp, decoor, denran, denror, defede, defere, defeex,
					defeim, deinre, denrrgen,
					new FormaPresentacion(formaPresentacionTfpcodigo, null, null, null, null, null, null),
					new Consumidor(consumidorDtcodigo, null, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
							null, null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Denuncia> denuncias = this.denunciaService.findAll(filterDenuncia, pagination);

				if (denuncias == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterDenuncia, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(denuncias);
				return data;
			} else {
				List<Denuncia> denuncias = this.denunciaService.findAll(filterDenuncia, pagination);
				if (denuncias == null) {
					throw new Exception("No data Found.");
				}
				return denuncias;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllSolicitud'.
	 * 
	 * @param hddenunciaaaccempresas_
	 *            String
	 * @param decoor_
	 *            String
	 * @param denror
	 *            BigDecimal
	 * @param denran
	 *            BigDecimal
	 * @param codOrg_
	 *            String
	 * @param mocodigoExpediente_
	 *            String
	 * @param defedeDesde_
	 *            String
	 * @param defedeHasta_
	 *            String
	 * @param hdcosc_
	 *            String
	 * @param defereDesde_
	 *            String
	 * @param defereHasta_
	 *            String
	 * @param tfpcodigo_
	 *            String
	 * @param idsDescriptores_
	 *            String
	 * @param descsDescriptores_
	 *            String
	 * @param hdformanotificacion_
	 *            String
	 * @param hdcodexpedienteorigen_
	 *            String
	 * @param numregistroentrada_
	 *            String
	 * @param hdtipodenunciante_
	 *            String
	 * @param prodAgrupadoE8codigo_
	 *            String
	 * @param productoPscodigo_
	 *            String
	 * @param productoPsnombre_
	 *            String
	 * @param motivoTircodigoCombo_
	 *            String
	 * @param motivoTircodigo_
	 *            String
	 * @param motivoTirnombre_
	 *            String
	 * @param fcodigo_
	 *            String
	 * @param trcodigo_
	 *            String
	 * @param decodigo_
	 *            String
	 * @param mocodigoTramitador_
	 *            String
	 * @param ehfechafinDecisionDesde_
	 *            String
	 * @param ehfechafinDecisionHasta_
	 *            String
	 * @param indUltimoTramite_
	 *            String
	 * @param indPendienteAcuse_
	 *            String
	 * @param indIncluirCerrados_
	 *            String
	 * @param indPendienteDecision_
	 *            String
	 * @param indPendienteFirma_
	 *            String
	 * @param dtnombre_
	 *            String
	 * @param dtapellido1_
	 *            String
	 * @param dtapellido2_
	 *            String
	 * @param dtnif_
	 *            String
	 * @param dtestado_
	 *            String
	 * @param dtnoraProvinciaId_
	 *            String
	 * @param dtnoraMunicipioId_
	 *            String
	 * @param dtnoraLocalidadId_
	 *            String
	 * @param dtextranjero_
	 *            String
	 * @param dtnoraPaisId_
	 *            String
	 * @param dtdireccion_nocapv_
	 *            String
	 * @param esnombre_
	 *            String
	 * @param esnif_
	 *            String
	 * @param esnoco_
	 *            String
	 * @param esestado_
	 *            String
	 * @param esnoraProvinciaId_
	 *            String
	 * @param esnoraMunicipioId_
	 *            String
	 * @param esnoraLocalidadId_
	 *            String
	 * @param esextranjero_
	 *            String
	 * @param esnoraPaisId_
	 *            String
	 * @param esdireccion_nocapv_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/busquedaSolicitudes", method = RequestMethod.GET)
	public @ResponseBody Object getAllSolicitud(@RequestParam(value = "origen", required = false) String origen,
			@RequestParam(value = "hddenunciaaaccempresas", required = false) String hddenunciaaaccempresas_,
			@RequestParam(value = "decoor", required = false) String decoor_,
			@RequestParam(value = "denror", required = false) BigDecimal denror,
			@RequestParam(value = "denran", required = false) BigDecimal denran,
			@RequestParam(value = "codOrg", required = false) String codOrg_,
			@RequestParam(value = "mocodigoExpediente", required = false) String mocodigoExpediente_,
			@RequestParam(value = "defedeDesde", required = false) String defedeDesde_,
			@RequestParam(value = "defedeHasta", required = false) String defedeHasta_,
			@RequestParam(value = "hdcosc", required = false) String hdcosc_,
			@RequestParam(value = "defereDesde", required = false) String defereDesde_,
			@RequestParam(value = "defereHasta", required = false) String defereHasta_,
			@RequestParam(value = "tfpcodigo", required = false) String tfpcodigo_,
			@RequestParam(value = "idsDescriptores", required = false) String idsDescriptores_,
			@RequestParam(value = "descsDescriptores", required = false) String descsDescriptores_,
			@RequestParam(value = "hdformanotificacion", required = false) String hdformanotificacion_,
			@RequestParam(value = "hdcodexpedienteorigen", required = false) String hdcodexpedienteorigen_,
			@RequestParam(value = "numregistroentrada", required = false) String numregistroentrada_,
			@RequestParam(value = "hdtipodenunciante", required = false) String hdtipodenunciante_,
			@RequestParam(value = "prodAgrupadoE8codigo", required = false) String prodAgrupadoE8codigo_,
			@RequestParam(value = "productoPscodigo", required = false) String productoPscodigo_,
			@RequestParam(value = "productoPsnombre", required = false) String productoPsnombre_,
			@RequestParam(value = "motivoTircodigoCombo", required = false) String motivoTircodigoCombo_,
			@RequestParam(value = "motivoTircodigo", required = false) String motivoTircodigo_,
			@RequestParam(value = "motivoTirnombre", required = false) String motivoTirnombre_,
			@RequestParam(value = "fcodigo", required = false) String fcodigo_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_,
			@RequestParam(value = "decodigo", required = false) String decodigo_,
			@RequestParam(value = "mocodigoTramitador", required = false) String mocodigoTramitador_,
			@RequestParam(value = "ehfechafinDecisionDesde", required = false) String ehfechafinDecisionDesde_,
			@RequestParam(value = "ehfechafinDecisionHasta", required = false) String ehfechafinDecisionHasta_,
			@RequestParam(value = "indUltimoTramite", required = false) String indUltimoTramite_,
			@RequestParam(value = "indPendienteAcuse", required = false) String indPendienteAcuse_,
			@RequestParam(value = "indIncluirCerrados", required = false) String indIncluirCerrados_,
			@RequestParam(value = "indPendienteDecision", required = false) String indPendienteDecision_,
			@RequestParam(value = "indPendienteFirma", required = false) String indPendienteFirma_,
			@RequestParam(value = "dtnombre", required = false) String dtnombre_,
			@RequestParam(value = "dtapellido1", required = false) String dtapellido1_,
			@RequestParam(value = "dtapellido2", required = false) String dtapellido2_,
			@RequestParam(value = "dtnif", required = false) String dtnif_,
			@RequestParam(value = "dtestado", required = false) String dtestado_,
			@RequestParam(value = "dtnoraProvinciaId", required = false) String dtnoraProvinciaId_,
			@RequestParam(value = "dtnoraMunicipioId", required = false) String dtnoraMunicipioId_,
			@RequestParam(value = "dtnoraLocalidadId", required = false) String dtnoraLocalidadId_,
			@RequestParam(value = "dtextranjero", required = false) String dtextranjero_,
			@RequestParam(value = "dtnoraPaisId", required = false) String dtnoraPaisId_,
			@RequestParam(value = "dtdireccion_nocapv", required = false) String dtdireccion_nocapv_,
			@RequestParam(value = "esnombre", required = false) String esnombre_,
			@RequestParam(value = "esnif", required = false) String esnif_,
			@RequestParam(value = "esnoco", required = false) String esnoco_,
			@RequestParam(value = "esestado", required = false) String esestado_,
			@RequestParam(value = "esnoraProvinciaId", required = false) String esnoraProvinciaId_,
			@RequestParam(value = "esnoraMunicipioId", required = false) String esnoraMunicipioId_,
			@RequestParam(value = "esnoraLocalidadId", required = false) String esnoraLocalidadId_,
			@RequestParam(value = "esextranjero", required = false) String esextranjero_,
			@RequestParam(value = "esnoraPaisId", required = false) String esnoraPaisId_,
			@RequestParam(value = "esdireccion_nocapv", required = false) String esdireccion_nocapv_,
			HttpServletRequest request, Model model) {
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date defereDesde = Y41bUtils.parseDate(defereDesde_, locale);
			Date defereHasta = Y41bUtils.parseDate(defereHasta_, locale);
			Date defedeDesde = Y41bUtils.parseDate(defedeDesde_, locale);
			Date defedeHasta = Y41bUtils.parseDate(defedeHasta_, locale);
			Date ehfechafinDecisionDesde = Y41bUtils.parseDate(ehfechafinDecisionDesde_, locale);
			Date ehfechafinDecisionHasta = Y41bUtils.parseDate(ehfechafinDecisionHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro
			String hddenunciaaaccempresas = ("".equals(hddenunciaaaccempresas_)) ? null : hddenunciaaaccempresas_;
			String decoor = ("".equals(decoor_)) ? null : decoor_;

			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			String mocodigoExpediente = ("".equals(mocodigoExpediente_)) ? null : mocodigoExpediente_;

			String hdcosc = ("".equals(hdcosc_)) ? null : hdcosc_;
			String tfpcodigo = ("".equals(tfpcodigo_)) ? null : tfpcodigo_;
			String idsDescriptores = ("".equals(idsDescriptores_)) ? null : idsDescriptores_;
			String descsDescriptores = ("".equals(descsDescriptores_)) ? null : descsDescriptores_;
			String hdformanotificacion = ("".equals(hdformanotificacion_)) ? null : hdformanotificacion_;
			String hdcodexpedienteorigen = ("".equals(hdcodexpedienteorigen_)) ? null : hdcodexpedienteorigen_;
			String numregistroentrada = ("".equals(numregistroentrada_)) ? null : numregistroentrada_;
			String hdtipodenunciante = ("".equals(hdtipodenunciante_)) ? null : hdtipodenunciante_;

			String productoPscodigo = ("".equals(productoPscodigo_)) ? null : productoPscodigo_;
			String productoPsnombre = ("".equals(productoPsnombre_)) ? null : productoPsnombre_;
			String motivoTircodigo = ("".equals(motivoTircodigoCombo_)) ? null : motivoTircodigoCombo_;

			if (motivoTircodigo == null) {
				motivoTircodigo = ("".equals(motivoTircodigo_)) ? null : motivoTircodigo_;
			}
			String motivoTirnombre = ("".equals(motivoTirnombre_)) ? null : motivoTirnombre_;

			String fcodigo = ("".equals(fcodigo_)) ? null : fcodigo_;
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;
			String decodigo = ("".equals(decodigo_)) ? null : decodigo_;
			String mocodigoTramitador = ("".equals(mocodigoTramitador_)) ? null : mocodigoTramitador_;

			// control checks
			String indUltimoTramite = ("on".equals(indUltimoTramite_)) ? Y41bConstantes.VALOR_SI : null;
			String indPendienteAcuse = ("on".equals(indPendienteAcuse_)) ? Y41bConstantes.VALOR_SI : null;
			String indIncluirCerrados = ("on".equals(indIncluirCerrados_)) ? Y41bConstantes.VALOR_SI : null;
			String indPendienteDecision = ("on".equals(indPendienteDecision_)) ? Y41bConstantes.VALOR_SI : null;
			String indPendienteFirma = ("on".equals(indPendienteFirma_)) ? Y41bConstantes.VALOR_SI : null;

			// cons
			String dtextranjero = null;
			String dtestado = null;
			String dtnoraPaisId = null;
			String dtnoraProvinciaId = null;
			String dtnoraMunicipioId = null;
			String dtnoraLocalidadId = null;
			String dtdireccion_nocapv = null;

			if (Y41bConstantes.NORA_LOCALIZACION_TODOS.equals(dtextranjero_)) {
				dtextranjero = null;
				dtnoraPaisId = null;
				dtestado = null;
				dtnoraProvinciaId = null;
				dtnoraMunicipioId = null;
				dtnoraLocalidadId = null;
				dtdireccion_nocapv = null;
			} else if (Y41bConstantes.NORA_LOCALIZACION_EXTRANJERO.equals(dtextranjero_)) {
				dtextranjero = Y41bConstantes.VALOR_SI;
				dtnoraPaisId = ("".equals(dtnoraPaisId_)) ? null : dtnoraPaisId_;
				dtestado = null;
				dtnoraProvinciaId = null;
				dtnoraMunicipioId = null;
				dtnoraLocalidadId = null;
				dtdireccion_nocapv = ("".equals(dtdireccion_nocapv_)) ? null : dtdireccion_nocapv_;

			} else if (Y41bConstantes.NORA_LOCALIZACION_ESTADO.equals(dtextranjero_)) {
				dtextranjero = null;
				dtnoraPaisId = null;
				dtestado = Y41bConstantes.VALOR_SI;
				dtnoraProvinciaId = ("".equals(dtnoraProvinciaId_)) ? null : dtnoraProvinciaId_;
				dtnoraMunicipioId = ("".equals(dtnoraMunicipioId_)) ? null : dtnoraMunicipioId_;
				dtnoraLocalidadId = ("".equals(dtnoraLocalidadId_)) ? null : dtnoraLocalidadId_;
				dtdireccion_nocapv = ("".equals(dtdireccion_nocapv_)) ? null : dtdireccion_nocapv_;
			}

			// est
			String esextranjero = null;
			String esestado = null;
			String esnoraPaisId = null;
			String esnoraProvinciaId = null;
			String esnoraMunicipioId = null;
			String esnoraLocalidadId = null;
			String esdireccion_nocapv = null;

			if (Y41bConstantes.NORA_LOCALIZACION_TODOS.equals(esextranjero_)) {
				esextranjero = null;
				esnoraPaisId = null;
				esestado = null;
				esnoraProvinciaId = null;
				esnoraMunicipioId = null;
				esnoraLocalidadId = null;
				esdireccion_nocapv = null;
			} else if (Y41bConstantes.NORA_LOCALIZACION_EXTRANJERO.equals(esextranjero_)) {
				esextranjero = Y41bConstantes.VALOR_SI;
				esnoraPaisId = ("".equals(esnoraPaisId_)) ? null : esnoraPaisId_;
				esestado = null;
				esnoraProvinciaId = null;
				esnoraMunicipioId = null;
				esnoraLocalidadId = null;
				esdireccion_nocapv = ("".equals(esdireccion_nocapv_)) ? null : esdireccion_nocapv_;

			} else if (Y41bConstantes.NORA_LOCALIZACION_ESTADO.equals(esextranjero_)) {
				esextranjero = null;
				esnoraPaisId = null;
				esestado = Y41bConstantes.VALOR_SI;
				esnoraProvinciaId = ("".equals(esnoraProvinciaId_)) ? null : esnoraProvinciaId_;
				esnoraMunicipioId = ("".equals(esnoraMunicipioId_)) ? null : esnoraMunicipioId_;
				esnoraLocalidadId = ("".equals(esnoraLocalidadId_)) ? null : esnoraLocalidadId_;
				esdireccion_nocapv = ("".equals(esdireccion_nocapv_)) ? null : esdireccion_nocapv_;
			}

			//

			String dtnombre = ("".equals(dtnombre_)) ? null : dtnombre_;
			String dtapellido1 = ("".equals(dtapellido1_)) ? null : dtapellido1_;
			String dtapellido2 = ("".equals(dtapellido2_)) ? null : dtapellido2_;
			String dtnif = ("".equals(dtnif_)) ? null : dtnif_;
			// String dtestado = ("".equals(dtestado_)) ? null : dtestado_;
			// String dtnoraProvinciaId = ("".equals(dtnoraProvinciaId_)) ? null
			// : dtnoraProvinciaId_;
			// String dtnoraMunicipioId = ("".equals(dtnoraMunicipioId_)) ? null
			// : dtnoraMunicipioId_;
			// String dtnoraLocalidadId = ("".equals(dtnoraLocalidadId_)) ? null
			// : dtnoraLocalidadId_;
			// String dtextranjero = ("".equals(dtextranjero_)) ? null
			// : dtextranjero_;
			// String dtnoraPaisId = ("".equals(dtnoraPaisId_)) ? null
			// : dtnoraPaisId_;
			// String dtdireccion_nocapv = ("".equals(dtdireccion_nocapv_)) ?
			// null
			// : dtdireccion_nocapv_;

			String esnombre = ("".equals(esnombre_)) ? null : esnombre_;
			String esnif = ("".equals(esnif_)) ? null : esnif_;
			String esnoco = ("".equals(esnoco_)) ? null : esnoco_;
			// String esestado = ("".equals(esestado_)) ? null : esestado_;
			// String esnoraProvinciaId = ("".equals(esnoraProvinciaId_)) ? null
			// : esnoraProvinciaId_;
			// String esnoraMunicipioId = ("".equals(esnoraMunicipioId_)) ? null
			// : esnoraMunicipioId_;
			// String esnoraLocalidadId = ("".equals(esnoraLocalidadId_)) ? null
			// : esnoraLocalidadId_;
			// String esextranjero = ("".equals(esextranjero_)) ? null
			// : esextranjero_;
			// String esnoraPaisId = ("".equals(esnoraPaisId_)) ? null
			// : esnoraPaisId_;
			// String esdireccion_nocapv = ("".equals(esdireccion_nocapv_)) ?
			// null
			// : esdireccion_nocapv_;

			CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			String codOrgConectado = censoMonitor.getOrganismo().getCodOrg();

			SolicitudBusqueda filterSolicitudBusqueda = new SolicitudBusqueda();
			filterSolicitudBusqueda.setOrigen(origen);
			filterSolicitudBusqueda.setHddenunciaaaccempresas(hddenunciaaaccempresas);
			filterSolicitudBusqueda.setDecoor(decoor);
			filterSolicitudBusqueda.setDenror(denror);
			filterSolicitudBusqueda.setDenran(denran);

			filterSolicitudBusqueda.setCodOrgSeleccionado(codOrg);
			filterSolicitudBusqueda.setMocodigoExpediente(mocodigoExpediente);

			filterSolicitudBusqueda.setDefedeDesde(defedeDesde);
			filterSolicitudBusqueda.setDefedeHasta(defedeHasta);

			filterSolicitudBusqueda.setHdcosc(hdcosc);

			filterSolicitudBusqueda.setDefereDesde(defereDesde);
			filterSolicitudBusqueda.setDefereHasta(defereHasta);

			filterSolicitudBusqueda.setTfpcodigo(tfpcodigo);

			List<Descriptor> descriptores = new ArrayList<Descriptor>();
			// Generar el listado listado de etiquetas (comun)
			if (null != idsDescriptores && !"".equals(idsDescriptores)) {
				Descriptor descriptor = null;
				for (String id : idsDescriptores.split(",")) {
					descriptor = new Descriptor();// NOPMD 2012/02/29 (IDA)
					descriptor.setIdDescriptor(id);
					descriptores.add(descriptor);
				}
			}
			filterSolicitudBusqueda.setDescriptores(descriptores);
			filterSolicitudBusqueda.setIdsDescriptores(idsDescriptores);
			filterSolicitudBusqueda.setDescsDescriptores(descsDescriptores);

			filterSolicitudBusqueda.setHdformanotificacion(hdformanotificacion);
			filterSolicitudBusqueda.setHdcodexpedienteorigen(hdcodexpedienteorigen);
			filterSolicitudBusqueda.setNumregistroentrada(numregistroentrada);

			filterSolicitudBusqueda.setHdtipodenunciante(hdtipodenunciante);

			filterSolicitudBusqueda.setPscodigo(productoPscodigo);
			filterSolicitudBusqueda.setPsnombre(productoPsnombre);
			filterSolicitudBusqueda.setTircodigo(motivoTircodigo);
			filterSolicitudBusqueda.setTirnombre(motivoTirnombre);

			filterSolicitudBusqueda.setFcodigo(fcodigo);
			filterSolicitudBusqueda.setTrcodigo(trcodigo);
			filterSolicitudBusqueda.setDecodigo(decodigo);
			filterSolicitudBusqueda.setMocodigoTramitador(mocodigoTramitador);

			filterSolicitudBusqueda.setEhfechafinDecisionDesde(ehfechafinDecisionDesde);
			filterSolicitudBusqueda.setEhfechafinDecisionHasta(ehfechafinDecisionHasta);

			filterSolicitudBusqueda.setIndUltimoTramite(indUltimoTramite);
			filterSolicitudBusqueda.setIndPendienteAcuse(indPendienteAcuse);
			filterSolicitudBusqueda.setIndIncluirCerrados(indIncluirCerrados);
			filterSolicitudBusqueda.setIndPendienteDecision(indPendienteDecision);
			filterSolicitudBusqueda.setIndPendienteFirma(indPendienteFirma);

			filterSolicitudBusqueda.setDtnombre(dtnombre);
			filterSolicitudBusqueda.setDtapellido1(dtapellido1);
			filterSolicitudBusqueda.setDtapellido2(dtapellido2);
			filterSolicitudBusqueda.setDtnif(dtnif);
			filterSolicitudBusqueda.setDtestado(dtestado);
			filterSolicitudBusqueda.setDtnoraProvinciaId(dtnoraProvinciaId);
			filterSolicitudBusqueda.setDtnoraMunicipioId(dtnoraMunicipioId);
			filterSolicitudBusqueda.setDtnoraLocalidadId(dtnoraLocalidadId);
			filterSolicitudBusqueda.setDtextranjero(dtextranjero);
			filterSolicitudBusqueda.setDtnoraPaisId(dtnoraPaisId);
			filterSolicitudBusqueda.setDtdireccion_nocapv(dtdireccion_nocapv);

			filterSolicitudBusqueda.setEsnombre(esnombre);
			filterSolicitudBusqueda.setEsnif(esnif);
			filterSolicitudBusqueda.setEsnoco(esnoco);
			filterSolicitudBusqueda.setEsestado(esestado);
			filterSolicitudBusqueda.setEsnoraProvinciaId(esnoraProvinciaId);
			filterSolicitudBusqueda.setEsnoraMunicipioId(esnoraMunicipioId);
			filterSolicitudBusqueda.setEsnoraLocalidadId(esnoraLocalidadId);
			filterSolicitudBusqueda.setEsextranjero(esextranjero);
			filterSolicitudBusqueda.setEsnoraPaisId(esnoraPaisId);
			filterSolicitudBusqueda.setEsdireccion_nocapv(esdireccion_nocapv);

			filterSolicitudBusqueda.setCodOrgConectado(codOrgConectado);

			// Ponemos los valores para la visualizacion de las fechas
			// correctamente Ini
			filterSolicitudBusqueda.setDefereDesdeStr(defereDesde_);
			filterSolicitudBusqueda.setDefereHastaStr(defereHasta_);
			filterSolicitudBusqueda.setDefedeDesdeStr(defedeDesde_);
			filterSolicitudBusqueda.setDefedeHastaStr(defedeHasta_);
			filterSolicitudBusqueda.setEhfechafinDecisionDesdeStr(ehfechafinDecisionDesde_);
			filterSolicitudBusqueda.setEhfechafinDecisionHastaStr(ehfechafinDecisionHasta_);
			// Ponemos los valores para la visualizacion de las fechas
			// correctamente Fin

			model.addAttribute("solicitudBusqueda", filterSolicitudBusqueda);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<SolicitudBusqueda> solicitudesBusqueda = this.denunciaService
						.findAllLikeSolicitudes(filterSolicitudBusqueda, pagination, false);

				if (solicitudesBusqueda == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.denunciaService.findAllLikeSolicitudesCount(filterSolicitudBusqueda, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(solicitudesBusqueda);
				return data;
			} else {
				List<SolicitudBusqueda> solicitudesBusqueda = this.denunciaService
						.findAllLikeSolicitudes(filterSolicitudBusqueda, pagination, false);
				if (solicitudesBusqueda == null) {
					throw new Exception("No data Found.");
				}
				return solicitudesBusqueda;
			}
		} catch (Exception e) {
			logger.error("###########################ERROR BUSQUEDA SOLICITUDES", e);
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Metodo para generar un archivo excel con los filtrados correspondientes *
	 * 
	 * @param hddenunciaaaccempresas_
	 *            String
	 * @param decoor_
	 *            String
	 * @param denror_
	 *            BigDecimal
	 * @param denran
	 *            BigDecimal
	 * @param codOrg_
	 *            String
	 * @param mocodigoExpediente_
	 *            String
	 * @param defedeDesde_
	 *            String
	 * @param defedeHasta_
	 *            String
	 * @param hdcosc_
	 *            String
	 * @param defereDesde_
	 *            String
	 * @param defereHasta_
	 *            String
	 * @param tfpcodigo_
	 *            String
	 * @param idsDescriptores_
	 *            String
	 * @param descsDescriptores_
	 *            String
	 * @param hdformanotificacion_
	 *            String
	 * @param hdcodexpedienteorigen_
	 *            String
	 * @param numregistroentrada_
	 *            String
	 * @param hdtipodenunciante_
	 *            String
	 * @param prodAgrupadoE8codigo_
	 *            String
	 * @param productoPscodigo_
	 *            String
	 * @param productoPsnombre_
	 *            String
	 * @param motivoTircodigoCombo_
	 *            String
	 * @param motivoTircodigo_
	 *            String
	 * @param motivoTirnombre_
	 *            String
	 * @param fcodigo_
	 *            String
	 * @param trcodigo_
	 *            String
	 * @param decodigo_
	 *            String
	 * @param mocodigoTramitador_
	 *            String
	 * @param ehfechafinDecisionDesde_
	 *            String
	 * @param ehfechafinDecisionHasta_
	 *            String
	 * @param indUltimoTramite_
	 *            String
	 * @param indPendienteAcuse_
	 *            String
	 * @param indIncluirCerrados_
	 *            String
	 * @param indPendienteDecision_
	 *            String
	 * @param indPendienteFirma_
	 *            String
	 * @param dtnombre_
	 *            String
	 * @param dtapellido1_
	 *            String
	 * @param dtapellido2_
	 *            String
	 * @param dtnif_
	 *            String
	 * @param dtestado_
	 *            String
	 * @param dtnoraProvinciaId_
	 *            String
	 * @param dtnoraMunicipioId_
	 *            String
	 * @param dtnoraLocalidadId_
	 *            String
	 * @param dtextranjero_
	 *            String
	 * @param dtnoraPaisId_
	 *            String
	 * @param dtdireccion_nocapv_
	 *            String
	 * @param esnombre_
	 *            String
	 * @param esnif_
	 *            String
	 * @param esnoco_
	 *            String
	 * @param esestado_
	 *            String
	 * @param esnoraProvinciaId_
	 *            String
	 * @param esnoraMunicipioId_
	 *            String
	 * @param esnoraLocalidadId_
	 *            String
	 * @param esextranjero_
	 *            String
	 * @param esnoraPaisId_
	 *            String
	 * @param esdireccion_nocapv_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excel", method = RequestMethod.GET)
	public void getAllSolicitudExcel(@RequestParam(value = "origen", required = false) String origen,
			@RequestParam(value = "hddenunciaaaccempresas", required = false) String hddenunciaaaccempresas_,
			@RequestParam(value = "decoor", required = false) String decoor_,
			@RequestParam(value = "denror", required = false) BigDecimal denror,
			@RequestParam(value = "denran", required = false) BigDecimal denran,
			@RequestParam(value = "codOrg", required = false) String codOrg_,
			@RequestParam(value = "mocodigoExpediente", required = false) String mocodigoExpediente_,
			@RequestParam(value = "defedeDesde", required = false) String defedeDesde_,
			@RequestParam(value = "defedeHasta", required = false) String defedeHasta_,
			@RequestParam(value = "hdcosc", required = false) String hdcosc_,
			@RequestParam(value = "defereDesde", required = false) String defereDesde_,
			@RequestParam(value = "defereHasta", required = false) String defereHasta_,
			@RequestParam(value = "tfpcodigo", required = false) String tfpcodigo_,
			@RequestParam(value = "idsDescriptores", required = false) String idsDescriptores_,
			@RequestParam(value = "descsDescriptores", required = false) String descsDescriptores_,
			@RequestParam(value = "hdformanotificacion", required = false) String hdformanotificacion_,
			@RequestParam(value = "hdcodexpedienteorigen", required = false) String hdcodexpedienteorigen_,
			@RequestParam(value = "numregistroentrada", required = false) String numregistroentrada_,
			@RequestParam(value = "hdtipodenunciante", required = false) String hdtipodenunciante_,
			@RequestParam(value = "prodAgrupadoE8codigo", required = false) String prodAgrupadoE8codigo_,
			@RequestParam(value = "productoPscodigo", required = false) String productoPscodigo_,
			@RequestParam(value = "productoPsnombre", required = false) String productoPsnombre_,
			@RequestParam(value = "motivoTircodigoCombo", required = false) String motivoTircodigoCombo_,
			@RequestParam(value = "motivoTircodigo", required = false) String motivoTircodigo_,
			@RequestParam(value = "motivoTirnombre", required = false) String motivoTirnombre_,
			@RequestParam(value = "fcodigo", required = false) String fcodigo_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_,
			@RequestParam(value = "decodigo", required = false) String decodigo_,
			@RequestParam(value = "mocodigoTramitador", required = false) String mocodigoTramitador_,
			@RequestParam(value = "ehfechafinDecisionDesde", required = false) String ehfechafinDecisionDesde_,
			@RequestParam(value = "ehfechafinDecisionHasta", required = false) String ehfechafinDecisionHasta_,
			@RequestParam(value = "indUltimoTramite", required = false) String indUltimoTramite_,
			@RequestParam(value = "indPendienteAcuse", required = false) String indPendienteAcuse_,
			@RequestParam(value = "indIncluirCerrados", required = false) String indIncluirCerrados_,
			@RequestParam(value = "indPendienteDecision", required = false) String indPendienteDecision_,
			@RequestParam(value = "indPendienteFirma", required = false) String indPendienteFirma_,
			@RequestParam(value = "dtnombre", required = false) String dtnombre_,
			@RequestParam(value = "dtapellido1", required = false) String dtapellido1_,
			@RequestParam(value = "dtapellido2", required = false) String dtapellido2_,
			@RequestParam(value = "dtnif", required = false) String dtnif_,
			@RequestParam(value = "dtestado", required = false) String dtestado_,
			@RequestParam(value = "dtnoraProvinciaId", required = false) String dtnoraProvinciaId_,
			@RequestParam(value = "dtnoraMunicipioId", required = false) String dtnoraMunicipioId_,
			@RequestParam(value = "dtnoraLocalidadId", required = false) String dtnoraLocalidadId_,
			@RequestParam(value = "dtextranjero", required = false) String dtextranjero_,
			@RequestParam(value = "dtnoraPaisId", required = false) String dtnoraPaisId_,
			@RequestParam(value = "dtdireccion_nocapv", required = false) String dtdireccion_nocapv_,
			@RequestParam(value = "esnombre", required = false) String esnombre_,
			@RequestParam(value = "esnif", required = false) String esnif_,
			@RequestParam(value = "esnoco", required = false) String esnoco_,
			@RequestParam(value = "esestado", required = false) String esestado_,
			@RequestParam(value = "esnoraProvinciaId", required = false) String esnoraProvinciaId_,
			@RequestParam(value = "esnoraMunicipioId", required = false) String esnoraMunicipioId_,
			@RequestParam(value = "esnoraLocalidadId", required = false) String esnoraLocalidadId_,
			@RequestParam(value = "esextranjero", required = false) String esextranjero_,
			@RequestParam(value = "esnoraPaisId", required = false) String esnoraPaisId_,
			@RequestParam(value = "esdireccion_nocapv", required = false) String esdireccion_nocapv_,
			HttpServletRequest request, HttpServletResponse response) {
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date defereDesde = Y41bUtils.parseDate(defereDesde_, locale);
			Date defereHasta = Y41bUtils.parseDate(defereHasta_, locale);
			Date defedeDesde = Y41bUtils.parseDate(defedeDesde_, locale);
			Date defedeHasta = Y41bUtils.parseDate(defedeHasta_, locale);
			Date ehfechafinDecisionDesde = Y41bUtils.parseDate(ehfechafinDecisionDesde_, locale);
			Date ehfechafinDecisionHasta = Y41bUtils.parseDate(ehfechafinDecisionHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro
			String hddenunciaaaccempresas = ("".equals(hddenunciaaaccempresas_)) ? null : hddenunciaaaccempresas_;
			String decoor = ("".equals(decoor_)) ? null : decoor_;

			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			String mocodigoExpediente = ("".equals(mocodigoExpediente_)) ? null : mocodigoExpediente_;

			String hdcosc = ("".equals(hdcosc_)) ? null : hdcosc_;
			String tfpcodigo = ("".equals(tfpcodigo_)) ? null : tfpcodigo_;
			String idsDescriptores = ("".equals(idsDescriptores_)) ? null : idsDescriptores_;
			String descsDescriptores = ("".equals(descsDescriptores_)) ? null : descsDescriptores_;
			String hdformanotificacion = ("".equals(hdformanotificacion_)) ? null : hdformanotificacion_;
			String hdcodexpedienteorigen = ("".equals(hdcodexpedienteorigen_)) ? null : hdcodexpedienteorigen_;
			String numregistroentrada = ("".equals(numregistroentrada_)) ? null : numregistroentrada_;
			String hdtipodenunciante = ("".equals(hdtipodenunciante_)) ? null : hdtipodenunciante_;

			String productoPscodigo = ("".equals(productoPscodigo_)) ? null : productoPscodigo_;
			String productoPsnombre = ("".equals(productoPsnombre_)) ? null : productoPsnombre_;
			String motivoTircodigo = ("".equals(motivoTircodigoCombo_)) ? null : motivoTircodigoCombo_;

			if (motivoTircodigo == null) {
				motivoTircodigo = ("".equals(motivoTircodigo_)) ? null : motivoTircodigo_;
			}
			String motivoTirnombre = ("".equals(motivoTirnombre_)) ? null : motivoTirnombre_;

			String fcodigo = ("".equals(fcodigo_)) ? null : fcodigo_;
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;
			String decodigo = ("".equals(decodigo_)) ? null : decodigo_;
			String mocodigoTramitador = ("".equals(mocodigoTramitador_)) ? null : mocodigoTramitador_;

			// control checks
			String indUltimoTramite = ("on".equals(indUltimoTramite_)) ? Y41bConstantes.VALOR_SI : null;
			String indPendienteAcuse = ("on".equals(indPendienteAcuse_)) ? Y41bConstantes.VALOR_SI : null;
			String indIncluirCerrados = ("on".equals(indIncluirCerrados_)) ? Y41bConstantes.VALOR_SI : null;
			String indPendienteDecision = ("on".equals(indPendienteDecision_)) ? Y41bConstantes.VALOR_SI : null;
			String indPendienteFirma = ("on".equals(indPendienteFirma_)) ? Y41bConstantes.VALOR_SI : null;

			// cons
			String dtextranjero = null;
			String dtestado = null;
			String dtnoraPaisId = null;
			String dtnoraProvinciaId = null;
			String dtnoraMunicipioId = null;
			String dtnoraLocalidadId = null;
			String dtdireccion_nocapv = null;

			if (Y41bConstantes.NORA_LOCALIZACION_TODOS.equals(dtextranjero_)) {
				dtextranjero = null;
				dtnoraPaisId = null;
				dtestado = null;
				dtnoraProvinciaId = null;
				dtnoraMunicipioId = null;
				dtnoraLocalidadId = null;
				dtdireccion_nocapv = null;
			} else if (Y41bConstantes.NORA_LOCALIZACION_EXTRANJERO.equals(dtextranjero_)) {
				dtextranjero = Y41bConstantes.VALOR_SI;
				dtnoraPaisId = ("".equals(dtnoraPaisId_)) ? null : dtnoraPaisId_;
				dtestado = null;
				dtnoraProvinciaId = null;
				dtnoraMunicipioId = null;
				dtnoraLocalidadId = null;
				dtdireccion_nocapv = ("".equals(dtdireccion_nocapv_)) ? null : dtdireccion_nocapv_;

			} else if (Y41bConstantes.NORA_LOCALIZACION_ESTADO.equals(dtextranjero_)) {
				dtextranjero = null;
				dtnoraPaisId = null;
				dtestado = Y41bConstantes.VALOR_SI;
				dtnoraProvinciaId = ("".equals(dtnoraProvinciaId_)) ? null : dtnoraProvinciaId_;
				dtnoraMunicipioId = ("".equals(dtnoraMunicipioId_)) ? null : dtnoraMunicipioId_;
				dtnoraLocalidadId = ("".equals(dtnoraLocalidadId_)) ? null : dtnoraLocalidadId_;
				dtdireccion_nocapv = ("".equals(dtdireccion_nocapv_)) ? null : dtdireccion_nocapv_;
			}

			// est
			String esextranjero = null;
			String esestado = null;
			String esnoraPaisId = null;
			String esnoraProvinciaId = null;
			String esnoraMunicipioId = null;
			String esnoraLocalidadId = null;
			String esdireccion_nocapv = null;

			if (Y41bConstantes.NORA_LOCALIZACION_TODOS.equals(esextranjero_)) {
				esextranjero = null;
				esnoraPaisId = null;
				esestado = null;
				esnoraProvinciaId = null;
				esnoraMunicipioId = null;
				esnoraLocalidadId = null;
				esdireccion_nocapv = null;
			} else if (Y41bConstantes.NORA_LOCALIZACION_EXTRANJERO.equals(esextranjero_)) {
				esextranjero = Y41bConstantes.VALOR_SI;
				esnoraPaisId = ("".equals(esnoraPaisId_)) ? null : esnoraPaisId_;
				esestado = null;
				esnoraProvinciaId = null;
				esnoraMunicipioId = null;
				esnoraLocalidadId = null;
				esdireccion_nocapv = ("".equals(esdireccion_nocapv_)) ? null : esdireccion_nocapv_;

			} else if (Y41bConstantes.NORA_LOCALIZACION_ESTADO.equals(esextranjero_)) {
				esextranjero = null;
				esnoraPaisId = null;
				esestado = Y41bConstantes.VALOR_SI;
				esnoraProvinciaId = ("".equals(esnoraProvinciaId_)) ? null : esnoraProvinciaId_;
				esnoraMunicipioId = ("".equals(esnoraMunicipioId_)) ? null : esnoraMunicipioId_;
				esnoraLocalidadId = ("".equals(esnoraLocalidadId_)) ? null : esnoraLocalidadId_;
				esdireccion_nocapv = ("".equals(esdireccion_nocapv_)) ? null : esdireccion_nocapv_;
			}

			//

			String dtnombre = ("".equals(dtnombre_)) ? null : dtnombre_;
			String dtapellido1 = ("".equals(dtapellido1_)) ? null : dtapellido1_;
			String dtapellido2 = ("".equals(dtapellido2_)) ? null : dtapellido2_;
			String dtnif = ("".equals(dtnif_)) ? null : dtnif_;
			// String dtestado = ("".equals(dtestado_)) ? null : dtestado_;
			// String dtnoraProvinciaId = ("".equals(dtnoraProvinciaId_)) ? null
			// : dtnoraProvinciaId_;
			// String dtnoraMunicipioId = ("".equals(dtnoraMunicipioId_)) ? null
			// : dtnoraMunicipioId_;
			// String dtnoraLocalidadId = ("".equals(dtnoraLocalidadId_)) ? null
			// : dtnoraLocalidadId_;
			// String dtextranjero = ("".equals(dtextranjero_)) ? null
			// : dtextranjero_;
			// String dtnoraPaisId = ("".equals(dtnoraPaisId_)) ? null
			// : dtnoraPaisId_;
			// String dtdireccion_nocapv = ("".equals(dtdireccion_nocapv_)) ?
			// null
			// : dtdireccion_nocapv_;

			String esnombre = ("".equals(esnombre_)) ? null : esnombre_;
			String esnif = ("".equals(esnif_)) ? null : esnif_;
			String esnoco = ("".equals(esnoco_)) ? null : esnoco_;
			// String esestado = ("".equals(esestado_)) ? null : esestado_;
			// String esnoraProvinciaId = ("".equals(esnoraProvinciaId_)) ? null
			// : esnoraProvinciaId_;
			// String esnoraMunicipioId = ("".equals(esnoraMunicipioId_)) ? null
			// : esnoraMunicipioId_;
			// String esnoraLocalidadId = ("".equals(esnoraLocalidadId_)) ? null
			// : esnoraLocalidadId_;
			// String esextranjero = ("".equals(esextranjero_)) ? null
			// : esextranjero_;
			// String esnoraPaisId = ("".equals(esnoraPaisId_)) ? null
			// : esnoraPaisId_;
			// String esdireccion_nocapv = ("".equals(esdireccion_nocapv_)) ?
			// null
			// : esdireccion_nocapv_;

			CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			String codOrgConectado = censoMonitor.getOrganismo().getCodOrg();

			SolicitudBusqueda filterSolicitudBusqueda = new SolicitudBusqueda();
			filterSolicitudBusqueda.setOrigen(origen);
			filterSolicitudBusqueda.setHddenunciaaaccempresas(hddenunciaaaccempresas);
			filterSolicitudBusqueda.setDecoor(decoor);
			filterSolicitudBusqueda.setDenror(denror);
			filterSolicitudBusqueda.setDenran(denran);

			filterSolicitudBusqueda.setCodOrgSeleccionado(codOrg);
			filterSolicitudBusqueda.setMocodigoExpediente(mocodigoExpediente);

			filterSolicitudBusqueda.setDefedeDesde(defedeDesde);
			filterSolicitudBusqueda.setDefedeHasta(defedeHasta);

			filterSolicitudBusqueda.setHdcosc(hdcosc);

			filterSolicitudBusqueda.setDefereDesde(defereDesde);
			filterSolicitudBusqueda.setDefereHasta(defereHasta);

			filterSolicitudBusqueda.setTfpcodigo(tfpcodigo);

			List<Descriptor> descriptores = new ArrayList<Descriptor>();
			// Generar el listado listado de etiquetas (comun)
			if (null != idsDescriptores && !"".equals(idsDescriptores)) {
				Descriptor descriptor = null;
				for (String id : idsDescriptores.split(",")) {
					descriptor = new Descriptor();// NOPMD 2012/02/29 (IDA)
					descriptor.setIdDescriptor(id);
					descriptores.add(descriptor);
				}
			}
			filterSolicitudBusqueda.setDescriptores(descriptores);
			filterSolicitudBusqueda.setIdsDescriptores(idsDescriptores);
			filterSolicitudBusqueda.setDescsDescriptores(descsDescriptores);

			filterSolicitudBusqueda.setHdformanotificacion(hdformanotificacion);
			filterSolicitudBusqueda.setHdcodexpedienteorigen(hdcodexpedienteorigen);
			filterSolicitudBusqueda.setNumregistroentrada(numregistroentrada);

			filterSolicitudBusqueda.setHdtipodenunciante(hdtipodenunciante);

			filterSolicitudBusqueda.setPscodigo(productoPscodigo);
			filterSolicitudBusqueda.setPsnombre(productoPsnombre);
			filterSolicitudBusqueda.setTircodigo(motivoTircodigo);
			filterSolicitudBusqueda.setTirnombre(motivoTirnombre);

			filterSolicitudBusqueda.setFcodigo(fcodigo);
			filterSolicitudBusqueda.setTrcodigo(trcodigo);
			filterSolicitudBusqueda.setDecodigo(decodigo);
			filterSolicitudBusqueda.setMocodigoTramitador(mocodigoTramitador);

			filterSolicitudBusqueda.setEhfechafinDecisionDesde(ehfechafinDecisionDesde);
			filterSolicitudBusqueda.setEhfechafinDecisionHasta(ehfechafinDecisionHasta);

			filterSolicitudBusqueda.setIndUltimoTramite(indUltimoTramite);
			filterSolicitudBusqueda.setIndPendienteAcuse(indPendienteAcuse);
			filterSolicitudBusqueda.setIndIncluirCerrados(indIncluirCerrados);
			filterSolicitudBusqueda.setIndPendienteDecision(indPendienteDecision);
			filterSolicitudBusqueda.setIndPendienteFirma(indPendienteFirma);

			filterSolicitudBusqueda.setDtnombre(dtnombre);
			filterSolicitudBusqueda.setDtapellido1(dtapellido1);
			filterSolicitudBusqueda.setDtapellido2(dtapellido2);
			filterSolicitudBusqueda.setDtnif(dtnif);
			filterSolicitudBusqueda.setDtestado(dtestado);
			filterSolicitudBusqueda.setDtnoraProvinciaId(dtnoraProvinciaId);
			filterSolicitudBusqueda.setDtnoraMunicipioId(dtnoraMunicipioId);
			filterSolicitudBusqueda.setDtnoraLocalidadId(dtnoraLocalidadId);
			filterSolicitudBusqueda.setDtextranjero(dtextranjero);
			filterSolicitudBusqueda.setDtnoraPaisId(dtnoraPaisId);
			filterSolicitudBusqueda.setDtdireccion_nocapv(dtdireccion_nocapv);

			filterSolicitudBusqueda.setEsnombre(esnombre);
			filterSolicitudBusqueda.setEsnif(esnif);
			filterSolicitudBusqueda.setEsnoco(esnoco);
			filterSolicitudBusqueda.setEsestado(esestado);
			filterSolicitudBusqueda.setEsnoraProvinciaId(esnoraProvinciaId);
			filterSolicitudBusqueda.setEsnoraMunicipioId(esnoraMunicipioId);
			filterSolicitudBusqueda.setEsnoraLocalidadId(esnoraLocalidadId);
			filterSolicitudBusqueda.setEsextranjero(esextranjero);
			filterSolicitudBusqueda.setEsnoraPaisId(esnoraPaisId);
			filterSolicitudBusqueda.setEsdireccion_nocapv(esdireccion_nocapv);

			filterSolicitudBusqueda.setCodOrgConectado(codOrgConectado);

			// Ponemos los valores para la visualizacion de las fechas
			// correctamente Ini
			filterSolicitudBusqueda.setDefereDesdeStr(defereDesde_);
			filterSolicitudBusqueda.setDefereHastaStr(defereHasta_);
			filterSolicitudBusqueda.setDefedeDesdeStr(defedeDesde_);
			filterSolicitudBusqueda.setDefedeHastaStr(defedeHasta_);
			filterSolicitudBusqueda.setEhfechafinDecisionDesdeStr(ehfechafinDecisionDesde_);
			filterSolicitudBusqueda.setEhfechafinDecisionHastaStr(ehfechafinDecisionHasta_);
			// Ponemos los valores para la visualizacion de las fechas
			// correctamente Fin

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy, "yyyyMMddHHmmss");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_BUSQUEDA_SOLICITUDES + fechaActual + ".xls";
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(nombre) + "\"");

			String xslString = this.y41bExcelGeneratorService.getSolicitudesExcel(filterSolicitudBusqueda);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterDenuncia
	 *            Denuncia
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody Long getAllCount(@RequestParam(value = "denuncia", required = false) Denuncia filterDenuncia,
			HttpServletRequest request) {
		try {
			return denunciaService.findAllCount(filterDenuncia != null ? filterDenuncia : new Denuncia());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @param response
	 *            HttpServletResponse
	 * @return Denuncia
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody Denuncia edit(@RequestBody Denuncia denuncia, HttpServletResponse response) {
		try {
			Denuncia denunciaAux = this.denunciaService.update(denuncia);
			logger.info("Entity correctly inserted!");
			return denunciaAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Denuncia add(@RequestBody Denuncia denuncia) {
		try {
			Denuncia denunciaAux = this.denunciaService.add(denuncia);
			logger.info("Entity correctly inserted!");
			return denunciaAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'cargaExpedienteDesdePropuesta'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @return Denuncia
	 */
	@RequestMapping(value = "/cargaExpedienteDesdePropuesta", method = RequestMethod.POST)
	public @ResponseBody Denuncia cargaExpedienteDesdePropuesta(
			@RequestParam(value = "hdcodigo", required = false) String hdcodigo) {
		try {
			HechoDenunciado hechoDenunciado = new HechoDenunciado();
			hechoDenunciado.setHdcodigo(hdcodigo);
			Denuncia denuncia = new Denuncia();
			denuncia.setHechoDenunciado(hechoDenunciado);
			denuncia = this.denunciaService.findDenunciaPropARB(denuncia);
			logger.info("Entity correctly inserted!");
			return denuncia;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'addConsulta'.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * 
	 * @return Solicitud
	 */
	@RequestMapping(value = "/altaSolicitud", method = RequestMethod.POST)
	public @ResponseBody SolicitudDetalle addSolicitud(@RequestBody SolicitudDetalle solicitudDetalle, Model model) {
		try {
			Locale locale = LocaleContextHolder.getLocale();
			solicitudDetalle.setDefede(Y41bUtils.parseDate(solicitudDetalle.getDefede(), locale));
			solicitudDetalle.setDefere(Y41bUtils.parseDate(solicitudDetalle.getDefere(), locale));
			solicitudDetalle.setHdfehd(Y41bUtils.parseDate(solicitudDetalle.getHdfehd(), locale));

			SolicitudDetalle solicitudDetalleAux = this.denunciaService.addSolicitud(solicitudDetalle);

			model.addAttribute("solicitudDetalle", solicitudDetalleAux);

			logger.info("Entity correctly inserted!");
			return solicitudDetalleAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'addConsulta'.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * 
	 * @return Solicitud
	 */
	@RequestMapping(value = "/detalleSolicitud", method = RequestMethod.PUT)
	public @ResponseBody SolicitudDetalle editSolicitud(@RequestBody SolicitudDetalle solicitudDetalle) {
		try {
			Locale locale = LocaleContextHolder.getLocale();
			solicitudDetalle.setDefede(Y41bUtils.parseDate(solicitudDetalle.getDefede(), locale));
			solicitudDetalle.setDefere(Y41bUtils.parseDate(solicitudDetalle.getDefere(), locale));
			solicitudDetalle.setHdfehd(Y41bUtils.parseDate(solicitudDetalle.getHdfehd(), locale));

			SolicitudDetalle solicitudDetalleAux = this.denunciaService.updateSolicitud(solicitudDetalle);
			solicitudDetalleAux.setHdte(Y41bStringUtils.unescapeHTML(solicitudDetalleAux.getHdte(), 0));
			solicitudDetalleAux.setHdteso(Y41bStringUtils.unescapeHTML(solicitudDetalleAux.getHdteso(), 0));
			logger.info("Entity correctly inserted!");
			return solicitudDetalleAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'getFormaNotificacionSolicitud'.
	 * 
	 * @param idExpediente
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return String
	 */
	@RequestMapping(value = "/getFormaNotificacionSolicitud/{idExpediente}", method = RequestMethod.GET)
	public @ResponseBody SolicitudDetalle getFormaNotificacionSolicitud(@PathVariable String idExpediente,
			HttpServletRequest request) {

		try {
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			SolicitudDetalle solicitudDetalleAux = new SolicitudDetalle();
			solicitudDetalleAux.setHdcodigo(idExpediente);

			solicitudDetalleAux = this.denunciaService.findSolicitud(solicitudDetalleAux, censoMonitor);
			SolicitudDetalle solicitudDetalleResultado = new SolicitudDetalle();
			solicitudDetalleResultado.setHdcodigo(solicitudDetalleAux.getHdcodigo());
			solicitudDetalleResultado.setHdformanotificacion(solicitudDetalleAux.getHdformanotificacion());
			solicitudDetalleResultado
					.setHdformanotificacionestablecimiento(solicitudDetalleAux.getHdformanotificacionestablecimiento());
			return solicitudDetalleResultado;
		} catch (Exception e) {
			throw new ResourceNotFoundException("");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param decodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{decodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String decodigo, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Denuncia denuncia = new Denuncia();
			denuncia.setDecodigo(decodigo);
			this.denunciaService.remove(denuncia);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + decodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/removeSolicitud/{hdcodigo}", method = RequestMethod.DELETE)
	public void removeSolicitud(@PathVariable String hdcodigo, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(hdcodigo);
			this.denunciaService.removeSolicitud(solicitudDetalle);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			logger.error("Unable to delete " + hdcodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param denunciaIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(@RequestBody ArrayList<ArrayList<String>> denunciaIds, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Denuncia> denunciaList = new ArrayList<Denuncia>();
		try {
			for (ArrayList<String> denunciaId : denunciaIds) {
				Iterator<String> iterator = denunciaId.iterator();
				Denuncia denuncia = new Denuncia();
				denuncia.setDecodigo(ObjectConversionManager.convert(iterator.next(), String.class));
				denunciaList.add(denuncia);
			}
			this.denunciaService.removeMultiple(denunciaList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getDenunciaService'.
	 * 
	 * @return DenunciaService
	 */
	protected DenunciaService getDenunciaService() {
		return this.denunciaService;
	}

	/**
	 * Method 'setDenunciaService'.
	 * 
	 * @param denunciaService
	 *            DenunciaService
	 * @return
	 */
	public void setDenunciaService(DenunciaService denunciaService) {
		this.denunciaService = denunciaService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * Method 'getRegistroEntradaAlta'.
	 * 
	 * @param dni
	 *            String
	 * @param nombre
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return String
	 */
	@RequestMapping(value = "/getRegistroEntradaAlta/{dni}/{nombre}", method = RequestMethod.GET)
	public @ResponseBody RegistroEntrada getRegistroEntrada(@PathVariable String dni, @PathVariable String nombre,
			HttpServletRequest request) {
		try {
			RegistroEntrada registroEntrada = null;
			registroEntrada = this.denunciaService.getRegistroEntradaAlta(dni, nombre);

			if (registroEntrada == null) {
				throw new Exception("");
			}
			return registroEntrada;
		} catch (Exception e) {
			throw new ResourceNotFoundException("");
		}
	}

	/**
	 * Method 'addDocumentoSolicitudDetalle'.
	 * 
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 */
	@RequestMapping(value = "/subidaSolicitud", method = RequestMethod.POST)
	public @ResponseBody void addDocumentoSolicitudDetalle(HttpServletResponse response, HttpServletRequest request,
			Model model) {
		try {

			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();

			if (request.getParameter("isSir").equalsIgnoreCase(Y41bConstantes.SI)) {
				solicitudDetalle.setIsSir(request.getParameter("isSir"));
				solicitudDetalle.setIdAsiento(request.getParameter("idAsientoRegistral"));
				solicitudDetalle.setArSolicitante(request.getParameter("arSolicitante"));
				solicitudDetalle.setArResumen(request.getParameter("arResumen"));
			}

			// campos formulario
			Locale locale = LocaleContextHolder.getLocale();
			solicitudDetalle.setDefede(Y41bUtils.parseDate(request.getParameter("defede"), locale));
			solicitudDetalle.setDefere(Y41bUtils.parseDate(request.getParameter("defere"), locale));
			solicitudDetalle.setHdfehd(Y41bUtils.parseDate(request.getParameter("hdfehd"), locale));
			solicitudDetalle.setHdfedmps(Y41bUtils.parseDate(request.getParameter("hdfedmps"), locale));
			solicitudDetalle.setMocodigo(request.getParameter("mocodigo"));
			solicitudDetalle.setHdcodigo(request.getParameter("hdcodigo"));
			solicitudDetalle.setDecodigo(request.getParameter("decodigo"));
			solicitudDetalle.setDecoor(request.getParameter("decoor"));
			solicitudDetalle.setDehojareclamacion(request.getParameter("dehojareclamacion"));
			solicitudDetalle.setHdidioma(request.getParameter("hdidioma"));
			solicitudDetalle.setHdidiomareclamado(request.getParameter("hdidiomareclamado"));

			String denror = request.getParameter("denror");
			if ("".equals(denror)) {
				solicitudDetalle.setDenror(null);
			} else {
				solicitudDetalle.setDenror(Long.parseLong(denror));
			}

			solicitudDetalle.setDenran(Integer.parseInt(request.getParameter("denran")));

			String hdnror = request.getParameter("hdnror");
			if ("".equals(hdnror)) {
				solicitudDetalle.setHdnror(null);
			} else {
				solicitudDetalle.setHdnror(Long.parseLong(hdnror));
			}
			solicitudDetalle.setHdcosc(request.getParameter("hdcosc"));
			solicitudDetalle.setTfpcodigo(request.getParameter("tfpcodigo"));
			solicitudDetalle.setHdformanotificacion(request.getParameter("hdformanotificacion"));
			solicitudDetalle
					.setHdformanotificacionestablecimiento(request.getParameter("hdformanotificacionestablecimiento"));

			solicitudDetalle.setHddestnotificareclamante(request.getParameter("hddestnotificareclamante"));
			solicitudDetalle.setHddestnotificareclamado(request.getParameter("hddestnotificareclamado"));

			solicitudDetalle.setHdcodexpedienteorigen(request.getParameter("hdcodexpedienteorigen"));

			solicitudDetalle.setHdfecharegistroorigen(
					Y41bUtils.parseDate(request.getParameter("hdfecharegistroorigen"), locale));
			solicitudDetalle.setHdnumregistroentradaorigen(request.getParameter("hdnumregistroorigen"));

			solicitudDetalle.setNumregistroentrada(request.getParameter("numregistroentrada"));
			solicitudDetalle.setDtcodigo(request.getParameter("dtcodigo"));
			solicitudDetalle.setDtnif(request.getParameter("dtnif"));
			solicitudDetalle.setDtnombre(request.getParameter("dtnombre"));
			solicitudDetalle.setDtnrtel(request.getParameter("dtnrtel"));
			solicitudDetalle.setDttecoem(request.getParameter("dttecoem"));
			solicitudDetalle.setDtnombreMunicipio(request.getParameter("dtnombreMunicipio"));
			solicitudDetalle.setEscodigo(request.getParameter("escodigo"));
			solicitudDetalle.setEsnif(request.getParameter("esnif"));
			solicitudDetalle.setEsnombre(request.getParameter("esnombre"));
			solicitudDetalle.setSecodigo(request.getParameter("secodigo"));
			solicitudDetalle.setSenombre(request.getParameter("secodigo"));
			solicitudDetalle.setEsnombreMunicipio(request.getParameter("secodigo"));
			solicitudDetalle.setIdsDescriptores(request.getParameter("idsDescriptores"));
			solicitudDetalle.setHdte(request.getParameter("hdte"));
			solicitudDetalle.setPscodigo(request.getParameter("pscodigo"));
			solicitudDetalle.setHdnops(request.getParameter("hdnops"));
			solicitudDetalle.setHdnomaps(request.getParameter("hdnomaps"));
			solicitudDetalle.setHdnomops(request.getParameter("hdnomops"));
			solicitudDetalle.setHdnrlops(request.getParameter("hdnrlops"));
			solicitudDetalle.setHdcodigobarras(request.getParameter("hdcodigobarras"));
			solicitudDetalle.setHdinteresado(request.getParameter("hdinteresado"));
			solicitudDetalle.setTircodigo(request.getParameter("tircodigo"));
			solicitudDetalle.setTsrcodigo(request.getParameter("tsrcodigo"));

			solicitudDetalle.setFvcodigo(request.getParameter("fvcodigo"));

			solicitudDetalle.setHdtipodenunciante(request.getParameter("hdtipodenunciante"));

			String hdcaptso = request.getParameter("hdcaptso");
			if ("".equals(hdcaptso)) {
				solicitudDetalle.setHdcaptso(null);
			} else {
				solicitudDetalle.setHdcaptso(new BigDecimal(hdcaptso));
			}

			solicitudDetalle.setHdteso(request.getParameter("hdteso"));
			solicitudDetalle.setHddenunciaaaccempresas(request.getParameter("hddenunciaaaccempresas"));
			// 0184821 cuando se registren a travs de SIR Denuncias de empresas
			// no entren con el orgnico del Usuario conectado sino con el
			// 01A001
			if (request.getParameter("isSir").equalsIgnoreCase(Y41bConstantes.SI)
					&& request.getParameter("hddenunciaaaccempresas").equalsIgnoreCase(Y41bConstantes.VALOR_SI)) {
				solicitudDetalle.setDecoor(Y41bConstantes.CODIGO_ORGANISMO_SSCC_CONTROLMERCADO);
			}

			solicitudDetalle = this.denunciaService.addSolicitud(solicitudDetalle);

			model.addAttribute("solicitudDetalle", solicitudDetalle);

			logger.info("Entity correctly inserted!" + solicitudDetalle);

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			logger.error("###########################ERROR ALTA SOLICITUD", e);
			throw new MethodFailureException("Method failed addDocumentoSolicitudDetalle");
		}
	}

	/**
	 * Method 'updateDocumentoSolicitudDetalle'.
	 * 
	 * 
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 */
	@RequestMapping(value = "/guardarSolicitudEdicion", method = RequestMethod.POST)
	public @ResponseBody void updateDocumentoSolicitudDetalle(HttpServletResponse response,
			HttpServletRequest request) {
		try {

			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();

			// campos formulario
			Locale locale = LocaleContextHolder.getLocale();
			solicitudDetalle.setDefede(Y41bUtils.parseDate(request.getParameter("defede"), locale));
			solicitudDetalle.setDefere(Y41bUtils.parseDate(request.getParameter("defere"), locale));
			solicitudDetalle.setHdfehd(Y41bUtils.parseDate(request.getParameter("hdfehd"), locale));
			solicitudDetalle.setHdfedmps(Y41bUtils.parseDate(request.getParameter("hdfedmps"), locale));
			solicitudDetalle.setMocodigo(request.getParameter("mocodigo"));
			solicitudDetalle.setHdcodigo(request.getParameter("hdcodigo"));
			solicitudDetalle.setDecodigo(request.getParameter("decodigo"));
			solicitudDetalle.setDecoor(request.getParameter("decoor"));
			solicitudDetalle.setDehojareclamacion(request.getParameter("dehojareclamacion"));
			solicitudDetalle.setHdidioma(request.getParameter("hdidioma"));
			solicitudDetalle.setHdidiomareclamado(request.getParameter("hdidiomareclamado"));

			String denror = request.getParameter("denror");
			if ("".equals(denror)) {
				solicitudDetalle.setDenror(null);
			} else {
				solicitudDetalle.setDenror(Long.parseLong(denror));
			}

			solicitudDetalle.setDenran(Integer.parseInt(request.getParameter("denran")));

			String hdnror = request.getParameter("hdnror");
			if ("".equals(hdnror)) {
				solicitudDetalle.setHdnror(null);
			} else {
				solicitudDetalle.setHdnror(Long.parseLong(hdnror));
			}
			solicitudDetalle.setHdcosc(request.getParameter("hdcosc"));
			solicitudDetalle.setTfpcodigo(request.getParameter("tfpcodigo"));
			solicitudDetalle.setHdformanotificacion(request.getParameter("hdformanotificacion"));
			solicitudDetalle
					.setHdformanotificacionestablecimiento(request.getParameter("hdformanotificacionestablecimiento"));

			solicitudDetalle.setHddestnotificareclamante(request.getParameter("hddestnotificareclamante"));
			solicitudDetalle.setHddestnotificareclamado(request.getParameter("hddestnotificareclamado"));

			solicitudDetalle.setHdcodexpedienteorigen(request.getParameter("hdcodexpedienteorigen"));

			solicitudDetalle.setHdfecharegistroorigen(
					Y41bUtils.parseDate(request.getParameter("hdfecharegistroorigen"), locale));
			solicitudDetalle.setHdnumregistroentradaorigen(request.getParameter("hdnumregistroorigen"));

			solicitudDetalle.setNumregistroentrada(request.getParameter("numregistroentrada"));
			solicitudDetalle.setDtcodigo(request.getParameter("dtcodigo"));
			solicitudDetalle.setDtnif(request.getParameter("dtnif"));
			solicitudDetalle.setDtnombre(request.getParameter("dtnombre"));
			solicitudDetalle.setDtnrtel(request.getParameter("dtnrtel"));
			solicitudDetalle.setDttecoem(request.getParameter("dttecoem"));
			solicitudDetalle.setDtnombreMunicipio(request.getParameter("dtnombreMunicipio"));
			solicitudDetalle.setEscodigo(request.getParameter("escodigo"));
			solicitudDetalle.setEsnif(request.getParameter("esnif"));
			solicitudDetalle.setEsnombre(request.getParameter("esnombre"));
			solicitudDetalle.setSecodigo(request.getParameter("secodigo"));
			solicitudDetalle.setSenombre(request.getParameter("secodigo"));
			solicitudDetalle.setEsnombreMunicipio(request.getParameter("secodigo"));
			solicitudDetalle.setIdsDescriptores(request.getParameter("idsDescriptores"));
			solicitudDetalle.setHdte(request.getParameter("hdte"));
			solicitudDetalle.setPscodigo(request.getParameter("pscodigo"));
			solicitudDetalle.setHdnops(request.getParameter("hdnops"));
			solicitudDetalle.setHdnomaps(request.getParameter("hdnomaps"));
			solicitudDetalle.setHdnomops(request.getParameter("hdnomops"));
			solicitudDetalle.setHdnrlops(request.getParameter("hdnrlops"));
			solicitudDetalle.setHdcodigobarras(request.getParameter("hdcodigobarras"));
			solicitudDetalle.setHdinteresado(request.getParameter("hdinteresado"));
			solicitudDetalle.setTircodigo(request.getParameter("tircodigo"));
			solicitudDetalle.setTsrcodigo(request.getParameter("tsrcodigo"));

			solicitudDetalle.setFvcodigo(request.getParameter("fvcodigo"));
			solicitudDetalle.setHdtipodenunciante(request.getParameter("hdtipodenunciante"));

			String hdcaptso = request.getParameter("hdcaptso");
			if ("".equals(hdcaptso)) {
				solicitudDetalle.setHdcaptso(null);
			} else {
				solicitudDetalle.setHdcaptso(new BigDecimal(hdcaptso));
			}

			solicitudDetalle.setHdteso(request.getParameter("hdteso"));

			solicitudDetalle.setReclamanteCambio(request.getParameter("reclamanteCambio"));
			solicitudDetalle.setReclamadoCambio(request.getParameter("reclamadoCambio"));

			solicitudDetalle = this.denunciaService.updateSolicitud(solicitudDetalle);

			logger.info("Entity correctly inserted!" + solicitudDetalle);

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed addDocumentoSolicitudDetalle");
		}
	}

	// /**
	// *
	// * @param file
	// * MultipartFile
	// * @return mapa
	// */
	// private Map<String, Object> getFileReturnMap(MultipartFile file) {
	// Map<String, Object> mapaRetorno = new HashMap<String, Object>();
	// mapaRetorno.put(
	// "url",
	// "/y41bVistaWar/denuncia/subidaSolicitud/"
	// + file.getOriginalFilename());
	// mapaRetorno.put("name", file.getOriginalFilename());
	// mapaRetorno.put("type", file.getContentType());
	// mapaRetorno.put("size", file.getSize());
	// mapaRetorno.put("delete_url", "/y41bVistaWar/denuncia/subidaSolicitud/"
	// + file.getOriginalFilename());
	// mapaRetorno.put("delete_type", "DELETE");
	// return mapaRetorno;
	// }

	/**
	 * Method 'getAllPosibleTramite'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @param trPosibleCodigo
	 *            String
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param request
	 *            HttpServletRequest
	 * 
	 * 
	 * @return String
	 */
	@RequestMapping(value = "/getAllPosibleTramite/{hdcodigo}/{trPosibleCodigo}", method = RequestMethod.GET)
	public @ResponseBody Object getAllPosibleTramite(@PathVariable String hdcodigo,
			@PathVariable String trPosibleCodigo, HttpServletRequest request) {
		try {
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			PosibleTramite posibleTramite = new PosibleTramite();
			TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
			tipoProcedimiento.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);

			posibleTramite.setTipoProcedimiento(tipoProcedimiento);
			posibleTramite.setTrposiblecodigoorigen(trPosibleCodigo);

			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(hdcodigo);

			solicitudDetalle = this.denunciaService.findSolicitud(solicitudDetalle, censoMonitor);

			posibleTramite.setTiposolicitud(solicitudDetalle.getHdcosc());

			List<Tramite> tramites = new ArrayList<Tramite>();

			// si solo existe el tramite de registro y no se ha tramitado,
			// devolver la lista vacia
			TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();
			tramiteHechoDetalle.setHdcodigo(solicitudDetalle.getHdcodigo());
			List<TramiteHechoDetalle> listTramiteHechoDetalle = this.denunciaService
					.findAllTramiteHecho(tramiteHechoDetalle, null);
			if (listTramiteHechoDetalle.size() == 1 && listTramiteHechoDetalle.get(0).getEhfechafin() == null) {
				tramites = new ArrayList<Tramite>();
			} else {
				if (solicitudDetalle != null && solicitudDetalle.getHddenunciaaaccempresas() != null
						&& solicitudDetalle.getHddenunciaaaccempresas().equals(Y41bConstantes.VALOR_SI)) {
					posibleTramite.setTiposolicitud(Y41bConstantes.TIPO_SOLICITUD_DENUNCIA_EMPRESAS);
					tramites = this.posibleTramiteService.findAllPosibleTramite(posibleTramite, censoMonitor, null);
				} else {
					tramites = this.posibleTramiteService.findAllPosibleTramiteConsumidor(posibleTramite, censoMonitor,
							null);
				}
			}

			if (tramites == null) {
				throw new Exception("No data Found.");
			}
			return tramites;
		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException(trPosibleCodigo.toString());
		}
	}

	/**
	 * Method 'getAllPosibleTramite'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @param trPosibleCodigo
	 *            String
	 * @param tipoSolicitud
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * 
	 * 
	 * @return String
	 */
	@RequestMapping(value = "/getAllPosibleTramiteCount/{hdcodigo}/{trPosibleCodigo}/{tipoSolicitud}", method = RequestMethod.GET)
	public @ResponseBody Long getAllPosibleTramiteCount(@PathVariable String hdcodigo,
			@PathVariable String trPosibleCodigo, @PathVariable String tipoSolicitud, HttpServletRequest request) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			PosibleTramite posibleTramite = new PosibleTramite();
			TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
			tipoProcedimiento.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);

			posibleTramite.setTipoProcedimiento(tipoProcedimiento);
			posibleTramite.setTrposiblecodigoorigen(trPosibleCodigo);
			posibleTramite.setTiposolicitud(tipoSolicitud);

			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(hdcodigo);

			solicitudDetalle = this.denunciaService.findSolicitud(solicitudDetalle, censoMonitor);

			if (solicitudDetalle != null && solicitudDetalle.getHddenunciaaaccempresas() != null
					&& solicitudDetalle.getHddenunciaaaccempresas().equals(Y41bConstantes.VALOR_SI)) {
				posibleTramite.setTiposolicitud(Y41bConstantes.TIPO_SOLICITUD_DENUNCIA_EMPRESAS);
			}

			Long numTramites;

			// si solo existe el tramite de registro y no se ha tramitado,
			// devolver la lista vacia
			TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();
			tramiteHechoDetalle.setHdcodigo(hdcodigo);
			List<TramiteHechoDetalle> listTramiteHechoDetalle = this.denunciaService
					.findAllTramiteHecho(tramiteHechoDetalle, null);
			if (listTramiteHechoDetalle.size() == 1 && listTramiteHechoDetalle.get(0).getEhfechafin() == null) {
				numTramites = new Long(0);
			} else {
				numTramites = this.posibleTramiteService.findAllPosibleTramiteCount(posibleTramite, censoMonitor);
			}

			if (numTramites == null) {
				throw new Exception("No data Found.");
			}
			return numTramites;
		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException(trPosibleCodigo.toString());
		}
	}

	/**
	 * Method 'getDocsByHdcodigo'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "/documentos/{hdcodigo}", method = RequestMethod.GET)
	public @ResponseBody Object getDocsByHdcodigo(@PathVariable String hdcodigo, HttpServletRequest request) {
		try {

			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdExpediente(hdcodigo);
			TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
			tipoProcedimiento.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
			tramiteComun.setTipoProcedimiento(tipoProcedimiento);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<DocumentoExpediente> documentosExpediente = this.denunciaService
						.findAllDocumentosHecho(tramiteComun, pagination);

				if (documentosExpediente == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.denunciaService.findAllDocumentosHechoCount(tramiteComun);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(documentosExpediente);
				return data;
			} else {
				List<DocumentoExpediente> documentosExpediente = this.denunciaService
						.findAllDocumentosHecho(tramiteComun, pagination);
				if (documentosExpediente == null) {
					throw new Exception("No data Found.");
				}
				return documentosExpediente;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found. /denuncia/documentacion/{hdcodigo}");
		}
	}

	/**
	 * Method 'getIntervinientesByHdcodigo'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "/intervinientes/{hdcodigo}", method = RequestMethod.GET)
	public @ResponseBody Object getIntervinientesByHdcodigo(@PathVariable String hdcodigo, HttpServletRequest request) {
		try {

			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdExpediente(hdcodigo);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Intervinientes> listaIntervinientes = this.denunciaService.findAllIntervinientes(intervinientes,
						pagination);

				if (listaIntervinientes == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.denunciaService.findAllIntervinientesCount(intervinientes);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listaIntervinientes);
				return data;
			} else {
				List<Intervinientes> listaIntervinientes = this.denunciaService.findAllIntervinientes(intervinientes,
						pagination);
				if (listaIntervinientes == null) {
					throw new Exception("No data Found.");
				}
				return listaIntervinientes;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found. /denuncia/intervinientes/{hdcodigo}");
		}
	}

	/**
	 * Method 'getDetalleByIdTramitacion'.
	 * 
	 * @param ehcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "/tramitacion/detalle/{ehcodigo}", method = RequestMethod.GET)
	public @ResponseBody Object getDetalleByIdTramitacion(@PathVariable String ehcodigo, HttpServletRequest request) {
		try {

			TramiteHechoDetalleKnet tramiteHechoDetalleKnet = new TramiteHechoDetalleKnet();
			tramiteHechoDetalleKnet.setEhcodigo(ehcodigo);

			tramiteHechoDetalleKnet = this.denunciaService.findTramiteHecho(tramiteHechoDetalleKnet);

			if (tramiteHechoDetalleKnet == null) {
				throw new Exception("No data Found. /tramitacion/detalle/{ehcodigo}");
			} else if (tramiteHechoDetalleKnet.getEhtexto() != null
					&& !("".equalsIgnoreCase(tramiteHechoDetalleKnet.getEhtexto()))) {
				tramiteHechoDetalleKnet.setEhtexto(Y41bUtils.eliminarAmpersand(tramiteHechoDetalleKnet.getEhtexto()));

			}

			// else {
			// // ehoraa, amputarle los :ss
			// tramiteHechoDetalle.setEhhora(Y41aUtils
			// .horaToHora(tramiteHechoDetalle.getEhhora()));
			// }
			return tramiteHechoDetalleKnet;

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found. /tramitacion/detalle/{ehcodigo}");
		}
	}

	/**
	 * Method 'getByIdDocumentoHechoDetalle'.
	 * 
	 * @param q5codocumento
	 *            String
	 * 
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/documentacion/link/{q5codocumento}", method = RequestMethod.GET)
	public @ResponseBody void getByIdDocumentoHechoDetalle(@PathVariable String q5codocumento,
			HttpServletResponse response) {
		try {

			DocumentoHechoDetalle documentoHechoDetalle = new DocumentoHechoDetalle();
			documentoHechoDetalle.setQ5codocumento(q5codocumento);

			documentoHechoDetalle = this.denunciaService.findDocumentoHechoSinDocumento(documentoHechoDetalle);

			if (documentoHechoDetalle == null) {
				throw new Exception(q5codocumento.toString());
			}

			// si est en dokusi, descargar de dokusi
			if (documentoHechoDetalle != null && documentoHechoDetalle.getQ5iddocumentum() != null
					&& !documentoHechoDetalle.getQ5iddocumentum().equals("")) {
				// DESCARGA EL DOCUMENTO DEL PIF
				BufferedInputStream bIS = this.y41bPifAdapterService.getFile(documentoHechoDetalle.getRutaPif());

				// Cambiamos el objeto Response para visualizar el contenido del
				// archivo
				response.setHeader("Content-Disposition", "attachment; filename=\""
						+ StringEscapeUtils.unescapeHtml(documentoHechoDetalle.getQ5nofile()) + "\"");
				response.setContentType(documentoHechoDetalle.getQ5contenttypefile());
				response.setContentLength(documentoHechoDetalle.getQ5sizefile());

				InputStream is = new BufferedInputStream(bIS);

				int read = 0;
				byte[] bytes = new byte[Y41bConstantes.NUM_1024];
				OutputStream os = response.getOutputStream();

				while ((read = is.read(bytes)) != -1) {
					os.write(bytes, 0, read);
				}

				os.flush();
				os.close();
			} else {
				Blob contenido = documentoHechoDetalle.getQ5datafile();
				byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

				// Cambiamos el objeto Response para visualizar el contenido del
				// archivo
				response.setHeader("Content-Disposition", "attachment; filename=\""
						+ StringEscapeUtils.unescapeHtml(documentoHechoDetalle.getQ5nofile()) + "\"");
				response.setContentType(documentoHechoDetalle.getQ5contenttypefile());
				response.setContentLength(documentoHechoDetalle.getQ5sizefile());
				response.getOutputStream().write(bContenido);

				// Vaciamos el stream
				response.getOutputStream().flush();
			}

		} catch (Exception e) {
			throw new ResourceNotFoundException(q5codocumento.toString());
		}
	}

	/**
	 * Method 'editInstructor'.
	 * 
	 * @param solicitudCambioInstructor
	 *            SolicitudCambioInstructor
	 * @param request
	 *            HttpServletRequest
	 * 
	 */
	@RequestMapping(value = "/modificarInstructor", method = RequestMethod.PUT)
	public @ResponseBody void editInstructor(@RequestBody SolicitudCambioInstructor solicitudCambioInstructor,
			HttpServletRequest request) {
		try {
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			this.denunciaService.updateCambioInstructor(solicitudCambioInstructor, censoMonitor);
			logger.info("Entity correctly inserted!");

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException("Method failed /denuncia/modificarInstructor");
		}
	}

	/**
	 * Method 'trasvaseTotal'.
	 * 
	 * @param solicitudCambioInstructor
	 *            SolicitudCambioInstructor
	 * 
	 */
	@RequestMapping(value = "/trasvaseTotal", method = RequestMethod.PUT)
	public @ResponseBody void trasvaseTotal(@RequestBody SolicitudCambioInstructor solicitudCambioInstructor) {
		try {

			this.denunciaService.updateTrasvaseTotalCambioInstructor(solicitudCambioInstructor);
			logger.info("Entity correctly inserted!");

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException("Method failed /denuncia/modificarInstructor");
		}
	}

	/**
	 * Method 'getDocsByHdcodigo'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @param numExpediente
	 *            String
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/imprimirdocumentos/{hdcodigo}/{numExpediente}", method = RequestMethod.GET)
	public @ResponseBody void imprimirDocsByHdcodigo(@PathVariable String hdcodigo, @PathVariable String numExpediente,
			HttpServletResponse response) {
		try {

			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdExpediente(hdcodigo);

			List<DocumentoExpediente> documentosExpediente = this.denunciaService.findAllDocumentosHecho(tramiteComun,
					null);

			if (documentosExpediente == null || documentosExpediente.size() == 0) {
				throw new Exception("No data Found.");
			} else {
				// CONSTRUIR ZIP
				InputStream ficheroStream = null;
				File fileFichero = null;

				Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
				// Ej. /datos/y41b/tmp/zip/
				String strTmpZipDirectory = prop.getProperty("RUTA_TMP_ZIP");
				// Ej. /datos/y41b/tmp/zip/1383555971012_199906071034ESP10147

				String strZipDirectory = strTmpZipDirectory + numExpediente;
				// Ej.
				// /datos/y41b/tmp/zip/1383555971012_199906071034ESP10147.zip
				String strZipFile = strZipDirectory + Y41bConstantes.EXTENSION_ZIP;

				Y41bFicheroUtils.deleteDirectory(new File(strTmpZipDirectory));
				// 1. Validamos que exista el directorio TMP para los ZIP. Si no
				// existe, lo creo
				Y41bFicheroUtils.crearDirectorio(strTmpZipDirectory);
				// 2. Validamos que exista el directorio TMP para el ZIP actual.
				// Si
				// no existe, lo creo
				Y41bFicheroUtils.crearDirectorio(strZipDirectory);
				// 3. Creamos el ZIP
				Y41bFicheroUtils.crearFichero(new File(strZipFile));

				// ******* Borramos historico de ficheros con mas de 1 minuto
				// (60000ms) de
				// diferencia en la fecha de creacion
				Y41bFicheroUtils.deleteFilesFromDate(new File(strTmpZipDirectory), 60000);

				// **************************************************************
				String nombreFichero = null;
				int numDoc = 1;
				// 4. Recorremos la lista de documentos a zipear y los dejamos
				// en el directorio TMP para el ZIP actual
				for (DocumentoExpediente documento : documentosExpediente) {

					DocumentoHechoDetalle documentoHechoDetalle = new DocumentoHechoDetalle();
					documentoHechoDetalle.setQ5codocumento(documento.getCodocumento());
					documentoHechoDetalle = this.denunciaService.findDocumentoHecho(documentoHechoDetalle);

					if (documentoHechoDetalle == null) {
						throw new Exception(String.valueOf(documento.getCodocumento()));
					}

					nombreFichero = StringEscapeUtils.unescapeHtml(documentoHechoDetalle.getQ5nofile()).replaceAll("/",
							"-");
					ficheroStream = documentoHechoDetalle.getQ5datafile().getBinaryStream();

					String local = (String) prop.getProperty("y41bVistaWar.entorno.local");

					if (local.equals("true")) {
						fileFichero = new File(strZipDirectory + "\\" + numDoc + "." + nombreFichero);
					} else {
						fileFichero = new File(strZipDirectory + "/" + numDoc + "." + nombreFichero);
					}

					Y41bFicheroUtils.escribirFichero(ficheroStream, fileFichero);
					ficheroStream.close();
					numDoc++;
				}

				Y41bFicheroUtils.comprimirFichero(new File(strZipDirectory), strZipFile);
				// ***********************************************************************

				// PARA DESCARGALO
				File ficheroZip = new File(strZipFile);
				byte[] bFile = new byte[(int) ficheroZip.length()];

				FileInputStream fileInputStream = new FileInputStream(ficheroZip);
				fileInputStream.read(bFile);
				fileInputStream.close();

				response.setHeader("Content-Disposition",
						"attachment; filename=\"" + numExpediente + Y41bConstantes.EXTENSION_ZIP + "\"");
				response.setContentType("application/zip");
				response.setContentLength(bFile.length);
				response.getOutputStream().write(bFile);
				// Vaciamos el stream
				response.getOutputStream().flush();
			}

		} catch (Exception e) {
			logger.error("###########################ERROR AL IMPRIMIR DOCUMENTOS", e);
			throw new Y41bUDAException("No hay ficheros para esta solicitud", false, e);
		}
	}

	/**
	 * Method 'getDocsByHdcodigo'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @param numExpediente
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/imprimirdocumentosseleccionados/{hdcodigo}/{numExpediente}", method = RequestMethod.GET)
	public @ResponseBody void imprimirDocsByHdcodigo(@PathVariable String hdcodigo, @PathVariable String numExpediente,
			HttpServletRequest request, HttpServletResponse response) {
		try {

			String idsdocumentosParam = request.getParameter("idsdocumentos");

			List<String> idsdocumentosList = Arrays.asList(idsdocumentosParam.split(","));

			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdExpediente(hdcodigo);

			List<DocumentoExpediente> documentosExpediente = this.denunciaService
					.findAllDocumentosHechoByIds(tramiteComun, idsdocumentosList, null);

			if (documentosExpediente == null || documentosExpediente.size() == 0) {
				throw new Exception("No data Found.");
			} else {
				// CONSTRUIR ZIP
				InputStream ficheroStream = null;
				File fileFichero = null;

				Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
				// Ej. /datos/y41b/tmp/zip/
				String strTmpZipDirectory = prop.getProperty("RUTA_TMP_ZIP");
				// Ej. /datos/y41b/tmp/zip/1383555971012_199906071034ESP10147

				String strZipDirectory = strTmpZipDirectory + numExpediente;
				// Ej.
				// /datos/y41b/tmp/zip/1383555971012_199906071034ESP10147.zip
				String strZipFile = strZipDirectory + Y41bConstantes.EXTENSION_ZIP;

				Y41bFicheroUtils.deleteDirectory(new File(strTmpZipDirectory));

				// 1. Validamos que exista el directorio TMP para los ZIP. Si no
				// existe, lo creo
				Y41bFicheroUtils.crearDirectorio(strTmpZipDirectory);
				// 2. Validamos que exista el directorio TMP para el ZIP actual.
				// Si
				// no existe, lo creo
				Y41bFicheroUtils.crearDirectorio(strZipDirectory);
				// 3. Creamos el ZIP
				Y41bFicheroUtils.crearFichero(new File(strZipFile));

				// ******* Borramos historico de ficheros con mas de 1 minuto
				// (60000ms) de
				// diferencia en la fecha de creacion
				Y41bFicheroUtils.deleteFilesFromDate(new File(strTmpZipDirectory), 60000);

				// **************************************************************
				String nombreFichero = null;
				int numDoc = 1;
				// 4. Recorremos la lista de documentos a zipear y los dejamos
				// en el directorio TMP para el ZIP actual
				for (DocumentoExpediente documento : documentosExpediente) {

					DocumentoHechoDetalle documentoHechoDetalle = new DocumentoHechoDetalle();
					documentoHechoDetalle.setQ5codocumento(documento.getCodocumento());
					documentoHechoDetalle = this.denunciaService.findDocumentoHecho(documentoHechoDetalle);

					if (documentoHechoDetalle == null) {
						throw new Exception(String.valueOf(documento.getCodocumento()));
					}

					nombreFichero = StringEscapeUtils.unescapeHtml(documentoHechoDetalle.getQ5nofile()).replaceAll("/",
							"-");
					ficheroStream = documentoHechoDetalle.getQ5datafile().getBinaryStream();

					String local = (String) prop.getProperty("y41bVistaWar.entorno.local");

					if (local.equals("true")) {
						fileFichero = new File(strZipDirectory + "\\" + numDoc + "." + nombreFichero);
					} else {
						fileFichero = new File(strZipDirectory + "/" + numDoc + "." + nombreFichero);
					}

					Y41bFicheroUtils.escribirFichero(ficheroStream, fileFichero);
					ficheroStream.close();
					numDoc++;
				}

				Y41bFicheroUtils.comprimirFichero(new File(strZipDirectory), strZipFile);
				// ***********************************************************************

				// PARA DESCARGALO
				File ficheroZip = new File(strZipFile);
				byte[] bFile = new byte[(int) ficheroZip.length()];

				FileInputStream fileInputStream = new FileInputStream(ficheroZip);
				fileInputStream.read(bFile);
				fileInputStream.close();

				response.setHeader("Content-Disposition",
						"attachment; filename=\"" + numExpediente + Y41bConstantes.EXTENSION_ZIP + "\"");
				response.setContentType("application/zip");
				response.setContentLength(bFile.length);
				response.getOutputStream().write(bFile);
				// Vaciamos el stream
				response.getOutputStream().flush();
			}

		} catch (Exception e) {
			logger.error("###########################ERROR AL IMPRIMIR DOCUMENTOS", e);
			throw new Y41bUDAException("No hay ficheros para esta solicitud", false, e);
		}
	}

	/**
	 * Method 'getEnviosByHdcodigo'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "/envios/{hdcodigo}", method = RequestMethod.GET)
	public @ResponseBody Object getEnviosByHdcodigo(@PathVariable String hdcodigo, HttpServletRequest request) {
		try {

			HechoDenunciado hechoDenunciado = new HechoDenunciado();
			hechoDenunciado.setHdcodigo(hdcodigo);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<SolicitudEnvios> listaSolicitudEnvios = this.denunciaService
						.findAllSolicitudEnvios(hechoDenunciado, pagination);

				if (listaSolicitudEnvios == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.denunciaService.findAllSolicitudEnviosCount(hechoDenunciado);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listaSolicitudEnvios);
				return data;
			} else {
				List<SolicitudEnvios> listaSolicitudEnvios = this.denunciaService
						.findAllSolicitudEnvios(hechoDenunciado, pagination);
				if (listaSolicitudEnvios == null) {
					throw new Exception("No data Found.");
				}
				return listaSolicitudEnvios;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found. /denuncia/envios/{hdcodigo}");
		}
	}

	/**
	 * Method 'getRegistroEntrada'.
	 * 
	 * @return String
	 */
	@RequestMapping(value = "/getRegistroentrada", method = RequestMethod.GET)
	public @ResponseBody RegistroEntrada getRegistroEntrada() {
		try {

			RegistroEntrada registroEntrada = null;
			registroEntrada = this.denunciaService.getRegistroEntrada();

			if (registroEntrada == null) {
				throw new Exception("");
			}
			return registroEntrada;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'copiarExpediente'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/copiarexpediente/{hdcodigo}", method = RequestMethod.POST)
	public @ResponseBody SolicitudDetalle copiarExpediente(@PathVariable String hdcodigo, HttpServletRequest request) {
		try {
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(hdcodigo);

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			solicitudDetalle = this.denunciaService.copiarSolicitud(solicitudDetalle, censoMonitor);

			if (solicitudDetalle == null) {
				throw new Exception("");
			}
			return solicitudDetalle;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getByIdHecho'.
	 * 
	 * @param decoor
	 *            String
	 * @param denror
	 *            Long
	 * @param denran
	 *            Integer
	 * @param hdnror
	 *            Long
	 * @param request
	 *            HttpServletRequest
	 * 
	 * 
	 * @return String
	 */
	@RequestMapping(value = "/getHechoByNumExpediente/altaArb/{decoor}/{denror}/{denran}/{hdnror}", method = RequestMethod.GET)
	public @ResponseBody SolicitudDetalle getHechoByNumExpedienteAltaArb(@PathVariable String decoor,
			@PathVariable Long denror, @PathVariable Integer denran, @PathVariable Long hdnror,
			HttpServletRequest request) {
		try {

			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setDecoor(decoor);
			solicitudDetalle.setDenror(denror);
			solicitudDetalle.setDenran(denran);
			solicitudDetalle.setHdnror(hdnror);
			CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			solicitudDetalle = this.denunciaService.findSolicitudByNumeroExpedienteAltaArb(solicitudDetalle,
					censoMonitor);

			if (solicitudDetalle == null) {
				throw new Exception(decoor.toString());
			}
			return solicitudDetalle;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException(decoor.toString());
		}
	}

	/**
	 * Method 'editDenuncia'.
	 * 
	 * @param solicitudCambioInstructor
	 *            SolicitudCambioInstructor
	 * 
	 */

	@RequestMapping(value = "/convertirEnDenunciasAACCEmpresas/{hdcodigo}", method = RequestMethod.PUT)
	public @ResponseBody SolicitudDetalle updateSolicitudDenunciaAACC(@PathVariable String hdcodigo,
			HttpServletRequest request) {
		try {
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(hdcodigo);

			CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			this.denunciaService.updateSolicitudDenunciaAACC(solicitudDetalle, censoMonitor);
			logger.info("updateSolicitudDenunciaAACC correctly developed!");
			return solicitudDetalle;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException("Method failed /denuncia/updateSolicitudDenunciaAACC");
		}
	}

	/**
	 * Method 'editDenuncia'.
	 * 
	 * @param solicitudCambioInstructor
	 *            SolicitudCambioInstructor
	 * 
	 */

	@RequestMapping(value = "/convertirEnSolicitudes/{hdcodigo}", method = RequestMethod.PUT)
	public @ResponseBody SolicitudDetalle updateDenunciaAACCSolicitud(@PathVariable String hdcodigo,
			HttpServletRequest request) {
		try {
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(hdcodigo);

			CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			this.denunciaService.updateDenunciaAACCEnSolicitud(solicitudDetalle, censoMonitor);
			logger.info("updateDenunciaAACCSolicitud correctly developed!");
			return solicitudDetalle;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException("Method failed /denuncia/updateDenunciaAACCSolicitud");
		}
	}

	/**
	 * Method 'editDenuncia'.
	 * 
	 * @param hdcodigo
	 *            String
	 * 
	 */

	@RequestMapping(value = "/actualizarDocumentosLocalizados/{hdcodigo}", method = RequestMethod.PUT)
	public @ResponseBody SolicitudDetalle actualizarDocumentosLocalizados(@PathVariable String hdcodigo,
			HttpServletRequest request) {
		try {
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(hdcodigo);

			this.denunciaService.actualizarDocumentosLocalizados(solicitudDetalle);
			logger.info("updateDenunciaAACCSolicitud correctly developed!");
			return solicitudDetalle;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException("Method failed /denuncia/updateDenunciaAACCSolicitud");
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param idAsiento
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bDetalleSolicitudAR/{idAsiento}", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bDetalleSolicitudParaAsientoRegistral(@PathVariable String idAsiento,
			Model model, HttpServletRequest request) {

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo("");

		model.addAttribute("solicitudDetalle", solicitudDetalle);

		AsientoRegistral asientoRegistral = new AsientoRegistral();
		asientoRegistral.setIdAsiento(idAsiento);

		model.addAttribute("asientoRegistral", asientoRegistral);

		model.addAttribute("defaultLanguage", appConfiguration.get("z99aVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("z99aVistaWar.default.layout"));
		model.addAttribute("solicitudAccesoDesde", Y41bConstantes.SOLICITUDES_ACCESO_DESDE_SOLICITUD);

		httpSession.setAttribute("desde", Y41bConstantes.DESDE_ASIENTO_REGISTRAL);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bTabsDetalleSolicitudNormal", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param idAsiento
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bDetalleEmpresasAR/{idAsiento}", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bDetalleEmpresasParaAsientoRegistral(@PathVariable String idAsiento,
			Model model, HttpServletRequest request) {

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo("");

		model.addAttribute("solicitudDetalle", solicitudDetalle);

		AsientoRegistral asientoRegistral = new AsientoRegistral();
		asientoRegistral.setIdAsiento(idAsiento);

		model.addAttribute("asientoRegistral", asientoRegistral);

		model.addAttribute("defaultLanguage", appConfiguration.get("z99aVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("z99aVistaWar.default.layout"));
		model.addAttribute("solicitudAccesoDesde", Y41bConstantes.SOLICITUDES_ACCESO_DESDE_EMPRESA);

		httpSession.setAttribute("desde", Y41bConstantes.DESDE_ASIENTO_REGISTRAL);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bTabsDetalleSolicitudNormal", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param idAsiento
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 * @throws Exception
	 */
	@RequestMapping(value = "tieneEmail/{hdCodigo}", method = RequestMethod.GET)
	public @ResponseBody boolean getCreateFormTieneMail(@PathVariable String hdCodigo, Model model,
			HttpServletRequest request) throws Exception {

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(hdCodigo);

		solicitudDetalle = this.denunciaService.findSolicitud(solicitudDetalle, censoMonitor);

		boolean tieneEmail = false;

		tieneEmail = this.santramexpService.tieneEmail(solicitudDetalle.getEscodigo(), solicitudDetalle.getEsnif(),
				Y41bConstantes.TIPO_PROC_SANCIONES);

		return tieneEmail;
	}

}