package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Decision;
import com.ejie.y41b.service.DecisionService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * * DecisionController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/decision")
public class DecisionController {

	private static final Logger logger = LoggerFactory
			.getLogger(DecisionController.class);

	@Autowired
	private DecisionService decisionService;

	@Autowired
	private Properties appConfiguration;

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormMantenimiento'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "decisiones", method = RequestMethod.GET)
	public ModelAndView getCreateFormMantenimiento(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("decisiones", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormAltaDecision'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "altaDecision", method = RequestMethod.GET)
	public ModelAndView getCreateFormAltaDecision(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("codDecision", Y41bUIDGenerator.getInstance()
				.generateId(Y41bConstantes.PK_SIZE));

		model.addAttribute("modoDecision", Y41bConstantes.MODO_POPUP_ALTA);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleDecision", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormModDecision'.
	 * 
	 * @param codDecision
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "modDecision/{codDecision}", method = RequestMethod.GET)
	public ModelAndView getCreateFormModDecision(
			@PathVariable String codDecision, Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("codDecision", codDecision);

		model.addAttribute("modoDecision",
				Y41bConstantes.MODO_POPUP_MODIFICACION);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		Decision decision = new Decision();
		decision.setDecodigo(codDecision);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleDecision", "model", model);
		}
	}

	/**
	 * Method 'getAllDecisionActivo'.
	 * 
	 * @param pcodigo
	 *            String
	 * @param detiposolicitud
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/getAllDecisionActivo", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllDecisionActivo(
			@RequestParam(value = "pcodigo", required = false) String pcodigo,
			@RequestParam(value = "detiposolicitud", required = false) String detiposolicitud,
			HttpServletRequest request) {
		try {
			Decision filterDecision = new Decision();
			filterDecision.setPcodigo(pcodigo);
			filterDecision.setDetiposolicitud(detiposolicitud);
			return this.decisionService.findAllActivos(filterDecision, null);
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllDecisionActivoNoLaudo'.
	 * 
	 * @param pcodigo
	 *            String
	 * @param detiposolicitud
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/getAllDecisionActivoNoLaudo", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllDecisionActivoNoLaudo(
			@RequestParam(value = "pcodigo", required = false) String pcodigo,
			@RequestParam(value = "detiposolicitud", required = false) String detiposolicitud,
			HttpServletRequest request) {
		try {
			Decision filterDecision = new Decision();
			filterDecision.setPcodigo(pcodigo);
			filterDecision.setDetiposolicitud(detiposolicitud);
			return this.decisionService.findAllActivosNoLaudo(filterDecision,
					null);
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param decodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "findDecision/{decodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Decision getById(@PathVariable String decodigo) {
		try {
			Decision decision = new Decision();
			decision.setDecodigo(decodigo);
			decision = this.decisionService.find(decision);
			if (decision == null) {
				throw new Exception(decodigo.toString());
			}
			return decision;
		} catch (Exception e) {
			throw new ResourceNotFoundException(decodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param decodigo
	 *            String
	 * @param denombre
	 *            String
	 * @param denombree
	 *            String
	 * @param demediacion
	 *            String
	 * @param debaja
	 *            Date
	 * @param pcodigo
	 *            String
	 * @param detiposolicitud
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "decodigo", required = false) String decodigo,
			@RequestParam(value = "denombre", required = false) String denombre,
			@RequestParam(value = "denombree", required = false) String denombree,
			@RequestParam(value = "demediacion", required = false) String demediacion,
			@RequestParam(value = "debaja", required = false) Date debaja,
			@RequestParam(value = "pcodigo", required = false) String pcodigo,
			@RequestParam(value = "detiposolicitud", required = false) String detiposolicitud,
			HttpServletRequest request) {
		try {
			Decision filterDecision = new Decision(decodigo, denombre,
					denombree, demediacion, debaja, pcodigo, detiposolicitud);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Decision> decisions = this.decisionService.findAll(
						filterDecision, pagination);

				if (decisions == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterDecision, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(decisions);
				return data;
			} else {
				List<Decision> decisions = this.decisionService.findAll(
						filterDecision, pagination);
				if (decisions == null) {
					throw new Exception("No data Found.");
				}
				return decisions;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAlldecision'. de tipo like
	 * 
	 * @param decodigo_
	 *            String
	 * @param denombre_
	 *            String
	 * @param denombree_
	 *            String
	 * @param debaja_
	 *            Date
	 * @param pcodigo_
	 *            String
	 * @param detiposolicitud_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/like", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllDecision(
			@RequestParam(value = "decodigo", required = false) String decodigo_,
			@RequestParam(value = "denombre", required = false) String denombre_,
			@RequestParam(value = "denombree", required = false) String denombree_,
			@RequestParam(value = "demediacion", required = false) String demediacion_,
			@RequestParam(value = "debaja", required = false) Date debaja_,
			@RequestParam(value = "pcodigo", required = false) String pcodigo_,
			@RequestParam(value = "detiposolicitud", required = false) String detiposolicitud_,
			HttpServletRequest request) {
		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String decodigo = ("".equals(decodigo_)) ? null : decodigo_;
			String denombre = null;
			String denombree = null;
			String demediacion = null;
			Date debaja = null;
			String detiposolicitud = null;

			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
				denombre = ("".equals(denombre_)) ? null : denombre_;
			} else {
				denombree = ("".equals(denombre_)) ? null : denombre_;
			}

			String pcodigo = ("".equals(pcodigo_)) ? null : pcodigo_;

			Decision filterDecision = new Decision(decodigo, denombre,
					denombree, demediacion, debaja, pcodigo, detiposolicitud);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Decision> decisiones = this.decisionService
						.findAllLikeDecision(filterDecision, pagination, false);

				if (decisiones == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.decisionService.findAllLikeDecisionCount(
						filterDecision, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(decisiones);
				return data;
			} else {
				List<Decision> decisiones = this.decisionService
						.findAllLikeDecision(filterDecision, pagination, false);
				if (decisiones == null) {
					throw new Exception("No data Found.");
				}
				return decisiones;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllDecision'.
	 * 
	 * @param pcodigo
	 *            String
	 * @param detiposolicitud_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/getAllDecision", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllDecision(
			@RequestParam(value = "pcodigo", required = false) String pcodigo,
			@RequestParam(value = "detiposolicitud", required = false) String detiposolicitud_,
			HttpServletRequest request) {
		try {
			Decision filterDecision = new Decision();
			filterDecision.setPcodigo(pcodigo);
			String detiposolicitud = ("".equals(detiposolicitud_)) ? null
					: detiposolicitud_;
			filterDecision.setDetiposolicitud(detiposolicitud);
			return this.decisionService.findAll(filterDecision, null);
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllDecisionBusquedaSolicitud'.
	 * 
	 * @param pcodigo
	 *            String
	 * @param detiposolicitud_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/getAllDecisionBusquedaSolicitud", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllDecisionBusquedaSolicitud(
			@RequestParam(value = "pcodigo", required = false) String pcodigo,
			@RequestParam(value = "detiposolicitud", required = false) String detiposolicitud_,
			HttpServletRequest request) {
		try {
			Decision filterDecision = new Decision();
			filterDecision.setPcodigo(pcodigo);
			String detiposolicitud = ("".equals(detiposolicitud_)) ? null
					: detiposolicitud_;
			filterDecision.setDetiposolicitud(detiposolicitud);
			return this.decisionService.findAllDecisionBusquedaSolicitud(
					filterDecision, null);
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterDecision
	 *            Decision
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "decision", required = false) Decision filterDecision,
			HttpServletRequest request) {
		try {
			return decisionService
					.findAllCount(filterDecision != null ? filterDecision
							: new Decision());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param decodigo
	 *            string
	 * @return Decision
	 */
	@RequestMapping(value = "removeDecisionLogico/{decodigo}", method = RequestMethod.PUT)
	public @ResponseBody
	Decision edit(@PathVariable String decodigo, HttpServletResponse response) {
		try {

			Decision decision = new Decision();
			decision.setDecodigo(decodigo);
			decision.setDebaja(new Date());

			Decision decisionAux = this.decisionService.updateFecha(decision);
			logger.info("Entity correctly inserted!");
			return decisionAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param decision
	 *            Decision
	 * @return Decision
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Decision add(@RequestBody Decision decision) {
		try {

			Decision decisionAux = this.decisionService.addDecision(decision);
			logger.info("Entity correctly inserted!");
			return decisionAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'editDecision'.
	 * 
	 * @param decision
	 *            Decision
	 * @param response
	 *            HttpServletResponse
	 * @return Decision
	 */
	@RequestMapping(value = "/updateDecision", method = RequestMethod.PUT)
	public @ResponseBody
	Decision editDecision(@RequestBody Decision decision,
			HttpServletResponse response) {
		try {
			Decision decisionAux = this.decisionService.update(decision);
			logger.info("Entity correctly inserted!");
			return decisionAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param decodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{decodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String decodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Decision decision = new Decision();
			decision.setDecodigo(decodigo);
			this.decisionService.remove(decision);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			logger.error("Unable to delete " + decodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param decisionIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> decisionIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Decision> decisionList = new ArrayList<Decision>();
		try {
			for (ArrayList<String> decisionId : decisionIds) {
				Iterator<String> iterator = decisionId.iterator();
				Decision decision = new Decision();
				decision.setDecodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				decisionList.add(decision);
			}
			this.decisionService.removeMultiple(decisionList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getDecisionService'.
	 * 
	 * @return DecisionService
	 */
	protected DecisionService getDecisionService() {
		return this.decisionService;
	}

	/**
	 * Method 'setDecisionService'.
	 * 
	 * @param decisionService
	 *            DecisionService
	 * @return
	 */
	public void setDecisionService(DecisionService decisionService) {
		this.decisionService = decisionService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

}
