package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.DatosMailSedeService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.DatosMailSede;

/**
 * DatosMailSedeController  
 *  
 */
 
@Controller
@RequestMapping (value = "/datosmailsede")

public class DatosMailSedeController  {

	private static final Logger logger = LoggerFactory.getLogger(DatosMailSedeController.class);

	@Autowired
	private DatosMailSedeService datosMailSedeService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		DatosMailSedeController.logger.info("[GET - View] : datosmailsede");
		return "datosmailsede";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param idDatomail String
	 * @return datosMailSede DatosMailSede
	 */
	@RequestMapping(value = "/{idDatomail}", method = RequestMethod.GET)
	public @ResponseBody DatosMailSede getById(@PathVariable String idDatomail) {
        DatosMailSede datosMailSede = new DatosMailSede();
		datosMailSede.setIdDatomail(idDatomail);
        datosMailSede = this.datosMailSedeService.find(datosMailSede);
        DatosMailSedeController.logger.info("[GET - findBy_PK] : Obtener DatosMailSede por PK");
        return datosMailSede;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterDatosMailSede DatosMailSede
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<DatosMailSede> getAll(@ModelAttribute DatosMailSede filterDatosMailSede) {
		DatosMailSedeController.logger.info("[GET - find_ALL] : Obtener DatosMailSede por filtro");
	    return this.datosMailSedeService.findAll(filterDatosMailSede, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param datosMailSede DatosMailSede 
	 * @return DatosMailSede
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody DatosMailSede edit(@RequestBody DatosMailSede datosMailSede) {		
        DatosMailSede datosMailSedeAux = this.datosMailSedeService.update(datosMailSede);
		DatosMailSedeController.logger.info("[PUT] : DatosMailSede actualizado correctamente");
        return datosMailSedeAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param datosMailSede DatosMailSede 
	 * @return DatosMailSede
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody DatosMailSede add(@RequestBody DatosMailSede datosMailSede) {		
        DatosMailSede datosMailSedeAux = this.datosMailSedeService.add(datosMailSede);
        DatosMailSedeController.logger.info("[POST] : DatosMailSede insertado correctamente");
    	return datosMailSedeAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param idDatomail String
	 * @return datosMailSede
	 */
	@RequestMapping(value = "/{idDatomail}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody DatosMailSede remove(@PathVariable String idDatomail) {
        DatosMailSede datosMailSede = new DatosMailSede();
        datosMailSede.setIdDatomail(idDatomail);
        this.datosMailSedeService.remove(datosMailSede);
       	DatosMailSedeController.logger.info("[DELETE] : DatosMailSede borrado correctamente");
       	return datosMailSede;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param datosMailSedeIds List
	 * @return datosMailSedeList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> datosMailSedeIds) {
        List<DatosMailSede> datosMailSedeList = new ArrayList<DatosMailSede>();
        for (List<String> datosMailSedeId:datosMailSedeIds) {
		    Iterator<String> iterator = datosMailSedeId.iterator();
		    DatosMailSede datosMailSede = new DatosMailSede(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        datosMailSede.setIdDatomail(ObjectConversionManager.convert(iterator.next(), String.class));
		    datosMailSedeList.add(datosMailSede);
	    }
        this.datosMailSedeService.removeMultiple(datosMailSedeList);
		DatosMailSedeController.logger.info("[POST - DELETE_ALL] : DatosMailSede borrados correctamente");
		return datosMailSedeIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterDatosMailSede DatosMailSede
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute DatosMailSede filterDatosMailSede, @ModelAttribute Pagination pagination) {
        List<DatosMailSede> datosMailSedes = this.datosMailSedeService.findAll(filterDatosMailSede, pagination);
        Long recordNum = this.datosMailSedeService.findAllCount(filterDatosMailSede);
        DatosMailSedeController.logger.info("[GET - jqGrid] : Obtener DatosMailSede");
		return new JQGridJSONModel(pagination, recordNum, datosMailSedes);
	}
	
}	
