package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.DatosMailEstablecimientoService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.DatosMailEstablecimiento;

/**
 * DatosMailEstablecimientoController  
 *  
 */
 
@Controller
@RequestMapping (value = "/datosmailestablecimiento")

public class DatosMailEstablecimientoController  {

	private static final Logger logger = LoggerFactory.getLogger(DatosMailEstablecimientoController.class);

	@Autowired
	private DatosMailEstablecimientoService datosMailEstablecimientoService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		DatosMailEstablecimientoController.logger.info("[GET - View] : datosmailestablecimiento");
		return "datosmailestablecimiento";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param idDatomail String
	 * @return datosMailEstablecimiento DatosMailEstablecimiento
	 */
	@RequestMapping(value = "/{idDatomail}", method = RequestMethod.GET)
	public @ResponseBody DatosMailEstablecimiento getById(@PathVariable String idDatomail) {
        DatosMailEstablecimiento datosMailEstablecimiento = new DatosMailEstablecimiento();
		datosMailEstablecimiento.setIdDatomail(idDatomail);
        datosMailEstablecimiento = this.datosMailEstablecimientoService.find(datosMailEstablecimiento);
        DatosMailEstablecimientoController.logger.info("[GET - findBy_PK] : Obtener DatosMailEstablecimiento por PK");
        return datosMailEstablecimiento;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterDatosMailEstablecimiento DatosMailEstablecimiento
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<DatosMailEstablecimiento> getAll(@ModelAttribute DatosMailEstablecimiento filterDatosMailEstablecimiento) {
		DatosMailEstablecimientoController.logger.info("[GET - find_ALL] : Obtener DatosMailEstablecimiento por filtro");
	    return this.datosMailEstablecimientoService.findAll(filterDatosMailEstablecimiento, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param datosMailEstablecimiento DatosMailEstablecimiento 
	 * @return DatosMailEstablecimiento
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody DatosMailEstablecimiento edit(@RequestBody DatosMailEstablecimiento datosMailEstablecimiento) {		
        DatosMailEstablecimiento datosMailEstablecimientoAux = this.datosMailEstablecimientoService.update(datosMailEstablecimiento);
		DatosMailEstablecimientoController.logger.info("[PUT] : DatosMailEstablecimiento actualizado correctamente");
        return datosMailEstablecimientoAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param datosMailEstablecimiento DatosMailEstablecimiento 
	 * @return DatosMailEstablecimiento
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody DatosMailEstablecimiento add(@RequestBody DatosMailEstablecimiento datosMailEstablecimiento) {		
        DatosMailEstablecimiento datosMailEstablecimientoAux = this.datosMailEstablecimientoService.add(datosMailEstablecimiento);
        DatosMailEstablecimientoController.logger.info("[POST] : DatosMailEstablecimiento insertado correctamente");
    	return datosMailEstablecimientoAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param idDatomail String
	 * @return datosMailEstablecimiento
	 */
	@RequestMapping(value = "/{idDatomail}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody DatosMailEstablecimiento remove(@PathVariable String idDatomail) {
        DatosMailEstablecimiento datosMailEstablecimiento = new DatosMailEstablecimiento();
        datosMailEstablecimiento.setIdDatomail(idDatomail);
        this.datosMailEstablecimientoService.remove(datosMailEstablecimiento);
       	DatosMailEstablecimientoController.logger.info("[DELETE] : DatosMailEstablecimiento borrado correctamente");
       	return datosMailEstablecimiento;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param datosMailEstablecimientoIds List
	 * @return datosMailEstablecimientoList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> datosMailEstablecimientoIds) {
        List<DatosMailEstablecimiento> datosMailEstablecimientoList = new ArrayList<DatosMailEstablecimiento>();
        for (List<String> datosMailEstablecimientoId:datosMailEstablecimientoIds) {
		    Iterator<String> iterator = datosMailEstablecimientoId.iterator();
		    DatosMailEstablecimiento datosMailEstablecimiento = new DatosMailEstablecimiento(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        datosMailEstablecimiento.setIdDatomail(ObjectConversionManager.convert(iterator.next(), String.class));
		    datosMailEstablecimientoList.add(datosMailEstablecimiento);
	    }
        this.datosMailEstablecimientoService.removeMultiple(datosMailEstablecimientoList);
		DatosMailEstablecimientoController.logger.info("[POST - DELETE_ALL] : DatosMailEstablecimiento borrados correctamente");
		return datosMailEstablecimientoIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterDatosMailEstablecimiento DatosMailEstablecimiento
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute DatosMailEstablecimiento filterDatosMailEstablecimiento, @ModelAttribute Pagination pagination) {
        List<DatosMailEstablecimiento> datosMailEstablecimientos = this.datosMailEstablecimientoService.findAll(filterDatosMailEstablecimiento, pagination);
        Long recordNum = this.datosMailEstablecimientoService.findAllCount(filterDatosMailEstablecimiento);
        DatosMailEstablecimientoController.logger.info("[GET - jqGrid] : Obtener DatosMailEstablecimiento");
		return new JQGridJSONModel(pagination, recordNum, datosMailEstablecimientos);
	}
	
}	
