package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.ContactoService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.Contacto;

/**
 * ContactoController  
 *  
 */
 
@Controller
@RequestMapping (value = "/contacto")

public class ContactoController  {

	private static final Logger logger = LoggerFactory.getLogger(ContactoController.class);

	@Autowired
	private ContactoService contactoService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ContactoController.logger.info("[GET - View] : contacto");
		return "contacto";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param contactoId String
	 * @return contacto Contacto
	 */
	@RequestMapping(value = "/{contactoId}", method = RequestMethod.GET)
	public @ResponseBody Contacto getById(@PathVariable String contactoId) {
        Contacto contacto = new Contacto();
		contacto.setContactoId(contactoId);
        contacto = this.contactoService.find(contacto);
        ContactoController.logger.info("[GET - findBy_PK] : Obtener Contacto por PK");
        return contacto;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterContacto Contacto
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Contacto> getAll(@ModelAttribute Contacto filterContacto) {
		ContactoController.logger.info("[GET - find_ALL] : Obtener Contacto por filtro");
	    return this.contactoService.findAll(filterContacto, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param contacto Contacto 
	 * @return Contacto
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody Contacto edit(@RequestBody Contacto contacto) {		
        Contacto contactoAux = this.contactoService.update(contacto);
		ContactoController.logger.info("[PUT] : Contacto actualizado correctamente");
        return contactoAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param contacto Contacto 
	 * @return Contacto
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Contacto add(@RequestBody Contacto contacto) {		
        Contacto contactoAux = this.contactoService.add(contacto);
        ContactoController.logger.info("[POST] : Contacto insertado correctamente");
    	return contactoAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param contactoId String
	 * @return contacto
	 */
	@RequestMapping(value = "/{contactoId}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody Contacto remove(@PathVariable String contactoId) {
        Contacto contacto = new Contacto();
        contacto.setContactoId(contactoId);
        this.contactoService.remove(contacto);
       	ContactoController.logger.info("[DELETE] : Contacto borrado correctamente");
       	return contacto;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param contactoIds List
	 * @return contactoList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> contactoIds) {
        List<Contacto> contactoList = new ArrayList<Contacto>();
        for (List<String> contactoId:contactoIds) {
		    Iterator<String> iterator = contactoId.iterator();
		    Contacto contacto = new Contacto(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        contacto.setContactoId(ObjectConversionManager.convert(iterator.next(), String.class));
		    contactoList.add(contacto);
	    }
        this.contactoService.removeMultiple(contactoList);
		ContactoController.logger.info("[POST - DELETE_ALL] : Contacto borrados correctamente");
		return contactoIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterContacto Contacto
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute Contacto filterContacto, @ModelAttribute Pagination pagination) {
        List<Contacto> contactos = this.contactoService.findAll(filterContacto, pagination);
        Long recordNum = this.contactoService.findAllCount(filterContacto);
        ContactoController.logger.info("[GET - jqGrid] : Obtener Contacto");
		return new JQGridJSONModel(pagination, recordNum, contactos);
	}
	
}	
