package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.ConsumidorArbitraService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41b.model.ConsumidorArbitra;

/**
 * ConsumidorArbitraController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/consumidorarbitra")
public class ConsumidorArbitraController {

	private static final Logger logger = LoggerFactory
			.getLogger(ConsumidorArbitraController.class);

	@Autowired
	private ConsumidorArbitraService consumidorArbitraService;

	@Autowired()
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ConsumidorArbitraController.logger
				.info("[GET - View] : consumidorarbitra");
		return "consumidorarbitra";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param m9codt
	 *            String
	 * @param m9cosa
	 *            String
	 * @param m9inredt
	 *            String
	 * @return consumidorArbitra ConsumidorArbitra
	 */
	@RequestMapping(value = "/{m9codt}/{m9cosa}/{m9inredt}", method = RequestMethod.GET)
	public @ResponseBody
	ConsumidorArbitra getById(@PathVariable String m9codt,
			@PathVariable String m9cosa, @PathVariable String m9inredt) {
		ConsumidorArbitra consumidorArbitra = new ConsumidorArbitra();
		consumidorArbitra.setM9codt(m9codt);
		consumidorArbitra.setM9cosa(m9cosa);
		consumidorArbitra.setM9inredt(m9inredt);
		consumidorArbitra = this.consumidorArbitraService
				.find(consumidorArbitra);
		ConsumidorArbitraController.logger
				.info("[GET - findBy_PK] : Obtener ConsumidorArbitra por PK");
		return consumidorArbitra;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterConsumidorArbitra
	 *            ConsumidorArbitra
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<ConsumidorArbitra> getAll(
			@ModelAttribute ConsumidorArbitra filterConsumidorArbitra) {
		ConsumidorArbitraController.logger
				.info("[GET - find_ALL] : Obtener ConsumidorArbitra por filtro");
		return this.consumidorArbitraService.findAll(filterConsumidorArbitra,
				null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param consumidorArbitra
	 *            ConsumidorArbitra
	 * @return ConsumidorArbitra
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	ConsumidorArbitra edit(@RequestBody ConsumidorArbitra consumidorArbitra) {
		ConsumidorArbitra consumidorArbitraAux = this.consumidorArbitraService
				.update(consumidorArbitra);
		ConsumidorArbitraController.logger
				.info("[PUT] : ConsumidorArbitra actualizado correctamente");
		return consumidorArbitraAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param consumidorArbitra
	 *            ConsumidorArbitra
	 * @return ConsumidorArbitra
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	ConsumidorArbitra add(@RequestBody ConsumidorArbitra consumidorArbitra) {
		ConsumidorArbitra consumidorArbitraAux = this.consumidorArbitraService
				.add(consumidorArbitra);
		ConsumidorArbitraController.logger
				.info("[POST] : ConsumidorArbitra insertado correctamente");
		return consumidorArbitraAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param m9codt
	 *            String
	 * @param m9cosa
	 *            String
	 * @param m9inredt
	 *            String
	 * @return consumidorArbitra
	 */
	@RequestMapping(value = "/{m9codt}/{m9cosa}/{m9inredt}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	ConsumidorArbitra remove(@PathVariable String m9codt,
			@PathVariable String m9cosa, @PathVariable String m9inredt) {
		ConsumidorArbitra consumidorArbitra = new ConsumidorArbitra();
		consumidorArbitra.setM9codt(m9codt);
		consumidorArbitra.setM9cosa(m9cosa);
		consumidorArbitra.setM9inredt(m9inredt);
		this.consumidorArbitraService.remove(consumidorArbitra);
		ConsumidorArbitraController.logger
				.info("[DELETE] : ConsumidorArbitra borrado correctamente");
		return consumidorArbitra;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param consumidorArbitraIds
	 *            List
	 * @return consumidorArbitraList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> consumidorArbitraIds) {
		List<ConsumidorArbitra> consumidorArbitraList = new ArrayList<ConsumidorArbitra>();
		for (List<String> consumidorArbitraId : consumidorArbitraIds) {
			Iterator<String> iterator = consumidorArbitraId.iterator();
			ConsumidorArbitra consumidorArbitra = new ConsumidorArbitra(); // NOPMD
																			// -
																			// Objeto
																			// nuevo
																			// en
																			// la
																			// lista
																			// (parametro
																			// del
																			// servicio)
			consumidorArbitra.setM9codt(ObjectConversionManager.convert(
					iterator.next(), String.class));
			consumidorArbitra.setM9cosa(ObjectConversionManager.convert(
					iterator.next(), String.class));
			consumidorArbitra.setM9inredt(ObjectConversionManager.convert(
					iterator.next(), String.class));
			consumidorArbitraList.add(consumidorArbitra);
		}
		this.consumidorArbitraService.removeMultiple(consumidorArbitraList);
		ConsumidorArbitraController.logger
				.info("[POST - DELETE_ALL] : ConsumidorArbitra borrados correctamente");
		return consumidorArbitraIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterConsumidorArbitra
	 *            ConsumidorArbitra
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute ConsumidorArbitra filterConsumidorArbitra,
			@ModelAttribute Pagination pagination) {
		List<ConsumidorArbitra> consumidorArbitras = this.consumidorArbitraService
				.findAll(filterConsumidorArbitra, pagination);
		Long recordNum = this.consumidorArbitraService
				.findAllCount(filterConsumidorArbitra);
		ConsumidorArbitraController.logger
				.info("[GET - jqGrid] : Obtener ConsumidorArbitra");
		return new JQGridJSONModel(pagination, recordNum, consumidorArbitras);
	}

	/**
	 * Method 'getCreateFormModal'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintModal", method = RequestMethod.GET)
	public ModelAndView getCreateFormModal(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("consumidorModal", "model", model);
	}

}
