package com.ejie.y41b.control;

import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.rowset.serial.SerialBlob;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.model.Consulta;
import com.ejie.y41b.model.ConsultaFile;
import com.ejie.y41b.model.DocumentoConsultaDetalle;
import com.ejie.y41b.service.ConsultaFileService;
import com.ejie.y41b.service.ConsultaService;

/**
 * * ConsultaFileController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/consultafile")
public class ConsultaFileController {

	private static final Logger logger = LoggerFactory
			.getLogger(ConsultaFileController.class);

	@Autowired
	private ConsultaFileService consultaFileService;

	@Autowired
	private ConsultaService consultaService;

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));
		return new ModelAndView("consultafile", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param q4codocumento
	 *            Long
	 * @return String
	 */
	@RequestMapping(value = "/{q4codocumento}", method = RequestMethod.GET)
	public @ResponseBody
	ConsultaFile getById(@PathVariable Long q4codocumento) {
		try {
			ConsultaFile consultaFile = new ConsultaFile();
			consultaFile.setQ4codocumento(q4codocumento);
			consultaFile = this.consultaFileService.find(consultaFile);
			if (consultaFile == null) {
				throw new Exception(q4codocumento.toString());
			}
			return consultaFile;
		} catch (Exception e) {
			throw new ResourceNotFoundException(q4codocumento.toString());
		}
	}

	/**
	 * Method 'getAllFilesConsultaByIdConsulta'.
	 * 
	 * @param cocodigo
	 *            String
	 * 
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return String
	 */
	@RequestMapping(value = "/allFiles/{cocodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllFilesConsultaByIdConsulta(@PathVariable String cocodigo,
			HttpServletRequest request) {
		try {
			Consulta consulta = new Consulta();
			consulta.setCocodigo(cocodigo);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<DocumentoConsultaDetalle> lDocsConsultaDetalle = this.consultaService
						.findAllFileConsulta(consulta, pagination);

				if (lDocsConsultaDetalle == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.consultaService
						.findAllFileConsultaCount(consulta);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(lDocsConsultaDetalle);

				return data;

			} else {
				List<DocumentoConsultaDetalle> lDocsConsultaDetalle = this.consultaService
						.findAllFileConsulta(consulta, pagination);
				if (lDocsConsultaDetalle == null) {
					throw new Exception("No data Found.");
				}
				return lDocsConsultaDetalle;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param q4codocumento
	 *            Integer
	 * @param consultaCocodigo
	 *            String
	 * @param q4nofile
	 *            String
	 * @param q4sizefile
	 *            Integer
	 * @param q4tedesfile
	 *            String
	 * @param q4fecha
	 *            Date
	 * @param q4origen
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "q4codocumento", required = false) Long q4codocumento,
			@RequestParam(value = "consultaCocodigo", required = false) String consultaCocodigo,
			@RequestParam(value = "q4nofile", required = false) String q4nofile,
			@RequestParam(value = "q4sizefile", required = false) Integer q4sizefile,
			@RequestParam(value = "q4tedesfile", required = false) String q4tedesfile,
			@RequestParam(value = "q4fecha", required = false) Date q4fecha,
			@RequestParam(value = "q4origen", required = false) String q4origen,
			HttpServletRequest request) {
		try {
			ConsultaFile filterConsultaFile = new ConsultaFile(q4codocumento,
					q4nofile, null, q4sizefile, q4tedesfile, q4fecha, q4origen,
					null, new Consulta(consultaCocodigo, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<ConsultaFile> consultaFiles = this.consultaFileService
						.findAll(filterConsultaFile, pagination);

				if (consultaFiles == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterConsultaFile, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(consultaFiles);
				return data;
			} else {
				List<ConsultaFile> consultaFiles = this.consultaFileService
						.findAll(filterConsultaFile, pagination);
				if (consultaFiles == null) {
					throw new Exception("No data Found.");
				}
				return consultaFiles;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterConsultaFile
	 *            ConsultaFile
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "consultaFile", required = false) ConsultaFile filterConsultaFile,
			HttpServletRequest request) {
		try {
			return consultaFileService
					.findAllCount(filterConsultaFile != null ? filterConsultaFile
							: new ConsultaFile());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param consultaFile
	 *            ConsultaFile
	 * @param response
	 *            HttpServletResponse
	 * @return ConsultaFile
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	ConsultaFile edit(@RequestBody ConsultaFile consultaFile,
			HttpServletResponse response) {
		try {
			ConsultaFile consultaFileAux = this.consultaFileService
					.update(consultaFile);
			logger.info("Entity correctly inserted!");
			return consultaFileAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param consultaFile
	 *            ConsultaFile
	 * @return ConsultaFile
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	ConsultaFile add(@RequestBody ConsultaFile consultaFile) {
		try {
			ConsultaFile consultaFileAux = this.consultaFileService
					.add(consultaFile);
			logger.info("Entity correctly inserted!");
			return consultaFileAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'addDocumentoConsultaDetalle'.
	 * 
	 * @param file
	 *            MultipartFile
	 * 
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return ConsultaFile
	 */
	@RequestMapping(value = "subidaConsulta", method = RequestMethod.POST)
	public @ResponseBody
	List<Map<String, Object>> addDocumentoConsultaDetalle(
			@RequestParam(value = "files[]", required = false) MultipartFile file,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			String cocodigo = request.getParameter("cocodigo");
			String coinl21 = request.getParameter("coinl21");
			String desc = request.getParameter("desc");

			// CONSULTA FILE
			ConsultaFile consultaFile = new ConsultaFile();

			Consulta consulta = new Consulta();
			consulta.setCocodigo(cocodigo);
			// Organismo organismo = new Organismo();
			// organismo.setCodOrg(codOrg);
			// consulta.setOrganismo(organismo);
			// consulta.setConrreg(conrreg);
			// consulta.setConranrg(conranrg);
			consultaFile.setConsulta(consulta);

			Blob blob = new SerialBlob(file.getBytes());
			consultaFile.setQ4datafile(blob);
			consultaFile.setQ4contenttypefile(file.getContentType());
			consultaFile.setQ4nofile(file.getOriginalFilename());
			consultaFile.setQ4sizefile((int) file.getSize());
			consultaFile.setQ4tedesfile(desc);
			consultaFile.setQ4fecha(new Date());
			consultaFile.setQ4origen(coinl21);

			ConsultaFile consultaFileAux = this.consultaService
					.addFileConsulta(consultaFile);

			logger.info("Entity correctly inserted!" + consultaFileAux);

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			filesMetaInfo.add(this.getFileReturnMap(file));
			return filesMetaInfo;

		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException(
					"Method failed addDocumentoConsultaDetalle");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param q4codocumento
	 *            Long
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{q4codocumento}", method = RequestMethod.DELETE)
	public void remove(@PathVariable Long q4codocumento,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			ConsultaFile consultaFile = new ConsultaFile();
			consultaFile.setQ4codocumento(q4codocumento);
			this.consultaFileService.remove(consultaFile);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + q4codocumento);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param consultaFileIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> consultaFileIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<ConsultaFile> consultaFileList = new ArrayList<ConsultaFile>();
		try {
			for (ArrayList<String> consultaFileId : consultaFileIds) {
				Iterator<String> iterator = consultaFileId.iterator();
				ConsultaFile consultaFile = new ConsultaFile();
				consultaFile.setQ4codocumento(ObjectConversionManager.convert(
						iterator.next(), Long.class));
				consultaFileList.add(consultaFile);
			}
			this.consultaFileService.removeMultiple(consultaFileList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getConsultaFileService'.
	 * 
	 * @return ConsultaFileService
	 */
	protected ConsultaFileService getConsultaFileService() {
		return this.consultaFileService;
	}

	/**
	 * Method 'setConsultaFileService'.
	 * 
	 * @param consultaFileService
	 *            ConsultaFileService
	 * @return
	 */
	public void setConsultaFileService(ConsultaFileService consultaFileService) {
		this.consultaFileService = consultaFileService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * 
	 * @param file
	 *            MultipartFile
	 * @return mapa
	 */
	private Map<String, Object> getFileReturnMap(MultipartFile file) {
		Map<String, Object> mapaRetorno = new HashMap<String, Object>();
		mapaRetorno.put("url", "/y41bVistaWar/consultafile/subidaFichero/"
				+ file.getOriginalFilename() + "?R01HNoPortal=true");
		mapaRetorno.put("name", file.getOriginalFilename());
		mapaRetorno.put("type", file.getContentType());
		mapaRetorno.put("size", file.getSize());
		mapaRetorno.put(
				"delete_url",
				"/y41bVistaWar/consultafile/subidaFichero/"
						+ file.getOriginalFilename() + "?R01HNoPortal=true");
		mapaRetorno.put("delete_type", "DELETE");
		return mapaRetorno;
	}

	/**
	 * Method 'getByIdDocumentoConsultaDetalle'.
	 * 
	 * @param cofile
	 *            Long
	 * @param tipofile
	 *            String
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/{cofile}/{tipofile}", method = RequestMethod.GET)
	public @ResponseBody
	// ConsultaFile getByIdDocumentoConsultaDetalle(@PathVariable Long cofile,
	// @PathVariable String tipofile, HttpServletResponse response) {
	void getByIdDocumentoConsultaDetalle(@PathVariable Long cofile,
			@PathVariable String tipofile, HttpServletResponse response) {
		try {

			DocumentoConsultaDetalle documentoConsultaDetalle = new DocumentoConsultaDetalle();
			documentoConsultaDetalle.setCofile(cofile);
			documentoConsultaDetalle.setTipofile(tipofile);
			documentoConsultaDetalle = this.consultaService
					.findFileConsulta(documentoConsultaDetalle);

			if (documentoConsultaDetalle == null) {
				this.consultaService
						.removeLobTablaTemporal(documentoConsultaDetalle);
				throw new Exception(cofile.toString());
			}

			Blob contenido = documentoConsultaDetalle.getDatafile();
			byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

			this.consultaService
					.removeLobTablaTemporal(documentoConsultaDetalle);

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader(
					"Content-Disposition",
					"attachment; filename=\""
							+ StringEscapeUtils
									.unescapeHtml(documentoConsultaDetalle
											.getNofile()) + "\"");
			response.setContentType(documentoConsultaDetalle
					.getContenttypefile());
			response.setContentLength(documentoConsultaDetalle.getSizefile());
			response.getOutputStream().write(bContenido);

			// Vaciamos el stream
			response.getOutputStream().flush();

			// return documentoConsultaDetalle;
		} catch (Exception e) {
			throw new ResourceNotFoundException(cofile.toString());
		}
	}

}
