package com.ejie.y41b.control;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Consulta;
import com.ejie.y41b.model.ConsultaBusqueda;
import com.ejie.y41b.model.ConsultaDetalle;
import com.ejie.y41b.model.ConsultaRespuestaConsulta;
import com.ejie.y41b.model.ConsultaRespuestaEmail;
import com.ejie.y41b.model.FormaPresentacion;
import com.ejie.y41b.model.Motivo;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.Producto;
import com.ejie.y41b.model.RangoEdad;
import com.ejie.y41b.model.Respuesta;
import com.ejie.y41b.model.TipoRespuesta;
import com.ejie.y41b.service.ConsultaService;
import com.ejie.y41b.service.Y41bExcelGeneratorService;
import com.ejie.y41b.utils.Y41bStringUtils;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.documentos.Y41bDocumento;
import com.ejie.y41b.utils.documentos.Y41bGenerarDocumento;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * * ConsultaController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/consulta")
@SessionAttributes({ "consultaBusqueda", "consultaDetalle" })
public class ConsultaController {

	private static final Logger logger = LoggerFactory.getLogger(ConsultaController.class);

	@Autowired
	private ConsultaService consultaService;

	@Autowired
	private Y41bExcelGeneratorService y41bExcelGeneratorService;

	@Autowired
	private Properties appConfiguration;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilConsultas() == null || censoMonitor.getPerfilConsultas().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("consulta", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintBusquedaResultado", method = RequestMethod.GET)
	public ModelAndView getCreateFormBusquedaResultado(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		// precarga de los valores del conectado
		Consulta consultaBusqueda = new Consulta();
		// consultaBusqueda.setCensoMonitor(censoMonitor);

		if (censoMonitor.getOrganismo() != null) {
			Organismo organismo = new Organismo();
			organismo.setCodOrg(censoMonitor.getOrganismo().getCodOrg());
			consultaBusqueda.setOrganismo(organismo);
		}
		try {
			consultaBusqueda.setConranrg(Long.parseLong(Y41bUtils.fncObtenerAnnoSistema()));
		} catch (Exception e) {
		}
		consultaBusqueda.setCosituacion(Y41bConstantes.SITUACION_PENDIENTES);

		model.addAttribute("consultaBusqueda", consultaBusqueda);
		model.addAttribute("consultaAccesoDesde", Y41bConstantes.CONSULTAS_ACCESO_DESDE_CONSULTAS);

		if (censoMonitor.getPerfilConsultas() == null || censoMonitor.getPerfilConsultas().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("busquedaResultado", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintBusquedaResultadoAACC", method = RequestMethod.GET)
	public ModelAndView getCreateFormBusquedaResultadoAACC(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		// precarga de los valores del conectado
		Consulta consultaBusqueda = new Consulta();
		// consultaBusqueda.setCensoMonitor(censoMonitor);

		if (censoMonitor.getOrganismo() != null) {
			Organismo organismo = new Organismo();
			organismo.setCodOrg(censoMonitor.getOrganismo().getCodOrg());
			consultaBusqueda.setOrganismo(organismo);
		}
		try {
			consultaBusqueda.setConranrg(Long.parseLong(Y41bUtils.fncObtenerAnnoSistema()));
		} catch (Exception e) {
		}
		consultaBusqueda.setCosituacion(Y41bConstantes.SITUACION_PENDIENTES);

		model.addAttribute("consultaBusqueda", consultaBusqueda);
		model.addAttribute("consultaAccesoDesde", Y41bConstantes.CONSULTAS_ACCESO_DESDE_EMPRESA);

		if (censoMonitor.getPerfilOrganizacion() == null || censoMonitor.getPerfilOrganizacion().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("busquedaResultado", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintBusqueda", method = RequestMethod.GET)
	public ModelAndView getCreateFormBusqueda(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilConsultas() == null || censoMonitor.getPerfilConsultas().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("busqueda", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintBusquedaAACC", method = RequestMethod.GET)
	public ModelAndView getCreateFormBusquedaAACC(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilOrganizacion() == null || censoMonitor.getPerfilOrganizacion().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("busqueda", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintResultado", method = RequestMethod.GET)
	public ModelAndView getCreateFormResultado(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilConsultas() == null || censoMonitor.getPerfilConsultas().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("resultado", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintResultadoAACC", method = RequestMethod.GET)
	public ModelAndView getCreateFormResultadoAACC(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilOrganizacion() == null || censoMonitor.getPerfilOrganizacion().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("resultado", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormTabsDetalleDocs'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintTabsDetalleDocs", method = RequestMethod.GET)
	public ModelAndView getCreateFormTabsDetalleDocs(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		ConsultaDetalle consultaDetalle = new ConsultaDetalle();
		model.addAttribute("consultaDetalle", consultaDetalle);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilConsultas() == null || censoMonitor.getPerfilConsultas().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("tabsDetalleDocs", "model", model);
		}

	}

	/**
	 * Method 'getCreateFormTabsDetalleDocs'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintTabsDetalleDocsAACC", method = RequestMethod.GET)
	public ModelAndView getCreateFormTabsDetalleDocsAACC(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		ConsultaDetalle consultaDetalle = new ConsultaDetalle();
		model.addAttribute("consultaDetalle", consultaDetalle);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		model.addAttribute("consultaAccesoDesde", Y41bConstantes.CONSULTAS_ACCESO_DESDE_EMPRESA);
		if (censoMonitor.getPerfilOrganizacion() == null || censoMonitor.getPerfilOrganizacion().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("tabsDetalleDocs", "model", model);
		}

	}

	/**
	 * Method 'getCreateFormAltaTabsDetalleDocs'.
	 * 
	 * @param cocodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintAltaTabsDetalleDocs/{cocodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormAltaTabsDetalleDocs(@PathVariable String cocodigo, Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		ConsultaDetalle consultaDetalle = new ConsultaDetalle();
		consultaDetalle.setCocodigo(cocodigo);

		model.addAttribute("consultaDetalle", consultaDetalle);
		model.addAttribute("consultaAccesoDesde", Y41bConstantes.CONSULTAS_ACCESO_DESDE_CONSULTAS);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilConsultas() == null || censoMonitor.getPerfilConsultas().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("tabsAltaDetalleDocs", "model", model);
		}

	}

	/**
	 * Method 'getCreateFormAltaTabsDetalleDocsAACC'.
	 * 
	 * @param cocodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintAltaTabsDetalleDocsAACC/{cocodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormAltaTabsDetalleDocsAACC(@PathVariable String cocodigo, Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		ConsultaDetalle consultaDetalle = new ConsultaDetalle();
		consultaDetalle.setCocodigo(cocodigo);

		model.addAttribute("consultaDetalle", consultaDetalle);
		model.addAttribute("consultaAccesoDesde", Y41bConstantes.CONSULTAS_ACCESO_DESDE_EMPRESA);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilOrganizacion() == null || censoMonitor.getPerfilOrganizacion().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("tabsAltaDetalleDocs", "model", model);
		}

	}

	/**
	 * Method 'getCreateFormDetalleConsulta'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintDetalleConsulta", method = RequestMethod.GET)
	public ModelAndView getCreateFormDetalleConsulta(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilConsultas() == null || censoMonitor.getPerfilConsultas().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleConsulta", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormDetalleConsulta'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintDetalleConsultaAACC", method = RequestMethod.GET)
	public ModelAndView getCreateFormDetalleConsultaAACC(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilOrganizacion() == null || censoMonitor.getPerfilOrganizacion().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleConsulta", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormAlta'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintAltaConsulta", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		model.addAttribute("consultaAccesoDesde", Y41bConstantes.CONSULTAS_ACCESO_DESDE_CONSULTAS);

		if (censoMonitor.getPerfilConsultas() == null
				|| censoMonitor.getPerfilConsultas().getIdPerfil().equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)
				|| censoMonitor.getPerfilConsultas().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_CONSULTA_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("altaConsulta", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormAltaAACC'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintAltaConsultaAACC", method = RequestMethod.GET)
	public ModelAndView getCreateFormAltaAACC(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		model.addAttribute("consultaAccesoDesde", Y41bConstantes.CONSULTAS_ACCESO_DESDE_EMPRESA);

		if (censoMonitor.getPerfilOrganizacion() == null
				|| censoMonitor.getPerfilOrganizacion().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)
				|| censoMonitor.getPerfilOrganizacion().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_CONSULTA_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("altaConsulta", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintDocumentos", method = RequestMethod.GET)
	public ModelAndView getCreateFormDocumentos(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilConsultas() == null || censoMonitor.getPerfilConsultas().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("documentosConsulta", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintDocumentosAACC", method = RequestMethod.GET)
	public ModelAndView getCreateFormDocumentosAACC(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilOrganizacion() == null || censoMonitor.getPerfilOrganizacion().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("documentosConsulta", "model", model);
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param cocodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{cocodigo}", method = RequestMethod.GET)
	public @ResponseBody Consulta getById(@PathVariable String cocodigo) {
		try {
			Consulta consulta = new Consulta();
			consulta.setCocodigo(cocodigo);
			consulta = this.consultaService.find(consulta);
			if (consulta == null) {
				throw new Exception(cocodigo.toString());
			}
			return consulta;
		} catch (Exception e) {
			throw new ResourceNotFoundException(cocodigo.toString());
		}
	}

	/**
	 * Method 'getByIdConsulta'.
	 * 
	 * @param cocodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/edicion/{cocodigo}", method = RequestMethod.GET)
	public @ResponseBody ConsultaDetalle getByIdConsulta(@PathVariable String cocodigo) {
		try {
			Consulta consulta = new Consulta();
			consulta.setCocodigo(cocodigo);
			ConsultaDetalle consultaDetalle = this.consultaService.findConsulta(consulta);
			if (consultaDetalle == null) {
				throw new Exception(cocodigo.toString());
			}

			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			String cofechaconshora = "";
			if (consultaDetalle.getCofechaconsumidor() != null) {
				if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
					cofechaconshora = Y41bUtils.formatearDateToString(consultaDetalle.getCofechaconsumidor(),
							Y41bConstantes.FORMATO_FECHAHORA_ES);
				} else if (Y41bConstantes.EUSKERA.equalsIgnoreCase(idioma)) {
					cofechaconshora = Y41bUtils.formatearDateToString(consultaDetalle.getCofechaconsumidor(),
							Y41bConstantes.FORMATO_FECHAHORA_EU);
				}
				consultaDetalle.setCofechaconshora(cofechaconshora);

				String strTime = cofechaconshora.substring(Y41bConstantes.NUM_CARACTERES_FECHA);
				consultaDetalle.setLlegadaHoras(strTime.split(":")[0]);
				consultaDetalle.setLlegadaMinutos(strTime.split(":")[1]);
			}

			if (Y41bUtils.isFilled(consultaDetalle.getCohora())) {
				String strTime = consultaDetalle.getCohora();
				consultaDetalle.setAtencionHoras(strTime.split(":")[0]);
				consultaDetalle.setAtencionMinutos(strTime.split(":")[1]);
			}

			return consultaDetalle;
		} catch (Exception e) {
			throw new ResourceNotFoundException(cocodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param cocodigo
	 *            String
	 * @param motivoTircodigo
	 *            String
	 * @param productoPscodigo
	 *            String
	 * @param rangoEdadRancod
	 *            String
	 * @param formaPresentacionTfpcodigo
	 *            String
	 * @param organismoCodOrg
	 *            String
	 * @param censoMonitorMocodigo
	 *            String
	 * @param cofecha
	 *            Date
	 * @param cocosx
	 *            String
	 * @param conran
	 *            String
	 * @param cocose
	 *            String
	 * @param cotexto
	 *            String
	 * @param conrreg
	 *            Integer
	 * @param conoco
	 *            String
	 * @param conodirco
	 *            String
	 * @param conrcpco
	 *            String
	 * @param cocoloco
	 *            String
	 * @param conoloco
	 *            String
	 * @param conomuco
	 *            String
	 * @param cocopvco
	 *            String
	 * @param cocopaco
	 *            String
	 * @param conrtelco
	 *            String
	 * @param conrfaxco
	 *            String
	 * @param cocoemco
	 *            String
	 * @param coferes
	 *            Date
	 * @param coinreenv
	 *            String
	 * @param coteresp
	 *            String
	 * @param cocotfpr
	 *            String
	 * @param coinl37
	 *            String
	 * @param conranrg
	 *            Long
	 * @param cocopro
	 *            String
	 * @param cohdcodigo
	 *            String
	 * @param cohora
	 *            String
	 * @param cofechaconsumidor
	 *            Date
	 * @param noraPaisId
	 *            String
	 * @param nombrePais
	 *            String
	 * @param provinciaId
	 *            String
	 * @param nombreProvincia
	 *            String
	 * @param municipioId
	 *            String
	 * @param nombreMunicipio
	 *            String
	 * @param localidadId
	 *            String
	 * @param nombreLocalidad
	 *            String
	 * @param noraCalleId
	 *            String
	 * @param nombreCalle
	 *            String
	 * @param noraCpId
	 *            String
	 * @param nombreCp
	 *            String
	 * @param noraPortalId
	 *            String
	 * @param nombrePortal
	 *            String
	 * @param coinl21
	 *            String
	 * @param cosituacion
	 *            String
	 * @param nombrePiso
	 *            String
	 * @param coextranjero
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody Object getAll(@RequestParam(value = "cocodigo", required = false) String cocodigo,
			@RequestParam(value = "motivoTircodigo", required = false) String motivoTircodigo,
			@RequestParam(value = "productoPscodigo", required = false) String productoPscodigo,
			@RequestParam(value = "rangoEdadRancod", required = false) String rangoEdadRancod,
			@RequestParam(value = "formaPresentacionTfpcodigo", required = false) String formaPresentacionTfpcodigo,
			@RequestParam(value = "organismoCodOrg", required = false) String organismoCodOrg,
			@RequestParam(value = "censoMonitorMocodigo", required = false) String censoMonitorMocodigo,
			@RequestParam(value = "cofecha", required = false) Date cofecha,
			@RequestParam(value = "cocosx", required = false) String cocosx,
			@RequestParam(value = "conran", required = false) String conran,
			@RequestParam(value = "cocose", required = false) String cocose,
			@RequestParam(value = "cotexto", required = false) String cotexto,
			@RequestParam(value = "conrreg", required = false) Integer conrreg,
			@RequestParam(value = "conoco", required = false) String conoco,
			@RequestParam(value = "conodirco", required = false) String conodirco,
			@RequestParam(value = "conrcpco", required = false) String conrcpco,
			@RequestParam(value = "cocoloco", required = false) String cocoloco,
			@RequestParam(value = "conoloco", required = false) String conoloco,
			@RequestParam(value = "conomuco", required = false) String conomuco,
			@RequestParam(value = "cocopvco", required = false) String cocopvco,
			@RequestParam(value = "cocopaco", required = false) String cocopaco,
			@RequestParam(value = "conrtelco", required = false) String conrtelco,
			@RequestParam(value = "conrfaxco", required = false) String conrfaxco,
			@RequestParam(value = "cocoemco", required = false) String cocoemco,
			@RequestParam(value = "coferes", required = false) Date coferes,
			@RequestParam(value = "coinreenv", required = false) String coinreenv,
			@RequestParam(value = "coteresp", required = false) String coteresp,
			@RequestParam(value = "cocotfpr", required = false) String cocotfpr,
			@RequestParam(value = "coinl37", required = false) String coinl37,
			@RequestParam(value = "conranrg", required = false) Long conranrg,
			@RequestParam(value = "cocopro", required = false) String cocopro,
			@RequestParam(value = "cohdcodigo", required = false) String cohdcodigo,
			@RequestParam(value = "cohora", required = false) String cohora,
			@RequestParam(value = "cofechaconsumidor", required = false) Date cofechaconsumidor,
			@RequestParam(value = "noraPaisId", required = false) String noraPaisId,
			@RequestParam(value = "nombrePais", required = false) String nombrePais,
			@RequestParam(value = "provinciaId", required = false) String provinciaId,
			@RequestParam(value = "nombreProvincia", required = false) String nombreProvincia,
			@RequestParam(value = "municipioId", required = false) String municipioId,
			@RequestParam(value = "nombreMunicipio", required = false) String nombreMunicipio,
			@RequestParam(value = "localidadId", required = false) String localidadId,
			@RequestParam(value = "nombreLocalidad", required = false) String nombreLocalidad,
			@RequestParam(value = "noraCalleId", required = false) String noraCalleId,
			@RequestParam(value = "nombreCalle", required = false) String nombreCalle,
			@RequestParam(value = "noraCpId", required = false) String noraCpId,
			@RequestParam(value = "nombreCp", required = false) String nombreCp,
			@RequestParam(value = "noraPortalId", required = false) String noraPortalId,
			@RequestParam(value = "nombrePortal", required = false) String nombrePortal,
			@RequestParam(value = "coinl21", required = false) String coinl21,
			@RequestParam(value = "cosituacion", required = false) String cosituacion,
			@RequestParam(value = "nombrePiso", required = false) String nombrePiso,
			@RequestParam(value = "coextranjero", required = false) String coextranjero, HttpServletRequest request) {
		try {
			Consulta filterConsulta = new Consulta(cocodigo, new Motivo(motivoTircodigo, null, null),
					new Producto(productoPscodigo, null, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null),
					new RangoEdad(rangoEdadRancod, null, null, null),
					new FormaPresentacion(formaPresentacionTfpcodigo, null, null, null, null, null, null),
					new Organismo(organismoCodOrg),
					new CensoMonitor(censoMonitorMocodigo, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null),
					cofecha, cocosx, conran, cocose, cotexto, conrreg, conoco, conodirco, conrcpco, cocoloco, conoloco,
					conomuco, cocopvco, cocopaco, conrtelco, conrfaxco, cocoemco, coferes, coinreenv, coteresp,
					cocotfpr, coinl37, conranrg, cocopro, cohdcodigo, cohora, cofechaconsumidor, noraPaisId, nombrePais,
					provinciaId, nombreProvincia, municipioId, nombreMunicipio, localidadId, nombreLocalidad,
					noraCalleId, nombreCalle, noraCpId, nombreCp, noraPortalId, nombrePortal, coinl21, cosituacion,
					nombrePiso, coextranjero, null, null, null, null, null, null, null, null);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Consulta> consultas = this.consultaService.findAll(filterConsulta, pagination);

				if (consultas == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterConsulta, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(consultas);
				return data;
			} else {
				List<Consulta> consultas = this.consultaService.findAll(filterConsulta, pagination);
				if (consultas == null) {
					throw new Exception("No data Found.");
				}
				return consultas;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterConsulta
	 *            Consulta
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody Long getAllCount(@RequestParam(value = "consulta", required = false) Consulta filterConsulta,
			HttpServletRequest request) {
		try {
			return consultaService.findAllCount(filterConsulta != null ? filterConsulta : new Consulta());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}

	/**
	 * Method 'getFichaByIdConsulta'.
	 * 
	 * @param cocodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * 
	 */
	@RequestMapping(value = "/ficha/{cocodigo}", method = RequestMethod.GET)
	public @ResponseBody void getFichaByIdConsulta(@PathVariable String cocodigo, HttpServletResponse response) {
		try {

			Consulta consulta = new Consulta();
			consulta.setCocodigo(cocodigo);
			ConsultaDetalle consultaDetalle = this.consultaService.findConsulta(consulta);
			if (consultaDetalle == null) {
				throw new Exception(cocodigo.toString());
			}

			if (consultaDetalle != null && consultaDetalle.getCoconsultaaaccempresas() != null
					&& consultaDetalle.getCoconsultaaaccempresas().equals(Y41bConstantes.SI)) {
				consultaDetalle.setConoco(consultaDetalle.getConombrecomercial());
			}

			if (consultaDetalle.getCalleId_label() == null || consultaDetalle.getCalleId_label().equals("")) {
				if (consultaDetalle.getDireccion_nocapv() == null || consultaDetalle.getDireccion_nocapv().equals("")) {
					consultaDetalle.setCalleId_label(consultaDetalle.getDireccionAntiguaCompleta());
				} else {
					consultaDetalle.setCalleId_label(consultaDetalle.getDireccion_nocapv());
				}
			} else {
				StringBuffer domicilio = new StringBuffer();
				domicilio.append(consultaDetalle.getCalleId_label());

				if (consultaDetalle.getNombrePortal() != null) {
					domicilio.append(", ").append(consultaDetalle.getNombrePortal());
				}
				if (consultaDetalle.getNombrePiso() != null) {
					domicilio.append(" ").append(consultaDetalle.getNombrePiso());
				}
				consultaDetalle.setCalleId_label(domicilio.toString());
			}

			// tratamiento de los datos temporales (horas)
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			String cofechaconshora = "";
			if (consultaDetalle.getCofechaconsumidor() != null) {
				if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
					cofechaconshora = Y41bUtils.formatearDateToString(consultaDetalle.getCofechaconsumidor(),
							Y41bConstantes.FORMATO_FECHAHORA_ES);
				} else if (Y41bConstantes.EUSKERA.equalsIgnoreCase(idioma)) {
					cofechaconshora = Y41bUtils.formatearDateToString(consultaDetalle.getCofechaconsumidor(),
							Y41bConstantes.FORMATO_FECHAHORA_EU);
				}
				consultaDetalle.setCofechaconshora(cofechaconshora);

				String strTime = cofechaconshora.substring(Y41bConstantes.NUM_CARACTERES_FECHA);
				consultaDetalle.setLlegadaHoras(strTime.split(":")[0]);
				consultaDetalle.setLlegadaMinutos(strTime.split(":")[1]);
			}

			if (Y41bUtils.isFilled(consultaDetalle.getCohora())) {
				String strTime = consultaDetalle.getCohora();
				consultaDetalle.setAtencionHoras(strTime.split(":")[0]);
				consultaDetalle.setAtencionMinutos(strTime.split(":")[1]);
			}

			if (Y41bUtils.isFilled(consultaDetalle.getP9teres())) {
				// Tratamiento tiny
				consultaDetalle.setP9teres(consultaDetalle.getP9teres().replaceAll("</p>", "&lineSeparator;"));
				consultaDetalle.setP9teres(consultaDetalle.getP9teres().replaceAll("<br/>", "&lineSeparator;"));
				consultaDetalle.setP9teres(consultaDetalle.getP9teres().replaceAll("</li>", "&lineSeparator;"));

				// negrita
				consultaDetalle.setP9teres(consultaDetalle.getP9teres().replaceAll("<strong>", "&negritaini;"));
				consultaDetalle.setP9teres(consultaDetalle.getP9teres().replaceAll("</strong>", "&negritafin;"));

				// italic
				consultaDetalle.setP9teres(consultaDetalle.getP9teres().replaceAll("<em>", "&italicini;"));
				consultaDetalle.setP9teres(consultaDetalle.getP9teres().replaceAll("</em>", "&italicfin;"));

				// subrayado
				consultaDetalle.setP9teres(Y41bUtils.sustituirTagsSpanUnderline(consultaDetalle.getP9teres()));

				// tachado
				// consultaDetalle.setP9teres(Y41bUtils
				// .sustituirTagsSpanStrike(consultaDetalle.getP9teres()));

				// consultaDetalle.setP9teres(consultaDetalle.getP9teres()
				// .replaceAll(
				// "<span style=\"text-decoration: underline;\">",
				// "&subrayadoini;"));
				// consultaDetalle.setP9teres(consultaDetalle.getP9teres()
				// .replaceAll("</span>", "&subrayadofin;"));

				// lista
				consultaDetalle.setP9teres(consultaDetalle.getP9teres().replaceAll("<ol>", ""));
				consultaDetalle.setP9teres(consultaDetalle.getP9teres().replaceAll("</ol>", ""));
				consultaDetalle.setP9teres(consultaDetalle.getP9teres().replaceAll("<ul>", ""));
				consultaDetalle.setP9teres(consultaDetalle.getP9teres().replaceAll("</ul>", ""));

				consultaDetalle.setP9teres(Y41bUtils.sustituirTagsLi(consultaDetalle.getP9teres()));

				consultaDetalle.setP9teres(consultaDetalle.getP9teres().replaceAll("&ntilde;", "&ene;"));
				consultaDetalle.setP9teres(consultaDetalle.getP9teres().replaceAll("&Ntilde;", "&ENE;"));

				// consultaDetalle.setP9teres(consultaDetalle.getP9teres().replaceAll("</span>",
				// "&separator;"));

				consultaDetalle.setP9teres(Y41bStringUtils.unescapeHTML(
						StringEscapeUtils.unescapeHtml(Y41bUtils.eliminarTags(consultaDetalle.getP9teres())), 0));
			}

			String rutaRTF = (String) appConfiguration.get("y41bVistaWar.ruta.plantillas.word");
			String rutaXML = (String) appConfiguration.get("y41bVistaWar.rutaxml.plantillas.word");
			String nombreRTF = Y41bConstantes.NOMBRE_PLANTILLA_CONSULTAS_FICHA_RTF;
			String nombreXML = Y41bConstantes.NOMBRE_PLANTILLA_CONSULTAS_FICHA_XML;
			String rutaCompletaRTF = rutaRTF + nombreRTF;
			String rutaCompletaXML = rutaXML + nombreXML;

			String plantilla = new String(Y41bDocumento.leerArchivoOrigen(rutaCompletaRTF));

			String strFileDataDecode = Y41bGenerarDocumento.generarDocumentoWord(rutaCompletaXML, consultaDetalle,
					plantilla);

			byte[] bytesFichero = strFileDataDecode.getBytes();

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			String nombreFichero = consultaDetalle.getCodOrg() + "-" + consultaDetalle.getConrreg() + "-"
					+ consultaDetalle.getConranrg() + ".rtf";

			// FIXME Esto se ha quitado porque sino en Internet Explorer produce
			// un error al mostrarse
			// response.setCharacterEncoding("ISO-8859-1");
			// response.setHeader("Cache-Control", "no-cache");

			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(nombreFichero) + "\"");
			response.setContentType("application/msword");
			response.setContentLength(bytesFichero.length);
			response.getOutputStream().write(bytesFichero);

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Exception e) {
			throw new ResourceNotFoundException(cocodigo.toString());
		} catch (Throwable t) {
			throw new ResourceNotFoundException(cocodigo.toString());
		}
	}

	/**
	 * Method 'getAllConsulta'.
	 * 
	 * @param tircodigo_
	 *            String
	 * 
	 * @param cocodigo
	 *            String
	 * @param coconsultaaaccempresas_
	 *            String
	 * @param motivoTircodigo_
	 *            String
	 * @param motivoTirnombre_
	 *            String
	 * @param productoPscodigo_
	 *            String
	 * @param productoPsnombre_
	 *            String
	 * @param rangoEdadRancod_
	 *            String
	 * @param formaPresentacionTfpcodigo_
	 *            String
	 * @param organismoCodOrg_
	 *            String
	 * @param censoMonitorMocodigo_
	 *            String
	 * @param cofecha
	 *            Date
	 * @param cocosx_
	 *            String
	 * @param conran
	 *            String
	 * @param cocose
	 *            String
	 * @param cotexto_
	 *            String
	 * @param conrreg
	 *            Integer
	 * @param conoco_
	 *            String
	 * @param cocif_
	 *            String
	 * @param corazonsocial_
	 *            String
	 * @param conodirco
	 *            String
	 * @param conrcpco
	 *            String
	 * @param cocoloco
	 *            String
	 * @param conoloco
	 *            String
	 * @param conomuco
	 *            String
	 * @param cocopvco
	 *            String
	 * @param cocopaco
	 *            String
	 * @param conrtelco
	 *            String
	 * @param conrfaxco
	 *            String
	 * @param cocoemco
	 *            String
	 * @param coferes
	 *            Date
	 * @param coinreenv
	 *            String
	 * @param coteresp
	 *            String
	 * @param cocotfpr
	 *            String
	 * @param coinl37_
	 *            String
	 * @param conranrg
	 *            Long
	 * @param cocopro
	 *            String
	 * @param cohdcodigo
	 *            String
	 * @param cohora
	 *            String
	 * @param cofechaconsumidor
	 *            Date
	 * @param noraPaisId_
	 *            String
	 * @param nombrePais
	 *            String
	 * @param provinciaId_
	 *            String
	 * @param nombreProvincia
	 *            String
	 * @param municipioId_
	 *            String
	 * @param nombreMunicipio
	 *            String
	 * @param localidadId_
	 *            String
	 * @param nombreLocalidad
	 *            String
	 * @param noraCalleId
	 *            String
	 * @param nombreCalle
	 *            String
	 * @param noraCpId
	 *            String
	 * @param nombreCp
	 *            String
	 * @param noraPortalId
	 *            String
	 * @param nombrePortal
	 *            String
	 * @param direccion_nocapv_
	 *            String
	 * @param coextranjero_
	 *            String
	 * @param coestado_
	 *            String
	 * @param coinl21_
	 *            String
	 * @param cosituacion_
	 *            String
	 * @param nombrePiso
	 *            String
	 * @param cofechaDesde_
	 *            String
	 * @param cofechaHasta_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/busqueda", method = RequestMethod.GET)
	public @ResponseBody Object getAllConsulta(@RequestParam(value = "cocodigo", required = false) String cocodigo,
			@RequestParam(value = "coconsultaaaccempresas", required = false) String coconsultaaaccempresas_,
			@RequestParam(value = "motivoTircodigo", required = false) String motivoTircodigo_,
			@RequestParam(value = "motivoTirnombre", required = false) String motivoTirnombre_,
			@RequestParam(value = "tircodigo", required = false) String tircodigo_,
			@RequestParam(value = "productoPscodigo", required = false) String productoPscodigo_,
			@RequestParam(value = "productoPsnombre", required = false) String productoPsnombre_,
			@RequestParam(value = "rangoEdadRancod", required = false) String rangoEdadRancod_,
			@RequestParam(value = "formaPresentacionTfpcodigo", required = false) String formaPresentacionTfpcodigo_,
			@RequestParam(value = "organismoCodOrg", required = false) String organismoCodOrg_,
			@RequestParam(value = "censoMonitorMocodigo", required = false) String censoMonitorMocodigo_,
			@RequestParam(value = "cofecha", required = false) Date cofecha,
			@RequestParam(value = "cocosx", required = false) String cocosx_,
			@RequestParam(value = "conran", required = false) String conran,
			@RequestParam(value = "cocose", required = false) String cocose,
			@RequestParam(value = "cotexto", required = false) String cotexto_,
			@RequestParam(value = "conrreg", required = false) Integer conrreg,
			@RequestParam(value = "conoco", required = false) String conoco_,
			@RequestParam(value = "cocif", required = false) String cocif_,
			@RequestParam(value = "corazonsocial", required = false) String corazonsocial_,
			@RequestParam(value = "conodirco", required = false) String conodirco,
			@RequestParam(value = "conrcpco", required = false) String conrcpco,
			@RequestParam(value = "cocoloco", required = false) String cocoloco,
			@RequestParam(value = "conoloco", required = false) String conoloco,
			@RequestParam(value = "conomuco", required = false) String conomuco,
			@RequestParam(value = "cocopvco", required = false) String cocopvco,
			@RequestParam(value = "cocopaco", required = false) String cocopaco,
			@RequestParam(value = "conrtelco", required = false) String conrtelco,
			@RequestParam(value = "conrfaxco", required = false) String conrfaxco,
			@RequestParam(value = "cocoemco", required = false) String cocoemco,
			@RequestParam(value = "coferes", required = false) Date coferes,
			@RequestParam(value = "coinreenv", required = false) String coinreenv,
			@RequestParam(value = "coteresp", required = false) String coteresp,
			@RequestParam(value = "cocotfpr", required = false) String cocotfpr,
			@RequestParam(value = "coinl37", required = false) String coinl37_,
			@RequestParam(value = "conranrg", required = false) Long conranrg,
			@RequestParam(value = "cocopro", required = false) String cocopro,
			@RequestParam(value = "cohdcodigo", required = false) String cohdcodigo,
			@RequestParam(value = "cohora", required = false) String cohora,
			@RequestParam(value = "cofechaconsumidor", required = false) Date cofechaconsumidor,
			@RequestParam(value = "noraPaisId", required = false) String noraPaisId_,
			@RequestParam(value = "nombrePais", required = false) String nombrePais,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "nombreProvincia", required = false) String nombreProvincia,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "nombreMunicipio", required = false) String nombreMunicipio,
			@RequestParam(value = "localidadId", required = false) String localidadId_,
			@RequestParam(value = "nombreLocalidad", required = false) String nombreLocalidad,
			@RequestParam(value = "noraCalleId", required = false) String noraCalleId,
			@RequestParam(value = "nombreCalle", required = false) String nombreCalle,
			@RequestParam(value = "noraCpId", required = false) String noraCpId,
			@RequestParam(value = "nombreCp", required = false) String nombreCp,
			@RequestParam(value = "noraPortalId", required = false) String noraPortalId,
			@RequestParam(value = "nombrePortal", required = false) String nombrePortal,
			@RequestParam(value = "direccion_nocapv", required = false) String direccion_nocapv_,
			@RequestParam(value = "coextranjero", required = false) String coextranjero_,
			@RequestParam(value = "coestado", required = false) String coestado_,
			@RequestParam(value = "coinl21", required = false) String coinl21_,
			@RequestParam(value = "cosituacion", required = false) String cosituacion_,
			@RequestParam(value = "nombrePiso", required = false) String nombrePiso,
			@RequestParam(value = "cofechaDesde", required = false) String cofechaDesde_,
			@RequestParam(value = "cofechaHasta", required = false) String cofechaHasta_, HttpServletRequest request,
			Model model) {
		try {
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date cofechaDesde = Y41bUtils.parseDate(cofechaDesde_, locale);
			Date cofechaHasta = Y41bUtils.parseDate(cofechaHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro
			String coconsultaaaccempresas = ("".equals(coconsultaaaccempresas_)) ? null : coconsultaaaccempresas_;
			String cosituacion = ("".equals(cosituacion_)) ? null : cosituacion_;
			String censoMonitorMocodigo = ("".equals(censoMonitorMocodigo_)) ? null : censoMonitorMocodigo_;
			String formaPresentacionTfpcodigo = ("".equals(formaPresentacionTfpcodigo_)) ? null
					: formaPresentacionTfpcodigo_;
			String cotexto = ("".equals(cotexto_)) ? null : cotexto_;
			String conoco = ("".equals(conoco_)) ? null : conoco_;
			String cocif = ("".equals(cocif_)) ? null : cocif_;
			String corazonsocial = ("".equals(corazonsocial_)) ? null : corazonsocial_;

			String coextranjero = null;
			String coestado = null;
			String noraPaisId = null;
			String provinciaId = null;
			String municipioId = null;
			String localidadId = null;
			String direccion_nocapv = null;

			if (Y41bConstantes.NORA_LOCALIZACION_TODOS.equals(coextranjero_)) {
				coextranjero = null;
				noraPaisId = null;
				coestado = null;
				provinciaId = null;
				municipioId = null;
				localidadId = null;
				direccion_nocapv = null;
			} else if (Y41bConstantes.NORA_LOCALIZACION_EXTRANJERO.equals(coextranjero_)) {
				coextranjero = Y41bConstantes.VALOR_SI;
				noraPaisId = ("".equals(noraPaisId_)) ? null : noraPaisId_;
				coestado = null;
				provinciaId = null;
				municipioId = null;
				localidadId = null;
				direccion_nocapv = ("".equals(direccion_nocapv_)) ? null : direccion_nocapv_;

			} else if (Y41bConstantes.NORA_LOCALIZACION_ESTADO.equals(coextranjero_)) {
				coextranjero = null;
				noraPaisId = null;
				coestado = Y41bConstantes.VALOR_SI;
				provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
				municipioId = ("".equals(municipioId_)) ? null : municipioId_;
				localidadId = ("".equals(localidadId_)) ? null : localidadId_;
				direccion_nocapv = ("".equals(direccion_nocapv_)) ? null : direccion_nocapv_;
			}

			String rangoEdadRancod = ("".equals(rangoEdadRancod_)) ? null : rangoEdadRancod_;
			String cocosx = ("".equals(cocosx_)) ? null : cocosx_;

			String productoPscodigo = ("".equals(productoPscodigo_)) ? null : productoPscodigo_;

			String productoPsnombre = ("".equals(productoPsnombre_)) ? null : productoPsnombre_;

			String motivoTircodigo = "";
			if (tircodigo_ != "" && tircodigo_ != null) {
				motivoTircodigo = ("".equals(tircodigo_)) ? null : tircodigo_;
			} else {
				motivoTircodigo = ("".equals(motivoTircodigo_)) ? null : motivoTircodigo_;

			}
			String motivoTirnombre = ("".equals(motivoTirnombre_)) ? null : motivoTirnombre_;

			// control checks
			String coinl21 = ("on".equals(coinl21_)) ? Y41bConstantes.VALOR_SI : null;
			String coinl37 = ("on".equals(coinl37_)) ? Y41bConstantes.VALOR_SI : null;

			String organismoCodOrg = ("".equals(organismoCodOrg_)) ? null : organismoCodOrg_;

			// Filtro
			Consulta filterConsulta = new Consulta(cocodigo, new Motivo(motivoTircodigo, motivoTirnombre, null),
					new Producto(productoPscodigo, productoPsnombre, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null),
					new RangoEdad(rangoEdadRancod, null, null, null),
					new FormaPresentacion(formaPresentacionTfpcodigo, null, null, null, null, null, null),
					new Organismo(organismoCodOrg),
					new CensoMonitor(censoMonitorMocodigo, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null),
					cofecha, cocosx, conran, cocose, cotexto, conrreg, conoco, conodirco, conrcpco, cocoloco, conoloco,
					conomuco, cocopvco, cocopaco, conrtelco, conrfaxco, cocoemco, coferes, coinreenv, coteresp,
					cocotfpr, coinl37, conranrg, cocopro, cohdcodigo, cohora, cofechaconsumidor, noraPaisId, nombrePais,
					provinciaId, nombreProvincia, municipioId, nombreMunicipio, localidadId, nombreLocalidad,
					noraCalleId, nombreCalle, noraCpId, nombreCp, noraPortalId, nombrePortal, coinl21, cosituacion,
					nombrePiso, direccion_nocapv, coextranjero, coestado, null, null, null, null, null, null);
			filterConsulta.setCofechadesde(cofechaDesde_);
			filterConsulta.setCofechahasta(cofechaHasta_);

			filterConsulta.setCoconsultaaaccempresas(coconsultaaaccempresas);
			filterConsulta.setCocif(cocif);
			filterConsulta.setCorazonsocial(corazonsocial);

			model.addAttribute("consultaBusqueda", filterConsulta);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				// Dejamos en sesin el objeto pagination
				request.getSession().setAttribute("paginationBandejaConsultasPdtes", pagination);

				List<ConsultaBusqueda> consultasBusqueda = null;
				if (censoMonitor != null && censoMonitor.getPerfilConsultas() != null && !censoMonitor
						.getPerfilConsultas().getIdPerfil().equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
					consultasBusqueda = this.consultaService.findAllLikeConsulta(filterConsulta, pagination, false,
							cofechaDesde, cofechaHasta);

					if (consultasBusqueda == null) {
						throw new Exception("No data Found.");
					}
				} else {
					consultasBusqueda = new ArrayList<ConsultaBusqueda>();
				}

				Long total = new Long(0);
				if (censoMonitor != null && censoMonitor.getPerfilConsultas() != null && !censoMonitor
						.getPerfilConsultas().getIdPerfil().equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
					total = this.consultaService.findAllLikeConsultaCount(filterConsulta, false, cofechaDesde,
							cofechaHasta);
				}
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(consultasBusqueda);
				return data;
			} else {
				pagination = new Pagination();
				pagination.setSort("COFECHA");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_DESC);

				List<ConsultaBusqueda> consultasBusqueda = null;
				if (censoMonitor != null && censoMonitor.getPerfilConsultas() != null && !censoMonitor
						.getPerfilConsultas().getIdPerfil().equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
					consultasBusqueda = this.consultaService.findAllLikeConsulta(filterConsulta, pagination, false,
							cofechaDesde, cofechaHasta);
					if (consultasBusqueda == null) {
						throw new Exception("No data Found.");
					}
				} else {
					consultasBusqueda = new ArrayList<ConsultaBusqueda>();
				}
				return consultasBusqueda;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllConsulta'.
	 * 
	 * @param tircodigo_
	 *            String
	 * 
	 * @param cocodigo
	 *            String
	 * @param coconsultaaaccempresas_
	 *            String
	 * @param motivoTircodigo_
	 *            String
	 * @param motivoTirnombre_
	 *            String
	 * @param productoPscodigo_
	 *            String
	 * @param productoPsnombre_
	 *            String
	 * @param rangoEdadRancod_
	 *            String
	 * @param formaPresentacionTfpcodigo_
	 *            String
	 * @param organismoCodOrg_
	 *            String
	 * @param censoMonitorMocodigo_
	 *            String
	 * @param cofecha
	 *            Date
	 * @param cocosx_
	 *            String
	 * @param conran
	 *            String
	 * @param cocose
	 *            String
	 * @param cotexto_
	 *            String
	 * @param conrreg
	 *            Integer
	 * @param conoco_
	 *            String
	 * @param cocif_
	 *            String
	 * @param corazonsocial_
	 *            String
	 * @param conodirco
	 *            String
	 * @param conrcpco
	 *            String
	 * @param cocoloco
	 *            String
	 * @param conoloco
	 *            String
	 * @param conomuco
	 *            String
	 * @param cocopvco
	 *            String
	 * @param cocopaco
	 *            String
	 * @param conrtelco
	 *            String
	 * @param conrfaxco
	 *            String
	 * @param cocoemco
	 *            String
	 * @param coferes
	 *            Date
	 * @param coinreenv
	 *            String
	 * @param coteresp
	 *            String
	 * @param cocotfpr
	 *            String
	 * @param coinl37_
	 *            String
	 * @param conranrg
	 *            Long
	 * @param cocopro
	 *            String
	 * @param cohdcodigo
	 *            String
	 * @param cohora
	 *            String
	 * @param cofechaconsumidor
	 *            Date
	 * @param noraPaisId_
	 *            String
	 * @param nombrePais
	 *            String
	 * @param provinciaId_
	 *            String
	 * @param nombreProvincia
	 *            String
	 * @param municipioId_
	 *            String
	 * @param nombreMunicipio
	 *            String
	 * @param localidadId_
	 *            String
	 * @param nombreLocalidad
	 *            String
	 * @param noraCalleId
	 *            String
	 * @param nombreCalle
	 *            String
	 * @param noraCpId
	 *            String
	 * @param nombreCp
	 *            String
	 * @param noraPortalId
	 *            String
	 * @param nombrePortal
	 *            String
	 * @param direccion_nocapv_
	 *            String
	 * @param coextranjero_
	 *            String
	 * @param coestado_
	 *            String
	 * @param coinl21_
	 *            String
	 * @param cosituacion_
	 *            String
	 * @param nombrePiso
	 *            String
	 * @param cofechaDesde_
	 *            String
	 * @param cofechaHasta_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/busquedaAACC", method = RequestMethod.GET)
	public @ResponseBody Object getAllConsultaAACC(@RequestParam(value = "cocodigo", required = false) String cocodigo,
			@RequestParam(value = "coconsultaaaccempresas", required = false) String coconsultaaaccempresas_,
			@RequestParam(value = "motivoTircodigo", required = false) String motivoTircodigo_,
			@RequestParam(value = "motivoTirnombre", required = false) String motivoTirnombre_,
			@RequestParam(value = "tircodigo", required = false) String tircodigo_,
			@RequestParam(value = "productoPscodigo", required = false) String productoPscodigo_,
			@RequestParam(value = "productoPsnombre", required = false) String productoPsnombre_,
			@RequestParam(value = "rangoEdadRancod", required = false) String rangoEdadRancod_,
			@RequestParam(value = "formaPresentacionTfpcodigo", required = false) String formaPresentacionTfpcodigo_,
			@RequestParam(value = "organismoCodOrg", required = false) String organismoCodOrg_,
			@RequestParam(value = "censoMonitorMocodigo", required = false) String censoMonitorMocodigo_,
			@RequestParam(value = "cofecha", required = false) Date cofecha,
			@RequestParam(value = "cocosx", required = false) String cocosx_,
			@RequestParam(value = "conran", required = false) String conran,
			@RequestParam(value = "cocose", required = false) String cocose,
			@RequestParam(value = "cotexto", required = false) String cotexto_,
			@RequestParam(value = "conrreg", required = false) Integer conrreg,
			@RequestParam(value = "conoco", required = false) String conoco_,
			@RequestParam(value = "cocif", required = false) String cocif_,
			@RequestParam(value = "corazonsocial", required = false) String corazonsocial_,
			@RequestParam(value = "conodirco", required = false) String conodirco,
			@RequestParam(value = "conrcpco", required = false) String conrcpco,
			@RequestParam(value = "cocoloco", required = false) String cocoloco,
			@RequestParam(value = "conoloco", required = false) String conoloco,
			@RequestParam(value = "conomuco", required = false) String conomuco,
			@RequestParam(value = "cocopvco", required = false) String cocopvco,
			@RequestParam(value = "cocopaco", required = false) String cocopaco,
			@RequestParam(value = "conrtelco", required = false) String conrtelco,
			@RequestParam(value = "conrfaxco", required = false) String conrfaxco,
			@RequestParam(value = "cocoemco", required = false) String cocoemco,
			@RequestParam(value = "coferes", required = false) Date coferes,
			@RequestParam(value = "coinreenv", required = false) String coinreenv,
			@RequestParam(value = "coteresp", required = false) String coteresp,
			@RequestParam(value = "cocotfpr", required = false) String cocotfpr,
			@RequestParam(value = "coinl37", required = false) String coinl37_,
			@RequestParam(value = "conranrg", required = false) Long conranrg,
			@RequestParam(value = "cocopro", required = false) String cocopro,
			@RequestParam(value = "cohdcodigo", required = false) String cohdcodigo,
			@RequestParam(value = "cohora", required = false) String cohora,
			@RequestParam(value = "cofechaconsumidor", required = false) Date cofechaconsumidor,
			@RequestParam(value = "noraPaisId", required = false) String noraPaisId_,
			@RequestParam(value = "nombrePais", required = false) String nombrePais,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "nombreProvincia", required = false) String nombreProvincia,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "nombreMunicipio", required = false) String nombreMunicipio,
			@RequestParam(value = "localidadId", required = false) String localidadId_,
			@RequestParam(value = "nombreLocalidad", required = false) String nombreLocalidad,
			@RequestParam(value = "noraCalleId", required = false) String noraCalleId,
			@RequestParam(value = "nombreCalle", required = false) String nombreCalle,
			@RequestParam(value = "noraCpId", required = false) String noraCpId,
			@RequestParam(value = "nombreCp", required = false) String nombreCp,
			@RequestParam(value = "noraPortalId", required = false) String noraPortalId,
			@RequestParam(value = "nombrePortal", required = false) String nombrePortal,
			@RequestParam(value = "direccion_nocapv", required = false) String direccion_nocapv_,
			@RequestParam(value = "coextranjero", required = false) String coextranjero_,
			@RequestParam(value = "coestado", required = false) String coestado_,
			@RequestParam(value = "coinl21", required = false) String coinl21_,
			@RequestParam(value = "cosituacion", required = false) String cosituacion_,
			@RequestParam(value = "nombrePiso", required = false) String nombrePiso,
			@RequestParam(value = "cofechaDesde", required = false) String cofechaDesde_,
			@RequestParam(value = "cofechaHasta", required = false) String cofechaHasta_, HttpServletRequest request,
			Model model) {
		try {
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date cofechaDesde = Y41bUtils.parseDate(cofechaDesde_, locale);
			Date cofechaHasta = Y41bUtils.parseDate(cofechaHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro
			String coconsultaaaccempresas = ("".equals(coconsultaaaccempresas_)) ? null : coconsultaaaccempresas_;
			String cosituacion = ("".equals(cosituacion_)) ? null : cosituacion_;
			String censoMonitorMocodigo = ("".equals(censoMonitorMocodigo_)) ? null : censoMonitorMocodigo_;
			String formaPresentacionTfpcodigo = ("".equals(formaPresentacionTfpcodigo_)) ? null
					: formaPresentacionTfpcodigo_;
			String cotexto = ("".equals(cotexto_)) ? null : cotexto_;
			String conoco = ("".equals(conoco_)) ? null : conoco_;
			String cocif = ("".equals(cocif_)) ? null : cocif_;
			String corazonsocial = ("".equals(corazonsocial_)) ? null : corazonsocial_;

			String coextranjero = null;
			String coestado = null;
			String noraPaisId = null;
			String provinciaId = null;
			String municipioId = null;
			String localidadId = null;
			String direccion_nocapv = null;

			if (Y41bConstantes.NORA_LOCALIZACION_TODOS.equals(coextranjero_)) {
				coextranjero = null;
				noraPaisId = null;
				coestado = null;
				provinciaId = null;
				municipioId = null;
				localidadId = null;
				direccion_nocapv = null;
			} else if (Y41bConstantes.NORA_LOCALIZACION_EXTRANJERO.equals(coextranjero_)) {
				coextranjero = Y41bConstantes.VALOR_SI;
				noraPaisId = ("".equals(noraPaisId_)) ? null : noraPaisId_;
				coestado = null;
				provinciaId = null;
				municipioId = null;
				localidadId = null;
				direccion_nocapv = ("".equals(direccion_nocapv_)) ? null : direccion_nocapv_;

			} else if (Y41bConstantes.NORA_LOCALIZACION_ESTADO.equals(coextranjero_)) {
				coextranjero = null;
				noraPaisId = null;
				coestado = Y41bConstantes.VALOR_SI;
				provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
				municipioId = ("".equals(municipioId_)) ? null : municipioId_;
				localidadId = ("".equals(localidadId_)) ? null : localidadId_;
				direccion_nocapv = ("".equals(direccion_nocapv_)) ? null : direccion_nocapv_;
			}

			String rangoEdadRancod = ("".equals(rangoEdadRancod_)) ? null : rangoEdadRancod_;
			String cocosx = ("".equals(cocosx_)) ? null : cocosx_;

			String productoPscodigo = ("".equals(productoPscodigo_)) ? null : productoPscodigo_;

			String productoPsnombre = ("".equals(productoPsnombre_)) ? null : productoPsnombre_;

			String motivoTircodigo = "";
			if (tircodigo_ != "" && tircodigo_ != null) {
				motivoTircodigo = ("".equals(tircodigo_)) ? null : tircodigo_;
			} else {
				motivoTircodigo = ("".equals(motivoTircodigo_)) ? null : motivoTircodigo_;

			}
			String motivoTirnombre = ("".equals(motivoTirnombre_)) ? null : motivoTirnombre_;

			// control checks
			String coinl21 = ("on".equals(coinl21_)) ? Y41bConstantes.VALOR_SI : null;
			String coinl37 = ("on".equals(coinl37_)) ? Y41bConstantes.VALOR_SI : null;

			String organismoCodOrg = ("".equals(organismoCodOrg_)) ? null : organismoCodOrg_;

			// Filtro
			Consulta filterConsulta = new Consulta(cocodigo, new Motivo(motivoTircodigo, motivoTirnombre, null),
					new Producto(productoPscodigo, productoPsnombre, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null),
					new RangoEdad(rangoEdadRancod, null, null, null),
					new FormaPresentacion(formaPresentacionTfpcodigo, null, null, null, null, null, null),
					new Organismo(organismoCodOrg),
					new CensoMonitor(censoMonitorMocodigo, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null),
					cofecha, cocosx, conran, cocose, cotexto, conrreg, conoco, conodirco, conrcpco, cocoloco, conoloco,
					conomuco, cocopvco, cocopaco, conrtelco, conrfaxco, cocoemco, coferes, coinreenv, coteresp,
					cocotfpr, coinl37, conranrg, cocopro, cohdcodigo, cohora, cofechaconsumidor, noraPaisId, nombrePais,
					provinciaId, nombreProvincia, municipioId, nombreMunicipio, localidadId, nombreLocalidad,
					noraCalleId, nombreCalle, noraCpId, nombreCp, noraPortalId, nombrePortal, coinl21, cosituacion,
					nombrePiso, direccion_nocapv, coextranjero, coestado, null, null, null, null, null, null);
			filterConsulta.setCofechadesde(cofechaDesde_);
			filterConsulta.setCofechahasta(cofechaHasta_);

			filterConsulta.setCoconsultaaaccempresas(coconsultaaaccempresas);
			filterConsulta.setCocif(cocif);
			filterConsulta.setCorazonsocial(corazonsocial);

			model.addAttribute("consultaBusqueda", filterConsulta);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				// Dejamos en sesin el objeto pagination
				request.getSession().setAttribute("paginationBandejaConsultasPdtes", pagination);

				List<ConsultaBusqueda> consultasBusqueda = null;
				if (censoMonitor != null && censoMonitor.getPerfilOrganizacion() != null && !censoMonitor
						.getPerfilOrganizacion().getIdPerfil().equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
					consultasBusqueda = this.consultaService.findAllLikeConsulta(filterConsulta, pagination, false,
							cofechaDesde, cofechaHasta);

					if (consultasBusqueda == null) {
						throw new Exception("No data Found.");
					}
				} else {
					consultasBusqueda = new ArrayList<ConsultaBusqueda>();
				}

				Long total = new Long(0);
				if (censoMonitor != null && censoMonitor.getPerfilOrganizacion() != null && !censoMonitor
						.getPerfilOrganizacion().getIdPerfil().equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
					total = this.consultaService.findAllLikeConsultaCount(filterConsulta, false, cofechaDesde,
							cofechaHasta);
				}
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(consultasBusqueda);
				return data;
			} else {
				pagination = new Pagination();
				pagination.setSort("COFECHA");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_DESC);

				List<ConsultaBusqueda> consultasBusqueda = null;
				if (censoMonitor != null && censoMonitor.getPerfilOrganizacion() != null && !censoMonitor
						.getPerfilOrganizacion().getIdPerfil().equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
					consultasBusqueda = this.consultaService.findAllLikeConsulta(filterConsulta, pagination, false,
							cofechaDesde, cofechaHasta);
					if (consultasBusqueda == null) {
						throw new Exception("No data Found.");
					}
				} else {
					consultasBusqueda = new ArrayList<ConsultaBusqueda>();
				}
				return consultasBusqueda;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllConsultaSession'.
	 * 
	 * @param tircodigo_
	 *            String
	 * 
	 * @param cocodigo
	 *            String
	 * @param coconsultaaaccempresas_
	 *            String
	 * @param motivoTircodigo_
	 *            String
	 * @param motivoTirnombre_
	 *            String
	 * @param productoPscodigo_
	 *            String
	 * @param productoPsnombre_
	 *            String
	 * @param rangoEdadRancod_
	 *            String
	 * @param formaPresentacionTfpcodigo_
	 *            String
	 * @param organismoCodOrg_
	 *            String
	 * @param censoMonitorMocodigo_
	 *            String
	 * @param cofecha
	 *            Date
	 * @param cocosx_
	 *            String
	 * @param conran
	 *            String
	 * @param cocose
	 *            String
	 * @param cotexto_
	 *            String
	 * @param conrreg
	 *            Integer
	 * @param conoco_
	 *            String
	 * @param cocif_
	 *            String
	 * @param corazonsocial_
	 *            String
	 * @param conodirco
	 *            String
	 * @param conrcpco
	 *            String
	 * @param cocoloco
	 *            String
	 * @param conoloco
	 *            String
	 * @param conomuco
	 *            String
	 * @param cocopvco
	 *            String
	 * @param cocopaco
	 *            String
	 * @param conrtelco
	 *            String
	 * @param conrfaxco
	 *            String
	 * @param cocoemco
	 *            String
	 * @param coferes
	 *            Date
	 * @param coinreenv
	 *            String
	 * @param coteresp
	 *            String
	 * @param cocotfpr
	 *            String
	 * @param coinl37_
	 *            String
	 * @param conranrg
	 *            Long
	 * @param cocopro
	 *            String
	 * @param cohdcodigo
	 *            String
	 * @param cohora
	 *            String
	 * @param cofechaconsumidor
	 *            Date
	 * @param noraPaisId_
	 *            String
	 * @param nombrePais
	 *            String
	 * @param provinciaId_
	 *            String
	 * @param nombreProvincia
	 *            String
	 * @param municipioId_
	 *            String
	 * @param nombreMunicipio
	 *            String
	 * @param localidadId_
	 *            String
	 * @param nombreLocalidad
	 *            String
	 * @param noraCalleId
	 *            String
	 * @param nombreCalle
	 *            String
	 * @param noraCpId
	 *            String
	 * @param nombreCp
	 *            String
	 * @param noraPortalId
	 *            String
	 * @param nombrePortal
	 *            String
	 * @param direccion_nocapv_
	 *            String
	 * @param coextranjero_
	 *            String
	 * @param coestado_
	 *            String
	 * @param coinl21_
	 *            String
	 * @param cosituacion_
	 *            String
	 * @param nombrePiso
	 *            String
	 * @param cofechaDesde_
	 *            String
	 * @param cofechaHasta_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/busquedaSession", method = RequestMethod.GET)
	public @ResponseBody Object getAllConsultaSession(
			@RequestParam(value = "cocodigo", required = false) String cocodigo,
			@RequestParam(value = "coconsultaaaccempresas", required = false) String coconsultaaaccempresas_,
			@RequestParam(value = "motivoTircodigo", required = false) String motivoTircodigo_,
			@RequestParam(value = "motivoTirnombre", required = false) String motivoTirnombre_,
			@RequestParam(value = "tircodigo", required = false) String tircodigo_,
			@RequestParam(value = "productoPscodigo", required = false) String productoPscodigo_,
			@RequestParam(value = "productoPsnombre", required = false) String productoPsnombre_,
			@RequestParam(value = "rangoEdadRancod", required = false) String rangoEdadRancod_,
			@RequestParam(value = "formaPresentacionTfpcodigo", required = false) String formaPresentacionTfpcodigo_,
			@RequestParam(value = "organismoCodOrg", required = false) String organismoCodOrg_,
			@RequestParam(value = "censoMonitorMocodigo", required = false) String censoMonitorMocodigo_,
			@RequestParam(value = "cofecha", required = false) Date cofecha,
			@RequestParam(value = "cocosx", required = false) String cocosx_,
			@RequestParam(value = "conran", required = false) String conran,
			@RequestParam(value = "cocose", required = false) String cocose,
			@RequestParam(value = "cotexto", required = false) String cotexto_,
			@RequestParam(value = "conrreg", required = false) Integer conrreg,
			@RequestParam(value = "conoco", required = false) String conoco_,
			@RequestParam(value = "cocif", required = false) String cocif_,
			@RequestParam(value = "corazonsocial", required = false) String corazonsocial_,
			@RequestParam(value = "conodirco", required = false) String conodirco,
			@RequestParam(value = "conrcpco", required = false) String conrcpco,
			@RequestParam(value = "cocoloco", required = false) String cocoloco,
			@RequestParam(value = "conoloco", required = false) String conoloco,
			@RequestParam(value = "conomuco", required = false) String conomuco,
			@RequestParam(value = "cocopvco", required = false) String cocopvco,
			@RequestParam(value = "cocopaco", required = false) String cocopaco,
			@RequestParam(value = "conrtelco", required = false) String conrtelco,
			@RequestParam(value = "conrfaxco", required = false) String conrfaxco,
			@RequestParam(value = "cocoemco", required = false) String cocoemco,
			@RequestParam(value = "coferes", required = false) Date coferes,
			@RequestParam(value = "coinreenv", required = false) String coinreenv,
			@RequestParam(value = "coteresp", required = false) String coteresp,
			@RequestParam(value = "cocotfpr", required = false) String cocotfpr,
			@RequestParam(value = "coinl37", required = false) String coinl37_,
			@RequestParam(value = "conranrg", required = false) Long conranrg,
			@RequestParam(value = "cocopro", required = false) String cocopro,
			@RequestParam(value = "cohdcodigo", required = false) String cohdcodigo,
			@RequestParam(value = "cohora", required = false) String cohora,
			@RequestParam(value = "cofechaconsumidor", required = false) Date cofechaconsumidor,
			@RequestParam(value = "noraPaisId", required = false) String noraPaisId_,
			@RequestParam(value = "nombrePais", required = false) String nombrePais,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "nombreProvincia", required = false) String nombreProvincia,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "nombreMunicipio", required = false) String nombreMunicipio,
			@RequestParam(value = "localidadId", required = false) String localidadId_,
			@RequestParam(value = "nombreLocalidad", required = false) String nombreLocalidad,
			@RequestParam(value = "noraCalleId", required = false) String noraCalleId,
			@RequestParam(value = "nombreCalle", required = false) String nombreCalle,
			@RequestParam(value = "noraCpId", required = false) String noraCpId,
			@RequestParam(value = "nombreCp", required = false) String nombreCp,
			@RequestParam(value = "noraPortalId", required = false) String noraPortalId,
			@RequestParam(value = "nombrePortal", required = false) String nombrePortal,
			@RequestParam(value = "direccion_nocapv", required = false) String direccion_nocapv_,
			@RequestParam(value = "coextranjero", required = false) String coextranjero_,
			@RequestParam(value = "coestado", required = false) String coestado_,
			@RequestParam(value = "coinl21", required = false) String coinl21_,
			@RequestParam(value = "cosituacion", required = false) String cosituacion_,
			@RequestParam(value = "nombrePiso", required = false) String nombrePiso,
			@RequestParam(value = "cofechaDesde", required = false) String cofechaDesde_,
			@RequestParam(value = "cofechaHasta", required = false) String cofechaHasta_, HttpServletRequest request,
			Model model) {
		try {
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date cofechaDesde = Y41bUtils.parseDate(cofechaDesde_, locale);
			Date cofechaHasta = Y41bUtils.parseDate(cofechaHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro
			String coconsultaaaccempresas = ("".equals(coconsultaaaccempresas_)) ? null : coconsultaaaccempresas_;
			String cosituacion = ("".equals(cosituacion_)) ? null : cosituacion_;
			String censoMonitorMocodigo = ("".equals(censoMonitorMocodigo_)) ? null : censoMonitorMocodigo_;
			String formaPresentacionTfpcodigo = ("".equals(formaPresentacionTfpcodigo_)) ? null
					: formaPresentacionTfpcodigo_;
			String cotexto = ("".equals(cotexto_)) ? null : cotexto_;
			String conoco = ("".equals(conoco_)) ? null : conoco_;
			String cocif = ("".equals(cocif_)) ? null : cocif_;
			String corazonsocial = ("".equals(corazonsocial_)) ? null : corazonsocial_;

			String coextranjero = null;
			String coestado = null;
			String noraPaisId = null;
			String provinciaId = null;
			String municipioId = null;
			String localidadId = null;
			String direccion_nocapv = null;

			if (Y41bConstantes.NORA_LOCALIZACION_TODOS.equals(coextranjero_)) {
				coextranjero = null;
				noraPaisId = null;
				coestado = null;
				provinciaId = null;
				municipioId = null;
				localidadId = null;
				direccion_nocapv = null;
			} else if (Y41bConstantes.NORA_LOCALIZACION_EXTRANJERO.equals(coextranjero_)) {
				coextranjero = Y41bConstantes.VALOR_SI;
				noraPaisId = ("".equals(noraPaisId_)) ? null : noraPaisId_;
				coestado = null;
				provinciaId = null;
				municipioId = null;
				localidadId = null;
				direccion_nocapv = ("".equals(direccion_nocapv_)) ? null : direccion_nocapv_;

			} else if (Y41bConstantes.NORA_LOCALIZACION_ESTADO.equals(coextranjero_)) {
				coextranjero = null;
				noraPaisId = null;
				coestado = Y41bConstantes.VALOR_SI;
				provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
				municipioId = ("".equals(municipioId_)) ? null : municipioId_;
				localidadId = ("".equals(localidadId_)) ? null : localidadId_;
				direccion_nocapv = ("".equals(direccion_nocapv_)) ? null : direccion_nocapv_;
			}

			String rangoEdadRancod = ("".equals(rangoEdadRancod_)) ? null : rangoEdadRancod_;
			String cocosx = ("".equals(cocosx_)) ? null : cocosx_;

			String productoPscodigo = ("".equals(productoPscodigo_)) ? null : productoPscodigo_;

			String productoPsnombre = ("".equals(productoPsnombre_)) ? null : productoPsnombre_;

			String motivoTircodigo = "";
			if (tircodigo_ != "" && tircodigo_ != null) {
				motivoTircodigo = ("".equals(tircodigo_)) ? null : tircodigo_;
			} else {
				motivoTircodigo = ("".equals(motivoTircodigo_)) ? null : motivoTircodigo_;

			}
			String motivoTirnombre = ("".equals(motivoTirnombre_)) ? null : motivoTirnombre_;

			// control checks
			String coinl21 = ("on".equals(coinl21_)) ? Y41bConstantes.VALOR_SI : null;
			String coinl37 = ("on".equals(coinl37_)) ? Y41bConstantes.VALOR_SI : null;

			String organismoCodOrg = ("".equals(organismoCodOrg_)) ? null : organismoCodOrg_;

			// Filtro
			Consulta filterConsulta = new Consulta(cocodigo, new Motivo(motivoTircodigo, motivoTirnombre, null),
					new Producto(productoPscodigo, productoPsnombre, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null),
					new RangoEdad(rangoEdadRancod, null, null, null),
					new FormaPresentacion(formaPresentacionTfpcodigo, null, null, null, null, null, null),
					new Organismo(organismoCodOrg),
					new CensoMonitor(censoMonitorMocodigo, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null),
					cofecha, cocosx, conran, cocose, cotexto, conrreg, conoco, conodirco, conrcpco, cocoloco, conoloco,
					conomuco, cocopvco, cocopaco, conrtelco, conrfaxco, cocoemco, coferes, coinreenv, coteresp,
					cocotfpr, coinl37, conranrg, cocopro, cohdcodigo, cohora, cofechaconsumidor, noraPaisId, nombrePais,
					provinciaId, nombreProvincia, municipioId, nombreMunicipio, localidadId, nombreLocalidad,
					noraCalleId, nombreCalle, noraCpId, nombreCp, noraPortalId, nombrePortal, coinl21, cosituacion,
					nombrePiso, direccion_nocapv, coextranjero, coestado, null, null, null, null, null, null);
			filterConsulta.setCofechadesde(cofechaDesde_);
			filterConsulta.setCofechahasta(cofechaHasta_);

			filterConsulta.setCoconsultaaaccempresas(coconsultaaaccempresas);
			filterConsulta.setCocif(cocif);
			filterConsulta.setCorazonsocial(corazonsocial);

			model.addAttribute("consultaBusqueda", filterConsulta);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {

				pagination = (Pagination) request.getSession().getAttribute("paginationBandejaConsultasPdtes");

				// Si al refrescar la tabla existen menos elementos y la
				// lapgina guardada en sesin no existe, se debe seleccionar la
				// ltima pgina con datos
				Long totalReg = new Long(0);
				totalReg = this.consultaService.findAllLikeConsultaCount(filterConsulta, false, cofechaDesde,
						cofechaHasta);
				Long totalSesion = new Long(0);
				Long page = new Long(0);
				totalSesion = pagination.getPage() * pagination.getRows();
				totalSesion = totalSesion - pagination.getRows();

				if (totalSesion >= totalReg) {
					page = totalReg / pagination.getRows();
					pagination.setPage(page);
				}

				List<ConsultaBusqueda> consultasBusqueda = null;

				consultasBusqueda = this.consultaService.findAllLikeConsulta(filterConsulta, pagination, false,
						cofechaDesde, cofechaHasta);

				if (consultasBusqueda == null) {
					throw new Exception("No data Found.");
				}

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(pagination.getPage().toString());
				data.setRecords(totalReg.intValue());
				data.setTotal(totalReg, pagination.getRows());
				data.setRows(consultasBusqueda);
				return data;
			} else {
				pagination = new Pagination();
				pagination.setSort("COFECHA");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_DESC);

				List<ConsultaBusqueda> consultasBusqueda = null;
				if (censoMonitor != null && censoMonitor.getPerfilConsultas() != null && !censoMonitor
						.getPerfilConsultas().getIdPerfil().equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
					consultasBusqueda = this.consultaService.findAllLikeConsulta(filterConsulta, pagination, false,
							cofechaDesde, cofechaHasta);
					if (consultasBusqueda == null) {
						throw new Exception("No data Found.");
					}
				} else {
					consultasBusqueda = new ArrayList<ConsultaBusqueda>();
				}
				return consultasBusqueda;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllConsultaCount'.
	 * 
	 * @param cocodigo
	 *            String
	 * @param coconsultaaaccempresas_
	 *            String
	 * @param motivoTircodigo_
	 *            String
	 * @param motivoTirnombre_
	 *            String
	 * @param tircodigo_
	 *            String
	 * @param productoPscodigo_
	 *            String
	 * @param productoPsnombre_
	 *            String
	 * @param rangoEdadRancod_
	 *            String
	 * @param formaPresentacionTfpcodigo_
	 *            String
	 * @param organismoCodOrg_
	 *            String
	 * @param censoMonitorMocodigo_
	 *            String
	 * @param cofecha
	 *            Date
	 * @param cocosx_
	 *            String
	 * @param conran
	 *            String
	 * @param cocose
	 *            String
	 * @param cotexto_
	 *            String
	 * @param conrreg
	 *            Integer
	 * @param conoco_
	 *            String
	 * @param cocif_
	 *            String
	 * @param corazonsocial_
	 *            String
	 * @param conodirco
	 *            String
	 * @param conrcpco
	 *            String
	 * @param cocoloco
	 *            String
	 * @param conoloco
	 *            String
	 * @param conomuco
	 *            String
	 * @param cocopvco
	 *            String
	 * @param cocopaco
	 *            String
	 * @param conrtelco
	 *            String
	 * @param conrfaxco
	 *            String
	 * @param cocoemco
	 *            String
	 * @param coferes
	 *            Date
	 * @param coinreenv
	 *            String
	 * @param coteresp
	 *            String
	 * @param cocotfpr
	 *            String
	 * @param coinl37_
	 *            String
	 * @param conranrg
	 *            Long
	 * @param cocopro
	 *            String
	 * @param cohdcodigo
	 *            String
	 * @param cohora
	 *            String
	 * @param cofechaconsumidor
	 *            Date
	 * @param noraPaisId_
	 *            String
	 * @param nombrePais
	 *            String
	 * @param provinciaId_
	 *            String
	 * @param nombreProvincia
	 *            String
	 * @param municipioId_
	 *            String
	 * @param nombreMunicipio
	 *            String
	 * @param localidadId_
	 *            String
	 * @param nombreLocalidad
	 *            String
	 * @param noraCalleId
	 *            String
	 * @param nombreCalle
	 *            String
	 * @param noraCpId
	 *            String
	 * @param nombreCp
	 *            String
	 * @param noraPortalId
	 *            String
	 * @param nombrePortal
	 *            String
	 * @param direccion_nocapv_
	 *            String
	 * @param coextranjero_
	 *            String
	 * @param coestado_
	 *            String
	 * @param coinl21_
	 *            String
	 * @param cosituacion_
	 *            String
	 * @param nombrePiso
	 *            String
	 * @param cofechaDesde_
	 *            String
	 * @param cofechaHasta_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/busquedacount", method = RequestMethod.GET)
	public @ResponseBody Long getAllConsultaCount(@RequestParam(value = "cocodigo", required = false) String cocodigo,
			@RequestParam(value = "coconsultaaaccempresas", required = false) String coconsultaaaccempresas_,
			@RequestParam(value = "motivoTircodigo", required = false) String motivoTircodigo_,
			@RequestParam(value = "motivoTirnombre", required = false) String motivoTirnombre_,
			@RequestParam(value = "tircodigo", required = false) String tircodigo_,
			@RequestParam(value = "productoPscodigo", required = false) String productoPscodigo_,
			@RequestParam(value = "productoPsnombre", required = false) String productoPsnombre_,
			@RequestParam(value = "rangoEdadRancod", required = false) String rangoEdadRancod_,
			@RequestParam(value = "formaPresentacionTfpcodigo", required = false) String formaPresentacionTfpcodigo_,
			@RequestParam(value = "organismoCodOrg", required = false) String organismoCodOrg_,
			@RequestParam(value = "censoMonitorMocodigo", required = false) String censoMonitorMocodigo_,
			@RequestParam(value = "cofecha", required = false) Date cofecha,
			@RequestParam(value = "cocosx", required = false) String cocosx_,
			@RequestParam(value = "conran", required = false) String conran,
			@RequestParam(value = "cocose", required = false) String cocose,
			@RequestParam(value = "cotexto", required = false) String cotexto_,
			@RequestParam(value = "conrreg", required = false) Integer conrreg,
			@RequestParam(value = "conoco", required = false) String conoco_,
			@RequestParam(value = "cocif", required = false) String cocif_,
			@RequestParam(value = "corazonsocial", required = false) String corazonsocial_,
			@RequestParam(value = "conodirco", required = false) String conodirco,
			@RequestParam(value = "conrcpco", required = false) String conrcpco,
			@RequestParam(value = "cocoloco", required = false) String cocoloco,
			@RequestParam(value = "conoloco", required = false) String conoloco,
			@RequestParam(value = "conomuco", required = false) String conomuco,
			@RequestParam(value = "cocopvco", required = false) String cocopvco,
			@RequestParam(value = "cocopaco", required = false) String cocopaco,
			@RequestParam(value = "conrtelco", required = false) String conrtelco,
			@RequestParam(value = "conrfaxco", required = false) String conrfaxco,
			@RequestParam(value = "cocoemco", required = false) String cocoemco,
			@RequestParam(value = "coferes", required = false) Date coferes,
			@RequestParam(value = "coinreenv", required = false) String coinreenv,
			@RequestParam(value = "coteresp", required = false) String coteresp,
			@RequestParam(value = "cocotfpr", required = false) String cocotfpr,
			@RequestParam(value = "coinl37", required = false) String coinl37_,
			@RequestParam(value = "conranrg", required = false) Long conranrg,
			@RequestParam(value = "cocopro", required = false) String cocopro,
			@RequestParam(value = "cohdcodigo", required = false) String cohdcodigo,
			@RequestParam(value = "cohora", required = false) String cohora,
			@RequestParam(value = "cofechaconsumidor", required = false) Date cofechaconsumidor,
			@RequestParam(value = "noraPaisId", required = false) String noraPaisId_,
			@RequestParam(value = "nombrePais", required = false) String nombrePais,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "nombreProvincia", required = false) String nombreProvincia,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "nombreMunicipio", required = false) String nombreMunicipio,
			@RequestParam(value = "localidadId", required = false) String localidadId_,
			@RequestParam(value = "nombreLocalidad", required = false) String nombreLocalidad,
			@RequestParam(value = "noraCalleId", required = false) String noraCalleId,
			@RequestParam(value = "nombreCalle", required = false) String nombreCalle,
			@RequestParam(value = "noraCpId", required = false) String noraCpId,
			@RequestParam(value = "nombreCp", required = false) String nombreCp,
			@RequestParam(value = "noraPortalId", required = false) String noraPortalId,
			@RequestParam(value = "nombrePortal", required = false) String nombrePortal,
			@RequestParam(value = "direccion_nocapv", required = false) String direccion_nocapv_,
			@RequestParam(value = "coextranjero", required = false) String coextranjero_,
			@RequestParam(value = "coestado", required = false) String coestado_,
			@RequestParam(value = "coinl21", required = false) String coinl21_,
			@RequestParam(value = "cosituacion", required = false) String cosituacion_,
			@RequestParam(value = "nombrePiso", required = false) String nombrePiso,
			@RequestParam(value = "cofechaDesde", required = false) String cofechaDesde_,
			@RequestParam(value = "cofechaHasta", required = false) String cofechaHasta_, HttpServletRequest request,
			Model model) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date cofechaDesde = Y41bUtils.parseDate(cofechaDesde_, locale);
			Date cofechaHasta = Y41bUtils.parseDate(cofechaHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro
			String coconsultaaaccempresas = ("".equals(coconsultaaaccempresas_)) ? null : coconsultaaaccempresas_;
			String cosituacion = ("".equals(cosituacion_)) ? null : cosituacion_;
			String censoMonitorMocodigo = ("".equals(censoMonitorMocodigo_)) ? null : censoMonitorMocodigo_;
			String formaPresentacionTfpcodigo = ("".equals(formaPresentacionTfpcodigo_)) ? null
					: formaPresentacionTfpcodigo_;
			String cotexto = ("".equals(cotexto_)) ? null : cotexto_;
			String conoco = ("".equals(conoco_)) ? null : conoco_;
			String cocif = ("".equals(cocif_)) ? null : cocif_;
			String corazonsocial = ("".equals(corazonsocial_)) ? null : corazonsocial_;

			String coextranjero = null;
			String coestado = null;
			String noraPaisId = null;
			String provinciaId = null;
			String municipioId = null;
			String localidadId = null;
			String direccion_nocapv = null;

			if (Y41bConstantes.NORA_LOCALIZACION_TODOS.equals(coextranjero_)) {
				coextranjero = null;
				noraPaisId = null;
				coestado = null;
				provinciaId = null;
				municipioId = null;
				localidadId = null;
				direccion_nocapv = null;
			} else if (Y41bConstantes.NORA_LOCALIZACION_EXTRANJERO.equals(coextranjero_)) {
				coextranjero = Y41bConstantes.VALOR_SI;
				noraPaisId = ("".equals(noraPaisId_)) ? null : noraPaisId_;
				coestado = null;
				provinciaId = null;
				municipioId = null;
				localidadId = null;
				direccion_nocapv = ("".equals(direccion_nocapv_)) ? null : direccion_nocapv_;

			} else if (Y41bConstantes.NORA_LOCALIZACION_ESTADO.equals(coextranjero_)) {
				coextranjero = null;
				noraPaisId = null;
				coestado = Y41bConstantes.VALOR_SI;
				provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
				municipioId = ("".equals(municipioId_)) ? null : municipioId_;
				localidadId = ("".equals(localidadId_)) ? null : localidadId_;
				direccion_nocapv = ("".equals(direccion_nocapv_)) ? null : direccion_nocapv_;
			}

			String rangoEdadRancod = ("".equals(rangoEdadRancod_)) ? null : rangoEdadRancod_;
			String cocosx = ("".equals(cocosx_)) ? null : cocosx_;

			String productoPscodigo = ("".equals(productoPscodigo_)) ? null : productoPscodigo_;

			String productoPsnombre = ("".equals(productoPsnombre_)) ? null : productoPsnombre_;

			String motivoTircodigo = "";
			if (tircodigo_ != "" && tircodigo_ != null) {
				motivoTircodigo = ("".equals(tircodigo_)) ? null : tircodigo_;
			} else {
				motivoTircodigo = ("".equals(motivoTircodigo_)) ? null : motivoTircodigo_;

			}
			String motivoTirnombre = ("".equals(motivoTirnombre_)) ? null : motivoTirnombre_;

			// control checks
			String coinl21 = ("on".equals(coinl21_)) ? Y41bConstantes.VALOR_SI : null;
			String coinl37 = ("on".equals(coinl37_)) ? Y41bConstantes.VALOR_SI : null;

			String organismoCodOrg = ("".equals(organismoCodOrg_)) ? null : organismoCodOrg_;

			// Filtro
			Consulta filterConsulta = new Consulta(cocodigo, new Motivo(motivoTircodigo, motivoTirnombre, null),
					new Producto(productoPscodigo, productoPsnombre, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null),
					new RangoEdad(rangoEdadRancod, null, null, null),
					new FormaPresentacion(formaPresentacionTfpcodigo, null, null, null, null, null, null),
					new Organismo(organismoCodOrg),
					new CensoMonitor(censoMonitorMocodigo, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null),
					cofecha, cocosx, conran, cocose, cotexto, conrreg, conoco, conodirco, conrcpco, cocoloco, conoloco,
					conomuco, cocopvco, cocopaco, conrtelco, conrfaxco, cocoemco, coferes, coinreenv, coteresp,
					cocotfpr, coinl37, conranrg, cocopro, cohdcodigo, cohora, cofechaconsumidor, noraPaisId, nombrePais,
					provinciaId, nombreProvincia, municipioId, nombreMunicipio, localidadId, nombreLocalidad,
					noraCalleId, nombreCalle, noraCpId, nombreCp, noraPortalId, nombrePortal, coinl21, cosituacion,
					nombrePiso, direccion_nocapv, coextranjero, coestado, null, null, null, null, null, null);
			filterConsulta.setCofechadesde(cofechaDesde_);
			filterConsulta.setCofechahasta(cofechaHasta_);

			filterConsulta.setCoconsultaaaccempresas(coconsultaaaccempresas);
			filterConsulta.setCocif(cocif);
			filterConsulta.setCorazonsocial(corazonsocial);

			Long total = new Long(0);
			if (censoMonitor != null && censoMonitor.getPerfilConsultas() != null && !censoMonitor.getPerfilConsultas()
					.getIdPerfil().equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
				total = this.consultaService.findAllLikeConsultaCount(filterConsulta, false, cofechaDesde,
						cofechaHasta);
			}

			return total;

		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Metodo para generar un archivo excel con los filtrados correspondientes *
	 * 
	 * @param cocodigo
	 *            String
	 * @param coconsultaaaccempresas_
	 *            String
	 * @param motivoTircodigo_
	 *            String
	 * @param motivoTirnombre_
	 *            String
	 * @param productoPscodigo_
	 *            String
	 * @param productoPsnombre_
	 *            String
	 * @param rangoEdadRancod_
	 *            String
	 * @param formaPresentacionTfpcodigo_
	 *            String
	 * @param organismoCodOrg_
	 *            String
	 * @param censoMonitorMocodigo_
	 *            String
	 * @param cofecha
	 *            Date
	 * @param cocosx_
	 *            String
	 * @param conran
	 *            String
	 * @param cocose
	 *            String
	 * @param cotexto_
	 *            String
	 * @param conrreg
	 *            Integer
	 * @param conoco_
	 *            String
	 * @param cocif_
	 *            String
	 * @param corazonsocial_
	 *            String
	 * @param conodirco
	 *            String
	 * @param conrcpco
	 *            String
	 * @param cocoloco
	 *            String
	 * @param conoloco
	 *            String
	 * @param conomuco
	 *            String
	 * @param cocopvco
	 *            String
	 * @param cocopaco
	 *            String
	 * @param conrtelco
	 *            String
	 * @param conrfaxco
	 *            String
	 * @param cocoemco
	 *            String
	 * @param coferes
	 *            Date
	 * @param coinreenv
	 *            String
	 * @param coteresp
	 *            String
	 * @param cocotfpr
	 *            String
	 * @param coinl37_
	 *            String
	 * @param conranrg
	 *            Long
	 * @param cocopro
	 *            String
	 * @param cohdcodigo
	 *            String
	 * @param cohora
	 *            String
	 * @param cofechaconsumidor
	 *            Date
	 * @param noraPaisId_
	 *            String
	 * @param nombrePais
	 *            String
	 * @param provinciaId_
	 *            String
	 * @param nombreProvincia
	 *            String
	 * @param municipioId_
	 *            String
	 * @param nombreMunicipio
	 *            String
	 * @param localidadId_
	 *            String
	 * @param nombreLocalidad
	 *            String
	 * @param noraCalleId
	 *            String
	 * @param nombreCalle
	 *            String
	 * @param noraCpId
	 *            String
	 * @param nombreCp
	 *            String
	 * @param noraPortalId
	 *            String
	 * @param nombrePortal
	 *            String
	 * @param direccion_nocapv_
	 *            String
	 * @param coextranjero_
	 *            String
	 * @param coestado_
	 *            String
	 * @param coinl21_
	 *            String
	 * @param cosituacion_
	 *            String
	 * @param nombrePiso
	 *            String
	 * @param cofechaDesde_
	 *            String
	 * @param cofechaHasta_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excel", method = RequestMethod.GET)
	public void getAllConsultaExcel(@RequestParam(value = "cocodigo", required = false) String cocodigo,
			@RequestParam(value = "coconsultaaaccempresas", required = false) String coconsultaaaccempresas_,
			@RequestParam(value = "motivoTircodigo", required = false) String motivoTircodigo_,
			@RequestParam(value = "motivoTirnombre", required = false) String motivoTirnombre_,
			@RequestParam(value = "tircodigo", required = false) String tircodigo_,
			@RequestParam(value = "productoPscodigo", required = false) String productoPscodigo_,
			@RequestParam(value = "productoPsnombre", required = false) String productoPsnombre_,
			@RequestParam(value = "rangoEdadRancod", required = false) String rangoEdadRancod_,
			@RequestParam(value = "formaPresentacionTfpcodigo", required = false) String formaPresentacionTfpcodigo_,
			@RequestParam(value = "organismoCodOrg", required = false) String organismoCodOrg_,
			@RequestParam(value = "censoMonitorMocodigo", required = false) String censoMonitorMocodigo_,
			@RequestParam(value = "cofecha", required = false) Date cofecha,
			@RequestParam(value = "cocosx", required = false) String cocosx_,
			@RequestParam(value = "conran", required = false) String conran,
			@RequestParam(value = "cocose", required = false) String cocose,
			@RequestParam(value = "cotexto", required = false) String cotexto_,
			@RequestParam(value = "conrreg", required = false) Integer conrreg,
			@RequestParam(value = "conoco", required = false) String conoco_,
			@RequestParam(value = "cocif", required = false) String cocif_,
			@RequestParam(value = "corazonsocial", required = false) String corazonsocial_,
			@RequestParam(value = "conodirco", required = false) String conodirco,
			@RequestParam(value = "conrcpco", required = false) String conrcpco,
			@RequestParam(value = "cocoloco", required = false) String cocoloco,
			@RequestParam(value = "conoloco", required = false) String conoloco,
			@RequestParam(value = "conomuco", required = false) String conomuco,
			@RequestParam(value = "cocopvco", required = false) String cocopvco,
			@RequestParam(value = "cocopaco", required = false) String cocopaco,
			@RequestParam(value = "conrtelco", required = false) String conrtelco,
			@RequestParam(value = "conrfaxco", required = false) String conrfaxco,
			@RequestParam(value = "cocoemco", required = false) String cocoemco,
			@RequestParam(value = "coferes", required = false) Date coferes,
			@RequestParam(value = "coinreenv", required = false) String coinreenv,
			@RequestParam(value = "coteresp", required = false) String coteresp,
			@RequestParam(value = "cocotfpr", required = false) String cocotfpr,
			@RequestParam(value = "coinl37", required = false) String coinl37_,
			@RequestParam(value = "conranrg", required = false) Long conranrg,
			@RequestParam(value = "cocopro", required = false) String cocopro,
			@RequestParam(value = "cohdcodigo", required = false) String cohdcodigo,
			@RequestParam(value = "cohora", required = false) String cohora,
			@RequestParam(value = "cofechaconsumidor", required = false) Date cofechaconsumidor,
			@RequestParam(value = "noraPaisId", required = false) String noraPaisId_,
			@RequestParam(value = "nombrePais", required = false) String nombrePais,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "nombreProvincia", required = false) String nombreProvincia,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "nombreMunicipio", required = false) String nombreMunicipio,
			@RequestParam(value = "localidadId", required = false) String localidadId_,
			@RequestParam(value = "nombreLocalidad", required = false) String nombreLocalidad,
			@RequestParam(value = "noraCalleId", required = false) String noraCalleId,
			@RequestParam(value = "nombreCalle", required = false) String nombreCalle,
			@RequestParam(value = "noraCpId", required = false) String noraCpId,
			@RequestParam(value = "nombreCp", required = false) String nombreCp,
			@RequestParam(value = "noraPortalId", required = false) String noraPortalId,
			@RequestParam(value = "nombrePortal", required = false) String nombrePortal,
			@RequestParam(value = "direccion_nocapv", required = false) String direccion_nocapv_,
			@RequestParam(value = "coextranjero", required = false) String coextranjero_,
			@RequestParam(value = "coestado", required = false) String coestado_,
			@RequestParam(value = "coinl21", required = false) String coinl21_,
			@RequestParam(value = "cosituacion", required = false) String cosituacion_,
			@RequestParam(value = "nombrePiso", required = false) String nombrePiso,
			@RequestParam(value = "cofechaDesde", required = false) String cofechaDesde_,
			@RequestParam(value = "cofechaHasta", required = false) String cofechaHasta_, HttpServletRequest request,
			HttpServletResponse response) {
		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String coconsultaaaccempresas = ("".equals(coconsultaaaccempresas_)) ? null : coconsultaaaccempresas_;
			String cosituacion = ("".equals(cosituacion_)) ? null : cosituacion_;
			String censoMonitorMocodigo = ("".equals(censoMonitorMocodigo_)) ? null : censoMonitorMocodigo_;
			String formaPresentacionTfpcodigo = ("".equals(formaPresentacionTfpcodigo_)) ? null
					: formaPresentacionTfpcodigo_;
			String cotexto = ("".equals(cotexto_)) ? null : cotexto_;
			String conoco = ("".equals(conoco_)) ? null : conoco_;
			String cocif = ("".equals(cocif_)) ? null : cocif_;
			String corazonsocial = ("".equals(corazonsocial_)) ? null : corazonsocial_;

			String coextranjero = null;
			String coestado = null;
			String noraPaisId = null;
			String provinciaId = null;
			String municipioId = null;
			String localidadId = null;
			String direccion_nocapv = null;

			if (Y41bConstantes.NORA_LOCALIZACION_TODOS.equals(coextranjero_)) {
				coextranjero = null;
				noraPaisId = null;
				coestado = null;
				provinciaId = null;
				municipioId = null;
				localidadId = null;
				direccion_nocapv = null;
			} else if (Y41bConstantes.NORA_LOCALIZACION_EXTRANJERO.equals(coextranjero_)) {
				coextranjero = Y41bConstantes.VALOR_SI;
				noraPaisId = ("".equals(noraPaisId_)) ? null : noraPaisId_;
				coestado = null;
				provinciaId = null;
				municipioId = null;
				localidadId = null;
				direccion_nocapv = ("".equals(direccion_nocapv_)) ? null : direccion_nocapv_;

			} else if (Y41bConstantes.NORA_LOCALIZACION_ESTADO.equals(coextranjero_)) {
				coextranjero = null;
				noraPaisId = null;
				coestado = Y41bConstantes.VALOR_SI;
				provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
				municipioId = ("".equals(municipioId_)) ? null : municipioId_;
				localidadId = ("".equals(localidadId_)) ? null : localidadId_;
				direccion_nocapv = ("".equals(direccion_nocapv_)) ? null : direccion_nocapv_;
			}

			String rangoEdadRancod = ("".equals(rangoEdadRancod_)) ? null : rangoEdadRancod_;
			String cocosx = ("".equals(cocosx_)) ? null : cocosx_;

			String productoPscodigo = ("".equals(productoPscodigo_)) ? null : productoPscodigo_;

			String productoPsnombre = ("".equals(productoPsnombre_)) ? null : productoPsnombre_;

			String motivoTircodigo = "";
			if (tircodigo_ != "" && tircodigo_ != null) {
				motivoTircodigo = ("".equals(tircodigo_)) ? null : tircodigo_;
			} else {
				motivoTircodigo = ("".equals(motivoTircodigo_)) ? null : motivoTircodigo_;

			}
			String motivoTirnombre = ("".equals(motivoTirnombre_)) ? null : motivoTirnombre_;

			// control checks
			String coinl21 = ("on".equals(coinl21_)) ? Y41bConstantes.VALOR_SI : null;
			String coinl37 = ("on".equals(coinl37_)) ? Y41bConstantes.VALOR_SI : null;

			String organismoCodOrg = ("".equals(organismoCodOrg_)) ? null : organismoCodOrg_;

			// Filtro
			Consulta filterConsulta = new Consulta(cocodigo, new Motivo(motivoTircodigo, motivoTirnombre, null),
					new Producto(productoPscodigo, productoPsnombre, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null),
					new RangoEdad(rangoEdadRancod, null, null, null),
					new FormaPresentacion(formaPresentacionTfpcodigo, null, null, null, null, null, null),
					new Organismo(organismoCodOrg),
					new CensoMonitor(censoMonitorMocodigo, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null),
					cofecha, cocosx, conran, cocose, cotexto, conrreg, conoco, conodirco, conrcpco, cocoloco, conoloco,
					conomuco, cocopvco, cocopaco, conrtelco, conrfaxco, cocoemco, coferes, coinreenv, coteresp,
					cocotfpr, coinl37, conranrg, cocopro, cohdcodigo, cohora, cofechaconsumidor, noraPaisId, nombrePais,
					provinciaId, nombreProvincia, municipioId, nombreMunicipio, localidadId, nombreLocalidad,
					noraCalleId, nombreCalle, noraCpId, nombreCp, noraPortalId, nombrePortal, coinl21, cosituacion,
					nombrePiso, direccion_nocapv, coextranjero, coestado, null, null, null, null, null, null);
			filterConsulta.setCofechadesde(cofechaDesde_);
			filterConsulta.setCofechahasta(cofechaHasta_);

			filterConsulta.setCoconsultaaaccempresas(coconsultaaaccempresas);
			filterConsulta.setCocif(cocif);
			filterConsulta.setCorazonsocial(corazonsocial);

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy, "yyyyMMddHHmmss");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_BUSQUEDA_CONSULTAS + fechaActual + ".xls";
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(nombre) + "\"");

			String xslString = this.y41bExcelGeneratorService.getConsultasExcel(filterConsulta);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}

	}

	/**
	 * Method 'edit'.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param response
	 *            HttpServletResponse
	 * @return Consulta
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody Consulta edit(@RequestBody Consulta consulta, HttpServletResponse response) {
		try {
			Consulta consultaAux = this.consultaService.update(consulta);
			logger.info("Entity correctly inserted!");
			return consultaAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'respuesta'.
	 * 
	 * @param consultaRespuestaConsulta
	 *            ConsultaRespuestaConsulta
	 * @param response
	 *            HttpServletResponse
	 * @return Consulta
	 */
	@RequestMapping(value = "/respuesta", method = RequestMethod.PUT)
	public @ResponseBody Respuesta editRespuestaConsulta(
			@RequestBody ConsultaRespuestaConsulta consultaRespuestaConsulta, HttpServletResponse response,
			HttpServletRequest request) {
		try {
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			// mapeo del objeto que llega del formulario (consultaDetalle) todo
			// plano, al objeto real (consulta)

			// CONSULTA_________________________________________________________
			Consulta consulta = new Consulta();

			// id consulta
			consulta.setCocodigo(consultaRespuestaConsulta.getCocodigo());
			// nº consulta
			consulta.setCensoMonitor(censoMonitor);
			Organismo organismo = new Organismo();
			organismo.setCodOrg(consultaRespuestaConsulta.getCodOrg());
			consulta.setOrganismo(organismo);
			consulta.setConranrg(consultaRespuestaConsulta.getConranrg());
			consulta.setConrreg(consultaRespuestaConsulta.getConrreg());
			// cofecha Date
			consulta.setCofecha(consultaRespuestaConsulta.getCofecha());
			// texto consulta
			consulta.setCotexto(consultaRespuestaConsulta.getCotexto());

			// RESPUESTA________________________________________________
			Respuesta respuesta = new Respuesta();

			TipoRespuesta tipoRespuesta = new TipoRespuesta();
			tipoRespuesta.setP8codigo(consultaRespuestaConsulta.getP8codigo());
			respuesta.setTipoRespuesta(tipoRespuesta);
			respuesta.setP9feresp(consultaRespuestaConsulta.getP9feresp());
			respuesta.setP9teres(consultaRespuestaConsulta.getP9teres());
			respuesta.setP9feanot(new Date());
			respuesta.setP9nufiladj(new BigDecimal(0));
			respuesta.setP9inemlusu(Y41bConstantes.VALOR_NO);
			respuesta.setConsulta(consulta);

			Respuesta respAux = this.consultaService.responderConsulta(respuesta);
			logger.info("Entity correctly inserted!");
			return respAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'respuestaEmail'.
	 * 
	 * @param consultaRespuestaEmail
	 *            ConsultaRespuestaEmail
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return Consulta
	 */
	@RequestMapping(value = "/respuestaEmail", method = RequestMethod.PUT)
	public @ResponseBody Respuesta editRespuestaEmail(@RequestBody ConsultaRespuestaEmail consultaRespuestaEmail,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			// mapeo del objeto que llega del formulario (consultaDetalle) todo
			// plano, al objeto real (consulta)

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			// CONSULTA_________________________________________________
			Consulta consulta = new Consulta();

			consulta.setCocodigo(consultaRespuestaEmail.getCocodigo());
			consulta.setCocoemco(consultaRespuestaEmail.getCocoemco());
			consulta.setCensoMonitor(censoMonitor);
			Organismo organismo = new Organismo();
			organismo.setCodOrg(consultaRespuestaEmail.getCodOrg());
			consulta.setOrganismo(organismo);
			consulta.setConranrg(consultaRespuestaEmail.getConranrg());
			consulta.setConrreg(consultaRespuestaEmail.getConrreg());
			consulta.setCofecha(consultaRespuestaEmail.getCofecha());
			consulta.setCotexto(consultaRespuestaEmail.getCotexto());

			// RESPUESTA________________________________________________
			Respuesta respuesta = new Respuesta();
			TipoRespuesta tipoRespuesta = new TipoRespuesta();
			tipoRespuesta.setP8codigo(Y41bConstantes.TIPO_RESPUESTA_CONSULTA_EMAIL);
			respuesta.setTipoRespuesta(tipoRespuesta);
			respuesta.setP9feresp(consultaRespuestaEmail.getP9feresp());
			respuesta.setP9teres(consultaRespuestaEmail.getP9teres());
			respuesta.setP9feanot(new Date());
			respuesta.setP9nufiladj(new BigDecimal(0));
			respuesta.setP9inemlusu(Y41bConstantes.VALOR_SI);
			respuesta.setConsulta(consulta);

			Respuesta respAux = this.consultaService.emailConsulta(consulta, respuesta);
			logger.info("Entity correctly inserted!");
			return respAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'editConsulta'.
	 * 
	 * @param consultaDetalle
	 *            ConsultaDetalle
	 * @param response
	 *            HttpServletResponse
	 * @return Consulta
	 */
	@RequestMapping(value = "/modificacion", method = RequestMethod.PUT)
	public @ResponseBody Consulta editConsulta(@RequestBody ConsultaDetalle consultaDetalle,
			HttpServletResponse response) {
		try {
			// mapeo del objeto que llega del formulario (consultaDetalle) todo
			// plano, al objeto real (consulta)

			// CONSULTA_________________________________________________________
			Consulta consulta = new Consulta();

			// estado
			if ((consultaDetalle.getCoextranjero()).equalsIgnoreCase(Y41bConstantes.NO)) {

				consulta.setNoraPaisId(null);
				consulta.setNombrePais(null);
				consulta.setNoraProvinciaId(consultaDetalle.getProvinciaId());
				consulta.setNombreProvincia(consultaDetalle.getNombreProvincia());
				consulta.setNoraMunicipioId(consultaDetalle.getMunicipioId());
				consulta.setNombreMunicipio(consultaDetalle.getNombreMunicipio());
				consulta.setNoraLocalidadId(consultaDetalle.getLocalidadId());
				consulta.setNombreLocalidad(consultaDetalle.getNombreLocalidad());
				consulta.setNoraCalleId(consultaDetalle.getCalleId());
				consulta.setNombreCalle(consultaDetalle.getCalleId_label());
				consulta.setNoraCpId(consultaDetalle.getCpId());
				consulta.setNombreCp(consultaDetalle.getNombreCp());
				consulta.setNoraPortalId(consultaDetalle.getPortalId());
				consulta.setNombrePortal(consultaDetalle.getNombrePortal());
				consulta.setNombrePiso(consultaDetalle.getNombrePiso());
			} else {
				consulta.setNoraPaisId(consultaDetalle.getNoraPaisId());
				consulta.setNombrePais(consultaDetalle.getNombrePais());
				consulta.setNoraProvinciaId(null);
				consulta.setNombreProvincia(null);
				consulta.setNoraMunicipioId(null);
				consulta.setNombreMunicipio(null);
				consulta.setNoraLocalidadId(null);
				consulta.setNombreLocalidad(null);
				consulta.setNoraCalleId(null);
				consulta.setNombreCalle(null);
				consulta.setNoraPortalId(null);
				consulta.setNombrePortal(null);
				consulta.setNombrePiso(null);
			}

			// id consulta
			consulta.setCocodigo(consultaDetalle.getCocodigo());
			// nº consulta
			Organismo organismo = new Organismo();
			organismo.setCodOrg(consultaDetalle.getCodOrg());
			consulta.setOrganismo(organismo);
			consulta.setConranrg(consultaDetalle.getConranrg());
			consulta.setConrreg(consultaDetalle.getConrreg());
			// fecha

			// cofecha Date
			consulta.setCofecha(consultaDetalle.getCofecha());
			// cofecha consumidor = cofecha + hora llegada(cofechacons)
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			String strCofechaconshora = consultaDetalle.getCofechaconshora();

			if (Y41bUtils.isFilled(strCofechaconshora)) {
				String strDateCofecha = Y41bUtils.parseDateToString(consultaDetalle.getCofecha(), idioma);
				String strFechaconhora = strDateCofecha + " " + strCofechaconshora;

				Date dateFechaconhora = null;

				if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
					dateFechaconhora = Y41bUtils.formatearStringToDateFormato(strFechaconhora,
							Y41bConstantes.FORMATO_FECHAHORA_ES);
				} else if (Y41bConstantes.EUSKERA.equalsIgnoreCase(idioma)) {
					dateFechaconhora = Y41bUtils.formatearStringToDateFormato(strFechaconhora,
							Y41bConstantes.FORMATO_FECHAHORA_EU);
				}
				consulta.setCofechaconsumidor(dateFechaconhora);
			}

			consulta.setCohora(consultaDetalle.getCohora());

			// monitor
			CensoMonitor censoMonitor = new CensoMonitor();
			censoMonitor.setMocodigo(consultaDetalle.getMocodigo());
			consulta.setCensoMonitor(censoMonitor);
			// forma presentacion
			FormaPresentacion formaPresentacion = new FormaPresentacion();
			formaPresentacion.setTfpcodigo(consultaDetalle.getTfpcodigo());
			consulta.setFormaPresentacion(formaPresentacion);
			// texto consulta
			consulta.setCotexto(consultaDetalle.getCotexto());
			// producto/servicio
			Producto producto = new Producto();
			producto.setPscodigo(consultaDetalle.getPscodigo());
			consulta.setProducto(producto);
			// motivo
			Motivo motivo = new Motivo();
			motivo.setTircodigo(consultaDetalle.getTircodigo());
			consulta.setMotivo(motivo);

			// Consultas empresas
			consulta.setCoconsultaaaccempresas(consultaDetalle.getCoconsultaaaccempresas());
			consulta.setCocif(consultaDetalle.getCocif());
			consulta.setCorazonsocial(consultaDetalle.getCorazonsocial());
			consulta.setConombrecomercial(consultaDetalle.getConombrecomercial());

			// persona consumidora
			// nombre
			consulta.setConoco(consultaDetalle.getConoco());
			// edad
			RangoEdad rangoEdad = new RangoEdad();
			rangoEdad.setRancod(consultaDetalle.getRancod());
			consulta.setRangoEdad(rangoEdad);
			// sexo
			consulta.setCocosx(consultaDetalle.getCocosx());
			// email
			consulta.setCocoemco(consultaDetalle.getCocoemco());
			// tlfno1
			consulta.setConrtelco(consultaDetalle.getConrtelco());
			// fax - tlfno2
			consulta.setConrfaxco(consultaDetalle.getConrfaxco());

			// NORA
			// provincia
			// consulta.setNoraProvinciaId(consultaDetalle.getProvinciaId());
			// consulta.setNombreProvincia(consultaDetalle.getNombreProvincia());
			// // municipio
			// consulta.setNoraMunicipioId(consultaDetalle.getMunicipioId());
			// consulta.setNombreMunicipio(consultaDetalle.getNombreMunicipio());
			// // localidad
			// consulta.setNoraLocalidadId(consultaDetalle.getLocalidadId());
			// consulta.setNombreLocalidad(consultaDetalle.getNombreLocalidad());
			// // calle
			// consulta.setNoraCalleId(consultaDetalle.getCalleId());
			// consulta.setNombreCalle(consultaDetalle.getCalleId_label());
			// portal
			// consulta.setNoraPortalId(consultaDetalle.getPortalId());
			// consulta.setNombrePortal(consultaDetalle.getNombrePortal());
			// cp
			consulta.setNoraCpId(consultaDetalle.getCpId());
			consulta.setNombreCp(consultaDetalle.getNombreCp());
			// piso
			// consulta.setNombrePiso(consultaDetalle.getNombrePiso());

			// "direccion_nocapv"
			consulta.setDireccion_nocapv(consultaDetalle.getDireccion_nocapv());

			// "coextranjero"
			consulta.setCoextranjero(consultaDetalle.getCoextranjero());

			// consulta.setCocodigo(consultaDetalle.getCocodigo());
			// consulta.setCocoloco(consultaDetalle.getCocoloco());
			// consulta.setCocopaco(consultaDetalle.getCocopaco());
			// consulta.setCocopro(consultaDetalle.getCocopro());
			// consulta.setCocopvco(consultaDetalle.getCocopvco());
			// consulta.setCocose(consultaDetalle.getCocose());
			// consulta.setCocotfpr(consultaDetalle.getCocotfpr());
			// consulta.setCofecha(consultaDetalle.getCofecha());
			// consulta.setCoferes(consultaDetalle.getCoferes());
			// consulta.setCohdcodigo(consultaDetalle.getCohdcodigo());
			// consulta.setCoinl21(consultaDetalle.getCoinl21());
			// consulta.setCoinl37(consultaDetalle.getCoinl37());
			// consulta.setCoinreenv(consultaDetalle.getCoinreenv());
			// consulta.setConodirco(consultaDetalle.getConodirco());
			// consulta.setConoloco(consultaDetalle.getConoloco());
			// consulta.setConomuco(consultaDetalle.getConomuco());
			// consulta.setConran(consultaDetalle.getConran());
			// consulta.setConrcpco(consultaDetalle.getConrcpco());

			// // consulta.setConsultaFiles(consultaFiles);
			// consulta.setCosituacion(consultaDetalle.getCosituacion());
			// consulta.setCoteresp(consultaDetalle.getCoteresp());
			// consulta.setNombreCalle(consultaDetalle.getNombreCalle());
			// consulta.setNombreCp(consultaDetalle.getNombreCp());
			// consulta.setNombreLocalidad(consultaDetalle.getNombreLocalidad());
			// consulta.setNombreMunicipio(consultaDetalle.getNombreMunicipio());
			// consulta.setNombrePais(consultaDetalle.getNombrePais());
			// consulta.setNombrePiso(consultaDetalle.getNombrePiso());
			// consulta.setNombrePortal(consultaDetalle.getNombrePortal());
			// consulta.setNombreProvincia(consultaDetalle.getNombreProvincia());
			// consulta.setNoraPaisId(consultaDetalle.getNoraPaisId());

			// RESPUESTA________________________________________________
			Respuesta respuesta = new Respuesta();

			TipoRespuesta tipoRespuesta = new TipoRespuesta();
			tipoRespuesta.setP8codigo(consultaDetalle.getP8codigo());
			respuesta.setTipoRespuesta(tipoRespuesta);
			respuesta.setP9feresp(consultaDetalle.getP9feresp());
			respuesta.setP9teres(consultaDetalle.getP9teres());
			respuesta.setP9feanot(new Date());
			respuesta.setP9nufiladj(new BigDecimal(0));
			respuesta.setP9inemlusu(Y41bConstantes.VALOR_NO);

			// respuesta.setP9codigo(consultaDetalle.getP9codigo());
			// respuesta.setP9feanot(consultaDetalle.getP9feanot());
			// respuesta.setP9inemlusu(consultaDetalle.getP9inemlusu());
			// respuesta.setP9nufiladj(consultaDetalle.getP9nufiladj());
			// _________________________________________________________

			Consulta consultaAux = this.consultaService.updateConsulta(consulta, respuesta);
			logger.info("Entity correctly inserted!");
			return consultaAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return Consulta
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Consulta add(@RequestBody Consulta consulta) {
		try {
			Consulta consultaAux = this.consultaService.add(consulta);
			logger.info("Entity correctly inserted!");
			return consultaAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'addConsulta'.
	 * 
	 * @param consultaDetalle
	 *            ConsultaDetalle
	 * 
	 * @return Consulta
	 */
	@RequestMapping(value = "/alta", method = RequestMethod.POST)
	public @ResponseBody Consulta addConsulta(@RequestBody ConsultaDetalle consultaDetalle) {
		try {
			// mapeo del objeto que llega del formulario (consultaDetalle) todo
			// plano, al objeto real (consulta)

			// CONSULTA_________________________________________________________
			Consulta consulta = new Consulta();

			// estado
			if ((consultaDetalle.getCoextranjero()).equalsIgnoreCase(Y41bConstantes.NO)) {

				consulta.setNoraPaisId(null);
				consulta.setNombrePais(null);
				consulta.setNoraProvinciaId(consultaDetalle.getProvinciaId());
				consulta.setNombreProvincia(consultaDetalle.getNombreProvincia());
				consulta.setNoraMunicipioId(consultaDetalle.getMunicipioId());
				consulta.setNombreMunicipio(consultaDetalle.getNombreMunicipio());
				consulta.setNoraLocalidadId(consultaDetalle.getLocalidadId());
				consulta.setNombreLocalidad(consultaDetalle.getNombreLocalidad());
				consulta.setNoraCalleId(consultaDetalle.getCalleId());
				consulta.setNombreCalle(consultaDetalle.getCalleId_label());
				consulta.setNoraCpId(consultaDetalle.getCpId());
				consulta.setNombreCp(consultaDetalle.getNombreCp());
				consulta.setNoraPortalId(consultaDetalle.getPortalId());
				consulta.setNombrePortal(consultaDetalle.getNombrePortal());
				consulta.setNombrePiso(consultaDetalle.getNombrePiso());
			} else {
				consulta.setNoraPaisId(consultaDetalle.getNoraPaisId());
				consulta.setNombrePais(consultaDetalle.getNombrePais());
				consulta.setNoraProvinciaId(null);
				consulta.setNombreProvincia(null);
				consulta.setNoraMunicipioId(null);
				consulta.setNombreMunicipio(null);
				consulta.setNoraLocalidadId(null);
				consulta.setNombreLocalidad(null);
				consulta.setNoraCalleId(null);
				consulta.setNombreCalle(null);
				consulta.setNoraPortalId(null);
				consulta.setNombrePortal(null);
				consulta.setNombrePiso(null);
			}

			// nº consulta
			Organismo organismo = new Organismo();
			organismo.setCodOrg(consultaDetalle.getCodOrg());
			consulta.setOrganismo(organismo);
			consulta.setConranrg(consultaDetalle.getConranrg());
			consulta.setConrreg(consultaDetalle.getConrreg());
			// fecha

			// cofecha Date
			consulta.setCofecha(consultaDetalle.getCofecha());

			// cofecha consumidor = cofecha + hora llegada(cofechacons)
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			String strCofechaconshora = consultaDetalle.getCofechaconshora();

			if (Y41bUtils.isFilled(strCofechaconshora)) {
				String strDateCofecha = Y41bUtils.parseDateToString(consultaDetalle.getCofecha(), idioma);
				String strFechaconhora = strDateCofecha + " " + strCofechaconshora;

				Date dateFechaconhora = null;

				if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
					dateFechaconhora = Y41bUtils.formatearStringToDateFormato(strFechaconhora,
							Y41bConstantes.FORMATO_FECHAHORA_ES);
				} else if (Y41bConstantes.EUSKERA.equalsIgnoreCase(idioma)) {
					dateFechaconhora = Y41bUtils.formatearStringToDateFormato(strFechaconhora,
							Y41bConstantes.FORMATO_FECHAHORA_EU);
				}
				consulta.setCofechaconsumidor(dateFechaconhora);
			}

			consulta.setCohora(consultaDetalle.getCohora());

			// monitor
			CensoMonitor censoMonitor = new CensoMonitor();
			censoMonitor.setMocodigo(consultaDetalle.getMocodigo());
			consulta.setCensoMonitor(censoMonitor);
			// forma presentacion
			FormaPresentacion formaPresentacion = new FormaPresentacion();
			formaPresentacion.setTfpcodigo(consultaDetalle.getTfpcodigo());
			consulta.setFormaPresentacion(formaPresentacion);
			// texto consulta
			consulta.setCotexto(consultaDetalle.getCotexto());
			// producto/servicio
			Producto producto = new Producto();
			producto.setPscodigo(consultaDetalle.getPscodigo());
			consulta.setProducto(producto);
			// motivo
			Motivo motivo = new Motivo();
			motivo.setTircodigo(consultaDetalle.getTircodigo());
			consulta.setMotivo(motivo);

			// Consultas empresas
			consulta.setCoconsultaaaccempresas(consultaDetalle.getCoconsultaaaccempresas());
			consulta.setCocif(consultaDetalle.getCocif());
			consulta.setCorazonsocial(consultaDetalle.getCorazonsocial());
			consulta.setConombrecomercial(consultaDetalle.getConombrecomercial());

			// persona consumidora
			// nombre
			consulta.setConoco(consultaDetalle.getConoco());
			// edad
			RangoEdad rangoEdad = new RangoEdad();
			rangoEdad.setRancod(consultaDetalle.getRancod());
			consulta.setRangoEdad(rangoEdad);
			// sexo
			consulta.setCocosx(consultaDetalle.getCocosx());
			// email
			consulta.setCocoemco(consultaDetalle.getCocoemco());
			// tlfno1
			consulta.setConrtelco(consultaDetalle.getConrtelco());
			// fax - tlfno2
			consulta.setConrfaxco(consultaDetalle.getConrfaxco());

			// NORA
			// provincia
			// consulta.setNoraProvinciaId(consultaDetalle.getProvinciaId());
			// consulta.setNombreProvincia(consultaDetalle.getNombreProvincia());
			// municipio
			// consulta.setNoraMunicipioId(consultaDetalle.getMunicipioId());
			// consulta.setNombreMunicipio(consultaDetalle.getNombreMunicipio());
			// localidad
			// consulta.setNoraLocalidadId(consultaDetalle.getLocalidadId());
			// consulta.setNombreLocalidad(consultaDetalle.getNombreLocalidad());
			// calle
			// consulta.setNoraCalleId(consultaDetalle.getCalleId());
			// consulta.setNombreCalle(consultaDetalle.getCalleId_label());
			// portal
			// consulta.setNoraPortalId(consultaDetalle.getPortalId());
			// consulta.setNombrePortal(consultaDetalle.getNombrePortal());
			// cp
			consulta.setNoraCpId(consultaDetalle.getCpId());
			consulta.setNombreCp(consultaDetalle.getNombreCp());
			// piso
			// consulta.setNombrePiso(consultaDetalle.getNombrePiso());

			// "direccion_nocapv"
			consulta.setDireccion_nocapv(consultaDetalle.getDireccion_nocapv());

			// "coextranjero"
			consulta.setCoextranjero(consultaDetalle.getCoextranjero());

			// consulta.setCocodigo(consultaDetalle.getCocodigo());
			// consulta.setCocoloco(consultaDetalle.getCocoloco());
			// consulta.setCocopaco(consultaDetalle.getCocopaco());
			// consulta.setCocopro(consultaDetalle.getCocopro());
			// consulta.setCocopvco(consultaDetalle.getCocopvco());
			// consulta.setCocose(consultaDetalle.getCocose());
			// consulta.setCocotfpr(consultaDetalle.getCocotfpr());
			// consulta.setCofecha(consultaDetalle.getCofecha());
			// consulta.setCoferes(consultaDetalle.getCoferes());
			// consulta.setCohdcodigo(consultaDetalle.getCohdcodigo());
			// consulta.setCoinl21(consultaDetalle.getCoinl21());
			// consulta.setCoinl37(consultaDetalle.getCoinl37());
			// consulta.setCoinreenv(consultaDetalle.getCoinreenv());
			// consulta.setConodirco(consultaDetalle.getConodirco());
			// consulta.setConoloco(consultaDetalle.getConoloco());
			// consulta.setConomuco(consultaDetalle.getConomuco());
			// consulta.setConran(consultaDetalle.getConran());
			// consulta.setConrcpco(consultaDetalle.getConrcpco());
			// consulta.setConrreg(consultaDetalle.getConrreg());
			// // consulta.setConsultaFiles(consultaFiles);
			// consulta.setCosituacion(consultaDetalle.getCosituacion());
			// consulta.setCoteresp(consultaDetalle.getCoteresp());
			// consulta.setNombreCalle(consultaDetalle.getNombreCalle());
			// consulta.setNombreCp(consultaDetalle.getNombreCp());
			// consulta.setNombreLocalidad(consultaDetalle.getNombreLocalidad());
			// consulta.setNombreMunicipio(consultaDetalle.getNombreMunicipio());
			// consulta.setNombrePais(consultaDetalle.getNombrePais());
			// consulta.setNombrePiso(consultaDetalle.getNombrePiso());
			// consulta.setNombrePortal(consultaDetalle.getNombrePortal());
			// consulta.setNombreProvincia(consultaDetalle.getNombreProvincia());

			// RESPUESTA________________________________________________
			Respuesta respuesta = new Respuesta();

			TipoRespuesta tipoRespuesta = new TipoRespuesta();
			tipoRespuesta.setP8codigo(consultaDetalle.getP8codigo());
			respuesta.setTipoRespuesta(tipoRespuesta);
			respuesta.setP9feresp(consultaDetalle.getP9feresp());
			respuesta.setP9teres(consultaDetalle.getP9teres());
			respuesta.setP9feanot(new Date());
			respuesta.setP9nufiladj(new BigDecimal(0));
			respuesta.setP9inemlusu(Y41bConstantes.VALOR_NO);

			// respuesta.setP9codigo(consultaDetalle.getP9codigo());
			// respuesta.setP9feanot(consultaDetalle.getP9feanot());
			// respuesta.setP9inemlusu(consultaDetalle.getP9inemlusu());
			// respuesta.setP9nufiladj(consultaDetalle.getP9nufiladj());
			// _________________________________________________________

			Consulta consultaAux = this.consultaService.addConsulta(consulta, respuesta);
			logger.info("Entity correctly inserted!");
			return consultaAux;
		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param cocodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{cocodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String cocodigo, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Consulta consulta = new Consulta();
			consulta.setCocodigo(cocodigo);
			this.consultaService.remove(consulta);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + cocodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeConsulta'.
	 * 
	 * @param cocodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/removeConsulta/{cocodigo}", method = RequestMethod.DELETE)
	public void removeConsulta(@PathVariable String cocodigo, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Consulta consulta = new Consulta();
			consulta.setCocodigo(cocodigo);
			this.consultaService.removeConsulta(consulta);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			logger.error("Unable to delete " + cocodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param consultaIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(@RequestBody ArrayList<ArrayList<String>> consultaIds, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Consulta> consultaList = new ArrayList<Consulta>();
		try {
			for (ArrayList<String> consultaId : consultaIds) {
				Iterator<String> iterator = consultaId.iterator();
				Consulta consulta = new Consulta();
				consulta.setCocodigo(ObjectConversionManager.convert(iterator.next(), String.class));
				consultaList.add(consulta);
			}
			this.consultaService.removeMultiple(consultaList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getConsultaService'.
	 * 
	 * @return ConsultaService
	 */
	protected ConsultaService getConsultaService() {
		return this.consultaService;
	}

	/**
	 * Method 'setConsultaService'.
	 * 
	 * @param consultaService
	 *            ConsultaService
	 * @return
	 */
	public void setConsultaService(ConsultaService consultaService) {
		this.consultaService = consultaService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * Metodo para generar un archivo excel con los filtrados correspondientes *
	 * 
	 * @param tircodigo_
	 *            String
	 * 
	 * @param cocodigo
	 *            String
	 * @param coconsultaaaccempresas_
	 *            String
	 * @param motivoTircodigo_
	 *            String
	 * @param motivoTirnombre_
	 *            String
	 * @param productoPscodigo_
	 *            String
	 * @param productoPsnombre_
	 *            String
	 * @param rangoEdadRancod_
	 *            String
	 * @param formaPresentacionTfpcodigo_
	 *            String
	 * @param organismoCodOrg_
	 *            String
	 * @param censoMonitorMocodigo_
	 *            String
	 * @param cofecha
	 *            Date
	 * @param cocosx_
	 *            String
	 * @param conran
	 *            String
	 * @param cocose
	 *            String
	 * @param cotexto_
	 *            String
	 * @param conrreg
	 *            Integer
	 * @param conoco_
	 *            String
	 * @param conodirco
	 *            String
	 * @param conrcpco
	 *            String
	 * @param cocoloco
	 *            String
	 * @param conoloco
	 *            String
	 * @param conomuco
	 *            String
	 * @param cocopvco
	 *            String
	 * @param cocopaco
	 *            String
	 * @param conrtelco
	 *            String
	 * @param conrfaxco
	 *            String
	 * @param cocoemco
	 *            String
	 * @param coferes
	 *            Date
	 * @param coinreenv
	 *            String
	 * @param coteresp
	 *            String
	 * @param cocotfpr
	 *            String
	 * @param coinl37_
	 *            String
	 * @param conranrg
	 *            Long
	 * @param cocopro
	 *            String
	 * @param cohdcodigo
	 *            String
	 * @param cohora
	 *            String
	 * @param cofechaconsumidor
	 *            Date
	 * @param noraPaisId_
	 *            String
	 * @param nombrePais
	 *            String
	 * @param provinciaId_
	 *            String
	 * @param nombreProvincia
	 *            String
	 * @param municipioId_
	 *            String
	 * @param nombreMunicipio
	 *            String
	 * @param localidadId_
	 *            String
	 * @param nombreLocalidad
	 *            String
	 * @param noraCalleId
	 *            String
	 * @param nombreCalle
	 *            String
	 * @param noraCpId
	 *            String
	 * @param nombreCp
	 *            String
	 * @param noraPortalId
	 *            String
	 * @param nombrePortal
	 *            String
	 * @param direccion_nocapv_
	 *            String
	 * @param coextranjero_
	 *            String
	 * @param coestado_
	 *            String
	 * @param coinl21_
	 *            String
	 * @param cosituacion_
	 *            String
	 * @param nombrePiso
	 *            String
	 * @param cofechaDesde_
	 *            String
	 * @param cofechaHasta_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excelBandeja", method = RequestMethod.GET)
	public void getAllConsultaExcelBandeja(@RequestParam(value = "cocodigo", required = false) String cocodigo,
			@RequestParam(value = "coconsultaaaccempresas", required = false) String coconsultaaaccempresas_,
			@RequestParam(value = "motivoTircodigo", required = false) String motivoTircodigo_,
			@RequestParam(value = "motivoTirnombre", required = false) String motivoTirnombre_,
			@RequestParam(value = "tircodigo", required = false) String tircodigo_,
			@RequestParam(value = "productoPscodigo", required = false) String productoPscodigo_,
			@RequestParam(value = "productoPsnombre", required = false) String productoPsnombre_,
			@RequestParam(value = "rangoEdadRancod", required = false) String rangoEdadRancod_,
			@RequestParam(value = "formaPresentacionTfpcodigo", required = false) String formaPresentacionTfpcodigo_,
			@RequestParam(value = "organismoCodOrg", required = false) String organismoCodOrg_,
			@RequestParam(value = "censoMonitorMocodigo", required = false) String censoMonitorMocodigo_,
			@RequestParam(value = "cofecha", required = false) Date cofecha,
			@RequestParam(value = "cocosx", required = false) String cocosx_,
			@RequestParam(value = "conran", required = false) String conran,
			@RequestParam(value = "cocose", required = false) String cocose,
			@RequestParam(value = "cotexto", required = false) String cotexto_,
			@RequestParam(value = "conrreg", required = false) Integer conrreg,
			@RequestParam(value = "conoco", required = false) String conoco_,
			@RequestParam(value = "conodirco", required = false) String conodirco,
			@RequestParam(value = "conrcpco", required = false) String conrcpco,
			@RequestParam(value = "cocoloco", required = false) String cocoloco,
			@RequestParam(value = "conoloco", required = false) String conoloco,
			@RequestParam(value = "conomuco", required = false) String conomuco,
			@RequestParam(value = "cocopvco", required = false) String cocopvco,
			@RequestParam(value = "cocopaco", required = false) String cocopaco,
			@RequestParam(value = "conrtelco", required = false) String conrtelco,
			@RequestParam(value = "conrfaxco", required = false) String conrfaxco,
			@RequestParam(value = "cocoemco", required = false) String cocoemco,
			@RequestParam(value = "coferes", required = false) Date coferes,
			@RequestParam(value = "coinreenv", required = false) String coinreenv,
			@RequestParam(value = "coteresp", required = false) String coteresp,
			@RequestParam(value = "cocotfpr", required = false) String cocotfpr,
			@RequestParam(value = "coinl37", required = false) String coinl37_,
			@RequestParam(value = "conranrg", required = false) Long conranrg,
			@RequestParam(value = "cocopro", required = false) String cocopro,
			@RequestParam(value = "cohdcodigo", required = false) String cohdcodigo,
			@RequestParam(value = "cohora", required = false) String cohora,
			@RequestParam(value = "cofechaconsumidor", required = false) Date cofechaconsumidor,
			@RequestParam(value = "noraPaisId", required = false) String noraPaisId_,
			@RequestParam(value = "nombrePais", required = false) String nombrePais,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "nombreProvincia", required = false) String nombreProvincia,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "nombreMunicipio", required = false) String nombreMunicipio,
			@RequestParam(value = "localidadId", required = false) String localidadId_,
			@RequestParam(value = "nombreLocalidad", required = false) String nombreLocalidad,
			@RequestParam(value = "noraCalleId", required = false) String noraCalleId,
			@RequestParam(value = "nombreCalle", required = false) String nombreCalle,
			@RequestParam(value = "noraCpId", required = false) String noraCpId,
			@RequestParam(value = "nombreCp", required = false) String nombreCp,
			@RequestParam(value = "noraPortalId", required = false) String noraPortalId,
			@RequestParam(value = "nombrePortal", required = false) String nombrePortal,
			@RequestParam(value = "direccion_nocapv", required = false) String direccion_nocapv_,
			@RequestParam(value = "coextranjero", required = false) String coextranjero_,
			@RequestParam(value = "coestado", required = false) String coestado_,
			@RequestParam(value = "coinl21", required = false) String coinl21_,
			@RequestParam(value = "cosituacion", required = false) String cosituacion_,
			@RequestParam(value = "nombrePiso", required = false) String nombrePiso,
			@RequestParam(value = "cofechaDesde", required = false) String cofechaDesde_,
			@RequestParam(value = "cofechaHasta", required = false) String cofechaHasta_, HttpServletRequest request,
			HttpServletResponse response) {
		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String coconsultaaaccempresas = ("".equals(coconsultaaaccempresas_)) ? null : coconsultaaaccempresas_;
			String cosituacion = ("".equals(cosituacion_)) ? null : cosituacion_;
			String censoMonitorMocodigo = ("".equals(censoMonitorMocodigo_)) ? null : censoMonitorMocodigo_;
			String formaPresentacionTfpcodigo = ("".equals(formaPresentacionTfpcodigo_)) ? null
					: formaPresentacionTfpcodigo_;
			String cotexto = ("".equals(cotexto_)) ? null : cotexto_;
			String conoco = ("".equals(conoco_)) ? null : conoco_;

			String coextranjero = null;
			String coestado = null;
			String noraPaisId = null;
			String provinciaId = null;
			String municipioId = null;
			String localidadId = null;
			String direccion_nocapv = null;

			if (Y41bConstantes.NORA_LOCALIZACION_TODOS.equals(coextranjero_)) {
				coextranjero = null;
				noraPaisId = null;
				coestado = null;
				provinciaId = null;
				municipioId = null;
				localidadId = null;
				direccion_nocapv = null;
			} else if (Y41bConstantes.NORA_LOCALIZACION_EXTRANJERO.equals(coextranjero_)) {
				coextranjero = Y41bConstantes.VALOR_SI;
				noraPaisId = ("".equals(noraPaisId_)) ? null : noraPaisId_;
				coestado = null;
				provinciaId = null;
				municipioId = null;
				localidadId = null;
				direccion_nocapv = ("".equals(direccion_nocapv_)) ? null : direccion_nocapv_;

			} else if (Y41bConstantes.NORA_LOCALIZACION_ESTADO.equals(coextranjero_)) {
				coextranjero = null;
				noraPaisId = null;
				coestado = Y41bConstantes.VALOR_SI;
				provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
				municipioId = ("".equals(municipioId_)) ? null : municipioId_;
				localidadId = ("".equals(localidadId_)) ? null : localidadId_;
				direccion_nocapv = ("".equals(direccion_nocapv_)) ? null : direccion_nocapv_;
			}

			String rangoEdadRancod = ("".equals(rangoEdadRancod_)) ? null : rangoEdadRancod_;
			String cocosx = ("".equals(cocosx_)) ? null : cocosx_;

			String productoPscodigo = ("".equals(productoPscodigo_)) ? null : productoPscodigo_;

			String productoPsnombre = ("".equals(productoPsnombre_)) ? null : productoPsnombre_;

			String motivoTircodigo = "";
			if (tircodigo_ != "" && tircodigo_ != null) {
				motivoTircodigo = ("".equals(tircodigo_)) ? null : tircodigo_;
			} else {
				motivoTircodigo = ("".equals(motivoTircodigo_)) ? null : motivoTircodigo_;

			}
			String motivoTirnombre = ("".equals(motivoTirnombre_)) ? null : motivoTirnombre_;

			// control checks
			String coinl21 = ("on".equals(coinl21_)) ? Y41bConstantes.VALOR_SI : null;
			String coinl37 = ("on".equals(coinl37_)) ? Y41bConstantes.VALOR_SI : null;

			String organismoCodOrg = ("".equals(organismoCodOrg_)) ? null : organismoCodOrg_;

			// Filtro
			Consulta filterConsulta = new Consulta(cocodigo, new Motivo(motivoTircodigo, motivoTirnombre, null),
					new Producto(productoPscodigo, productoPsnombre, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null),
					new RangoEdad(rangoEdadRancod, null, null, null),
					new FormaPresentacion(formaPresentacionTfpcodigo, null, null, null, null, null, null),
					new Organismo(organismoCodOrg),
					new CensoMonitor(censoMonitorMocodigo, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null),
					cofecha, cocosx, conran, cocose, cotexto, conrreg, conoco, conodirco, conrcpco, cocoloco, conoloco,
					conomuco, cocopvco, cocopaco, conrtelco, conrfaxco, cocoemco, coferes, coinreenv, coteresp,
					cocotfpr, coinl37, conranrg, cocopro, cohdcodigo, cohora, cofechaconsumidor, noraPaisId, nombrePais,
					provinciaId, nombreProvincia, municipioId, nombreMunicipio, localidadId, nombreLocalidad,
					noraCalleId, nombreCalle, noraCpId, nombreCp, noraPortalId, nombrePortal, coinl21, cosituacion,
					nombrePiso, direccion_nocapv, coextranjero, coestado, null, null, null, null, null, null);
			filterConsulta.setCofechadesde(cofechaDesde_);
			filterConsulta.setCofechahasta(cofechaHasta_);

			filterConsulta.setCoconsultaaaccempresas(coconsultaaaccempresas);

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy, "yyyyMMddHHmmss");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_BANDEJA_CONSULTAS + fechaActual + ".xls";
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(nombre) + "\"");

			String xslString = this.y41bExcelGeneratorService.getConsultasExcelBandeja(filterConsulta);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}

	}
}
