package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.codehaus.jackson.annotate.JsonValue;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Conceptopago;
import com.ejie.y41b.service.ConceptopagoService;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * ConceptopagoController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/conceptopago")
public class ConceptopagoController {

	private static final Logger logger = LoggerFactory.getLogger(ConceptopagoController.class);

	@Autowired()
	private ConceptopagoService conceptopagoService;

	@Autowired()
	private Properties appConfiguration;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */
	@Autowired()
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody() void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintAplicPresupuestaria", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ConceptopagoController.logger.info("[GET - View] : conceptopago");
		return "conceptopago";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param sdcodigo
	 *            String
	 * @return conceptopago Conceptopago
	 */
	@RequestMapping(value = "/{sdcodigo}", method = RequestMethod.GET)
	public @ResponseBody() Conceptopago getById(@PathVariable() String sdcodigo) {
		Conceptopago conceptopago = new Conceptopago();
		conceptopago.setSdcodigo(sdcodigo);
		conceptopago = this.conceptopagoService.find(conceptopago);
		ConceptopagoController.logger.info("[GET - findBy_PK] : Obtener Conceptopago por PK");
		return conceptopago;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterConceptopago
	 *            Conceptopago
	 * @return List
	 */
	@RequestMapping(value = "/listar", method = RequestMethod.GET)
	public @ResponseBody() List<Conceptopago> getAll(@ModelAttribute() Conceptopago filterConceptopago) {
		ConceptopagoController.logger.info("[GET - find_ALL] : Obtener Conceptopago por filtro");
		return this.conceptopagoService.findAll(filterConceptopago, null);
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterConceptopago
	 *            Conceptopago
	 * @return List
	 */
	@RequestMapping(value = "/ejercicio", method = RequestMethod.GET)
	public @ResponseBody() List<Conceptopago> getAllEjercicios(@ModelAttribute() Conceptopago filterConceptopago) {
		ConceptopagoController.logger.info("[GET - find_ALL] : Obtener Conceptopago por filtro");
		return this.conceptopagoService.findAllEjerciciosVigentes(filterConceptopago, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param conceptopago
	 *            Conceptopago
	 * @return Conceptopago
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody() Conceptopago edit(@RequestBody() Conceptopago conceptopago) {
		Conceptopago conceptopagoAux = this.conceptopagoService.update(conceptopago);
		ConceptopagoController.logger.info("[PUT] : Conceptopago actualizado correctamente");
		return conceptopagoAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param conceptopago
	 *            Conceptopago
	 * @return Conceptopago
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody() Conceptopago add(@RequestBody() Conceptopago conceptopago) {
		conceptopago.setSdcodigo(String.valueOf(this.conceptopagoService.getNewPK()));
		Conceptopago conceptopagoAux = this.conceptopagoService.add(conceptopago);
		ConceptopagoController.logger.info("[POST] : Conceptopago insertado correctamente");
		return conceptopagoAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param sdcodigo
	 *            String
	 * @return conceptopago
	 */
	@RequestMapping(value = "/{sdcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody() Conceptopago remove(@PathVariable() String sdcodigo) {
		Conceptopago conceptopago = new Conceptopago();
		conceptopago.setSdcodigo(sdcodigo);
		this.conceptopagoService.remove(conceptopago);
		ConceptopagoController.logger.info("[DELETE] : Conceptopago borrado correctamente");
		return conceptopago;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param conceptopagoIds
	 *            List
	 * @return conceptopagoList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody() List<List<String>> removeMultiple(@RequestBody() List<List<String>> conceptopagoIds) {
		List<Conceptopago> conceptopagoList = new ArrayList<Conceptopago>();
		for (List<String> conceptopagoId : conceptopagoIds) {
			Iterator<String> iterator = conceptopagoId.iterator();
			Conceptopago conceptopago = new Conceptopago(); // NOPMD - Objeto
															// nuevo en la lista
															// (parametro del
															// servicio)
			conceptopago.setSdcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
			conceptopagoList.add(conceptopago);
		}
		this.conceptopagoService.removeMultiple(conceptopagoList);
		ConceptopagoController.logger.info("[POST - DELETE_ALL] : Conceptopago borrados correctamente");
		return conceptopagoIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterConceptopago
	 *            Conceptopago
	 * @param sddescripcion
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody() JQGridJSONModel getAllJQGrid(@ModelAttribute() Conceptopago filterConceptopago,
			@RequestParam(value = "sddescripcion", required = false) String sddescripcion,
			@ModelAttribute() Pagination pagination) {

		if (sddescripcion != null && !"".equals(sddescripcion)) {
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			if (Y41bConstantes.CASTELLANO.equals(idioma)) {
				filterConceptopago.setSddesces(sddescripcion);
			} else {
				filterConceptopago.setSddesdeu(sddescripcion);
			}
		}
		if (filterConceptopago.getSdejercicio() != null && "".equals(filterConceptopago.getSdejercicio())) {
			filterConceptopago.setSdejercicio(null);
		}
		if (filterConceptopago.getTipoconceptopago() != null
				&& "".equals(filterConceptopago.getTipoconceptopago().getSccodigo())) {
			filterConceptopago.getTipoconceptopago().setSccodigo(null);
		}
		List<Conceptopago> conceptopagos = this.conceptopagoService.findAll(filterConceptopago, pagination);
		Long recordNum = this.conceptopagoService.findAllCount(filterConceptopago);
		ConceptopagoController.logger.info("[GET - jqGrid] : Obtener Conceptopago");
		return new JQGridJSONModel(pagination, recordNum, conceptopagos);
	}

	/**
	 * Method 'comboEjercicio'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return List
	 */
	@RequestMapping(value = "/comboEjercicio", method = RequestMethod.GET)
	public @ResponseBody() List<Conceptopago> comboEjercicio(HttpServletRequest request) {

		Conceptopago conceptopago = new Conceptopago();

		Pagination pagination = new Pagination();
		pagination.setSort("sdejercicio");
		pagination.setAscDsc("ASC");

		return this.conceptopagoService.findAllEjercicio(conceptopago, pagination, false);
	}

	/**
	 * Method 'comboEjercicio'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return List
	 */
	@RequestMapping(value = "/comboEjercicioVigente", method = RequestMethod.GET)
	public @ResponseBody() List<Conceptopago> comboEjercicioVigente(HttpServletRequest request) {

		Conceptopago conceptopago = new Conceptopago();

		Pagination pagination = new Pagination();
		pagination.setSort("sdejercicio");
		pagination.setAscDsc("ASC");

		return this.conceptopagoService.findAllEjercicio(conceptopago, pagination, true);
	}

	/**
	 * Method 'getCreateFormAltaDecision'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "/alta", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		model.addAttribute("sdcodigo", "");
		if (censoMonitor.getPerfilEconomico() == null || censoMonitor.getPerfilEconomico().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleConceptopago", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormAltaDecision'.
	 * 
	 * @param sdcodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "/modificacion/{sdcodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormMod(@PathVariable() String sdcodigo, Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("sdcodigo", sdcodigo);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilEconomico() == null || censoMonitor.getPerfilEconomico().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleConceptopago", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormAltaDecision'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/baja", method = RequestMethod.GET)
	public ModelAndView getCreateFormBaja(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilEconomico() == null || censoMonitor.getPerfilEconomico().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("bajaConceptopago", "model", model);
		}
	}

	/**
	 * Method 'baja'.
	 * 
	 * @param sdejercicio
	 *            String
	 */
	@RequestMapping(value = "/baja/{sdejercicio}", method = RequestMethod.POST)
	public void baja(@PathVariable() String sdejercicio) {
		Conceptopago conceptopago = new Conceptopago();
		conceptopago.setSdejercicio(Long.parseLong(sdejercicio));
		this.conceptopagoService.baja(conceptopago);
		ConceptopagoController.logger.info("[POST] : Conceptopago baja correctamente");

	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
