package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.ComunicacionSoivreRelService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.ComunicacionSoivreRel;

/**
 * ComunicacionSoivreRelController  
 *  
 */
 
@Controller
@RequestMapping (value = "/comunicacionsoivrerel")

public class ComunicacionSoivreRelController  {

	private static final Logger logger = LoggerFactory.getLogger(ComunicacionSoivreRelController.class);

	@Autowired
	private ComunicacionSoivreRelService comunicacionSoivreRelService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ComunicacionSoivreRelController.logger.info("[GET - View] : comunicacionsoivrerel");
		return "comunicacionsoivrerel";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param v7codigo String
	 * @return comunicacionSoivreRel ComunicacionSoivreRel
	 */
	@RequestMapping(value = "/{v7codigo}", method = RequestMethod.GET)
	public @ResponseBody ComunicacionSoivreRel getById(@PathVariable String v7codigo) {
        ComunicacionSoivreRel comunicacionSoivreRel = new ComunicacionSoivreRel();
		comunicacionSoivreRel.setV7codigo(v7codigo);
        comunicacionSoivreRel = this.comunicacionSoivreRelService.find(comunicacionSoivreRel);
        ComunicacionSoivreRelController.logger.info("[GET - findBy_PK] : Obtener ComunicacionSoivreRel por PK");
        return comunicacionSoivreRel;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterComunicacionSoivreRel ComunicacionSoivreRel
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<ComunicacionSoivreRel> getAll(@ModelAttribute ComunicacionSoivreRel filterComunicacionSoivreRel) {
		ComunicacionSoivreRelController.logger.info("[GET - find_ALL] : Obtener ComunicacionSoivreRel por filtro");
	    return this.comunicacionSoivreRelService.findAll(filterComunicacionSoivreRel, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param comunicacionSoivreRel ComunicacionSoivreRel 
	 * @return ComunicacionSoivreRel
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody ComunicacionSoivreRel edit(@RequestBody ComunicacionSoivreRel comunicacionSoivreRel) {		
        ComunicacionSoivreRel comunicacionSoivreRelAux = this.comunicacionSoivreRelService.update(comunicacionSoivreRel);
		ComunicacionSoivreRelController.logger.info("[PUT] : ComunicacionSoivreRel actualizado correctamente");
        return comunicacionSoivreRelAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param comunicacionSoivreRel ComunicacionSoivreRel 
	 * @return ComunicacionSoivreRel
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody ComunicacionSoivreRel add(@RequestBody ComunicacionSoivreRel comunicacionSoivreRel) {		
        ComunicacionSoivreRel comunicacionSoivreRelAux = this.comunicacionSoivreRelService.add(comunicacionSoivreRel);
        ComunicacionSoivreRelController.logger.info("[POST] : ComunicacionSoivreRel insertado correctamente");
    	return comunicacionSoivreRelAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param v7codigo String
	 * @return comunicacionSoivreRel
	 */
	@RequestMapping(value = "/{v7codigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody ComunicacionSoivreRel remove(@PathVariable String v7codigo) {
        ComunicacionSoivreRel comunicacionSoivreRel = new ComunicacionSoivreRel();
        comunicacionSoivreRel.setV7codigo(v7codigo);
        this.comunicacionSoivreRelService.remove(comunicacionSoivreRel);
       	ComunicacionSoivreRelController.logger.info("[DELETE] : ComunicacionSoivreRel borrado correctamente");
       	return comunicacionSoivreRel;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param comunicacionSoivreRelIds List
	 * @return comunicacionSoivreRelList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> comunicacionSoivreRelIds) {
        List<ComunicacionSoivreRel> comunicacionSoivreRelList = new ArrayList<ComunicacionSoivreRel>();
        for (List<String> comunicacionSoivreRelId:comunicacionSoivreRelIds) {
		    Iterator<String> iterator = comunicacionSoivreRelId.iterator();
		    ComunicacionSoivreRel comunicacionSoivreRel = new ComunicacionSoivreRel(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        comunicacionSoivreRel.setV7codigo(ObjectConversionManager.convert(iterator.next(), String.class));
		    comunicacionSoivreRelList.add(comunicacionSoivreRel);
	    }
        this.comunicacionSoivreRelService.removeMultiple(comunicacionSoivreRelList);
		ComunicacionSoivreRelController.logger.info("[POST - DELETE_ALL] : ComunicacionSoivreRel borrados correctamente");
		return comunicacionSoivreRelIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterComunicacionSoivreRel ComunicacionSoivreRel
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute ComunicacionSoivreRel filterComunicacionSoivreRel, @ModelAttribute Pagination pagination) {
        List<ComunicacionSoivreRel> comunicacionSoivreRels = this.comunicacionSoivreRelService.findAll(filterComunicacionSoivreRel, pagination);
        Long recordNum = this.comunicacionSoivreRelService.findAllCount(filterComunicacionSoivreRel);
        ComunicacionSoivreRelController.logger.info("[GET - jqGrid] : Obtener ComunicacionSoivreRel");
		return new JQGridJSONModel(pagination, recordNum, comunicacionSoivreRels);
	}
	
}	
