package com.ejie.y41b.control;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.rowset.serial.SerialBlob;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.AdjunInfraccHechoDenun;
import com.ejie.y41b.model.AdjuntarComusoivrerel;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.ComunicacionSoivre;
import com.ejie.y41b.model.PlantillaControlMercadoDetalle;
import com.ejie.y41b.model.PlantillaTramite;
import com.ejie.y41b.model.PlantillaTramiteBusqueda;
import com.ejie.y41b.model.TipoDocumento;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.service.AdjunInfraccHechoDenunService;
import com.ejie.y41b.service.AdjuntarComusoivrerelService;
import com.ejie.y41b.service.AdjuntardocsService;
import com.ejie.y41b.service.CensoMonitorService;
import com.ejie.y41b.service.ComunicacionSoivreService;
import com.ejie.y41b.service.DenunciaService;
import com.ejie.y41b.service.PlantillaTramiteService;
import com.ejie.y41b.service.Y41bExcelGeneratorService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.documentos.Y41bDocumento;
import com.ejie.y41b.utils.documentos.Y41bGenerarDocumento;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * ComunicacionSoivreController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/comunicacionsoivre")
@SessionAttributes({ "codComunicacionSoivre", "modoBusquedaComuSoivre",
		"modoComunicacionSoivre", "comunicacionSoivreBusqueda" })
public class ComunicacionSoivreController {

	private static final Logger logger = LoggerFactory
			.getLogger(ComunicacionSoivreController.class);

	@Autowired
	private ComunicacionSoivreService comunicacionSoivreService;

	@Autowired
	private AdjunInfraccHechoDenunService adjunInfraccHechoDenunService;

	@Autowired
	private AdjuntardocsService adjuntardocsService;

	@Autowired
	private AdjuntarComusoivrerelService adjuntarComusoivrerelService;

	@Autowired
	private DenunciaService denunciaService;

	@Autowired
	private Properties appConfiguration;

	@Autowired()
	private CensoMonitorService censoMonitorService;

	@Autowired
	private Y41bExcelGeneratorService y41bExcelGeneratorService;

	@Autowired()
	private PlantillaTramiteService plantillaTramiteService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormMantenimiento'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/comunicacionesSoivre", method = RequestMethod.GET)
	public ModelAndView getCreateFormMantenimiento(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modoBusquedaComuSoivre", "");

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		ComunicacionSoivre comunicacionSoivre = new ComunicacionSoivre();
		model.addAttribute("comunicacionSoivreBusqueda", comunicacionSoivre);

		if (censoMonitor.getPerfilOrganizacion() == null
				|| censoMonitor.getPerfilOrganizacion().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("comunicacionessoivre", "model", model);
		}
	}

	/**
	 * Metodo que evita que la llamada a
	 * 'comunicacionesSoivreBusquedaConPrecarga' devuelva una excepcion variable
	 * de sesion. Si no existe, entra aqui y la crea. Si ya existe, Spring
	 * ignora este metodo.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return ComunicacionSoivre
	 */
	@ModelAttribute(value = "comunicacionSoivreBusqueda")
	public ComunicacionSoivre getComunicacionSoivre(HttpServletRequest request) {
		return new ComunicacionSoivre();
	}

	/**
	 * Method 'getCreateFormMantenimiento'.
	 * 
	 * @param model
	 *            Model
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "comunicacionesSoivreBusquedaConPrecarga", method = RequestMethod.GET)
	public ModelAndView getCreateFormComunicacionesSoivreBusquedaConPrecarga(
			Model model,
			@ModelAttribute(value = "comunicacionSoivreBusqueda") ComunicacionSoivre comunicacionSoivre,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modoBusquedaComuSoivre", "");

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		model.addAttribute("comunicacionSoivreBusqueda", comunicacionSoivre);

		if (censoMonitor.getPerfilOrganizacion() == null
				|| censoMonitor.getPerfilOrganizacion().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("comunicacionessoivre", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "seleccionComunicacionSoivre", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modoBusquedaComuSoivre",
				Y41bConstantes.MODO_POPUP_SELECCION);
		if (!model.containsAttribute("vieneDe")) {
			model.addAttribute("vieneDe", Y41bConstantes.VIENE_DE_BUSQUEDA);
		}

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilOrganizacion() == null
				|| censoMonitor.getPerfilOrganizacion().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("seleccionComunicacionSoivre", "model",
					model);
		}
	}

	/**
	 * Method 'getCreateFormAltaComunicacionSoivre'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "altaComunicacionSoivre", method = RequestMethod.GET)
	public ModelAndView getCreateFormAltaComunicacionSoivre(Model model,
			HttpServletRequest request) {
		model.addAttribute("vieneDe", Y41bConstantes.VIENE_DE_BANDEJAS);
		return this.getCreateFormAltaComunicacionSoivreBusqueda(model, request);
	}

	/**
	 * Method 'getCreateFormAltaComunicacionSoivreBusqueda'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "comunicacionesSoivreBusquedaConPrecarga/altaComunicacionSoivre", method = RequestMethod.GET)
	public ModelAndView getCreateFormAltaComunicacionSoivreBusqueda(
			Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("codComunicacionSoivre", Y41bUIDGenerator
				.getInstance().generateId(Y41bConstantes.PK_SIZE));

		model.addAttribute("modoComunicacionSoivre",
				Y41bConstantes.MODO_POPUP_ALTA);
		if (!model.containsAttribute("vieneDe")) {
			model.addAttribute("vieneDe", Y41bConstantes.VIENE_DE_BUSQUEDA);
		}

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilOrganizacion() == null
				|| censoMonitor.getPerfilOrganizacion().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleComunicacionSoivre", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormModComunicacionSoivre'.
	 * 
	 * @param idcomunicacionsoivre
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "comunicacionesSoivreBusquedaConPrecarga/modComunicacionSoivre/{idcomunicacionsoivre}", method = RequestMethod.GET)
	public ModelAndView getCreateFormModComunicacionSoivre(
			@PathVariable String idcomunicacionsoivre, Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("codComunicacionSoivre", idcomunicacionsoivre);

		model.addAttribute("modoComunicacionSoivre",
				Y41bConstantes.MODO_POPUP_MODIFICACION);
		if (!model.containsAttribute("vieneDe")) {
			model.addAttribute("vieneDe", Y41bConstantes.VIENE_DE_BUSQUEDA);
		}

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		ComunicacionSoivre comunicacionSoivre = new ComunicacionSoivre();
		comunicacionSoivre.setIdcomunicacionsoivre(idcomunicacionsoivre);

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idcomunicacionsoivre);

		this.adjunInfraccHechoDenunService
				.addInfraccionesTableTemporalControlMercado(tramiteComun);
		this.adjuntardocsService.addDocsTableTemporal(idcomunicacionsoivre);
		this.adjuntarComusoivrerelService
				.addComuSoivreRelTableTemporal(comunicacionSoivre);

		if (censoMonitor.getPerfilOrganizacion() == null
				|| censoMonitor.getPerfilOrganizacion().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleComunicacionSoivre", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormModComunicacionSoivre'.
	 * 
	 * @param idcomunicacionsoivre
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "comunicacionesSoivreBusquedaConPrecarga/modComunicacionSoivreSinCabecera/{idcomunicacionsoivre}", method = RequestMethod.GET)
	public ModelAndView getCreateFormModComunicacionSoivreSinCabecera(
			@PathVariable String idcomunicacionsoivre, Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("codComunicacionSoivre", idcomunicacionsoivre);

		model.addAttribute("modoComunicacionSoivre",
				Y41bConstantes.MODO_POPUP_MODIFICACION);
		if (!model.containsAttribute("vieneDe")) {
			model.addAttribute("vieneDe", Y41bConstantes.VIENE_DE_BUSQUEDA);
		}

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		ComunicacionSoivre comunicacionSoivre = new ComunicacionSoivre();
		comunicacionSoivre.setIdcomunicacionsoivre(idcomunicacionsoivre);

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idcomunicacionsoivre);

		this.adjunInfraccHechoDenunService
				.addInfraccionesTableTemporalControlMercado(tramiteComun);
		this.adjuntardocsService.addDocsTableTemporal(idcomunicacionsoivre);
		this.adjuntarComusoivrerelService
				.addComuSoivreRelTableTemporal(comunicacionSoivre);

		if (censoMonitor.getPerfilOrganizacion() == null
				|| censoMonitor.getPerfilOrganizacion().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleComunicacionSoivreSinCabecera",
					"model", model);
		}
	}

	/**
	 * Method 'getCreateFormModComunicacionSoivre'.
	 * 
	 * @param idcomunicacionsoivre
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "detalleComunicacionSoivre/{idcomunicacionsoivre}", method = RequestMethod.GET)
	public ModelAndView getCreateFormModComunicacionSoivreBandeja(
			@PathVariable String idcomunicacionsoivre, Model model,
			HttpServletRequest request) {
		model.addAttribute("vieneDe", Y41bConstantes.VIENE_DE_BANDEJAS);
		return this.getCreateFormModComunicacionSoivre(idcomunicacionsoivre,
				model, request);
	}

	/**
	 * Method 'getCreateFormModComunicacionSoivre'.
	 * 
	 * @param idcomunicacionsoivre
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "detalleComunicacionSoivreSinCabecera/{idcomunicacionsoivre}", method = RequestMethod.GET)
	public ModelAndView getCreateFormModComunicacionSoivreBandejaSinCabecera(
			@PathVariable String idcomunicacionsoivre, Model model,
			HttpServletRequest request) {
		model.addAttribute("vieneDe", Y41bConstantes.VIENE_DE_BANDEJAS);
		return this.getCreateFormModComunicacionSoivreSinCabecera(
				idcomunicacionsoivre, model, request);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idcomunicacionsoivre
	 *            String
	 * @return comunicacionSoivre ComunicacionSoivre
	 */
	@RequestMapping(value = "findComunicacionSoivre/{idcomunicacionsoivre}", method = RequestMethod.GET)
	public @ResponseBody
	ComunicacionSoivre getById(@PathVariable String idcomunicacionsoivre) {
		ComunicacionSoivre comunicacionSoivre = new ComunicacionSoivre();
		comunicacionSoivre.setIdcomunicacionsoivre(idcomunicacionsoivre);
		comunicacionSoivre = this.comunicacionSoivreService
				.find(comunicacionSoivre);
		ComunicacionSoivreController.logger
				.info("[GET - findBy_PK] : Obtener ComunicacionSoivre por PK");
		return comunicacionSoivre;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterComunicacionSoivre
	 *            ComunicacionSoivre
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<ComunicacionSoivre> getAll(
			@ModelAttribute ComunicacionSoivre filterComunicacionSoivre) {
		ComunicacionSoivreController.logger
				.info("[GET - find_ALL] : Obtener ComunicacionSoivre por filtro");
		return this.comunicacionSoivreService.findAll(filterComunicacionSoivre,
				null);
	}

	/**
	 * Method 'getAllComunicacionSoivre'.
	 * 
	 * @param v6codigo_
	 *            String
	 * @param v6tipo_
	 *            String
	 * @param v6coor_
	 *            String
	 * @param v6importador_
	 *            String
	 * @param esnif_
	 *            String
	 * @param esnombre_
	 *            String
	 * @param v6cops_
	 *            String
	 * @param v6copsdesc_
	 *            String
	 * @param v6nomps_
	 *            String
	 * @param codInfraccion_
	 *            String
	 * @param infraccionNombre_
	 *            String
	 * @param v6fechaentradaDesde_
	 *            String
	 * @param v6fechaentradaHasta_
	 *            String
	 * @param v6fecharespuestaDesde_
	 *            String
	 * @param v6fecharespuestaHasta_
	 *            String
	 * @param v6incluirrespondidas_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/findAllComunicacionSoivre", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllComunicacionSoivre(
			@RequestParam(value = "v6codigo", required = false) String v6codigo_,
			@RequestParam(value = "v6tipo", required = false) String v6tipo_,
			@RequestParam(value = "v6numsolicitud", required = false) String v6numsolicitud_,
			@RequestParam(value = "v6coor", required = false) String v6coor_,
			@RequestParam(value = "v6importador", required = false) String v6importador_,
			@RequestParam(value = "esnif", required = false) String esnif_,
			@RequestParam(value = "esnombre", required = false) String esnombre_,
			@RequestParam(value = "v6cops", required = false) String v6cops_,
			@RequestParam(value = "v6copsdesc", required = false) String v6copsdesc_,
			@RequestParam(value = "v6nomps", required = false) String v6nomps_,
			@RequestParam(value = "codInfraccion", required = false) String codInfraccion_,
			@RequestParam(value = "infraccionNombre", required = false) String infraccionNombre_,
			@RequestParam(value = "v6fechaentradaDesde", required = false) String v6fechaentradaDesde_,
			@RequestParam(value = "v6fechaentradaHasta", required = false) String v6fechaentradaHasta_,
			@RequestParam(value = "v6fecharespuestaDesde", required = false) String v6fecharespuestaDesde_,
			@RequestParam(value = "v6fecharespuestaHasta", required = false) String v6fecharespuestaHasta_,
			@RequestParam(value = "v6incluirrespondidas", required = false) String v6incluirrespondidas_,
			HttpServletRequest request, Model model) {
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();

			Date v6fechaentradaDesde = Y41bUtils.parseDate(
					v6fechaentradaDesde_, locale);
			Date v6fechaentradaHasta = Y41bUtils.parseDate(
					v6fechaentradaHasta_, locale);

			Date v6fecharespuestaDesde = Y41bUtils.parseDate(
					v6fecharespuestaDesde_, locale);
			Date v6fecharespuestaHasta = Y41bUtils.parseDate(
					v6fecharespuestaHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro
			String v6codigo = ("".equals(v6codigo_)) ? null : v6codigo_;
			String v6tipo = ("".equals(v6tipo_)) ? null : v6tipo_;
			String v6numsolicitud = ("".equals(v6numsolicitud_)) ? null
					: v6numsolicitud_;
			String v6coor = ("".equals(v6coor_)) ? null : v6coor_;
			String v6importador = ("".equals(v6importador_)) ? null
					: v6importador_;
			String v6cops = ("".equals(v6cops_)) ? null : v6cops_;
			String v6nomps = ("".equals(v6nomps_)) ? null : v6nomps_;
			String codInfraccion = ("".equals(codInfraccion_)) ? null
					: codInfraccion_;

			// control checks
			String v6incluirrespondidas = ("on".equals(v6incluirrespondidas_)) ? Y41bConstantes.VALOR_SI
					: null;

			ComunicacionSoivre filterComunicacionSoivre = new ComunicacionSoivre();

			filterComunicacionSoivre.setV6codigo(v6codigo);
			filterComunicacionSoivre.setV6tipo(v6tipo);
			filterComunicacionSoivre.setV6numsolicitud(v6numsolicitud);
			filterComunicacionSoivre.setV6coor(v6coor);
			filterComunicacionSoivre.setV6importador(v6importador);
			filterComunicacionSoivre.setV6importadoresnif(esnif_);
			filterComunicacionSoivre.setV6importadoresnombre(esnombre_);
			filterComunicacionSoivre.setV6cops(v6cops);
			filterComunicacionSoivre.setV6psnombre(v6copsdesc_);
			filterComunicacionSoivre.setV6nomps(v6nomps);
			filterComunicacionSoivre.setCodInfraccion(codInfraccion);
			filterComunicacionSoivre.setInfraccionNombre(infraccionNombre_);

			filterComunicacionSoivre
					.setV6fechaentradaDesde(v6fechaentradaDesde);
			filterComunicacionSoivre
					.setV6fechaentradaHasta(v6fechaentradaHasta);
			filterComunicacionSoivre
					.setV6fecharespuestaDesde(v6fecharespuestaDesde);
			filterComunicacionSoivre
					.setV6fecharespuestaHasta(v6fecharespuestaHasta);

			filterComunicacionSoivre
					.setV6fechaentradaDesdeStr(v6fechaentradaDesde_);
			filterComunicacionSoivre
					.setV6fechaentradaHastaStr(v6fechaentradaHasta_);
			filterComunicacionSoivre
					.setV6fecharespuestaDesdeStr(v6fecharespuestaDesde_);
			filterComunicacionSoivre
					.setV6fecharespuestaHastaStr(v6fecharespuestaHasta_);

			filterComunicacionSoivre
					.setV6incluirrespondidas(v6incluirrespondidas);

			model.addAttribute("comunicacionSoivreBusqueda",
					filterComunicacionSoivre);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<ComunicacionSoivre> listComunicacionSoivre = this.comunicacionSoivreService
						.findAllLike(filterComunicacionSoivre, pagination,
								false);

				if (listComunicacionSoivre == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.comunicacionSoivreService.findAllLikeCount(
						filterComunicacionSoivre, false);

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listComunicacionSoivre);
				return data;
			} else {
				List<ComunicacionSoivre> listComunicacionSoivre = this.comunicacionSoivreService
						.findAllLike(filterComunicacionSoivre, pagination,
								false);
				if (listComunicacionSoivre == null) {
					throw new Exception("No data Found.");
				}
				return listComunicacionSoivre;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllBandejaComunicacionSoivre'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/findAllBandejaComunicacionSoivre", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllBandejaComunicacionSoivre(HttpServletRequest request,
			Model model) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			ComunicacionSoivre filterComunicacionSoivre = new ComunicacionSoivre();

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setAscDsc(request.getParameter("sord"));

				String sort = request.getParameter("sidx");
				if ("v6establecimientovisitaesnombre".equals(sort)) {
					sort = "t3establecimiento.nombre";
				} else if ("v6establecimientovisitaesnombreMunicipio"
						.equals(sort)) {
					sort = "t3establecimiento.nombre_municipio";
				}
				pagination.setSort(sort);

				List<ComunicacionSoivre> listComunicacionSoivre = this.comunicacionSoivreService
						.findAllBandejaComunicacionSoivre(
								filterComunicacionSoivre, censoMonitor,
								pagination);

				if (listComunicacionSoivre == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.comunicacionSoivreService
						.findAllBandejaComunicacionSoivreCount(
								filterComunicacionSoivre, censoMonitor);

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listComunicacionSoivre);
				return data;
			} else {
				List<ComunicacionSoivre> listComunicacionSoivre = this.comunicacionSoivreService
						.findAllBandejaComunicacionSoivre(
								filterComunicacionSoivre, censoMonitor,
								pagination);
				if (listComunicacionSoivre == null) {
					throw new Exception("No data Found.");
				}
				return listComunicacionSoivre;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllBandejaComunicacionSoivreCount'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllBandejaComunicacionSoivrecount", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllBandejaComunicacionSoivreCount(HttpServletRequest request) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			ComunicacionSoivre filterComunicacionSoivre = new ComunicacionSoivre();

			Long total = this.comunicacionSoivreService
					.findAllBandejaComunicacionSoivreCount(
							filterComunicacionSoivre, censoMonitor);

			return total;
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @return ComunicacionSoivre
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	ComunicacionSoivre edit(@RequestBody ComunicacionSoivre comunicacionSoivre) {
		ComunicacionSoivre comunicacionSoivreAux = this.comunicacionSoivreService
				.update(comunicacionSoivre);
		ComunicacionSoivreController.logger
				.info("[PUT] : ComunicacionSoivre actualizado correctamente");
		return comunicacionSoivreAux;
	}

	/**
	 * Method 'updateComunicacionSoivre'.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @param response
	 *            HttpServletResponse
	 * @return ComunicacionSoivre
	 */
	@RequestMapping(value = "/updateComunicacionSoivre", method = RequestMethod.PUT)
	public @ResponseBody
	ComunicacionSoivre editComunicacionSoivre(
			@RequestBody ComunicacionSoivre comunicacionSoivre,
			HttpServletResponse response) {
		try {
			ComunicacionSoivre comunicacionSoivreAux = this.comunicacionSoivreService
					.updateComunicacionSoivre(comunicacionSoivre);
			ComunicacionSoivreController.logger
					.info("[PUT] : ComunicacionSoivre actualizado correctamente");
			return comunicacionSoivreAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'iniciarComunicacionSoivre'.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @param response
	 *            HttpServletResponse
	 * @return ComunicacionSoivre
	 */
	@RequestMapping(value = "/iniciarComunicacionSoivre", method = RequestMethod.PUT)
	public @ResponseBody
	ComunicacionSoivre iniciarComunicacionSoivre(
			@RequestBody ComunicacionSoivre comunicacionSoivre,
			HttpServletResponse response) {
		try {
			ComunicacionSoivre comunicacionSoivreAux = this.comunicacionSoivreService
					.iniciarComunicacionSoivre(comunicacionSoivre);
			ComunicacionSoivreController.logger
					.info("[PUT] : ComunicacionSoivre actualizado correctamente");
			return comunicacionSoivreAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @return ComunicacionSoivre
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	ComunicacionSoivre add(@RequestBody ComunicacionSoivre comunicacionSoivre) {
		ComunicacionSoivre comunicacionSoivreAux = this.comunicacionSoivreService
				.add(comunicacionSoivre);
		ComunicacionSoivreController.logger
				.info("[POST] : ComunicacionSoivre insertado correctamente");
		return comunicacionSoivreAux;
	}

	/**
	 * Method 'addComunicacionSoivre'.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @param codComunicacionSoivreAlta
	 *            String
	 * @param modoComunicacionSoivre
	 *            String
	 * @param model
	 *            Model
	 * @return ComunicacionSoivre
	 */
	@RequestMapping(value = "/guardarComunicacionSoivre", method = RequestMethod.POST)
	public @ResponseBody
	ComunicacionSoivre guardarComunicacionSoivre(
			@RequestBody ComunicacionSoivre comunicacionSoivre,
			@ModelAttribute(value = "codComunicacionSoivre") String codComunicacionSoivreAlta,
			@ModelAttribute(value = "modoComunicacionSoivre") String modoComunicacionSoivre,
			Model model) {
		try {

			comunicacionSoivre
					.setIdcomunicacionsoivre(codComunicacionSoivreAlta);
			ComunicacionSoivre comunicacionSoivreAux;
			if (modoComunicacionSoivre != null
					&& modoComunicacionSoivre
							.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
				comunicacionSoivreAux = this.comunicacionSoivreService
						.updateComunicacionSoivre(comunicacionSoivre);
				comunicacionSoivreAux
						.setModoComunicacionSoivre(Y41bConstantes.MODO_POPUP_MODIFICACION);
			} else {
				comunicacionSoivreAux = this.comunicacionSoivreService
						.addComunicacionSoivre(comunicacionSoivre);

				comunicacionSoivreAux
						.setModoComunicacionSoivre(Y41bConstantes.MODO_POPUP_ALTA);
			}
			model.addAttribute("modoComunicacionSoivre",
					Y41bConstantes.MODO_POPUP_MODIFICACION);

			logger.info("Entity correctly inserted!");
			return comunicacionSoivreAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'copiarComunicacionSoivre'.
	 * 
	 * @param v6codigoOrigen
	 *            String
	 * @param v6codigoDestino
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/copiarComunicacionSoivre", method = RequestMethod.POST)
	public @ResponseBody
	ComunicacionSoivre copiarComunicacionSoivre(

	@RequestParam(value = "v6codigoOrigen") String v6codigoOrigen,
			@RequestParam(value = "v6codigoDestino") String v6codigoDestino,
			HttpServletRequest request) {
		try {
			ComunicacionSoivre comunicacionSoivreOrigen = new ComunicacionSoivre();
			comunicacionSoivreOrigen.setV6codigo(v6codigoOrigen);

			ComunicacionSoivre comunicacionSoivreDestino = new ComunicacionSoivre();
			comunicacionSoivreDestino.setV6codigo(v6codigoDestino);

			comunicacionSoivreDestino = this.comunicacionSoivreService
					.copiarComunicacionSoivre(comunicacionSoivreOrigen,
							comunicacionSoivreDestino);

			if (comunicacionSoivreDestino == null) {
				throw new Exception("");
			}
			return comunicacionSoivreDestino;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idcomunicacionsoivre
	 *            String
	 * @return comunicacionSoivre
	 */
	@RequestMapping(value = "/{idcomunicacionsoivre}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	ComunicacionSoivre remove(@PathVariable String idcomunicacionsoivre) {
		ComunicacionSoivre comunicacionSoivre = new ComunicacionSoivre();
		comunicacionSoivre.setIdcomunicacionsoivre(idcomunicacionsoivre);
		this.comunicacionSoivreService.remove(comunicacionSoivre);
		ComunicacionSoivreController.logger
				.info("[DELETE] : ComunicacionSoivre borrado correctamente");
		return comunicacionSoivre;
	}

	/**
	 * Method 'removeComunicacionSoivre'.
	 * 
	 * @param idcomunicacionsoivre
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "removeComunicacionSoivre/{idcomunicacionsoivre}", method = RequestMethod.DELETE)
	public void removeComunicacionSoivre(
			@PathVariable String idcomunicacionsoivre,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			ComunicacionSoivre comunicacionSoivre = new ComunicacionSoivre();
			comunicacionSoivre.setIdcomunicacionsoivre(idcomunicacionsoivre);
			this.comunicacionSoivreService
					.removeComunicacionSoivre(comunicacionSoivre);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			logger.error("Unable to delete " + idcomunicacionsoivre);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param comunicacionSoivreIds
	 *            List
	 * @return comunicacionSoivreList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> comunicacionSoivreIds) {
		List<ComunicacionSoivre> comunicacionSoivreList = new ArrayList<ComunicacionSoivre>();
		for (List<String> comunicacionSoivreId : comunicacionSoivreIds) {
			Iterator<String> iterator = comunicacionSoivreId.iterator();
			ComunicacionSoivre comunicacionSoivre = new ComunicacionSoivre(); // NOPMD
																				// -
																				// Objeto
																				// nuevo
																				// en
																				// la
																				// lista
																				// (parametro
																				// del
																				// servicio)
			comunicacionSoivre.setIdcomunicacionsoivre(ObjectConversionManager
					.convert(iterator.next(), String.class));
			comunicacionSoivreList.add(comunicacionSoivre);
		}
		this.comunicacionSoivreService.removeMultiple(comunicacionSoivreList);
		ComunicacionSoivreController.logger
				.info("[POST - DELETE_ALL] : ComunicacionSoivre borrados correctamente");
		return comunicacionSoivreIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterComunicacionSoivre
	 *            ComunicacionSoivre
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute ComunicacionSoivre filterComunicacionSoivre,
			@ModelAttribute Pagination pagination) {
		List<ComunicacionSoivre> comunicacionSoivres = this.comunicacionSoivreService
				.findAll(filterComunicacionSoivre, pagination);
		Long recordNum = this.comunicacionSoivreService
				.findAllCount(filterComunicacionSoivre);
		ComunicacionSoivreController.logger
				.info("[GET - jqGrid] : Obtener ComunicacionSoivre");
		return new JQGridJSONModel(pagination, recordNum, comunicacionSoivres);
	}

	/**
	 * Method 'getAllComunicacionSoivreDocs'.
	 * 
	 * @param codComunicacionSoivre
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllComunicacionSoivreDocs", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllComunicacionSoivreDocs(
			@ModelAttribute(value = "codComunicacionSoivre") String codComunicacionSoivre,
			HttpServletRequest request) {
		try {
			Adjuntardocs adjuntardocsFilter = new Adjuntardocs();
			adjuntardocsFilter.setThidExpediente(codComunicacionSoivre);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAll(
						adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.adjuntardocsService
						.findAllCount(adjuntardocsFilter);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAdjuntardocs);
				return data;
			} else {
				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAll(
						adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}
				return listAdjuntardocs;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getByIdDocumentoComunicacionSoivre'.
	 * 
	 * @param iddocumento
	 *            String
	 * @param codComunicacionSoivreAlta
	 *            String
	 * 
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findComunicacionSoivreDocumento/{iddocumento}", method = RequestMethod.GET)
	public @ResponseBody
	void getByIdDocumentoComunicacionSoivre(
			@PathVariable String iddocumento,
			@ModelAttribute(value = "codComunicacionSoivre") String codComunicacionSoivreAlta,
			HttpServletResponse response) {
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThcodocumento(iddocumento);
			adjuntardocsAux.setThidTramite(codComunicacionSoivreAlta);

			adjuntardocsAux = this.adjuntardocsService
					.findAdjuntardocs(adjuntardocsAux);

			Blob contenido = adjuntardocsAux.getThdatafile();
			byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader(
					"Content-Disposition",
					"attachment; filename=\""
							+ StringEscapeUtils.unescapeHtml(adjuntardocsAux
									.getThnofile()) + "\"");
			response.setContentType(adjuntardocsAux.getThcontenttypefile());
			response.setContentLength(adjuntardocsAux.getThsizefile());
			response.getOutputStream().write(bContenido);

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addComunicacionSoivreDocs'.
	 * 
	 * @param file
	 *            MultipartFile
	 * @param codComunicacionSoivreAlta
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return ConsultaFile
	 */
	@RequestMapping(value = "/addComunicacionSoivreDocs", method = RequestMethod.POST)
	public @ResponseBody
	List<Map<String, Object>> addComunicacionSoivreDocs(
			@RequestParam(value = "files[]", required = false) MultipartFile file,
			@ModelAttribute(value = "codComunicacionSoivre") String codComunicacionSoivreAlta,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();

			String tedesfile = request.getParameter("tedesfile");

			String acuerdoInicio = request.getParameter("acuerdoInicio");

			if (acuerdoInicio != null && acuerdoInicio.equals("on")) {
				TipoDocumento tipoDocumento = new TipoDocumento();
				tipoDocumento.setIdTipodoc(Y41bConstantes.TIPO_DOC_AIP);

				adjuntardocsAux.setTipoDocumento(tipoDocumento);

				// En la lista de documentos asociados solo podr haber un
				// mximo de 1
				// documento de tipo acuerdo de inicio de procedimiento.
				Adjuntardocs adjuntardocsAux2 = new Adjuntardocs();
				TipoDocumento tipoDocumentoAux2 = new TipoDocumento();
				tipoDocumentoAux2.setIdTipodoc(Y41bConstantes.TIPO_DOC_AIP);

				adjuntardocsAux2.setTipoDocumento(tipoDocumentoAux2);
				adjuntardocsAux2.setThidExpediente(codComunicacionSoivreAlta);

				Long numAcuerdoInicioProcedimiento = this.adjuntardocsService
						.findAllCount(adjuntardocsAux2);

				if (numAcuerdoInicioProcedimiento > 0) {
					throw new Y41bUDAException(
							"error.comunicacionsoivre.AcuerdoInicioProcedimientoException",
							true, null);
				}
			}

			adjuntardocsAux.setThcodocumento(this.denunciaService
					.getNewPKDocumentoHecho().toString());

			Blob blob = new SerialBlob(file.getBytes());
			adjuntardocsAux.setThdatafile(blob);
			adjuntardocsAux.setThcontenttypefile(file.getContentType());
			adjuntardocsAux.setThnofile(file.getOriginalFilename());
			adjuntardocsAux.setThsizefile((int) file.getSize());

			adjuntardocsAux.setThidExpediente(codComunicacionSoivreAlta);
			adjuntardocsAux.setThidTramite(codComunicacionSoivreAlta);

			adjuntardocsAux.setThtedesfile(tedesfile);

			adjuntardocsAux
					.setThorigen(Y41bConstantes.ORIGEN_SOL_APORTADO_ADMINISTRACION);

			TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
			tipoProcedimiento.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
			adjuntardocsAux.setTipoProcedimiento(tipoProcedimiento);

			adjuntardocsAux.setThfecha(new Date());

			adjuntardocsAux = this.adjuntardocsService.add(adjuntardocsAux);

			logger.info("Entity correctly inserted!" + adjuntardocsAux);

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			filesMetaInfo.add(this.getFileReturnMap(file));
			return filesMetaInfo;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * @param file
	 *            MultipartFile
	 * @return mapa
	 */
	private Map<String, Object> getFileReturnMap(MultipartFile file) {
		Map<String, Object> mapaRetorno = new HashMap<String, Object>();
		mapaRetorno.put("url",
				"/y41bVistaWar/comunicacionsoivre/addComunicacionSoivreDocs/"
						+ file.getOriginalFilename());
		mapaRetorno.put("name", file.getOriginalFilename());
		mapaRetorno.put("type", file.getContentType());
		mapaRetorno.put("size", file.getSize());
		mapaRetorno.put("delete_url",
				"/y41bVistaWar/comunicacionsoivre/addComunicacionSoivreDocs/"
						+ file.getOriginalFilename());
		mapaRetorno.put("delete_type", "DELETE");
		return mapaRetorno;
	}

	/**
	 * Method 'removeComunicacionSoivreDocs'.
	 * 
	 * @param iddocumento
	 *            String
	 * @param codComunicacionSoivre
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarComunicacionSoivreDocs/{iddocumento}", method = RequestMethod.DELETE)
	public void removeComunicacionSoivreDocs(
			@PathVariable String iddocumento,
			@ModelAttribute(value = "codComunicacionSoivre") String codComunicacionSoivre,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThcodocumento(iddocumento);

			this.adjuntardocsService.remove(adjuntardocsAux);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllInfraccionesComunicacionSoivre'.
	 * 
	 * @param codComunicacionSoivre
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllInfraccionesComunicacionSoivre", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllInfraccionesComunicacionSoivre(
			@ModelAttribute(value = "codComunicacionSoivre") String codComunicacionSoivre,
			HttpServletRequest request) {
		try {
			AdjunInfraccHechoDenun adjunInfraccHechoDenunFilter = new AdjunInfraccHechoDenun();
			adjunInfraccHechoDenunFilter.setHicohd(codComunicacionSoivre);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<AdjunInfraccHechoDenun> listAdjunInfraccHechoDenun = null;

				listAdjunInfraccHechoDenun = this.adjunInfraccHechoDenunService
						.findAll(adjunInfraccHechoDenunFilter, pagination);

				if (listAdjunInfraccHechoDenun == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.adjunInfraccHechoDenunService
						.findAllCount(adjunInfraccHechoDenunFilter);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAdjunInfraccHechoDenun);
				return data;
			} else {
				List<AdjunInfraccHechoDenun> listAdjunInfraccHechoDenun = null;

				listAdjunInfraccHechoDenun = this.adjunInfraccHechoDenunService
						.findAll(adjunInfraccHechoDenunFilter, pagination);

				if (listAdjunInfraccHechoDenun == null) {
					throw new Exception("No data Found.");
				}
				return listAdjunInfraccHechoDenun;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addInfraccionesComunicacionSoivre'.
	 * 
	 * @param adjunInfraccHechoDenun
	 *            AdjunInfraccHechoDenun
	 * @param codComunicacionSoivre
	 *            String
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return AdjunInfraccHechoDenun
	 */
	@RequestMapping(value = "/addComunicacionSoivreInfracciones", method = RequestMethod.POST)
	public @ResponseBody
	AdjunInfraccHechoDenun addInfraccionesComunicacionSoivre(
			@RequestBody AdjunInfraccHechoDenun adjunInfraccHechoDenun,
			@ModelAttribute(value = "codComunicacionSoivre") String codComunicacionSoivre,
			HttpServletRequest request) {
		try {

			adjunInfraccHechoDenun.setHicohd(codComunicacionSoivre);

			String hiinexii = null;
			if (adjunInfraccHechoDenun.getHicotti() != null
					&& adjunInfraccHechoDenun.getHicotti().indexOf("N0") > -1) {
				// es un articulo
				hiinexii = "S";
			} else {
				hiinexii = "N";
			}
			adjunInfraccHechoDenun.setHiinexii(hiinexii);

			// Se da de alta el interviniente
			this.adjunInfraccHechoDenunService.add(adjunInfraccHechoDenun);

			logger.info("Entity correctly inserted!");
			return adjunInfraccHechoDenun;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'removeInfracciones'.
	 * 
	 * @param hicodigo
	 *            Long
	 * @param codComunicacionSoivre
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarComunicacionSoivreInfracciones/{hicodigo}", method = RequestMethod.DELETE)
	public void removeInfracciones(
			@PathVariable String hicodigo,
			@ModelAttribute(value = "codComunicacionSoivre") String codComunicacionSoivre,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			AdjunInfraccHechoDenun adjunInfraccHechoDenunAux = new AdjunInfraccHechoDenun();
			adjunInfraccHechoDenunAux.setHicodigo(hicodigo);

			this.adjunInfraccHechoDenunService
					.remove(adjunInfraccHechoDenunAux);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllRelComunicacionSoivre'.
	 * 
	 * @param codComunicacionSoivre
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllRelComunicacionSoivre", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllRelComunicacionSoivre(
			@ModelAttribute(value = "codComunicacionSoivre") String codComunicacionSoivre,
			HttpServletRequest request) {
		try {
			AdjuntarComusoivrerel adjuntarComusoivrerelFilter = new AdjuntarComusoivrerel();
			adjuntarComusoivrerelFilter
					.setIdcomunicacionsoivre(codComunicacionSoivre);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<ComunicacionSoivre> listComunicacionSoivre = null;

				listComunicacionSoivre = this.adjuntarComusoivrerelService
						.findAll(adjuntarComusoivrerelFilter, pagination);

				if (listComunicacionSoivre == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.adjuntarComusoivrerelService
						.findAllCount(adjuntarComusoivrerelFilter);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listComunicacionSoivre);
				return data;
			} else {
				List<ComunicacionSoivre> listComunicacionSoivre = null;

				listComunicacionSoivre = this.adjuntarComusoivrerelService
						.findAll(adjuntarComusoivrerelFilter, pagination);

				if (listComunicacionSoivre == null) {
					throw new Exception("No data Found.");
				}
				return listComunicacionSoivre;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addRelComunicacionSoivre'.
	 * 
	 * @param adjuntarComusoivrerel
	 *            AdjuntarComusoivrerel
	 * @param codComunicacionSoivre
	 *            String
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return AdjuntarComusoivrerel
	 */
	@RequestMapping(value = "/addRelComunicacionSoivre", method = RequestMethod.POST)
	public @ResponseBody
	AdjuntarComusoivrerel addRelComunicacionSoivre(
			@RequestBody AdjuntarComusoivrerel adjuntarComusoivrerel,
			@ModelAttribute(value = "codComunicacionSoivre") String codComunicacionSoivre,
			HttpServletRequest request) {
		try {
			this.adjuntarComusoivrerelService.add(adjuntarComusoivrerel);

			logger.info("Entity correctly inserted!");
			return adjuntarComusoivrerel;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'removeRelComunicacionSoivre'.
	 * 
	 * @param idcomunicacionsoivrerel
	 *            String
	 * @param codComunicacionSoivre
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarRelComunicacionSoivre/{idcomunicacionsoivrerel}", method = RequestMethod.DELETE)
	public void removeRelComunicacionSoivre(
			@PathVariable String idcomunicacionsoivrerel,
			@ModelAttribute(value = "codComunicacionSoivre") String codComunicacionSoivre,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			AdjuntarComusoivrerel adjuntarComusoivrerel = new AdjuntarComusoivrerel();
			adjuntarComusoivrerel
					.setIdcomunicacionsoivre(codComunicacionSoivre);
			adjuntarComusoivrerel
					.setIdcomunicacionsoivrerel(idcomunicacionsoivrerel);

			this.adjuntarComusoivrerelService
					.removeComusoivrerel(adjuntarComusoivrerel);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getCreateFormCopia'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "copiarComunicacionesSoivre", method = RequestMethod.GET)
	public ModelAndView getCreateFormCopia(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilOrganizacion() == null
				|| censoMonitor.getPerfilOrganizacion().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("copiaComunicacionesSoivre", "model", model);
		}
	}

	/**
	 * Metodo para generar un archivo excel con los filtrados correspondientes *
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excelBandejaComunicacionesSoivre", method = RequestMethod.GET)
	public void getAllConsultaExcel(HttpServletRequest request,
			HttpServletResponse response) {
		try {

			HttpSession httpSession = request.getSession();

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy,
					"yyyyMMddHHmmss");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_BUSQUEDA_BANDCOMUNICACIONESSOIVRE
					+ fechaActual + ".xls";
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ StringEscapeUtils.unescapeHtml(nombre) + "\"");

			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			censoMonitor = this.censoMonitorService.find(censoMonitor);
			String perfil = censoMonitor.getPerfilSanciones().getIdPerfil();

			String xslString = this.y41bExcelGeneratorService
					.getBandejaComunicacionesSoivreExcel(censoMonitor, perfil);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}

	}

	/**
	 * Method 'getAllComunicacionSoivreExcel'.
	 * 
	 * @param v6codigo_
	 *            String
	 * @param v6tipo_
	 *            String
	 * @param v6coor_
	 *            String
	 * @param v6importador_
	 *            String
	 * @param esnif_
	 *            String
	 * @param esnombre_
	 *            String
	 * @param v6cops_
	 *            String
	 * @param v6copsdesc_
	 *            String
	 * @param v6nomps_
	 *            String
	 * @param codInfraccion_
	 *            String
	 * @param infraccionNombre_
	 *            String
	 * @param v6fechaentradaDesde_
	 *            String
	 * @param v6fechaentradaHasta_
	 *            String
	 * @param v6fecharespuestaDesde_
	 *            String
	 * @param v6fecharespuestaHasta_
	 *            String
	 * @param v6incluirrespondidas_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excel", method = RequestMethod.GET)
	public void getAllComunicacionSoivreExcel(
			@RequestParam(value = "v6codigo", required = false) String v6codigo_,
			@RequestParam(value = "v6tipo", required = false) String v6tipo_,
			@RequestParam(value = "v6coor", required = false) String v6coor_,
			@RequestParam(value = "v6importador", required = false) String v6importador_,
			@RequestParam(value = "esnif", required = false) String esnif_,
			@RequestParam(value = "esnombre", required = false) String esnombre_,
			@RequestParam(value = "v6cops", required = false) String v6cops_,
			@RequestParam(value = "v6copsdesc", required = false) String v6copsdesc_,
			@RequestParam(value = "v6nomps", required = false) String v6nomps_,
			@RequestParam(value = "codInfraccion", required = false) String codInfraccion_,
			@RequestParam(value = "infraccionNombre", required = false) String infraccionNombre_,
			@RequestParam(value = "v6fechaentradaDesde", required = false) String v6fechaentradaDesde_,
			@RequestParam(value = "v6fechaentradaHasta", required = false) String v6fechaentradaHasta_,
			@RequestParam(value = "v6fecharespuestaDesde", required = false) String v6fecharespuestaDesde_,
			@RequestParam(value = "v6fecharespuestaHasta", required = false) String v6fecharespuestaHasta_,
			@RequestParam(value = "v6incluirrespondidas", required = false) String v6incluirrespondidas_,
			HttpServletRequest request, HttpServletResponse response) {
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();

			Date v6fechaentradaDesde = Y41bUtils.parseDate(
					v6fechaentradaDesde_, locale);
			Date v6fechaentradaHasta = Y41bUtils.parseDate(
					v6fechaentradaHasta_, locale);

			Date v6fecharespuestaDesde = Y41bUtils.parseDate(
					v6fecharespuestaDesde_, locale);
			Date v6fecharespuestaHasta = Y41bUtils.parseDate(
					v6fecharespuestaHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro
			String v6codigo = ("".equals(v6codigo_)) ? null : v6codigo_;
			String v6tipo = ("".equals(v6tipo_)) ? null : v6tipo_;
			String v6coor = ("".equals(v6coor_)) ? null : v6coor_;
			String v6importador = ("".equals(v6importador_)) ? null
					: v6importador_;
			String v6cops = ("".equals(v6cops_)) ? null : v6cops_;
			String v6nomps = ("".equals(v6nomps_)) ? null : v6nomps_;
			String codInfraccion = ("".equals(codInfraccion_)) ? null
					: codInfraccion_;

			// control checks
			String v6incluirrespondidas = ("on".equals(v6incluirrespondidas_)) ? Y41bConstantes.VALOR_SI
					: null;

			ComunicacionSoivre filterComunicacionSoivre = new ComunicacionSoivre();

			filterComunicacionSoivre.setV6codigo(v6codigo);
			filterComunicacionSoivre.setV6tipo(v6tipo);
			filterComunicacionSoivre.setV6coor(v6coor);
			filterComunicacionSoivre.setV6importador(v6importador);
			filterComunicacionSoivre.setV6importadoresnif(esnif_);
			filterComunicacionSoivre.setV6importadoresnombre(esnombre_);
			filterComunicacionSoivre.setV6cops(v6cops);
			filterComunicacionSoivre.setV6psnombre(v6copsdesc_);
			filterComunicacionSoivre.setV6nomps(v6nomps);
			filterComunicacionSoivre.setCodInfraccion(codInfraccion);
			filterComunicacionSoivre.setInfraccionNombre(infraccionNombre_);

			filterComunicacionSoivre
					.setV6fechaentradaDesde(v6fechaentradaDesde);
			filterComunicacionSoivre
					.setV6fechaentradaHasta(v6fechaentradaHasta);
			filterComunicacionSoivre
					.setV6fecharespuestaDesde(v6fecharespuestaDesde);
			filterComunicacionSoivre
					.setV6fecharespuestaHasta(v6fecharespuestaHasta);

			filterComunicacionSoivre
					.setV6fechaentradaDesdeStr(v6fechaentradaDesde_);
			filterComunicacionSoivre
					.setV6fechaentradaHastaStr(v6fechaentradaHasta_);
			filterComunicacionSoivre
					.setV6fecharespuestaDesdeStr(v6fecharespuestaDesde_);
			filterComunicacionSoivre
					.setV6fecharespuestaHastaStr(v6fecharespuestaHasta_);

			filterComunicacionSoivre
					.setV6incluirrespondidas(v6incluirrespondidas);

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy,
					"yyyyMMddHHmmss");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_BUSQUEDA_COMUNICACIONESSOIVRE
					+ fechaActual + ".xls";
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ StringEscapeUtils.unescapeHtml(nombre) + "\"");

			String xslString = this.y41bExcelGeneratorService
					.getComunicacionesSoivreExcel(filterComunicacionSoivre);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();

		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllPlantillasComunicacionSoivre'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllPlantilla", method = RequestMethod.GET)
	public @ResponseBody()
	Object getAllPlantillasComunicacionSoivre(HttpServletRequest request) {
		try {
			PlantillaTramite plantillaTramite = new PlantillaTramite();

			Tramite tramite = new Tramite();
			tramite.setTrcodigo(Y41bConstantes.TRAMITE_INSPECCIONES_ACUERDO_INICIO_PROCEDIMIENTO);
			plantillaTramite.setTramite(tramite);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<PlantillaTramiteBusqueda> listPlantillaTramiteBusqueda = null;

				listPlantillaTramiteBusqueda = this.plantillaTramiteService
						.findAllPlantillaTramite(plantillaTramite, pagination);

				if (listPlantillaTramiteBusqueda == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.plantillaTramiteService
						.findAllPlantillaTramiteCount(plantillaTramite);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listPlantillaTramiteBusqueda);
				return data;
			} else {
				List<PlantillaTramiteBusqueda> listPlantillaTramiteBusqueda = null;

				listPlantillaTramiteBusqueda = this.plantillaTramiteService
						.findAllPlantillaTramite(plantillaTramite, pagination);

				if (listPlantillaTramiteBusqueda == null) {
					throw new Exception("No data Found.");
				}
				return listPlantillaTramiteBusqueda;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addPlantillaComunicacionSoivre'.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param codComunicacionSoivreAlta
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/addPlantilla", method = RequestMethod.POST)
	public @ResponseBody()
	void addPlantillaComunicacionSoivre(
			@RequestBody() Adjuntardocs adjuntardocs,
			@ModelAttribute(value = "codComunicacionSoivre") String codComunicacionSoivreAlta,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			ComunicacionSoivre comunicacionSoivre = new ComunicacionSoivre();
			comunicacionSoivre
					.setIdcomunicacionsoivre(codComunicacionSoivreAlta);

			this.comunicacionSoivreService.addPlantilla(adjuntardocs,
					comunicacionSoivre, Y41bConstantes.TIPO_DOC_AIP);

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getEtiqueta'.
	 * 
	 * @param idcomunicacionsoivre
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * 
	 */
	@RequestMapping(value = "/etiqueta/{idcomunicacionsoivre}", method = RequestMethod.GET)
	public @ResponseBody
	void getEtiqueta(@PathVariable String idcomunicacionsoivre,
			HttpServletResponse response) {
		try {
			ComunicacionSoivre comunicacionSoivre = new ComunicacionSoivre();
			comunicacionSoivre.setIdcomunicacionsoivre(idcomunicacionsoivre);

			PlantillaControlMercadoDetalle plantillaControlMercadoDetalle = this.comunicacionSoivreService
					.findPlantillaControlMercadoDetalle(comunicacionSoivre);

			if (plantillaControlMercadoDetalle == null) {
				throw new Exception(idcomunicacionsoivre.toString());
			}

			String rutaRTF = (String) appConfiguration
					.get("y41bVistaWar.ruta.plantillas.word");
			String rutaXML = (String) appConfiguration
					.get("y41bVistaWar.rutaxml.plantillas.word");
			String nombreRTF = Y41bConstantes.NOMBRE_PLANTILLA_CONTROL_MERCADO_SOIVRE_ETIQUETA_RTF;
			String nombreXML = Y41bConstantes.NOMBRE_PLANTILLA_CONTROL_MERCADO_ETIQUETA_XML;
			String rutaCompletaRTF = rutaRTF + nombreRTF;
			String rutaCompletaXML = rutaXML + nombreXML;

			String plantilla = new String(
					Y41bDocumento.leerArchivoOrigen(rutaCompletaRTF));

			String strFileDataDecode = Y41bGenerarDocumento
					.generarDocumentoWord(rutaCompletaXML,
							plantillaControlMercadoDetalle, plantilla);

			byte[] bytesFichero = strFileDataDecode.getBytes();

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			StringBuffer nombreFichero = new StringBuffer()
					.append(plantillaControlMercadoDetalle.getTipoOrigen())
					.append("-")
					.append(plantillaControlMercadoDetalle.getCodigoOrigen())
					.append(".rtf");

			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ nombreFichero + "\"");
			response.setContentType("application/msword");
			response.setContentLength(bytesFichero.length);
			response.getOutputStream().write(bytesFichero);

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException(idcomunicacionsoivre.toString());
		} catch (Throwable t) {
			t.printStackTrace();
			throw new ResourceNotFoundException(idcomunicacionsoivre.toString());
		}
	}
}
