package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Claseingreso;
import com.ejie.y41b.service.ClaseingresoService;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * ClaseingresoController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/claseingreso")
public class ClaseingresoController {

	private static final Logger logger = LoggerFactory
			.getLogger(ClaseingresoController.class);

	@Autowired()
	private ClaseingresoService claseingresoService;

	@Autowired()
	private Properties appConfiguration;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */
	@Autowired()
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody()
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintClaseIngreso", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ClaseingresoController.logger.info("[GET - View] : claseingreso");
		return "claseingreso";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param slcodigo
	 *            String
	 * @return claseingreso Claseingreso
	 */
	@RequestMapping(value = "/{slcodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	Claseingreso getById(@PathVariable() String slcodigo) {
		Claseingreso claseingreso = new Claseingreso();
		claseingreso.setSlcodigo(slcodigo);
		claseingreso = this.claseingresoService.find(claseingreso);
		ClaseingresoController.logger
				.info("[GET - findBy_PK] : Obtener Claseingreso por PK");
		return claseingreso;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterClaseingreso
	 *            Claseingreso
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Claseingreso> getAll(@ModelAttribute() Claseingreso filterClaseingreso) {
		ClaseingresoController.logger
				.info("[GET - find_ALL] : Obtener Claseingreso por filtro");
		return this.claseingresoService.findAll(filterClaseingreso, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param claseingreso
	 *            Claseingreso
	 * @return Claseingreso
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Claseingreso edit(@RequestBody() Claseingreso claseingreso) {
		Claseingreso claseingresoAux = this.claseingresoService
				.update(claseingreso);
		ClaseingresoController.logger
				.info("[PUT] : Claseingreso actualizado correctamente");
		return claseingresoAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param claseingreso
	 *            Claseingreso
	 * @return Claseingreso
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Claseingreso add(@RequestBody() Claseingreso claseingreso) {
		claseingreso.setSlcodigo(String.valueOf(this.claseingresoService
				.getNewPK()));
		Claseingreso claseingresoAux = this.claseingresoService
				.add(claseingreso);
		ClaseingresoController.logger
				.info("[POST] : Claseingreso insertado correctamente");
		return claseingresoAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param slcodigo
	 *            String
	 */
	@RequestMapping(value = "/eliminar/{slcodigo}", method = RequestMethod.POST)
	public @ResponseBody()
	void remove(@PathVariable() String slcodigo) {
		try {
			Claseingreso claseingreso = new Claseingreso();
			claseingreso.setSlcodigo(slcodigo);
			this.claseingresoService.remove(claseingreso);
			ClaseingresoController.logger
					.info("[DELETE] : Claseingreso borrado correctamente");
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException(
					"error.claseingreso.DataIntegrityViolationException", true,
					e);
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param claseingresoIds
	 *            List
	 * @return claseingresoList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(
			@RequestBody() List<List<String>> claseingresoIds) {
		List<Claseingreso> claseingresoList = new ArrayList<Claseingreso>();
		for (List<String> claseingresoId : claseingresoIds) {
			Iterator<String> iterator = claseingresoId.iterator();
			Claseingreso claseingreso = new Claseingreso(); // NOPMD
															// -
															// Objeto
															// nuevo
															// en la
															// lista
															// (parametro
															// del
															// servicio)
			claseingreso.setSlcodigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			claseingresoList.add(claseingreso);
		}
		this.claseingresoService.removeMultiple(claseingresoList);
		ClaseingresoController.logger
				.info("[POST - DELETE_ALL] : Claseingreso borrados correctamente");
		return claseingresoIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterClaseingreso
	 *            Claseingreso
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute() Claseingreso filterClaseingreso,
			@ModelAttribute() Pagination pagination) {
		List<Claseingreso> claseingresos = this.claseingresoService.findAll(
				filterClaseingreso, pagination);
		Long recordNum = this.claseingresoService
				.findAllCount(filterClaseingreso);
		ClaseingresoController.logger
				.info("[GET - jqGrid] : Obtener Claseingreso");
		return new JQGridJSONModel(pagination, recordNum, claseingresos);
	}

	/**
	 * Method 'getCreateFormAltaDecision'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/alta", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		model.addAttribute("slcodigo", "");
		if (censoMonitor.getPerfilEconomico() == null
				|| censoMonitor.getPerfilEconomico().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleClaseingreso", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormMod'.
	 * 
	 * @param slcodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "/modificacion/{slcodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormMod(@PathVariable() String slcodigo,
			Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("slcodigo", slcodigo);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilEconomico() == null
				|| censoMonitor.getPerfilEconomico().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleClaseingreso", "model", model);
		}
	}

	/**
	 * Method 'comboClaseingreso'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return List
	 */
	@RequestMapping(value = "/combo", method = RequestMethod.GET)
	public @ResponseBody()
	List<Claseingreso> comboClaseingreso(HttpServletRequest request) {

		Claseingreso claseingreso = new Claseingreso();
		/*
		 * desde la ficha de expedientes
		 */
		Locale locale = LocaleContextHolder.getLocale();
		String idioma = locale.getLanguage();

		Pagination pagination = new Pagination();
		if (Y41bConstantes.CASTELLANO.equals(idioma)) {
			pagination.setSort("sldesces");
		} else {
			pagination.setSort("sldesceu");
		}
		pagination.setAscDsc("ASC");

		return this.claseingresoService.findAll(claseingreso, pagination);
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

}
