package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.Perfil;
import com.ejie.y41b.service.CensoMonitorService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * * CensoMonitorController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/censomonitor")
public class CensoMonitorController {

	private static final Logger logger = LoggerFactory.getLogger(CensoMonitorController.class);

	@Autowired
	private CensoMonitorService censoMonitorService;

	@Autowired
	private Properties appConfiguration;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("Y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("Y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null || censoMonitor.getPerfilMaestros().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("censomonitor", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormAlta'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "alta", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("Y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("Y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null || censoMonitor.getPerfilMaestros().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("alta_modal", "model", model);
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param mocodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{mocodigo}", method = RequestMethod.GET)
	public @ResponseBody CensoMonitor getById(@PathVariable String mocodigo) {
		try {
			CensoMonitor censoMonitor = new CensoMonitor();
			censoMonitor.setMocodigo(mocodigo);
			censoMonitor = this.censoMonitorService.find(censoMonitor);
			if (censoMonitor == null) {
				throw new Exception(mocodigo.toString());
			}
			return censoMonitor;
		} catch (Exception e) {
			throw new ResourceNotFoundException(mocodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param mocodigo
	 *            String
	 * @param organismoCodOrg
	 *            String
	 * @param monombre
	 *            String
	 * @param mocoem
	 *            String
	 * @param modni
	 *            String
	 * @param usuarioxlnet
	 *            String
	 * @param mofecbaja
	 *            Date
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody Object getAll(@RequestParam(value = "mocodigo", required = false) String mocodigo,
			@RequestParam(value = "organismoCodOrg", required = false) String organismoCodOrg,
			@RequestParam(value = "monombre", required = false) String monombre,
			@RequestParam(value = "mocoem", required = false) String mocoem,
			@RequestParam(value = "modni", required = false) String modni,
			@RequestParam(value = "usuarioxlnet", required = false) String usuarioxlnet,
			@RequestParam(value = "mofecbaja", required = false) Date mofecbaja, HttpServletRequest request) {
		try {
			CensoMonitor filterCensoMonitor = new CensoMonitor(mocodigo, monombre, mocoem, modni, usuarioxlnet, null,
					mofecbaja, new Organismo(organismoCodOrg), null, null, null, null, null, null, null, null, null,
					null, null, null, null, null);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<CensoMonitor> censoMonitors = this.censoMonitorService.findAll(filterCensoMonitor, pagination);

				if (censoMonitors == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterCensoMonitor, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(censoMonitors);
				return data;
			} else {
				List<CensoMonitor> censoMonitors = this.censoMonitorService.findAll(filterCensoMonitor, pagination);
				if (censoMonitors == null) {
					throw new Exception("No data Found.");
				}
				return censoMonitors;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllFilter'.
	 * 
	 * @param mocodigo
	 *            String
	 * @param organismoCodOrg_
	 *            String
	 * @param monombre
	 *            String
	 * @param mocoem
	 *            String
	 * @param modni_
	 *            String
	 * @param usuarioxlnet_
	 *            String
	 * @param mofecbaja
	 *            Date
	 * @param indIncluirBaja_
	 *            String
	 * @param perfilEconomico_
	 *            String
	 * @param perfilOrganizacion_
	 *            String
	 * @param perfilMaestros_
	 *            String
	 * @param perfilConsultas_
	 *            String
	 * @param perfilInspecciones_
	 *            String
	 * @param perfilSolicitudes_
	 *            String
	 * @param perfilSanciones_
	 *            String
	 * @param perfilArbitraje_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.GET)
	public @ResponseBody Object getAllFilter(@RequestParam(value = "mocodigo", required = false) String mocodigo,
			@RequestParam(value = "organismoCodOrg", required = false) String organismoCodOrg_,
			@RequestParam(value = "monombre", required = false) String monombre_,
			@RequestParam(value = "mocoem", required = false) String mocoem,
			@RequestParam(value = "modni", required = false) String modni_,
			@RequestParam(value = "usuarioxlnet", required = false) String usuarioxlnet_,
			@RequestParam(value = "mofecbaja", required = false) Date mofecbaja,
			@RequestParam(value = "indIncluirBaja", required = false) String indIncluirBaja_,
			@RequestParam(value = "perfilEconomico.idPerfil", required = false) String perfilEconomico_,
			@RequestParam(value = "perfilOrganizacion.idPerfil", required = false) String perfilOrganizacion_,
			@RequestParam(value = "perfilMaestros.idPerfil", required = false) String perfilMaestros_,
			@RequestParam(value = "perfilConsultas.idPerfil", required = false) String perfilConsultas_,
			@RequestParam(value = "perfilInspecciones.idPerfil", required = false) String perfilInspecciones_,
			@RequestParam(value = "perfilSolicitudes.idPerfil", required = false) String perfilSolicitudes_,
			@RequestParam(value = "perfilSanciones.idPerfil", required = false) String perfilSanciones_,
			@RequestParam(value = "perfilArbitraje.idPerfil", required = false) String perfilArbitraje_,
			HttpServletRequest request) {
		try {
			String organismoCodOrg = ("".equals(organismoCodOrg_)) ? null : organismoCodOrg_;
			String modni = ("".equals(modni_)) ? null : modni_;
			String usuarioxlnet = ("".equals(usuarioxlnet_)) ? null : usuarioxlnet_;
			String monombre = ("".equals(monombre_)) ? null : monombre_;

			String perfilEconomico = ("".equals(perfilEconomico_)) ? null : perfilEconomico_;
			String perfilOrganizacion = ("".equals(perfilOrganizacion_)) ? null : perfilOrganizacion_;
			String perfilMaestros = ("".equals(perfilMaestros_)) ? null : perfilMaestros_;
			String perfilConsultas = ("".equals(perfilConsultas_)) ? null : perfilConsultas_;
			String perfilInspecciones = ("".equals(perfilInspecciones_)) ? null : perfilInspecciones_;
			String perfilSolicitudes = ("".equals(perfilSolicitudes_)) ? null : perfilSolicitudes_;
			String perfilSanciones = ("".equals(perfilSanciones_)) ? null : perfilSanciones_;
			String perfilArbitraje = ("".equals(perfilArbitraje_)) ? null : perfilArbitraje_;

			// control checks
			String indIncluirBaja = ("on".equals(indIncluirBaja_)) ? Y41bConstantes.VALOR_SI : null;

			CensoMonitor filterCensoMonitor = new CensoMonitor(mocodigo, monombre, mocoem, modni, usuarioxlnet, null,
					mofecbaja, new Organismo(organismoCodOrg), new Perfil(perfilSolicitudes, null, null),
					new Perfil(perfilSanciones, null, null), new Perfil(perfilInspecciones, null, null),
					new Perfil(perfilArbitraje, null, null), new Perfil(perfilOrganizacion, null, null),
					new Perfil(perfilMaestros, null, null), new Perfil(perfilEconomico, null, null),
					new Perfil(perfilConsultas, null, null), null, null, null, indIncluirBaja, null, null);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<CensoMonitor> censoMonitors = this.censoMonitorService.findAllLikeFilter(filterCensoMonitor,
						pagination, false);

				if (censoMonitors == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCountFilter(filterCensoMonitor, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(censoMonitors);
				return data;
			} else {
				List<CensoMonitor> censoMonitors = this.censoMonitorService.findAllLikeFilter(filterCensoMonitor,
						pagination, false);
				if (censoMonitors == null) {
					throw new Exception("No data Found.");
				}
				return censoMonitors;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllFilter'.
	 * 
	 * @param mocodigo
	 *            String
	 * @param organismoCodOrg_
	 *            String
	 * @param monombre
	 *            String
	 * @param mocoem
	 *            String
	 * @param modni_
	 *            String
	 * @param usuarioxlnet_
	 *            String
	 * @param mofecbaja
	 *            Date
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/filterModif", method = RequestMethod.GET)
	public @ResponseBody Object getAllFilterModif(@RequestParam(value = "mocodigo", required = false) String mocodigo,
			@RequestParam(value = "organismoCodOrg", required = false) String organismoCodOrg_,
			@RequestParam(value = "monombre", required = false) String monombre,
			@RequestParam(value = "mocoem", required = false) String mocoem,
			@RequestParam(value = "modni", required = false) String modni_,
			@RequestParam(value = "usuarioxlnet", required = false) String usuarioxlnet_,
			@RequestParam(value = "mofecbaja", required = false) Date mofecbaja, HttpServletRequest request) {
		try {
			String organismoCodOrg = ("".equals(organismoCodOrg_)) ? null : organismoCodOrg_;
			String modni = ("".equals(modni_)) ? null : modni_;
			String usuarioxlnet = ("".equals(usuarioxlnet_)) ? null : usuarioxlnet_;
			CensoMonitor filterCensoMonitor = new CensoMonitor(mocodigo, monombre, mocoem, modni, usuarioxlnet, null,
					mofecbaja, new Organismo(organismoCodOrg), null, null, null, null, null, null, null, null, null,
					null, null, null, null, null);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<CensoMonitor> censoMonitors = this.censoMonitorService.findAllFilterModif(filterCensoMonitor,
						pagination, false);

				if (censoMonitors == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCountFilter(filterCensoMonitor, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(censoMonitors);
				return data;
			} else {
				List<CensoMonitor> censoMonitors = this.censoMonitorService.findAllFilterModif(filterCensoMonitor,
						pagination, false);
				if (censoMonitors == null) {
					throw new Exception("No data Found.");
				}
				return censoMonitors;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllFilter'.
	 * 
	 * @param mocodigo
	 *            String
	 * @param organismoCodOrg_
	 *            String
	 * @param monombre
	 *            String
	 * @param mocoem
	 *            String
	 * @param modni_
	 *            String
	 * @param usuarioxlnet_
	 *            String
	 * @param mofecbaja
	 *            Date
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/filterModifArb", method = RequestMethod.GET)
	public @ResponseBody Object getAllFilterModifArb(
			@RequestParam(value = "mocodigo", required = false) String mocodigo,
			@RequestParam(value = "organismoCodOrg", required = false) String organismoCodOrg_,
			@RequestParam(value = "monombre", required = false) String monombre,
			@RequestParam(value = "mocoem", required = false) String mocoem,
			@RequestParam(value = "modni", required = false) String modni_,
			@RequestParam(value = "usuarioxlnet", required = false) String usuarioxlnet_,
			@RequestParam(value = "mofecbaja", required = false) Date mofecbaja, HttpServletRequest request) {
		try {
			// String organismoCodOrg = ("".equals(organismoCodOrg_)) ? null
			// : organismoCodOrg_;
			String modni = ("".equals(modni_)) ? null : modni_;
			String usuarioxlnet = ("".equals(usuarioxlnet_)) ? null : usuarioxlnet_;
			CensoMonitor filterCensoMonitor = new CensoMonitor(mocodigo, monombre, mocoem, modni, usuarioxlnet, null,
					mofecbaja, null/* new Organismo(organismoCodOrg) */, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null);
			Pagination pagination = null;

			List<CensoMonitor> censoMonitors = this.censoMonitorService.findAllFilterModifArb(filterCensoMonitor,
					pagination, false);
			if (censoMonitors == null) {
				throw new Exception("No data Found.");
			}
			return censoMonitors;

		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllFilterAltas'.
	 * 
	 * @param organismoCodOrg
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/filterAltas", method = RequestMethod.GET)
	public @ResponseBody Object getAllFilterAltas(
			@RequestParam(value = "organismoCodOrg", required = false) String organismoCodOrg,
			HttpServletRequest request) {
		try {
			CensoMonitor filterCensoMonitor = new CensoMonitor(null, null, null, null, null, null, null,
					new Organismo(organismoCodOrg), null, null, null, null, null, null, null, null, null, null, null,
					null, null, null);

			List<CensoMonitor> censoMonitors = this.censoMonitorService.findAllCensoMonitorAlta(filterCensoMonitor);
			if (censoMonitors == null) {
				throw new Exception("No data Found.");
			}
			return censoMonitors;

		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllFilterAltasConsultas'.
	 * 
	 * @param organismoCodOrg
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/filterAltasConsultas", method = RequestMethod.GET)
	public @ResponseBody Object getAllFilterAltasConsultas(
			@RequestParam(value = "organismoCodOrg", required = false) String organismoCodOrg,
			HttpServletRequest request) {
		try {
			CensoMonitor filterCensoMonitor = new CensoMonitor(null, null, null, null, null, null, null,
					new Organismo(organismoCodOrg), null, null, null, null, null, null, null, null, null, null, null,
					null, null, null);

			List<CensoMonitor> censoMonitors = this.censoMonitorService
					.findAllCensoMonitorAltaConsultas(filterCensoMonitor);
			if (censoMonitors == null) {
				throw new Exception("No data Found.");
			}
			return censoMonitors;

		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllFilterAltasConsultas'.
	 * 
	 * @param organismoCodOrg
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/filterAltasConsultasEmpresas", method = RequestMethod.GET)
	public @ResponseBody Object getAllFilterAltasConsultasEmpresas(
			@RequestParam(value = "organismoCodOrg", required = false) String organismoCodOrg,
			HttpServletRequest request) {
		try {
			CensoMonitor filterCensoMonitor = new CensoMonitor(null, null, null, null, null, null, null,
					new Organismo(organismoCodOrg), null, null, null, null, null, null, null, null, null, null, null,
					null, null, null);

			List<CensoMonitor> censoMonitors = this.censoMonitorService
					.findAllCensoMonitorAltaConsultasEmpresas(filterCensoMonitor);
			if (censoMonitors == null) {
				throw new Exception("No data Found.");
			}
			return censoMonitors;

		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllFilterAltasInstructor'.
	 * 
	 * @param organismoCodOrg
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/filterAltasInstructor", method = RequestMethod.GET)
	public @ResponseBody Object getAllFilterAltasInstructor(
			@RequestParam(value = "organismoCodOrg", required = false) String organismoCodOrg,
			HttpServletRequest request) {
		try {
			CensoMonitor filterCensoMonitor = new CensoMonitor(null, null, null, null, null, null, null,
					new Organismo(organismoCodOrg), null, null, null, null, null, null, null, null, null, null, null,
					null, null, null);

			List<CensoMonitor> censoMonitors = this.censoMonitorService
					.findAllCensoMonitorAltaAsignacionInstructor(filterCensoMonitor);
			if (censoMonitors == null) {
				throw new Exception("No data Found.");
			}
			return censoMonitors;

		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllFilterAltasInspeccionesInstructor'.
	 * 
	 * @param organismoCodOrg
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/filterAltasInspeccionesInstructor", method = RequestMethod.GET)
	public @ResponseBody Object getAllFilterAltasInspeccionesInstructor(
			@RequestParam(value = "organismoCodOrg", required = false) String organismoCodOrg,
			HttpServletRequest request) {
		try {
			CensoMonitor filterCensoMonitor = new CensoMonitor(null, null, null, null, null, null, null,
					new Organismo(organismoCodOrg), null, null, null, null, null, null, null, null, null, null, null,
					null, null, null);

			List<CensoMonitor> censoMonitors = this.censoMonitorService
					.findAllCensoMonitorAltaSolicitudInspeccion(filterCensoMonitor);
			if (censoMonitors == null) {
				throw new Exception("No data Found.");
			}
			return censoMonitors;

		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCountFilter'.
	 * 
	 * @param filterCensoMonitor
	 *            CensoMonitor
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody Long getAllCountFilter(
			@RequestParam(value = "censoMonitor", required = false) CensoMonitor filterCensoMonitor,
			HttpServletRequest request) {
		try {
			return censoMonitorService.findAllLikeCountFilter(
					filterCensoMonitor != null ? filterCensoMonitor : new CensoMonitor(), false);
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterCensoMonitor
	 *            CensoMonitor
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count2", method = RequestMethod.GET)
	public @ResponseBody Long getAllCount(
			@RequestParam(value = "censoMonitor", required = false) CensoMonitor filterCensoMonitor,
			HttpServletRequest request) {
		try {
			return censoMonitorService
					.findAllCount(filterCensoMonitor != null ? filterCensoMonitor : new CensoMonitor());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param response
	 *            HttpServletResponse
	 * @return CensoMonitor
	 */

	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody CensoMonitor edit(@RequestBody CensoMonitor censoMonitor, HttpServletResponse response) {
		try {
			CensoMonitor censoMonitorAux = this.censoMonitorService.update(censoMonitor);
			logger.info("Entity correctly inserted!");
			return censoMonitorAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	// @RequestMapping(method = RequestMethod.PUT)
	// public @ResponseBody
	// CensoMonitor edit(@RequestBody CensoMonitor censoMonitor,
	// HttpServletResponse response) {
	// try {
	// CensoMonitor censoMonitorAux = this.censoMonitorService
	// .update(censoMonitor);
	// logger.info("Entity correctly inserted!");
	// return censoMonitorAux;
	// } catch (Exception e) {
	// throw new MethodFailureException("Method failed");
	// }
	// }

	/**
	 * Method 'add'.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return CensoMonitor
	 */
	/*
	 * @RequestMapping(method = RequestMethod.POST) public @ResponseBody
	 * CensoMonitor add(@RequestBody CensoMonitor censoMonitor) { try {
	 * CensoMonitor censoMonitorAux = this.censoMonitorService
	 * .add(censoMonitor); logger.info("Entity correctly inserted!"); return
	 * censoMonitorAux; } catch (Exception e) { throw new
	 * MethodFailureException("Method failed"); } }
	 */

	/**
	 * Method 'add'.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return CensoMonitor
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody CensoMonitor addMonitor(@RequestBody CensoMonitor censoMonitor) {
		try {

			CensoMonitor censoMonitorAux = this.censoMonitorService.add(censoMonitor);
			logger.info("Entity correctly inserted!");
			return censoMonitorAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param mocodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return
	 */
	@RequestMapping(value = "/{mocodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String mocodigo, HttpServletResponse response, HttpServletRequest request) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			CensoMonitor censoMonitorConectado = (CensoMonitor) request.getSession()
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			String moCodigoConectado = censoMonitorConectado.getMocodigo();
			if (mocodigo.equals(moCodigoConectado)) {
				throw new Y41bUDAException("error.censomonitor.NoDeleteCensoMonitorConnected", true, new Exception());
			}

			CensoMonitor censoMonitor = new CensoMonitor();
			censoMonitor.setMocodigo(mocodigo);
			this.censoMonitorService.remove(censoMonitor);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			logger.error("Unable to delete " + mocodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param censoMonitorIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(@RequestBody ArrayList<ArrayList<String>> censoMonitorIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<CensoMonitor> censoMonitorList = new ArrayList<CensoMonitor>();
		try {
			for (ArrayList<String> censoMonitorId : censoMonitorIds) {
				Iterator<String> iterator = censoMonitorId.iterator();
				CensoMonitor censoMonitor = new CensoMonitor();
				censoMonitor.setMocodigo(ObjectConversionManager.convert(iterator.next(), String.class));
				censoMonitorList.add(censoMonitor);
			}
			this.censoMonitorService.removeMultiple(censoMonitorList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getCensoMonitorService'.
	 * 
	 * @return CensoMonitorService
	 */
	protected CensoMonitorService getCensoMonitorService() {
		return this.censoMonitorService;
	}

	/**
	 * Method 'setCensoMonitorService'.
	 * 
	 * @param censoMonitorService
	 *            CensoMonitorService
	 * @return
	 */
	public void setCensoMonitorService(CensoMonitorService censoMonitorService) {
		this.censoMonitorService = censoMonitorService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterInstructor
	 *            Instructor
	 * @return List
	 */
	@RequestMapping(value = "/comboInstructores", method = RequestMethod.GET)
	public @ResponseBody List<CensoMonitor> getAll(@ModelAttribute CensoMonitor filterCensoMonitor,
			HttpServletRequest httpRequest) {
		CensoMonitorController.logger.info("[GET - find_ALL] : Obtener CensoMonitor por filtro");
		try {

			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			if (!Y41bConstantes.PERFIL_SUPERVISOR.equals(censoMonitor.getPerfilSanciones().getIdPerfil())) {
				Organismo organismoNOSupervisor = censoMonitor.getOrganismo();
				Organismo organismoAux = new Organismo();
				organismoAux.setCodOrg(organismoNOSupervisor.getCodOrg());
				filterCensoMonitor.setOrganismo(organismoAux);
			}
			filterCensoMonitor.setPerfilSanciones(new Perfil(Y41bConstantes.PERFIL_INSTRUCTOR, "", ""));
			return this.censoMonitorService.findAll(filterCensoMonitor, null);
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("Error producido en getAll: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterInstructor
	 *            Instructor
	 * @return List
	 */
	@RequestMapping(value = "/comboInstructoresApertura", method = RequestMethod.GET)
	public @ResponseBody List<CensoMonitor> comboInstructoresApertura(@ModelAttribute CensoMonitor filterCensoMonitor,
			HttpServletRequest httpRequest) {
		CensoMonitorController.logger.info("[GET - find_ALL] : Obtener CensoMonitor por filtro");
		try {

			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			/*
			 * SI ES INSTRUCTOR, SOLO APARECE ÉL MISMO SI ES SUPEVISOR, SALEN
			 * TODOS LOS INSTRUCTORES .SI ES COORDINADOR, SOLO SALEN LOS DE LA
			 * OFICINA
			 */
			if (Y41bConstantes.PERFIL_COORDINADOR.equals(censoMonitor.getPerfilSanciones().getIdPerfil())) {
				/* SI ES COORDINADOR, TODOS LOS INSTRUCTORES DE SU OFICINA */
				Organismo organismoNOSupervisor = censoMonitor.getOrganismo();
				Organismo organismoAux = new Organismo();
				organismoAux.setCodOrg(organismoNOSupervisor.getCodOrg());
				filterCensoMonitor.setOrganismo(organismoAux);
				filterCensoMonitor.setPerfilSanciones(new Perfil(Y41bConstantes.PERFIL_INSTRUCTOR, "", ""));
				filterCensoMonitor
						.setMofecbajaDesde(Y41bUtils.formatearDateToString(Y41bUtils.obtenerFechaHoy(), "yyyyMMdd"));
			} else if (Y41bConstantes.PERFIL_INSTRUCTOR.equals(censoMonitor.getPerfilSanciones().getIdPerfil())) {
				/* SI ES INSTRUCTOR, EL MISMO SOLO */
				filterCensoMonitor.setMocodigo(censoMonitor.getMocodigo());
				filterCensoMonitor.setPerfilSanciones(new Perfil(Y41bConstantes.PERFIL_INSTRUCTOR, "", ""));
			} else if (Y41bConstantes.PERFIL_SUPERVISOR.equals(censoMonitor.getPerfilSanciones().getIdPerfil())) {
				/*
				 * SI ES SUPERVISOR, TODOS LOS INSTRUCTORES DE TODAS LAS
				 * OFICINAS
				 */
				filterCensoMonitor.setPerfilSanciones(new Perfil(Y41bConstantes.PERFIL_INSTRUCTOR, "", ""));
				filterCensoMonitor
						.setMofecbajaDesde(Y41bUtils.formatearDateToString(Y41bUtils.obtenerFechaHoy(), "yyyyMMdd"));
			} else {
				/* PARA EL RESTO, QUE NO DEBERIA HABER, COMBO VACIO */
				return null;
			}

			return this.censoMonitorService.findAll(filterCensoMonitor, null);
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("Error producido en getAll: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterInstructor
	 *            Instructor
	 * @return List
	 */
	@RequestMapping(value = "/comboInstructoresBusquedaSanciones", method = RequestMethod.GET)
	public @ResponseBody List<CensoMonitor> getComboBusqueda(@ModelAttribute CensoMonitor filterCensoMonitor,
			@RequestParam(value = "perfil", required = false) String perfil, HttpServletRequest httpRequest) {
		CensoMonitorController.logger.info("[GET - find_ALL] : Obtener CensoMonitor por filtro");
		try {
			if (Y41bConstantes.VALOR_SI.equals(perfil)) {
				filterCensoMonitor.setPerfilSanciones(new Perfil(Y41bConstantes.PERFIL_INSTRUCTOR, "", ""));
			}
			return this.censoMonitorService.findAllCensoMonitorSanciones(filterCensoMonitor);
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("Error producido en getAll: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllFilterAltasBusquedaSolicitudes'.
	 * 
	 * @param organismoCodOrg
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/filterAltasBusquedaSolicitudes", method = RequestMethod.GET)
	public @ResponseBody Object getAllFilterAltasBusquedaSolicitudes(
			@RequestParam(value = "organismoCodOrg", required = false) String organismoCodOrg,
			HttpServletRequest request) {
		try {
			CensoMonitor filterCensoMonitor = new CensoMonitor(null, null, null, null, null, null, null,
					new Organismo(organismoCodOrg), null, null, null, null, null, null, null, null, null, null, null,
					null, null, null);

			List<CensoMonitor> censoMonitors = this.censoMonitorService
					.findAllCensoMonitorAltaBusquedaSolicitudes(filterCensoMonitor);
			if (censoMonitors == null) {
				throw new Exception("No data Found.");
			}
			return censoMonitors;

		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	// EVOLUTIVO 0135083 2.10
	/**
	 * Method 'getAllFilterAltasBusquedaSanciones'.
	 * 
	 * @param organismoCodOrg
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/filterAltasBusquedaSanciones", method = RequestMethod.GET)
	public @ResponseBody Object getAllFilterAltasBusquedaSanciones(
			@RequestParam(value = "organismoCodOrg", required = false) String organismoCodOrg,
			HttpServletRequest request) {
		try {
			// 0176609: Refactoring Bandejas 2021. Que solo salgan responsables
			// de expediente de sanciones en el combo
			CensoMonitor filterCensoMonitor = new CensoMonitor(null, null, null, null, null, null, null,
					new Organismo(organismoCodOrg), null, new Perfil(Y41bConstantes.PERFIL_INSTRUCTOR, null, null),
					null, null, null, null, null, null, null, null, null, null, null, null);

			List<CensoMonitor> censoMonitors = this.censoMonitorService
					.findAllCensoMonitorAltaBusquedaSanciones(filterCensoMonitor);
			if (censoMonitors == null) {
				throw new Exception("No data Found.");
			}
			return censoMonitors;

		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	// EVOLUTIVO 0135083 2.10
	/**
	 * Method 'getAllFilterAltasBusquedaInspecciones'.
	 * 
	 * @param organismoCodOrg
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/filterAltasBusquedaInspecciones", method = RequestMethod.GET)
	public @ResponseBody Object getAllFilterAltasBusquedaInspecciones(
			@RequestParam(value = "organismoCodOrg", required = false) String organismoCodOrg,
			HttpServletRequest request) {
		try {
			CensoMonitor filterCensoMonitor = new CensoMonitor(null, null, null, null, null, null, null,
					new Organismo(organismoCodOrg), null, null, null, null, null, null, null, null, null, null, null,
					null, null, null);

			List<CensoMonitor> censoMonitors = this.censoMonitorService
					.findAllCensoMonitorAltaBusquedaInspecciones(filterCensoMonitor);
			if (censoMonitors == null) {
				throw new Exception("No data Found.");
			}
			return censoMonitors;

		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllFilterAltasBusquedaConsultas'.
	 * 
	 * @param organismoCodOrg
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/filterAltasBusquedaConsultas", method = RequestMethod.GET)
	public @ResponseBody Object getAllFilterAltasBusquedaConsultas(
			@RequestParam(value = "organismoCodOrg", required = false) String organismoCodOrg,
			HttpServletRequest request) {
		try {
			CensoMonitor filterCensoMonitor = new CensoMonitor(null, null, null, null, null, null, null,
					new Organismo(organismoCodOrg), null, null, null, null, null, null, null, null, null, null, null,
					null, null, null);

			List<CensoMonitor> censoMonitors = this.censoMonitorService
					.findAllCensoMonitorAltaBusquedaConsultas(filterCensoMonitor);
			if (censoMonitors == null) {
				throw new Exception("No data Found.");
			}
			return censoMonitors;

		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllFilterAltasBusquedaConsultasEmpresas'.
	 * 
	 * @param organismoCodOrg
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/filterAltasBusquedaConsultasEmpresas", method = RequestMethod.GET)
	public @ResponseBody Object getAllFilterAltasBusquedaConsultasEmpresas(
			@RequestParam(value = "organismoCodOrg", required = false) String organismoCodOrg,
			HttpServletRequest request) {
		try {
			CensoMonitor filterCensoMonitor = new CensoMonitor(null, null, null, null, null, null, null,
					new Organismo(organismoCodOrg), null, null, null, null, null, null, null, null, null, null, null,
					null, null, null);

			List<CensoMonitor> censoMonitors = this.censoMonitorService
					.findAllCensoMonitorAltaBusquedaConsultasEmpresas(filterCensoMonitor);
			if (censoMonitors == null) {
				throw new Exception("No data Found.");
			}
			return censoMonitors;

		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterInstructor
	 *            Instructor
	 * @return List
	 */
	@RequestMapping(value = "/comboAsignacionResponsablesARB", method = RequestMethod.GET)
	public @ResponseBody List<CensoMonitor> comboAsignacionResponsablesARB(@RequestParam String mocodigo,
			HttpServletRequest httpRequest) {
		CensoMonitorController.logger.info("[GET - find_ALL] : Obtener CensoMonitor por filtro");
		try {
			CensoMonitor filterCensoMonitor = new CensoMonitor();
			if (!Y41bUtils.esNullOCadenaVacia(mocodigo)) {
				// Si viene un codigo sacamos ese usuario
				filterCensoMonitor.setMocodigo(mocodigo);
			} else {
				filterCensoMonitor.setPerfilArbitraje(new Perfil(Y41bConstantes.PERFIL_INSTRUCTOR, "", ""));
				filterCensoMonitor
						.setMofecbajaDesde(Y41bUtils.formatearDateToString(Y41bUtils.obtenerFechaHoy(), "yyyyMMdd"));
			}

			// return this.censoMonitorService.findAll(filterCensoMonitor,
			// null);
			return this.censoMonitorService.findAllCensoMonitorArbitrajes(filterCensoMonitor, true);
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("Error producido en getAll: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterInstructor
	 *            Instructor
	 * @return List
	 */
	@RequestMapping(value = "/comboInstructoresBusquedaArbitrajes", method = RequestMethod.GET)
	public @ResponseBody List<CensoMonitor> getComboBusquedaArbitrajes(@ModelAttribute CensoMonitor filterCensoMonitor,
			@RequestParam(value = "perfil", required = false) String perfil, HttpServletRequest httpRequest) {
		CensoMonitorController.logger.info("[GET - find_ALL] : Obtener CensoMonitor por filtro");
		try {
			return this.censoMonitorService.findAllCensoMonitorArbitrajes(filterCensoMonitor,
					Y41bConstantes.VALOR_SI.equals(perfil));
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("Error producido en getAll: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}
}
