package com.ejie.y41b.control;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.model.Aacc;
import com.ejie.y41b.model.Ccta1;
import com.ejie.y41b.service.Ccta1Service;

/**
 * Ccta1Controller  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/ccta1")
public class Ccta1Controller {

	private static final Logger logger = LoggerFactory
			.getLogger(Ccta1Controller.class);

	@Autowired()
	private Ccta1Service ccta1Service;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		Ccta1Controller.logger.info("[GET - View] : ccta1");
		return "ccta1";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param aaccCccodigo
	 *            String
	 * @param m7cota1
	 *            String
	 * @param m7fecalta
	 *            Date
	 * @param m7usualta
	 *            String
	 * @return ccta1 Ccta1
	 */
	@RequestMapping(value = "/{aaccCccodigo}/{m7cota1}/{m7fecalta}/{m7usualta}", method = RequestMethod.GET)
	public @ResponseBody()
	Ccta1 getById(@PathVariable() String aaccCccodigo,
			@PathVariable() String m7cota1, @PathVariable() Date m7fecalta,
			@PathVariable() String m7usualta) {
		Ccta1 ccta1 = new Ccta1();
		ccta1.setAacc(new Aacc());
		ccta1.getAacc().setCccodigo(aaccCccodigo);
		ccta1.setM7cota1(m7cota1);
		ccta1.setM7fecalta(m7fecalta);
		ccta1.setM7usualta(m7usualta);
		ccta1 = this.ccta1Service.find(ccta1);
		Ccta1Controller.logger.info("[GET - findBy_PK] : Obtener Ccta1 por PK");
		return ccta1;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterCcta1
	 *            Ccta1
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Ccta1> getAll(@ModelAttribute() Ccta1 filterCcta1) {
		Ccta1Controller.logger
				.info("[GET - find_ALL] : Obtener Ccta1 por filtro");
		return this.ccta1Service.findAll(filterCcta1, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param ccta1
	 *            Ccta1
	 * @return Ccta1
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Ccta1 edit(@RequestBody() Ccta1 ccta1) {
		Ccta1 ccta1Aux = this.ccta1Service.update(ccta1);
		Ccta1Controller.logger.info("[PUT] : Ccta1 actualizado correctamente");
		return ccta1Aux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param ccta1
	 *            Ccta1
	 * @return Ccta1
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Ccta1 add(@RequestBody() Ccta1 ccta1) {
		Ccta1 ccta1Aux = this.ccta1Service.add(ccta1);
		Ccta1Controller.logger.info("[POST] : Ccta1 insertado correctamente");
		return ccta1Aux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param aaccCccodigo
	 *            String
	 * @param m7cota1
	 *            String
	 * @param m7fecalta
	 *            Date
	 * @param m7usualta
	 *            String
	 * @return ccta1
	 */
	@RequestMapping(value = "/{aaccCccodigo}/{m7cota1}/{m7fecalta}/{m7usualta}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Ccta1 remove(@PathVariable() String aaccCccodigo,
			@PathVariable() String m7cota1, @PathVariable() Date m7fecalta,
			@PathVariable() String m7usualta) {
		Ccta1 ccta1 = new Ccta1();
		ccta1.setAacc(new Aacc());
		ccta1.getAacc().setCccodigo(aaccCccodigo);
		ccta1.setM7cota1(m7cota1);
		ccta1.setM7fecalta(m7fecalta);
		ccta1.setM7usualta(m7usualta);
		this.ccta1Service.remove(ccta1);
		Ccta1Controller.logger.info("[DELETE] : Ccta1 borrado correctamente");
		return ccta1;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param ccta1Ids
	 *            List
	 * @return ccta1List
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(@RequestBody() List<List<String>> ccta1Ids) {
		List<Ccta1> ccta1List = new ArrayList<Ccta1>();
		for (List<String> ccta1Id : ccta1Ids) {
			Iterator<String> iterator = ccta1Id.iterator();
			Ccta1 ccta1 = new Ccta1(); // NOPMD - Objeto nuevo en la lista
										// (parametro del servicio)
			ccta1.setAacc(new Aacc()); // NOPMD - Objeto nuevo en la lista
										// (parametro del servicio)
			ccta1.getAacc().setCccodigo(
					ObjectConversionManager.convert(iterator.next(),
							String.class));
			ccta1.setM7cota1(ObjectConversionManager.convert(iterator.next(),
					String.class));
			ccta1.setM7fecalta(ObjectConversionManager.convert(iterator.next(),
					java.util.Date.class));
			ccta1.setM7usualta(ObjectConversionManager.convert(iterator.next(),
					String.class));
			ccta1List.add(ccta1);
		}
		this.ccta1Service.removeMultiple(ccta1List);
		Ccta1Controller.logger
				.info("[POST - DELETE_ALL] : Ccta1 borrados correctamente");
		return ccta1Ids;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterCcta1
	 *            Ccta1
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(@ModelAttribute() Ccta1 filterCcta1,
			@ModelAttribute() Pagination pagination) {
		List<Ccta1> ccta1s = this.ccta1Service.findAll(filterCcta1, pagination);
		Long recordNum = this.ccta1Service.findAllCount(filterCcta1);
		Ccta1Controller.logger.info("[GET - jqGrid] : Obtener Ccta1");
		return new JQGridJSONModel(pagination, recordNum, ccta1s);
	}

	/**
	 * Method 'getChecks'.
	 * 
	 * @param cccodigo
	 *            String
	 * @return List
	 */
	@RequestMapping(value = "/checks/{cccodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	List<Ccta1> getChecks(@PathVariable() String cccodigo) {
		Ccta1Controller.logger
				.info("[GET - find_ALL] : Obtener Oeta1 por filtro");
		Ccta1 filterCcta1 = new Ccta1();
		Aacc aacc = new Aacc();
		aacc.setCccodigo(cccodigo);
		filterCcta1.setAacc(aacc);
		return this.ccta1Service.findAll(filterCcta1, null);
	}
}
