package com.ejie.y41b.control;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.model.Aacc;
import com.ejie.y41b.model.Arbitro;
import com.ejie.y41b.model.Ccar;
import com.ejie.y41b.service.CcarService;

/**
 * CcarController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/ccar")
public class CcarController {

	private static final Logger logger = LoggerFactory
			.getLogger(CcarController.class);

	@Autowired()
	private CcarService ccarService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		CcarController.logger.info("[GET - View] : ccar");
		return "ccar";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param aaccCccodigo
	 *            String
	 * @param arbitroArcodigo
	 *            String
	 * @param m1centroar
	 *            String
	 * @param m1fecalta
	 *            Date
	 * @param m1usualta
	 *            String
	 * @return ccar Ccar
	 */
	@RequestMapping(value = "/{aaccCccodigo}/{arbitroArcodigo}/{m1centroar}/{m1fecalta}/{m1usualta}", method = RequestMethod.GET)
	public @ResponseBody()
	Ccar getById(@PathVariable() String aaccCccodigo,
			@PathVariable() String arbitroArcodigo,
			@PathVariable() String m1centroar, @PathVariable() Date m1fecalta,
			@PathVariable() String m1usualta) {
		Ccar ccar = new Ccar();
		ccar.setAacc(new Aacc());
		ccar.setArbitro(new Arbitro());
		ccar.getAacc().setCccodigo(aaccCccodigo);
		ccar.getArbitro().setArcodigo(arbitroArcodigo);
		ccar.setM1centroar(m1centroar);
		ccar.setM1fecalta(m1fecalta);
		ccar.setM1usualta(m1usualta);
		ccar = this.ccarService.find(ccar);
		CcarController.logger.info("[GET - findBy_PK] : Obtener Ccar por PK");
		return ccar;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterCcar
	 *            Ccar
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Ccar> getAll(@ModelAttribute() Ccar filterCcar) {
		CcarController.logger
				.info("[GET - find_ALL] : Obtener Ccar por filtro");
		return this.ccarService.findAll(filterCcar, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param ccar
	 *            Ccar
	 * @return Ccar
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Ccar edit(@RequestBody() Ccar ccar) {
		Ccar ccarAux = this.ccarService.update(ccar);
		CcarController.logger.info("[PUT] : Ccar actualizado correctamente");
		return ccarAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param ccar
	 *            Ccar
	 * @return Ccar
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Ccar add(@RequestBody() Ccar ccar) {
		Ccar ccarAux = this.ccarService.add(ccar);
		CcarController.logger.info("[POST] : Ccar insertado correctamente");
		return ccarAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param aaccCccodigo
	 *            String
	 * @param arbitroArcodigo
	 *            String
	 * @return ccar
	 */
	@RequestMapping(value = "/{aaccCccodigo}/{arbitroArcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Ccar remove(@PathVariable() String aaccCccodigo,
			@PathVariable() String arbitroArcodigo) {
		Ccar ccar = new Ccar();
		ccar.setAacc(new Aacc());
		ccar.setArbitro(new Arbitro());
		ccar.getAacc().setCccodigo(aaccCccodigo);
		ccar.getArbitro().setArcodigo(arbitroArcodigo);
		this.ccarService.remove(ccar);
		CcarController.logger.info("[DELETE] : Ccar borrado correctamente");
		return ccar;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param ccarIds
	 *            List
	 * @return ccarList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(@RequestBody() List<List<String>> ccarIds) {
		List<Ccar> ccarList = new ArrayList<Ccar>();
		for (List<String> ccarId : ccarIds) {
			Iterator<String> iterator = ccarId.iterator();
			Ccar ccar = new Ccar(); // NOPMD - Objeto nuevo en la lista
									// (parametro del servicio)
			ccar.setAacc(new Aacc()); // NOPMD - Objeto nuevo en la lista
										// (parametro del servicio)
			ccar.setArbitro(new Arbitro()); // NOPMD - Objeto nuevo en la lista
											// (parametro del servicio)
			ccar.getAacc().setCccodigo(
					ObjectConversionManager.convert(iterator.next(),
							String.class));
			ccar.getArbitro().setArcodigo(
					ObjectConversionManager.convert(iterator.next(),
							String.class));
			ccar.setM1centroar(ObjectConversionManager.convert(iterator.next(),
					String.class));
			ccar.setM1fecalta(ObjectConversionManager.convert(iterator.next(),
					java.util.Date.class));
			ccar.setM1usualta(ObjectConversionManager.convert(iterator.next(),
					String.class));
			ccarList.add(ccar);
		}
		this.ccarService.removeMultiple(ccarList);
		CcarController.logger
				.info("[POST - DELETE_ALL] : Ccar borrados correctamente");
		return ccarIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterCcar
	 *            Ccar
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(@ModelAttribute() Ccar filterCcar,
			@ModelAttribute() Pagination pagination) {
		List<Ccar> ccars = this.ccarService.findAll(filterCcar, pagination);
		Long recordNum = this.ccarService.findAllCount(filterCcar);
		CcarController.logger.info("[GET - jqGrid] : Obtener Ccar");
		return new JQGridJSONModel(pagination, recordNum, ccars);
	}

}
