package com.ejie.y41b.control;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CargaTrabajo;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.service.CargaTrabajoService;
import com.ejie.y41b.service.Y41bExcelGeneratorService;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * CargaTrabajoController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/cargatrabajo")
public class CargaTrabajoController {

	private static final Logger logger = LoggerFactory.getLogger(CargaTrabajoController.class);

	@Autowired
	private CargaTrabajoService cargaTrabajoService;

	@Autowired
	private Y41bExcelGeneratorService y41bExcelGeneratorService;

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {
		CargaTrabajoController.logger.info("[GET - View] : OBTENER PANTALLA REMESAS");
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		model.addAttribute("organismo", censoMonitor.getOrganismo().getCodOrg());

		return new ModelAndView("cargatrabajo", "model", model);
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param mocoor
	 *            String
	 * @param pagination
	 *            Pagination
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody JQGridJSONModel getAllJQGrid(@RequestParam(value = "mocoor", required = false) String mocoor,
			@ModelAttribute Pagination pagination, HttpServletRequest request) {

		CargaTrabajoController.logger.info("[GET - find_ALL] : Obtener CargaTrabajo por filtro");
		List<CargaTrabajo> listCargaTrabajo = new ArrayList<CargaTrabajo>();

		try {
			CargaTrabajo filterCargaTrabajo = new CargaTrabajo();
			filterCargaTrabajo.setMocoor(mocoor);

			listCargaTrabajo = this.cargaTrabajoService.findAll(filterCargaTrabajo, pagination);
			Long recordNum = this.cargaTrabajoService.findAllCount(filterCargaTrabajo);
			CargaTrabajoController.logger.info("[GET - jqGrid] : Obtener CargaTrabajo");
			return new JQGridJSONModel(pagination, recordNum, listCargaTrabajo);
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCargaTrabajoExcel'.
	 * 
	 * @param mocoor
	 *            String
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excelCargaTrabajo", method = RequestMethod.GET)
	public @ResponseBody void getAllCargaTrabajoExcel(@RequestParam(value = "mocoor", required = false) String mocoor,
			HttpServletRequest request, HttpServletResponse response) {

		try {
			CargaTrabajo filterCargaTrabajo = new CargaTrabajo();
			filterCargaTrabajo.setMocoor(mocoor);

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy, "yyyyMMddHHmmss");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_CARGATRABAJO + fechaActual + ".xls";
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(nombre) + "\"");

			String xslString = this.y41bExcelGeneratorService.getCargaTrabajoExcel(filterCargaTrabajo);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();

		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

}