package com.ejie.y41b.control;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.CampanhaProgramacion;
import com.ejie.y41b.service.CampanhaProgramacionService;

/**
 * CampanhaProgramacionController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/campanhaprogramacion")
public class CampanhaProgramacionController {

	private static final Logger logger = LoggerFactory.getLogger(CampanhaProgramacionController.class);

	@Autowired
	private CampanhaProgramacionService campanhaProgramacionService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		CampanhaProgramacionController.logger.info("[GET - View] : campanhaprogramacion");
		return "campanhaprogramacion";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param pgcodigo
	 *            String
	 * @return campanhaProgramacion CampanhaProgramacion
	 */
	@RequestMapping(value = "/{pgcodigo}", method = RequestMethod.GET)
	public @ResponseBody CampanhaProgramacion getById(@PathVariable String pgcodigo) {
		CampanhaProgramacion campanhaProgramacion = new CampanhaProgramacion();
		campanhaProgramacion.setPgcodigo(pgcodigo);
		campanhaProgramacion = this.campanhaProgramacionService.find(campanhaProgramacion);
		CampanhaProgramacionController.logger.info("[GET - findBy_PK] : Obtener CampanhaProgramacion por PK");
		return campanhaProgramacion;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterCampanhaProgramacion
	 *            CampanhaProgramacion
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<CampanhaProgramacion> getAll(
			@ModelAttribute CampanhaProgramacion filterCampanhaProgramacion) {
		CampanhaProgramacionController.logger.info("[GET - find_ALL] : Obtener CampanhaProgramacion por filtro");
		return this.campanhaProgramacionService.findAll(filterCampanhaProgramacion, null);
	}

	/**
	 * Method 'getAllByCampanha'.
	 * 
	 * @param cmcodigo
	 *            String
	 * @return List
	 */
	@RequestMapping(value = "findAllByCampanha", method = RequestMethod.GET)
	public @ResponseBody List<CampanhaProgramacion> getAllByCampanha(
			@RequestParam(value = "codCampanha", required = false) String cmcodigo) {
		CampanhaProgramacionController.logger
				.info("[GET - find_ALL] : Obtener CampanhaProgramacion ByCampanha por filtro");

		CampanhaProgramacion filterCampanhaProgramacion = new CampanhaProgramacion();
		Campanha campanha = new Campanha();
		campanha.setCmcodigo(cmcodigo);
		filterCampanhaProgramacion.setCampanha(campanha);

		return this.campanhaProgramacionService.findAll(filterCampanhaProgramacion, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param campanhaProgramacion
	 *            CampanhaProgramacion
	 * @return CampanhaProgramacion
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody CampanhaProgramacion edit(@RequestBody CampanhaProgramacion campanhaProgramacion) {
		CampanhaProgramacion campanhaProgramacionAux = this.campanhaProgramacionService.update(campanhaProgramacion);
		CampanhaProgramacionController.logger.info("[PUT] : CampanhaProgramacion actualizado correctamente");
		return campanhaProgramacionAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param campanhaProgramacion
	 *            CampanhaProgramacion
	 * @return CampanhaProgramacion
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody CampanhaProgramacion add(@RequestBody CampanhaProgramacion campanhaProgramacion) {
		CampanhaProgramacion campanhaProgramacionAux = this.campanhaProgramacionService.add(campanhaProgramacion);
		CampanhaProgramacionController.logger.info("[POST] : CampanhaProgramacion insertado correctamente");
		return campanhaProgramacionAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param pgcodigo
	 *            String
	 * @return campanhaProgramacion
	 */
	@RequestMapping(value = "/{pgcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody CampanhaProgramacion remove(@PathVariable String pgcodigo) {
		CampanhaProgramacion campanhaProgramacion = new CampanhaProgramacion();
		campanhaProgramacion.setPgcodigo(pgcodigo);
		this.campanhaProgramacionService.remove(campanhaProgramacion);
		CampanhaProgramacionController.logger.info("[DELETE] : CampanhaProgramacion borrado correctamente");
		return campanhaProgramacion;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param campanhaProgramacionIds
	 *            List
	 * @return campanhaProgramacionList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> campanhaProgramacionIds) {
		List<CampanhaProgramacion> campanhaProgramacionList = new ArrayList<CampanhaProgramacion>();
		for (List<String> campanhaProgramacionId : campanhaProgramacionIds) {
			Iterator<String> iterator = campanhaProgramacionId.iterator();
			CampanhaProgramacion campanhaProgramacion = new CampanhaProgramacion(); // NOPMD
																					// -
																					// Objeto
																					// nuevo
																					// en
																					// la
																					// lista
																					// (parametro
																					// del
																					// servicio)
			campanhaProgramacion.setPgcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
			campanhaProgramacionList.add(campanhaProgramacion);
		}
		this.campanhaProgramacionService.removeMultiple(campanhaProgramacionList);
		CampanhaProgramacionController.logger.info("[POST - DELETE_ALL] : CampanhaProgramacion borrados correctamente");
		return campanhaProgramacionIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterCampanhaProgramacion
	 *            CampanhaProgramacion
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute CampanhaProgramacion filterCampanhaProgramacion,
			@ModelAttribute Pagination pagination) {
		List<CampanhaProgramacion> campanhaProgramacions = this.campanhaProgramacionService
				.findAll(filterCampanhaProgramacion, pagination);
		Long recordNum = this.campanhaProgramacionService.findAllCount(filterCampanhaProgramacion);
		CampanhaProgramacionController.logger.info("[GET - jqGrid] : Obtener CampanhaProgramacion");
		return new JQGridJSONModel(pagination, recordNum, campanhaProgramacions);
	}

	/**
	 * Method 'getProgramaciones'.
	 * 
	 * @param cmcodigo
	 *            identificador de la campaa
	 * @return List<CampanhaProgramacion>
	 */
	@RequestMapping(value = "/programaciones", method = RequestMethod.GET)
	public @ResponseBody() List<CampanhaProgramacion> getProgramaciones(
			@RequestParam(value = "cmcodigo", required = false) String cmcodigo) {

		if (cmcodigo != null && !cmcodigo.equals("")) {
			CampanhaProgramacion filterCampanhaProgramacion = new CampanhaProgramacion();
			Campanha campanha = new Campanha();
			campanha.setCmcodigo(cmcodigo);
			filterCampanhaProgramacion.setCampanha(campanha);
			return this.campanhaProgramacionService.findAll(filterCampanhaProgramacion, null);
		} else {
			return (List<CampanhaProgramacion>) new ArrayList<CampanhaProgramacion>();
		}
	}
}
