package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.CampanhaProdService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.CampanhaProd;

/**
 * CampanhaProdController  
 *  
 */
 
@Controller
@RequestMapping (value = "/campanhaprod")

public class CampanhaProdController  {

	private static final Logger logger = LoggerFactory.getLogger(CampanhaProdController.class);

	@Autowired
	private CampanhaProdService campanhaProdService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		CampanhaProdController.logger.info("[GET - View] : campanhaprod");
		return "campanhaprod";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param cpcodigo String
	 * @return campanhaProd CampanhaProd
	 */
	@RequestMapping(value = "/{cpcodigo}", method = RequestMethod.GET)
	public @ResponseBody CampanhaProd getById(@PathVariable String cpcodigo) {
        CampanhaProd campanhaProd = new CampanhaProd();
		campanhaProd.setCpcodigo(cpcodigo);
        campanhaProd = this.campanhaProdService.find(campanhaProd);
        CampanhaProdController.logger.info("[GET - findBy_PK] : Obtener CampanhaProd por PK");
        return campanhaProd;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterCampanhaProd CampanhaProd
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<CampanhaProd> getAll(@ModelAttribute CampanhaProd filterCampanhaProd) {
		CampanhaProdController.logger.info("[GET - find_ALL] : Obtener CampanhaProd por filtro");
	    return this.campanhaProdService.findAll(filterCampanhaProd, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param campanhaProd CampanhaProd 
	 * @return CampanhaProd
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody CampanhaProd edit(@RequestBody CampanhaProd campanhaProd) {		
        CampanhaProd campanhaProdAux = this.campanhaProdService.update(campanhaProd);
		CampanhaProdController.logger.info("[PUT] : CampanhaProd actualizado correctamente");
        return campanhaProdAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param campanhaProd CampanhaProd 
	 * @return CampanhaProd
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody CampanhaProd add(@RequestBody CampanhaProd campanhaProd) {		
        CampanhaProd campanhaProdAux = this.campanhaProdService.add(campanhaProd);
        CampanhaProdController.logger.info("[POST] : CampanhaProd insertado correctamente");
    	return campanhaProdAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param cpcodigo String
	 * @return campanhaProd
	 */
	@RequestMapping(value = "/{cpcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody CampanhaProd remove(@PathVariable String cpcodigo) {
        CampanhaProd campanhaProd = new CampanhaProd();
        campanhaProd.setCpcodigo(cpcodigo);
        this.campanhaProdService.remove(campanhaProd);
       	CampanhaProdController.logger.info("[DELETE] : CampanhaProd borrado correctamente");
       	return campanhaProd;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param campanhaProdIds List
	 * @return campanhaProdList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> campanhaProdIds) {
        List<CampanhaProd> campanhaProdList = new ArrayList<CampanhaProd>();
        for (List<String> campanhaProdId:campanhaProdIds) {
		    Iterator<String> iterator = campanhaProdId.iterator();
		    CampanhaProd campanhaProd = new CampanhaProd(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        campanhaProd.setCpcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
		    campanhaProdList.add(campanhaProd);
	    }
        this.campanhaProdService.removeMultiple(campanhaProdList);
		CampanhaProdController.logger.info("[POST - DELETE_ALL] : CampanhaProd borrados correctamente");
		return campanhaProdIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterCampanhaProd CampanhaProd
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute CampanhaProd filterCampanhaProd, @ModelAttribute Pagination pagination) {
        List<CampanhaProd> campanhaProds = this.campanhaProdService.findAll(filterCampanhaProd, pagination);
        Long recordNum = this.campanhaProdService.findAllCount(filterCampanhaProd);
        CampanhaProdController.logger.info("[GET - jqGrid] : Obtener CampanhaProd");
		return new JQGridJSONModel(pagination, recordNum, campanhaProds);
	}
	
}	
