package com.ejie.y41b.control;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.rowset.serial.SerialBlob;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.AdjuntarCampanhaproducto;
import com.ejie.y41b.model.AdjuntarCampanhaprogra;
import com.ejie.y41b.model.AdjuntarCampanhatipoprot;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.CampanhaCierre;
import com.ejie.y41b.model.CampanhaComentarios;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.PlantillaControlMercadoDetalle;
import com.ejie.y41b.model.ProductosCampanhaActuacion;
import com.ejie.y41b.model.TipProtocolo;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.service.ActuacionService;
import com.ejie.y41b.service.AdjuntarCampanhaproductoService;
import com.ejie.y41b.service.AdjuntarCampanhaprograService;
import com.ejie.y41b.service.AdjuntarCampanhatipoprotService;
import com.ejie.y41b.service.AdjuntardocsService;
import com.ejie.y41b.service.CampanhaCierreService;
import com.ejie.y41b.service.CampanhaComentariosService;
import com.ejie.y41b.service.CampanhaService;
import com.ejie.y41b.service.DenunciaService;
import com.ejie.y41b.service.Y41bExcelGeneratorService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.documentos.Y41bDocumento;
import com.ejie.y41b.utils.documentos.Y41bGenerarDocumento;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * CampanhaController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/campanha")
@SessionAttributes({ "codCampanha", "modoBusquedaCampanha", "modoCampanha", "campanhaBusqueda" })
public class CampanhaController {

	private static final Logger logger = LoggerFactory.getLogger(CampanhaController.class);

	@Autowired
	private CampanhaService campanhaService;
	@Autowired
	private AdjuntarCampanhaproductoService adjuntarCampanhaproductoService;
	@Autowired
	private AdjuntarCampanhatipoprotService adjuntarCampanhatipoprotService;
	@Autowired
	private AdjuntardocsService adjuntardocsService;
	@Autowired
	private AdjuntarCampanhaprograService adjuntarCampanhaprograService;
	@Autowired
	private DenunciaService denunciaService;
	@Autowired
	private CampanhaComentariosService campanhaComentariosService;
	@Autowired
	private CampanhaCierreService campanhaCierreService;
	@Autowired
	private Properties appConfiguration;
	@Autowired
	private Y41bExcelGeneratorService y41bExcelGeneratorService;
	@Autowired
	private ActuacionService actuacionService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */
	/**
	 * Method 'getCreateFormMantenimiento'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "campanhas", method = RequestMethod.GET)
	public ModelAndView getCreateFormMantenimiento(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modoBusquedaCampanha", "");

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		Campanha campanha = new Campanha();
		model.addAttribute("campanhaBusqueda", campanha);

		if (censoMonitor.getPerfilOrganizacion() == null || censoMonitor.getPerfilOrganizacion().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("campanhas", "model", model);
		}
	}

	/**
	 * Metodo que evita que la llamada a 'campanhasBusquedaConPrecarga' devuelva
	 * una excepcion variable de sesion. Si no existe, entra aqui y la crea. Si
	 * ya existe, Spring ignora este metodo.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return Campanha
	 */
	@ModelAttribute(value = "campanhaBusqueda")
	public Campanha getCampanha(HttpServletRequest request) {
		return new Campanha();
	}

	/**
	 * Method 'getCreateFormMantenimiento'.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "campanhasBusquedaConPrecarga", method = RequestMethod.GET)
	public ModelAndView getCreateFormCampanhasBusquedaConPrecarga(Model model,
			@ModelAttribute(value = "campanhaBusqueda") Campanha campanha, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modoBusquedaCampanha", "");

		model.addAttribute("campanhaBusqueda", campanha);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilOrganizacion() == null || censoMonitor.getPerfilOrganizacion().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("campanhas", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "seleccionCampanha", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modoBusquedaCampanha", Y41bConstantes.MODO_POPUP_SELECCION);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilOrganizacion() == null || censoMonitor.getPerfilOrganizacion().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("seleccionCampanha", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormAltaCampanha'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "altaCampanha", method = RequestMethod.GET)
	public ModelAndView getCreateFormAltaCampanha(Model model, HttpServletRequest request) {
		model.addAttribute("vieneDe", Y41bConstantes.VIENE_DE_BANDEJAS);
		return this.getCreateFormAltaCampanhaBusqueda(model, request);
	}

	/**
	 * Method 'getCreateFormAltaCampanhaBusqueda'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "campanhasBusquedaConPrecarga/altaCampanha", method = RequestMethod.GET)
	public ModelAndView getCreateFormAltaCampanhaBusqueda(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("codCampanha", Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

		model.addAttribute("modoCampanha", Y41bConstantes.MODO_POPUP_ALTA);
		if (!model.containsAttribute("vieneDe")) {
			model.addAttribute("vieneDe", Y41bConstantes.VIENE_DE_BUSQUEDA);
		}

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilOrganizacion() == null || censoMonitor.getPerfilOrganizacion().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("campanhaDetalle", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormModCampanha'.
	 * 
	 * @param codCampanha_
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "campanhasBusquedaConPrecarga/modCampanha", method = RequestMethod.GET)
	public ModelAndView getCreateFormModCampanha(
			@RequestParam(value = "codCampanha", required = false) String codCampanha_,
			// @PathVariable String codCampanha,
			Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		String codCampanha = ("".equals(codCampanha_)) ? null : codCampanha_;

		if (codCampanha != null) {
			model.addAttribute("codCampanha", codCampanha);

			model.addAttribute("modoCampanha", Y41bConstantes.MODO_POPUP_MODIFICACION);
			if (!model.containsAttribute("vieneDe")) {
				model.addAttribute("vieneDe", Y41bConstantes.VIENE_DE_BUSQUEDA);
			}

			Campanha campanha = new Campanha();
			campanha.setCmcodigo(codCampanha);

			this.adjuntarCampanhaproductoService.addCampanhaproductoTableTemporal(campanha);
			this.adjuntarCampanhatipoprotService.addCampanhatipoprotTableTemporal(campanha);
			this.adjuntardocsService.addDocsTableTemporal(codCampanha);
			this.adjuntarCampanhaprograService.addCampanhaprograTableTemporal(campanha);
		}

		if (censoMonitor.getPerfilOrganizacion() == null || censoMonitor.getPerfilOrganizacion().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("campanhaDetalle", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormModCampanhaBandeja'.
	 * 
	 * @param codCampanha_
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "detalleCampanha", method = RequestMethod.GET)
	public ModelAndView getCreateFormModCampanhaBandeja(
			@RequestParam(value = "codCampanha", required = false) String codCampanha_, Model model,
			HttpServletRequest request) {
		model.addAttribute("vieneDe", Y41bConstantes.VIENE_DE_BANDEJAS);
		return this.getCreateFormModCampanha(codCampanha_, model, request);
	}

	/**
	 * Method 'getCreateFormMaintY41bCampanhaDetalleProductosServicios'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintY41bCampanhaDetalle_ProductosServicios", method = RequestMethod.GET)
	public ModelAndView getCreateFormMaintY41bCampanhaDetalleProductosServicios(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("campanhaDetalle_ProductosServicios", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormMaintY41bCampanhaDetalleProtocolos'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintY41bCampanhaDetalle_Protocolos", method = RequestMethod.GET)
	public ModelAndView getCreateFormMaintY41bCampanhaDetalleProtocolos(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("campanhaDetalle_Protocolos", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormMaintY41bCampanhaDetalleDocumentos'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintY41bCampanhaDetalle_Documentos", method = RequestMethod.GET)
	public ModelAndView getCreateFormMaintY41bCampanhaDetalleDocumentos(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("campanhaDetalle_Documentos", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormMaintY41bCampanhaDetalleProgramacion'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintY41bCampanhaDetalle_Programacion", method = RequestMethod.GET)
	public ModelAndView getCreateFormMaintY41bCampanhaDetalleProgramacion(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("campanhaDetalle_Programacion", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormMaintY41bCampanhaDetalleComentarios'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintY41bCampanhaDetalle_Comentarios", method = RequestMethod.GET)
	public ModelAndView getCreateFormMaintY41bCampanhaDetalleComentarios(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("campanhaDetalle_Comentarios", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormMaintY41bCampanhaDetalleCierre'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintY41bCampanhaDetalle_Cierre", method = RequestMethod.GET)
	public ModelAndView getCreateFormMaintY41bCampanhaDetalleCierre(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("campanhaDetalle_Cierre", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintY41bCampanhaDetalle_ProductosServiciosConsulta", method = RequestMethod.GET)
	public ModelAndView getConsultaProductosCampanha(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilOrganizacion() == null || censoMonitor.getPerfilOrganizacion().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("campanhaDetalle_ProductosServiciosConsulta", "model", model);
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param cmcodigo
	 *            String
	 * @return campanha Campanha
	 */
	@RequestMapping(value = "/{cmcodigo}", method = RequestMethod.GET)
	public @ResponseBody Campanha getById(@PathVariable String cmcodigo) {
		Campanha campanha = new Campanha();
		campanha.setCmcodigo(cmcodigo);
		campanha = this.campanhaService.find(campanha);
		CampanhaController.logger.info("[GET - findBy_PK] : Obtener Campanha por PK");
		return campanha;
	}

	/**
	 * Method 'getCampanhaById'.
	 * 
	 * @param cmcodigo_
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "findCampanha", method = RequestMethod.GET)
	public @ResponseBody Campanha getCampanhaById(
			@RequestParam(value = "cmcodigo", required = false) String cmcodigo_) {
		try {

			String cmcodigo = ("".equals(cmcodigo_)) ? null : cmcodigo_;
			Campanha campanha = new Campanha();
			campanha.setCmcodigo(cmcodigo);
			campanha = this.campanhaService.find(campanha);
			if (campanha == null) {
				throw new Exception(cmcodigo.toString());
			}
			return campanha;
		} catch (Exception e) {
			throw new ResourceNotFoundException(cmcodigo_.toString());
		}
	}

	/**
	 * Method 'getComentarioCampanhaById'.
	 * 
	 * @param cmcodigo_
	 *            String
	 * @return String
	 */

	@RequestMapping(value = "findComentarioCampanha", method = RequestMethod.GET)
	public @ResponseBody CampanhaComentarios getComentarioCampanhaById(
			@RequestParam(value = "cmcodigo", required = false) String cmcodigo_) {
		try {
			String cmcodigo = ("".equals(cmcodigo_)) ? null : cmcodigo_;
			CampanhaComentarios campanhacomentarios = new CampanhaComentarios();
			campanhacomentarios.setTxcmcodigo(cmcodigo);
			campanhacomentarios = this.campanhaComentariosService.find(campanhacomentarios);
			if (campanhacomentarios == null) {
				throw new Exception(cmcodigo.toString());
			}
			return campanhacomentarios;
		} catch (Exception e) {
			throw new ResourceNotFoundException(cmcodigo_.toString());
		}
	}

	/**
	 * Method 'getCierreCampanhaById'.
	 * 
	 * @param cmcodigo_
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "findCierreCampanha", method = RequestMethod.GET)
	public @ResponseBody CampanhaCierre getCierreCampanhaById(
			@RequestParam(value = "cmcodigo", required = false) String cmcodigo_) {
		try {
			String cmcodigo = ("".equals(cmcodigo_)) ? null : cmcodigo_;
			CampanhaCierre campanhaCierre = new CampanhaCierre();
			campanhaCierre.setTycmcodigo(cmcodigo);
			campanhaCierre = this.campanhaCierreService.find(campanhaCierre);
			if (campanhaCierre == null) {
				throw new Exception(cmcodigo.toString());
			}
			return campanhaCierre;
		} catch (Exception e) {
			throw new ResourceNotFoundException(cmcodigo_.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterCampanha
	 *            Campanha
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Campanha> getAll(@ModelAttribute Campanha filterCampanha) {
		CampanhaController.logger.info("[GET - find_ALL] : Obtener Campanha por filtro");
		return this.campanhaService.findAll(filterCampanha, null);
	}

	/**
	 * Method 'getAllCampanha'.
	 * 
	 * @param cmcodigo_
	 *            String
	 * @param cmnombre_
	 *            String
	 * @param cmorigen_
	 *            String
	 * @param cmcops_
	 *            String
	 * @param cmcopsdesc_
	 *            String
	 * @param cmtipo_
	 *            String
	 * @param cmfase_
	 *            String
	 * @param cmincluircerradas_
	 *            String
	 * @param cmincluirnoactivas_
	 *            String
	 * @param cmfechainicioDesde_
	 *            String
	 * @param cmfechainicioHasta_
	 *            String
	 * @param cmfechacierreDesde_
	 *            String
	 * @param cmfechacierreHasta_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/like", method = RequestMethod.GET)
	public @ResponseBody Object getAllCampanha(@RequestParam(value = "cmcodigo", required = false) String cmcodigo_,
			@RequestParam(value = "cmnombre", required = false) String cmnombre_,
			@RequestParam(value = "cmorigen", required = false) String cmorigen_,
			@RequestParam(value = "cmcops", required = false) String cmcops_,
			@RequestParam(value = "cmcopsdesc", required = false) String cmcopsdesc_,
			@RequestParam(value = "cmtipo", required = false) String cmtipo_,
			@RequestParam(value = "cmfase", required = false) String cmfase_,
			@RequestParam(value = "cmincluircerradas", required = false) String cmincluircerradas_,
			@RequestParam(value = "cmincluirnoactivas", required = false) String cmincluirnoactivas_,
			@RequestParam(value = "cmfechainicioDesde", required = false) String cmfechainicioDesde_,
			@RequestParam(value = "cmfechainicioHasta", required = false) String cmfechainicioHasta_,
			@RequestParam(value = "cmfechacierreDesde", required = false) String cmfechacierreDesde_,
			@RequestParam(value = "cmfechacierreHasta", required = false) String cmfechacierreHasta_,
			HttpServletRequest request, Model model) {
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date cmfechainicioDesde = Y41bUtils.parseDate(cmfechainicioDesde_, locale);
			Date cmfechainicioHasta = Y41bUtils.parseDate(cmfechainicioHasta_, locale);

			Date cmfechacierreDesde = Y41bUtils.parseDate(cmfechacierreDesde_, locale);
			Date cmfechacierreHasta = Y41bUtils.parseDate(cmfechacierreHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro
			String cmcodigo = ("".equals(cmcodigo_)) ? null : cmcodigo_;
			String cmnombre = ("".equals(cmnombre_)) ? null : cmnombre_;
			String cmorigen = ("".equals(cmorigen_)) ? null : cmorigen_;
			String cmtipo = ("".equals(cmtipo_)) ? null : cmtipo_;
			String cmfase = ("".equals(cmfase_)) ? null : cmfase_;
			String cmcops = ("".equals(cmcops_)) ? null : cmcops_;
			String cmcopsdesc = ("".equals(cmcopsdesc_)) ? null : cmcopsdesc_;

			// control checks
			String cmincluircerradas = ("on".equals(cmincluircerradas_)) ? Y41bConstantes.VALOR_SI : null;
			String cmincluirnoactivas = ("on".equals(cmincluirnoactivas_)) ? Y41bConstantes.VALOR_SI : null;

			Campanha filterCampanha = new Campanha();
			filterCampanha.setCmcodigo(cmcodigo);
			filterCampanha.setCmnombre(cmnombre);
			filterCampanha.setCmorigen(cmorigen);
			filterCampanha.setCmtipo(cmtipo);
			filterCampanha.setCmfase(cmfase);
			filterCampanha.setCmfechainicioDesde(cmfechainicioDesde);
			filterCampanha.setCmfechainicioHasta(cmfechainicioHasta);
			filterCampanha.setCmfechacierreDesde(cmfechacierreDesde);
			filterCampanha.setCmfechacierreHasta(cmfechacierreHasta);

			filterCampanha.setCmfechainicioDesdeStr(cmfechainicioDesde_);
			filterCampanha.setCmfechainicioHastaStr(cmfechainicioHasta_);
			filterCampanha.setCmfechacierreDesdeStr(cmfechacierreDesde_);
			filterCampanha.setCmfechacierreHastaStr(cmfechacierreHasta_);

			filterCampanha.setCmcops(cmcops);
			filterCampanha.setCmcopsdesc(cmcopsdesc);

			filterCampanha.setCmincluircerradas(cmincluircerradas);
			filterCampanha.setCmincluirnoactivas(cmincluirnoactivas);

			model.addAttribute("campanhaBusqueda", filterCampanha);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Campanha> campanhas = this.campanhaService.findAllLikeCampanha(filterCampanha, pagination, false);

				if (campanhas == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.campanhaService.findAllLikeCampanhaCount(filterCampanha, false);

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(campanhas);
				return data;
			} else {
				List<Campanha> campanhas = this.campanhaService.findAllLikeCampanha(filterCampanha, pagination, false);
				if (campanhas == null) {
					throw new Exception("No data Found.");
				}
				return campanhas;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return Campanha
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody Campanha edit(@RequestBody Campanha campanha) {
		Campanha campanhaAux = this.campanhaService.update(campanha);
		CampanhaController.logger.info("[PUT] : Campanha actualizado correctamente");
		return campanhaAux;
	}

	/**
	 * Method 'editCampanha'.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param response
	 *            HttpServletResponse
	 * @return Campanha
	 */
	@RequestMapping(value = "/updateCampanha", method = RequestMethod.PUT)
	public @ResponseBody Campanha editCampanha(@RequestBody Campanha campanha, HttpServletResponse response) {
		try {
			// Actualizamos la campanha.
			Campanha campanhaAux = this.campanhaService.updateCampanha(campanha);
			CampanhaController.logger.info("[PUT] : Campanha actualizado correctamente");
			return campanhaAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'editComentarioCampanha'.
	 * 
	 * @param campanhaComentarios
	 *            CampanhaComentarios
	 * @param response
	 *            HttpServletResponse
	 * @return CampanhaComentarios
	 */
	@RequestMapping(value = "/updateComentarioCampanha", method = RequestMethod.PUT)
	public @ResponseBody CampanhaComentarios editComentarioCampanha(
			@RequestBody CampanhaComentarios campanhaComentarios, HttpServletResponse response) {
		try {
			CampanhaComentarios campanhaComentariosAux = this.campanhaComentariosService.update(campanhaComentarios);
			CampanhaController.logger.info("[PUT] : Campanha actualizado correctamente");
			return campanhaComentariosAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'editCierreCampanha'.
	 * 
	 * @param campanhaCierre
	 *            CampanhaCierre
	 * @param response
	 *            HttpServletResponse
	 * @return CampanhaComentarios
	 */
	@RequestMapping(value = "/updateCierreCampanha", method = RequestMethod.PUT)
	public @ResponseBody CampanhaCierre editCierreCampanha(@RequestBody CampanhaCierre campanhaCierre,
			HttpServletResponse response) {
		try {
			CampanhaCierre campanhaCierreAux = this.campanhaCierreService.update(campanhaCierre);
			CampanhaController.logger.info("[PUT] : Campanha actualizado correctamente");
			return campanhaCierreAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return Campanha
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Campanha add(@RequestBody Campanha campanha) {
		Campanha campanhaAux = this.campanhaService.add(campanha);
		CampanhaController.logger.info("[POST] : Campanha insertado correctamente");
		return campanhaAux;
	}

	/**
	 * Method 'addCampanha'.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param codCampanhaAlta
	 *            String
	 * @return Campanha
	 */
	@RequestMapping(value = "/addCampanha", method = RequestMethod.POST)
	public @ResponseBody Campanha addCampanha(@RequestBody Campanha campanha,
			@ModelAttribute(value = "codCampanha") String codCampanhaAlta) {
		try {
			Campanha campanhaAux = this.campanhaService.addCampanha(campanha, codCampanhaAlta);
			logger.info("Entity correctly inserted!");
			return campanhaAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param cmcodigo
	 *            String
	 * @return campanha
	 */
	@RequestMapping(value = "/{cmcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody Campanha remove(@PathVariable String cmcodigo) {
		Campanha campanha = new Campanha();
		campanha.setCmcodigo(cmcodigo);
		this.campanhaService.remove(campanha);
		CampanhaController.logger.info("[DELETE] : Campanha borrado correctamente");
		return campanha;
	}

	/**
	 * Method 'removeCampanha'.
	 * 
	 * @param cmcodigo_
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "removeCampanha", method = RequestMethod.DELETE)
	public void removeCampanha(@RequestParam(value = "codCampanha", required = false) String cmcodigo_,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			String cmcodigo = ("".equals(cmcodigo_)) ? null : cmcodigo_;
			Campanha campanha = new Campanha();
			campanha.setCmcodigo(cmcodigo);
			this.campanhaService.removeCampanha(campanha);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			logger.error("Unable to delete " + cmcodigo_);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param campanhaIds
	 *            List
	 * @return campanhaList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> campanhaIds) {
		List<Campanha> campanhaList = new ArrayList<Campanha>();
		for (List<String> campanhaId : campanhaIds) {
			Iterator<String> iterator = campanhaId.iterator();
			Campanha campanha = new Campanha(); // NOPMD - Objeto nuevo en la
												// lista (parametro del
												// servicio)
			campanha.setCmcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
			campanhaList.add(campanha);
		}
		this.campanhaService.removeMultiple(campanhaList);
		CampanhaController.logger.info("[POST - DELETE_ALL] : Campanha borrados correctamente");
		return campanhaIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterCampanha
	 *            Campanha
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute Campanha filterCampanha,
			@ModelAttribute Pagination pagination) {
		List<Campanha> campanhas = this.campanhaService.findAll(filterCampanha, pagination);
		Long recordNum = this.campanhaService.findAllCount(filterCampanha);
		CampanhaController.logger.info("[GET - jqGrid] : Obtener Campanha");
		return new JQGridJSONModel(pagination, recordNum, campanhas);
	}

	/**
	 * Method 'unBind' CampanhaTipoprotocolo
	 * 
	 * @param cmcodigo
	 *            String
	 * @param tipProtocoloTpcodigo
	 *            String
	 * @return
	 */
	@RequestMapping(value = "/unbindCampanhaTipoprotocolo", method = RequestMethod.POST)
	public void unBindCampanhaTipoprotocolo(@RequestParam(value = "cmcodigo", required = false) String cmcodigo,
			@RequestParam(value = "tipProtocoloTpcodigo", required = false) String tipProtocoloTpcodigo) {
		Campanha campanha = new Campanha();
		TipProtocolo tipProtocolo = new TipProtocolo();
		if (cmcodigo != null) {
			campanha.setCmcodigo(cmcodigo);
		}
		if (tipProtocoloTpcodigo != null) {
			tipProtocolo.setTpcodigo(tipProtocoloTpcodigo);
		}
		campanha.getTipProtocolos_1().add(tipProtocolo);
		this.campanhaService.removeCampanhaTipoprotocolo(campanha);
	}

	/**
	 * Method 'bind' CampanhaTipoprotocolo
	 * 
	 * @param cmcodigo
	 *            String
	 * @param tipProtocoloTpcodigo
	 *            String
	 */
	@RequestMapping(value = "/bindCampanhaTipoprotocolo", method = RequestMethod.POST)
	public void bindCampanhaTipoprotocolo(@RequestParam(value = "cmcodigo", required = false) String cmcodigo,
			@RequestParam(value = "tipProtocoloTpcodigo", required = false) String tipProtocoloTpcodigo) {
		Campanha campanha = new Campanha();
		TipProtocolo tipProtocolo = new TipProtocolo();
		if (cmcodigo != null) {
			campanha.setCmcodigo(cmcodigo);
		}
		if (tipProtocoloTpcodigo != null) {
			tipProtocolo.setTpcodigo(tipProtocoloTpcodigo);
		}
		campanha.getTipProtocolos_1().add(tipProtocolo);
		this.campanhaService.addCampanhaTipoprotocolo(campanha);
	}

	/**
	 * Method 'getAllCampanhatipoprot'.
	 * 
	 * @param codCampanha
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllCampanhatipoprot", method = RequestMethod.GET)
	public @ResponseBody Object getAllCampanhatipoprot(@ModelAttribute(value = "codCampanha") String codCampanha,
			HttpServletRequest request) {
		try {
			AdjuntarCampanhatipoprot adjuntarCampanhatipoprot = new AdjuntarCampanhatipoprot();
			adjuntarCampanhatipoprot.setCmcodigo(codCampanha);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<TipProtocolo> listTipProtocolo = null;

				listTipProtocolo = this.adjuntarCampanhatipoprotService.findAllTipProtocolo(adjuntarCampanhatipoprot,
						pagination);

				if (listTipProtocolo == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.adjuntarCampanhatipoprotService.findAllTipProtocoloCount(adjuntarCampanhatipoprot);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listTipProtocolo);
				return data;
			} else {
				List<TipProtocolo> listTipProtocolo = null;

				listTipProtocolo = this.adjuntarCampanhatipoprotService.findAllTipProtocolo(adjuntarCampanhatipoprot,
						pagination);

				if (listTipProtocolo == null) {
					throw new Exception("No data Found.");
				}
				return listTipProtocolo;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addCampanhatipoprot'.
	 * 
	 * @param adjuntarCampanhatipoprot
	 *            AdjuntarCampanhatipoprot
	 * @param codCampanhaAlta
	 *            String
	 * @return AdjuntarCampanhatipoprot
	 */
	@RequestMapping(value = "/addCampanhatipoprot", method = RequestMethod.POST)
	public @ResponseBody AdjuntarCampanhatipoprot addCampanhatipoprot(
			@RequestBody AdjuntarCampanhatipoprot adjuntarCampanhatipoprot,
			@ModelAttribute(value = "codCampanha") String codCampanhaAlta) {
		try {
			AdjuntarCampanhatipoprot adjuntarCampanhatipoprotAux = this.adjuntarCampanhatipoprotService
					.addCampanhatipoprot(adjuntarCampanhatipoprot, codCampanhaAlta);
			logger.info("Entity correctly inserted!");
			return adjuntarCampanhatipoprotAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeCampanhatipoprot'.
	 * 
	 * @param tpcodigo_
	 *            String
	 * @param codCampanha
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarCampanhatipoprot", method = RequestMethod.DELETE)
	public void removeCampanhatipoprot(@RequestParam(value = "tpcodigo", required = false) String tpcodigo_,
			@ModelAttribute(value = "codCampanha") String codCampanha, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {

			String tpcodigo = ("".equals(tpcodigo_)) ? null : tpcodigo_;

			AdjuntarCampanhatipoprot adjuntarCampanhatipoprot = new AdjuntarCampanhatipoprot();
			adjuntarCampanhatipoprot.setTpcodigo(tpcodigo);
			adjuntarCampanhatipoprot.setCmcodigo(codCampanha);

			this.adjuntarCampanhatipoprotService.remove(adjuntarCampanhatipoprot);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllCampanhaproducto'.
	 * 
	 * @param codCampanha
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllCampanhaproducto", method = RequestMethod.GET)
	public @ResponseBody Object getAllCampanhaproducto(@ModelAttribute(value = "codCampanha") String codCampanha,
			HttpServletRequest request) {
		try {
			AdjuntarCampanhaproducto adjuntarCampanhaproducto = new AdjuntarCampanhaproducto();
			adjuntarCampanhaproducto.setCpcocm(codCampanha);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setAscDsc(request.getParameter("sord"));

				String orderBy = request.getParameter("sidx").replace("producto.", "");
				pagination.setSort(orderBy);

				List<AdjuntarCampanhaproducto> listAdjuntarCampanhaproducto = null;

				listAdjuntarCampanhaproducto = this.adjuntarCampanhaproductoService
						.findAllCampanhaproducto(adjuntarCampanhaproducto, pagination);

				if (listAdjuntarCampanhaproducto == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.adjuntarCampanhaproductoService
						.findAllCampanhaproductoCount(adjuntarCampanhaproducto);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAdjuntarCampanhaproducto);
				return data;
			} else {
				List<AdjuntarCampanhaproducto> listAdjuntarCampanhaproducto = null;

				listAdjuntarCampanhaproducto = this.adjuntarCampanhaproductoService
						.findAllCampanhaproducto(adjuntarCampanhaproducto, pagination);

				if (listAdjuntarCampanhaproducto == null) {
					throw new Exception("No data Found.");
				}
				return listAdjuntarCampanhaproducto;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addCampanhaproducto'.
	 * 
	 * @param adjuntarCampanhaproducto
	 *            AdjuntarCampanhaproducto
	 * @param codCampanhaAlta
	 *            String
	 * @return AdjuntarCampanhaproducto
	 */
	@RequestMapping(value = "/addCampanhaproducto", method = RequestMethod.POST)
	public @ResponseBody AdjuntarCampanhaproducto addCampanhaproducto(
			@RequestBody AdjuntarCampanhaproducto adjuntarCampanhaproducto,
			@ModelAttribute(value = "codCampanha") String codCampanhaAlta) {
		try {
			AdjuntarCampanhaproducto adjuntarCampanhaproductoAux = this.adjuntarCampanhaproductoService
					.addCampanhaproducto(adjuntarCampanhaproducto, codCampanhaAlta);
			logger.info("Entity correctly inserted!");
			return adjuntarCampanhaproductoAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeCampanhaproducto'.
	 * 
	 * @param cpcodigo
	 *            String
	 * @param codCampanha
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarCampanhaproducto/{cpcodigo}", method = RequestMethod.DELETE)
	public void removeCampanhaproducto(@PathVariable String cpcodigo,
			@ModelAttribute(value = "codCampanha") String codCampanha, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			AdjuntarCampanhaproducto adjuntarCampanhaproducto = new AdjuntarCampanhaproducto();
			adjuntarCampanhaproducto.setCpcodigo(cpcodigo);

			this.adjuntarCampanhaproductoService.remove(adjuntarCampanhaproducto);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllCampanhaDocs'.
	 * 
	 * @param codCampanha
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllCampanhaDocs", method = RequestMethod.GET)
	public @ResponseBody Object getAllCampanhaDocs(@ModelAttribute(value = "codCampanha") String codCampanha,
			HttpServletRequest request) {
		try {
			Adjuntardocs adjuntardocsFilter = new Adjuntardocs();
			adjuntardocsFilter.setThidExpediente(codCampanha);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAdjuntardocs);
				return data;
			} else {
				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}
				return listAdjuntardocs;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getByIdDocumentoCampanha'.
	 * 
	 * @param iddocumento
	 *            String
	 * @param codCampanhaAlta
	 *            String
	 * 
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findCampahnaDocumento/{iddocumento}", method = RequestMethod.GET)
	public @ResponseBody void getByIdDocumentoCampanha(@PathVariable String iddocumento,
			@ModelAttribute(value = "codCampanha") String codCampanhaAlta, HttpServletResponse response) {
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThcodocumento(iddocumento);
			adjuntardocsAux.setThidExpediente(codCampanhaAlta);

			adjuntardocsAux = this.adjuntardocsService.findAdjuntardocsByExpediente(adjuntardocsAux);

			Blob contenido = adjuntardocsAux.getThdatafile();
			byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(adjuntardocsAux.getThnofile()) + "\"");
			response.setContentType(adjuntardocsAux.getThcontenttypefile());
			response.setContentLength(adjuntardocsAux.getThsizefile());
			response.getOutputStream().write(bContenido);

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addCampanhaDocs'.
	 * 
	 * @param file
	 *            MultipartFile
	 * @param codCampanhaAlta
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return ConsultaFile
	 */
	@RequestMapping(value = "/addCampanhaDocs", method = RequestMethod.POST)
	public @ResponseBody List<Map<String, Object>> addCampanhaDocs(
			@RequestParam(value = "files[]", required = false) MultipartFile file,
			@ModelAttribute(value = "codCampanha") String codCampanhaAlta, HttpServletResponse response,
			HttpServletRequest request) {
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();

			String tedesfile = request.getParameter("tedesfile");

			adjuntardocsAux.setThcodocumento(this.denunciaService.getNewPKDocumentoHecho().toString());

			Blob blob = new SerialBlob(file.getBytes());
			adjuntardocsAux.setThdatafile(blob);
			adjuntardocsAux.setThcontenttypefile(file.getContentType());
			adjuntardocsAux.setThnofile(file.getOriginalFilename());
			adjuntardocsAux.setThsizefile((int) file.getSize());

			adjuntardocsAux.setThidExpediente(codCampanhaAlta);
			adjuntardocsAux.setThidTramite(codCampanhaAlta);

			adjuntardocsAux.setThtedesfile(tedesfile);

			adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SOL_APORTADO_ADMINISTRACION);

			TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
			tipoProcedimiento.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
			adjuntardocsAux.setTipoProcedimiento(tipoProcedimiento);

			adjuntardocsAux.setThfecha(new Date());

			adjuntardocsAux = this.adjuntardocsService.add(adjuntardocsAux);

			logger.info("Entity correctly inserted!" + adjuntardocsAux);

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			filesMetaInfo.add(this.getFileReturnMap(file));
			return filesMetaInfo;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * @param file
	 *            MultipartFile
	 * @return mapa
	 */
	private Map<String, Object> getFileReturnMap(MultipartFile file) {
		Map<String, Object> mapaRetorno = new HashMap<String, Object>();
		mapaRetorno.put("url", "/y41bVistaWar/campanha/addCampanhaDocs/" + file.getOriginalFilename());
		mapaRetorno.put("name", file.getOriginalFilename());
		mapaRetorno.put("type", file.getContentType());
		mapaRetorno.put("size", file.getSize());
		mapaRetorno.put("delete_url", "/y41bVistaWar/campanha/addCampanhaDocs/" + file.getOriginalFilename());
		mapaRetorno.put("delete_type", "DELETE");
		return mapaRetorno;
	}

	/**
	 * Method 'removeCampanhaDocs'.
	 * 
	 * @param iddocumento
	 *            String
	 * @param codCampanha
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarCampanhaDocs/{iddocumento}", method = RequestMethod.DELETE)
	public void removeCampanhaDocs(@PathVariable String iddocumento,
			@ModelAttribute(value = "codCampanha") String codCampanha, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThcodocumento(iddocumento);

			this.adjuntardocsService.remove(adjuntardocsAux);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllCampanhaProgramacion'.
	 * 
	 * @param codCampanha
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllCampanhaProgramacion", method = RequestMethod.GET)
	public @ResponseBody Object getAllCampanhaProgramacion(@ModelAttribute(value = "codCampanha") String codCampanha,
			HttpServletRequest request) {
		try {
			AdjuntarCampanhaprogra adjuntarCampanhaprogra = new AdjuntarCampanhaprogra();
			adjuntarCampanhaprogra.setPgcocm(codCampanha);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<AdjuntarCampanhaprogra> listAdjuntarCampanhaprogra = null;

				listAdjuntarCampanhaprogra = this.adjuntarCampanhaprograService.findAll(adjuntarCampanhaprogra,
						pagination);

				if (listAdjuntarCampanhaprogra == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.adjuntarCampanhaprograService.findAllCount(adjuntarCampanhaprogra);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAdjuntarCampanhaprogra);
				return data;
			} else {
				List<AdjuntarCampanhaprogra> listAdjuntarCampanhaprogra = null;

				listAdjuntarCampanhaprogra = this.adjuntarCampanhaprograService.findAll(adjuntarCampanhaprogra,
						pagination);

				if (listAdjuntarCampanhaprogra == null) {
					throw new Exception("No data Found.");
				}
				return listAdjuntarCampanhaprogra;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getCampanhaProgramacionById'.
	 * 
	 * @param pgcodigo
	 *            String
	 * @param codCampanhaAlta
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "findCampanhaProgramacion/{pgcodigo}", method = RequestMethod.GET)
	public @ResponseBody AdjuntarCampanhaprogra getCampanhaProgramacionById(@PathVariable String pgcodigo,
			@ModelAttribute(value = "codCampanha") String codCampanhaAlta) {
		try {

			Campanha campanha = new Campanha();
			campanha.setCmcodigo(codCampanhaAlta);

			this.adjuntarCampanhaproductoService.addCampanhaproductoTableTemporal(campanha);
			this.adjuntarCampanhatipoprotService.addCampanhatipoprotTableTemporal(campanha);
			this.adjuntardocsService.addDocsTableTemporal(codCampanhaAlta);
			this.adjuntarCampanhaprograService.addCampanhaprograTableTemporal(campanha);

			AdjuntarCampanhaprogra adjuntarCampanhaprogra = new AdjuntarCampanhaprogra();
			adjuntarCampanhaprogra.setPgcodigo(pgcodigo);

			adjuntarCampanhaprogra = this.adjuntarCampanhaprograService.find(adjuntarCampanhaprogra);
			if (adjuntarCampanhaprogra == null) {
				throw new Exception(pgcodigo);
			}
			return adjuntarCampanhaprogra;
		} catch (Exception e) {
			throw new ResourceNotFoundException(pgcodigo);
		}
	}

	/**
	 * Method 'addCampanhaProgramacion'.
	 * 
	 * @param adjuntarCampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @param codCampanhaAlta
	 *            String
	 * @return AdjuntarCampanhaprogra
	 */
	@RequestMapping(value = "/addCampanhaProgramacion", method = RequestMethod.POST)
	public @ResponseBody AdjuntarCampanhaprogra addCampanhaProgramacion(
			@RequestBody AdjuntarCampanhaprogra adjuntarCampanhaprogra,
			@ModelAttribute(value = "codCampanha") String codCampanhaAlta) {
		try {

			AdjuntarCampanhaprogra adjuntarCampanhaprograAux = this.adjuntarCampanhaprograService
					.addCampanhaprogra(adjuntarCampanhaprogra, codCampanhaAlta);

			logger.info("Entity correctly inserted!");
			return adjuntarCampanhaprograAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'addCampanhaProgramacionInspeccionAdicional'.
	 * 
	 * @param adjuntarCampanhaprogra
	 *            AdjuntarCampanhaprogra
	 * @param codCampanhaAlta
	 *            String
	 * @return AdjuntarCampanhaprogra
	 */
	@RequestMapping(value = "/addCampanhaProgramacionInspeccionAdicional", method = RequestMethod.PUT)
	public @ResponseBody AdjuntarCampanhaprogra addCampanhaProgramacionInspeccionAdicional(
			@RequestBody AdjuntarCampanhaprogra adjuntarCampanhaprogra,
			@ModelAttribute(value = "codCampanha") String codCampanhaAlta) {
		try {
			AdjuntarCampanhaprogra adjuntarCampanhaprograAux = this.adjuntarCampanhaprograService
					.addCampanhaprograInspeccionAdicional(adjuntarCampanhaprogra);
			logger.info("Entity correctly inserted!");
			return adjuntarCampanhaprograAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeBandejaControlmercado'.
	 * 
	 * @param pgcodigo
	 *            String
	 * @param codCampanha
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarCampanhaProgramacion/{pgcodigo}", method = RequestMethod.DELETE)
	public void removeBandejaControlmercado(@PathVariable String pgcodigo,
			@ModelAttribute(value = "codCampanha") String codCampanha, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			AdjuntarCampanhaprogra adjuntarCampanhaprogra = new AdjuntarCampanhaprogra();
			adjuntarCampanhaprogra.setPgcodigo(pgcodigo);

			this.adjuntarCampanhaprograService.remove(adjuntarCampanhaprogra);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllCampanhaproducto'.
	 * 
	 * @param codCampanha
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllCampanhaproductoInspeccionado", method = RequestMethod.GET)
	public @ResponseBody() Object getAllCampanhaproductoInspeccionado(
			@ModelAttribute(value = "codCampanha") String codCampanha, HttpServletRequest request) {
		try {

			Actuacion actuacion = new Actuacion();
			actuacion.setAtcocm(codCampanha);

			Pagination pagination = null;
			List<ProductosCampanhaActuacion> listProductosCampanhaActuacion = null;

			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				listProductosCampanhaActuacion = this.actuacionService.findAllProductosCampanha(actuacion, pagination);

				if (listProductosCampanhaActuacion == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.actuacionService.findAllProductosCampanhaCount(actuacion);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listProductosCampanhaActuacion);
				return data;

			} else {
				listProductosCampanhaActuacion = this.actuacionService.findAllProductosCampanha(actuacion, null);
				if (listProductosCampanhaActuacion == null) {
					throw new Exception("No data Found.");
				}
				return listProductosCampanhaActuacion;
			}

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllCampanha'.
	 * 
	 * @param cmcodigo_
	 *            String
	 * @param cmnombre_
	 *            String
	 * @param cmorigen_
	 *            String
	 * @param cmcops_
	 *            String
	 * @param cmcopsdesc_
	 *            String
	 * @param cmtipo_
	 *            String
	 * @param cmfase_
	 *            String
	 * @param cmincluircerradas_
	 *            String
	 * @param cmincluirnoactivas_
	 *            String
	 * @param cmfechainicioDesde_
	 *            String
	 * @param cmfechainicioHasta_
	 *            String
	 * @param cmfechacierreDesde_
	 *            String
	 * @param cmfechacierreHasta_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excel", method = RequestMethod.GET)
	public void getAllCampanhaExcel(@RequestParam(value = "cmcodigo", required = false) String cmcodigo_,
			@RequestParam(value = "cmnombre", required = false) String cmnombre_,
			@RequestParam(value = "cmorigen", required = false) String cmorigen_,
			@RequestParam(value = "cmcops", required = false) String cmcops_,
			@RequestParam(value = "cmcopsdesc", required = false) String cmcopsdesc_,
			@RequestParam(value = "cmtipo", required = false) String cmtipo_,
			@RequestParam(value = "cmfase", required = false) String cmfase_,
			@RequestParam(value = "cmincluircerradas", required = false) String cmincluircerradas_,
			@RequestParam(value = "cmincluirnoactivas", required = false) String cmincluirnoactivas_,
			@RequestParam(value = "cmfechainicioDesde", required = false) String cmfechainicioDesde_,
			@RequestParam(value = "cmfechainicioHasta", required = false) String cmfechainicioHasta_,
			@RequestParam(value = "cmfechacierreDesde", required = false) String cmfechacierreDesde_,
			@RequestParam(value = "cmfechacierreHasta", required = false) String cmfechacierreHasta_,
			HttpServletRequest request, HttpServletResponse response) {
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date cmfechainicioDesde = Y41bUtils.parseDate(cmfechainicioDesde_, locale);
			Date cmfechainicioHasta = Y41bUtils.parseDate(cmfechainicioHasta_, locale);

			Date cmfechacierreDesde = Y41bUtils.parseDate(cmfechacierreDesde_, locale);
			Date cmfechacierreHasta = Y41bUtils.parseDate(cmfechacierreHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro
			String cmcodigo = ("".equals(cmcodigo_)) ? null : cmcodigo_;
			String cmnombre = ("".equals(cmnombre_)) ? null : cmnombre_;
			String cmorigen = ("".equals(cmorigen_)) ? null : cmorigen_;
			String cmtipo = ("".equals(cmtipo_)) ? null : cmtipo_;
			String cmfase = ("".equals(cmfase_)) ? null : cmfase_;
			String cmcops = ("".equals(cmcops_)) ? null : cmcops_;
			String cmcopsdesc = ("".equals(cmcopsdesc_)) ? null : cmcopsdesc_;

			// control checks
			String cmincluircerradas = ("on".equals(cmincluircerradas_)) ? Y41bConstantes.VALOR_SI : null;
			String cmincluirnoactivas = ("on".equals(cmincluirnoactivas_)) ? Y41bConstantes.VALOR_SI : null;

			Campanha filterCampanha = new Campanha();
			filterCampanha.setCmcodigo(cmcodigo);
			filterCampanha.setCmnombre(cmnombre);
			filterCampanha.setCmorigen(cmorigen);
			filterCampanha.setCmtipo(cmtipo);
			filterCampanha.setCmfase(cmfase);
			filterCampanha.setCmfechainicioDesde(cmfechainicioDesde);
			filterCampanha.setCmfechainicioHasta(cmfechainicioHasta);
			filterCampanha.setCmfechacierreDesde(cmfechacierreDesde);
			filterCampanha.setCmfechacierreHasta(cmfechacierreHasta);

			filterCampanha.setCmfechainicioDesdeStr(cmfechainicioDesde_);
			filterCampanha.setCmfechainicioHastaStr(cmfechainicioHasta_);
			filterCampanha.setCmfechacierreDesdeStr(cmfechacierreDesde_);
			filterCampanha.setCmfechacierreHastaStr(cmfechacierreHasta_);

			filterCampanha.setCmcops(cmcops);
			filterCampanha.setCmcopsdesc(cmcopsdesc);

			filterCampanha.setCmincluircerradas(cmincluircerradas);
			filterCampanha.setCmincluirnoactivas(cmincluirnoactivas);

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy, "yyyyMMddHHmmss");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_BUSQUEDA_CAMPANHAS + fechaActual + ".xls";
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(nombre) + "\"");

			String xslString = this.y41bExcelGeneratorService.getCampanhasExcel(filterCampanha);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();

		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getEtiqueta'.
	 * 
	 * @param cmcodigo_
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * 
	 */
	@RequestMapping(value = "/etiqueta", method = RequestMethod.GET)
	public @ResponseBody void getEtiqueta(@RequestParam(value = "cmcodigo", required = false) String cmcodigo_,
			HttpServletResponse response) {
		try {
			String cmcodigo = ("".equals(cmcodigo_)) ? null : cmcodigo_;
			Campanha campanha = new Campanha();
			campanha.setCmcodigo(cmcodigo);

			PlantillaControlMercadoDetalle plantillaControlMercadoDetalle = this.campanhaService
					.findPlantillaControlMercadoDetalle(campanha);

			if (plantillaControlMercadoDetalle == null) {
				throw new Exception(cmcodigo_);
			}

			String rutaRTF = (String) appConfiguration.get("y41bVistaWar.ruta.plantillas.word");
			String rutaXML = (String) appConfiguration.get("y41bVistaWar.rutaxml.plantillas.word");
			String nombreRTF = Y41bConstantes.NOMBRE_PLANTILLA_CONTROL_MERCADO_CAMPANAS_ETIQUETA_RTF;
			String nombreXML = Y41bConstantes.NOMBRE_PLANTILLA_CONTROL_MERCADO_ETIQUETA_XML;
			String rutaCompletaRTF = rutaRTF + nombreRTF;
			String rutaCompletaXML = rutaXML + nombreXML;

			String plantilla = new String(Y41bDocumento.leerArchivoOrigen(rutaCompletaRTF));

			String strFileDataDecode = Y41bGenerarDocumento.generarDocumentoWord(rutaCompletaXML,
					plantillaControlMercadoDetalle, plantilla);

			byte[] bytesFichero = strFileDataDecode.getBytes();

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			StringBuffer nombreFichero = new StringBuffer().append(plantillaControlMercadoDetalle.getTipoOrigen())
					.append("-").append(plantillaControlMercadoDetalle.getCodigoOrigen()).append(".rtf");

			response.setHeader("Content-Disposition", "attachment; filename=\"" + nombreFichero + "\"");
			response.setContentType("application/msword");
			response.setContentLength(bytesFichero.length);
			response.getOutputStream().write(bytesFichero);

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException(cmcodigo_);
		} catch (Throwable t) {
			t.printStackTrace();
			throw new ResourceNotFoundException(cmcodigo_);
		}
	}

	/**
	 * Method 'reabrirCampana'.
	 * 
	 * @param cmcodigo_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/reabrir", method = RequestMethod.POST)
	public @ResponseBody void reabrirCampana(@RequestParam(value = "codCampanha", required = false) String cmcodigo_,
			HttpServletRequest request) {
		try {
			String cmcodigo = ("".equals(cmcodigo_)) ? null : cmcodigo_;
			Campanha campanha = new Campanha();
			campanha.setCmcodigo(cmcodigo);

			this.campanhaService.reabrir(campanha);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}
}
