package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.CampanhaComentariosService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.CampanhaComentarios;

/**
 * CampanhaComentariosController  
 *  
 */
 
@Controller
@RequestMapping (value = "/campanhacomentarios")

public class CampanhaComentariosController  {

	private static final Logger logger = LoggerFactory.getLogger(CampanhaComentariosController.class);

	@Autowired
	private CampanhaComentariosService campanhaComentariosService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		CampanhaComentariosController.logger.info("[GET - View] : campanhacomentarios");
		return "campanhacomentarios";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param txcodigo String
	 * @param txcmcodigo String
	 * @return campanhaComentarios CampanhaComentarios
	 */
	@RequestMapping(value = "/{txcodigo}/{txcmcodigo}", method = RequestMethod.GET)
	public @ResponseBody CampanhaComentarios getById(@PathVariable String txcodigo, @PathVariable String txcmcodigo) {
        CampanhaComentarios campanhaComentarios = new CampanhaComentarios();
		campanhaComentarios.setTxcodigo(txcodigo);
		campanhaComentarios.setTxcmcodigo(txcmcodigo);
        campanhaComentarios = this.campanhaComentariosService.find(campanhaComentarios);
        CampanhaComentariosController.logger.info("[GET - findBy_PK] : Obtener CampanhaComentarios por PK");
        return campanhaComentarios;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterCampanhaComentarios CampanhaComentarios
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<CampanhaComentarios> getAll(@ModelAttribute CampanhaComentarios filterCampanhaComentarios) {
		CampanhaComentariosController.logger.info("[GET - find_ALL] : Obtener CampanhaComentarios por filtro");
	    return this.campanhaComentariosService.findAll(filterCampanhaComentarios, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param campanhaComentarios CampanhaComentarios 
	 * @return CampanhaComentarios
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody CampanhaComentarios edit(@RequestBody CampanhaComentarios campanhaComentarios) {		
        CampanhaComentarios campanhaComentariosAux = this.campanhaComentariosService.update(campanhaComentarios);
		CampanhaComentariosController.logger.info("[PUT] : CampanhaComentarios actualizado correctamente");
        return campanhaComentariosAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param campanhaComentarios CampanhaComentarios 
	 * @return CampanhaComentarios
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody CampanhaComentarios add(@RequestBody CampanhaComentarios campanhaComentarios) {		
        CampanhaComentarios campanhaComentariosAux = this.campanhaComentariosService.add(campanhaComentarios);
        CampanhaComentariosController.logger.info("[POST] : CampanhaComentarios insertado correctamente");
    	return campanhaComentariosAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param txcodigo String
	 * @param txcmcodigo String
	 * @return campanhaComentarios
	 */
	@RequestMapping(value = "/{txcodigo}/{txcmcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody CampanhaComentarios remove(@PathVariable String txcodigo, @PathVariable String txcmcodigo) {
        CampanhaComentarios campanhaComentarios = new CampanhaComentarios();
        campanhaComentarios.setTxcodigo(txcodigo);
        campanhaComentarios.setTxcmcodigo(txcmcodigo);
        this.campanhaComentariosService.remove(campanhaComentarios);
       	CampanhaComentariosController.logger.info("[DELETE] : CampanhaComentarios borrado correctamente");
       	return campanhaComentarios;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param campanhaComentariosIds List
	 * @return campanhaComentariosList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> campanhaComentariosIds) {
        List<CampanhaComentarios> campanhaComentariosList = new ArrayList<CampanhaComentarios>();
        for (List<String> campanhaComentariosId:campanhaComentariosIds) {
		    Iterator<String> iterator = campanhaComentariosId.iterator();
		    CampanhaComentarios campanhaComentarios = new CampanhaComentarios(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        campanhaComentarios.setTxcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
	        campanhaComentarios.setTxcmcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
		    campanhaComentariosList.add(campanhaComentarios);
	    }
        this.campanhaComentariosService.removeMultiple(campanhaComentariosList);
		CampanhaComentariosController.logger.info("[POST - DELETE_ALL] : CampanhaComentarios borrados correctamente");
		return campanhaComentariosIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterCampanhaComentarios CampanhaComentarios
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute CampanhaComentarios filterCampanhaComentarios, @ModelAttribute Pagination pagination) {
        List<CampanhaComentarios> campanhaComentarioss = this.campanhaComentariosService.findAll(filterCampanhaComentarios, pagination);
        Long recordNum = this.campanhaComentariosService.findAllCount(filterCampanhaComentarios);
        CampanhaComentariosController.logger.info("[GET - jqGrid] : Obtener CampanhaComentarios");
		return new JQGridJSONModel(pagination, recordNum, campanhaComentarioss);
	}
	
}	
