package com.ejie.y41b.control;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CampanhaCierre;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.PlantillaInformeCierreCampanha;
import com.ejie.y41b.service.CampanhaCierreService;
import com.ejie.y41b.utils.documentos.Y41bDocumento;
import com.ejie.y41b.utils.documentos.Y41bGenerarDocumento;

/**
 * CampanhaCierreController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/campanhacierre")
public class CampanhaCierreController {

	private static final Logger logger = LoggerFactory
			.getLogger(CampanhaCierreController.class);

	@Autowired
	private CampanhaCierreService campanhaCierreService;

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		CampanhaCierreController.logger.info("[GET - View] : campanhacierre");
		return "campanhacierre";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param tycodigo
	 *            String
	 * @param tycmcodigo
	 *            String
	 * @param tyfinalizadoaraba
	 *            String
	 * @param tyfinalizadobizkaia
	 *            String
	 * @param tyfinalizadogipuzkoa
	 *            String
	 * @param tyfinalizadosscc
	 *            String
	 * @return campanhaCierre CampanhaCierre
	 */
	@RequestMapping(value = "/{tycodigo}/{tycmcodigo}/{tyfinalizadoaraba}/{tyfinalizadobizkaia}/{tyfinalizadogipuzkoa}/{tyfinalizadosscc}", method = RequestMethod.GET)
	public @ResponseBody
	CampanhaCierre getById(@PathVariable String tycodigo,
			@PathVariable String tycmcodigo,
			@PathVariable String tyfinalizadoaraba,
			@PathVariable String tyfinalizadobizkaia,
			@PathVariable String tyfinalizadogipuzkoa,
			@PathVariable String tyfinalizadosscc) {
		CampanhaCierre campanhaCierre = new CampanhaCierre();
		campanhaCierre.setTycodigo(tycodigo);
		campanhaCierre.setTycmcodigo(tycmcodigo);
		campanhaCierre.setTyfinalizadoaraba(tyfinalizadoaraba);
		campanhaCierre.setTyfinalizadobizkaia(tyfinalizadobizkaia);
		campanhaCierre.setTyfinalizadogipuzkoa(tyfinalizadogipuzkoa);
		campanhaCierre.setTyfinalizadosscc(tyfinalizadosscc);
		campanhaCierre = this.campanhaCierreService.find(campanhaCierre);
		CampanhaCierreController.logger
				.info("[GET - findBy_PK] : Obtener CampanhaCierre por PK");
		return campanhaCierre;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterCampanhaCierre
	 *            CampanhaCierre
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<CampanhaCierre> getAll(
			@ModelAttribute CampanhaCierre filterCampanhaCierre) {
		CampanhaCierreController.logger
				.info("[GET - find_ALL] : Obtener CampanhaCierre por filtro");
		return this.campanhaCierreService.findAll(filterCampanhaCierre, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param campanhaCierre
	 *            CampanhaCierre
	 * @return CampanhaCierre
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	CampanhaCierre edit(@RequestBody CampanhaCierre campanhaCierre) {
		try {
			CampanhaCierre campanhaCierreAux = this.campanhaCierreService
					.update(campanhaCierre);
			CampanhaCierreController.logger
					.info("[PUT] : CampanhaCierre actualizado correctamente");
			return campanhaCierreAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param campanhaCierre
	 *            CampanhaCierre
	 * @return CampanhaCierre
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	CampanhaCierre add(@RequestBody CampanhaCierre campanhaCierre) {
		CampanhaCierre campanhaCierreAux = this.campanhaCierreService
				.add(campanhaCierre);
		CampanhaCierreController.logger
				.info("[POST] : CampanhaCierre insertado correctamente");
		return campanhaCierreAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param tycodigo
	 *            String
	 * @param tycmcodigo
	 *            String
	 * @param tyfinalizadoaraba
	 *            String
	 * @param tyfinalizadobizkaia
	 *            String
	 * @param tyfinalizadogipuzkoa
	 *            String
	 * @param tyfinalizadosscc
	 *            String
	 * @return campanhaCierre
	 */
	@RequestMapping(value = "/{tycodigo}/{tycmcodigo}/{tyfinalizadoaraba}/{tyfinalizadobizkaia}/{tyfinalizadogipuzkoa}/{tyfinalizadosscc}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	CampanhaCierre remove(@PathVariable String tycodigo,
			@PathVariable String tycmcodigo,
			@PathVariable String tyfinalizadoaraba,
			@PathVariable String tyfinalizadobizkaia,
			@PathVariable String tyfinalizadogipuzkoa,
			@PathVariable String tyfinalizadosscc) {
		CampanhaCierre campanhaCierre = new CampanhaCierre();
		campanhaCierre.setTycodigo(tycodigo);
		campanhaCierre.setTycmcodigo(tycmcodigo);
		campanhaCierre.setTyfinalizadoaraba(tyfinalizadoaraba);
		campanhaCierre.setTyfinalizadobizkaia(tyfinalizadobizkaia);
		campanhaCierre.setTyfinalizadogipuzkoa(tyfinalizadogipuzkoa);
		campanhaCierre.setTyfinalizadosscc(tyfinalizadosscc);
		this.campanhaCierreService.remove(campanhaCierre);
		CampanhaCierreController.logger
				.info("[DELETE] : CampanhaCierre borrado correctamente");
		return campanhaCierre;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param campanhaCierreIds
	 *            List
	 * @return campanhaCierreList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> campanhaCierreIds) {
		List<CampanhaCierre> campanhaCierreList = new ArrayList<CampanhaCierre>();
		for (List<String> campanhaCierreId : campanhaCierreIds) {
			Iterator<String> iterator = campanhaCierreId.iterator();
			CampanhaCierre campanhaCierre = new CampanhaCierre(); // NOPMD -
																	// Objeto
																	// nuevo en
																	// la lista
																	// (parametro
																	// del
																	// servicio)
			campanhaCierre.setTycodigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			campanhaCierre.setTycmcodigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			campanhaCierre.setTyfinalizadoaraba(ObjectConversionManager
					.convert(iterator.next(), String.class));
			campanhaCierre.setTyfinalizadobizkaia(ObjectConversionManager
					.convert(iterator.next(), String.class));
			campanhaCierre.setTyfinalizadogipuzkoa(ObjectConversionManager
					.convert(iterator.next(), String.class));
			campanhaCierre.setTyfinalizadosscc(ObjectConversionManager.convert(
					iterator.next(), String.class));
			campanhaCierreList.add(campanhaCierre);
		}
		this.campanhaCierreService.removeMultiple(campanhaCierreList);
		CampanhaCierreController.logger
				.info("[POST - DELETE_ALL] : CampanhaCierre borrados correctamente");
		return campanhaCierreIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterCampanhaCierre
	 *            CampanhaCierre
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute CampanhaCierre filterCampanhaCierre,
			@ModelAttribute Pagination pagination) {
		List<CampanhaCierre> campanhaCierres = this.campanhaCierreService
				.findAll(filterCampanhaCierre, pagination);
		Long recordNum = this.campanhaCierreService
				.findAllCount(filterCampanhaCierre);
		CampanhaCierreController.logger
				.info("[GET - jqGrid] : Obtener CampanhaCierre");
		return new JQGridJSONModel(pagination, recordNum, campanhaCierres);
	}

	/**
	 * Method 'getByIdInformeCierreCampanha'.
	 * 
	 * @param tycmcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/generarInforme", method = RequestMethod.GET)
	public @ResponseBody()
	void getByIdInformeCierreCampanha(
			@RequestParam(value = "codCampanha", required = false) String tycmcodigo,
			HttpServletRequest request, HttpServletResponse response) {
		try {
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			PlantillaInformeCierreCampanha plantillaInformeCierreCampanha = new PlantillaInformeCierreCampanha();
			plantillaInformeCierreCampanha.setCmCodigo(tycmcodigo);

			plantillaInformeCierreCampanha = this.campanhaCierreService
					.generarInformeCierreCampanha(
							plantillaInformeCierreCampanha, censoMonitor);

			if (plantillaInformeCierreCampanha == null) {
				throw new Exception(tycmcodigo.toString());
			}

			String rutaRTF = (String) this.appConfiguration
					.get("y41bVistaWar.ruta.plantillas.word");
			String rutaXML = (String) this.appConfiguration
					.get("y41bVistaWar.rutaxml.plantillas.word");
			String nombreRTF = Y41bConstantes.NOMBRE_PLANTILLA_INFORME_CIERRE_CAMPANHA_RTF;
			String nombreXML = Y41bConstantes.NOMBRE_PLANTILLA_INFORME_CIERRE_CAMPANHA_XML;
			String rutaCompletaRTF = rutaRTF + nombreRTF;
			String rutaCompletaXML = rutaXML + nombreXML;

			String plantilla = new String(
					Y41bDocumento.leerArchivoOrigen(rutaCompletaRTF));

			String strFileDataDecode = Y41bGenerarDocumento
					.generarDocumentoWord(rutaCompletaXML,
							plantillaInformeCierreCampanha, plantilla);

			byte[] bytesFichero = strFileDataDecode.getBytes();

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			String nombreFichero = tycmcodigo
					+ " - "
					+ Y41bConstantes.NOMBRE_PLANTILLA_DOC_INFORME_CIERRE_CAMPANHA;

			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ nombreFichero + "\"");
			response.setContentType(Y41bConstantes.CONTENT_TYPE_MSWORD);

			// response.addHeader("Expires", "-1");

			// FIXME Esto se ha quitado porque sino en Internet Explorer produce
			// un error al mostrarse
			// response.setCharacterEncoding("ISO-8859-1");
			// response.setHeader("Cache-Control", "no-cache");

			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ nombreFichero + "\"");
			response.setContentType("application/msword");
			response.setContentLength(bytesFichero.length);
			response.getOutputStream().write(bytesFichero);

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException(tycmcodigo.toString());
		} catch (Throwable t) {
			t.printStackTrace();
			throw new ResourceNotFoundException(tycmcodigo.toString());
		}
	}
}
