package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.*;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.*;
import com.ejie.y41b.service.*;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.dokusi.Y41bUtilsDokusi;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * BusquedaCombinadaController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/busquedacombinada")
@SessionAttributes({ "busquedacombinada", "solicitudDetalle",
		"modobusquedacombinada", "tipoProcedimiento" })
public class BusquedaCombinadaController {

	private static final Logger logger = LoggerFactory
			.getLogger(BusquedaCombinadaController.class);

	@Autowired
	private DenunciaService denunciaService;

	@Autowired
	private ExpedienService expedienService;

	@Autowired
	private SolarbService solarbService;

	@Autowired
	private CensoMonitorService censoMonitorService;

	@Autowired
	private ActaService actaService;

	@Autowired
	private Properties appConfiguration;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */
	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {
		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;
		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bTabsBusquedaCombinada", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bTabsBusquedaResultadoSolicitudes(
			Model model, HttpServletRequest request) {

		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("solicitudAccesoDesde",
				Y41bConstantes.SOLICITUDES_ACCESO_DESDE_SOLICITUD);

		model.addAttribute("busquedacombinada", new BusquedaCombinada());

		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo("");

		model.addAttribute("solicitudDetalle", solicitudDetalle);
		model.addAttribute("modobusquedacombinada", "");
		model.addAttribute("tipoProcedimiento", "");

		return new ModelAndView("y41bTabsBusquedaCombinada", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param dtcodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bTabBusquedaCombinadaModal/{codProcedimiento}/{dtcodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bTabsBusquedaResultadoSolicitudesModal(
			@PathVariable String codProcedimiento,
			@PathVariable String dtcodigo, Model model,
			HttpServletRequest request) {
		try {
			model.addAttribute("defaultLanguage",
					appConfiguration.get("y41bVistaWar.default.language"));
			model.addAttribute("defaultLayout",
					appConfiguration.get("y41bVistaWar.default.layout"));

			BusquedaCombinada busquedaCombinada = new BusquedaCombinada();
			busquedaCombinada.setDtcodigo(new String(Y41bUtilsDokusi
					.decode(dtcodigo)));

			model.addAttribute("busquedacombinada", busquedaCombinada);
			model.addAttribute("modobusquedacombinada",
					Y41bConstantes.MODO_POPUP_SELECCION);
			model.addAttribute("tipoProcedimiento", codProcedimiento);

			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo("");

			model.addAttribute("solicitudDetalle", solicitudDetalle);

			return new ModelAndView("y41bTabBusquedaCombinadaModal", "model",
					model);
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico" + e.getMessage(), true,
					e);
		}

	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param busquedaCombinada
	 *            BusquedaCombinada
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bTabsBusquedaCombinadaCon", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bTabsBusquedaResultadoSolicitudesCon(
			@ModelAttribute(value = "busquedacombinada") BusquedaCombinada busquedaCombinada,
			Model model, HttpServletRequest request) {
		model.addAttribute("busquedacombinada", busquedaCombinada);

		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modobusquedacombinada", "");
		model.addAttribute("tipoProcedimiento", "");

		return new ModelAndView("y41bTabsBusquedaCombinada", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bTabsBusquedaCombinadaCon/y41bDetalleSolicitud/{hdcodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bDetalleSolicitud(
			@PathVariable String hdcodigo, Model model,
			HttpServletRequest request) {

		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(hdcodigo);

		model.addAttribute("solicitudDetalle", solicitudDetalle);

		model.addAttribute("defaultLanguage",
				appConfiguration.get("z99aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("z99aVistaWar.default.layout"));

		model.addAttribute("modobusquedacombinada", "");
		model.addAttribute("tipoProcedimiento", "");

		return new ModelAndView("y41bTabsDetalleSolicitudNormal", "model",
				model);
	}

	/**
	 * Method 'getCreateFormDetalleConsulta'.
	 * 
	 * @param model
	 *            Model
	 * @param excodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "y41bTabsBusquedaCombinadaSan/y41bDetalleSancion/{excodigo}", method = RequestMethod.GET)
	public ModelAndView getFichaExpediente(
			Model model,
			@RequestParam(value = "desde", required = false) String desde,
			@RequestParam(value = "accesoPest2", required = false) String accesoPest2,
			@PathVariable String excodigo, HttpServletRequest httpRequest) {

		try {
			return expedienService.getFichaExpedienteSanciones(model, desde,
					accesoPest2, excodigo, httpRequest);
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico" + e.getMessage(), true,
					e);
		}
	}

	/**
	 * Method 'getCreateFormDetalleConsulta'.
	 * 
	 * @param model
	 *            Model
	 * @param excodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "y41bTabsBusquedaCombinadaArb/y41bDetalleArbitraje/{sacodigo}", method = RequestMethod.GET)
	public ModelAndView getFichaExpedienteArb(
			Model model,
			@RequestParam(value = "desde", required = false) String desde,
			@RequestParam(value = "accesoPest2", required = false) String accesoPest2,
			@PathVariable String sacodigo, HttpServletRequest httpRequest) {

		try {
			return solarbService.getFichaExpedienteArbitraje(model, desde,
					accesoPest2, new String(Y41bUtilsDokusi.decode(sacodigo)),
					httpRequest);
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico" + e.getMessage(), true,
					e);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param atcodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bTabsBusquedaCombinadaIns/y41bDetalleInspeccion/{atcodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bDetalleInspeccion(
			@PathVariable String atcodigo, Model model,
			HttpServletRequest request) {

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(atcodigo);

		model.addAttribute("atcodigo", atcodigo);
		model.addAttribute("estadoInspeccion",
				Y41bConstantes.MODO_POPUP_MODIFICACION);

		Actuacion actuacionaux = new Actuacion();
		actuacionaux.setAtcodigo(atcodigo);

		InspeccionDetalle inspeccionDetalle = this.actaService.findInspeccion(
				actuacion, censoMonitor);

		// Si es inspeccion vieja, la redirige a la url correcta.
		if (!Y41bConstantes.VALOR_SI.equals(inspeccionDetalle
				.getIskontsumobide())) {
			return new ModelAndView(
					"redirect:/busquedacombinada/y41bTabsBusquedaCombinadaCon/y41bDetalleInspeccionAntiguas/"
							+ atcodigo);
		}

		model.addAttribute("inspeccionDetalle", inspeccionDetalle);

		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modobusquedacombinada", "");
		model.addAttribute("tipoProcedimiento", "");

		return new ModelAndView("y41bInspeccionDetalle", "model", model);
	}

	/**
	 * Method 'getCreateFormY49BTabsInspeccionesDetalleAntiguas'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @param atcodigo
	 *            String
	 * @return ModelAndView
	 */
	@RequestMapping(value = "y41bTabsBusquedaCombinadaIns/y41bDetalleInspeccionAntiguas/{atcodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bDetalleInspeccionAntigua(Model model,
			HttpServletRequest request, @PathVariable() String atcodigo) {

		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		model.addAttribute("atcodigo", atcodigo);
		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(atcodigo);
		model.addAttribute("numExpediente",
				this.actaService.findNumExpediente(actuacion));

		httpSession.setAttribute("desde", Y41bConstantes.DESDE_BUSQUEDA);

		if (censoMonitor.getPerfilInspecciones() == null
				|| censoMonitor.getPerfilInspecciones().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bTabsInspeccionesDetalleAntiguas",
					"model", model);
		}
	}

	/**
	 * Method 'getCreateFormY41bTabBusquedaCombinada'.
	 * 
	 * @param model
	 *            Model
	 * @param busquedaCombinada
	 *            BusquedaCombinada
	 * @param modobusquedacombinada
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bTabBusquedaCombinada", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bTabBusquedaCombinada(
			Model model,
			@ModelAttribute(value = "busquedacombinada") BusquedaCombinada busquedaCombinada,
			@ModelAttribute(value = "modobusquedacombinada") String modobusquedacombinada,
			HttpServletRequest request) {
		model.addAttribute("busquedacombinada", busquedaCombinada);

		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modobusquedacombinada", modobusquedacombinada);

		return new ModelAndView("y41bTabBusquedaCombinada", "model", model);
	}

	/**
	 * Method 'getCreateFormY41bTabResultadoSolicitudes'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bTabResultadoSolicitudesBusquedaCombinada", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bTabResultadoSolicitudes(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("y41bTabResultadoSolicitudesBusquedaCombinada",
				"model", model);
	}

	/**
	 * Method 'getCreateFormY41bTabResultadoSanciones'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bTabResultadoSancionesBusquedaCombinada", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bTabResultadoSanciones(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		httpSession.setAttribute("desde", Y41bConstantes.DESDE_COMBINADA);

		return new ModelAndView("y41bTabResultadoSancionesBusquedaCombinada",
				"model", model);
	}

	/**
	 * Method 'getCreateFormY41bTabResultadoSanciones'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bTabResultadoArbitrajesBusquedaCombinada", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bTabResultadoArbitrajes(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		httpSession.setAttribute("desde", Y41bConstantes.DESDE_COMBINADA);

		return new ModelAndView("y41bTabResultadoArbitrajesBusquedaCombinada",
				"model", model);
	}

	/**
	 * Method 'getCreateFormY41bTabResultadoInspecciones'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bTabResultadoInspeccionesBusquedaCombinada", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bTabResultadoInspecciones(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView(
				"y41bTabResultadoInspeccionesBusquedaCombinada", "model", model);
	}

	/**
	 * Method 'getAllSolicitud'.
	 * 
	 * @param escodigo_
	 *            String
	 * @param esnombre_
	 *            String
	 * @param esnif_
	 *            String
	 * @param esnoco_
	 *            String
	 * @param esextranjero_
	 *            String
	 * @param esestado_
	 *            String
	 * @param esnoraPaisId_
	 *            String
	 * @param esnoraProvinciaId_
	 *            String
	 * @param esnoraMunicipioId_
	 *            String
	 * @param esnoraLocalidadId_
	 *            String
	 * @param esdireccion_nocapv_
	 *            String
	 * @param dtcodigo_
	 *            String
	 * @param dtnombre_
	 *            String
	 * @param dtapellido1_
	 *            String
	 * @param dtapellido2_
	 *            String
	 * @param dtnif_
	 *            String
	 * @param dtextranjero_
	 *            String
	 * @param dtestado_
	 *            String
	 * @param dtnoraPaisId_
	 *            String
	 * @param dtnoraProvinciaId_
	 *            String
	 * @param dtnoraMunicipioId_
	 *            String
	 * @param dtnoraLocalidadId_
	 *            String
	 * @param dtdireccion_nocapv_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/busquedaSolicitudes", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllSolicitud(
			@RequestParam(value = "escodigo", required = false) String escodigo_,
			@RequestParam(value = "esnombre", required = false) String esnombre_,
			@RequestParam(value = "esnif", required = false) String esnif_,
			@RequestParam(value = "esnoco", required = false) String esnoco_,
			@RequestParam(value = "esextranjero", required = false) String esextranjero_,
			@RequestParam(value = "esestado", required = false) String esestado_,
			@RequestParam(value = "esnoraPaisId", required = false) String esnoraPaisId_,
			@RequestParam(value = "esnoraProvinciaId", required = false) String esnoraProvinciaId_,
			@RequestParam(value = "esnoraMunicipioId", required = false) String esnoraMunicipioId_,
			@RequestParam(value = "esnoraLocalidadId", required = false) String esnoraLocalidadId_,
			@RequestParam(value = "esdireccion_nocapv", required = false) String esdireccion_nocapv_,
			@RequestParam(value = "dtcodigo", required = false) String dtcodigo_,
			@RequestParam(value = "dtnombre", required = false) String dtnombre_,
			@RequestParam(value = "dtapellido1", required = false) String dtapellido1_,
			@RequestParam(value = "dtapellido2", required = false) String dtapellido2_,
			@RequestParam(value = "dtnif", required = false) String dtnif_,
			@RequestParam(value = "dtextranjero", required = false) String dtextranjero_,
			@RequestParam(value = "dtestado", required = false) String dtestado_,
			@RequestParam(value = "dtnoraPaisId", required = false) String dtnoraPaisId_,
			@RequestParam(value = "dtnoraProvinciaId", required = false) String dtnoraProvinciaId_,
			@RequestParam(value = "dtnoraMunicipioId", required = false) String dtnoraMunicipioId_,
			@RequestParam(value = "dtnoraLocalidadId", required = false) String dtnoraLocalidadId_,
			@RequestParam(value = "dtdireccion_nocapv", required = false) String dtdireccion_nocapv_,
			HttpServletRequest request, Model model) {
		try {

			// est
			String esextranjero = null;
			String esestado = null;
			String esnoraPaisId = null;
			String esnoraProvinciaId = null;
			String esnoraMunicipioId = null;
			String esnoraLocalidadId = null;
			String esdireccion_nocapv = null;

			if (Y41bConstantes.NORA_LOCALIZACION_TODOS.equals(esextranjero_)) {
				esextranjero = null;
				esnoraPaisId = null;
				esestado = null;
				esnoraProvinciaId = null;
				esnoraMunicipioId = null;
				esnoraLocalidadId = null;
				esdireccion_nocapv = null;
			} else if (Y41bConstantes.NORA_LOCALIZACION_EXTRANJERO
					.equals(esextranjero_)) {
				esextranjero = Y41bConstantes.VALOR_SI;
				esnoraPaisId = ("".equals(esnoraPaisId_)) ? null
						: esnoraPaisId_;
				esestado = null;
				esnoraProvinciaId = null;
				esnoraMunicipioId = null;
				esnoraLocalidadId = null;
				esdireccion_nocapv = ("".equals(esdireccion_nocapv_)) ? null
						: esdireccion_nocapv_;

			} else if (Y41bConstantes.NORA_LOCALIZACION_ESTADO
					.equals(esextranjero_)) {
				esextranjero = null;
				esnoraPaisId = null;
				esestado = Y41bConstantes.VALOR_SI;
				esnoraProvinciaId = ("".equals(esnoraProvinciaId_)) ? null
						: esnoraProvinciaId_;
				esnoraMunicipioId = ("".equals(esnoraMunicipioId_)) ? null
						: esnoraMunicipioId_;
				esnoraLocalidadId = ("".equals(esnoraLocalidadId_)) ? null
						: esnoraLocalidadId_;
				esdireccion_nocapv = ("".equals(esdireccion_nocapv_)) ? null
						: esdireccion_nocapv_;
			}

			// cons
			String dtextranjero = null;
			String dtestado = null;
			String dtnoraPaisId = null;
			String dtnoraProvinciaId = null;
			String dtnoraMunicipioId = null;
			String dtnoraLocalidadId = null;
			String dtdireccion_nocapv = null;

			if (Y41bConstantes.NORA_LOCALIZACION_TODOS.equals(dtextranjero_)) {
				dtextranjero = null;
				dtnoraPaisId = null;
				dtestado = null;
				dtnoraProvinciaId = null;
				dtnoraMunicipioId = null;
				dtnoraLocalidadId = null;
				dtdireccion_nocapv = null;
			} else if (Y41bConstantes.NORA_LOCALIZACION_EXTRANJERO
					.equals(dtextranjero_)) {
				dtextranjero = Y41bConstantes.VALOR_SI;
				dtnoraPaisId = ("".equals(dtnoraPaisId_)) ? null
						: dtnoraPaisId_;
				dtestado = null;
				dtnoraProvinciaId = null;
				dtnoraMunicipioId = null;
				dtnoraLocalidadId = null;
				dtdireccion_nocapv = ("".equals(dtdireccion_nocapv_)) ? null
						: dtdireccion_nocapv_;

			} else if (Y41bConstantes.NORA_LOCALIZACION_ESTADO
					.equals(dtextranjero_)) {
				dtextranjero = null;
				dtnoraPaisId = null;
				dtestado = Y41bConstantes.VALOR_SI;
				dtnoraProvinciaId = ("".equals(dtnoraProvinciaId_)) ? null
						: dtnoraProvinciaId_;
				dtnoraMunicipioId = ("".equals(dtnoraMunicipioId_)) ? null
						: dtnoraMunicipioId_;
				dtnoraLocalidadId = ("".equals(dtnoraLocalidadId_)) ? null
						: dtnoraLocalidadId_;
				dtdireccion_nocapv = ("".equals(dtdireccion_nocapv_)) ? null
						: dtdireccion_nocapv_;
			}
			//

			String dtcodigo = ("".equals(dtcodigo_)) ? null : dtcodigo_;
			String dtnombre = ("".equals(dtnombre_)) ? null : dtnombre_;
			String dtapellido1 = ("".equals(dtapellido1_)) ? null
					: dtapellido1_;
			String dtapellido2 = ("".equals(dtapellido2_)) ? null
					: dtapellido2_;
			String dtnif = ("".equals(dtnif_)) ? null : dtnif_;
			// String dtextranjero = ("on".equals(dtextranjero_)) ?
			// Y41bConstantes.VALOR_SI
			// : null;
			// String dtestado = ("on".equals(dtestado_)) ?
			// Y41bConstantes.VALOR_SI
			// : null;
			// String dtnoraPaisId = ("".equals(dtnoraPaisId_)) ? null
			// : dtnoraPaisId_;
			// String dtnoraProvinciaId = ("".equals(dtnoraProvinciaId_)) ? null
			// : dtnoraProvinciaId_;
			// String dtnoraMunicipioId = ("".equals(dtnoraMunicipioId_)) ? null
			// : dtnoraMunicipioId_;
			// String dtnoraLocalidadId = ("".equals(dtnoraLocalidadId_)) ? null
			// : dtnoraLocalidadId_;
			// String dtdireccion_nocapv = ("".equals(dtdireccion_nocapv_)) ?
			// null
			// : dtdireccion_nocapv_;

			String escodigo = ("".equals(escodigo_)) ? null : escodigo_;
			String esnombre = ("".equals(esnombre_)) ? null : esnombre_;
			String esnif = ("".equals(esnif_)) ? null : esnif_;
			String esnoco = ("".equals(esnoco_)) ? null : esnoco_;
			// String esextranjero = ("on".equals(esextranjero_)) ?
			// Y41bConstantes.VALOR_SI
			// : null;
			// String esestado = ("on".equals(esestado_)) ?
			// Y41bConstantes.VALOR_SI
			// : null;
			// String esnoraPaisId = ("".equals(esnoraPaisId_)) ? null
			// : esnoraPaisId_;
			// String esnoraProvinciaId = ("".equals(esnoraProvinciaId_)) ? null
			// : esnoraProvinciaId_;
			// String esnoraMunicipioId = ("".equals(esnoraMunicipioId_)) ? null
			// : esnoraMunicipioId_;
			// String esnoraLocalidadId = ("".equals(esnoraLocalidadId_)) ? null
			// : esnoraLocalidadId_;
			// String esdireccion_nocapv = ("".equals(esdireccion_nocapv_)) ?
			// null
			// : esdireccion_nocapv_;

			BusquedaCombinada filterBusquedaCombinada = new BusquedaCombinada(
					esnombre, esnif, esnoco, esextranjero, esestado,
					esnoraPaisId, esnoraProvinciaId, esnoraMunicipioId,
					esnoraLocalidadId, esdireccion_nocapv, dtnombre,
					dtapellido1, dtapellido2, dtnif, dtextranjero, dtestado,
					dtnoraPaisId, dtnoraProvinciaId, dtnoraMunicipioId,
					dtnoraLocalidadId, dtdireccion_nocapv);
			filterBusquedaCombinada.setDtcodigo(dtcodigo);
			filterBusquedaCombinada.setEscodigo(escodigo);

			model.addAttribute("busquedacombinada", filterBusquedaCombinada);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<SolicitudBusqueda> solicitudesBusqueda = this.denunciaService
						.findAllLikeSolicitudesBusquedaCombinada(
								filterBusquedaCombinada, pagination, false);

				if (solicitudesBusqueda == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.denunciaService
						.findAllLikeSolicitudesBusquedaCombinadaCount(
								filterBusquedaCombinada, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(solicitudesBusqueda);
				return data;
			} else {
				List<SolicitudBusqueda> solicitudesBusqueda = this.denunciaService
						.findAllLikeSolicitudesBusquedaCombinada(
								filterBusquedaCombinada, pagination, false);
				if (solicitudesBusqueda == null) {
					throw new Exception("No data Found.");
				}
				return solicitudesBusqueda;
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllSanciones'.
	 * 
	 * @param escodigo_
	 *            String
	 * @param esnombre_
	 *            String
	 * @param esnif_
	 *            String
	 * @param esnoco_
	 *            String
	 * @param esextranjero_
	 *            String
	 * @param esestado_
	 *            String
	 * @param esnoraPaisId_
	 *            String
	 * @param esnoraProvinciaId_
	 *            String
	 * @param esnoraMunicipioId_
	 *            String
	 * @param esnoraLocalidadId_
	 *            String
	 * @param esdireccion_nocapv_
	 *            String
	 * @param dtcodigo_
	 *            String
	 * @param dtnombre_
	 *            String
	 * @param dtapellido1_
	 *            String
	 * @param dtapellido2_
	 *            String
	 * @param dtnif_
	 *            String
	 * @param dtextranjero_
	 *            String
	 * @param dtestado_
	 *            String
	 * @param dtnoraPaisId_
	 *            String
	 * @param dtnoraProvinciaId_
	 *            String
	 * @param dtnoraMunicipioId_
	 *            String
	 * @param dtnoraLocalidadId_
	 *            String
	 * @param dtdireccion_nocapv_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/busquedaSanciones", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllSanciones(
			@RequestParam(value = "escodigo", required = false) String escodigo_, /* nuevo */
			@RequestParam(value = "esnombre", required = false) String esnombre_,
			@RequestParam(value = "esnif", required = false) String esnif_,
			@RequestParam(value = "esnoco", required = false) String esnoco_,
			@RequestParam(value = "esextranjero", required = false) String esextranjero_,
			@RequestParam(value = "esestado", required = false) String esestado_,
			@RequestParam(value = "esnoraPaisId", required = false) String esnoraPaisId_,
			@RequestParam(value = "esnoraProvinciaId", required = false) String esnoraProvinciaId_,
			@RequestParam(value = "esnoraMunicipioId", required = false) String esnoraMunicipioId_,
			@RequestParam(value = "esnoraLocalidadId", required = false) String esnoraLocalidadId_,
			@RequestParam(value = "esdireccion_nocapv", required = false) String esdireccion_nocapv_,
			@RequestParam(value = "dtcodigo", required = false) String dtcodigo_, /* nuevo */
			@RequestParam(value = "dtnombre", required = false) String dtnombre_,
			@RequestParam(value = "dtapellido1", required = false) String dtapellido1_,
			@RequestParam(value = "dtapellido2", required = false) String dtapellido2_,
			@RequestParam(value = "dtnif", required = false) String dtnif_,
			@RequestParam(value = "dtextranjero", required = false) String dtextranjero_,
			@RequestParam(value = "dtestado", required = false) String dtestado_,
			@RequestParam(value = "dtnoraPaisId", required = false) String dtnoraPaisId_,
			@RequestParam(value = "dtnoraProvinciaId", required = false) String dtnoraProvinciaId_,
			@RequestParam(value = "dtnoraMunicipioId", required = false) String dtnoraMunicipioId_,
			@RequestParam(value = "dtnoraLocalidadId", required = false) String dtnoraLocalidadId_,
			@RequestParam(value = "dtdireccion_nocapv", required = false) String dtdireccion_nocapv_,
			HttpServletRequest request, Model model) {
		try {

			Establecimiento establecimiento = new Establecimiento();
			Saninterv saninterv = new Saninterv();

			// est
			String esextranjero = null;
			String esestado = null;
			String esnoraPaisId = null;
			String esnoraProvinciaId = null;
			String esnoraMunicipioId = null;
			String esnoraLocalidadId = null;
			String esdireccion_nocapv = null;

			if (Y41bConstantes.NORA_LOCALIZACION_TODOS.equals(esextranjero_)) {
				esextranjero = null;
				esnoraPaisId = null;
				esestado = null;
				esnoraProvinciaId = null;
				esnoraMunicipioId = null;
				esnoraLocalidadId = null;
				esdireccion_nocapv = null;
			} else if (Y41bConstantes.NORA_LOCALIZACION_EXTRANJERO
					.equals(esextranjero_)) {
				esextranjero = Y41bConstantes.VALOR_SI;
				esnoraPaisId = ("".equals(esnoraPaisId_)) ? null
						: esnoraPaisId_;
				esestado = null;
				esnoraProvinciaId = null;
				esnoraMunicipioId = null;
				esnoraLocalidadId = null;
				esdireccion_nocapv = ("".equals(esdireccion_nocapv_)) ? null
						: esdireccion_nocapv_;

			} else if (Y41bConstantes.NORA_LOCALIZACION_ESTADO
					.equals(esextranjero_)) {
				esextranjero = null;
				esnoraPaisId = null;
				esestado = Y41bConstantes.VALOR_SI;
				esnoraProvinciaId = ("".equals(esnoraProvinciaId_)) ? null
						: esnoraProvinciaId_;
				esnoraMunicipioId = ("".equals(esnoraMunicipioId_)) ? null
						: esnoraMunicipioId_;
				esnoraLocalidadId = ("".equals(esnoraLocalidadId_)) ? null
						: esnoraLocalidadId_;
				esdireccion_nocapv = ("".equals(esdireccion_nocapv_)) ? null
						: esdireccion_nocapv_;
			}

			if (!Y41bUtils.esNullOCadenaVacia(escodigo_)) {
				establecimiento.setEscodigo(escodigo_);
			}
			if (!Y41bUtils.esNullOCadenaVacia(esnombre_)) {
				establecimiento.setEsnombre(esnombre_);
			}
			if (!Y41bUtils.esNullOCadenaVacia(esnif_)) {
				establecimiento.setEsnif(esnif_);
			}
			if (!Y41bUtils.esNullOCadenaVacia(esnoco_)) {
				establecimiento.setEsnoco(esnoco_);
			}
			// String esextranjero = ("on".equals(esextranjero_)) ?
			// Y41bConstantes.VALOR_SI
			// : null;
			// String esestado = ("on".equals(esestado_)) ?
			// Y41bConstantes.VALOR_SI
			// : null;
			if (!Y41bUtils.esNullOCadenaVacia(esextranjero)) {
				establecimiento.setEsextranjero(esextranjero);
			}
			if (!Y41bUtils.esNullOCadenaVacia(esestado)) {
				establecimiento.setEsestado(esestado);
			}
			if (!Y41bUtils.esNullOCadenaVacia(esnoraPaisId)) {
				establecimiento.setEsnoraPaisId(esnoraPaisId);
			}
			if (!Y41bUtils.esNullOCadenaVacia(esnoraProvinciaId)) {
				establecimiento.setEsnoraProvinciaId(esnoraProvinciaId);
			}
			if (!Y41bUtils.esNullOCadenaVacia(esnoraMunicipioId)) {
				establecimiento.setEsnoraMunicipioId(esnoraMunicipioId);
			}
			if (!Y41bUtils.esNullOCadenaVacia(esnoraLocalidadId)) {
				establecimiento.setEsnoraLocalidadId(esnoraLocalidadId);
			}
			if (!Y41bUtils.esNullOCadenaVacia(esdireccion_nocapv)) {
				establecimiento.setEsdireccion_nocapv(esdireccion_nocapv);
			}
			/*
			 * StringBuffer nombre = new StringBuffer(); if
			 * (!Y41bUtils.esNullOCadenaVacia(dtnombre_)) { nombre =
			 * nombre.append(dtnombre_); } if
			 * (!Y41bUtils.esNullOCadenaVacia(dtapellido1_)) { nombre =
			 * nombre.append(" ").append(dtapellido1_); } if
			 * (!Y41bUtils.esNullOCadenaVacia(dtapellido2_)) { nombre =
			 * nombre.append(" ").append(dtapellido2_); } if (nombre.length() >
			 * 0) { saninterv.setUanombre(nombre.toString()); }
			 */
			if (!Y41bUtils.esNullOCadenaVacia(dtcodigo_)) {
				saninterv.setUadtcodigo(dtcodigo_);
			}
			if (!Y41bUtils.esNullOCadenaVacia(dtnombre_)) {
				saninterv.setUanombre(dtnombre_);
			}
			if (!Y41bUtils.esNullOCadenaVacia(dtapellido1_)) {
				saninterv.setUaapellido1(dtapellido1_);
			}
			if (!Y41bUtils.esNullOCadenaVacia(dtapellido2_)) {
				saninterv.setUaapellido2(dtapellido2_);
			}
			if (!Y41bUtils.esNullOCadenaVacia(dtnif_)) {
				saninterv.setUanif(dtnif_);
			}

			// cons
			String dtextranjero = null;
			String dtestado = null;
			String dtnoraPaisId = null;
			String dtnoraProvinciaId = null;
			String dtnoraMunicipioId = null;
			String dtnoraLocalidadId = null;
			String dtdireccion_nocapv = null;

			if (Y41bConstantes.NORA_LOCALIZACION_TODOS.equals(dtextranjero_)) {
				dtextranjero = null;
				dtnoraPaisId = null;
				dtestado = null;
				dtnoraProvinciaId = null;
				dtnoraMunicipioId = null;
				dtnoraLocalidadId = null;
				dtdireccion_nocapv = null;
			} else if (Y41bConstantes.NORA_LOCALIZACION_EXTRANJERO
					.equals(dtextranjero_)) {
				dtextranjero = Y41bConstantes.VALOR_SI;
				dtnoraPaisId = ("".equals(dtnoraPaisId_)) ? null
						: dtnoraPaisId_;
				dtestado = null;
				dtnoraProvinciaId = null;
				dtnoraMunicipioId = null;
				dtnoraLocalidadId = null;
				dtdireccion_nocapv = ("".equals(dtdireccion_nocapv_)) ? null
						: dtdireccion_nocapv_;

			} else if (Y41bConstantes.NORA_LOCALIZACION_ESTADO
					.equals(dtextranjero_)) {
				dtextranjero = null;
				dtnoraPaisId = null;
				dtestado = Y41bConstantes.VALOR_SI;
				dtnoraProvinciaId = ("".equals(dtnoraProvinciaId_)) ? null
						: dtnoraProvinciaId_;
				dtnoraMunicipioId = ("".equals(dtnoraMunicipioId_)) ? null
						: dtnoraMunicipioId_;
				dtnoraLocalidadId = ("".equals(dtnoraLocalidadId_)) ? null
						: dtnoraLocalidadId_;
				dtdireccion_nocapv = ("".equals(dtdireccion_nocapv_)) ? null
						: dtdireccion_nocapv_;
			}
			//

			// String dtextranjero = ("on".equals(dtextranjero_)) ?
			// Y41bConstantes.VALOR_SI
			// : null;
			// String dtestado = ("on".equals(dtestado_)) ?
			// Y41bConstantes.VALOR_SI
			// : null;
			if (!Y41bUtils.esNullOCadenaVacia(dtextranjero)) {
				saninterv.setUaextranjero(dtextranjero);
			}
			if (!Y41bUtils.esNullOCadenaVacia(dtestado)) {
				saninterv.setUaestado(dtestado);
			}
			if (!Y41bUtils.esNullOCadenaVacia(dtnoraProvinciaId)) {
				saninterv.setUaprovId(dtnoraProvinciaId);
			}
			if (!Y41bUtils.esNullOCadenaVacia(dtnoraMunicipioId)) {
				saninterv.setUamunId(dtnoraMunicipioId);
			}
			if (!Y41bUtils.esNullOCadenaVacia(dtnoraLocalidadId)) {
				saninterv.setUalocId(dtnoraLocalidadId);
			}
			if (!Y41bUtils.esNullOCadenaVacia(dtnoraPaisId)) {
				saninterv.setUapaisId(dtnoraPaisId);
			}
			if (!Y41bUtils.esNullOCadenaVacia(dtdireccion_nocapv)) {
				saninterv.setUadireNocapv(dtdireccion_nocapv);
			}
			FiltroSanciones filtroSanciones = new FiltroSanciones(
					establecimiento, saninterv);

			if (esnoraPaisId != null) {
				logger.info("Busqueda combinada:esnoraPaisId:" + esnoraPaisId
						+ ".");
			} else {
				logger.info("Busqueda combinada:esnoraPaisId: NULO..");
			}

			if (dtextranjero != null) {
				logger.info("Busqueda combinada:dtextranjero:" + dtextranjero
						+ ".");
			} else {
				logger.info("Busqueda combinada:dtextranjero: NULO..");
			}

			BusquedaCombinada filterBusquedaCombinada = new BusquedaCombinada(
					esnombre_, esnif_, esnoco_, esextranjero, esestado,
					esnoraPaisId, esnoraProvinciaId, esnoraMunicipioId,
					esnoraLocalidadId, esdireccion_nocapv, dtnombre_,
					dtapellido1_, dtapellido2_, dtnif_, dtextranjero, dtestado,
					dtnoraPaisId, dtnoraProvinciaId, dtnoraMunicipioId,
					dtnoraLocalidadId, dtdireccion_nocapv);
			filterBusquedaCombinada.setDtcodigo(dtcodigo_);
			filterBusquedaCombinada.setEscodigo(escodigo_);

			model.addAttribute("busquedacombinada", filterBusquedaCombinada);

			HttpSession httpSession = request.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			censoMonitor = censoMonitorService.find(censoMonitor);
			String perfil = censoMonitor.getPerfilSanciones().getIdPerfil();
			if (perfil != null
					&& Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO
							.equals(perfil)) {
				// Si perfil sin acceso devolvemos listado vacio
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(0);
				data.setTotal(0L, 0L);
				data.setRows(new ArrayList<FiltroSanciones>());
				return data;
			}

			Pagination pagination = new Pagination();
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<FiltroSanciones> sancionesBusqueda = this.expedienService
						.findAllLikeSancionesBusquedaCombinada(filtroSanciones,
								pagination, false);

				if (sancionesBusqueda == null) {
					throw new Exception("No data Found.");
				}

				Long totalSanciones = this.expedienService
						.findAllLikeSancionesBusquedaCombinadaCount(
								filtroSanciones, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(totalSanciones.intValue());
				data.setTotal(totalSanciones, pagination.getRows());
				data.setRows(sancionesBusqueda);
				return data;
			} else {
				List<FiltroSanciones> sancionesBusqueda = this.expedienService
						.findAllLikeSancionesBusquedaCombinada(filtroSanciones,
								pagination, false);
				if (sancionesBusqueda == null) {
					throw new Exception("No data Found.");
				}
				return sancionesBusqueda;
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllSanciones'.
	 * 
	 * @param escodigo_
	 *            String
	 * @param esnombre_
	 *            String
	 * @param esnif_
	 *            String
	 * @param esnoco_
	 *            String
	 * @param esextranjero_
	 *            String
	 * @param esestado_
	 *            String
	 * @param esnoraPaisId_
	 *            String
	 * @param esnoraProvinciaId_
	 *            String
	 * @param esnoraMunicipioId_
	 *            String
	 * @param esnoraLocalidadId_
	 *            String
	 * @param esdireccion_nocapv_
	 *            String
	 * @param dtcodigo_
	 *            String
	 * @param dtnombre_
	 *            String
	 * @param dtapellido1_
	 *            String
	 * @param dtapellido2_
	 *            String
	 * @param dtnif_
	 *            String
	 * @param dtextranjero_
	 *            String
	 * @param dtestado_
	 *            String
	 * @param dtnoraPaisId_
	 *            String
	 * @param dtnoraProvinciaId_
	 *            String
	 * @param dtnoraMunicipioId_
	 *            String
	 * @param dtnoraLocalidadId_
	 *            String
	 * @param dtdireccion_nocapv_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/busquedaArbitrajes", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllArbitrajes(
			@RequestParam(value = "escodigo", required = false) String escodigo_, /* nuevo */
			@RequestParam(value = "esnombre", required = false) String esnombre_,
			@RequestParam(value = "esnif", required = false) String esnif_,
			@RequestParam(value = "esnoco", required = false) String esnoco_,
			@RequestParam(value = "esextranjero", required = false) String esextranjero_,
			@RequestParam(value = "esestado", required = false) String esestado_,
			@RequestParam(value = "esnoraPaisId", required = false) String esnoraPaisId_,
			@RequestParam(value = "esnoraProvinciaId", required = false) String esnoraProvinciaId_,
			@RequestParam(value = "esnoraMunicipioId", required = false) String esnoraMunicipioId_,
			@RequestParam(value = "esnoraLocalidadId", required = false) String esnoraLocalidadId_,
			@RequestParam(value = "esdireccion_nocapv", required = false) String esdireccion_nocapv_,
			@RequestParam(value = "dtcodigo", required = false) String dtcodigo_, /* nuevo */
			@RequestParam(value = "dtnombre", required = false) String dtnombre_,
			@RequestParam(value = "dtapellido1", required = false) String dtapellido1_,
			@RequestParam(value = "dtapellido2", required = false) String dtapellido2_,
			@RequestParam(value = "dtnif", required = false) String dtnif_,
			@RequestParam(value = "dtextranjero", required = false) String dtextranjero_,
			@RequestParam(value = "dtestado", required = false) String dtestado_,
			@RequestParam(value = "dtnoraPaisId", required = false) String dtnoraPaisId_,
			@RequestParam(value = "dtnoraProvinciaId", required = false) String dtnoraProvinciaId_,
			@RequestParam(value = "dtnoraMunicipioId", required = false) String dtnoraMunicipioId_,
			@RequestParam(value = "dtnoraLocalidadId", required = false) String dtnoraLocalidadId_,
			@RequestParam(value = "dtdireccion_nocapv", required = false) String dtdireccion_nocapv_,
			HttpServletRequest request, Model model) {
		try {

			Arbinterv arbintervReclamado = new Arbinterv();

			// est
			String esextranjero = null;
			String esestado = null;
			String esnoraPaisId = null;
			String esnoraProvinciaId = null;
			String esnoraMunicipioId = null;
			String esnoraLocalidadId = null;
			String esdireccion_nocapv = null;

			if (Y41bConstantes.NORA_LOCALIZACION_TODOS.equals(esextranjero_)) {
				esextranjero = null;
				esnoraPaisId = null;
				esestado = null;
				esnoraProvinciaId = null;
				esnoraMunicipioId = null;
				esnoraLocalidadId = null;
				esdireccion_nocapv = null;
			} else if (Y41bConstantes.NORA_LOCALIZACION_EXTRANJERO
					.equals(esextranjero_)) {
				esextranjero = Y41bConstantes.VALOR_SI;
				esnoraPaisId = ("".equals(esnoraPaisId_)) ? null
						: esnoraPaisId_;
				esestado = null;
				esnoraProvinciaId = null;
				esnoraMunicipioId = null;
				esnoraLocalidadId = null;
				esdireccion_nocapv = ("".equals(esdireccion_nocapv_)) ? null
						: esdireccion_nocapv_;

			} else if (Y41bConstantes.NORA_LOCALIZACION_ESTADO
					.equals(esextranjero_)) {
				esextranjero = null;
				esnoraPaisId = null;
				esestado = Y41bConstantes.VALOR_SI;
				esnoraProvinciaId = ("".equals(esnoraProvinciaId_)) ? null
						: esnoraProvinciaId_;
				esnoraMunicipioId = ("".equals(esnoraMunicipioId_)) ? null
						: esnoraMunicipioId_;
				esnoraLocalidadId = ("".equals(esnoraLocalidadId_)) ? null
						: esnoraLocalidadId_;
				esdireccion_nocapv = ("".equals(esdireccion_nocapv_)) ? null
						: esdireccion_nocapv_;
			}

			if (!Y41bUtils.esNullOCadenaVacia(escodigo_)) {
				arbintervReclamado.setUaescodigo(escodigo_);
			}
			if (!Y41bUtils.esNullOCadenaVacia(esnombre_)) {
				arbintervReclamado.setUanombre(esnombre_);
			}
			if (!Y41bUtils.esNullOCadenaVacia(esnif_)) {
				arbintervReclamado.setUanif(esnif_);
			}
			if (!Y41bUtils.esNullOCadenaVacia(esnoco_)) {
				arbintervReclamado.setUanoco(esnoco_);
			}
			if (!Y41bUtils.esNullOCadenaVacia(esextranjero)) {
				arbintervReclamado.setUaextranjero(esextranjero);
			}
			if (!Y41bUtils.esNullOCadenaVacia(esestado)) {
				arbintervReclamado.setUaestado(esestado);
			}
			if (!Y41bUtils.esNullOCadenaVacia(esnoraPaisId)) {
				arbintervReclamado.setUapaisId(esnoraPaisId);
			}
			if (!Y41bUtils.esNullOCadenaVacia(esnoraProvinciaId)) {
				arbintervReclamado.setUaprovId(esnoraProvinciaId);
			}
			if (!Y41bUtils.esNullOCadenaVacia(esnoraMunicipioId)) {
				arbintervReclamado.setUamunId(esnoraMunicipioId);
			}
			if (!Y41bUtils.esNullOCadenaVacia(esnoraLocalidadId)) {
				arbintervReclamado.setUalocId(esnoraLocalidadId);
			}
			if (!Y41bUtils.esNullOCadenaVacia(esdireccion_nocapv)) {
				arbintervReclamado.setUadireNocapv(esdireccion_nocapv);
			}

			Arbinterv arbintervReclamante = new Arbinterv();

			if (!Y41bUtils.esNullOCadenaVacia(dtcodigo_)) {
				arbintervReclamante.setUadtcodigo(dtcodigo_);
			}
			if (!Y41bUtils.esNullOCadenaVacia(dtnombre_)) {
				arbintervReclamante.setUanombre(dtnombre_);
			}
			if (!Y41bUtils.esNullOCadenaVacia(dtapellido1_)) {
				arbintervReclamante.setUaapellido1(dtapellido1_);
			}
			if (!Y41bUtils.esNullOCadenaVacia(dtapellido2_)) {
				arbintervReclamante.setUaapellido2(dtapellido2_);
			}
			if (!Y41bUtils.esNullOCadenaVacia(dtnif_)) {
				arbintervReclamante.setUanif(dtnif_);
			}

			// cons
			String dtextranjero = null;
			String dtestado = null;
			String dtnoraPaisId = null;
			String dtnoraProvinciaId = null;
			String dtnoraMunicipioId = null;
			String dtnoraLocalidadId = null;
			String dtdireccion_nocapv = null;

			if (Y41bConstantes.NORA_LOCALIZACION_TODOS.equals(dtextranjero_)) {
				dtextranjero = null;
				dtnoraPaisId = null;
				dtestado = null;
				dtnoraProvinciaId = null;
				dtnoraMunicipioId = null;
				dtnoraLocalidadId = null;
				dtdireccion_nocapv = null;
			} else if (Y41bConstantes.NORA_LOCALIZACION_EXTRANJERO
					.equals(dtextranjero_)) {
				dtextranjero = Y41bConstantes.VALOR_SI;
				dtnoraPaisId = ("".equals(dtnoraPaisId_)) ? null
						: dtnoraPaisId_;
				dtestado = null;
				dtnoraProvinciaId = null;
				dtnoraMunicipioId = null;
				dtnoraLocalidadId = null;
				dtdireccion_nocapv = ("".equals(dtdireccion_nocapv_)) ? null
						: dtdireccion_nocapv_;

			} else if (Y41bConstantes.NORA_LOCALIZACION_ESTADO
					.equals(dtextranjero_)) {
				dtextranjero = null;
				dtnoraPaisId = null;
				dtestado = Y41bConstantes.VALOR_SI;
				dtnoraProvinciaId = ("".equals(dtnoraProvinciaId_)) ? null
						: dtnoraProvinciaId_;
				dtnoraMunicipioId = ("".equals(dtnoraMunicipioId_)) ? null
						: dtnoraMunicipioId_;
				dtnoraLocalidadId = ("".equals(dtnoraLocalidadId_)) ? null
						: dtnoraLocalidadId_;
				dtdireccion_nocapv = ("".equals(dtdireccion_nocapv_)) ? null
						: dtdireccion_nocapv_;
			}

			if (!Y41bUtils.esNullOCadenaVacia(dtextranjero)) {
				arbintervReclamante.setUaextranjero(dtextranjero);
			}
			if (!Y41bUtils.esNullOCadenaVacia(dtestado)) {
				arbintervReclamante.setUaestado(dtestado);
			}
			if (!Y41bUtils.esNullOCadenaVacia(dtnoraProvinciaId)) {
				arbintervReclamante.setUaprovId(dtnoraProvinciaId);
			}
			if (!Y41bUtils.esNullOCadenaVacia(dtnoraMunicipioId)) {
				arbintervReclamante.setUamunId(dtnoraMunicipioId);
			}
			if (!Y41bUtils.esNullOCadenaVacia(dtnoraLocalidadId)) {
				arbintervReclamante.setUalocId(dtnoraLocalidadId);
			}
			if (!Y41bUtils.esNullOCadenaVacia(dtnoraPaisId)) {
				arbintervReclamante.setUapaisId(dtnoraPaisId);
			}
			if (!Y41bUtils.esNullOCadenaVacia(dtdireccion_nocapv)) {
				arbintervReclamante.setUadireNocapv(dtdireccion_nocapv);
			}
			FiltroArbitraje filtroArbitraje = new FiltroArbitraje(
					arbintervReclamado, arbintervReclamante);

			if (esnoraPaisId != null) {
				logger.info("Busqueda combinada:esnoraPaisId:" + esnoraPaisId
						+ ".");
			} else {
				logger.info("Busqueda combinada:esnoraPaisId: NULO..");
			}

			if (dtextranjero != null) {
				logger.info("Busqueda combinada:dtextranjero:" + dtextranjero
						+ ".");
			} else {
				logger.info("Busqueda combinada:dtextranjero: NULO..");
			}

			BusquedaCombinada filterBusquedaCombinada = new BusquedaCombinada(
					esnombre_, esnif_, esnoco_, esextranjero, esestado,
					esnoraPaisId, esnoraProvinciaId, esnoraMunicipioId,
					esnoraLocalidadId, esdireccion_nocapv, dtnombre_,
					dtapellido1_, dtapellido2_, dtnif_, dtextranjero, dtestado,
					dtnoraPaisId, dtnoraProvinciaId, dtnoraMunicipioId,
					dtnoraLocalidadId, dtdireccion_nocapv);
			filterBusquedaCombinada.setDtcodigo(dtcodigo_);
			filterBusquedaCombinada.setEscodigo(escodigo_);

			model.addAttribute("busquedacombinada", filterBusquedaCombinada);

			HttpSession httpSession = request.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			censoMonitor = censoMonitorService.find(censoMonitor);
			String perfil = censoMonitor.getPerfilArbitraje().getIdPerfil();
			if (perfil != null
					&& Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO
							.equals(perfil)) {
				// Si perfil sin acceso devolvemos listado vacio
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(0);
				data.setTotal(0L, 0L);
				data.setRows(new ArrayList<FiltroArbitraje>());
				return data;
			}

			Pagination pagination = new Pagination();
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<FiltroArbitraje> arbitrajeBusqueda = this.solarbService
						.findAllLikeArbitrajesBusquedaCombinada(
								filtroArbitraje, pagination, false);

				if (arbitrajeBusqueda == null) {
					throw new Exception("No data Found.");
				}

				Long totalArbitrajes = this.solarbService
						.findAllLikeArbitrajesBusquedaCombinadaCount(
								filtroArbitraje, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(totalArbitrajes.intValue());
				data.setTotal(totalArbitrajes, pagination.getRows());
				data.setRows(arbitrajeBusqueda);
				return data;
			} else {
				List<FiltroArbitraje> arbitrajeBusqueda = this.solarbService
						.findAllLikeArbitrajesBusquedaCombinada(
								filtroArbitraje, pagination, false);
				if (arbitrajeBusqueda == null) {
					throw new Exception("No data Found.");
				}
				return arbitrajeBusqueda;
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllInspecciones'.
	 * 
	 * @param escodigo_
	 *            String
	 * @param esnombre_
	 *            String
	 * @param esnif_
	 *            String
	 * @param esnoco_
	 *            String
	 * @param esextranjero_
	 *            String
	 * @param esestado_
	 *            String
	 * @param esnoraPaisId_
	 *            String
	 * @param esnoraProvinciaId_
	 *            String
	 * @param esnoraMunicipioId_
	 *            String
	 * @param esnoraLocalidadId_
	 *            String
	 * @param esdireccion_nocapv_
	 *            String
	 * @param dtcodigo_
	 *            String
	 * @param dtnombre_
	 *            String
	 * @param dtapellido1_
	 *            String
	 * @param dtapellido2_
	 *            String
	 * @param dtnif_
	 *            String
	 * @param dtextranjero_
	 *            String
	 * @param dtestado_
	 *            String
	 * @param dtnoraPaisId_
	 *            String
	 * @param dtnoraProvinciaId_
	 *            String
	 * @param dtnoraMunicipioId_
	 *            String
	 * @param dtnoraLocalidadId_
	 *            String
	 * @param dtdireccion_nocapv_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/busquedaInspecciones", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllInspecciones(
			@RequestParam(value = "escodigo", required = false) String escodigo_,
			@RequestParam(value = "esnombre", required = false) String esnombre_,
			@RequestParam(value = "esnif", required = false) String esnif_,
			@RequestParam(value = "esnoco", required = false) String esnoco_,
			@RequestParam(value = "esextranjero", required = false) String esextranjero_,
			@RequestParam(value = "esestado", required = false) String esestado_,
			@RequestParam(value = "esnoraPaisId", required = false) String esnoraPaisId_,
			@RequestParam(value = "esnoraProvinciaId", required = false) String esnoraProvinciaId_,
			@RequestParam(value = "esnoraMunicipioId", required = false) String esnoraMunicipioId_,
			@RequestParam(value = "esnoraLocalidadId", required = false) String esnoraLocalidadId_,
			@RequestParam(value = "esdireccion_nocapv", required = false) String esdireccion_nocapv_,
			@RequestParam(value = "dtcodigo", required = false) String dtcodigo_,
			@RequestParam(value = "dtnombre", required = false) String dtnombre_,
			@RequestParam(value = "dtapellido1", required = false) String dtapellido1_,
			@RequestParam(value = "dtapellido2", required = false) String dtapellido2_,
			@RequestParam(value = "dtnif", required = false) String dtnif_,
			@RequestParam(value = "dtextranjero", required = false) String dtextranjero_,
			@RequestParam(value = "dtestado", required = false) String dtestado_,
			@RequestParam(value = "dtnoraPaisId", required = false) String dtnoraPaisId_,
			@RequestParam(value = "dtnoraProvinciaId", required = false) String dtnoraProvinciaId_,
			@RequestParam(value = "dtnoraMunicipioId", required = false) String dtnoraMunicipioId_,
			@RequestParam(value = "dtnoraLocalidadId", required = false) String dtnoraLocalidadId_,
			@RequestParam(value = "dtdireccion_nocapv", required = false) String dtdireccion_nocapv_,
			HttpServletRequest request, Model model) {
		try {

			// est
			String esextranjero = null;
			String esestado = null;
			String esnoraPaisId = null;
			String esnoraProvinciaId = null;
			String esnoraMunicipioId = null;
			String esnoraLocalidadId = null;
			String esdireccion_nocapv = null;

			if (Y41bConstantes.NORA_LOCALIZACION_TODOS.equals(esextranjero_)) {
				esextranjero = null;
				esnoraPaisId = null;
				esestado = null;
				esnoraProvinciaId = null;
				esnoraMunicipioId = null;
				esnoraLocalidadId = null;
				esdireccion_nocapv = null;
			} else if (Y41bConstantes.NORA_LOCALIZACION_EXTRANJERO
					.equals(esextranjero_)) {
				esextranjero = Y41bConstantes.VALOR_SI;
				esnoraPaisId = ("".equals(esnoraPaisId_)) ? null
						: esnoraPaisId_;
				esestado = null;
				esnoraProvinciaId = null;
				esnoraMunicipioId = null;
				esnoraLocalidadId = null;
				esdireccion_nocapv = ("".equals(esdireccion_nocapv_)) ? null
						: esdireccion_nocapv_;

			} else if (Y41bConstantes.NORA_LOCALIZACION_ESTADO
					.equals(esextranjero_)) {
				esextranjero = null;
				esnoraPaisId = null;
				esestado = Y41bConstantes.VALOR_SI;
				esnoraProvinciaId = ("".equals(esnoraProvinciaId_)) ? null
						: esnoraProvinciaId_;
				esnoraMunicipioId = ("".equals(esnoraMunicipioId_)) ? null
						: esnoraMunicipioId_;
				esnoraLocalidadId = ("".equals(esnoraLocalidadId_)) ? null
						: esnoraLocalidadId_;
				esdireccion_nocapv = ("".equals(esdireccion_nocapv_)) ? null
						: esdireccion_nocapv_;
			}

			// cons
			String dtextranjero = null;
			String dtestado = null;
			String dtnoraPaisId = null;
			String dtnoraProvinciaId = null;
			String dtnoraMunicipioId = null;
			String dtnoraLocalidadId = null;
			String dtdireccion_nocapv = null;

			if (Y41bConstantes.NORA_LOCALIZACION_TODOS.equals(dtextranjero_)) {
				dtextranjero = null;
				dtnoraPaisId = null;
				dtestado = null;
				dtnoraProvinciaId = null;
				dtnoraMunicipioId = null;
				dtnoraLocalidadId = null;
				dtdireccion_nocapv = null;
			} else if (Y41bConstantes.NORA_LOCALIZACION_EXTRANJERO
					.equals(dtextranjero_)) {
				dtextranjero = Y41bConstantes.VALOR_SI;
				dtnoraPaisId = ("".equals(dtnoraPaisId_)) ? null
						: dtnoraPaisId_;
				dtestado = null;
				dtnoraProvinciaId = null;
				dtnoraMunicipioId = null;
				dtnoraLocalidadId = null;
				dtdireccion_nocapv = ("".equals(dtdireccion_nocapv_)) ? null
						: dtdireccion_nocapv_;

			} else if (Y41bConstantes.NORA_LOCALIZACION_ESTADO
					.equals(dtextranjero_)) {
				dtextranjero = null;
				dtnoraPaisId = null;
				dtestado = Y41bConstantes.VALOR_SI;
				dtnoraProvinciaId = ("".equals(dtnoraProvinciaId_)) ? null
						: dtnoraProvinciaId_;
				dtnoraMunicipioId = ("".equals(dtnoraMunicipioId_)) ? null
						: dtnoraMunicipioId_;
				dtnoraLocalidadId = ("".equals(dtnoraLocalidadId_)) ? null
						: dtnoraLocalidadId_;
				dtdireccion_nocapv = ("".equals(dtdireccion_nocapv_)) ? null
						: dtdireccion_nocapv_;
			}
			//

			String dtcodigo = ("".equals(dtcodigo_)) ? null : dtcodigo_;
			String dtnombre = ("".equals(dtnombre_)) ? null : dtnombre_;
			String dtapellido1 = ("".equals(dtapellido1_)) ? null
					: dtapellido1_;
			String dtapellido2 = ("".equals(dtapellido2_)) ? null
					: dtapellido2_;
			String dtnif = ("".equals(dtnif_)) ? null : dtnif_;

			String escodigo = ("".equals(escodigo_)) ? null : escodigo_;
			String esnombre = ("".equals(esnombre_)) ? null : esnombre_;
			String esnif = ("".equals(esnif_)) ? null : esnif_;
			String esnoco = ("".equals(esnoco_)) ? null : esnoco_;

			BusquedaCombinada filterBusquedaCombinada = new BusquedaCombinada(
					esnombre, esnif, esnoco, esextranjero, esestado,
					esnoraPaisId, esnoraProvinciaId, esnoraMunicipioId,
					esnoraLocalidadId, esdireccion_nocapv, dtnombre,
					dtapellido1, dtapellido2, dtnif, dtextranjero, dtestado,
					dtnoraPaisId, dtnoraProvinciaId, dtnoraMunicipioId,
					dtnoraLocalidadId, dtdireccion_nocapv);
			filterBusquedaCombinada.setDtcodigo(dtcodigo);
			filterBusquedaCombinada.setEscodigo(escodigo);

			model.addAttribute("busquedacombinada", filterBusquedaCombinada);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<BusquedaInspeccion> inspeccionesBusqueda = this.actaService
						.findAllLikeInspeccionesBusquedaCombinada(
								filterBusquedaCombinada, pagination);

				if (inspeccionesBusqueda == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.actaService
						.findAllLikeInspeccionesBusquedaCombinadaCount(
								filterBusquedaCombinada, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(inspeccionesBusqueda);
				return data;
			} else {
				List<BusquedaInspeccion> inspeccionesBusqueda = this.actaService
						.findAllLikeInspeccionesBusquedaCombinada(
								filterBusquedaCombinada, pagination);
				if (inspeccionesBusqueda == null) {
					throw new Exception("No data Found.");
				}
				return inspeccionesBusqueda;
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}
}
