package com.ejie.y41b.control;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.adapter.Y41bPifAdapterService;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.BandejaSolicitudes;
import com.ejie.y41b.model.BandejaSolicitudesBusqueda;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.DocumentoHechoDetalle;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteHechoDetalle;
import com.ejie.y41b.model.TramiteHechoModal;
import com.ejie.y41b.service.BandejaSolicitudesService;
import com.ejie.y41b.service.DenunciaService;
import com.ejie.y41b.service.Y41bExcelGeneratorService;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * BandejaSolicitudesController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/bandejasolicitudes")
@SessionAttributes({ "idTramiteHechoSolicitud", "idHechoDenunciado" })
public class BandejaSolicitudesController {

	private static final Logger logger = LoggerFactory.getLogger(BandejaSolicitudesController.class);

	@Autowired
	private BandejaSolicitudesService bandejaSolicitudesService;

	@Autowired
	private DenunciaService denunciaService;

	@Autowired
	private Properties appConfiguration;

	@Autowired
	private Y41bExcelGeneratorService y41bExcelGeneratorService;

	@Autowired()
	private Y41bPifAdapterService y41bPifAdapterService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		BandejaSolicitudesController.logger.info("[GET - View] : bandejasolicitudes");
		return "bandejasolicitudes";
	}

	/**
	 * Method 'getDocumentosTramiteForm'.
	 * 
	 * @param idTramite
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "documentosTramite/{idTramite}", method = RequestMethod.GET)
	public ModelAndView getDocumentosTramiteForm(@PathVariable String idTramite, Model model) {

		model.addAttribute("idTramiteHechoSolicitud", idTramite);

		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("documentosTramite", "model", model);
	}

	/**
	 * Method 'getDocumentosTramiteForm'.
	 * 
	 * @param idHechoDenunciado
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "tramitesPendientes/{idHechoDenunciado}", method = RequestMethod.GET)
	public ModelAndView getTramitesPendientesForm(@PathVariable String idHechoDenunciado, Model model) {

		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(idHechoDenunciado);
		solicitudDetalle = this.denunciaService.findNumExpedienteSolicitud(solicitudDetalle);

		model.addAttribute("idHechoDenunciado", idHechoDenunciado);
		model.addAttribute("numExpedienteHechoDenunciado", solicitudDetalle.getNumExpediente());

		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("tramitesPendientes", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param ehcodigo
	 *            String
	 * @return bandejaSolicitudes BandejaSolicitudes
	 */
	@RequestMapping(value = "/{ehcodigo}", method = RequestMethod.GET)
	public @ResponseBody BandejaSolicitudes getById(@PathVariable String ehcodigo) {
		BandejaSolicitudes bandejaSolicitudes = new BandejaSolicitudes();
		bandejaSolicitudes.setEhcodigo(ehcodigo);
		bandejaSolicitudes = this.bandejaSolicitudesService.find(bandejaSolicitudes);
		BandejaSolicitudesController.logger.info("[GET - findBy_PK] : Obtener BandejaSolicitudes por PK");
		return bandejaSolicitudes;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterBandejaSolicitudes
	 *            BandejaSolicitudes
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<BandejaSolicitudes> getAll(@ModelAttribute BandejaSolicitudes filterBandejaSolicitudes) {
		BandejaSolicitudesController.logger.info("[GET - find_ALL] : Obtener BandejaSolicitudes por filtro");
		return this.bandejaSolicitudesService.findAll(filterBandejaSolicitudes, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @return BandejaSolicitudes
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody BandejaSolicitudes edit(@RequestBody BandejaSolicitudes bandejaSolicitudes) {
		BandejaSolicitudes bandejaSolicitudesAux = this.bandejaSolicitudesService.update(bandejaSolicitudes);
		BandejaSolicitudesController.logger.info("[PUT] : BandejaSolicitudes actualizado correctamente");
		return bandejaSolicitudesAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @return BandejaSolicitudes
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody BandejaSolicitudes add(@RequestBody BandejaSolicitudes bandejaSolicitudes) {
		BandejaSolicitudes bandejaSolicitudesAux = this.bandejaSolicitudesService.add(bandejaSolicitudes);
		BandejaSolicitudesController.logger.info("[POST] : BandejaSolicitudes insertado correctamente");
		return bandejaSolicitudesAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param ehcodigo
	 *            String
	 * @return bandejaSolicitudes
	 */
	@RequestMapping(value = "/{ehcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody BandejaSolicitudes remove(@PathVariable String ehcodigo) {
		BandejaSolicitudes bandejaSolicitudes = new BandejaSolicitudes();
		bandejaSolicitudes.setEhcodigo(ehcodigo);
		this.bandejaSolicitudesService.remove(bandejaSolicitudes);
		BandejaSolicitudesController.logger.info("[DELETE] : BandejaSolicitudes borrado correctamente");
		return bandejaSolicitudes;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param bandejaSolicitudesIds
	 *            List
	 * @return bandejaSolicitudesList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> bandejaSolicitudesIds) {
		List<BandejaSolicitudes> bandejaSolicitudesList = new ArrayList<BandejaSolicitudes>();
		for (List<String> bandejaSolicitudesId : bandejaSolicitudesIds) {
			Iterator<String> iterator = bandejaSolicitudesId.iterator();
			BandejaSolicitudes bandejaSolicitudes = new BandejaSolicitudes(); // NOPMD
																				// -
																				// Objeto
																				// nuevo
																				// en
																				// la
																				// lista
																				// (parametro
																				// del
																				// servicio)
			bandejaSolicitudes.setEhcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
			bandejaSolicitudesList.add(bandejaSolicitudes);
		}
		this.bandejaSolicitudesService.removeMultiple(bandejaSolicitudesList);
		BandejaSolicitudesController.logger.info("[POST - DELETE_ALL] : BandejaSolicitudes borrados correctamente");
		return bandejaSolicitudesIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterBandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute BandejaSolicitudes filterBandejaSolicitudes,
			@ModelAttribute Pagination pagination) {
		List<BandejaSolicitudes> bandejaSolicitudess = this.bandejaSolicitudesService.findAll(filterBandejaSolicitudes,
				pagination);
		Long recordNum = this.bandejaSolicitudesService.findAllCount(filterBandejaSolicitudes);
		BandejaSolicitudesController.logger.info("[GET - jqGrid] : Obtener BandejaSolicitudes");
		return new JQGridJSONModel(pagination, recordNum, bandejaSolicitudess);
	}

	/**
	 * Method 'getAllBandejaSolicitudes'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busquedaBandejaSolicitudes", method = RequestMethod.GET)
	public @ResponseBody Object getAllBandejaSolicitudes(HttpServletRequest request) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaSolicitudes bandejaSolicitudes = new BandejaSolicitudes();

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = null;

				if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
								.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
					listBandejaSolicitudesBusqueda = this.bandejaSolicitudesService
							.findAllBandejaSolicitudes(bandejaSolicitudes, censoMonitor, pagination);

					if (listBandejaSolicitudesBusqueda == null) {
						throw new Exception("No data Found.");
					}
				} else {
					listBandejaSolicitudesBusqueda = new ArrayList<BandejaSolicitudesBusqueda>();
				}

				Long total = new Long(0);
				if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
								.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
					total = this.bandejaSolicitudesService.findAllBandejaSolicitudesCount(bandejaSolicitudes,
							censoMonitor);
				}
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listBandejaSolicitudesBusqueda);
				return data;
			} else {
				List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = null;

				if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
								.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
					listBandejaSolicitudesBusqueda = this.bandejaSolicitudesService
							.findAllBandejaSolicitudes(bandejaSolicitudes, censoMonitor, null);

					if (listBandejaSolicitudesBusqueda == null) {
						throw new Exception("No data Found.");
					}
				} else {
					listBandejaSolicitudesBusqueda = new ArrayList<BandejaSolicitudesBusqueda>();
				}

				return listBandejaSolicitudesBusqueda;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllBandejaSolicitudesCount'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busquedaBandejaSolicitudescount", method = RequestMethod.GET)
	public @ResponseBody Long getAllBandejaSolicitudesCount(HttpServletRequest request) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaSolicitudes bandejaSolicitudes = new BandejaSolicitudes();

			Long total = new Long(0);
			if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
					&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
					&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
							.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
				total = this.bandejaSolicitudesService.findAllBandejaSolicitudesCount(bandejaSolicitudes, censoMonitor);
			}

			return total;
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllDocumentosTramite'.
	 * 
	 * @param idTramite
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllDocumentosTramite", method = RequestMethod.GET)
	public @ResponseBody Object getAllDocumentosTramite(
			@ModelAttribute(value = "idTramiteHechoSolicitud") String idTramite, HttpServletRequest request) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdTramite(idTramite);

			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				List<DocumentoHecho> listDocumentoHecho = null;

				if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null) {
					listDocumentoHecho = this.denunciaService.findAllDocumentosTramite(tramiteComun, null);
				}

				if (listDocumentoHecho == null) {
					throw new Exception("No data Found.");
				}

				JQGridJSONModel data = new JQGridJSONModel();
				data.setRows(listDocumentoHecho);
				return data;
			} else {
				List<DocumentoHecho> listDocumentoHecho = null;

				if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)) {
					listDocumentoHecho = this.denunciaService.findAllDocumentosTramite(tramiteComun, null);
				}
				if (listDocumentoHecho == null) {
					throw new Exception("No data Found.");
				}
				return listDocumentoHecho;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllTramitesPendientes'.
	 * 
	 * @param idSolicitudTramitesPendientes
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllTramitesPendientes", method = RequestMethod.GET)
	public @ResponseBody Object getAllTramitesPendientes(
			@ModelAttribute(value = "idHechoDenunciado") String idSolicitudTramitesPendientes,
			HttpServletRequest request) {
		try {
			TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();
			tramiteHechoDetalle.setHdcodigo(idSolicitudTramitesPendientes);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<TramiteHechoModal> listTramitesPendientesHecho = null;

				BandejaSolicitudes bandejaSolicitudes = new BandejaSolicitudes();
				bandejaSolicitudes.setHdcodigo(idSolicitudTramitesPendientes);
				listTramitesPendientesHecho = this.bandejaSolicitudesService
						.findAllTramitesPendientesSolicitudesBandejas(bandejaSolicitudes, pagination);

				if (listTramitesPendientesHecho == null) {
					throw new Exception("No data Found.");
				}

				Long total = new Long(0);
				total = this.bandejaSolicitudesService
						.findAllTramitesPendientesSolicitudesBandejasCount(bandejaSolicitudes);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listTramitesPendientesHecho);
				return data;
			} else {
				List<TramiteHechoModal> listTramitesPendientesHecho = null;

				BandejaSolicitudes bandejaSolicitudes = new BandejaSolicitudes();
				bandejaSolicitudes.setHdcodigo(idSolicitudTramitesPendientes);
				listTramitesPendientesHecho = this.bandejaSolicitudesService
						.findAllTramitesPendientesSolicitudesBandejas(bandejaSolicitudes, null);

				if (listTramitesPendientesHecho == null) {
					throw new Exception("No data Found.");
				}
				return listTramitesPendientesHecho;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getByIdDocumentoRegistroSolicitud'.
	 * 
	 * @param codocumento
	 *            String
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findDocumento/{codocumento}", method = RequestMethod.GET)
	public @ResponseBody void getByIdDocumentoRegistroSolicitud(@PathVariable String codocumento,
			HttpServletResponse response) {
		try {
			logger.info("getByIdDocumentoRegistroSolicitud - Inicio");
			DocumentoHechoDetalle documentoHechoDetalle = new DocumentoHechoDetalle();
			documentoHechoDetalle.setQ5codocumento(codocumento);

			documentoHechoDetalle = this.denunciaService.findDocumentoHechoSinDocumento(documentoHechoDetalle);

			// si est en dokusi, descargar de dokusi
			if (documentoHechoDetalle != null && documentoHechoDetalle.getQ5iddocumentum() != null
					&& !documentoHechoDetalle.getQ5iddocumentum().equals("")) {
				// DESCARGA EL DOCUMENTO DEL PIF
				BufferedInputStream bIS = this.y41bPifAdapterService.getFile(documentoHechoDetalle.getRutaPif());

				// Cambiamos el objeto Response para visualizar el contenido del
				// archivo
				response.setHeader("Content-Disposition", "attachment; filename=\""
						+ StringEscapeUtils.unescapeHtml(documentoHechoDetalle.getQ5nofile()) + "\"");
				response.setContentType(documentoHechoDetalle.getQ5contenttypefile());
				response.setContentLength(documentoHechoDetalle.getQ5sizefile());

				InputStream is = new BufferedInputStream(bIS);

				int read = 0;
				byte[] bytes = new byte[Y41bConstantes.NUM_1024];
				OutputStream os = response.getOutputStream();

				while ((read = is.read(bytes)) != -1) {
					os.write(bytes, 0, read);
				}

				os.flush();
				os.close();
			} else {
				Blob contenido = documentoHechoDetalle.getQ5datafile();
				byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

				// Cambiamos el objeto Response para visualizar el contenido del
				// archivo
				response.setHeader("Content-Disposition", "attachment; filename=\""
						+ StringEscapeUtils.unescapeHtml(documentoHechoDetalle.getQ5nofile()) + "\"");
				response.setContentType(documentoHechoDetalle.getQ5contenttypefile());
				response.setContentLength(documentoHechoDetalle.getQ5sizefile());
				response.getOutputStream().write(bContenido);

				// Vaciamos el stream
				response.getOutputStream().flush();
			}

			logger.info("getByIdDocumentoRegistroSolicitud - Fin");

		} catch (Exception e) {
			logger.error("Error producido en findDocumento: " + e.getMessage(), e);
			throw new ResourceNotFoundException(codocumento.toString());
		}
	}

	/*---- excel Bandeja-----*/

	/**
	 * Method 'getAllBandejaSolicitudes'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excelBandeja", method = RequestMethod.GET)
	public @ResponseBody void getAllSolicitudExcelBandeja(HttpServletRequest request, HttpServletResponse response) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaSolicitudes bandejaSolicitudes = new BandejaSolicitudes();

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy, "yyyyMMddHHmmss");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_BANDEJA_SOLICITUDES + fechaActual + ".xls";
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(nombre) + "\"");

			String xslString = this.y41bExcelGeneratorService.getSolicitudesExcelBandeja(bandejaSolicitudes,
					censoMonitor);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllBandejaSolicitudesAdministrativoCount'.
	 * 
	 * @param trFechaDesde_
	 *            String
	 * @param trFechaHasta_
	 *            String
	 * @param trcodigo_
	 *            String
	 * @param tfpcodigo_
	 *            String
	 * @param y41bBandejaSolicitudesAdministrativo_CheckExcluirAcuses_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busquedaBandejaSolicitudesAdministrativocount", method = RequestMethod.GET)
	public @ResponseBody Long getAllBandejaSolicitudesAdministrativoCount(
			@RequestParam(value = "trFechaDesde", required = false) String trFechaDesde_,
			@RequestParam(value = "trFechaHasta", required = false) String trFechaHasta_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_,
			@RequestParam(value = "tfpcodigo", required = false) String tfpcodigo_,
			@RequestParam(value = "y41bBandejaSolicitudesAdministrativo_CheckExcluirAcuses", required = false) String y41bBandejaSolicitudesAdministrativo_CheckExcluirAcuses_,
			HttpServletRequest request) {
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date trFechaDesde = Y41bUtils.parseDate(trFechaDesde_, locale);
			Date trFechaHasta = Y41bUtils.parseDate(trFechaHasta_, locale);

			// control checks
			String y41bBandejaSolicitudesAdministrativo_CheckExcluirAcuses = ("on"
					.equals(y41bBandejaSolicitudesAdministrativo_CheckExcluirAcuses_)) ? Y41bConstantes.VALOR_SI
							: Y41bConstantes.VALOR_NO;

			// control de los campos susceptibles de llegar a "" desde el filtro
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;
			String tfpcodigo = ("".equals(tfpcodigo_)) ? null : tfpcodigo_;

			BandejaSolicitudesController.logger.info("desde: " + trFechaDesde + " hasta: " + trFechaHasta
					+ " trcodigo: " + trcodigo + " tfpcodigo: " + tfpcodigo);

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaSolicitudes bandejaSolicitudes = new BandejaSolicitudes();
			bandejaSolicitudes.setDecotfp(tfpcodigo);
			bandejaSolicitudes.setTrcodigo(trcodigo);

			Long total = new Long(0);
			if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
					&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
					&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
							.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
				total = this.bandejaSolicitudesService.findAllBandejaSolicitudesAdministrativoCount(bandejaSolicitudes,
						censoMonitor, trFechaDesde, trFechaHasta,
						y41bBandejaSolicitudesAdministrativo_CheckExcluirAcuses);

			}

			return total;
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllBandejaSolicitudes'.
	 * 
	 * @param trFechaDesde_
	 *            String
	 * @param trFechaHasta_
	 *            String
	 * @param trcodigo_
	 *            String
	 * @param tfpcodigo_
	 *            String
	 * @param y41bBandejaSolicitudesAdministrativo_CheckExcluirAcuses_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busquedaBandejaSolicitudesAdministrativo", method = RequestMethod.GET)
	public @ResponseBody Object getAllBandejaSolicitudesAdministrativo(
			@RequestParam(value = "trFechaDesde", required = false) String trFechaDesde_,
			@RequestParam(value = "trFechaHasta", required = false) String trFechaHasta_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_,
			@RequestParam(value = "tfpcodigo", required = false) String tfpcodigo_,
			@RequestParam(value = "y41bBandejaSolicitudesAdministrativo_CheckExcluirAcuses", required = false) String y41bBandejaSolicitudesAdministrativo_CheckExcluirAcuses_,
			HttpServletRequest request) {
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date trFechaDesde = Y41bUtils.parseDate(trFechaDesde_, locale);
			Date trFechaHasta = Y41bUtils.parseDate(trFechaHasta_, locale);

			// control checks
			String y41bBandejaSolicitudesAdministrativo_CheckExcluirAcuses = ("on"
					.equals(y41bBandejaSolicitudesAdministrativo_CheckExcluirAcuses_)) ? Y41bConstantes.VALOR_SI
							: Y41bConstantes.VALOR_NO;

			// control de los campos susceptibles de llegar a "" desde el filtro
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;
			String tfpcodigo = ("".equals(tfpcodigo_)) ? null : tfpcodigo_;

			BandejaSolicitudesController.logger.info("desde: " + trFechaDesde + " hasta: " + trFechaHasta
					+ " trcodigo: " + trcodigo + " tfpcodigo: " + tfpcodigo);

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaSolicitudes bandejaSolicitudes = new BandejaSolicitudes();

			bandejaSolicitudes.setDecotfp(tfpcodigo);
			bandejaSolicitudes.setTrcodigo(trcodigo);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				// Dejamos en sesin el objeto pagination
				request.getSession().setAttribute("paginationBandejaSolicitudesAdm", pagination);

				List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = null;

				if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
								.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
					listBandejaSolicitudesBusqueda = this.bandejaSolicitudesService
							.findAllBandejaSolicitudesAdministrativo(bandejaSolicitudes, censoMonitor, trFechaDesde,
									trFechaHasta, y41bBandejaSolicitudesAdministrativo_CheckExcluirAcuses, pagination);

					if (listBandejaSolicitudesBusqueda == null) {
						throw new Exception("No data Found.");
					}
				} else {
					listBandejaSolicitudesBusqueda = new ArrayList<BandejaSolicitudesBusqueda>();
				}

				Long total = new Long(0);
				if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
								.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
					total = this.bandejaSolicitudesService.findAllBandejaSolicitudesAdministrativoCount(
							bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta,
							y41bBandejaSolicitudesAdministrativo_CheckExcluirAcuses);
				}
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listBandejaSolicitudesBusqueda);
				return data;
			} else {
				List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = null;

				if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
								.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
					listBandejaSolicitudesBusqueda = this.bandejaSolicitudesService
							.findAllBandejaSolicitudesAdministrativo(bandejaSolicitudes, censoMonitor, trFechaDesde,
									trFechaHasta, y41bBandejaSolicitudesAdministrativo_CheckExcluirAcuses, null);

					if (listBandejaSolicitudesBusqueda == null) {
						throw new Exception("No data Found.");
					}
				} else {
					listBandejaSolicitudesBusqueda = new ArrayList<BandejaSolicitudesBusqueda>();
				}

				return listBandejaSolicitudesBusqueda;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllBandejaSolicitudesSession'.
	 * 
	 * @param trFechaDesde_
	 *            String
	 * @param trFechaHasta_
	 *            String
	 * @param trcodigo_
	 *            String
	 * @param tfpcodigo_
	 *            String
	 * @param y41bBandejaSolicitudesAdministrativo_CheckExcluirAcuses_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busquedaBandejaSolicitudesAdministrativoSession", method = RequestMethod.GET)
	public @ResponseBody Object getAllBandejaSolicitudesAdministrativoSession(
			@RequestParam(value = "trFechaDesde", required = false) String trFechaDesde_,
			@RequestParam(value = "trFechaHasta", required = false) String trFechaHasta_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_,
			@RequestParam(value = "tfpcodigo", required = false) String tfpcodigo_,
			@RequestParam(value = "y41bBandejaSolicitudesAdministrativo_CheckExcluirAcuses", required = false) String y41bBandejaSolicitudesAdministrativo_CheckExcluirAcuses_,
			HttpServletRequest request) {
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date trFechaDesde = Y41bUtils.parseDate(trFechaDesde_, locale);
			Date trFechaHasta = Y41bUtils.parseDate(trFechaHasta_, locale);

			// control checks
			String y41bBandejaSolicitudesAdministrativo_CheckExcluirAcuses = ("on"
					.equals(y41bBandejaSolicitudesAdministrativo_CheckExcluirAcuses_)) ? Y41bConstantes.VALOR_SI
							: Y41bConstantes.VALOR_NO;

			// control de los campos susceptibles de llegar a "" desde el filtro
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;
			String tfpcodigo = ("".equals(tfpcodigo_)) ? null : tfpcodigo_;

			BandejaSolicitudesController.logger.info("desde: " + trFechaDesde + " hasta: " + trFechaHasta
					+ " trcodigo: " + trcodigo + " tfpcodigo: " + tfpcodigo);

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaSolicitudes bandejaSolicitudes = new BandejaSolicitudes();

			bandejaSolicitudes.setDecotfp(tfpcodigo);
			bandejaSolicitudes.setTrcodigo(trcodigo);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = (Pagination) request.getSession().getAttribute("paginationBandejaSolicitudesAdm");

				// Si al refrescar la tabla existen menos elementos y la pgina
				// guardada en sesin no existe, se debe seleccionar la ltima
				// pgina con datos
				Long totalReg = new Long(0);
				totalReg = this.bandejaSolicitudesService.findAllBandejaSolicitudesAdministrativoCount(
						bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta,
						y41bBandejaSolicitudesAdministrativo_CheckExcluirAcuses);
				Long pagSession = new Long(0);
				Long page = new Long(0);
				pagSession = pagination.getPage() * pagination.getRows();
				pagSession = pagSession - pagination.getRows();

				if (pagSession >= totalReg) {
					page = totalReg / pagination.getRows();
					pagination.setPage(page);
				}

				List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = null;

				listBandejaSolicitudesBusqueda = this.bandejaSolicitudesService.findAllBandejaSolicitudesAdministrativo(
						bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta,
						y41bBandejaSolicitudesAdministrativo_CheckExcluirAcuses, pagination);

				if (listBandejaSolicitudesBusqueda == null) {
					throw new Exception("No data Found.");
				}

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(pagination.getPage().toString());
				data.setRecords(totalReg.intValue());
				data.setTotal(totalReg, pagination.getRows());
				data.setRows(listBandejaSolicitudesBusqueda);
				return data;
			} else {
				List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = null;

				if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
								.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
					listBandejaSolicitudesBusqueda = this.bandejaSolicitudesService
							.findAllBandejaSolicitudesAdministrativo(bandejaSolicitudes, censoMonitor, trFechaDesde,
									trFechaHasta, y41bBandejaSolicitudesAdministrativo_CheckExcluirAcuses, null);

					if (listBandejaSolicitudesBusqueda == null) {
						throw new Exception("No data Found.");
					}
				} else {
					listBandejaSolicitudesBusqueda = new ArrayList<BandejaSolicitudesBusqueda>();
				}

				return listBandejaSolicitudesBusqueda;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*---- excel Bandeja-----*/

	/**
	 * Method 'getAllBandejaSolicitudes'.
	 * 
	 * @param trFechaDesde_
	 *            String
	 * @param trFechaHasta_
	 *            String
	 * @param trcodigo_
	 *            String
	 * @param tfpcodigo_
	 *            String
	 * @param y41bBandejaSolicitudesAdministrativo_CheckExcluirAcuses_
	 *            String
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excelBandejaAdministrativo", method = RequestMethod.GET)
	public @ResponseBody void getAllSolicitudExcelBandejaAdministrativo(
			@RequestParam(value = "trFechaDesde", required = false) String trFechaDesde_,
			@RequestParam(value = "trFechaHasta", required = false) String trFechaHasta_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_,
			@RequestParam(value = "tfpcodigo", required = false) String tfpcodigo_,
			@RequestParam(value = "y41bBandejaSolicitudesAdministrativo_CheckExcluirAcuses", required = false) String y41bBandejaSolicitudesAdministrativo_CheckExcluirAcuses_,
			HttpServletRequest request, HttpServletResponse response) {
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date trFechaDesde = Y41bUtils.parseDate(trFechaDesde_, locale);
			Date trFechaHasta = Y41bUtils.parseDate(trFechaHasta_, locale);

			// control checks
			String y41bBandejaSolicitudesAdministrativo_CheckExcluirAcuses = ("on"
					.equals(y41bBandejaSolicitudesAdministrativo_CheckExcluirAcuses_)) ? Y41bConstantes.VALOR_SI
							: Y41bConstantes.VALOR_NO;

			// control de los campos susceptibles de llegar a "" desde el filtro
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;
			String tfpcodigo = ("".equals(tfpcodigo_)) ? null : tfpcodigo_;

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaSolicitudes bandejaSolicitudes = new BandejaSolicitudes();

			bandejaSolicitudes.setDecotfp(tfpcodigo);
			bandejaSolicitudes.setTrcodigo(trcodigo);

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy, "yyyyMMddHHmmss");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_BANDEJA_SOLICITUDES_ADMINISTRATIVO + fechaActual + ".xls";
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(nombre) + "\"");

			String xslString = this.y41bExcelGeneratorService.getSolicitudesExcelBandejaAdministrativo(
					bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta,
					y41bBandejaSolicitudesAdministrativo_CheckExcluirAcuses);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'busquedaBandejaENYPDcount'.
	 * 
	 * @param trFechaDesde_
	 *            String
	 * @param trFechaHasta_
	 *            String
	 * @param trcodigo_
	 *            String
	 * @param y41bBandejaENYPD_CheckNuevos_
	 *            String
	 * @param y41bBandejaENYPD_CheckSinDecision_
	 *            String
	 * @param y41bBandejaENYPD_CheckExcluirAcuses_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busquedaBandejaENYPDcount", method = RequestMethod.GET)
	public @ResponseBody Long getAllBandejaENYPDCount(
			@RequestParam(value = "trFechaDesde", required = false) String trFechaDesde_,
			@RequestParam(value = "trFechaHasta", required = false) String trFechaHasta_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_,
			@RequestParam(value = "y41bBandejaENYPD_CheckNuevos", required = false) String y41bBandejaENYPD_CheckNuevos_,
			@RequestParam(value = "y41bBandejaENYPD_CheckSinDecision", required = false) String y41bBandejaENYPD_CheckSinDecision_,
			@RequestParam(value = "y41bBandejaENYPD_CheckExcluirAcuses", required = false) String y41bBandejaENYPD_CheckExcluirAcuses_,
			HttpServletRequest request) {
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date trFechaDesde = Y41bUtils.parseDate(trFechaDesde_, locale);
			Date trFechaHasta = Y41bUtils.parseDate(trFechaHasta_, locale);

			// control checks
			String y41bBandejaENYPD_CheckNuevos = ("on".equals(y41bBandejaENYPD_CheckNuevos_)) ? Y41bConstantes.VALOR_SI
					: Y41bConstantes.VALOR_NO;
			String y41bBandejaENYPD_CheckSinDecision = ("on".equals(y41bBandejaENYPD_CheckSinDecision_))
					? Y41bConstantes.VALOR_SI : Y41bConstantes.VALOR_NO;

			// control checks
			String y41bBandejaENYPD_CheckExcluirAcuses = ("on".equals(y41bBandejaENYPD_CheckExcluirAcuses_))
					? Y41bConstantes.VALOR_SI : Y41bConstantes.VALOR_NO;

			Boolean conAsignacionResp = false;
			if (y41bBandejaENYPD_CheckNuevos.equalsIgnoreCase(Y41bConstantes.VALOR_SI)
					&& y41bBandejaENYPD_CheckSinDecision.equalsIgnoreCase(Y41bConstantes.VALOR_SI)) {
				conAsignacionResp = true;
			} else if (y41bBandejaENYPD_CheckNuevos.equalsIgnoreCase(Y41bConstantes.VALOR_SI)
					&& y41bBandejaENYPD_CheckSinDecision.equalsIgnoreCase(Y41bConstantes.VALOR_NO)) {
				conAsignacionResp = true;
			} else if (y41bBandejaENYPD_CheckNuevos.equalsIgnoreCase(Y41bConstantes.VALOR_NO)
					&& y41bBandejaENYPD_CheckSinDecision.equalsIgnoreCase(Y41bConstantes.VALOR_SI)) {
				conAsignacionResp = false;
			} else if (y41bBandejaENYPD_CheckNuevos.equalsIgnoreCase(Y41bConstantes.VALOR_NO)
					&& y41bBandejaENYPD_CheckSinDecision.equalsIgnoreCase(Y41bConstantes.VALOR_NO)) {
				conAsignacionResp = false;
			}

			Boolean conStandBy = false;
			if (y41bBandejaENYPD_CheckSinDecision.equalsIgnoreCase(Y41bConstantes.VALOR_SI)) {
				conStandBy = true;
			} else if (y41bBandejaENYPD_CheckSinDecision.equalsIgnoreCase(Y41bConstantes.VALOR_NO)) {
				conStandBy = false;
			}

			// control de los campos susceptibles de llegar a "" desde el filtro
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;

			BandejaSolicitudesController.logger
					.info("desde: " + trFechaDesde + " hasta: " + trFechaHasta + " trcodigo: " + trcodigo);

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaSolicitudes bandejaSolicitudes = new BandejaSolicitudes();
			bandejaSolicitudes.setTrcodigo(trcodigo);

			Long total = new Long(0);
			if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
					&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
					&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
							.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
				total = this.bandejaSolicitudesService.findAllBandejaSolicitudesENYPDCount(bandejaSolicitudes,
						censoMonitor, trFechaDesde, trFechaHasta, conAsignacionResp, conStandBy,
						y41bBandejaENYPD_CheckExcluirAcuses);

			}

			return total;
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllBandejaSolicitudesENYPD'.
	 * 
	 * @param trFechaDesde_
	 *            String
	 * @param trFechaHasta_
	 *            String
	 * @param trcodigo_
	 *            String
	 * @param y41bBandejaENYPD_CheckNuevos_
	 *            String
	 * @param y41bBandejaENYPD_CheckSinDecision_
	 *            String
	 * @param y41bBandejaENYPD_CheckExcluirAcuses_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busquedaBandejaSolicitudesENYPD", method = RequestMethod.GET)
	public @ResponseBody Object getAllBandejaSolicitudesENYPD(
			@RequestParam(value = "trFechaDesde", required = false) String trFechaDesde_,
			@RequestParam(value = "trFechaHasta", required = false) String trFechaHasta_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_,
			@RequestParam(value = "y41bBandejaENYPD_CheckNuevos", required = false) String y41bBandejaENYPD_CheckNuevos_,
			@RequestParam(value = "y41bBandejaENYPD_CheckSinDecision", required = false) String y41bBandejaENYPD_CheckSinDecision_,
			@RequestParam(value = "y41bBandejaENYPD_CheckExcluirAcuses", required = false) String y41bBandejaENYPD_CheckExcluirAcuses_,
			HttpServletRequest request) {
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date trFechaDesde = Y41bUtils.parseDate(trFechaDesde_, locale);
			Date trFechaHasta = Y41bUtils.parseDate(trFechaHasta_, locale);

			// control checks
			String y41bBandejaENYPD_CheckNuevos = ("on".equals(y41bBandejaENYPD_CheckNuevos_)) ? Y41bConstantes.VALOR_SI
					: Y41bConstantes.VALOR_NO;
			String y41bBandejaENYPD_CheckSinDecision = ("on".equals(y41bBandejaENYPD_CheckSinDecision_))
					? Y41bConstantes.VALOR_SI : Y41bConstantes.VALOR_NO;

			// control checks
			String y41bBandejaENYPD_CheckExcluirAcuses = ("on".equals(y41bBandejaENYPD_CheckExcluirAcuses_))
					? Y41bConstantes.VALOR_SI : Y41bConstantes.VALOR_NO;

			Boolean conAsignacionResp = false;
			if (y41bBandejaENYPD_CheckNuevos.equalsIgnoreCase(Y41bConstantes.VALOR_SI)
					&& y41bBandejaENYPD_CheckSinDecision.equalsIgnoreCase(Y41bConstantes.VALOR_SI)) {
				conAsignacionResp = true;
			} else if (y41bBandejaENYPD_CheckNuevos.equalsIgnoreCase(Y41bConstantes.VALOR_SI)
					&& y41bBandejaENYPD_CheckSinDecision.equalsIgnoreCase(Y41bConstantes.VALOR_NO)) {
				conAsignacionResp = true;
			} else if (y41bBandejaENYPD_CheckNuevos.equalsIgnoreCase(Y41bConstantes.VALOR_NO)
					&& y41bBandejaENYPD_CheckSinDecision.equalsIgnoreCase(Y41bConstantes.VALOR_SI)) {
				conAsignacionResp = false;
			} else if (y41bBandejaENYPD_CheckNuevos.equalsIgnoreCase(Y41bConstantes.VALOR_NO)
					&& y41bBandejaENYPD_CheckSinDecision.equalsIgnoreCase(Y41bConstantes.VALOR_NO)) {
				conAsignacionResp = false;
			}

			Boolean conStandBy = false;
			if (y41bBandejaENYPD_CheckSinDecision.equalsIgnoreCase(Y41bConstantes.VALOR_SI)) {
				conStandBy = true;
			} else if (y41bBandejaENYPD_CheckSinDecision.equalsIgnoreCase(Y41bConstantes.VALOR_NO)) {
				conStandBy = false;
			}

			// control de los campos susceptibles de llegar a "" desde el filtro
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;

			BandejaSolicitudesController.logger
					.info("desde: " + trFechaDesde + " hasta: " + trFechaHasta + " trcodigo: " + trcodigo);

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaSolicitudes bandejaSolicitudes = new BandejaSolicitudes();
			bandejaSolicitudes.setTrcodigo(trcodigo);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = null;

				if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
								.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
					listBandejaSolicitudesBusqueda = this.bandejaSolicitudesService.findAllBandejaSolicitudesENYPD(
							bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta, conAsignacionResp, conStandBy,
							y41bBandejaENYPD_CheckExcluirAcuses, pagination);

					if (listBandejaSolicitudesBusqueda == null) {
						throw new Exception("No data Found.");
					}
				} else {
					listBandejaSolicitudesBusqueda = new ArrayList<BandejaSolicitudesBusqueda>();
				}

				Long total = new Long(0);
				if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
								.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
					total = this.bandejaSolicitudesService.findAllBandejaSolicitudesENYPDCount(bandejaSolicitudes,
							censoMonitor, trFechaDesde, trFechaHasta, conAsignacionResp, conStandBy,
							y41bBandejaENYPD_CheckExcluirAcuses);
				}
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listBandejaSolicitudesBusqueda);
				return data;
			} else {
				List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = null;

				if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
								.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
					listBandejaSolicitudesBusqueda = this.bandejaSolicitudesService.findAllBandejaSolicitudesENYPD(
							bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta, conAsignacionResp, conStandBy,
							y41bBandejaENYPD_CheckExcluirAcuses, null);

					if (listBandejaSolicitudesBusqueda == null) {
						throw new Exception("No data Found.");
					}
				} else {
					listBandejaSolicitudesBusqueda = new ArrayList<BandejaSolicitudesBusqueda>();
				}

				return listBandejaSolicitudesBusqueda;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllSolicitudExcelBandejaENYP'.
	 * 
	 * @param trFechaDesde_
	 *            String
	 * @param trFechaHasta_
	 *            String
	 * @param trcodigo_
	 *            String
	 * @param y41bBandejaENYPD_CheckNuevos_
	 *            String
	 * @param y41bBandejaENYPD_CheckSinDecision_
	 *            String
	 * @param y41bBandejaENYPD_CheckExcluirAcuses_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excelBandejaENYPD", method = RequestMethod.GET)
	public @ResponseBody void getAllSolicitudExcelBandejaENYP(
			@RequestParam(value = "trFechaDesde", required = false) String trFechaDesde_,
			@RequestParam(value = "trFechaHasta", required = false) String trFechaHasta_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_,
			@RequestParam(value = "y41bBandejaENYPD_CheckNuevos", required = false) String y41bBandejaENYPD_CheckNuevos_,
			@RequestParam(value = "y41bBandejaENYPD_CheckSinDecision", required = false) String y41bBandejaENYPD_CheckSinDecision_,
			@RequestParam(value = "y41bBandejaENYPD_CheckExcluirAcuses", required = false) String y41bBandejaENYPD_CheckExcluirAcuses_,
			HttpServletRequest request, HttpServletResponse response) {
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date trFechaDesde = Y41bUtils.parseDate(trFechaDesde_, locale);
			Date trFechaHasta = Y41bUtils.parseDate(trFechaHasta_, locale);

			// control checks
			String y41bBandejaENYPD_CheckNuevos = ("on".equals(y41bBandejaENYPD_CheckNuevos_)) ? Y41bConstantes.VALOR_SI
					: Y41bConstantes.VALOR_NO;
			String y41bBandejaENYPD_CheckSinDecision = ("on".equals(y41bBandejaENYPD_CheckSinDecision_))
					? Y41bConstantes.VALOR_SI : Y41bConstantes.VALOR_NO;

			// control checks
			String y41bBandejaENYPD_CheckExcluirAcuses = ("on".equals(y41bBandejaENYPD_CheckExcluirAcuses_))
					? Y41bConstantes.VALOR_SI : Y41bConstantes.VALOR_NO;

			Boolean conAsignacionResp = false;
			if (y41bBandejaENYPD_CheckNuevos.equalsIgnoreCase(Y41bConstantes.VALOR_SI)
					&& y41bBandejaENYPD_CheckSinDecision.equalsIgnoreCase(Y41bConstantes.VALOR_SI)) {
				conAsignacionResp = true;
			} else if (y41bBandejaENYPD_CheckNuevos.equalsIgnoreCase(Y41bConstantes.VALOR_SI)
					&& y41bBandejaENYPD_CheckSinDecision.equalsIgnoreCase(Y41bConstantes.VALOR_NO)) {
				conAsignacionResp = true;
			} else if (y41bBandejaENYPD_CheckNuevos.equalsIgnoreCase(Y41bConstantes.VALOR_NO)
					&& y41bBandejaENYPD_CheckSinDecision.equalsIgnoreCase(Y41bConstantes.VALOR_SI)) {
				conAsignacionResp = false;
			} else if (y41bBandejaENYPD_CheckNuevos.equalsIgnoreCase(Y41bConstantes.VALOR_NO)
					&& y41bBandejaENYPD_CheckSinDecision.equalsIgnoreCase(Y41bConstantes.VALOR_NO)) {
				conAsignacionResp = false;
			}

			Boolean conStandBy = false;
			if (y41bBandejaENYPD_CheckSinDecision.equalsIgnoreCase(Y41bConstantes.VALOR_SI)) {
				conStandBy = true;
			} else if (y41bBandejaENYPD_CheckSinDecision.equalsIgnoreCase(Y41bConstantes.VALOR_NO)) {
				conStandBy = false;
			}

			// control de los campos susceptibles de llegar a "" desde el filtro
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaSolicitudes bandejaSolicitudes = new BandejaSolicitudes();

			bandejaSolicitudes.setTrcodigo(trcodigo);

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy, "yyyyMMddHHmmss");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_BANDEJA_SOLICITUDES_ENYPD + fechaActual + ".xls";
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(nombre) + "\"");

			String xslString = this.y41bExcelGeneratorService.getSolicitudesExcelBandejaENYPD(bandejaSolicitudes,
					censoMonitor, trFechaDesde, trFechaHasta, conAsignacionResp, conStandBy,
					y41bBandejaENYPD_CheckExcluirAcuses);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'busquedaBandejaECTPcount'.
	 * 
	 * @param trFechaDesde_
	 *            String
	 * @param trFechaHasta_
	 *            String
	 * @param trcodigo_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busquedaBandejaECTPcount", method = RequestMethod.GET)
	public @ResponseBody Long getAllBandejaECTPCount(
			@RequestParam(value = "trFechaDesde", required = false) String trFechaDesde_,
			@RequestParam(value = "trFechaHasta", required = false) String trFechaHasta_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_, HttpServletRequest request) {
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date trFechaDesde = Y41bUtils.parseDate(trFechaDesde_, locale);
			Date trFechaHasta = Y41bUtils.parseDate(trFechaHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;

			BandejaSolicitudesController.logger
					.info("desde: " + trFechaDesde + " hasta: " + trFechaHasta + " trcodigo: " + trcodigo);

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaSolicitudes bandejaSolicitudes = new BandejaSolicitudes();
			bandejaSolicitudes.setTrcodigo(trcodigo);

			Long total = new Long(0);
			if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
					&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
					&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
							.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
				total = this.bandejaSolicitudesService.findAllBandejaSolicitudesECTPCount(bandejaSolicitudes,
						censoMonitor, trFechaDesde, trFechaHasta);

			}

			return total;
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllBandejaSolicitudes'.
	 * 
	 * @param trFechaDesde_
	 *            String
	 * @param trFechaHasta_
	 *            String
	 * @param trcodigo_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busquedaBandejaECTP", method = RequestMethod.GET)
	public @ResponseBody Object getAllBandejaSolicitudesECTP(
			@RequestParam(value = "trFechaDesde", required = false) String trFechaDesde_,
			@RequestParam(value = "trFechaHasta", required = false) String trFechaHasta_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_, HttpServletRequest request) {
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date trFechaDesde = Y41bUtils.parseDate(trFechaDesde_, locale);
			Date trFechaHasta = Y41bUtils.parseDate(trFechaHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;

			BandejaSolicitudesController.logger
					.info("desde: " + trFechaDesde + " hasta: " + trFechaHasta + " trcodigo: " + trcodigo);

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaSolicitudes bandejaSolicitudes = new BandejaSolicitudes();
			bandejaSolicitudes.setTrcodigo(trcodigo);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				// Dejamos en sesin el objeto pagination
				request.getSession().setAttribute("paginationBandejaSolicitudesECTP", pagination);

				List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = null;

				if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
								.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
					listBandejaSolicitudesBusqueda = this.bandejaSolicitudesService.findAllBandejaSolicitudesECTP(
							bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta, pagination);

					if (listBandejaSolicitudesBusqueda == null) {
						throw new Exception("No data Found.");
					}
				} else {
					listBandejaSolicitudesBusqueda = new ArrayList<BandejaSolicitudesBusqueda>();
				}

				Long total = new Long(0);
				if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
								.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
					total = this.bandejaSolicitudesService.findAllBandejaSolicitudesECTPCount(bandejaSolicitudes,
							censoMonitor, trFechaDesde, trFechaHasta);
				}
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listBandejaSolicitudesBusqueda);
				return data;
			} else {
				List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = null;

				if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
								.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
					listBandejaSolicitudesBusqueda = this.bandejaSolicitudesService.findAllBandejaSolicitudesECTP(
							bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta, null);

					if (listBandejaSolicitudesBusqueda == null) {
						throw new Exception("No data Found.");
					}
				} else {
					listBandejaSolicitudesBusqueda = new ArrayList<BandejaSolicitudesBusqueda>();
				}

				return listBandejaSolicitudesBusqueda;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllBandejaSolicitudesECTPSession'.
	 * 
	 * @param trFechaDesde_
	 *            String
	 * @param trFechaHasta_
	 *            String
	 * @param trcodigo_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busquedaBandejaECTPSession", method = RequestMethod.GET)
	public @ResponseBody Object getAllBandejaSolicitudesECTPSession(
			@RequestParam(value = "trFechaDesde", required = false) String trFechaDesde_,
			@RequestParam(value = "trFechaHasta", required = false) String trFechaHasta_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_, HttpServletRequest request) {
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date trFechaDesde = Y41bUtils.parseDate(trFechaDesde_, locale);
			Date trFechaHasta = Y41bUtils.parseDate(trFechaHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;

			BandejaSolicitudesController.logger
					.info("desde: " + trFechaDesde + " hasta: " + trFechaHasta + " trcodigo: " + trcodigo);

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaSolicitudes bandejaSolicitudes = new BandejaSolicitudes();
			bandejaSolicitudes.setTrcodigo(trcodigo);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {

				pagination = (Pagination) request.getSession().getAttribute("paginationBandejaSolicitudesECTP");

				// Si al refrescar la tabla existen menos elementos y la pgina
				// guardada en sesin no existe, se debe seleccionar la ltima
				// pgina con datos
				Long totalReg = new Long(0);
				totalReg = this.bandejaSolicitudesService.findAllBandejaSolicitudesECTPCount(bandejaSolicitudes,
						censoMonitor, trFechaDesde, trFechaHasta);
				Long totalSesion = new Long(0);
				Long page = new Long(0);
				totalSesion = pagination.getPage() * pagination.getRows();
				totalSesion = totalSesion - pagination.getRows();

				if (totalSesion >= totalReg) {
					page = totalReg / pagination.getRows();
					pagination.setPage(page);
				}

				List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = null;

				listBandejaSolicitudesBusqueda = this.bandejaSolicitudesService.findAllBandejaSolicitudesECTP(
						bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta, pagination);

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(pagination.getPage().toString());
				data.setRecords(totalReg.intValue());
				data.setTotal(totalReg, pagination.getRows());
				data.setRows(listBandejaSolicitudesBusqueda);
				return data;

			} else {
				List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = null;

				if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
								.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
					listBandejaSolicitudesBusqueda = this.bandejaSolicitudesService.findAllBandejaSolicitudesECTP(
							bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta, null);

					if (listBandejaSolicitudesBusqueda == null) {
						throw new Exception("No data Found.");
					}
				} else {
					listBandejaSolicitudesBusqueda = new ArrayList<BandejaSolicitudesBusqueda>();
				}

				return listBandejaSolicitudesBusqueda;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllSolicitudExcelBandejaECTP'.
	 * 
	 * @param trFechaDesde_
	 *            String
	 * @param trFechaHasta_
	 *            String
	 * @param trcodigo_
	 *            String
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excelBandejaECTP", method = RequestMethod.GET)
	public @ResponseBody void getAllSolicitudExcelBandejaECTP(
			@RequestParam(value = "trFechaDesde", required = false) String trFechaDesde_,
			@RequestParam(value = "trFechaHasta", required = false) String trFechaHasta_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_, HttpServletRequest request,
			HttpServletResponse response) {
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date trFechaDesde = Y41bUtils.parseDate(trFechaDesde_, locale);
			Date trFechaHasta = Y41bUtils.parseDate(trFechaHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaSolicitudes bandejaSolicitudes = new BandejaSolicitudes();

			bandejaSolicitudes.setTrcodigo(trcodigo);

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy, "yyyyMMddHHmmss");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_BANDEJA_SOLICITUDES_ECTP + fechaActual + ".xls";
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(nombre) + "\"");

			String xslString = this.y41bExcelGeneratorService.getSolicitudesExcelBandejaECTP(bandejaSolicitudes,
					censoMonitor, trFechaDesde, trFechaHasta);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'busquedaBandejaECTPOcount'.
	 * 
	 * @param trFechaDesde_
	 *            String
	 * @param trFechaHasta_
	 *            String
	 * @param trcodigo_
	 *            String
	 * @param y41bBandejaECTPO_CheckExcluirAcuses_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busquedaBandejaECTPOcount", method = RequestMethod.GET)
	public @ResponseBody Long getAllBandejaECTPOCount(
			@RequestParam(value = "trFechaDesde", required = false) String trFechaDesde_,
			@RequestParam(value = "trFechaHasta", required = false) String trFechaHasta_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_,
			@RequestParam(value = "y41bBandejaECTPO_CheckExcluirAcuses", required = false) String y41bBandejaECTPO_CheckExcluirAcuses_,
			HttpServletRequest request) {
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date trFechaDesde = Y41bUtils.parseDate(trFechaDesde_, locale);
			Date trFechaHasta = Y41bUtils.parseDate(trFechaHasta_, locale);

			// control checks
			String y41bBandejaECTPO_CheckExcluirAcuses = ("on".equals(y41bBandejaECTPO_CheckExcluirAcuses_))
					? Y41bConstantes.VALOR_SI : Y41bConstantes.VALOR_NO;

			// control de los campos susceptibles de llegar a "" desde el filtro
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;

			BandejaSolicitudesController.logger
					.info("desde: " + trFechaDesde + " hasta: " + trFechaHasta + " trcodigo: " + trcodigo);

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaSolicitudes bandejaSolicitudes = new BandejaSolicitudes();
			bandejaSolicitudes.setTrcodigo(trcodigo);

			Long total = new Long(0);
			if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
					&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
					&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
							.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
				total = this.bandejaSolicitudesService.findAllBandejaSolicitudesECTPOCount(bandejaSolicitudes,
						censoMonitor, trFechaDesde, trFechaHasta, y41bBandejaECTPO_CheckExcluirAcuses);

			}

			return total;
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllBandejaSolicitudes'.
	 * 
	 * @param trFechaDesde_
	 *            String
	 * @param trFechaHasta_
	 *            String
	 * @param trcodigo_
	 *            String
	 * @param y41bBandejaECTPO_CheckExcluirAcuses_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busquedaBandejaECTPO", method = RequestMethod.GET)
	public @ResponseBody Object getAllBandejaSolicitudesECTPO(
			@RequestParam(value = "trFechaDesde", required = false) String trFechaDesde_,
			@RequestParam(value = "trFechaHasta", required = false) String trFechaHasta_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_,
			@RequestParam(value = "y41bBandejaECTPO_CheckExcluirAcuses", required = false) String y41bBandejaECTPO_CheckExcluirAcuses_,
			HttpServletRequest request) {
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date trFechaDesde = Y41bUtils.parseDate(trFechaDesde_, locale);
			Date trFechaHasta = Y41bUtils.parseDate(trFechaHasta_, locale);

			// control checks
			String y41bBandejaECTPO_CheckExcluirAcuses = ("on".equals(y41bBandejaECTPO_CheckExcluirAcuses_))
					? Y41bConstantes.VALOR_SI : Y41bConstantes.VALOR_NO;

			// control de los campos susceptibles de llegar a "" desde el filtro
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;

			BandejaSolicitudesController.logger
					.info("desde: " + trFechaDesde + " hasta: " + trFechaHasta + " trcodigo: " + trcodigo);

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaSolicitudes bandejaSolicitudes = new BandejaSolicitudes();
			bandejaSolicitudes.setTrcodigo(trcodigo);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				// Dejamos en sesin el objeto paginacion
				request.getSession().setAttribute("paginationBandejaSolicitudesECTPO", pagination);

				List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = null;

				if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
								.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
					listBandejaSolicitudesBusqueda = this.bandejaSolicitudesService.findAllBandejaSolicitudesECTPO(
							bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta,
							y41bBandejaECTPO_CheckExcluirAcuses, pagination);

					if (listBandejaSolicitudesBusqueda == null) {
						throw new Exception("No data Found.");
					}
				} else {
					listBandejaSolicitudesBusqueda = new ArrayList<BandejaSolicitudesBusqueda>();
				}

				Long total = new Long(0);
				if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
								.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
					total = this.bandejaSolicitudesService.findAllBandejaSolicitudesECTPOCount(bandejaSolicitudes,
							censoMonitor, trFechaDesde, trFechaHasta, y41bBandejaECTPO_CheckExcluirAcuses);
				}
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listBandejaSolicitudesBusqueda);
				return data;
			} else {
				List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = null;

				if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
								.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
					listBandejaSolicitudesBusqueda = this.bandejaSolicitudesService.findAllBandejaSolicitudesECTPO(
							bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta,
							y41bBandejaECTPO_CheckExcluirAcuses, null);

					if (listBandejaSolicitudesBusqueda == null) {
						throw new Exception("No data Found.");
					}
				} else {
					listBandejaSolicitudesBusqueda = new ArrayList<BandejaSolicitudesBusqueda>();
				}

				return listBandejaSolicitudesBusqueda;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllBandejaSolicitudesECTPOSession'.
	 * 
	 * @param trFechaDesde_
	 *            String
	 * @param trFechaHasta_
	 *            String
	 * @param trcodigo_
	 *            String
	 * @param y41bBandejaECTPO_CheckExcluirAcuses_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busquedaBandejaECTPOSession", method = RequestMethod.GET)
	public @ResponseBody Object getAllBandejaSolicitudesECTPOSession(
			@RequestParam(value = "trFechaDesde", required = false) String trFechaDesde_,
			@RequestParam(value = "trFechaHasta", required = false) String trFechaHasta_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_,
			@RequestParam(value = "y41bBandejaECTPO_CheckExcluirAcuses", required = false) String y41bBandejaECTPO_CheckExcluirAcuses_,
			HttpServletRequest request) {
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date trFechaDesde = Y41bUtils.parseDate(trFechaDesde_, locale);
			Date trFechaHasta = Y41bUtils.parseDate(trFechaHasta_, locale);

			// control checks
			String y41bBandejaECTPO_CheckExcluirAcuses = ("on".equals(y41bBandejaECTPO_CheckExcluirAcuses_))
					? Y41bConstantes.VALOR_SI : Y41bConstantes.VALOR_NO;

			// control de los campos susceptibles de llegar a "" desde el filtro
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;

			BandejaSolicitudesController.logger
					.info("desde: " + trFechaDesde + " hasta: " + trFechaHasta + " trcodigo: " + trcodigo);

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaSolicitudes bandejaSolicitudes = new BandejaSolicitudes();
			bandejaSolicitudes.setTrcodigo(trcodigo);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {

				pagination = (Pagination) request.getSession().getAttribute("paginationBandejaSolicitudesECTPO");

				// si al referescar la tabla existen menos elementos y la pgina
				// guardada ensesin no existe, se debe seleccionar la ltima
				// pgina con datos
				Long totalReg = new Long(0);
				totalReg = this.bandejaSolicitudesService.findAllBandejaSolicitudesECTPOCount(bandejaSolicitudes,
						censoMonitor, trFechaDesde, trFechaHasta, y41bBandejaECTPO_CheckExcluirAcuses);
				Long totalSesion = new Long(0);
				Long page = new Long(0);
				totalSesion = pagination.getPage() * pagination.getRows();
				totalSesion = totalSesion - pagination.getRows();

				if (totalSesion >= totalReg) {
					page = totalReg / pagination.getRows();
					pagination.setPage(page);
				}

				List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = null;

				listBandejaSolicitudesBusqueda = this.bandejaSolicitudesService.findAllBandejaSolicitudesECTPO(
						bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta,
						y41bBandejaECTPO_CheckExcluirAcuses, pagination);

				if (listBandejaSolicitudesBusqueda == null) {
					throw new Exception("No data Found.");
				}

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(pagination.getPage().toString());
				data.setRecords(totalReg.intValue());
				data.setTotal(totalReg, pagination.getRows());
				data.setRows(listBandejaSolicitudesBusqueda);
				return data;
			} else {
				List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = null;

				if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
								.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
					listBandejaSolicitudesBusqueda = this.bandejaSolicitudesService.findAllBandejaSolicitudesECTPO(
							bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta,
							y41bBandejaECTPO_CheckExcluirAcuses, null);

					if (listBandejaSolicitudesBusqueda == null) {
						throw new Exception("No data Found.");
					}
				} else {
					listBandejaSolicitudesBusqueda = new ArrayList<BandejaSolicitudesBusqueda>();
				}

				return listBandejaSolicitudesBusqueda;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'excelBandejaECTPO'.
	 * 
	 * @param trFechaDesde_
	 *            String
	 * @param trFechaHasta_
	 *            String
	 * @param trcodigo_
	 *            String
	 * @param y41bBandejaECTPO_CheckExcluirAcuses_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excelBandejaECTPO", method = RequestMethod.GET)
	public @ResponseBody void getAllSolicitudExcelBandejaECTPO(
			@RequestParam(value = "trFechaDesde", required = false) String trFechaDesde_,
			@RequestParam(value = "trFechaHasta", required = false) String trFechaHasta_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_,
			@RequestParam(value = "y41bBandejaECTPO_CheckExcluirAcuses", required = false) String y41bBandejaECTPO_CheckExcluirAcuses_,
			HttpServletRequest request, HttpServletResponse response) {
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date trFechaDesde = Y41bUtils.parseDate(trFechaDesde_, locale);
			Date trFechaHasta = Y41bUtils.parseDate(trFechaHasta_, locale);

			// control checks
			String y41bBandejaECTPO_CheckExcluirAcuses = ("on".equals(y41bBandejaECTPO_CheckExcluirAcuses_))
					? Y41bConstantes.VALOR_SI : Y41bConstantes.VALOR_NO;

			// control de los campos susceptibles de llegar a "" desde el filtro
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaSolicitudes bandejaSolicitudes = new BandejaSolicitudes();

			bandejaSolicitudes.setTrcodigo(trcodigo);

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy, "yyyyMMddHHmmss");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_BANDEJA_SOLICITUDES_ECTPO + fechaActual + ".xls";
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(nombre) + "\"");

			String xslString = this.y41bExcelGeneratorService.getSolicitudesExcelBandejaECTPO(bandejaSolicitudes,
					censoMonitor, trFechaDesde, trFechaHasta, y41bBandejaECTPO_CheckExcluirAcuses);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'busquedaBandejaEONYPDcount'.
	 * 
	 * @param trFechaDesde_
	 *            String
	 * @param trFechaHasta_
	 *            String
	 * @param trcodigo_
	 *            String
	 * @param codOrg_
	 *            String
	 * @param mocodigoExpediente_
	 *            String
	 * @param y41bBandejaEONYPD_CheckNuevos_
	 *            String
	 * @param y41bBandejaEONYPD_CheckSinDecision_
	 *            String
	 * @param y41bBandejaEONYPD_CheckExcluirAcuses_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busquedaBandejaEONYPDcount", method = RequestMethod.GET)
	public @ResponseBody Long getAllBandejaEONYPDCount(
			@RequestParam(value = "trFechaDesde", required = false) String trFechaDesde_,
			@RequestParam(value = "trFechaHasta", required = false) String trFechaHasta_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_,
			@RequestParam(value = "codOrg", required = false) String codOrg_,
			@RequestParam(value = "mocodigoExpediente", required = false) String mocodigoExpediente_,
			@RequestParam(value = "y41bBandejaEONYPD_CheckNuevos", required = false) String y41bBandejaEONYPD_CheckNuevos_,
			@RequestParam(value = "y41bBandejaEONYPD_CheckSinDecision", required = false) String y41bBandejaEONYPD_CheckSinDecision_,
			@RequestParam(value = "y41bBandejaEONYPD_CheckExcluirAcuses", required = false) String y41bBandejaEONYPD_CheckExcluirAcuses_,
			HttpServletRequest request) {
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date trFechaDesde = Y41bUtils.parseDate(trFechaDesde_, locale);
			Date trFechaHasta = Y41bUtils.parseDate(trFechaHasta_, locale);

			// control checks
			String y41bBandejaENYPD_CheckNuevos = ("on".equals(y41bBandejaEONYPD_CheckNuevos_))
					? Y41bConstantes.VALOR_SI : Y41bConstantes.VALOR_NO;
			String y41bBandejaENYPD_CheckSinDecision = ("on".equals(y41bBandejaEONYPD_CheckSinDecision_))
					? Y41bConstantes.VALOR_SI : Y41bConstantes.VALOR_NO;

			// control checks
			String y41bBandejaEONYPD_CheckExcluirAcuses = ("on".equals(y41bBandejaEONYPD_CheckExcluirAcuses_))
					? Y41bConstantes.VALOR_SI : Y41bConstantes.VALOR_NO;

			Boolean conAsignacionResp = false;
			if (y41bBandejaENYPD_CheckNuevos.equalsIgnoreCase(Y41bConstantes.VALOR_SI)
					&& y41bBandejaENYPD_CheckSinDecision.equalsIgnoreCase(Y41bConstantes.VALOR_SI)) {
				conAsignacionResp = true;
			} else if (y41bBandejaENYPD_CheckNuevos.equalsIgnoreCase(Y41bConstantes.VALOR_SI)
					&& y41bBandejaENYPD_CheckSinDecision.equalsIgnoreCase(Y41bConstantes.VALOR_NO)) {
				conAsignacionResp = true;
			} else if (y41bBandejaENYPD_CheckNuevos.equalsIgnoreCase(Y41bConstantes.VALOR_NO)
					&& y41bBandejaENYPD_CheckSinDecision.equalsIgnoreCase(Y41bConstantes.VALOR_SI)) {
				conAsignacionResp = false;
			} else if (y41bBandejaENYPD_CheckNuevos.equalsIgnoreCase(Y41bConstantes.VALOR_NO)
					&& y41bBandejaENYPD_CheckSinDecision.equalsIgnoreCase(Y41bConstantes.VALOR_NO)) {
				conAsignacionResp = false;
			}

			// control de los campos susceptibles de llegar a "" desde el filtro
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;
			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			String mocodigoExpediente = ("".equals(mocodigoExpediente_)) ? null : mocodigoExpediente_;

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaSolicitudes bandejaSolicitudes = new BandejaSolicitudes();
			bandejaSolicitudes.setTrcodigo(trcodigo);
			bandejaSolicitudes.setHccoor(codOrg);
			bandejaSolicitudes.setHdcomo(mocodigoExpediente);

			Long total = new Long(0);
			if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
					&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
					&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
							.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
				total = this.bandejaSolicitudesService.findAllBandejaSolicitudesEONYPDCount(bandejaSolicitudes,
						censoMonitor, trFechaDesde, trFechaHasta, conAsignacionResp,
						y41bBandejaEONYPD_CheckExcluirAcuses);

			}

			return total;
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllBandejaSolicitudes'.
	 * 
	 * @param trFechaDesde_
	 *            String
	 * @param trFechaHasta_
	 *            String
	 * @param trcodigo_
	 *            String
	 * @param codOrg_
	 *            String
	 * @param mocodigoExpediente_
	 *            String
	 * @param y41bBandejaEONYPD_CheckNuevos_
	 *            String
	 * @param y41bBandejaEONYPD_CheckSinDecision_
	 *            String
	 * @param y41bBandejaEONYPD_CheckExcluirAcuses_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busquedaBandejaEONYPD", method = RequestMethod.GET)
	public @ResponseBody Object getAllBandejaSolicitudesEONYPD(
			@RequestParam(value = "trFechaDesde", required = false) String trFechaDesde_,
			@RequestParam(value = "trFechaHasta", required = false) String trFechaHasta_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_,
			@RequestParam(value = "codOrg", required = false) String codOrg_,
			@RequestParam(value = "mocodigoExpediente", required = false) String mocodigoExpediente_,
			@RequestParam(value = "y41bBandejaEONYPD_CheckNuevos", required = false) String y41bBandejaEONYPD_CheckNuevos_,
			@RequestParam(value = "y41bBandejaEONYPD_CheckSinDecision", required = false) String y41bBandejaEONYPD_CheckSinDecision_,
			@RequestParam(value = "y41bBandejaEONYPD_CheckExcluirAcuses", required = false) String y41bBandejaEONYPD_CheckExcluirAcuses_,
			HttpServletRequest request) {
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date trFechaDesde = Y41bUtils.parseDate(trFechaDesde_, locale);
			Date trFechaHasta = Y41bUtils.parseDate(trFechaHasta_, locale);

			// control checks
			String y41bBandejaENYPD_CheckNuevos = ("on".equals(y41bBandejaEONYPD_CheckNuevos_))
					? Y41bConstantes.VALOR_SI : Y41bConstantes.VALOR_NO;
			String y41bBandejaENYPD_CheckSinDecision = ("on".equals(y41bBandejaEONYPD_CheckSinDecision_))
					? Y41bConstantes.VALOR_SI : Y41bConstantes.VALOR_NO;

			// control checks
			String y41bBandejaEONYPD_CheckExcluirAcuses = ("on".equals(y41bBandejaEONYPD_CheckExcluirAcuses_))
					? Y41bConstantes.VALOR_SI : Y41bConstantes.VALOR_NO;

			Boolean conAsignacionResp = false;
			if (y41bBandejaENYPD_CheckNuevos.equalsIgnoreCase(Y41bConstantes.VALOR_SI)
					&& y41bBandejaENYPD_CheckSinDecision.equalsIgnoreCase(Y41bConstantes.VALOR_SI)) {
				conAsignacionResp = true;
			} else if (y41bBandejaENYPD_CheckNuevos.equalsIgnoreCase(Y41bConstantes.VALOR_SI)
					&& y41bBandejaENYPD_CheckSinDecision.equalsIgnoreCase(Y41bConstantes.VALOR_NO)) {
				conAsignacionResp = true;
			} else if (y41bBandejaENYPD_CheckNuevos.equalsIgnoreCase(Y41bConstantes.VALOR_NO)
					&& y41bBandejaENYPD_CheckSinDecision.equalsIgnoreCase(Y41bConstantes.VALOR_SI)) {
				conAsignacionResp = false;
			} else if (y41bBandejaENYPD_CheckNuevos.equalsIgnoreCase(Y41bConstantes.VALOR_NO)
					&& y41bBandejaENYPD_CheckSinDecision.equalsIgnoreCase(Y41bConstantes.VALOR_NO)) {
				conAsignacionResp = false;
			}

			// control de los campos susceptibles de llegar a "" desde el filtro
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;
			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			String mocodigoExpediente = ("".equals(mocodigoExpediente_)) ? null : mocodigoExpediente_;

			BandejaSolicitudesController.logger
					.info("desde: " + trFechaDesde + " hasta: " + trFechaHasta + " trcodigo: " + trcodigo);

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaSolicitudes bandejaSolicitudes = new BandejaSolicitudes();
			bandejaSolicitudes.setTrcodigo(trcodigo);
			bandejaSolicitudes.setHccoor(codOrg);
			bandejaSolicitudes.setHdcomo(mocodigoExpediente);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = null;

				if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
								.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
					listBandejaSolicitudesBusqueda = this.bandejaSolicitudesService.findAllBandejaSolicitudesEONYPD(
							bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta, conAsignacionResp,
							y41bBandejaEONYPD_CheckExcluirAcuses, pagination);

					if (listBandejaSolicitudesBusqueda == null) {
						throw new Exception("No data Found.");
					}
				} else {
					listBandejaSolicitudesBusqueda = new ArrayList<BandejaSolicitudesBusqueda>();
				}

				Long total = new Long(0);
				if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
								.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
					total = this.bandejaSolicitudesService.findAllBandejaSolicitudesEONYPDCount(bandejaSolicitudes,
							censoMonitor, trFechaDesde, trFechaHasta, conAsignacionResp,
							y41bBandejaEONYPD_CheckExcluirAcuses);
				}
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listBandejaSolicitudesBusqueda);
				return data;
			} else {
				List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = null;

				if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
								.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
					listBandejaSolicitudesBusqueda = this.bandejaSolicitudesService.findAllBandejaSolicitudesEONYPD(
							bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta, conAsignacionResp,
							y41bBandejaEONYPD_CheckExcluirAcuses, null);

					if (listBandejaSolicitudesBusqueda == null) {
						throw new Exception("No data Found.");
					}
				} else {
					listBandejaSolicitudesBusqueda = new ArrayList<BandejaSolicitudesBusqueda>();
				}

				return listBandejaSolicitudesBusqueda;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'busquedaBandejaEONYPDcount'.
	 * 
	 * @param trFechaDesde_
	 *            String
	 * @param trFechaHasta_
	 *            String
	 * @param trcodigo_
	 *            String
	 * @param codOrg_
	 *            String
	 * @param mocodigoExpediente_
	 *            String
	 * @param y41bBandejaEOCTP_CheckExcluirAcuses_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busquedaBandejaEOCTPcount", method = RequestMethod.GET)
	public @ResponseBody Long getAllBandejaEOCTPCount(
			@RequestParam(value = "trFechaDesde", required = false) String trFechaDesde_,
			@RequestParam(value = "trFechaHasta", required = false) String trFechaHasta_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_,
			@RequestParam(value = "codOrg", required = false) String codOrg_,
			@RequestParam(value = "mocodigoExpediente", required = false) String mocodigoExpediente_,
			@RequestParam(value = "y41bBandejaEOCTP_CheckExcluirAcuses", required = false) String y41bBandejaEOCTP_CheckExcluirAcuses_,
			HttpServletRequest request) {
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date trFechaDesde = Y41bUtils.parseDate(trFechaDesde_, locale);
			Date trFechaHasta = Y41bUtils.parseDate(trFechaHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;
			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			String mocodigoExpediente = ("".equals(mocodigoExpediente_)) ? null : mocodigoExpediente_;
			// control checks
			String y41bBandejaEOCTP_CheckExcluirAcuses = ("on".equals(y41bBandejaEOCTP_CheckExcluirAcuses_))
					? Y41bConstantes.VALOR_SI : Y41bConstantes.VALOR_NO;

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaSolicitudes bandejaSolicitudes = new BandejaSolicitudes();
			bandejaSolicitudes.setTrcodigo(trcodigo);
			bandejaSolicitudes.setHccoor(codOrg);
			bandejaSolicitudes.setHdcomo(mocodigoExpediente);

			Long total = new Long(0);
			if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
					&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
					&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
							.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
				total = this.bandejaSolicitudesService.findAllBandejaSolicitudesEOCTPCount(bandejaSolicitudes,
						censoMonitor, trFechaDesde, trFechaHasta, y41bBandejaEOCTP_CheckExcluirAcuses);

			}

			return total;
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllBandejaSolicitudes'.
	 * 
	 * @param trFechaDesde_
	 *            String
	 * @param trFechaHasta_
	 *            String
	 * @param trcodigo_
	 *            String
	 * @param codOrg_
	 *            String
	 * @param mocodigoExpediente_
	 *            String
	 * @param y41bBandejaEOCTP_CheckExcluirAcuses_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busquedaBandejaEOCTP", method = RequestMethod.GET)
	public @ResponseBody Object getAllBandejaSolicitudesEOCTP(
			@RequestParam(value = "trFechaDesde", required = false) String trFechaDesde_,
			@RequestParam(value = "trFechaHasta", required = false) String trFechaHasta_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_,
			@RequestParam(value = "codOrg", required = false) String codOrg_,
			@RequestParam(value = "mocodigoExpediente", required = false) String mocodigoExpediente_,
			@RequestParam(value = "y41bBandejaEOCTP_CheckExcluirAcuses", required = false) String y41bBandejaEOCTP_CheckExcluirAcuses_,
			HttpServletRequest request) {
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date trFechaDesde = Y41bUtils.parseDate(trFechaDesde_, locale);
			Date trFechaHasta = Y41bUtils.parseDate(trFechaHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;
			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			String mocodigoExpediente = ("".equals(mocodigoExpediente_)) ? null : mocodigoExpediente_;
			// control checks
			String y41bBandejaEOCTP_CheckExcluirAcuses = ("on".equals(y41bBandejaEOCTP_CheckExcluirAcuses_))
					? Y41bConstantes.VALOR_SI : Y41bConstantes.VALOR_NO;

			BandejaSolicitudesController.logger
					.info("desde: " + trFechaDesde + " hasta: " + trFechaHasta + " trcodigo: " + trcodigo);

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaSolicitudes bandejaSolicitudes = new BandejaSolicitudes();
			bandejaSolicitudes.setTrcodigo(trcodigo);
			bandejaSolicitudes.setHccoor(codOrg);
			bandejaSolicitudes.setHdcomo(mocodigoExpediente);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				// Dejamos en sesin el objeto pagination
				request.getSession().setAttribute("paginationBandejaSolicitudesEOCTP", pagination);

				List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = null;

				if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
								.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
					listBandejaSolicitudesBusqueda = this.bandejaSolicitudesService.findAllBandejaSolicitudesEOCTP(
							bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta,
							y41bBandejaEOCTP_CheckExcluirAcuses, pagination);

					if (listBandejaSolicitudesBusqueda == null) {
						throw new Exception("No data Found.");
					}
				} else {
					listBandejaSolicitudesBusqueda = new ArrayList<BandejaSolicitudesBusqueda>();
				}

				Long total = new Long(0);
				if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
								.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
					total = this.bandejaSolicitudesService.findAllBandejaSolicitudesEOCTPCount(bandejaSolicitudes,
							censoMonitor, trFechaDesde, trFechaHasta, y41bBandejaEOCTP_CheckExcluirAcuses);
				}
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listBandejaSolicitudesBusqueda);
				return data;
			} else {
				List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = null;

				if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
								.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
					listBandejaSolicitudesBusqueda = this.bandejaSolicitudesService.findAllBandejaSolicitudesEOCTP(
							bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta,
							y41bBandejaEOCTP_CheckExcluirAcuses, null);

					if (listBandejaSolicitudesBusqueda == null) {
						throw new Exception("No data Found.");
					}
				} else {
					listBandejaSolicitudesBusqueda = new ArrayList<BandejaSolicitudesBusqueda>();
				}

				return listBandejaSolicitudesBusqueda;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllBandejaSolicitudesEOCTPSession'.
	 * 
	 * @param trFechaDesde_
	 *            String
	 * @param trFechaHasta_
	 *            String
	 * @param trcodigo_
	 *            String
	 * @param codOrg_
	 *            String
	 * @param mocodigoExpediente_
	 *            String
	 * @param y41bBandejaEOCTP_CheckExcluirAcuses_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busquedaBandejaEOCTPSession", method = RequestMethod.GET)
	public @ResponseBody Object getAllBandejaSolicitudesEOCTPSession(
			@RequestParam(value = "trFechaDesde", required = false) String trFechaDesde_,
			@RequestParam(value = "trFechaHasta", required = false) String trFechaHasta_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_,
			@RequestParam(value = "codOrg", required = false) String codOrg_,
			@RequestParam(value = "mocodigoExpediente", required = false) String mocodigoExpediente_,
			@RequestParam(value = "y41bBandejaEOCTP_CheckExcluirAcuses", required = false) String y41bBandejaEOCTP_CheckExcluirAcuses_,
			HttpServletRequest request) {
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date trFechaDesde = Y41bUtils.parseDate(trFechaDesde_, locale);
			Date trFechaHasta = Y41bUtils.parseDate(trFechaHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;
			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			String mocodigoExpediente = ("".equals(mocodigoExpediente_)) ? null : mocodigoExpediente_;
			// control checks
			String y41bBandejaEOCTP_CheckExcluirAcuses = ("on".equals(y41bBandejaEOCTP_CheckExcluirAcuses_))
					? Y41bConstantes.VALOR_SI : Y41bConstantes.VALOR_NO;

			BandejaSolicitudesController.logger
					.info("desde: " + trFechaDesde + " hasta: " + trFechaHasta + " trcodigo: " + trcodigo);

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaSolicitudes bandejaSolicitudes = new BandejaSolicitudes();
			bandejaSolicitudes.setTrcodigo(trcodigo);
			bandejaSolicitudes.setHccoor(codOrg);
			bandejaSolicitudes.setHdcomo(mocodigoExpediente);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = (Pagination) request.getSession().getAttribute("paginationBandejaSolicitudesEOCTP");

				// Si al refrescar la tabla existen menos elementos y la pgina
				// guardada en sesin no existe, se debe seleccionar la ltima
				// pgina con datos
				Long totalReg = new Long(0);
				totalReg = this.bandejaSolicitudesService.findAllBandejaSolicitudesEOCTPCount(bandejaSolicitudes,
						censoMonitor, trFechaDesde, trFechaHasta, y41bBandejaEOCTP_CheckExcluirAcuses);
				Long totalSesion = new Long(0);
				Long page = new Long(0);
				totalSesion = pagination.getPage() * pagination.getRows();
				totalSesion = totalSesion - pagination.getRows();

				if (totalSesion >= totalReg) {
					page = totalReg / pagination.getRows();
					pagination.setPage(page);
				}

				List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = null;

				listBandejaSolicitudesBusqueda = this.bandejaSolicitudesService.findAllBandejaSolicitudesEOCTP(
						bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta,
						y41bBandejaEOCTP_CheckExcluirAcuses, pagination);

				if (listBandejaSolicitudesBusqueda == null) {
					throw new Exception("No data Found.");
				}

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(pagination.getPage().toString());
				data.setRecords(totalReg.intValue());
				data.setTotal(totalReg, pagination.getRows());
				data.setRows(listBandejaSolicitudesBusqueda);
				return data;
			} else {
				List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = null;

				if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
						&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
								.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
					listBandejaSolicitudesBusqueda = this.bandejaSolicitudesService.findAllBandejaSolicitudesEOCTP(
							bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta,
							y41bBandejaEOCTP_CheckExcluirAcuses, null);

					if (listBandejaSolicitudesBusqueda == null) {
						throw new Exception("No data Found.");
					}
				} else {
					listBandejaSolicitudesBusqueda = new ArrayList<BandejaSolicitudesBusqueda>();
				}

				return listBandejaSolicitudesBusqueda;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllSolicitudExcelBandejaEONYPD'.
	 * 
	 * @param trFechaDesde_
	 *            String
	 * @param trFechaHasta_
	 *            String
	 * @param trcodigo_
	 *            String
	 * @param codOrg_
	 *            String
	 * @param mocodigoExpediente_
	 *            String
	 * @param y41bBandejaEONYPD_CheckNuevos_
	 *            String
	 * @param y41bBandejaEONYPD_CheckSinDecision_
	 *            String
	 * @param y41bBandejaEONYPD_CheckExcluirAcuses_
	 *            String
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excelBandejaEONYPD", method = RequestMethod.GET)
	public @ResponseBody void getAllSolicitudExcelBandejaEONYPD(
			@RequestParam(value = "trFechaDesde", required = false) String trFechaDesde_,
			@RequestParam(value = "trFechaHasta", required = false) String trFechaHasta_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_,
			@RequestParam(value = "codOrg", required = false) String codOrg_,
			@RequestParam(value = "mocodigoExpediente", required = false) String mocodigoExpediente_,
			@RequestParam(value = "y41bBandejaEONYPD_CheckNuevos", required = false) String y41bBandejaEONYPD_CheckNuevos_,
			@RequestParam(value = "y41bBandejaEONYPD_CheckSinDecision", required = false) String y41bBandejaEONYPD_CheckSinDecision_,
			@RequestParam(value = "y41bBandejaEONYPD_CheckExcluirAcuses", required = false) String y41bBandejaEONYPD_CheckExcluirAcuses_,
			HttpServletRequest request, HttpServletResponse response) {
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date trFechaDesde = Y41bUtils.parseDate(trFechaDesde_, locale);
			Date trFechaHasta = Y41bUtils.parseDate(trFechaHasta_, locale);

			// control checks
			String y41bBandejaENYPD_CheckNuevos = ("on".equals(y41bBandejaEONYPD_CheckNuevos_))
					? Y41bConstantes.VALOR_SI : Y41bConstantes.VALOR_NO;
			String y41bBandejaENYPD_CheckSinDecision = ("on".equals(y41bBandejaEONYPD_CheckSinDecision_))
					? Y41bConstantes.VALOR_SI : Y41bConstantes.VALOR_NO;

			// control checks
			String y41bBandejaEONYPD_CheckExcluirAcuses = ("on".equals(y41bBandejaEONYPD_CheckExcluirAcuses_))
					? Y41bConstantes.VALOR_SI : Y41bConstantes.VALOR_NO;

			Boolean conAsignacionResp = false;
			if (y41bBandejaENYPD_CheckNuevos.equalsIgnoreCase(Y41bConstantes.VALOR_SI)
					&& y41bBandejaENYPD_CheckSinDecision.equalsIgnoreCase(Y41bConstantes.VALOR_SI)) {
				conAsignacionResp = true;
			} else if (y41bBandejaENYPD_CheckNuevos.equalsIgnoreCase(Y41bConstantes.VALOR_SI)
					&& y41bBandejaENYPD_CheckSinDecision.equalsIgnoreCase(Y41bConstantes.VALOR_NO)) {
				conAsignacionResp = true;
			} else if (y41bBandejaENYPD_CheckNuevos.equalsIgnoreCase(Y41bConstantes.VALOR_NO)
					&& y41bBandejaENYPD_CheckSinDecision.equalsIgnoreCase(Y41bConstantes.VALOR_SI)) {
				conAsignacionResp = false;
			} else if (y41bBandejaENYPD_CheckNuevos.equalsIgnoreCase(Y41bConstantes.VALOR_NO)
					&& y41bBandejaENYPD_CheckSinDecision.equalsIgnoreCase(Y41bConstantes.VALOR_NO)) {
				conAsignacionResp = false;
			}

			// control de los campos susceptibles de llegar a "" desde el filtro
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;
			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			String mocodigoExpediente = ("".equals(mocodigoExpediente_)) ? null : mocodigoExpediente_;

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaSolicitudes bandejaSolicitudes = new BandejaSolicitudes();

			bandejaSolicitudes.setTrcodigo(trcodigo);
			bandejaSolicitudes.setHccoor(codOrg);
			bandejaSolicitudes.setHdcomo(mocodigoExpediente);

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy, "yyyyMMddHHmmss");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_BANDEJA_SOLICITUDES_ECTPO + fechaActual + ".xls";
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(nombre) + "\"");

			String xslString = this.y41bExcelGeneratorService.getSolicitudesExcelBandejaEONYPD(bandejaSolicitudes,
					censoMonitor, trFechaDesde, trFechaHasta, conAsignacionResp, y41bBandejaEONYPD_CheckExcluirAcuses);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllSolicitudExcelBandejaECTP'.
	 * 
	 * @param trFechaDesde_
	 *            String
	 * @param trFechaHasta_
	 *            String
	 * @param trcodigo_
	 *            String
	 * @param codOrg_
	 *            String
	 * @param mocodigoExpediente_
	 *            String
	 * @param y41bBandejaEOCTP_CheckExcluirAcuses_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excelBandejaEOCTP", method = RequestMethod.GET)
	public @ResponseBody void getAllSolicitudExcelBandejaEOCTP(
			@RequestParam(value = "trFechaDesde", required = false) String trFechaDesde_,
			@RequestParam(value = "trFechaHasta", required = false) String trFechaHasta_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_,
			@RequestParam(value = "codOrg", required = false) String codOrg_,
			@RequestParam(value = "mocodigoExpediente", required = false) String mocodigoExpediente_,
			@RequestParam(value = "y41bBandejaEOCTP_CheckExcluirAcuses", required = false) String y41bBandejaEOCTP_CheckExcluirAcuses_,
			HttpServletRequest request, HttpServletResponse response) {
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date trFechaDesde = Y41bUtils.parseDate(trFechaDesde_, locale);
			Date trFechaHasta = Y41bUtils.parseDate(trFechaHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;
			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			String mocodigoExpediente = ("".equals(mocodigoExpediente_)) ? null : mocodigoExpediente_;
			// control checks
			String y41bBandejaEOCTP_CheckExcluirAcuses = ("on".equals(y41bBandejaEOCTP_CheckExcluirAcuses_))
					? Y41bConstantes.VALOR_SI : Y41bConstantes.VALOR_NO;

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaSolicitudes bandejaSolicitudes = new BandejaSolicitudes();

			bandejaSolicitudes.setTrcodigo(trcodigo);
			bandejaSolicitudes.setHccoor(codOrg);
			bandejaSolicitudes.setHdcomo(mocodigoExpediente);

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy, "yyyyMMddHHmmss");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_BANDEJA_SOLICITUDES_ECTPO + fechaActual + ".xls";
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(nombre) + "\"");

			String xslString = this.y41bExcelGeneratorService.getSolicitudesExcelBandejaEOCTP(bandejaSolicitudes,
					censoMonitor, trFechaDesde, trFechaHasta, y41bBandejaEOCTP_CheckExcluirAcuses);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

}