package com.ejie.y41b.control;

import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.BandejaInspecciones;
import com.ejie.y41b.model.BandejaInspeccionesFiltro;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.TramiteHechoDetalle;
import com.ejie.y41b.model.TramiteInspeccionDetalle;
import com.ejie.y41b.service.ActuacionService;
import com.ejie.y41b.service.BandejaInspeccionesService;
import com.ejie.y41b.service.Y41bExcelGeneratorService;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * BandejaInspeccionesController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/bandejainspecciones")
@SessionAttributes(value = { "idTramiteHechoSolicitud", "idActuacion" })
public class BandejaInspeccionesController {

	private static final Logger logger = LoggerFactory
			.getLogger(BandejaInspeccionesController.class);

	@Autowired()
	private BandejaInspeccionesService bandejaInspeccionesService;

	@Autowired()
	private ActuacionService actuacionService;

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private Y41bExcelGeneratorService y41bExcelGeneratorService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		BandejaInspeccionesController.logger
				.info("[GET - View] : bandejainspecciones");
		return "bandejainspecciones";
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterBandejaInspecciones
	 *            BandejaInspecciones
	 * @param request
	 *            HttpServletRequest
	 * @return List
	 */
	@RequestMapping(value = "/findAll", method = RequestMethod.GET)
	public @ResponseBody()
	List<BandejaInspecciones> getAll(
			@ModelAttribute() BandejaInspecciones filterBandejaInspecciones,
			HttpServletRequest request) {
		BandejaInspeccionesController.logger
				.info("[GET - find_ALL] : Obtener BandejaInspecciones por filtro");

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		return this.bandejaInspeccionesService.findAll(
				filterBandejaInspecciones, null, censoMonitor, null);
	}

	/**
	 * Method 'getAllBandejaInspecciones'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/findAllBandeja", method = RequestMethod.GET)
	public @ResponseBody()
	Object getAllBandejaInspecciones(HttpServletRequest request, Model model) {
		try {
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaInspecciones filterBandejaInspecciones = new BandejaInspecciones();

			BandejaInspeccionesFiltro bandejaInspeccionesFiltro = this
					.parseRequestFormularioBandejaInspeccionesFiltro(request);

			if (Y41bConstantes.PERFIL_SUPERVISOR.equals(censoMonitor
					.getPerfilInspecciones().getIdPerfil())) {
				// Lo ve todo.
			} else if ((Y41bConstantes.PERFIL_INSTRUCTOR.equals(censoMonitor
					.getPerfilInspecciones().getIdPerfil())
					|| Y41bConstantes.PERFIL_COORDINADOR.equals(censoMonitor
							.getPerfilInspecciones().getIdPerfil()) || Y41bConstantes.PERFIL_TECNICO_CONTROL_MERCADO
					.equals(censoMonitor.getPerfilInspecciones().getIdPerfil()))
					&& Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO
							.equals(censoMonitor.getPerfilOrganizacion()
									.getIdPerfil())) {

				if (Y41bConstantes.PERFIL_INSTRUCTOR.equals(censoMonitor
						.getPerfilInspecciones().getIdPerfil())) {
					bandejaInspeccionesFiltro.setCodOrg(null);
				}
				// Lo ve todo.
			} else if (Y41bConstantes.PERFIL_COORDINADOR.equals(censoMonitor
					.getPerfilInspecciones().getIdPerfil())
					|| Y41bConstantes.PERFIL_TECNICO_CONTROL_MERCADO
							.equals(censoMonitor.getPerfilInspecciones()
									.getIdPerfil())
					|| Y41bConstantes.PERFIL_ADMINISTRATIVO.equals(censoMonitor
							.getPerfilInspecciones().getIdPerfil())) {
				// Ve lo de la OT.
				filterBandejaInspecciones.setAdcoor(censoMonitor.getOrganismo()
						.getCodOrg());
			} else if (Y41bConstantes.PERFIL_INSTRUCTOR.equals(censoMonitor
					.getPerfilInspecciones().getIdPerfil())) {
				filterBandejaInspecciones.setAdcoor(censoMonitor.getOrganismo()
						.getCodOrg());
				// Ve los asignados a el.
				filterBandejaInspecciones.setAccomo(censoMonitor.getMocodigo());
			}

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setAscDsc(request.getParameter("sord"));
				pagination.setSord(request.getParameter("sord"));
				pagination.setSidx(request.getParameter("sidx"));

				List<BandejaInspecciones> listInspecciones = this.bandejaInspeccionesService
						.findAll(filterBandejaInspecciones, pagination,
								censoMonitor, bandejaInspeccionesFiltro);

				if (listInspecciones == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.bandejaInspeccionesService.findAllCount(
						filterBandejaInspecciones, censoMonitor,
						bandejaInspeccionesFiltro);

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listInspecciones);
				return data;
			} else {
				List<BandejaInspecciones> listInspecciones = this.bandejaInspeccionesService
						.findAll(filterBandejaInspecciones, pagination,
								censoMonitor, bandejaInspeccionesFiltro);
				if (listInspecciones == null) {
					throw new Exception("No data Found.");
				}
				return listInspecciones;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'busquedaBandejaECTPOcount'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busquedaBandejaInspeccionesCount", method = RequestMethod.GET)
	public @ResponseBody()
	Long getAllBandejaInspeccionesCount(HttpServletRequest request) {
		try {
			BandejaInspecciones filterBandejaInspecciones = new BandejaInspecciones();

			BandejaInspeccionesFiltro bandejaInspeccionesFiltro = this
					.parseRequestFormularioBandejaInspeccionesFiltro(request);

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			if (Y41bConstantes.PERFIL_SUPERVISOR.equals(censoMonitor
					.getPerfilInspecciones().getIdPerfil())) {
				// Lo ve todo.
			} else if ((Y41bConstantes.PERFIL_INSTRUCTOR.equals(censoMonitor
					.getPerfilInspecciones().getIdPerfil())
					|| Y41bConstantes.PERFIL_COORDINADOR.equals(censoMonitor
							.getPerfilInspecciones().getIdPerfil()) || Y41bConstantes.PERFIL_TECNICO_CONTROL_MERCADO
					.equals(censoMonitor.getPerfilInspecciones().getIdPerfil()))
					&& Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO
							.equals(censoMonitor.getPerfilOrganizacion()
									.getIdPerfil())) {

				if (Y41bConstantes.PERFIL_INSTRUCTOR.equals(censoMonitor
						.getPerfilInspecciones().getIdPerfil())) {
					bandejaInspeccionesFiltro.setCodOrg(null);
				}
				// Lo ve todo.
			} else if (Y41bConstantes.PERFIL_COORDINADOR.equals(censoMonitor
					.getPerfilInspecciones().getIdPerfil())
					|| Y41bConstantes.PERFIL_TECNICO_CONTROL_MERCADO
							.equals(censoMonitor.getPerfilInspecciones()
									.getIdPerfil())
					|| Y41bConstantes.PERFIL_ADMINISTRATIVO.equals(censoMonitor
							.getPerfilInspecciones().getIdPerfil())) {
				// Ve lo de la OT.
				filterBandejaInspecciones.setAdcoor(censoMonitor.getOrganismo()
						.getCodOrg());
			} else if (Y41bConstantes.PERFIL_INSTRUCTOR.equals(censoMonitor
					.getPerfilInspecciones().getIdPerfil())) {
				filterBandejaInspecciones.setAdcoor(censoMonitor.getOrganismo()
						.getCodOrg());
				// Ve los asignados a el.
				filterBandejaInspecciones.setAccomo(censoMonitor.getMocodigo());
			}

			return this.bandejaInspeccionesService.findAllCount(
					filterBandejaInspecciones, censoMonitor,
					bandejaInspeccionesFiltro);
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param bandejaInspecciones
	 *            BandejaInspecciones
	 * @return BandejaInspecciones
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	BandejaInspecciones edit(
			@RequestBody() BandejaInspecciones bandejaInspecciones) {
		BandejaInspecciones bandejaInspeccionesAux = this.bandejaInspeccionesService
				.update(bandejaInspecciones);
		BandejaInspeccionesController.logger
				.info("[PUT] : BandejaInspecciones actualizado correctamente");
		return bandejaInspeccionesAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param bandejaInspecciones
	 *            BandejaInspecciones
	 * @return BandejaInspecciones
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	BandejaInspecciones add(
			@RequestBody() BandejaInspecciones bandejaInspecciones) {
		BandejaInspecciones bandejaInspeccionesAux = this.bandejaInspeccionesService
				.add(bandejaInspecciones);
		BandejaInspeccionesController.logger
				.info("[POST] : BandejaInspecciones insertado correctamente");
		return bandejaInspeccionesAux;
	}

	/**
	 * Method 'getTramitesPendientesForm'.
	 * 
	 * @param idActuacion
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "tramitesPendientes/{idActuacion}", method = RequestMethod.GET)
	public ModelAndView getTramitesPendientesForm(
			@PathVariable() String idActuacion, Model model) {

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(idActuacion);
		String numExpediente = this.actuacionService
				.findNumExpedienteInspeccion(actuacion);

		model.addAttribute("idActuacion", idActuacion);
		model.addAttribute("numExpediente", numExpediente);

		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("tramitesPendientesInspecciones", "model",
				model);
	}

	/**
	 * Method 'getAllTramitesPendientes'.
	 * 
	 * @param idActuacion
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllTramitesPendientes", method = RequestMethod.GET)
	public @ResponseBody()
	Object getAllTramitesPendientes(
			@ModelAttribute(value = "idActuacion") String idActuacion,
			HttpServletRequest request) {
		try {
			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(idActuacion);

			TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();
			tramiteHechoDetalle.setHdcodigo(idActuacion);

			Pagination pagination = null;
			List<TramiteInspeccionDetalle> listTramitesPendientes = null;

			BandejaInspecciones bandejaInspecciones = new BandejaInspecciones();
			bandejaInspecciones.setAtcodigo(idActuacion);

			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				listTramitesPendientes = this.bandejaInspeccionesService
						.findAllTramitesPendientes(bandejaInspecciones,
								pagination);

				if (listTramitesPendientes == null) {
					throw new Exception("No data Found.");
				}

				Long total = new Long(0);
				total = this.bandejaInspeccionesService
						.findAllTramitesPendientesCount(bandejaInspecciones);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listTramitesPendientes);

				return data;
			} else {
				listTramitesPendientes = this.bandejaInspeccionesService
						.findAllTramitesPendientes(bandejaInspecciones, null);

				if (listTramitesPendientes == null) {
					throw new Exception("No data Found.");
				}

				return listTramitesPendientes;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Recoge el filtro del formulario de la Bandeja de Inspecciones y lo
	 * transforma en un objeto.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return BandejaInspeccionesFiltro
	 */
	private BandejaInspeccionesFiltro parseRequestFormularioBandejaInspeccionesFiltro(
			HttpServletRequest request) {
		BandejaInspeccionesFiltro bandejaInspeccionesFiltro = new BandejaInspeccionesFiltro();

		Locale locale = LocaleContextHolder.getLocale();

		try {
			// campos formulario
			String codOrg = request.getParameter("codOrg");
			if (codOrg != null && !"".equals(codOrg)) {
				bandejaInspeccionesFiltro.setCodOrg(codOrg);
			}

			String mocodigoExpediente = request
					.getParameter("mocodigoExpediente");
			if (mocodigoExpediente != null && !"".equals(mocodigoExpediente)) {
				bandejaInspeccionesFiltro
						.setMocodigoExpediente(mocodigoExpediente);
			}

			String accoororigen = request.getParameter("accoororigen");
			if (accoororigen != null && !"".equals(accoororigen)) {
				bandejaInspeccionesFiltro.setAccoororigen(accoororigen);
			}

			String attipo = request.getParameter("attipo");
			if (attipo != null && !"".equals(attipo)) {
				bandejaInspeccionesFiltro.setAttipo(attipo);
			}

			String atcocm = request.getParameter("atcocm");
			if (atcocm != null && !"".equals(atcocm)) {
				bandejaInspeccionesFiltro.setAtcocm(atcocm);
			}

			String alnror = request.getParameter("alnror");
			if (alnror != null && !"".equals(alnror)) {
				bandejaInspeccionesFiltro.setAlnror(alnror);
			}

			String alnran = request.getParameter("alnran");
			if (alnran != null && !"".equals(alnran)) {
				bandejaInspeccionesFiltro.setAlnran(alnran);
			}

			String v6codigo = request.getParameter("v6codigo");
			if (v6codigo != null && !"".equals(v6codigo)) {
				bandejaInspeccionesFiltro.setV6codigo(v6codigo);
			}

			String decoor = request.getParameter("decoor");
			if (decoor != null && !"".equals(decoor)) {
				bandejaInspeccionesFiltro.setDecoor(decoor);
			}

			String denror = request.getParameter("denror");
			if (denror != null && !"".equals(denror)) {
				bandejaInspeccionesFiltro.setDenror(denror);
			}

			String denran = request.getParameter("denran");
			if (denran != null && !"".equals(denran)) {
				bandejaInspeccionesFiltro.setDenran(denran);
			}

			String trcodigo = request.getParameter("trcodigo");
			if (trcodigo != null && !"".equals(trcodigo)) {
				bandejaInspeccionesFiltro.setTrcodigo(trcodigo);
			}

			String trFechaDesde = request.getParameter("trFechaDesde");
			if (!Y41bUtils.esNullOCadenaVacia(trFechaDesde)) {
				trFechaDesde = trFechaDesde.concat(" 00:00:00");

				bandejaInspeccionesFiltro.setTrFechaDesde(Y41bUtils
						.parseDateTime(trFechaDesde, locale));
			}

			String trFechaHasta = request.getParameter("trFechaHasta");
			if (!Y41bUtils.esNullOCadenaVacia(trFechaHasta)) {
				trFechaHasta = trFechaHasta.concat(" 23:59:59");

				bandejaInspeccionesFiltro.setTrFechaHasta(Y41bUtils
						.parseDateTime(trFechaHasta, locale));
			}

			return bandejaInspeccionesFiltro;
		} catch (Exception e) {
			BandejaInspeccionesController.logger
					.error("###########################ERROR PARSEO FILTRO DE BANDEJA INSPECCION",
							e);
			throw new MethodFailureException(
					"Method failed parseRequestFormularioBandejaInspeccionesFiltro");
		}
	}

	/**
	 * Metodo para generar un archivo excel con los filtrados correspondientes *
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excelBandejaInspecciones", method = RequestMethod.GET)
	public void getAllConsultaExcel(HttpServletRequest request,
			HttpServletResponse response) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaInspecciones filterBandejaInspecciones = new BandejaInspecciones();

			BandejaInspeccionesFiltro bandejaInspeccionesFiltro = this
					.parseRequestFormularioBandejaInspeccionesFiltro(request);

			if (Y41bConstantes.PERFIL_SUPERVISOR.equals(censoMonitor
					.getPerfilInspecciones().getIdPerfil())) {
				// Lo ve todo.
			} else if ((Y41bConstantes.PERFIL_INSTRUCTOR.equals(censoMonitor
					.getPerfilInspecciones().getIdPerfil())
					|| Y41bConstantes.PERFIL_COORDINADOR.equals(censoMonitor
							.getPerfilInspecciones().getIdPerfil()) || Y41bConstantes.PERFIL_TECNICO_CONTROL_MERCADO
					.equals(censoMonitor.getPerfilInspecciones().getIdPerfil()))
					&& Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO
							.equals(censoMonitor.getPerfilOrganizacion()
									.getIdPerfil())) {

				if (Y41bConstantes.PERFIL_INSTRUCTOR.equals(censoMonitor
						.getPerfilInspecciones().getIdPerfil())) {
					bandejaInspeccionesFiltro.setCodOrg(null);
				}
				// Lo ve todo.
			} else if (Y41bConstantes.PERFIL_COORDINADOR.equals(censoMonitor
					.getPerfilInspecciones().getIdPerfil())
					|| Y41bConstantes.PERFIL_TECNICO_CONTROL_MERCADO
							.equals(censoMonitor.getPerfilInspecciones()
									.getIdPerfil())
					|| Y41bConstantes.PERFIL_ADMINISTRATIVO.equals(censoMonitor
							.getPerfilInspecciones().getIdPerfil())) {
				// Ve lo de la OT.
				filterBandejaInspecciones.setAdcoor(censoMonitor.getOrganismo()
						.getCodOrg());
			} else if (Y41bConstantes.PERFIL_INSTRUCTOR.equals(censoMonitor
					.getPerfilInspecciones().getIdPerfil())) {
				filterBandejaInspecciones.setAdcoor(censoMonitor.getOrganismo()
						.getCodOrg());
				// Ve los asignados a el.
				filterBandejaInspecciones.setAccomo(censoMonitor.getMocodigo());
			}

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy,
					"yyyyMMddHHmmss");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_BUSQUEDA_BANDINSPECCIONES
					+ fechaActual + ".xls";
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ StringEscapeUtils.unescapeHtml(nombre) + "\"");

			String xslString = this.y41bExcelGeneratorService
					.getBandejaInspeccionesExcel(filterBandejaInspecciones,
							censoMonitor, bandejaInspeccionesFiltro);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}
}
