package com.ejie.y41b.control;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.xpath.XPathAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.adapter.Y41bDokusiAdapterService;
import com.ejie.y41b.adapter.Y41bPifAdapterService;
import com.ejie.y41b.adapter.Y41bPlateaAdapterService;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Arbadhsolcomdoc;
import com.ejie.y41b.model.Arbdoctemp;
import com.ejie.y41b.model.BandejaFirma;
import com.ejie.y41b.model.BandejaFirmaBusqueda;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DocumentoHechoDetalle;
import com.ejie.y41b.model.Parametros;
import com.ejie.y41b.model.Sandoctemp;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.dokusi.User;
import com.ejie.y41b.model.platea.Procedure;
import com.ejie.y41b.nshf.SignCertificateType;
import com.ejie.y41b.service.ArbadhsolcomdocService;
import com.ejie.y41b.service.ArbdoctempService;
import com.ejie.y41b.service.BandejaFirmaService;
import com.ejie.y41b.service.DenunciaService;
import com.ejie.y41b.service.ParametrosService;
import com.ejie.y41b.service.SandoctempService;
import com.ejie.y41b.service.Y41bExcelGeneratorService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.platea.Y41bFuncionesAuxiliaresPlatea;

import sun.misc.BASE64Decoder;

/**
 * BandejaFirmaController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/bandejaFirma")
@SessionAttributes({ "bandejaFirma" })
public class BandejaFirmaController {

	private static final Logger logger = LoggerFactory.getLogger(BandejaFirmaController.class);

	@Autowired
	private BandejaFirmaService bandejaFirmaService;

	@Autowired
	private DenunciaService denunciaService;

	@Autowired
	private ParametrosService parametrosService;

	@Autowired()
	private Y41bPlateaAdapterService y41bPlateaAdapterService;

	@Autowired
	private Properties appConfiguration;

	@Autowired
	private Y41bExcelGeneratorService y41bExcelGeneratorService;

	@Autowired()
	private Y41bDokusiAdapterService y41bDokusiAdapterService;

	@Autowired()
	private Y41bPifAdapterService y41bPifAdapterService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */
	@Autowired
	private Y41bUDAErrorManager errorManager;
	@Autowired
	private SandoctempService sandoctempService;
	@Autowired
	private ArbdoctempService arbdoctempService;
	@Autowired
	private ArbadhsolcomdocService arbadhsolcomdocService;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {
		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;
		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idBandejaFirma
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint/{codProcedimiento}/{idBandejaFirma}", method = RequestMethod.GET)
	public ModelAndView getCreateForm(@PathVariable String codProcedimiento, @PathVariable String idBandejaFirma,
			Model model) {
		logger.info("Entramos en la bandeja de firma - idBandejaFirma:" + idBandejaFirma);
		BandejaFirma bandejaFirma = new BandejaFirma();
		bandejaFirma.setPcodigo(codProcedimiento);
		bandejaFirma.setIdbandejafirma(idBandejaFirma);

		model.addAttribute("bandejaFirma", bandejaFirma);

		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("bandejaFirma", "model", model);
	}

	/**
	 * Method 'getCreateFormDenegacion'.
	 * 
	 * @param idBandejaFirma
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintdenegacion/{idBandejaFirma}", method = RequestMethod.GET)
	public ModelAndView getCreateFormDenegacion(@PathVariable String idBandejaFirma, Model model) {
		logger.info("Entramos en la bandeja de firma - idBandejaFirma:" + idBandejaFirma);
		BandejaFirma bandejaFirma = new BandejaFirma();
		bandejaFirma.setIdbandejafirma(idBandejaFirma);

		model.addAttribute("bandejaFirma", bandejaFirma);

		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("denegacionbandejaFirma", "model", model);
	}

	/**
	 * Method 'getCreateFormDenegacion'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintFirmaMultiple", method = RequestMethod.GET)
	public ModelAndView getCreateFormFirmaMultiple(Model model, HttpServletRequest request) {
		String idsbandejafirma = request.getParameter("idsbandejafirma");

		model.addAttribute("idsbandejafirma", idsbandejafirma);

		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("bandejaFirmaMultiple", "model", model);
	}

	/**
	 * Method 'findBandejaFirmaById'.
	 * 
	 * @param idbandejafirma
	 *            String
	 * @return bandejaFirmaBusqueda BandejaFirmaBusqueda
	 */
	@RequestMapping(value = "/findBandejaFirmaById/{idbandejafirma}", method = RequestMethod.GET)
	public @ResponseBody BandejaFirmaBusqueda findBandejaFirmaById(@PathVariable String idbandejafirma) {
		BandejaFirma bandejaFirma = new BandejaFirma();
		bandejaFirma.setIdbandejafirma(idbandejafirma);

		BandejaFirmaBusqueda bandejaFirmaBusqueda = new BandejaFirmaBusqueda();
		try {
			bandejaFirmaBusqueda = this.bandejaFirmaService.findBandejaFirma(bandejaFirma);
			if (bandejaFirma == null) {
				throw new Exception(idbandejafirma.toString());
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException(idbandejafirma.toString());
		}
		return bandejaFirmaBusqueda;
	}

	/**
	 * Method 'findBandejaFirmaDoc'.
	 * 
	 * @param codocumento
	 *            String
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findBandejaFirmaDoc/{codocumento}", method = RequestMethod.GET)
	public @ResponseBody void findBandejaFirmaDoc(@PathVariable String codocumento,
			@ModelAttribute(value = "bandejaFirma") BandejaFirma bandejaFirma, HttpServletResponse response) {
		try {
			String codProc = bandejaFirma.getPcodigo();

			if (codProc != null && codProc.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				DocumentoHechoDetalle documentoHechoDetalle = new DocumentoHechoDetalle();
				documentoHechoDetalle.setQ5codocumento(codocumento);

				documentoHechoDetalle = this.denunciaService.findDocumentoHecho(documentoHechoDetalle);

				Blob contenido = documentoHechoDetalle.getQ5datafile();
				byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

				// Cambiamos el objeto Response para visualizar el contenido del
				// archivo
				response.setHeader("Content-Disposition", "attachment; filename=\""
						+ StringEscapeUtils.unescapeHtml(documentoHechoDetalle.getQ5nofile()) + "\"");
				response.setContentType(documentoHechoDetalle.getQ5contenttypefile());
				response.setContentLength(documentoHechoDetalle.getQ5sizefile());
				response.getOutputStream().write(bContenido);

				// Vaciamos el stream
				response.getOutputStream().flush();
			} else if (codProc != null && codProc.equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

				Sandoctemp sandoctemp = new Sandoctemp();
				sandoctemp.setU5codocumento(codocumento);
				sandoctemp = this.sandoctempService.find(sandoctemp);

				Blob contenido = sandoctemp.getU5datafile();

				// byte[] bContenido = contenido.getBytes(1, (int)
				// contenido.length());

				// Cambiamos el objeto Response para visualizar el contenido del
				// archivo
				response.setHeader("Content-Disposition",
						"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(sandoctemp.getU5nofile()) + "\"");
				response.setContentType(sandoctemp.getU5conttype());
				response.setContentLength(sandoctemp.getU5sizefile());
				// response.getOutputStream().write(bContenido);
				Y41bUtils.copyStream(contenido.getBinaryStream(), response.getOutputStream());

				// Vaciamos el stream
				response.getOutputStream().flush();
			} else if (codProc != null && codProc.equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {

				Arbdoctemp arbdoctemp = new Arbdoctemp();
				arbdoctemp.setX5codocumento(codocumento);
				arbdoctemp = this.arbdoctempService.find(arbdoctemp);

				Blob contenido = arbdoctemp.getX5datafile();

				// byte[] bContenido = contenido.getBytes(1, (int)
				// contenido.length());

				// Cambiamos el objeto Response para visualizar el contenido del
				// archivo
				response.setHeader("Content-Disposition",
						"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(arbdoctemp.getX5nofile()) + "\"");
				response.setContentType(arbdoctemp.getX5conttype());
				response.setContentLength(arbdoctemp.getX5sizefile());
				// response.getOutputStream().write(bContenido);
				Y41bUtils.copyStream(contenido.getBinaryStream(), response.getOutputStream());

				// Vaciamos el stream
				response.getOutputStream().flush();
			} else if (codProc != null && (codProc.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
					|| codProc.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
					|| codProc.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {

				Arbadhsolcomdoc arbadhsolcomdoc = new Arbadhsolcomdoc();
				arbadhsolcomdoc.setXmcodocumento(codocumento);
				arbadhsolcomdoc = this.arbadhsolcomdocService.find(arbadhsolcomdoc);

				Blob contenido = arbadhsolcomdoc.getXmdatafile();
				// byte[] bContenido = contenido.getBytes(1, (int)
				// contenido.length());

				// Cambiamos el objeto Response para visualizar el contenido del
				// archivo
				response.setHeader("Content-Disposition", "attachment; filename=\""
						+ StringEscapeUtils.unescapeHtml(arbadhsolcomdoc.getXmnofile()) + "\"");
				response.setContentType(arbadhsolcomdoc.getXmconttype());
				response.setContentLength(arbadhsolcomdoc.getXmsizefile());
				// response.getOutputStream().write(bContenido);
				Y41bUtils.copyStream(contenido.getBinaryStream(), response.getOutputStream());

				// Vaciamos el stream
				response.getOutputStream().flush();
			} else if (codProc != null && codProc.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				DocumentoHechoDetalle documentoHechoDetalle = new DocumentoHechoDetalle();
				documentoHechoDetalle.setQ5codocumento(codocumento);

				documentoHechoDetalle = this.denunciaService.findDocumentoHecho(documentoHechoDetalle);

				Blob contenido = documentoHechoDetalle.getQ5datafile();
				byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

				// Cambiamos el objeto Response para visualizar el contenido del
				// archivo
				response.setHeader("Content-Disposition", "attachment; filename=\""
						+ StringEscapeUtils.unescapeHtml(documentoHechoDetalle.getQ5nofile()) + "\"");
				response.setContentType(documentoHechoDetalle.getQ5contenttypefile());
				response.setContentLength(documentoHechoDetalle.getQ5sizefile());
				response.getOutputStream().write(bContenido);

				// Vaciamos el stream
				response.getOutputStream().flush();
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException(codocumento.toString());
		}
	}

	/**
	 * Method 'findBandejaFirmaDocHash'.
	 * 
	 * @param idbandejafirma
	 *            String
	 * @return String Hash del documento vinculado a la bandeja
	 */
	@RequestMapping(value = "/findBandejaFirmaDocHash/{idbandejafirma}", method = RequestMethod.GET)
	public @ResponseBody String findBandejaFirmaDocHash(@PathVariable String idbandejafirma) {
		String hashDocumento = "";
		BandejaFirma bandejaFirma = new BandejaFirma();
		bandejaFirma.setIdbandejafirma(idbandejafirma);
		try {
			// 1. Recupero la bandeja
			bandejaFirma = this.bandejaFirmaService.find(bandejaFirma);
			if (bandejaFirma == null) {
				throw new Exception(idbandejafirma.toString());
			}
			// 2. Recupero los bytes dependiendo del tipo de procedimiento
			String codProc = bandejaFirma.getPcodigo();
			byte[] bContenido = null;
			Procedure procedure = new Procedure();
			if (codProc != null && codProc.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				DocumentoHechoDetalle documentoHechoDetalle = new DocumentoHechoDetalle();

				documentoHechoDetalle.setQ5codocumento(bandejaFirma.getCodocumento());

				documentoHechoDetalle = this.denunciaService.findDocumentoHecho(documentoHechoDetalle);

				Blob contenido = documentoHechoDetalle.getQ5datafile();
				bContenido = contenido.getBytes(1, (int) contenido.length());

				procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);
			} else if (codProc != null && codProc.equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				Sandoctemp sandoctemp = new Sandoctemp();

				sandoctemp.setU5codocumento(bandejaFirma.getCodocumento());
				sandoctemp = this.sandoctempService.find(sandoctemp);

				Blob contenido = sandoctemp.getU5datafile();
				bContenido = contenido.getBytes(1, (int) contenido.length());

				procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES);

			} else if (codProc != null && codProc.equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				Arbdoctemp arbdoctemp = new Arbdoctemp();

				arbdoctemp.setX5codocumento(bandejaFirma.getCodocumento());
				arbdoctemp = this.arbdoctempService.find(arbdoctemp);

				Blob contenido = arbdoctemp.getX5datafile();
				bContenido = contenido.getBytes(1, (int) contenido.length());

				procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE);

			} else if (codProc != null && (codProc.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
					|| codProc.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
					|| codProc.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				Arbadhsolcomdoc arbadhsolcomdoc = new Arbadhsolcomdoc();
				arbadhsolcomdoc.setXmcodocumento(bandejaFirma.getCodocumento());
				arbadhsolcomdoc = this.arbadhsolcomdocService.find(arbadhsolcomdoc);
				Blob contenido = arbadhsolcomdoc.getXmdatafile();
				bContenido = contenido.getBytes(1, (int) contenido.length());

				procedure.setIdProcedimiento(Y41bFuncionesAuxiliaresPlatea.devuelveCodigoProcedimientoPlatea(codProc));
			}
			if (codProc != null && codProc.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				DocumentoHechoDetalle documentoHechoDetalle = new DocumentoHechoDetalle();

				documentoHechoDetalle.setQ5codocumento(bandejaFirma.getCodocumento());

				documentoHechoDetalle = this.denunciaService.findDocumentoHecho(documentoHechoDetalle);

				Blob contenido = documentoHechoDetalle.getQ5datafile();
				bContenido = contenido.getBytes(1, (int) contenido.length());

				procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);
			}
			// 3. Recuperamos el Hash del documento
			Documento documento = new Documento();
			User user = new User();
			user.setNombre(Y41bConstantes.COD_APLICACION);
			user.setDni(Y41bConstantes.COD_APLICACION);
			documento.setUser(user);
			documento.setProcedure(procedure);
			documento.setOidDokusi(bandejaFirma.getIddocumentum());
			if (bandejaFirma.getNofile() != null) {
				documento.setNombre(Y41bUtils.getNameFile(bandejaFirma.getNofile()));
				documento.setExtension(Y41bUtils.getExtensionFile(bandejaFirma.getNofile()));
			}

			if (documento != null && documento.getExtension() != null
					&& !documento.getExtension().equalsIgnoreCase(Y41bConstantes.PDF)) {
				throw new Y41bUDAException("error.bandejafirma.sinlocalizador", true, new Exception());
			}

			documento.setBytes(new String(bContenido));
			hashDocumento = y41bPlateaAdapterService.generarHashDocumento(documento);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new ResourceNotFoundException(idbandejafirma.toString());
		}
		return hashDocumento;
	}

	/**
	 * Method 'denegarBandejaFirmaDoc'.
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/denegarBandejaFirmaDoc", method = RequestMethod.PUT)
	public @ResponseBody void denegarBandejaFirmaDoc(@RequestBody BandejaFirma bandejaFirma,
			HttpServletRequest request) {
		try {
			// Anyadimos a la bandejaFirma informacion de BBDD de esa bandeja
			// que vamos a necesitar
			BandejaFirma bandejaFirmaBBDD = this.bandejaFirmaService.find(bandejaFirma);
			bandejaFirma.setCodocumento(bandejaFirmaBBDD.getCodocumento());
			bandejaFirma.setIdtramitehecho(bandejaFirmaBBDD.getIdtramitehecho());
			bandejaFirma.setIddocumentum(bandejaFirmaBBDD.getIddocumentum());
			bandejaFirma.setNofile(bandejaFirmaBBDD.getNofile());
			bandejaFirma.setPcodigo(bandejaFirmaBBDD.getPcodigo());

			// Dependiendo del procedimiento ejecutaremos sus acciones
			String codProc = bandejaFirma.getPcodigo();
			if (codProc != null && codProc.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				this.bandejaFirmaService.denegarBandejaFirmaDocSol(bandejaFirma);
			} else if (codProc != null && codProc.equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				this.bandejaFirmaService.denegarBandejaFirmaDocSan(bandejaFirma);
			} else if (codProc != null && codProc.equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				this.bandejaFirmaService.denegarBandejaFirmaDocArb(bandejaFirma);
			} else if (codProc != null && (codProc.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
					|| codProc.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
					|| codProc.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				this.bandejaFirmaService.denegarBandejaFirmaDocAdh(bandejaFirma);
			} else if (codProc != null && codProc.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				this.bandejaFirmaService.denegarBandejaFirmaDocIns(bandejaFirma);
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'saveBandejaFirmaDocHash'.
	 * 
	 * @param listBandejaFirma
	 *            List<BandejaFirma>
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/saveBandejaFirmaDocHash", method = RequestMethod.PUT)
	public @ResponseBody void saveBandejaFirmaDocHash(@RequestBody List listBandejaFirma, HttpServletRequest request) {
		try {
			HashMap hashmap = new HashMap();
			BandejaFirma bandejaFirma = null;
			String rutaPifFileFirma = "";

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			for (int i = 0; i < listBandejaFirma.size(); i++) {
				hashmap = (HashMap) listBandejaFirma.get(i);
				bandejaFirma = new BandejaFirma();

				bandejaFirma.setIdbandejafirma((String) hashmap.get("idbandejafirma"));
				rutaPifFileFirma = (String) hashmap.get("rutaPifFileFirma");

				bandejaFirma.setComofirma(censoMonitor.getMocodigo());

				// Anyadimos a la bandejaFirma informacion de BBDD de esa
				// bandeja
				// que vamos a necesitar
				BufferedInputStream bIS = this.y41bPifAdapterService.getFile(rutaPifFileFirma);

				// Verificar firmante
				BASE64Decoder b64Decoder = new BASE64Decoder();
				String firmaCodificada = this.extraerFirma(Y41bUtils.convertInputStreamToString(bIS));
				bandejaFirma.setFirma(firmaCodificada);
				String strFirmaDecodificada = new String(b64Decoder.decodeBuffer(firmaCodificada));
				DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
				factory.setValidating(false);
				factory.setIgnoringElementContentWhitespace(true);
				DocumentBuilder builder = factory.newDocumentBuilder();
				StringReader stringIn = null;

				Parametros parametros = new Parametros();
				parametros.setParametro(Y41bConstantes.VALIDAR_FIRMANTE_BANDEJA_FIRMA);

				parametros = this.parametrosService.find(parametros);

				if (parametros.getValor() != null
						&& parametros.getValor().toUpperCase().equals(Y41bConstantes.VALOR_SI)) {

					stringIn = new StringReader(strFirmaDecodificada);

					Document document = builder.parse(new InputSource(stringIn));
					String strCertificado = this.buscarDomString(document, "//X509Certificate/text()");

					SignCertificateType signCertificateType = this.y41bPlateaAdapterService
							.verifyCertificate(b64Decoder.decodeBuffer(strCertificado));

					if (signCertificateType.getSuscriptor() != null
							&& signCertificateType.getSuscriptor().getDni().equals(censoMonitor.getModni())) {
						// Coincide el firmante con el conectado
					} else if (signCertificateType.getEntidad() != null
							&& signCertificateType.getEntidad().getCif().equals(censoMonitor.getModni())) {
						// Coincide el firmante con el conectado
					} else {
						// No coincide el firmante con el conectado
						throw new Y41bUDAException("error.bandejafirma.nocoincide", true, new Exception());
					}
				}

				// Anyadimos a la bandejaFirma informacion de BBDD de esa
				// bandeja
				// que vamos a necesitar
				BandejaFirma bandejaFirmaBBDD = null;
				bandejaFirmaBBDD = this.bandejaFirmaService.find(bandejaFirma);

				bandejaFirma.setIdbandejafirma(bandejaFirmaBBDD.getIdbandejafirma());
				bandejaFirma.setCodocumento(bandejaFirmaBBDD.getCodocumento());
				bandejaFirma.setIdtramitehecho(bandejaFirmaBBDD.getIdtramitehecho());
				bandejaFirma.setIddocumentum(bandejaFirmaBBDD.getIddocumentum());
				bandejaFirma.setNofile(bandejaFirmaBBDD.getNofile());
				bandejaFirma.setHashfile(bandejaFirmaBBDD.getHashfile());

				// Dependiendo del procedimiento ejecutaremos sus acciones
				String codProc = bandejaFirmaBBDD.getPcodigo();
				if (codProc != null && codProc.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
					this.bandejaFirmaService.saveBandejaFirmaDocHashSol(bandejaFirma);
				} else if (codProc != null && codProc.equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
					bandejaFirma.setIdexpediente(bandejaFirmaBBDD.getIdexpediente());
					this.bandejaFirmaService.saveBandejaFirmaDocHashSan(bandejaFirma);
				} else if (codProc != null && codProc.equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
					bandejaFirma.setIdexpediente(bandejaFirmaBBDD.getIdexpediente());
					this.bandejaFirmaService.saveBandejaFirmaDocHashArb(bandejaFirma);
				} else if (codProc != null && (codProc.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
						|| codProc.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
						|| codProc.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
					this.bandejaFirmaService.saveBandejaFirmaDocHashAdh(bandejaFirma);
				} else if (codProc != null && codProc.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
					this.bandejaFirmaService.saveBandejaFirmaDocHashIns(bandejaFirma);
				}
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'extraerFirma'. Extrae la firma codificada del xml recibido por el
	 * componente de firma
	 * 
	 * @param ejgvDocument
	 *            String en formato XML con una cabecera ejgvDocument que
	 *            contiene la firma codificada en Base 64
	 * @return texto con la firma codificada en Base 64 o null si no existe
	 */
	private String extraerFirma(String ejgvDocument) {
		try {
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			factory.setValidating(false);
			factory.setIgnoringElementContentWhitespace(true);
			DocumentBuilder builder = factory.newDocumentBuilder();
			StringReader stringIn = new StringReader(ejgvDocument);

			Document document = builder.parse(new InputSource(stringIn));

			return this.buscarDomString(document, "//sign/text()");

		} catch (Y41bUDAException e) {
			return null;
		} catch (SAXException e) {
			return null;
		} catch (IOException e) {
			return null;
		} catch (ParserConfigurationException e) {
			return null;
		}
	}

	private String buscarDomString(Document docDom, String strPath) {
		NodeList NodeLiResultado = null;
		String strValor = "";

		try {
			NodeLiResultado = XPathAPI.selectNodeList(docDom, strPath);

			if (NodeLiResultado.getLength() != 0) {
				strValor = (String) NodeLiResultado.item(0).getNodeValue();
			} else {
				strValor = "";
			}

		} catch (Exception ex) {
			ex.printStackTrace(System.out);
		}

		return strValor;
	}

	/**
	 * Method 'getAllBandejaFirma'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busquedaBandejaFirma", method = RequestMethod.GET)
	public @ResponseBody Object getAllBandejaFirma(HttpServletRequest request) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaFirma bandejaFirma = new BandejaFirma();

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				// Dejamos en sesin el objeto pagination
				request.getSession().setAttribute("paginationBandejaFirmas", pagination);

				List<BandejaFirmaBusqueda> listBandejaFirmaBusqueda = this.bandejaFirmaService
						.findAllBandejaFirma(bandejaFirma, censoMonitor, pagination);

				if (listBandejaFirmaBusqueda == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.bandejaFirmaService.findAllBandejaFirmaCount(bandejaFirma, censoMonitor);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listBandejaFirmaBusqueda);
				return data;
			} else {
				List<BandejaFirmaBusqueda> listBandejaFirmaBusqueda = this.bandejaFirmaService
						.findAllBandejaFirma(bandejaFirma, censoMonitor, null);
				if (listBandejaFirmaBusqueda == null) {
					throw new Exception("No data Found.");
				}
				return listBandejaFirmaBusqueda;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllBandejaFirma'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busquedaBandejaFirmaMultiple", method = RequestMethod.GET)
	public @ResponseBody Object getAllBandejaFirmaMultiple(HttpServletRequest request) {
		try {

			String idsbandejafirmaParam = request.getParameter("idsbandejafirma");

			List<String> idsbandejafirmaList = Arrays.asList(idsbandejafirmaParam.split(","));

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				// Dejamos en sesin el objeto pagination
				request.getSession().setAttribute("paginationBandejaFirmas", pagination);

				List<BandejaFirmaBusqueda> listBandejaFirmaBusqueda = this.bandejaFirmaService
						.findAllByIds(idsbandejafirmaList);

				if (listBandejaFirmaBusqueda == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.bandejaFirmaService.findAllByIdsCount(idsbandejafirmaList);

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listBandejaFirmaBusqueda);
				return data;
			} else {
				List<BandejaFirmaBusqueda> listBandejaFirmaBusqueda = this.bandejaFirmaService
						.findAllByIds(idsbandejafirmaList);
				if (listBandejaFirmaBusqueda == null) {
					throw new Exception("No data Found.");
				}
				return listBandejaFirmaBusqueda;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllBandejaFirmaSession'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busquedaBandejaFirmaSession", method = RequestMethod.GET)
	public @ResponseBody Object getAllBandejaFirmaSession(HttpServletRequest request) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaFirma bandejaFirma = new BandejaFirma();

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = (Pagination) request.getSession().getAttribute("paginationBandejaFirmas");

				// Si al refrescar la tabla existen menos elementos y la pgina
				// guardada en sesin no existe se debe seleccionar la ltima
				// pgina con datos
				Long totalReg = new Long(0);
				totalReg = this.bandejaFirmaService.findAllBandejaFirmaCount(bandejaFirma, censoMonitor);
				Long pagSession = new Long(0);
				Long page = new Long(0);
				pagSession = pagination.getPage() * pagination.getRows();
				pagSession = pagSession - pagination.getRows();

				if (pagSession >= totalReg) {
					page = totalReg / pagination.getRows();
					pagination.setPage(page);
				}

				List<BandejaFirmaBusqueda> listBandejaFirmaBusqueda = this.bandejaFirmaService
						.findAllBandejaFirma(bandejaFirma, censoMonitor, pagination);

				if (listBandejaFirmaBusqueda == null) {
					throw new Exception("No data Found.");
				}

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(pagination.getPage().toString());
				data.setRecords(totalReg.intValue());
				data.setTotal(totalReg, pagination.getRows());
				data.setRows(listBandejaFirmaBusqueda);
				return data;
			} else {
				List<BandejaFirmaBusqueda> listBandejaFirmaBusqueda = this.bandejaFirmaService
						.findAllBandejaFirma(bandejaFirma, censoMonitor, null);
				if (listBandejaFirmaBusqueda == null) {
					throw new Exception("No data Found.");
				}
				return listBandejaFirmaBusqueda;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllBandejaFirmaCount'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busquedaBandejaFirmacount", method = RequestMethod.GET)
	public @ResponseBody Long getAllBandejaFirmaCount(HttpServletRequest request) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaFirma bandejaFirma = new BandejaFirma();

			Long total = this.bandejaFirmaService.findAllBandejaFirmaCount(bandejaFirma, censoMonitor);

			return total;
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'findBandejaFirmaDoc'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param codocumento
	 *            String
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findBandejaFirmaDoc/{codProcedimiento}/{codocumento}", method = RequestMethod.GET)
	public @ResponseBody void findBandejaFirmaDoc(@PathVariable String codProcedimiento,
			@PathVariable String codocumento, HttpServletResponse response) {
		try {

			if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				DocumentoHechoDetalle documentoHechoDetalle = new DocumentoHechoDetalle();
				documentoHechoDetalle.setQ5codocumento(codocumento);

				documentoHechoDetalle = this.denunciaService.findDocumentoHecho(documentoHechoDetalle);

				Blob contenido = documentoHechoDetalle.getQ5datafile();
				byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

				// Cambiamos el objeto Response para visualizar el contenido del
				// archivo
				response.setHeader("Content-Disposition", "attachment; filename=\""
						+ StringEscapeUtils.unescapeHtml(documentoHechoDetalle.getQ5nofile()) + "\"");
				response.setContentType(documentoHechoDetalle.getQ5contenttypefile());
				response.setContentLength(documentoHechoDetalle.getQ5sizefile());
				response.getOutputStream().write(bContenido);

				// Vaciamos el stream
				response.getOutputStream().flush();
			} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

				Sandoctemp sandoctemp = new Sandoctemp();
				sandoctemp.setU5codocumento(codocumento);
				sandoctemp = this.sandoctempService.find(sandoctemp);

				// byte[] bContenido = sandoctemp.getU5datafile().getBytes(1,
				// (int) sandoctemp.getU5datafile().length());

				// Cambiamos el objeto Response para visualizar el contenido del
				// archivo
				response.setHeader("Content-Disposition",
						"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(sandoctemp.getU5nofile()) + "\"");
				response.setContentType(sandoctemp.getU5conttype());
				response.setContentLength(sandoctemp.getU5sizefile());
				// response.getOutputStream().write(bContenido);
				Y41bUtils.copyStream(sandoctemp.getU5datafile().getBinaryStream(), response.getOutputStream());

				// Vaciamos el stream
				response.getOutputStream().flush();
			} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {

				Arbdoctemp arbdoctemp = new Arbdoctemp();
				arbdoctemp.setX5codocumento(codocumento);
				arbdoctemp = this.arbdoctempService.find(arbdoctemp);

				Blob contenido = arbdoctemp.getX5datafile();
				// byte[] bContenido = contenido.getBytes(1, (int)
				// contenido.length());

				// Cambiamos el objeto Response para visualizar el contenido del
				// archivo
				response.setHeader("Content-Disposition",
						"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(arbdoctemp.getX5nofile()) + "\"");
				response.setContentType(arbdoctemp.getX5conttype());
				response.setContentLength(arbdoctemp.getX5sizefile());
				// response.getOutputStream().write(bContenido);
				Y41bUtils.copyStream(contenido.getBinaryStream(), response.getOutputStream());

				// Vaciamos el stream
				response.getOutputStream().flush();
			} else if (codProcedimiento != null && (codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
					|| codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
					|| codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {

				Arbadhsolcomdoc arbadhsolcomdoc = new Arbadhsolcomdoc();
				arbadhsolcomdoc.setXmcodocumento(codocumento);
				arbadhsolcomdoc = this.arbadhsolcomdocService.find(arbadhsolcomdoc);

				Blob contenido = arbadhsolcomdoc.getXmdatafile();
				// byte[] bContenido = contenido.getBytes(1, (int)
				// contenido.length());

				// Cambiamos el objeto Response para visualizar el contenido del
				// archivo
				response.setHeader("Content-Disposition", "attachment; filename=\""
						+ StringEscapeUtils.unescapeHtml(arbadhsolcomdoc.getXmnofile()) + "\"");
				response.setContentType(arbadhsolcomdoc.getXmconttype());
				response.setContentLength(arbadhsolcomdoc.getXmsizefile());
				// response.getOutputStream().write(bContenido);
				Y41bUtils.copyStream(contenido.getBinaryStream(), response.getOutputStream());

				// Vaciamos el stream
				response.getOutputStream().flush();
			} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				DocumentoHechoDetalle documentoHechoDetalle = new DocumentoHechoDetalle();
				documentoHechoDetalle.setQ5codocumento(codocumento);

				documentoHechoDetalle = this.denunciaService.findDocumentoHecho(documentoHechoDetalle);

				Blob contenido = documentoHechoDetalle.getQ5datafile();
				byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

				// Cambiamos el objeto Response para visualizar el contenido del
				// archivo
				response.setHeader("Content-Disposition", "attachment; filename=\""
						+ StringEscapeUtils.unescapeHtml(documentoHechoDetalle.getQ5nofile()) + "\"");
				response.setContentType(documentoHechoDetalle.getQ5contenttypefile());
				response.setContentLength(documentoHechoDetalle.getQ5sizefile());
				response.getOutputStream().write(bContenido);

				// Vaciamos el stream
				response.getOutputStream().flush();
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException(codocumento.toString());
		}
	}

	/*---- excel Bandeja-----*/

	/**
	 * Method 'getAllBandejaFirma'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excelBandeja", method = RequestMethod.GET)
	public @ResponseBody void getAllExcelBandejaFirma(HttpServletRequest request, HttpServletResponse response) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaFirma bandejaFirma = new BandejaFirma();

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy, "yyyyMMddHHmmss");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_BANDEJA_FIRMA + fechaActual + ".xls";
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(nombre) + "\"");

			String xslString = this.y41bExcelGeneratorService.getFirmasExcelBandeja(bandejaFirma, censoMonitor);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'subirDocumentoPIF'.
	 * 
	 * @param nombreDocumento
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/subirDocumentoPIFMultiple", method = RequestMethod.POST)
	public @ResponseBody List<BandejaFirma> subirDocumentoPIFMultiple(HttpServletRequest request) {

		List<BandejaFirma> listaDocumentos = new ArrayList<BandejaFirma>();

		String idsbandejafirmaParam = request.getParameter("idsbandejafirma");
		List<String> idsbandejafirmaList = Arrays.asList(idsbandejafirmaParam.split(","));

		String codProc = null;
		Procedure procedure = null;
		for (String idbandejafirma : idsbandejafirmaList) {
			BandejaFirma bandejaFirma = new BandejaFirma();
			bandejaFirma.setIdbandejafirma(idbandejafirma);
			bandejaFirma = this.bandejaFirmaService.find(bandejaFirma);

			Documento documento = new Documento();
			User user = new User();
			user.setNombre(Y41bConstantes.COD_APLICACION);
			user.setDni(Y41bConstantes.COD_APLICACION);
			documento.setUser(user);

			procedure = new Procedure();
			if (codProc != null && codProc.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

				procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);
			} else if (codProc != null && codProc.equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

				procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES);

			} else if (codProc != null && codProc.equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {

				procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE);

			} else if (codProc != null && (codProc.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
					|| codProc.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
					|| codProc.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				procedure.setIdProcedimiento(Y41bFuncionesAuxiliaresPlatea.devuelveCodigoProcedimientoPlatea(codProc));
			}
			if (codProc != null && codProc.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

				procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);
			}

			documento.setProcedure(procedure);
			documento.setOidDokusi(bandejaFirma.getIddocumentum());

			String pathTo = "/" + Y41bConstantes.COD_APLICACION_HSHF.toLowerCase() + "/"
					+ Y41bConstantes.COD_APLICACION.toLowerCase();

			Documento documentoRdo = y41bDokusiAdapterService.descargarPifDocumentoDokusiRuta(documento, pathTo);

			bandejaFirma.setRutaPif(documentoRdo.getPifId());

			listaDocumentos.add(bandejaFirma);
		}

		return listaDocumentos;
	}

}
