package com.ejie.y41b.control;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.BandejaCampanha;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.service.BandejaCampanhaService;
import com.ejie.y41b.service.CensoMonitorService;
import com.ejie.y41b.service.Y41bExcelGeneratorService;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * BandejaCampanhaController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/bandejacampanha")
public class BandejaCampanhaController {

	private static final Logger logger = LoggerFactory
			.getLogger(BandejaCampanhaController.class);

	@Autowired
	private BandejaCampanhaService bandejaCampanhaService;

	@Autowired
	private Y41bExcelGeneratorService y41bExcelGeneratorService;

	@Autowired()
	private CensoMonitorService censoMonitorService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		BandejaCampanhaController.logger.info("[GET - View] : bandejacampanha");
		return "bandejacampanha";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param tzcodigo
	 *            String
	 * @return bandejaCampanha BandejaCampanha
	 */
	@RequestMapping(value = "/{tzcodigo}", method = RequestMethod.GET)
	public @ResponseBody
	BandejaCampanha getById(@PathVariable String tzcodigo) {
		BandejaCampanha bandejaCampanha = new BandejaCampanha();
		bandejaCampanha.setTzcodigo(tzcodigo);
		bandejaCampanha = this.bandejaCampanhaService.find(bandejaCampanha);
		BandejaCampanhaController.logger
				.info("[GET - findBy_PK] : Obtener BandejaCampanha por PK");
		return bandejaCampanha;
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param bandejaCampanha
	 *            BandejaCampanha
	 * @return BandejaCampanha
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	BandejaCampanha edit(@RequestBody BandejaCampanha bandejaCampanha) {
		BandejaCampanha bandejaCampanhaAux = this.bandejaCampanhaService
				.update(bandejaCampanha);
		BandejaCampanhaController.logger
				.info("[PUT] : BandejaCampanha actualizado correctamente");
		return bandejaCampanhaAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param bandejaCampanha
	 *            BandejaCampanha
	 * @return BandejaCampanha
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	BandejaCampanha add(@RequestBody BandejaCampanha bandejaCampanha) {
		BandejaCampanha bandejaCampanhaAux = this.bandejaCampanhaService
				.add(bandejaCampanha);
		BandejaCampanhaController.logger
				.info("[POST] : BandejaCampanha insertado correctamente");
		return bandejaCampanhaAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param tzcodigo
	 *            String
	 * @return bandejaCampanha
	 */
	@RequestMapping(value = "/{tzcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	BandejaCampanha remove(@PathVariable String tzcodigo) {
		BandejaCampanha bandejaCampanha = new BandejaCampanha();
		bandejaCampanha.setTzcodigo(tzcodigo);
		this.bandejaCampanhaService.remove(bandejaCampanha);
		BandejaCampanhaController.logger
				.info("[DELETE] : BandejaCampanha borrado correctamente");
		return bandejaCampanha;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param bandejaCampanhaIds
	 *            List
	 * @return bandejaCampanhaList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> bandejaCampanhaIds) {
		List<BandejaCampanha> bandejaCampanhaList = new ArrayList<BandejaCampanha>();
		for (List<String> bandejaCampanhaId : bandejaCampanhaIds) {
			Iterator<String> iterator = bandejaCampanhaId.iterator();
			BandejaCampanha bandejaCampanha = new BandejaCampanha(); // NOPMD -
																		// Objeto
																		// nuevo
																		// en la
																		// lista
																		// (parametro
																		// del
																		// servicio)
			bandejaCampanha.setTzcodigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			bandejaCampanhaList.add(bandejaCampanha);
		}
		this.bandejaCampanhaService.removeMultiple(bandejaCampanhaList);
		BandejaCampanhaController.logger
				.info("[POST - DELETE_ALL] : BandejaCampanha borrados correctamente");
		return bandejaCampanhaIds;
	}

	/**
	 * Method 'getAllBandejaCampanhas'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busquedaBandejaCampanhas", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllBandejaCampanhas(HttpServletRequest request) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaCampanha bandejaCampanha = new BandejaCampanha();
			String coor = "";
			if (censoMonitor.getOrganismo() != null) {
				coor = censoMonitor.getOrganismo().getCodOrg();
			}
			bandejaCampanha.setTzcoor(coor);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setAscDsc(request.getParameter("sord"));

				String sort = request.getParameter("sidx");
				if ("campanha.cmcodigo".equals(sort)) {
					sort = "cmcodigo";
				} else if ("campanha.cmnombre".equals(sort)) {
					sort = "cmnombre";
				}
				pagination.setSort(sort);

				List<BandejaCampanha> listBandejaCampanha = null;

				listBandejaCampanha = this.bandejaCampanhaService.findAll(
						bandejaCampanha, censoMonitor, pagination);

				if (listBandejaCampanha == null) {
					throw new Exception("No data Found.");
				}

				request.getSession().setAttribute("paginationBandejaCampanha",
						pagination);

				Long total = this.bandejaCampanhaService.findAllCount(
						bandejaCampanha, censoMonitor);

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listBandejaCampanha);
				return data;
			} else {
				List<BandejaCampanha> listBandejaCampanha = null;

				listBandejaCampanha = this.bandejaCampanhaService.findAll(
						bandejaCampanha, censoMonitor, null);

				if (listBandejaCampanha == null) {
					throw new Exception("No data Found.");
				}

				return listBandejaCampanha;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllBandejaCampanhasCount'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busquedaBandejaCampanhascount", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllBandejaCampanhasCount(HttpServletRequest request) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaCampanha bandejaCampanha = new BandejaCampanha();
			String coor = "";
			if (censoMonitor.getOrganismo() != null) {
				coor = censoMonitor.getOrganismo().getCodOrg();
			}
			bandejaCampanha.setTzcoor(coor);

			Long total = this.bandejaCampanhaService.findAllCount(
					bandejaCampanha, censoMonitor);

			return total;
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Metodo para generar un archivo excel con los filtrados correspondientes *
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excelBandejaCampanhas", method = RequestMethod.GET)
	public void getAllConsultaExcel(HttpServletRequest request,
			HttpServletResponse response) {
		try {

			HttpSession httpSession = request.getSession();

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy,
					"yyyyMMddHHmmss");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_BUSQUEDA_BANDCAMPANHAS
					+ fechaActual + ".xls";
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ StringEscapeUtils.unescapeHtml(nombre) + "\"");

			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			censoMonitor = this.censoMonitorService.find(censoMonitor);
			String perfil = censoMonitor.getPerfilSanciones().getIdPerfil();

			String xslString = this.y41bExcelGeneratorService
					.getBandejaCampanhasExcel(censoMonitor, perfil);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}

	}

	/**
	 * Method 'getAllBandejaCampanhasSSCC'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busquedaBandejaCampanhasSSCC", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllBandejaCampanhasSSCC(HttpServletRequest request) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaCampanha bandejaCampanha = new BandejaCampanha();
			String coor = "";
			if (censoMonitor.getOrganismo() != null) {
				coor = censoMonitor.getOrganismo().getCodOrg();
			}
			bandejaCampanha.setTzcoor(coor);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setAscDsc(request.getParameter("sord"));

				String sort = request.getParameter("sidx");
				if ("campanha.cmcodigo".equals(sort)) {
					sort = "cmcodigo";
				} else if ("campanha.cmnombre".equals(sort)) {
					sort = "cmnombre";
				}
				pagination.setSort(sort);

				List<BandejaCampanha> listBandejaCampanha = null;

				listBandejaCampanha = this.bandejaCampanhaService.findAllSSCC(
						bandejaCampanha, censoMonitor, pagination);

				if (listBandejaCampanha == null) {
					throw new Exception("No data Found.");
				}

				request.getSession().setAttribute("paginationBandejaCampanha",
						pagination);

				Long total = this.bandejaCampanhaService.findAllSSCCCount(
						bandejaCampanha, censoMonitor);

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listBandejaCampanha);
				return data;
			} else {
				List<BandejaCampanha> listBandejaCampanha = null;

				listBandejaCampanha = this.bandejaCampanhaService.findAllSSCC(
						bandejaCampanha, censoMonitor, null);

				if (listBandejaCampanha == null) {
					throw new Exception("No data Found.");
				}

				return listBandejaCampanha;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllBandejaCampanhasCount'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busquedaBandejaCampanhasSSCCcount", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllBandejaCampanhasSSCCCount(HttpServletRequest request) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaCampanha bandejaCampanha = new BandejaCampanha();
			String coor = "";
			if (censoMonitor.getOrganismo() != null) {
				coor = censoMonitor.getOrganismo().getCodOrg();
			}
			bandejaCampanha.setTzcoor(coor);

			Long total = this.bandejaCampanhaService.findAllSSCCCount(
					bandejaCampanha, censoMonitor);

			return total;
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Metodo para generar un archivo excel con los filtrados correspondientes *
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excelBandejaCampanhasSSCC", method = RequestMethod.GET)
	public void getAllConsultaExcelSSCC(HttpServletRequest request,
			HttpServletResponse response) {
		try {

			HttpSession httpSession = request.getSession();

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy,
					"yyyyMMddHHmmss");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_BUSQUEDA_BANDCAMPANHASSSCC
					+ fechaActual + ".xls";
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ StringEscapeUtils.unescapeHtml(nombre) + "\"");

			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			censoMonitor = this.censoMonitorService.find(censoMonitor);
			String perfil = censoMonitor.getPerfilSanciones().getIdPerfil();

			String xslString = this.y41bExcelGeneratorService
					.getBandejaCampanhasSSCCExcel(censoMonitor, perfil);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}

	}

}
