package com.ejie.y41b.control;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.AlertaProgramacion;
import com.ejie.y41b.model.BandejaAlerta;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.service.AlertaProgramacionService;
import com.ejie.y41b.service.BandejaAlertaService;
import com.ejie.y41b.service.CensoMonitorService;
import com.ejie.y41b.service.Y41bExcelGeneratorService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * BandejaAlertaController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/bandejaalerta")
public class BandejaAlertaController {

	private static final Logger logger = LoggerFactory
			.getLogger(BandejaAlertaController.class);

	@Autowired
	private BandejaAlertaService bandejaAlertaService;

	@Autowired
	private AlertaProgramacionService alertaProgramacionService;

	@Autowired
	private Y41bExcelGeneratorService y41bExcelGeneratorService;

	@Autowired()
	private CensoMonitorService censoMonitorService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		BandejaAlertaController.logger.info("[GET - View] : bandejaalerta");
		return "bandejaalerta";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param v5codigo
	 *            String
	 * @return bandejaAlerta BandejaAlerta
	 */
	@RequestMapping(value = "/{v5codigo}", method = RequestMethod.GET)
	public @ResponseBody
	BandejaAlerta getById(@PathVariable String v5codigo) {
		BandejaAlerta bandejaAlerta = new BandejaAlerta();
		bandejaAlerta.setV5codigo(v5codigo);
		bandejaAlerta = this.bandejaAlertaService.find(bandejaAlerta);
		BandejaAlertaController.logger
				.info("[GET - findBy_PK] : Obtener BandejaAlerta por PK");
		return bandejaAlerta;
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param bandejaAlerta
	 *            BandejaAlerta
	 * @return BandejaAlerta
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	BandejaAlerta edit(@RequestBody BandejaAlerta bandejaAlerta) {
		BandejaAlerta bandejaAlertaAux = this.bandejaAlertaService
				.update(bandejaAlerta);
		BandejaAlertaController.logger
				.info("[PUT] : BandejaAlerta actualizado correctamente");
		return bandejaAlertaAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param bandejaAlerta
	 *            BandejaAlerta
	 * @return BandejaAlerta
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	BandejaAlerta add(@RequestBody BandejaAlerta bandejaAlerta) {
		BandejaAlerta bandejaAlertaAux = this.bandejaAlertaService
				.add(bandejaAlerta);
		BandejaAlertaController.logger
				.info("[POST] : BandejaAlerta insertado correctamente");
		return bandejaAlertaAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param v5codigo
	 *            String
	 * @return bandejaAlerta
	 */
	@RequestMapping(value = "/{v5codigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	BandejaAlerta remove(@PathVariable String v5codigo) {
		BandejaAlerta bandejaAlerta = new BandejaAlerta();
		bandejaAlerta.setV5codigo(v5codigo);
		this.bandejaAlertaService.remove(bandejaAlerta);
		BandejaAlertaController.logger
				.info("[DELETE] : BandejaAlerta borrado correctamente");
		return bandejaAlerta;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param bandejaAlertaIds
	 *            List
	 * @return bandejaAlertaList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> bandejaAlertaIds) {
		List<BandejaAlerta> bandejaAlertaList = new ArrayList<BandejaAlerta>();
		for (List<String> bandejaAlertaId : bandejaAlertaIds) {
			Iterator<String> iterator = bandejaAlertaId.iterator();
			BandejaAlerta bandejaAlerta = new BandejaAlerta(); // NOPMD - Objeto
																// nuevo en la
																// lista
																// (parametro
																// del servicio)
			bandejaAlerta.setV5codigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			bandejaAlertaList.add(bandejaAlerta);
		}
		this.bandejaAlertaService.removeMultiple(bandejaAlertaList);
		BandejaAlertaController.logger
				.info("[POST - DELETE_ALL] : BandejaAlerta borrados correctamente");
		return bandejaAlertaIds;
	}

	/**
	 * Method 'getAllBandejaAlertas'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busquedaBandejaAlertas", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllBandejaAlertas(HttpServletRequest request) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaAlerta bandejaAlerta = new BandejaAlerta();
			String coor = "";
			if (censoMonitor.getOrganismo() != null) {
				coor = censoMonitor.getOrganismo().getCodOrg();
			}
			bandejaAlerta.setCrcoor(coor);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<BandejaAlerta> listBandejaAlerta = null;

				listBandejaAlerta = this.bandejaAlertaService.findAll(
						bandejaAlerta, censoMonitor, pagination);

				if (listBandejaAlerta == null) {
					throw new Exception("No data Found.");
				}
				Long total = this.bandejaAlertaService.findAllCount(
						bandejaAlerta, censoMonitor);

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listBandejaAlerta);
				return data;
			} else {
				List<BandejaAlerta> listBandejaAlerta = null;

				listBandejaAlerta = this.bandejaAlertaService.findAll(
						bandejaAlerta, censoMonitor, null);

				if (listBandejaAlerta == null) {
					throw new Exception("No data Found.");
				}

				return listBandejaAlerta;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllBandejaAlertasCount'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busquedaBandejaAlertascount", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllBandejaAlertasCount(HttpServletRequest request) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			BandejaAlerta bandejaAlerta = new BandejaAlerta();
			String coor = "";
			if (censoMonitor.getOrganismo() != null) {
				coor = censoMonitor.getOrganismo().getCodOrg();
			}
			bandejaAlerta.setCrcoor(coor);

			Long total = this.bandejaAlertaService.findAllCount(bandejaAlerta,
					censoMonitor);

			return total;
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'finalizarProgramacion'.
	 * 
	 * @param alertaProgramacion
	 *            AlertaProgramacion
	 * @param response
	 *            HttpServletResponse
	 * @return AlertaProgramacion
	 */
	@RequestMapping(value = "/finalizarProgramacion", method = RequestMethod.PUT)
	public @ResponseBody
	AlertaProgramacion finalizarProgramacion(
			@RequestBody AlertaProgramacion alertaProgramacion,
			HttpServletResponse response) {
		try {
			AlertaProgramacion alertaProgramacionAux = this.alertaProgramacionService
					.finalizarProgramacion(alertaProgramacion);
			BandejaAlertaController.logger
					.info("[PUT] : Alerta actualizado correctamente");
			return alertaProgramacionAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'iniciarNuevaInspeccion'.
	 * 
	 * @param alertaProgramacion
	 *            AlertaProgramacion
	 * @param response
	 *            HttpServletResponse
	 * @return AlertaProgramacion
	 */
	@RequestMapping(value = "/nuevaInspeccion", method = RequestMethod.PUT)
	public @ResponseBody
	AlertaProgramacion iniciarNuevaInspeccion(
			@RequestBody AlertaProgramacion alertaProgramacion,
			HttpServletResponse response) {
		try {
			AlertaProgramacion alertaProgramacionAux = this.alertaProgramacionService
					.iniciarNuevaInspeccion(alertaProgramacion);
			BandejaAlertaController.logger
					.info("[PUT] : Alerta actualizado correctamente");
			return alertaProgramacionAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Metodo para generar un archivo excel con los filtrados correspondientes *
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excelBandejaAlertas", method = RequestMethod.GET)
	public void getAllConsultaExcel(HttpServletRequest request,
			HttpServletResponse response) {
		try {

			HttpSession httpSession = request.getSession();

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy,
					"yyyyMMddHHmmss");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_BUSQUEDA_BANDALERTAS
					+ fechaActual + ".xls";
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ StringEscapeUtils.unescapeHtml(nombre) + "\"");

			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			censoMonitor = this.censoMonitorService.find(censoMonitor);
			String perfil = censoMonitor.getPerfilSanciones().getIdPerfil();

			String xslString = this.y41bExcelGeneratorService
					.getBandejaAlertasExcel(censoMonitor, perfil);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}

	}

	/**
	 * Method 'getAllInspeccionesPendientes'.
	 * 
	 * @param codAlerta_
	 *            String
	 * @param codProgramacionAlerta_
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "getAllInspeccionesPendientes", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllInspeccionesPendientes(
			@RequestParam(value = "codAlerta", required = false) String codAlerta_,
			@RequestParam(value = "codProgramacionAlerta", required = false) String codProgramacionAlerta_,
			Model model, HttpServletRequest request) {

		try {
			String codAlerta = ("".equals(codAlerta_)) ? null : codAlerta_;
			String codProgramacionAlerta = ("".equals(codProgramacionAlerta_)) ? null
					: codProgramacionAlerta_;

			Actuacion actuacion = new Actuacion();

			actuacion.setAtcoal(codAlerta);
			actuacion.setAtcocr(codProgramacionAlerta);

			Long total = this.bandejaAlertaService
					.findAllInspeccionesPendientesCount(actuacion);

			return total;
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

}
