package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.AsientoRegistral;
import com.ejie.y41b.model.AsientoRegistralDetalle;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DocumentoAsientoRegistral;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.service.ArbadhsolService;
import com.ejie.y41b.service.ArbintervService;
import com.ejie.y41b.service.AsientoRegistralService;
import com.ejie.y41b.service.DocumentosAsientoRegistralService;
import com.ejie.y41b.service.IntervinientesService;
import com.ejie.y41b.service.SanintervService;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * AsientoRegistralController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/asientoregistral")
@SessionAttributes({ "idAsiento", "asientoRegistral" })
public class AsientoRegistralController {

	private static final Logger logger = LoggerFactory.getLogger(AsientoRegistralController.class);

	@Autowired
	private AsientoRegistralService asientoRegistralService;

	@Autowired
	private IntervinientesService intervinientesService;

	@Autowired
	private SanintervService sanintervService;

	@Autowired
	private ArbintervService arbintervService;

	@Autowired
	private ArbadhsolService arbadhsolService;

	@Autowired
	private Properties appConfiguration;

	@Autowired
	private DocumentosAsientoRegistralService documentosAsientoRegistralService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getAllBandejaAsientosRegistrales'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/findAllBandejaAsientoRegistral/{pcodigo}", method = RequestMethod.GET)
	public @ResponseBody Object getAllBandejaAsientoRegistral(@PathVariable String pcodigo, HttpServletRequest request,
			Model model) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			AsientoRegistral filterAsientoRegistral = new AsientoRegistral();

			if (pcodigo.equalsIgnoreCase("TODOS")) {
				filterAsientoRegistral.setPcodigo(null);
			} else {
				filterAsientoRegistral.setPcodigo(pcodigo);
			}

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<AsientoRegistral> listAsientoRegistral = this.asientoRegistralService
						.findAllBandejaAsientoRegistral(filterAsientoRegistral, censoMonitor, pagination);

				if (listAsientoRegistral == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.asientoRegistralService.findAllBandejaAsientoRegistralCount(filterAsientoRegistral,
						censoMonitor);

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAsientoRegistral);
				return data;
			} else {
				List<AsientoRegistral> listAsientoRegistral = this.asientoRegistralService
						.findAllBandejaAsientoRegistral(filterAsientoRegistral, censoMonitor, pagination);
				if (listAsientoRegistral == null) {
					throw new Exception("No data Found.");
				}
				return listAsientoRegistral;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllBandejaAsientoRegistralCount'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllBandejaAsientoRegistralCount", method = RequestMethod.GET)
	public @ResponseBody Long getAllBandejaAsientoRegistralCount(HttpServletRequest request) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			AsientoRegistral filterAsientoRegistral = new AsientoRegistral();

			Long total = this.asientoRegistralService.findAllBandejaAsientoRegistralCount(filterAsientoRegistral,
					censoMonitor);

			return total;
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getCreateFormY41bDetalleAsientoRegistral'.
	 * 
	 * @param idAsiento
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "detalle/{idAsiento}", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bDetalleAsientoRegistral(@PathVariable String idAsiento, Model model,
			HttpServletRequest request) {

		AsientoRegistral asientoRegistral = new AsientoRegistral();
		asientoRegistral.setIdAsiento(idAsiento);

		model.addAttribute("asientoRegistral", asientoRegistral);

		model.addAttribute("defaultLanguage", appConfiguration.get("z99aVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("z99aVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilSolicitudes() == null || censoMonitor.getPerfilSolicitudes().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bDetalleAsientoRegistral", "model", model);
		}
	}

	/**
	 * Method 'getByIdAsiento'.
	 * 
	 * @param idAsiento
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * 
	 * 
	 * @return String
	 */
	@RequestMapping(value = "/getbyid/{idAsiento}", method = RequestMethod.GET)
	public @ResponseBody AsientoRegistral getByIdAsiento(@PathVariable String idAsiento, HttpServletRequest request) {
		try {

			AsientoRegistral asientoRegistral = new AsientoRegistral();
			asientoRegistral.setIdAsiento(idAsiento);
			CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			asientoRegistral = this.asientoRegistralService.findAsientoRegistral(asientoRegistral);

			if (asientoRegistral == null) {
				throw new Exception(idAsiento.toString());
			}
			return asientoRegistral;
		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException(idAsiento.toString());
		}
	}

	/**
	 * Method 'getAllIntervinientes'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoAdjuntarDocs
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllIntervinientes/{pcodigo}/{idExpediente}", method = RequestMethod.GET)
	public @ResponseBody Object getAllIntervinientes(@PathVariable String pcodigo, @PathVariable String idExpediente,
			HttpServletRequest request) {

		try {

			TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
			tipoProcedimiento.setPcodigo(pcodigo);

			List<Intervinientes> listIntervinientes = null;

			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdExpediente(idExpediente);

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				listIntervinientes = this.intervinientesService.findAll(intervinientes, null);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

				listIntervinientes = this.sanintervService.findAllIntervinientes(intervinientes, null);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {

				listIntervinientes = this.arbintervService.findAllIntervinientes(intervinientes, null);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {

				// sirve este ? hay algun otro? crear otro similar a los otros?
				// listIntervinientes =
				// this.arbadhsolService.findAllIntervinientes(tramiteComun);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				listIntervinientes = this.intervinientesService.findAllInspecciones(intervinientes, null);
			}
			if (listIntervinientes == null) {
				throw new Exception("No data Found.");
			}
			return listIntervinientes;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'aportacion asiento registral'.
	 * 
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 */

	@RequestMapping(value = "/aportacion", method = RequestMethod.POST)
	public @ResponseBody void addAportacionAR(@RequestBody() AsientoRegistralDetalle asientoRegistralDetalle,
			HttpServletResponse response, HttpServletRequest request, Model model) {
		try {

			long docsSinRellenar = 0;

			DocumentoAsientoRegistral documentoAsientoRegistral = new DocumentoAsientoRegistral();
			AsientoRegistral asientoRegistral = new AsientoRegistral();
			asientoRegistral.setIdAsiento(asientoRegistralDetalle.getIdAsiento());
			documentoAsientoRegistral.setAsientoRegistral(asientoRegistral);

			docsSinRellenar = this.documentosAsientoRegistralService.countDocsSinRellenar(documentoAsientoRegistral);

			if (docsSinRellenar > 0) {
				throw new Y41bUDAException("error.asientoRegistral.documentos", true, new Exception());

			} else {
				this.asientoRegistralService.tramitarDocumentosAsientoRegistral(asientoRegistralDetalle);

				if (asientoRegistralDetalle.getPcodigo().equalsIgnoreCase(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
					this.asientoRegistralService.generarTramiteAportacionDocumentacionSol(asientoRegistralDetalle);
				} else if (asientoRegistralDetalle.getPcodigo()
						.equalsIgnoreCase(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
					this.asientoRegistralService.generarTramiteAportacionDocumentacionIns(asientoRegistralDetalle);
				} else if (asientoRegistralDetalle.getPcodigo().equalsIgnoreCase(Y41bConstantes.TIPO_PROC_SANCIONES)) {
					this.asientoRegistralService.generarTramiteAportacionDocumentacionSan(asientoRegistralDetalle);
				} else if (asientoRegistralDetalle.getPcodigo().equalsIgnoreCase(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
					this.asientoRegistralService.generarTramiteAportacionDocumentacionArb(asientoRegistralDetalle);
				}

			}

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			logger.error("###########################ERROR APORTACION AR", e);
			throw new MethodFailureException("Method failed addAportacionAR");
		}
	}

	/**
	 * Method 'rechazar asiento registral'.
	 * 
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 */
	@RequestMapping(value = "/rechazar", method = RequestMethod.POST)
	public @ResponseBody void rechazarAR(@RequestBody() AsientoRegistralDetalle asientoRegistralDetalle,
			HttpServletResponse response, HttpServletRequest request, Model model) {
		try {

			this.asientoRegistralService.rechazarAR(asientoRegistralDetalle);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			logger.error("###########################ERROR APORTACION AR", e);
			throw new MethodFailureException("Method failed addAportacionAR");
		}
	}

	/**
	 * Method 'aportacion asiento registral'.
	 * 
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 */

	@RequestMapping(value = "/solicitudAR", method = RequestMethod.POST)
	public @ResponseBody long addSolicitudAR(@RequestBody() AsientoRegistralDetalle asientoRegistralDetalle,
			HttpServletResponse response, HttpServletRequest request, Model model) {
		try {

			long docsSinRellenar = 0;

			DocumentoAsientoRegistral documentoAsientoRegistral = new DocumentoAsientoRegistral();
			AsientoRegistral asientoRegistral = new AsientoRegistral();
			asientoRegistral.setIdAsiento(asientoRegistralDetalle.getIdAsiento());
			documentoAsientoRegistral.setAsientoRegistral(asientoRegistral);

			docsSinRellenar = this.documentosAsientoRegistralService.countDocsSinRellenar(documentoAsientoRegistral);

			if (docsSinRellenar > 0) {
				throw new Y41bUDAException("error.asientoRegistral.documentos", true, new Exception());

			} else {
				return docsSinRellenar;

			}

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			logger.error("###########################ERROR APORTACION AR", e);
			throw new MethodFailureException("Method failed addAportacionAR");
		}
	}
}
