package com.ejie.y41b.control;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.model.Arbitro;
import com.ejie.y41b.model.Arta1;
import com.ejie.y41b.service.Arta1Service;

/**
 * Arta1Controller  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/arta1")
public class Arta1Controller {

	private static final Logger logger = LoggerFactory
			.getLogger(Arta1Controller.class);

	@Autowired()
	private Arta1Service arta1Service;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		Arta1Controller.logger.info("[GET - View] : arta1");
		return "arta1";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param arbitroArcodigo
	 *            String
	 * @param m3cota1
	 *            String
	 * @return arta1 Arta1
	 */
	@RequestMapping(value = "/{arbitroArcodigo}/{m3cota1}", method = RequestMethod.GET)
	public @ResponseBody()
	Arta1 getById(@PathVariable() String arbitroArcodigo,
			@PathVariable() String m3cota1) {
		Arta1 arta1 = new Arta1();
		arta1.setArbitro(new Arbitro());
		arta1.getArbitro().setArcodigo(arbitroArcodigo);
		arta1.setM3cota1(m3cota1);
		arta1 = this.arta1Service.find(arta1);
		Arta1Controller.logger.info("[GET - findBy_PK] : Obtener Arta1 por PK");
		return arta1;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterArta1
	 *            Arta1
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Arta1> getAll(@ModelAttribute() Arta1 filterArta1) {
		Arta1Controller.logger
				.info("[GET - find_ALL] : Obtener Arta1 por filtro");
		return this.arta1Service.findAll(filterArta1, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param arta1
	 *            Arta1
	 * @return Arta1
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Arta1 edit(@RequestBody() Arta1 arta1) {
		Arta1 arta1Aux = this.arta1Service.update(arta1);
		Arta1Controller.logger.info("[PUT] : Arta1 actualizado correctamente");
		return arta1Aux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param arta1
	 *            Arta1
	 * @return Arta1
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Arta1 add(@RequestBody() Arta1 arta1) {
		Arta1 arta1Aux = this.arta1Service.add(arta1);
		Arta1Controller.logger.info("[POST] : Arta1 insertado correctamente");
		return arta1Aux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param arbitroArcodigo
	 *            String
	 * @param m3cota1
	 *            String
	 * @return arta1
	 */
	@RequestMapping(value = "/{arbitroArcodigo}/{m3cota1}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Arta1 remove(@PathVariable() String arbitroArcodigo,
			@PathVariable() String m3cota1) {
		Arta1 arta1 = new Arta1();
		arta1.setArbitro(new Arbitro());
		arta1.getArbitro().setArcodigo(arbitroArcodigo);
		arta1.setM3cota1(m3cota1);
		this.arta1Service.remove(arta1);
		Arta1Controller.logger.info("[DELETE] : Arta1 borrado correctamente");
		return arta1;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param arta1Ids
	 *            List
	 * @return arta1List
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(@RequestBody() List<List<String>> arta1Ids) {
		List<Arta1> arta1List = new ArrayList<Arta1>();
		for (List<String> arta1Id : arta1Ids) {
			Iterator<String> iterator = arta1Id.iterator();
			Arta1 arta1 = new Arta1(); // NOPMD - Objeto nuevo en la lista
										// (parametro del servicio)
			arta1.setArbitro(new Arbitro()); // NOPMD - Objeto nuevo en la lista
												// (parametro del servicio)
			arta1.getArbitro().setArcodigo(
					ObjectConversionManager.convert(iterator.next(),
							String.class));
			arta1.setM3cota1(ObjectConversionManager.convert(iterator.next(),
					String.class));
			arta1List.add(arta1);
		}
		this.arta1Service.removeMultiple(arta1List);
		Arta1Controller.logger
				.info("[POST - DELETE_ALL] : Arta1 borrados correctamente");
		return arta1Ids;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterArta1
	 *            Arta1
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(@ModelAttribute() Arta1 filterArta1,
			@ModelAttribute() Pagination pagination) {
		List<Arta1> arta1s = this.arta1Service.findAll(filterArta1, pagination);
		Long recordNum = this.arta1Service.findAllCount(filterArta1);
		Arta1Controller.logger.info("[GET - jqGrid] : Obtener Arta1");
		return new JQGridJSONModel(pagination, recordNum, arta1s);
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param arcodigo
	 *            String
	 * @return List
	 */
	@RequestMapping(value = "/checks/{arcodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	List<Arta1> getChecks(@PathVariable() String arcodigo) {
		Arta1Controller.logger
				.info("[GET - find_ALL] : Obtener Arta1 por filtro");
		Arta1 filterArta1 = new Arta1();
		Arbitro arbitro = new Arbitro();
		arbitro.setArcodigo(arcodigo);
		filterArta1.setArbitro(arbitro);
		return this.arta1Service.findAll(filterArta1, null);
	}

}
