package com.ejie.y41b.control;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.model.Arbitro;
import com.ejie.y41b.model.Arse;
import com.ejie.y41b.service.ArseService;

/**
 * ArseController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/arse")
public class ArseController {

	private static final Logger logger = LoggerFactory
			.getLogger(ArseController.class);

	@Autowired()
	private ArseService arseService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ArseController.logger.info("[GET - View] : arse");
		return "arse";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param arbitroArcodigo
	 *            String
	 * @param m4cose
	 *            String
	 * @return arse Arse
	 */
	@RequestMapping(value = "/{arbitroArcodigo}/{m4cose}", method = RequestMethod.GET)
	public @ResponseBody()
	Arse getById(@PathVariable() String arbitroArcodigo,
			@PathVariable() String m4cose) {
		Arse arse = new Arse();
		arse.setArbitro(new Arbitro());
		arse.getArbitro().setArcodigo(arbitroArcodigo);
		arse.setM4cose(m4cose);
		arse = this.arseService.find(arse);
		ArseController.logger.info("[GET - findBy_PK] : Obtener Arse por PK");
		return arse;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterArse
	 *            Arse
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Arse> getAll(@ModelAttribute() Arse filterArse) {
		ArseController.logger
				.info("[GET - find_ALL] : Obtener Arse por filtro");
		return this.arseService.findAll(filterArse, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param arse
	 *            Arse
	 * @return Arse
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Arse edit(@RequestBody() Arse arse) {
		Arse arseAux = this.arseService.update(arse);
		ArseController.logger.info("[PUT] : Arse actualizado correctamente");
		return arseAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param arse
	 *            Arse
	 * @return Arse
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Arse add(@RequestBody() Arse arse) {
		Arse arseAux = this.arseService.add(arse);
		ArseController.logger.info("[POST] : Arse insertado correctamente");
		return arseAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param arbitroArcodigo
	 *            String
	 * @param m4cose
	 *            String
	 * @return arse
	 */
	@RequestMapping(value = "/{arbitroArcodigo}/{m4cose}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Arse remove(@PathVariable() String arbitroArcodigo,
			@PathVariable() String m4cose) {
		Arse arse = new Arse();
		arse.setArbitro(new Arbitro());
		arse.getArbitro().setArcodigo(arbitroArcodigo);
		arse.setM4cose(m4cose);
		this.arseService.remove(arse);
		ArseController.logger.info("[DELETE] : Arse borrado correctamente");
		return arse;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param arseIds
	 *            List
	 * @return arseList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(@RequestBody() List<List<String>> arseIds) {
		List<Arse> arseList = new ArrayList<Arse>();
		for (List<String> arseId : arseIds) {
			Iterator<String> iterator = arseId.iterator();
			Arse arse = new Arse(); // NOPMD - Objeto nuevo en la lista
									// (parametro del servicio)
			arse.setArbitro(new Arbitro()); // NOPMD - Objeto nuevo en la lista
											// (parametro del servicio)
			arse.getArbitro().setArcodigo(
					ObjectConversionManager.convert(iterator.next(),
							String.class));
			arse.setM4cose(ObjectConversionManager.convert(iterator.next(),
					String.class));
			arseList.add(arse);
		}
		this.arseService.removeMultiple(arseList);
		ArseController.logger
				.info("[POST - DELETE_ALL] : Arse borrados correctamente");
		return arseIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterArse
	 *            Arse
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(@ModelAttribute() Arse filterArse,
			@ModelAttribute() Pagination pagination) {
		List<Arse> arses = this.arseService.findAll(filterArse, pagination);
		Long recordNum = this.arseService.findAllCount(filterArse);
		ArseController.logger.info("[GET - jqGrid] : Obtener Arse");
		return new JQGridJSONModel(pagination, recordNum, arses);
	}

}
