package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.Arbtramexp2Service;
import com.ejie.y41b.service.Arbtramexp4Service;
import com.ejie.y41b.service.ArbtramexpService;
import com.ejie.y41b.service.SolarbService;
import com.ejie.y41b.service.T17CalleService;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Arbtramexp;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.T17Calle;

/**
 * ArbtramexpController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/arbtramexp")
public class ArbtramexpController {

	private static final Logger logger = LoggerFactory
			.getLogger(ArbtramexpController.class);

	@Autowired
	private ArbtramexpService arbtramexpService;

	@Autowired
	private Arbtramexp2Service arbtramexp2Service;

	@Autowired
	private SolarbService solarbService;

	@Autowired
	private T17CalleService t17calleService;
	@Autowired
	private Arbtramexp4Service arbtramexp4Service;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */
	@Autowired()
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody()
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;
		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			// throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ArbtramexpController.logger.info("[GET - View] : arbtramexp");
		return "arbtramexp";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param trid
	 *            Long
	 * @return arbtramexp Arbtramexp
	 */
	@RequestMapping(value = "/{trid}", method = RequestMethod.GET)
	public @ResponseBody
	Arbtramexp getById(@PathVariable String trid) {
		Arbtramexp arbtramexp = new Arbtramexp();
		arbtramexp.setTrid(trid);
		arbtramexp = this.arbtramexpService.find(arbtramexp);
		ArbtramexpController.logger
				.info("[GET - findBy_PK] : Obtener Arbtramexp por PK");
		if (arbtramexp.getTrnoraCalleId() != null
				&& !arbtramexp.getTrnoraCalleId().equals("")) {
			T17Calle calle = new T17Calle();
			calle.setId(new Long(arbtramexp.getTrnoraCalleId()));
			String nombreCalle = this.t17calleService
					.findCalleConTipoVia(calle);
			arbtramexp.setNombreCalle(nombreCalle);
		}
		return arbtramexp;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterArbtramexp
	 *            Arbtramexp
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Arbtramexp> getAll(@ModelAttribute Arbtramexp filterArbtramexp) {
		ArbtramexpController.logger
				.info("[GET - find_ALL] : Obtener Arbtramexp por filtro");
		return this.arbtramexpService.findAll(filterArbtramexp, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Arbtramexp edit(@RequestBody Arbtramexp arbtramexp) {
		Arbtramexp arbtramexpAux = this.arbtramexp2Service.update(arbtramexp);
		ArbtramexpController.logger
				.info("[PUT] : Arbtramexp actualizado correctamente");
		return arbtramexpAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Arbtramexp add(@RequestBody Arbtramexp arbtramexp) {
		Arbtramexp arbtramexpAux = this.arbtramexp2Service.add(arbtramexp);
		ArbtramexpController.logger
				.info("[POST] : Arbtramexp insertado correctamente");
		return arbtramexpAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param trid
	 *            Long
	 * @return arbtramexp
	 */
	@RequestMapping(value = "/{trid}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Arbtramexp remove(@PathVariable String trid) {
		Arbtramexp arbtramexp = new Arbtramexp();
		arbtramexp.setTrid(trid);
		this.arbtramexp4Service.remove(arbtramexp);
		ArbtramexpController.logger
				.info("[DELETE] : Arbtramexp borrado correctamente");
		return arbtramexp;
	}

	/**
	 * Method 'borraTramite'.
	 * 
	 * @param trid
	 *            BigDecimal
	 */
	@RequestMapping(value = "/eliminarTramite/{trid}", method = RequestMethod.POST)
	public @ResponseBody()
	void borraTramite(@PathVariable() String trid) {
		try {
			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setTrid(trid);
			this.arbtramexp4Service.remove(arbtramexp);
			ArbtramexpController.logger
					.info("[DELETE] :Arbtramexp borrado correctamente");
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException(
					"sanciones.error.eliminacionTramites.Dependencias", true,
					null);
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param arbtramexpIds
	 *            List
	 * @return arbtramexpList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> arbtramexpIds) {
		List<Arbtramexp> arbtramexpList = new ArrayList<Arbtramexp>();
		for (List<String> arbtramexpId : arbtramexpIds) {
			Iterator<String> iterator = arbtramexpId.iterator();
			Arbtramexp arbtramexp = new Arbtramexp(); // NOPMD - Objeto nuevo en
														// la lista (parametro
														// del servicio)
			arbtramexp.setTrid(ObjectConversionManager.convert(iterator.next(),
					String.class));
			arbtramexpList.add(arbtramexp);
		}
		this.arbtramexpService.removeMultiple(arbtramexpList);
		ArbtramexpController.logger
				.info("[POST - DELETE_ALL] : Arbtramexp borrados correctamente");
		return arbtramexpIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterArbtramexp
	 *            Arbtramexp
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Arbtramexp filterArbtramexp,
			@ModelAttribute Pagination pagination) {
		List<Arbtramexp> arbtramexps = this.arbtramexpService.findAll(
				filterArbtramexp, pagination);
		Long recordNum = this.arbtramexpService.findAllCount(filterArbtramexp);
		ArbtramexpController.logger.info("[GET - jqGrid] : Obtener Arbtramexp");
		return new JQGridJSONModel(pagination, recordNum, arbtramexps);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param sacodigo
	 *            String
	 * @return arbtramexp Arbtramexp
	 */
	@RequestMapping(value = "/dameFaseUltimoTramiteEnCurso", method = RequestMethod.GET)
	public @ResponseBody()
	Arbtramexp getFaseYUltimoTramite(
			@RequestParam(value = "sacodigo", required = true) String sacodigo) {
		Arbtramexp arbtramexp = new Arbtramexp();
		try {

			arbtramexp = this.arbtramexpService
					.dameUltimoTramiteEnCurso(sacodigo);
			ArbtramexpController.logger
					.info("[GET - dameFaseUltimoTramiteEnCurso] : ");
			return arbtramexp;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico" + e.getMessage(), true,
					e);
		}
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param sacodigo
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/dameTramitesExp", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(
			@RequestParam(value = "sacodigo", required = false) String sacodigo,
			@ModelAttribute() Pagination pagination) {

		Arbtramexp filterArbtramexp = new Arbtramexp();
		Solarb solarb = new Solarb();
		solarb.setSacodigo(sacodigo);
		filterArbtramexp.setSolarb(solarb);

		List<Arbtramexp> santramexps = this.arbtramexpService.findAll(
				filterArbtramexp, pagination);
		Long recordNum = this.arbtramexpService.findAllCount(filterArbtramexp);
		ArbtramexpController.logger.info("[GET - jqGrid] : Obtener Arbtramexp");
		return new JQGridJSONModel(pagination, recordNum, santramexps);
	}

	/**
	 * Method 'obtenerSolicitudesCopiaExpediente'.
	 * 
	 * @param sacodigo
	 *            String
	 * @return List<Arbtramexp>
	 */
	@RequestMapping(value = "/obtenerSolicitudesCopiaExpediente", method = RequestMethod.GET)
	public @ResponseBody()
	List<Arbtramexp> obtenerSolicitudesCopiaExpediente(
			@RequestParam(value = "sacodigo", required = true) String sacodigo) {

		Arbtramexp filterArbtramexp = new Arbtramexp();
		Solarb solarb = new Solarb();
		solarb.setSacodigo(sacodigo);
		filterArbtramexp.setSolarb(solarb);
		filterArbtramexp
				.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SOLICITUD_COPIA_EXPE);

		List<Arbtramexp> arbtramexps = this.arbtramexpService.findAll(
				filterArbtramexp, null);

		for (Arbtramexp arbtrmexp : arbtramexps) {
			arbtrmexp.setSolarb(this.solarbService.find(arbtrmexp.getSolarb()));
		}

		ArbtramexpController.logger
				.info("[GET - List<Arbtramexp>] : obtenerSolicitudesCopiaExpediente");
		return arbtramexps;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param tipo
	 *            String
	 * @param sacodigo
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/dameSolicitudesAclaracion/{tipo}", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGridSA(@PathVariable String tipo,
			@RequestParam(value = "sacodigo", required = true) String sacodigo,
			@ModelAttribute() Pagination pagination) {
		Arbtramexp arbtramexp = new Arbtramexp();
		Solarb solarb = new Solarb();
		solarb.setSacodigo(sacodigo);
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		if (tipo.equals(Y41bConstantes.SOLICITUD_ACLARACION)) {
			arbtramexp
					.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SOLICITUD_ACLARACION);
		} else {
			arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_ACLARACION);
		}
		List<Arbtramexp> arbtramexps = this.arbtramexp2Service
				.findTramitesAclaracion(arbtramexp, pagination);
		Long recordNum = this.arbtramexpService.findAllCount(arbtramexp);
		ArbtramexpController.logger
				.info("[GET - jqGrid] : dameSolicitudesAclaracion");
		return new JQGridJSONModel(pagination, recordNum, arbtramexps);
	}

	/**
	 * Method 'getCreateFormDetalle'.
	 * 
	 * @param trid
	 *            BigDecimal
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "/detalleLugarCitacionPrueba/{trid}", method = RequestMethod.GET)
	public ModelAndView getCreateFormDetalle(@PathVariable() BigDecimal trid,
			Model model) {
		ArbtramexpController.logger
				.info("[GET - View] : detalleLugarCitacionPrueba");
		model.addAttribute("trid", trid);
		model.addAttribute("modo", Y41bConstantes.MODO_POPUP_MODIFICACION);
		return new ModelAndView("detalleLugarCitacionPrueba", "model", model);
	}

	/**
	 * Method 'reabrirExpediente'.
	 * 
	 * @param excodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/reabrirExpediente/{excodigo}", method = RequestMethod.POST)
	public @ResponseBody()
	void reabrirExpediente(@PathVariable() String excodigo,
			HttpServletRequest request) {
		try {
			CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			this.arbtramexp4Service.reabrirExpediente(excodigo, censoMonitor);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}
}
