package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.ArbtipdocService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.Arbtipdoc;

/**
 * ArbtipdocController  
 *  
 */
 
@Controller
@RequestMapping (value = "/arbtipdoc")

public class ArbtipdocController  {

	private static final Logger logger = LoggerFactory.getLogger(ArbtipdocController.class);

	@Autowired
	private ArbtipdocService arbtipdocService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ArbtipdocController.logger.info("[GET - View] : arbtipdoc");
		return "arbtipdoc";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param tdid String
	 * @return arbtipdoc Arbtipdoc
	 */
	@RequestMapping(value = "/{tdid}", method = RequestMethod.GET)
	public @ResponseBody Arbtipdoc getById(@PathVariable String tdid) {
        Arbtipdoc arbtipdoc = new Arbtipdoc();
		arbtipdoc.setTdid(tdid);
        arbtipdoc = this.arbtipdocService.find(arbtipdoc);
        ArbtipdocController.logger.info("[GET - findBy_PK] : Obtener Arbtipdoc por PK");
        return arbtipdoc;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterArbtipdoc Arbtipdoc
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Arbtipdoc> getAll(@ModelAttribute Arbtipdoc filterArbtipdoc) {
		ArbtipdocController.logger.info("[GET - find_ALL] : Obtener Arbtipdoc por filtro");
	    return this.arbtipdocService.findAll(filterArbtipdoc, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param arbtipdoc Arbtipdoc 
	 * @return Arbtipdoc
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody Arbtipdoc edit(@RequestBody Arbtipdoc arbtipdoc) {		
        Arbtipdoc arbtipdocAux = this.arbtipdocService.update(arbtipdoc);
		ArbtipdocController.logger.info("[PUT] : Arbtipdoc actualizado correctamente");
        return arbtipdocAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param arbtipdoc Arbtipdoc 
	 * @return Arbtipdoc
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Arbtipdoc add(@RequestBody Arbtipdoc arbtipdoc) {		
        Arbtipdoc arbtipdocAux = this.arbtipdocService.add(arbtipdoc);
        ArbtipdocController.logger.info("[POST] : Arbtipdoc insertado correctamente");
    	return arbtipdocAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param tdid String
	 * @return arbtipdoc
	 */
	@RequestMapping(value = "/{tdid}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody Arbtipdoc remove(@PathVariable String tdid) {
        Arbtipdoc arbtipdoc = new Arbtipdoc();
        arbtipdoc.setTdid(tdid);
        this.arbtipdocService.remove(arbtipdoc);
       	ArbtipdocController.logger.info("[DELETE] : Arbtipdoc borrado correctamente");
       	return arbtipdoc;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param arbtipdocIds List
	 * @return arbtipdocList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> arbtipdocIds) {
        List<Arbtipdoc> arbtipdocList = new ArrayList<Arbtipdoc>();
        for (List<String> arbtipdocId:arbtipdocIds) {
		    Iterator<String> iterator = arbtipdocId.iterator();
		    Arbtipdoc arbtipdoc = new Arbtipdoc(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        arbtipdoc.setTdid(ObjectConversionManager.convert(iterator.next(), String.class));
		    arbtipdocList.add(arbtipdoc);
	    }
        this.arbtipdocService.removeMultiple(arbtipdocList);
		ArbtipdocController.logger.info("[POST - DELETE_ALL] : Arbtipdoc borrados correctamente");
		return arbtipdocIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterArbtipdoc Arbtipdoc
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute Arbtipdoc filterArbtipdoc, @ModelAttribute Pagination pagination) {
        List<Arbtipdoc> arbtipdocs = this.arbtipdocService.findAll(filterArbtipdoc, pagination);
        Long recordNum = this.arbtipdocService.findAllCount(filterArbtipdoc);
        ArbtipdocController.logger.info("[GET - jqGrid] : Obtener Arbtipdoc");
		return new JQGridJSONModel(pagination, recordNum, arbtipdocs);
	}
	
}	
