package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.ArbtipdecaudService;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Arbtipdecaud;

/**
 * ArbtipdecaudController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/arbtipdecaud")
public class ArbtipdecaudController {

	private static final Logger logger = LoggerFactory
			.getLogger(ArbtipdecaudController.class);

	@Autowired
	private ArbtipdecaudService arbtipdecaudService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ArbtipdecaudController.logger.info("[GET - View] : arbtipdecaud");
		return "arbtipdecaud";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param daid
	 *            Integer
	 * @return arbtipdecaud Arbtipdecaud
	 */
	@RequestMapping(value = "/{daid}", method = RequestMethod.GET)
	public @ResponseBody
	Arbtipdecaud getById(@PathVariable Integer daid) {
		Arbtipdecaud arbtipdecaud = new Arbtipdecaud();
		arbtipdecaud.setDaid(daid);
		arbtipdecaud = this.arbtipdecaudService.find(arbtipdecaud);
		ArbtipdecaudController.logger
				.info("[GET - findBy_PK] : Obtener Arbtipdecaud por PK");
		return arbtipdecaud;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterArbtipdecaud
	 *            Arbtipdecaud
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Arbtipdecaud> getAll(@ModelAttribute Arbtipdecaud filterArbtipdecaud) {
		ArbtipdecaudController.logger
				.info("[GET - find_ALL] : Obtener Arbtipdecaud por filtro");
		return this.arbtipdecaudService.findAll(filterArbtipdecaud, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param arbtipdecaud
	 *            Arbtipdecaud
	 * @return Arbtipdecaud
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Arbtipdecaud edit(@RequestBody Arbtipdecaud arbtipdecaud) {
		Arbtipdecaud arbtipdecaudAux = this.arbtipdecaudService
				.update(arbtipdecaud);
		ArbtipdecaudController.logger
				.info("[PUT] : Arbtipdecaud actualizado correctamente");
		return arbtipdecaudAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param arbtipdecaud
	 *            Arbtipdecaud
	 * @return Arbtipdecaud
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Arbtipdecaud add(@RequestBody Arbtipdecaud arbtipdecaud) {
		Arbtipdecaud arbtipdecaudAux = this.arbtipdecaudService
				.add(arbtipdecaud);
		ArbtipdecaudController.logger
				.info("[POST] : Arbtipdecaud insertado correctamente");
		return arbtipdecaudAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param daid
	 *            Integer
	 * @return arbtipdecaud
	 */
	@RequestMapping(value = "/{daid}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Arbtipdecaud remove(@PathVariable Integer daid) {
		Arbtipdecaud arbtipdecaud = new Arbtipdecaud();
		arbtipdecaud.setDaid(daid);
		this.arbtipdecaudService.remove(arbtipdecaud);
		ArbtipdecaudController.logger
				.info("[DELETE] : Arbtipdecaud borrado correctamente");
		return arbtipdecaud;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param arbtipdecaudIds
	 *            List
	 * @return arbtipdecaudList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> arbtipdecaudIds) {
		List<Arbtipdecaud> arbtipdecaudList = new ArrayList<Arbtipdecaud>();
		for (List<String> arbtipdecaudId : arbtipdecaudIds) {
			Iterator<String> iterator = arbtipdecaudId.iterator();
			Arbtipdecaud arbtipdecaud = new Arbtipdecaud(); // NOPMD - Objeto
															// nuevo en la lista
															// (parametro del
															// servicio)
			arbtipdecaud.setDaid(ObjectConversionManager.convert(
					iterator.next(), Integer.class));
			arbtipdecaudList.add(arbtipdecaud);
		}
		this.arbtipdecaudService.removeMultiple(arbtipdecaudList);
		ArbtipdecaudController.logger
				.info("[POST - DELETE_ALL] : Arbtipdecaud borrados correctamente");
		return arbtipdecaudIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterArbtipdecaud
	 *            Arbtipdecaud
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute Arbtipdecaud filterArbtipdecaud,
			@ModelAttribute Pagination pagination) {
		List<Arbtipdecaud> arbtipdecauds = this.arbtipdecaudService.findAll(
				filterArbtipdecaud, pagination);
		Long recordNum = this.arbtipdecaudService
				.findAllCount(filterArbtipdecaud);
		ArbtipdecaudController.logger
				.info("[GET - jqGrid] : Obtener Arbtipdecaud");
		return new JQGridJSONModel(pagination, recordNum, arbtipdecauds);
	}

	/**
	 * Method 'comboArbtipdecaud'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return List
	 */
	@RequestMapping(value = "/combo", method = RequestMethod.GET)
	public @ResponseBody()
	List<Arbtipdecaud> comboArbtipdecaud(HttpServletRequest request) {

		Arbtipdecaud arbtipdecaud = new Arbtipdecaud();
		Locale locale = LocaleContextHolder.getLocale();
		String idioma = locale.getLanguage();

		Pagination pagination = new Pagination();
		if (Y41bConstantes.CASTELLANO.equals(idioma)) {
			pagination.setSort("dadesces");
		} else {
			pagination.setSort("dadesceu");
		}
		pagination.setAscDsc("DESC");
		return this.arbtipdecaudService.findAll(arbtipdecaud, pagination);
	}
}
