package com.ejie.y41b.control;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Arbpropbandeja;
import com.ejie.y41b.service.ArbpropbandejaService;
import com.ejie.y41b.service.Y41bExcelGeneratorService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * ArbpropbandejaController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/arbpropbandeja")
public class ArbpropbandejaController {

	private static final Logger logger = LoggerFactory
			.getLogger(ArbpropbandejaController.class);

	@Autowired()
	private ArbpropbandejaService arbpropbandejaService;

	@Autowired
	private Properties appConfiguration;

	@Autowired()
	private Y41bExcelGeneratorService y41bExcelGeneratorService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ArbpropbandejaController.logger.info("[GET - View] : arbpropbandeja");
		return "arbpropbandeja";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param Baprarbid
	 *            Long
	 * @return arbpropbandeja Arbpropbandeja
	 */
	@RequestMapping(value = "/{Baprarbid}", method = RequestMethod.GET)
	public @ResponseBody()
	Arbpropbandeja getById(@PathVariable() Long Baprarbid) {
		Arbpropbandeja arbpropbandeja = new Arbpropbandeja();
		arbpropbandeja.setBaprarbid(Baprarbid);
		arbpropbandeja = this.arbpropbandejaService.find(arbpropbandeja);
		ArbpropbandejaController.logger
				.info("[GET - findBy_PK] : Obtener Arbpropbandeja por PK");
		return arbpropbandeja;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterArbpropbandeja
	 *            Arbpropbandeja
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Arbpropbandeja> getAll(
			@ModelAttribute() Arbpropbandeja filterArbpropbandeja) {
		ArbpropbandejaController.logger
				.info("[GET - find_ALL] : Obtener Arbpropbandeja por filtro");
		return this.arbpropbandejaService.findAll(filterArbpropbandeja, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param arbpropbandeja
	 *            Arbpropbandeja
	 * @return Arbpropbandeja
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Arbpropbandeja edit(@RequestBody() Arbpropbandeja arbpropbandeja) {
		Arbpropbandeja arbpropbandejaAux = this.arbpropbandejaService
				.update(arbpropbandeja);
		ArbpropbandejaController.logger
				.info("[PUT] : Arbpropbandeja actualizado correctamente");
		return arbpropbandejaAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param arbpropbandeja
	 *            Arbpropbandeja
	 * @return Arbpropbandeja
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Arbpropbandeja add(@RequestBody() Arbpropbandeja arbpropbandeja) {
		Arbpropbandeja arbpropbandejaAux = this.arbpropbandejaService
				.add(arbpropbandeja);
		ArbpropbandejaController.logger
				.info("[POST] : Arbpropbandeja insertado correctamente");
		return arbpropbandejaAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param Baprarbid
	 *            Long
	 * @return arbpropbandeja
	 */
	@RequestMapping(value = "/{Baprarbid}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Arbpropbandeja remove(@PathVariable() Long Baprarbid) {
		Arbpropbandeja arbpropbandeja = new Arbpropbandeja();
		arbpropbandeja.setBaprarbid(Baprarbid);
		this.arbpropbandejaService.remove(arbpropbandeja);
		ArbpropbandejaController.logger
				.info("[DELETE] : Arbpropbandeja borrado correctamente");
		return arbpropbandeja;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param arbpropbandejaIds
	 *            List
	 * @return arbpropbandejaList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(
			@RequestBody() List<List<String>> arbpropbandejaIds) {
		List<Arbpropbandeja> arbpropbandejaList = new ArrayList<Arbpropbandeja>();
		for (List<String> arbpropbandejaId : arbpropbandejaIds) {
			Iterator<String> iterator = arbpropbandejaId.iterator();
			Arbpropbandeja arbpropbandeja = new Arbpropbandeja(); // NOPMD -
																	// Objeto
																	// nuevo en
																	// la lista
																	// (parametro
																	// del
																	// servicio)
			arbpropbandeja.setBaprarbid(ObjectConversionManager.convert(
					iterator.next(), Long.class));
			arbpropbandejaList.add(arbpropbandeja);
		}
		this.arbpropbandejaService.removeMultiple(arbpropbandejaList);
		ArbpropbandejaController.logger
				.info("[POST - DELETE_ALL] : Arbpropbandeja borrados correctamente");
		return arbpropbandejaIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterArbpropbandeja
	 *            Arbpropbandeja
	 * @param pagination
	 *            Pagination
	 * @param request
	 *            HttpServletRequest
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute() Arbpropbandeja filterArbpropbandeja,
			@ModelAttribute() Pagination pagination, HttpServletRequest request) {
		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		filterArbpropbandeja.setCensoMonitor(censoMonitor);
		String perfil = censoMonitor.getPerfilArbitraje().getIdPerfil();
		List<Arbpropbandeja> arbpropbandejas = new ArrayList<Arbpropbandeja>();

		request.getSession().setAttribute("paginationArbpropbandeja",
				pagination);

		Long recordNum = 0L;
		if (Y41bConstantes.PERFIL_DIRECTOR.equals(perfil)
				|| Y41bConstantes.PERFIL_SUPERVISOR.equals(perfil)
				|| Y41bConstantes.PERFIL_COORDINADOR.equals(perfil)
				|| Y41bConstantes.PERFIL_INSTRUCTOR.equals(perfil)
				|| Y41bConstantes.PERFIL_ADMINISTRATIVO.equals(perfil)) {
			arbpropbandejas = this.arbpropbandejaService.findAll(
					filterArbpropbandeja, pagination);
			recordNum = this.arbpropbandejaService
					.findAllCount(filterArbpropbandeja);
		}
		ArbpropbandejaController.logger
				.info("[GET - jqGrid] : Obtener Arbpropbandeja");
		return new JQGridJSONModel(pagination, recordNum, arbpropbandejas);
	}

	/**
	 * getAllCount
	 * 
	 * @param filterArbpropbandeja
	 *            Arbpropbandeja
	 * @param pagination
	 *            Pagination
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/numeroEntradasBandeja", method = RequestMethod.GET)
	public @ResponseBody()
	Long getAllCount(@ModelAttribute() Arbpropbandeja filterArbpropbandeja,
			@ModelAttribute() Pagination pagination, HttpServletRequest request) {
		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		filterArbpropbandeja.setCensoMonitor(censoMonitor);
		String perfil = censoMonitor.getPerfilArbitraje().getIdPerfil();
		Long recordNum = 0L;
		if (Y41bConstantes.PERFIL_DIRECTOR.equals(perfil)
				|| Y41bConstantes.PERFIL_SUPERVISOR.equals(perfil)
				|| Y41bConstantes.PERFIL_COORDINADOR.equals(perfil)
				|| Y41bConstantes.PERFIL_INSTRUCTOR.equals(perfil)
				|| Y41bConstantes.PERFIL_ADMINISTRATIVO.equals(perfil)) {
			recordNum = this.arbpropbandejaService
					.findAllCount(filterArbpropbandeja);
		}
		ArbpropbandejaController.logger
				.info("[GET - jqGrid] : Obtener Arbpropbandeja");
		return recordNum;
	}

	/*---- excel Bandeja-----*/

	/**
	 * Method 'getAllExcelBandejaSanProp'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excelBandeja", method = RequestMethod.GET)
	public @ResponseBody()
	void getAllExcelBandejaSanProp(HttpServletRequest request,
			HttpServletResponse response) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			Arbpropbandeja filterArbpropbandeja = new Arbpropbandeja();
			filterArbpropbandeja.setCensoMonitor(censoMonitor);

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy,
					"yyyyMMddHHmmss");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_BANDEJA_ARBPROP + fechaActual
					+ ".xls";
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ StringEscapeUtils.unescapeHtml(nombre) + "\"");

			String xslString = this.y41bExcelGeneratorService
					.getArbPropExcelBandeja(filterArbpropbandeja);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterArbpropbandeja
	 *            Arbpropbandeja
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/arbpropbandejaSession", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGridSession(
			@ModelAttribute() Arbpropbandeja filterArbpropbandeja,
			@ModelAttribute() Pagination pagination, HttpServletRequest request) {

		try {
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			filterArbpropbandeja.setCensoMonitor(censoMonitor);

			String perfil = censoMonitor.getPerfilArbitraje().getIdPerfil();

			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = (Pagination) request.getSession().getAttribute(
						"paginationArbpropbandeja");

				// Si al refrescar la tabla existen menos elementos y la pgina
				// guardada en sesin no existe, se debe seleccionar la ltima
				// pgina con datos
				Long totalReg = new Long(0);
				totalReg = this.arbpropbandejaService
						.findAllCount(filterArbpropbandeja);

				Long pagSession = new Long(0);
				Long page = new Long(0);
				pagSession = pagination.getPage() * pagination.getRows();
				pagSession = pagSession - pagination.getRows();

				if (pagSession >= totalReg) {
					page = totalReg / pagination.getRows();
					pagination.setPage(page);
				}
			}

			List<Arbpropbandeja> arbpropbandejas = new ArrayList<Arbpropbandeja>();

			Long recordNum = 0L;
			if (Y41bConstantes.PERFIL_DIRECTOR.equals(perfil)
					|| Y41bConstantes.PERFIL_SUPERVISOR.equals(perfil)
					|| Y41bConstantes.PERFIL_COORDINADOR.equals(perfil)
					|| Y41bConstantes.PERFIL_INSTRUCTOR.equals(perfil)
					|| Y41bConstantes.PERFIL_ADMINISTRATIVO.equals(perfil)) {
				arbpropbandejas = this.arbpropbandejaService.findAll(
						filterArbpropbandeja, pagination);
				recordNum = this.arbpropbandejaService
						.findAllCount(filterArbpropbandeja);
			}
			ArbpropbandejaController.logger
					.info("[GET - jqGrid] : Obtener Arbpropbandeja");

			return new JQGridJSONModel(pagination, recordNum, arbpropbandejas);

		} catch (Exception e) {
			e.printStackTrace();
			logger.error("Error producido en getAllJQGrid: " + e.getMessage(),
					e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getObservaciones'.
	 * 
	 * @param Baprarbid
	 *            Long
	 * @return arbpropbandeja
	 */
	@RequestMapping(value = "/obtenerObservaciones/{baprarbid}", method = RequestMethod.GET)
	public ModelAndView getObservaciones(@PathVariable() Long baprarbid,
			Model model, HttpServletRequest request) {

		Arbpropbandeja arbpropbandeja = new Arbpropbandeja();
		arbpropbandeja.setBaprarbid(baprarbid);

		arbpropbandeja = this.arbpropbandejaService.getObserv(arbpropbandeja);

		ArbpropbandejaController.logger.info("[GET] : Obtener observaciones");

		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("arbpropbandeja", arbpropbandeja);

		return new ModelAndView("propArbObserv", "model", model);
	}

	/**
	 * Method 'getObservaciones'.
	 * 
	 * @param Baprarbid
	 *            Long
	 * @throws IOException
	 * @throws SQLException
	 */
	@RequestMapping(value = "/guardarObservaciones/{baprarbid}", method = RequestMethod.GET)
	public void setObservaciones(
			@RequestParam(value = "observ", required = false) String observ,
			@PathVariable() Long baprarbid, HttpServletRequest request)
			throws SQLException, IOException {

		Arbpropbandeja arbpropbandeja = new Arbpropbandeja();
		arbpropbandeja.setBaprarbid(baprarbid);

		arbpropbandeja.setBaprarbobserv(Y41bUtils.stringToClob(observ));

		this.arbpropbandejaService.setObserv(arbpropbandeja);

		ArbpropbandejaController.logger
				.info("[UPDATE] : Guardar observaciones");

	}

}