package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.ArbmotrasService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.Arbmotras;

/**
 * ArbmotrasController  
 *  
 */
 
@Controller
@RequestMapping (value = "/arbmotras")

public class ArbmotrasController  {

	private static final Logger logger = LoggerFactory.getLogger(ArbmotrasController.class);

	@Autowired
	private ArbmotrasService arbmotrasService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ArbmotrasController.logger.info("[GET - View] : arbmotras");
		return "arbmotras";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param mtid String
	 * @return arbmotras Arbmotras
	 */
	@RequestMapping(value = "/{mtid}", method = RequestMethod.GET)
	public @ResponseBody Arbmotras getById(@PathVariable String mtid) {
        Arbmotras arbmotras = new Arbmotras();
		arbmotras.setMtid(mtid);
        arbmotras = this.arbmotrasService.find(arbmotras);
        ArbmotrasController.logger.info("[GET - findBy_PK] : Obtener Arbmotras por PK");
        return arbmotras;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterArbmotras Arbmotras
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Arbmotras> getAll(@ModelAttribute Arbmotras filterArbmotras) {
		ArbmotrasController.logger.info("[GET - find_ALL] : Obtener Arbmotras por filtro");
	    return this.arbmotrasService.findAll(filterArbmotras, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param arbmotras Arbmotras 
	 * @return Arbmotras
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody Arbmotras edit(@RequestBody Arbmotras arbmotras) {		
        Arbmotras arbmotrasAux = this.arbmotrasService.update(arbmotras);
		ArbmotrasController.logger.info("[PUT] : Arbmotras actualizado correctamente");
        return arbmotrasAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param arbmotras Arbmotras 
	 * @return Arbmotras
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Arbmotras add(@RequestBody Arbmotras arbmotras) {		
        Arbmotras arbmotrasAux = this.arbmotrasService.add(arbmotras);
        ArbmotrasController.logger.info("[POST] : Arbmotras insertado correctamente");
    	return arbmotrasAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param mtid String
	 * @return arbmotras
	 */
	@RequestMapping(value = "/{mtid}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody Arbmotras remove(@PathVariable String mtid) {
        Arbmotras arbmotras = new Arbmotras();
        arbmotras.setMtid(mtid);
        this.arbmotrasService.remove(arbmotras);
       	ArbmotrasController.logger.info("[DELETE] : Arbmotras borrado correctamente");
       	return arbmotras;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param arbmotrasIds List
	 * @return arbmotrasList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> arbmotrasIds) {
        List<Arbmotras> arbmotrasList = new ArrayList<Arbmotras>();
        for (List<String> arbmotrasId:arbmotrasIds) {
		    Iterator<String> iterator = arbmotrasId.iterator();
		    Arbmotras arbmotras = new Arbmotras(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        arbmotras.setMtid(ObjectConversionManager.convert(iterator.next(), String.class));
		    arbmotrasList.add(arbmotras);
	    }
        this.arbmotrasService.removeMultiple(arbmotrasList);
		ArbmotrasController.logger.info("[POST - DELETE_ALL] : Arbmotras borrados correctamente");
		return arbmotrasIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterArbmotras Arbmotras
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute Arbmotras filterArbmotras, @ModelAttribute Pagination pagination) {
        List<Arbmotras> arbmotrass = this.arbmotrasService.findAll(filterArbmotras, pagination);
        Long recordNum = this.arbmotrasService.findAllCount(filterArbmotras);
        ArbmotrasController.logger.info("[GET - jqGrid] : Obtener Arbmotras");
		return new JQGridJSONModel(pagination, recordNum, arbmotrass);
	}
	
}	
