package com.ejie.y41b.control;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.model.Arbmonol;
import com.ejie.y41b.service.ArbmonolService;

/**
 * ArbmonolController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/arbmonol")
public class ArbmonolController {

	private static final Logger logger = LoggerFactory
			.getLogger(ArbmonolController.class);

	@Autowired
	private ArbmonolService arbmonolService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ArbmonolController.logger.info("[GET - View] : arbmonol");
		return "arbmonol";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param mnid
	 *            String
	 * @return arbmonol Arbmonol
	 */
	@RequestMapping(value = "/{mnid}", method = RequestMethod.GET)
	public @ResponseBody
	Arbmonol getById(@PathVariable String mnid) {
		Arbmonol arbmonol = new Arbmonol();
		arbmonol.setMnid(mnid);
		arbmonol = this.arbmonolService.find(arbmonol);
		ArbmonolController.logger
				.info("[GET - findBy_PK] : Obtener Arbmonol por PK");
		return arbmonol;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterArbmonol
	 *            Arbmonol
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Arbmonol> getAll(@ModelAttribute Arbmonol filterArbmonol) {
		ArbmonolController.logger
				.info("[GET - find_ALL] : Obtener Arbmonol por filtro");
		return this.arbmonolService.findAll(filterArbmonol, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param arbmonol
	 *            Arbmonol
	 * @return Arbmonol
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Arbmonol edit(@RequestBody Arbmonol arbmonol) {
		Arbmonol arbmonolAux = this.arbmonolService.update(arbmonol);
		ArbmonolController.logger
				.info("[PUT] : Arbmonol actualizado correctamente");
		return arbmonolAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param arbmonol
	 *            Arbmonol
	 * @return Arbmonol
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Arbmonol add(@RequestBody Arbmonol arbmonol) {
		Arbmonol arbmonolAux = this.arbmonolService.add(arbmonol);
		ArbmonolController.logger
				.info("[POST] : Arbmonol insertado correctamente");
		return arbmonolAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param mnid
	 *            String
	 * @return arbmonol
	 */
	@RequestMapping(value = "/{mnid}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Arbmonol remove(@PathVariable String mnid) {
		Arbmonol arbmonol = new Arbmonol();
		arbmonol.setMnid(mnid);
		this.arbmonolService.remove(arbmonol);
		ArbmonolController.logger
				.info("[DELETE] : Arbmonol borrado correctamente");
		return arbmonol;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param arbmonolIds
	 *            List
	 * @return arbmonolList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> arbmonolIds) {
		List<Arbmonol> arbmonolList = new ArrayList<Arbmonol>();
		for (List<String> arbmonolId : arbmonolIds) {
			Iterator<String> iterator = arbmonolId.iterator();
			Arbmonol arbmonol = new Arbmonol(); // NOPMD - Objeto nuevo en la
												// lista (parametro del
												// servicio)
			arbmonol.setMnid(ObjectConversionManager.convert(iterator.next(),
					String.class));
			arbmonolList.add(arbmonol);
		}
		this.arbmonolService.removeMultiple(arbmonolList);
		ArbmonolController.logger
				.info("[POST - DELETE_ALL] : Arbmonol borrados correctamente");
		return arbmonolIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterArbmonol
	 *            Arbmonol
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Arbmonol filterArbmonol,
			@ModelAttribute Pagination pagination) {
		List<Arbmonol> arbmonols = this.arbmonolService.findAll(filterArbmonol,
				pagination);
		Long recordNum = this.arbmonolService.findAllCount(filterArbmonol);
		ArbmonolController.logger.info("[GET - jqGrid] : Obtener Arbmonol");
		return new JQGridJSONModel(pagination, recordNum, arbmonols);
	}

}
