package com.ejie.y41b.control;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
//import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.Arbitro;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.service.ArbintervService;
import com.ejie.y41b.service.ArbitroService;
import com.ejie.y41b.service.EstablecimientoService;
import com.ejie.y41b.service.OrganismoService;
import com.ejie.y41b.service.SolarbService;
import com.ejie.y41b.service.Y41bExcelGeneratorService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.dokusi.Y41bUtilsDokusi;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * ArbitroController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/arbitro")
public class ArbitroController {

	private static final Logger logger = LoggerFactory
			.getLogger(ArbitroController.class);

	@Autowired()
	private ArbitroService arbitroService;

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private Y41bExcelGeneratorService y41bExcelGeneratorService;
	@Autowired()
	private SolarbService solarbService;
	@Autowired()
	private ArbintervService arbintervService;
	@Autowired()
	private EstablecimientoService establecimientoService;
	@Autowired()
	private OrganismoService organismoService;
	@Autowired()
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {
		ArbitroController.logger.info("[GET - View] : arbitro");
		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| (censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO) && censoMonitor
						.getPerfilArbitraje().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO))) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("arbitro", "model", model);
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param arcodigo
	 *            String
	 * @return arbitro Arbitro
	 */
	@RequestMapping(value = "/getById/{arcodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	Arbitro getById(@PathVariable() String arcodigo) {
		Arbitro arbitro = new Arbitro();
		arbitro.setArcodigo(arcodigo);
		arbitro = this.arbitroService.find(arbitro);
		ArbitroController.logger
				.info("[GET - findBy_PK] : Obtener Arbitro por PK");
		return arbitro;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterArbitro
	 *            Arbitro
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Arbitro> getAll(@ModelAttribute() Arbitro filterArbitro) {
		ArbitroController.logger
				.info("[GET - find_ALL] : Obtener Arbitro por filtro");
		return this.arbitroService.findAll(filterArbitro, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param arbitro
	 *            Arbitro
	 * @return Arbitro
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Arbitro edit(@RequestBody() Arbitro arbitro) {
		Arbitro arbitroAux = this.arbitroService.update(arbitro);
		ArbitroController.logger
				.info("[PUT] : Arbitro actualizado correctamente");
		return arbitroAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param arbitro
	 *            Arbitro
	 * @return Arbitro
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Arbitro add(@RequestBody() Arbitro arbitro) {
		Arbitro arbitroAux = this.arbitroService.add(arbitro);
		ArbitroController.logger
				.info("[POST] : Arbitro insertado correctamente");
		return arbitroAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param arcodigo
	 *            String
	 * @return arbitro
	 */
	@RequestMapping(value = "/{arcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Arbitro remove(@PathVariable() String arcodigo) {
		Arbitro arbitro = new Arbitro();
		arbitro.setArcodigo(arcodigo);
		this.arbitroService.remove(arbitro);
		ArbitroController.logger
				.info("[DELETE] : Arbitro borrado correctamente");
		return arbitro;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param arbitroIds
	 *            List
	 * @return arbitroList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(
			@RequestBody() List<List<String>> arbitroIds) {
		List<Arbitro> arbitroList = new ArrayList<Arbitro>();
		for (List<String> arbitroId : arbitroIds) {
			Iterator<String> iterator = arbitroId.iterator();
			Arbitro arbitro = new Arbitro(); // NOPMD - Objeto nuevo en la lista
												// (parametro del servicio)
			arbitro.setArcodigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			arbitroList.add(arbitro);
		}
		this.arbitroService.removeMultiple(arbitroList);
		ArbitroController.logger
				.info("[POST - DELETE_ALL] : Arbitro borrados correctamente");
		return arbitroIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterArbitro
	 *            Arbitro
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(@ModelAttribute() Arbitro filterArbitro,
			@ModelAttribute() Pagination pagination) {
		List<Arbitro> arbitros = this.arbitroService.findAll(filterArbitro,
				pagination);
		Long recordNum = this.arbitroService.findAllCount(filterArbitro);
		ArbitroController.logger.info("[GET - jqGrid] : Obtener Arbitro");
		return new JQGridJSONModel(pagination, recordNum, arbitros);
	}

	/**
	 * * Method 'getCreateFormBusqueda'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 * @throws Exception
	 */
	@RequestMapping(value = "maintArbitros", method = RequestMethod.GET)
	public ModelAndView getCreateFormModalBusqueda(Model model,
			HttpServletRequest request) throws Exception {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modoBusquedaArbitro",
				Y41bConstantes.MODO_POPUP_SELECCION);

		model.addAttribute("modoActualizarArbitro", true);

		ArbitroController.logger.info("[GET - View] : arbitro");
		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| (censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO) && censoMonitor
						.getPerfilArbitraje().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO))) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			StringBuffer cadenaJSON = new StringBuffer("'{");
			cadenaJSON.append("\\\"baja\\\":\\\"N\\\"}'");
			model.addAttribute("filtroArbitro", cadenaJSON);
			return new ModelAndView("arbitroSeleccion", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 * @throws Exception
	 */
	@RequestMapping(value = "seleccionArbitros", method = RequestMethod.GET)
	public ModelAndView getCreateFormModal(Model model,
			HttpServletRequest request) throws Exception {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modoBusquedaArbitro",
				Y41bConstantes.MODO_POPUP_SELECCION);

		String sacodigo = request.getParameter("sacodigo");
		StringBuffer cadenaJSON = new StringBuffer("'{");
		if (!Y41bUtils.esNullOCadenaVacia(sacodigo)) {
			Solarb solarb = new Solarb();
			solarb.setSacodigo(new String(Y41bUtilsDokusi.decode(sacodigo)));
			solarb = this.solarbService.find(solarb);
			// EVOLUTIVO 134898 2.5
			// cadenaJSON.append("\\\"idioma\\\":\\\"").append("C")
			// .append("\\\",");
			cadenaJSON.append("\\\"idioma\\\":\\\"").append("")
					.append("\\\", ");
			// EVOLUTIVO 134898 2.5
			cadenaJSON.append("\\\"licenciaturaDerecho\\\":\\\"")
					.append(solarb.getSaintiso()).append("\\\",");
			Arbinterv arbinterv = new Arbinterv();
			arbinterv.setSolarb(solarb);
			List<Arbinterv> larbinterv = this.arbintervService.findAll(
					arbinterv, null);
			if (larbinterv != null) {
				for (int i = 0; i < larbinterv.size(); i++) {
					arbinterv = larbinterv.get(i);
					// EVOLUTIVO 134898 2.5
					// if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE
					// .equals(arbinterv.getUatipointerv())) {
					// cadenaJSON.append("\\\"th\\\":\\\"")
					// .append(arbinterv.getUaprovId())
					// .append("\\\",");
					// } else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO
					// .equals(arbinterv.getUatipointerv())) {
					// cadenaJSON.append("\\\"secodigo\\\":\\\"")
					// .append(arbinterv.getUasecodigo())
					// .append("\\\",");
					// Locale locale = LocaleContextHolder.getLocale();
					// String idioma = locale.getLanguage();
					// cadenaJSON
					// .append("\\\"senombre\\\":\\\"")
					// .append(Y41bConstantes.EUSKERA.equals(idioma) ? arbinterv
					// .getUasenombree() : arbinterv
					// .getUasenombre()).append("\\\",");
					if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO
							.equals(arbinterv.getUatipointerv())) {
						// EVOLUTIVO 134898 2.5
						Establecimiento estableci = (Establecimiento) this.establecimientoService
								.find(new Establecimiento(arbinterv
										.getUaescodigo()));
						Organismo organismo = new Organismo();
						if (!Y41bUtils
								.esNullOCadenaVacia(estableci.getEscooe())) {
							organismo.setCodOrg(estableci.getEscooe());
							organismo = this.organismoService.find(organismo);
						}
						cadenaJSON
								.append("\\\"oecodigo\\\":\\\"")
								.append(estableci.getEscooe() == null ? ""
										: estableci.getEscooe())
								.append("\\\",");
						cadenaJSON.append("\\\"oenombre\\\":\\\"");
						// EVOLUTIVO 134898 2.5
						// if (Y41bConstantes.EUSKERA.equals(idioma)) {
						// cadenaJSON
						// .append(organismo.getNombreEu() == null ? ""
						// : organismo.getNombreEu());
						// } else {
						//
						// cadenaJSON
						// .append(organismo.getNombreEs() == null ? ""
						// : organismo.getNombreEs());
						// }
						// EVOLUTIVO 134898 2.5
						cadenaJSON.append("\\\",");
					}
					// cadenaJSON.append("\\\"baja\\\":\\\"").append(
					// solarb.getArbitro().getBaja() == null ? "" : solarb
					// .getArbitro().getBaja());
				}
			}
			// cadenaJSON.append("\\\"}'");
			cadenaJSON.append("\\\"baja\\\":\\\"N\\\"}'");
		}

		model.addAttribute("filtroArbitro", cadenaJSON);
		return new ModelAndView("arbitroSeleccion", "model", model);
	}

	/**
	 * Method 'getCreateFormDetalle'.
	 * 
	 * @param arcodigo
	 *            String
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "/detalle/{arcodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormDetalle(@PathVariable() String arcodigo,
			Model model) {
		ArbitroController.logger.info("[GET - View] : arbitro");
		model.addAttribute("arcodigo", arcodigo);
		model.addAttribute("modo", Y41bConstantes.MODO_POPUP_MODIFICACION);
		return new ModelAndView("arbitroDetalle", "model", model);
	}

	/**
	 * Method 'getCreateFormDetalle'.
	 * 
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "/alta", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(Model model) {
		ArbitroController.logger.info("[GET - View] : arbitro");
		Long arcodigo = this.arbitroService.getNewPK();
		model.addAttribute("arcodigo", arcodigo);
		model.addAttribute("modo", Y41bConstantes.MODO_POPUP_ALTA);
		return new ModelAndView("arbitroDetalle", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param arcodigo
	 *            String
	 * @return arbitro Arbitro
	 */
	@RequestMapping(value = "/existe/{arcodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	long existe(@PathVariable() String arcodigo) {
		Arbitro arbitro = new Arbitro();
		arbitro.setArcodigo(arcodigo);
		return this.arbitroService.findAllCount(arbitro);
	}

	/**
	 * Method 'borrarTemporales'.
	 * 
	 * @param arcodigo
	 *            String
	 */
	@RequestMapping(value = "/borrarTemporales/{arcodigo}", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	void borrarTemporales(@PathVariable() String arcodigo) {
		Arbitro arbitro = new Arbitro();
		arbitro.setArcodigo(arcodigo);
		this.arbitroService.borrarTemporales(arbitro);
		ArbitroController.logger
				.info("[DELETE] : Arbitro Temporalres borrado correctamente");

	}

	/**
	 * Method 'getAllExcel'.
	 * 
	 * @param filterArbitro
	 *            Arbitro
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excel", method = RequestMethod.GET)
	public void getAllExcel(@ModelAttribute() Arbitro filterArbitro,
			HttpServletRequest request, HttpServletResponse response) {
		try {

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy,
					"yyyyMMddHHmmss");
			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_ARBITRO + fechaActual + ".xls";
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ StringEscapeUtils.unescapeHtml(nombre) + "\"");

			String xslString = this.y41bExcelGeneratorService
					.getArbitroExcel(filterArbitro);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param arcodigo
	 *            String
	 * @return arbitro Arbitro
	 * @throws Exception
	 */
	@RequestMapping(value = "/getByIdDatosDireccion/{arcodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	Arbitro getByIdDatosDireccion(@PathVariable() String arcodigo)
			throws Exception {
		Arbitro arbitro = new Arbitro();
		arbitro.setArcodigo(arcodigo);
		arbitro = this.arbitroService.find(arbitro);
		ArbitroController.logger
				.info("[GET - findBy_PK] : Obtener Arbitro por PK");
		arbitro = this.arbitroService.tratarDireccionesCentro(arbitro);
		return arbitro;
	}

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody()
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;
		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			// throw new ResourceNotFoundException("No data Found.");
		}
	}
}
