package com.ejie.y41b.control;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.ArbintervService;
import com.ejie.y41b.service.EstablecimientoService;
import com.ejie.y41b.utils.dokusi.Y41bUtilsDokusi;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.ConsumidorDetalle;
import com.ejie.y41b.model.EstablecimientoDetalle;
import com.ejie.y41b.model.Solarb;

/**
 * ArbintervController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/arbinterv")
public class ArbintervController {

	private static final Logger logger = LoggerFactory
			.getLogger(ArbintervController.class);

	@Autowired
	private ArbintervService arbintervService;
	@Autowired()
	private EstablecimientoService establecimientoService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ArbintervController.logger.info("[GET - View] : arbinterv");
		return "arbinterv";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param uaidinterv
	 *            Long
	 * @return arbinterv Arbinterv
	 */
	@RequestMapping(value = "/{uaidinterv}", method = RequestMethod.GET)
	public @ResponseBody
	Arbinterv getById(@PathVariable BigDecimal uaidinterv) {
		Arbinterv arbinterv = new Arbinterv();
		arbinterv.setUaidinterv(uaidinterv);
		arbinterv = this.arbintervService.find(arbinterv);
		ArbintervController.logger
				.info("[GET - findBy_PK] : Obtener Arbinterv por PK");
		return arbinterv;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterArbinterv
	 *            Arbinterv
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Arbinterv> getAll(@ModelAttribute Arbinterv filterArbinterv) {
		ArbintervController.logger
				.info("[GET - find_ALL] : Obtener Arbinterv por filtro");
		return this.arbintervService.findAll(filterArbinterv, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @return Arbinterv
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Arbinterv edit(@RequestBody Arbinterv arbinterv) {
		Arbinterv arbintervAux = this.arbintervService.update(arbinterv);
		ArbintervController.logger
				.info("[PUT] : Arbinterv actualizado correctamente");
		return arbintervAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @return Arbinterv
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Arbinterv add(@RequestBody Arbinterv arbinterv) {
		Arbinterv arbintervAux = this.arbintervService.add(arbinterv);
		ArbintervController.logger
				.info("[POST] : Arbinterv insertado correctamente");
		return arbintervAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param uaidinterv
	 *            Long
	 * @return arbinterv
	 */
	@RequestMapping(value = "/{uaidinterv}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Arbinterv remove(@PathVariable BigDecimal uaidinterv) {
		Arbinterv arbinterv = new Arbinterv();
		arbinterv.setUaidinterv(uaidinterv);
		this.arbintervService.remove(arbinterv);
		ArbintervController.logger
				.info("[DELETE] : Arbinterv borrado correctamente");
		return arbinterv;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param arbintervIds
	 *            List
	 * @return arbintervList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> arbintervIds) {
		List<Arbinterv> arbintervList = new ArrayList<Arbinterv>();
		for (List<String> arbintervId : arbintervIds) {
			Iterator<String> iterator = arbintervId.iterator();
			Arbinterv arbinterv = new Arbinterv(); // NOPMD - Objeto nuevo en la
													// lista (parametro del
													// servicio)
			arbinterv.setUaidinterv(ObjectConversionManager.convert(
					iterator.next(), BigDecimal.class));
			arbintervList.add(arbinterv);
		}
		this.arbintervService.removeMultiple(arbintervList);
		ArbintervController.logger
				.info("[POST - DELETE_ALL] : Arbinterv borrados correctamente");
		return arbintervIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterArbinterv
	 *            Arbinterv
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Arbinterv filterArbinterv,
			@ModelAttribute Pagination pagination) {
		List<Arbinterv> arbintervs = this.arbintervService.findAll(
				filterArbinterv, pagination);
		Long recordNum = this.arbintervService.findAllCount(filterArbinterv);
		ArbintervController.logger.info("[GET - jqGrid] : Obtener Arbinterv");
		return new JQGridJSONModel(pagination, recordNum, arbintervs);
	}

	/**
	 * Method 'countAllByExp'.
	 * 
	 * @param sacodigo
	 *            String
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/countIntervExp", method = RequestMethod.GET)
	public @ResponseBody()
	Long countAllByExp(
			@RequestParam(value = "sacodigo", required = true) String sacodigo) {

		ArbintervController.logger
				.info("[GET - jqGrid] : Obtener countIntervExp");
		Arbinterv filterArbinterv = new Arbinterv();
		Solarb solarb = new Solarb();
		solarb.setSacodigo(sacodigo);
		filterArbinterv.setSolarb(solarb);
		return this.arbintervService.findAllCount(filterArbinterv);
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param sacodigo
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/dameIntervExp", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(
			@RequestParam(value = "sacodigo", required = false) String sacodigo,
			@ModelAttribute() Pagination pagination) {

		Arbinterv filterArbinterv = new Arbinterv();
		Solarb solarb = new Solarb();
		solarb.setSacodigo(sacodigo);
		filterArbinterv.setSolarb(solarb);

		List<Arbinterv> arbintervs = this.arbintervService.findAll(
				filterArbinterv, pagination);
		Long recordNum = this.arbintervService.findAllCount(filterArbinterv);
		ArbintervController.logger.info("[GET - jqGrid] : Obtener Arbinterv");
		return new JQGridJSONModel(pagination, recordNum, arbintervs);
	}

	/**
	 * Method 'getComboIntervinientes'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "/comboIntervinientes", method = RequestMethod.GET)
	public @ResponseBody()
	Object getComboIntervinientes(HttpServletRequest request) throws Exception {

		ArbintervController.logger
				.info("[GET - find_ALL] : Obtener combo Intervinientes del Expediente");

		String excodigo = "";

		if (!"".equalsIgnoreCase((String) request.getParameter("uaexcodigo"))
				&& null != (String) request.getParameter("uaexcodigo")) {
			excodigo = (String) request.getParameter("uaexcodigo");

			Pagination pagination = new Pagination();

			pagination.setSort("uanombre");
			pagination.setAscDsc("ASC");

			Long total = new Long(0);

			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				JQGridJSONModel data = new JQGridJSONModel();

				Arbinterv interviniente = new Arbinterv();
				Solarb solarb = new Solarb();
				solarb.setSacodigo(excodigo);

				interviniente.setSolarb(solarb);
				List<Arbinterv> listIntervinientes = this.arbintervService
						.findAllCombo(interviniente, pagination);
				if (listIntervinientes == null) {
					throw new Exception("No data Found.");
				}
				total = this.arbintervService.findAllCount(interviniente);
				data.setRows(listIntervinientes);

				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());

				return data;
			} else {

				Arbinterv interviniente = new Arbinterv();
				Solarb solarb = new Solarb();
				solarb.setSacodigo(excodigo);

				interviniente.setSolarb(solarb);
				List<Arbinterv> listIntervinientes = this.arbintervService
						.findAllCombo(interviniente, pagination);
				if (listIntervinientes == null) {
					throw new Exception("No data Found.");
				}
				total = this.arbintervService.findAllCount(interviniente);

				return listIntervinientes;
			}
		} else {
			throw new Exception("No data Found. EXCODIGO IS NULL");
		}

	}

	/**
	 * Method 'getById'.
	 * 
	 * @param sacodigo
	 *            String
	 * @param tipo
	 *            String
	 * @return arbinterv Arbinterv
	 */
	@RequestMapping(value = "/dameInterviniente", method = RequestMethod.GET)
	public @ResponseBody()
	Arbinterv getById(
			@RequestParam(value = "sacodigo", required = true) String sacodigo,
			@RequestParam(value = "tipo", required = true) String tipo) {
		ArbintervController.logger
				.info("[GET - getById] : Inicio dameInterviniente");

		return this.arbintervService.dameInterviniente(sacodigo, tipo);
	}

	/**
	 * Method 'getIntervinienteEstablecimiento'.
	 * 
	 * @param idinterviniente
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/detalleEstablecimiento/{idinterviniente}", method = RequestMethod.GET)
	public @ResponseBody
	EstablecimientoDetalle getIntervinienteEstablecimiento(
			@PathVariable String idinterviniente, Model model) {
		try {
			Arbinterv arbinterv = new Arbinterv();
			String id = new String(Y41bUtilsDokusi.decode(idinterviniente));
			try {
				arbinterv.setUaidinterv(new BigDecimal(id));
			} catch (NumberFormatException e) {
				arbinterv.setUaescodigo(id);
			}
			EstablecimientoDetalle establecimientoDetalle = this.arbintervService
					.findEstablecimiento(arbinterv);
			if (establecimientoDetalle == null) {
				throw new Exception(id.toString());
			}
			return establecimientoDetalle;
		} catch (Exception e) {
			throw new ResourceNotFoundException(idinterviniente);
		}
	}

	/**
	 * Method 'getConsumidorById'.
	 * 
	 * @return ConsumidorDetalle
	 */
	@RequestMapping(value = "/detalleConsumidor/{idinterviniente}", method = RequestMethod.GET)
	public @ResponseBody()
	ConsumidorDetalle getConsumidorById(@PathVariable() String idinterviniente) {
		try {
			Arbinterv arbinterv = new Arbinterv();
			String id = new String(Y41bUtilsDokusi.decode(idinterviniente));
			try {
				arbinterv.setUaidinterv(new BigDecimal(id));
			} catch (NumberFormatException e) {
				arbinterv.setUadtcodigo(id);
			}

			ConsumidorDetalle consumidorDetalle = this.arbintervService
					.findConsumidor(arbinterv);
			if (consumidorDetalle == null) {
				throw new Exception(id.toString());
			}
			return consumidorDetalle;
		} catch (Exception e) {
			throw new ResourceNotFoundException(idinterviniente);
		}
	}

	/**
	 * Method 'getConsumidorById'.
	 * 
	 * @return ConsumidorDetalle
	 */
	@RequestMapping(value = "/actualizar/{idinterviniente}", method = RequestMethod.POST)
	public @ResponseBody()
	void actualizarInterviniente(@PathVariable() String idinterviniente) {
		try {
			Arbinterv arbinterv = new Arbinterv();
			arbinterv.setUaidinterv(new BigDecimal(idinterviniente));

			this.arbintervService.actualizarInterviniente(arbinterv);
		} catch (Exception e) {
			throw new ResourceNotFoundException(idinterviniente);
		}
	}
}
