package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.ArbdoctempService;
import com.ejie.y41b.service.ArbexpService;
import com.ejie.y41b.service.SolarbService;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.fichero.Y41bFicheroUtils;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Arbdoctemp;
import com.ejie.y41b.model.Arbexp;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteComun;

/**
 * ArbexpController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/arbexp")
public class ArbexpController {

	private static final Logger logger = LoggerFactory
			.getLogger(ArbexpController.class);

	@Autowired()
	private ArbexpService arbexpService;

	@Autowired()
	private SolarbService solarbService;

	@Autowired()
	private ArbdoctempService arbdoctempService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ArbexpController.logger.info("[GET - View] : arbexp");
		return "arbexp";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param excodigo
	 *            String
	 * @return arbexp Arbexp
	 */
	@RequestMapping(value = "/{excodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Arbexp getById(@PathVariable String excodigo) {
		Arbexp arbexp = new Arbexp();
		arbexp.setExcodigo(excodigo);
		arbexp = this.arbexpService.find(arbexp);
		ArbexpController.logger
				.info("[GET - findBy_PK] : Obtener Arbexp por PK");
		return arbexp;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterArbexp
	 *            Arbexp
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Arbexp> getAll(@ModelAttribute Arbexp filterArbexp) {
		ArbexpController.logger
				.info("[GET - find_ALL] : Obtener Arbexp por filtro");
		return this.arbexpService.findAll(filterArbexp, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @return Arbexp
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Arbexp edit(@RequestBody Arbexp arbexp) {
		Arbexp arbexpAux = this.arbexpService.update(arbexp);
		ArbexpController.logger
				.info("[PUT] : Arbexp actualizado correctamente");
		return arbexpAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @return Arbexp
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Arbexp add(@RequestBody Arbexp arbexp) {
		Arbexp arbexpAux = this.arbexpService.add(arbexp);
		ArbexpController.logger.info("[POST] : Arbexp insertado correctamente");
		return arbexpAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param excodigo
	 *            String
	 * @return arbexp
	 */
	@RequestMapping(value = "/{excodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Arbexp remove(@PathVariable String excodigo) {
		Arbexp arbexp = new Arbexp();
		arbexp.setExcodigo(excodigo);
		this.arbexpService.remove(arbexp);
		ArbexpController.logger.info("[DELETE] : Arbexp borrado correctamente");
		return arbexp;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param arbexpIds
	 *            List
	 * @return arbexpList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(@RequestBody List<List<String>> arbexpIds) {
		List<Arbexp> arbexpList = new ArrayList<Arbexp>();
		for (List<String> arbexpId : arbexpIds) {
			Iterator<String> iterator = arbexpId.iterator();
			Arbexp arbexp = new Arbexp(); // NOPMD - Objeto nuevo en la lista
											// (parametro del servicio)
			arbexp.setExcodigo(ObjectConversionManager.convert(iterator.next(),
					String.class));
			arbexpList.add(arbexp);
		}
		this.arbexpService.removeMultiple(arbexpList);
		ArbexpController.logger
				.info("[POST - DELETE_ALL] : Arbexp borrados correctamente");
		return arbexpIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterArbexp
	 *            Arbexp
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Arbexp filterArbexp,
			@ModelAttribute Pagination pagination) {
		List<Arbexp> arbexps = this.arbexpService.findAll(filterArbexp,
				pagination);
		Long recordNum = this.arbexpService.findAllCount(filterArbexp);
		ArbexpController.logger.info("[GET - jqGrid] : Obtener Arbexp");
		return new JQGridJSONModel(pagination, recordNum, arbexps);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param sacodigo
	 *            String
	 * @return arbexp Arbexp
	 */
	@RequestMapping(value = "/dameFaseUltimoTramite", method = RequestMethod.GET)
	public @ResponseBody()
	Arbexp getFaseYUltimoTramite(
			@RequestParam(value = "sacodigo", required = false) String sacodigo) {
		Arbexp arbexp = new Arbexp();
		try {
			arbexp.setExcodigo(sacodigo);
			arbexp = this.arbexpService.dameDetallesExpediente(arbexp);
			ArbexpController.logger
					.info("[GET - findBy_PK] : Obtener Sanexp por PK");
			return arbexp;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico" + e.getMessage(), true,
					e);
		}
	}

	/**
	 * Method 'getDocsByHdcodigo'.
	 * 
	 * @param sacodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/imprimirdocumentos", method = RequestMethod.GET)
	public @ResponseBody()
	void imprimirDocsByHdcodigo(
			@RequestParam(value = "sacodigo", required = true) String sacodigo,
			HttpServletResponse response) {
		try {
			ArbexpController.logger
					.info("ArbexpController - ImprimirDocsByHdcodigo: "
							+ sacodigo + ".");

			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdExpediente(sacodigo);

			Solarb solarb = this.solarbService.find(new Solarb(sacodigo));
			TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
			tipoProcedimiento.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
			tramiteComun.setTipoProcedimiento(tipoProcedimiento);

			List<DocumentoExpediente> documentosExpediente = this.arbdoctempService
					.findAllDocumentosExpediente(tramiteComun, null);
			ArbexpController.logger
					.info("ArbexpController - ImprimirDocsByHdcodigo: "
							+ (documentosExpediente == null) + ".");

			if (documentosExpediente == null
					|| documentosExpediente.size() == 0) {
				throw new Exception("No data Found.");
			} else {
				// CONSTRUIR ZIP
				InputStream ficheroStream = null;
				File fileFichero = null;

				Properties prop = Y41bConfig
						.loadProperties(Y41bConstantes.CONFIG_PATH);
				// Ej. /datos/y41b/tmp/zip/
				String strTmpZipDirectory = prop.getProperty("RUTA_TMP_ZIP");
				// Ej. /datos/y41b/tmp/zip/1383555971012_199906071034ESP10147

				String strZipDirectory = strTmpZipDirectory
						+ solarb.damecodCompleto();
				// Ej.
				// /datos/y41b/tmp/zip/1383555971012_199906071034ESP10147.zip
				String strZipFile = strZipDirectory
						+ Y41bConstantes.EXTENSION_ZIP;

				// 1. Validamos que exista el directorio TMP para los ZIP. Si no
				// existe, lo creo
				Y41bFicheroUtils.crearDirectorio(strTmpZipDirectory);
				// 2. Validamos que exista el directorio TMP para el ZIP actual.
				// Si
				// no existe, lo creo
				Y41bFicheroUtils.crearDirectorio(strZipDirectory);
				// 3. Creamos el ZIP
				Y41bFicheroUtils.crearFichero(new File(strZipFile));

				// ******* Borramos historico de ficheros con mas de 1 minuto
				// (60000ms) de
				// diferencia en la fecha de creacion
				Y41bFicheroUtils.deleteFilesFromDate(new File(
						strTmpZipDirectory), Y41bConstantes.NUM_60000);

				// **************************************************************
				String nombreFichero = null;
				int numDoc = 1;
				// 4. Recorremos la lista de documentos a zipear y los dejamos
				// en el directorio TMP para el ZIP actual

				ArbexpController.logger
						.info("ArbexpController - ImprimirDocsByHdcodigo: "
								+ (documentosExpediente.size()) + ".");
				Arbdoctemp documentoHechoDetalle = new Arbdoctemp();
				for (DocumentoExpediente documento : documentosExpediente) {

					documentoHechoDetalle.setX5codocumento(documento
							.getCodocumento());

					ArbexpController.logger
							.info("ArbexpController - ImprimirDocsByHdcodigo: DOC:"
									+ documento.getCodocumento() + ".");

					Arbdoctemp documentoHechoDetalleAux = this.arbdoctempService
							.find(documentoHechoDetalle);
					// FIN ::::: BORRAMOS TABLA TEMPORAL

					nombreFichero = documentoHechoDetalleAux.getX5nofile();
					ficheroStream = documentoHechoDetalleAux.getX5datafile()
							.getBinaryStream();

					String local = (String) prop
							.getProperty("y41bVistaWar.entorno.local");
					if ("true".equals(local)) {
						fileFichero = this.crearFichero(strZipDirectory + "\\"
								+ numDoc + "." + nombreFichero);
					} else {
						fileFichero = this.crearFichero(strZipDirectory + "/"
								+ numDoc + "." + nombreFichero);
					}

					Y41bFicheroUtils
							.escribirFichero(ficheroStream, fileFichero);
					ficheroStream.close();
					numDoc++;
				}

				Y41bFicheroUtils.comprimirFichero(new File(strZipDirectory),
						strZipFile);
				// ***********************************************************************

				// PARA DESCARGALO
				File ficheroZip = new File(strZipFile);
				byte[] bFile = new byte[(int) ficheroZip.length()];

				FileInputStream fileInputStream = new FileInputStream(
						ficheroZip);
				fileInputStream.read(bFile);
				fileInputStream.close();

				response.setHeader("Content-Disposition",
						"attachment; filename=\"" + solarb.damecodCompleto()
								+ Y41bConstantes.EXTENSION_ZIP + "\"");
				response.setContentType("application/zip");
				response.setContentLength(bFile.length);
				response.getOutputStream().write(bFile);

				// Vaciamos el stream
				response.getOutputStream().flush();
			}

		} catch (Exception e) {
			throw new Y41bUDAException("No hay ficheros para esta solicitud",
					false, e);
		}
	}

	/**
	 * 
	 * @param path
	 *            String
	 * @return File
	 */
	private File crearFichero(String path) {
		return new File(path);
	}
}
